/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.resolve.internal;

import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.artifact.resolve.internal.Invoker;
import org.apache.maven.shared.artifact.resolve.internal.Maven31ArtifactResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

@Component(role=ArtifactResolver.class, hint="maven31")
public class Maven31ArtifactResolver
implements ArtifactResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, org.apache.maven.artifact.Artifact mavenArtifact) throws ArtifactResolverException {
        Artifact aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
        return this.resolveArtifact(buildingRequest, aetherArtifact);
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) throws ArtifactResolverException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return this.resolveArtifact(buildingRequest, aetherArtifact);
    }

    private ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, Artifact aetherArtifact) throws ArtifactResolverException {
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        try {
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest(aetherArtifact, aetherRepositories, null);
            ArtifactDescriptorResult descriptorResult = this.repositorySystem.readArtifactDescriptor(session, descriptorRequest);
            ArtifactRequest request = new ArtifactRequest(descriptorResult.getArtifact(), aetherRepositories, null);
            return new Maven31ArtifactResult(this.repositorySystem.resolveArtifact(session, request));
        }
        catch (ArtifactDescriptorException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
    }
}

