/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.processfiles;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.processfiles.Messages;
import org.pentaho.di.trans.steps.processfiles.ProcessFiles;
import org.pentaho.di.trans.steps.processfiles.ProcessFilesData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFilesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private boolean addresultfilenames;
    private boolean overwritetargetfile;
    private boolean createparentfolder;
    public boolean simulate;
    private String sourcefilenamefield;
    private String targetfilenamefield;
    private int operationType;
    public static final String[] operationTypeDesc = new String[]{Messages.getString("ProcessFilesMeta.operationType.Copy"), Messages.getString("ProcessFilesMeta.operationType.Move"), Messages.getString("ProcessFilesMeta.operationType.Delete")};
    public static final String[] operationTypeCode = new String[]{"copy", "move", "delete"};
    public static final int OPERATION_TYPE_COPY = 0;
    public static final int OPERATION_TYPE_MOVE = 1;
    public static final int OPERATION_TYPE_DELETE = 2;

    public int getOperationType() {
        return this.operationType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ProcessFilesMeta.getOperationTypeByCode(tt);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    public String getDynamicSourceFileNameField() {
        return this.sourcefilenamefield;
    }

    public void setDynamicSourceFileNameField(String sourcefilenamefield) {
        this.sourcefilenamefield = sourcefilenamefield;
    }

    public String getDynamicTargetFileNameField() {
        return this.targetfilenamefield;
    }

    public void setDynamicTargetFileNameField(String targetfilenamefield) {
        this.targetfilenamefield = targetfilenamefield;
    }

    public boolean isaddTargetFileNametoResult() {
        return this.addresultfilenames;
    }

    public boolean isOverwriteTargetFile() {
        return this.overwritetargetfile;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setaddTargetFileNametoResult(boolean addresultfilenames) {
        this.addresultfilenames = addresultfilenames;
    }

    public void setOverwriteTargetFile(boolean overwritetargetfile) {
        this.overwritetargetfile = overwritetargetfile;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ProcessFilesMeta retval = (ProcessFilesMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.addresultfilenames = false;
        this.overwritetargetfile = false;
        this.createparentfolder = false;
        this.simulate = true;
        this.operationType = 0;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"sourcefilenamefield", (String)this.sourcefilenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"targetfilenamefield", (String)this.targetfilenamefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"operation_type", (String)ProcessFilesMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addresultfilenames", (boolean)this.addresultfilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"overwritetargetfile", (boolean)this.overwritetargetfile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"createparentfolder", (boolean)this.createparentfolder));
        retval.append("    ").append(XMLHandler.addTagValue((String)"simulate", (boolean)this.simulate));
        return retval.toString();
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.sourcefilenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"sourcefilenamefield");
            this.targetfilenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"targetfilenamefield");
            this.operationType = ProcessFilesMeta.getOperationTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"operation_type"), (String)""));
            this.addresultfilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addresultfilenames"));
            this.overwritetargetfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"overwritetargetfile"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"createparentfolder"));
            this.simulate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"simulate"));
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("ProcessFilesMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.sourcefilenamefield = rep.getStepAttributeString(id_step, "sourcefilenamefield");
            this.targetfilenamefield = rep.getStepAttributeString(id_step, "targetfilenamefield");
            this.operationType = ProcessFilesMeta.getOperationTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "operation_type"), (String)""));
            this.addresultfilenames = rep.getStepAttributeBoolean(id_step, "addresultfilenames");
            this.overwritetargetfile = rep.getStepAttributeBoolean(id_step, "overwritetargetfile");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "createparentfolder");
            this.simulate = rep.getStepAttributeBoolean(id_step, "simulate");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ProcessFilesMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "sourcefilenamefield", this.sourcefilenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "targetfilenamefield", this.targetfilenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "operation_type", ProcessFilesMeta.getOperationTypeCode(this.operationType));
            rep.saveStepAttribute(id_transformation, id_step, "addresultfilenames", this.addresultfilenames);
            rep.saveStepAttribute(id_transformation, id_step, "overwritetargetfile", this.overwritetargetfile);
            rep.saveStepAttribute(id_transformation, id_step, "createparentfolder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "simulate", this.simulate);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ProcessFilesMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.sourcefilenamefield)) {
            error_message = Messages.getString("ProcessFilesMeta.CheckResult.SourceFileFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("ProcessFilesMeta.CheckResult.TargetFileFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.operationType != 2 && Const.isEmpty((String)this.targetfilenamefield)) {
            error_message = Messages.getString("ProcessFilesMeta.CheckResult.TargetFileFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("ProcessFilesMeta.CheckResult.SourceFileFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("ProcessFilesMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("ProcessFilesMeta.CheckResult.NoInpuReceived"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ProcessFiles(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ProcessFilesData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

