# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 12.1.0.  Any changes made here will be lost!

sub TODO_FAILING_BREAKS { 0 }

use strict;
use warnings;
no warnings 'experimental::uniprop_wildcards';

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

# loc_tools.pl requires this function to be defined
sub ok($@) {
    my ($pass, @msg) = @_;
    print "not " unless $pass;
    print "ok ";
    print ++$Tests;
    print " - ", join "", @msg if @msg;
    print "\n";
}

sub Expect($$$$) {
    my $expected = shift;
    my $ord = shift;
    my $regex  = shift;
    my $warning_type = shift;   # Type of warning message, like 'deprecated'
                                # or empty if none
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parentheses in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($) {
    my $regex  = shift;
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

my $are_ctype_locales_available;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
if (defined &locales_enabled) {
    $are_ctype_locales_available = locales_enabled('LC_CTYPE');
    if ($are_ctype_locales_available) {
        $utf8_locale = &find_utf8_ctype_locale;
    }
}

# Eval'd so can run on versions earlier than the property is available in
my $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}\p{WB=ZWJ}]/';
if (! defined $WB_Extend_or_Format_re) {
    $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}]/';
}

sub _test_break($$) {
    # Test various break property matches.  The 2nd parameter gives the
    # property name.  The input is a line from auxiliary/*Test.txt for the
    # given property.  Each such line is a sequence of Unicode (not native)
    # code points given by their hex numbers, separated by the two characters
    # defined just before this subroutine that indicate that either there can
    # or cannot be a break between the adjacent code points.  All these are
    # tested.
    #
    # For the gcb property extra tests are made.  if there isn't a break, that
    # means the sequence forms an extended grapheme cluster, which means that
    # \X should match the whole thing.  If there is a break, \X should stop
    # there.  This is all converted by this routine into a match: $string =~
    # /(\X)/, Each \X should match the next cluster; and that is what is
    # checked.

    my $template = shift;
    my $break_type = shift;

    my $line   = (caller 1)[2];   # Line number
    my $comment = "";

    if ($template =~ / ( .*? ) \s* \# (.*) /x) {
        $template = $1;
        $comment = $2;

        # Replace leading spaces with a single one.
        $comment =~ s/ ^ \s* / # /x;
    }

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Perl customizes wb.  So change the official tests accordingly
    if ($break_type eq 'wb' && $WB_Extend_or_Format_re) {

        # Split into elements that alternate between code point and
        # break/no-break
        my @line = split / +/, $template;

        # Look at each code point and its following one
        for (my $i = 1; $i <  @line - 1 - 1; $i+=2) {

            # The customization only involves changing some breaks to
            # non-breaks.
            next if $line[$i+1] =~ /$nobreak/;

            my $lhs = chr utf8::unicode_to_native(hex $line[$i]);
            my $rhs = chr utf8::unicode_to_native(hex $line[$i+2]);

            # And it only affects adjacent space characters.
            next if $lhs !~ /\s/u;

            # But, we want to make sure to test spaces followed by a Extend
            # or Format.
            next if $rhs !~ /\s|$WB_Extend_or_Format_re/;

            # To test the customization, add some white-space before this to
            # create a span.  The $lhs white space may or may not be bound to
            # that span, and also with the $rhs.  If the $rhs is a binding
            # character, the $lhs is bound to it and not to the span, unless
            # $lhs is vertical space.  In all other cases, the $lhs is bound
            # to the span.  If the $rhs is white space, it is bound to the
            # $lhs
            my $bound;
            my $span;
            if ($rhs =~ /$WB_Extend_or_Format_re/) {
                if ($lhs =~ /\v/) {
                    $bound = $breakable;
                    $span = $nobreak;
                }
                else {
                    $bound = $nobreak;
                    $span = $breakable;
                }
            }
            else {
                $span = $nobreak;
                $bound = $nobreak;
            }

            splice @line, $i, 0, ( '0020', $nobreak, '0020', $span);
            $i += 4;
            $line[$i+1] = $bound;
        }
        $template = join " ", @line;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        my @modifiers = qw(a aa d u i);
        if ($are_ctype_locales_available) {
            push @modifiers, "l$utf8_locale" if defined $utf8_locale;

            # The /l modifier has C after it to indicate the locale to try
            push @modifiers, "lC";
        }

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                POSIX::setlocale(&POSIX::LC_CTYPE, $locale);
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched_text;
            my $matched = $string =~ qr/$pattern/;
            if ($matched) {
                $matched_text = "matched";
            }
            else {
                $matched_text = "failed to match";
                print "not ";

                if (TODO_FAILING_BREAKS) {
                    $comment = " # $comment" unless $comment =~ / ^ \s* \# /x;
                    $comment =~ s/#/# TODO/;
                }
            }
            print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$pattern/$display_upgrade; line $line $display_locale$comment\n";

            # Only print the comment on the first use of this line
            $comment = "";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                $matched_text = ($matched) ? "matched" : "failed to match";
                print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$B_pattern/$display_upgrade; line $line $display_locale";
                print " # TODO" if TODO_FAILING_BREAKS && ! $matched;
                print "\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", ord $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests -";
                print " # TODO" if TODO_FAILING_BREAKS;
                print " In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line";
            print " # TODO" if TODO_FAILING_BREAKS;
            print "\n";
        }
    }

    return;
}

sub Test_GCB($) {
    _test_break(shift, 'gcb');
}

sub Test_LB($) {
    _test_break(shift, 'lb');
}

sub Test_SB($) {
    _test_break(shift, 'sb');
}

sub Test_WB($) {
    _test_break(shift, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

if (!$::TESTCHUNK or $::TESTCHUNK == 1) {
    Error('\p{Script=InGreek}');    # Bug #69018
    Test_GCB("1100 $nobreak 1161");  # Bug #70940
    Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
    Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
    Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
    
    # Make sure this gets tested; it was not part of the official test suite at
    # the time this was added.  Note that this is as it would appear in the
    # official suite, and gets modified to check for the perl tailoring by
    # Test_WB()
    Test_WB("$breakable 0020 $breakable 0020 $breakable 0308 $breakable");
    Test_LB("$nobreak 200B $nobreak 0020 $nobreak 0020 $breakable 2060 $breakable");
    Error('\p{_perllb}');
    Error('\P{_perllb}');
    Error('\p{_perlscx}');
    Error('\P{_perlscx}');
    Error('\p{age}');
    Error('\P{age}');
    Error('\p{Age=_V1_1/a/}');
    Error('\P{Age=_V1_1/a/}');
    Expect(1, 65533, '\p{Age=:\AV1_1\z:}', "");;
    Expect(0, 65536, '\p{Age=:\AV1_1\z:}', "");;
    Expect(1, 65533, '\p{Age=v11}', "");
    Expect(0, 65533, '\p{^Age=v11}', "");
    Expect(0, 65533, '\P{Age=v11}', "");
    Expect(1, 65533, '\P{^Age=v11}', "");
    Expect(0, 65536, '\p{Age=v11}', "");
    Expect(1, 65536, '\p{^Age=v11}', "");
    Expect(1, 65536, '\P{Age=v11}', "");
    Expect(0, 65536, '\P{^Age=v11}', "");
    Expect(1, 65533, '\p{Age=:\Av11\z:}', "");;
    Expect(0, 65536, '\p{Age=:\Av11\z:}', "");;
    Expect(1, 65533, '\p{Age=	v1_1}', "");
    Expect(0, 65533, '\p{^Age=	v1_1}', "");
    Expect(0, 65533, '\P{Age=	v1_1}', "");
    Expect(1, 65533, '\P{^Age=	v1_1}', "");
    Expect(0, 65536, '\p{Age=	v1_1}', "");
    Expect(1, 65536, '\p{^Age=	v1_1}', "");
    Expect(1, 65536, '\P{Age=	v1_1}', "");
    Expect(0, 65536, '\P{^Age=	v1_1}', "");
    Error('\p{Is_Age=:=	 000000001.1}');
    Error('\P{Is_Age=:=	 000000001.1}');
    Expect(1, 65533, '\p{Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\p{^Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\P{Is_Age=+0_1.1}', "");
    Expect(1, 65533, '\P{^Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\p{Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\p{^Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\P{Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\P{^Is_Age=+0_1.1}', "");
    Error('\p{Age=		v10_0:=}');
    Error('\P{Age=		v10_0:=}');
    Expect(1, 191456, '\p{Age=:\AV10_0\z:}', "");;
    Expect(0, 191457, '\p{Age=:\AV10_0\z:}', "");;
    Expect(1, 191456, '\p{Age=v100}', "");
    Expect(0, 191456, '\p{^Age=v100}', "");
    Expect(0, 191456, '\P{Age=v100}', "");
    Expect(1, 191456, '\P{^Age=v100}', "");
    Expect(0, 191457, '\p{Age=v100}', "");
    Expect(1, 191457, '\p{^Age=v100}', "");
    Expect(1, 191457, '\P{Age=v100}', "");
    Expect(0, 191457, '\P{^Age=v100}', "");
    Expect(1, 191456, '\p{Age=:\Av100\z:}', "");;
    Expect(0, 191457, '\p{Age=:\Av100\z:}', "");;
    Expect(1, 191456, '\p{Age=	-V10_0}', "");
    Expect(0, 191456, '\p{^Age=	-V10_0}', "");
    Expect(0, 191456, '\P{Age=	-V10_0}', "");
    Expect(1, 191456, '\P{^Age=	-V10_0}', "");
    Expect(0, 191457, '\p{Age=	-V10_0}', "");
    Expect(1, 191457, '\p{^Age=	-V10_0}', "");
    Expect(1, 191457, '\P{Age=	-V10_0}', "");
    Expect(0, 191457, '\P{^Age=	-V10_0}', "");
    Error('\p{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Error('\P{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Expect(1, 191456, '\p{Is_Age=0000010.0}', "");
    Expect(0, 191456, '\p{^Is_Age=0000010.0}', "");
    Expect(0, 191456, '\P{Is_Age=0000010.0}', "");
    Expect(1, 191456, '\P{^Is_Age=0000010.0}', "");
    Expect(0, 191457, '\p{Is_Age=0000010.0}', "");
    Expect(1, 191457, '\p{^Is_Age=0000010.0}', "");
    Expect(1, 191457, '\P{Is_Age=0000010.0}', "");
    Expect(0, 191457, '\P{^Is_Age=0000010.0}', "");
    Error('\p{Age=/a/V11_0}');
    Error('\P{Age=/a/V11_0}');
    Expect(1, 129645, '\p{Age=:\AV11_0\z:}', "");;
    Expect(0, 129646, '\p{Age=:\AV11_0\z:}', "");;
    Expect(1, 129645, '\p{Age=v110}', "");
    Expect(0, 129645, '\p{^Age=v110}', "");
    Expect(0, 129645, '\P{Age=v110}', "");
    Expect(1, 129645, '\P{^Age=v110}', "");
    Expect(0, 129646, '\p{Age=v110}', "");
    Expect(1, 129646, '\p{^Age=v110}', "");
    Expect(1, 129646, '\P{Age=v110}', "");
    Expect(0, 129646, '\P{^Age=v110}', "");
    Expect(1, 129645, '\p{Age=:\Av110\z:}', "");;
    Expect(0, 129646, '\p{Age=:\Av110\z:}', "");;
    Expect(1, 129645, '\p{Age= _V11_0}', "");
    Expect(0, 129645, '\p{^Age= _V11_0}', "");
    Expect(0, 129645, '\P{Age= _V11_0}', "");
    Expect(1, 129645, '\P{^Age= _V11_0}', "");
    Expect(0, 129646, '\p{Age= _V11_0}', "");
    Expect(1, 129646, '\p{^Age= _V11_0}', "");
    Expect(1, 129646, '\P{Age= _V11_0}', "");
    Expect(0, 129646, '\P{^Age= _V11_0}', "");
    Error('\p{Is_Age=_ +0000011.0:=}');
    Error('\P{Is_Age=_ +0000011.0:=}');
    Expect(1, 129645, '\p{Is_Age=1_1.0}', "");
    Expect(0, 129645, '\p{^Is_Age=1_1.0}', "");
    Expect(0, 129645, '\P{Is_Age=1_1.0}', "");
    Expect(1, 129645, '\P{^Is_Age=1_1.0}', "");
    Expect(0, 129646, '\p{Is_Age=1_1.0}', "");
    Expect(1, 129646, '\p{^Is_Age=1_1.0}', "");
    Expect(1, 129646, '\P{Is_Age=1_1.0}', "");
    Expect(0, 129646, '\P{^Is_Age=1_1.0}', "");
    Error('\p{Age= V12_0:=}');
    Error('\P{Age= V12_0:=}');
    Expect(1, 129685, '\p{Age=:\AV12_0\z:}', "");;
    Expect(0, 129686, '\p{Age=:\AV12_0\z:}', "");;
    Expect(1, 129685, '\p{Age=v120}', "");
    Expect(0, 129685, '\p{^Age=v120}', "");
    Expect(0, 129685, '\P{Age=v120}', "");
    Expect(1, 129685, '\P{^Age=v120}', "");
    Expect(0, 129686, '\p{Age=v120}', "");
    Expect(1, 129686, '\p{^Age=v120}', "");
    Expect(1, 129686, '\P{Age=v120}', "");
    Expect(0, 129686, '\P{^Age=v120}', "");
    Expect(1, 129685, '\p{Age=:\Av120\z:}', "");;
    Expect(0, 129686, '\p{Age=:\Av120\z:}', "");;
    Expect(1, 129685, '\p{Age= _V12_0}', "");
    Expect(0, 129685, '\p{^Age= _V12_0}', "");
    Expect(0, 129685, '\P{Age= _V12_0}', "");
    Expect(1, 129685, '\P{^Age= _V12_0}', "");
    Expect(0, 129686, '\p{Age= _V12_0}', "");
    Expect(1, 129686, '\p{^Age= _V12_0}', "");
    Expect(1, 129686, '\P{Age= _V12_0}', "");
    Expect(0, 129686, '\P{^Age= _V12_0}', "");
    Error('\p{Is_Age=/a/		0000000012.0}');
    Error('\P{Is_Age=/a/		0000000012.0}');
    Expect(1, 129685, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129685, '\P{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\P{^Is_Age=00_00_01_2.0}', "");
    Error('\p{Age=_V12_1/a/}');
    Error('\P{Age=_V12_1/a/}');
    Expect(1, 13055, '\p{Age=:\AV12_1\z:}', "");;
    Expect(0, 13056, '\p{Age=:\AV12_1\z:}', "");;
    Expect(1, 13055, '\p{Age=v121}', "");
    Expect(0, 13055, '\p{^Age=v121}', "");
    Expect(0, 13055, '\P{Age=v121}', "");
    Expect(1, 13055, '\P{^Age=v121}', "");
    Expect(0, 13056, '\p{Age=v121}', "");
    Expect(1, 13056, '\p{^Age=v121}', "");
    Expect(1, 13056, '\P{Age=v121}', "");
    Expect(0, 13056, '\P{^Age=v121}', "");
    Expect(1, 13055, '\p{Age=:\Av121\z:}', "");;
    Expect(0, 13056, '\p{Age=:\Av121\z:}', "");;
    Expect(1, 13055, '\p{Age= 	V12_1}', "");
    Expect(0, 13055, '\p{^Age= 	V12_1}', "");
    Expect(0, 13055, '\P{Age= 	V12_1}', "");
    Expect(1, 13055, '\P{^Age= 	V12_1}', "");
    Expect(0, 13056, '\p{Age= 	V12_1}', "");
    Expect(1, 13056, '\p{^Age= 	V12_1}', "");
    Expect(1, 13056, '\P{Age= 	V12_1}', "");
    Expect(0, 13056, '\P{^Age= 	V12_1}', "");
    Error('\p{Is_Age=:=-+012.1}');
    Error('\P{Is_Age=:=-+012.1}');
    Expect(1, 13055, '\p{Is_Age=000000012.1}', "");
    Expect(0, 13055, '\p{^Is_Age=000000012.1}', "");
    Expect(0, 13055, '\P{Is_Age=000000012.1}', "");
    Expect(1, 13055, '\P{^Is_Age=000000012.1}', "");
    Expect(0, 13056, '\p{Is_Age=000000012.1}', "");
    Expect(1, 13056, '\p{^Is_Age=000000012.1}', "");
    Expect(1, 13056, '\P{Is_Age=000000012.1}', "");
    Expect(0, 13056, '\P{^Is_Age=000000012.1}', "");
    Error('\p{Age=--V2_0/a/}');
    Error('\P{Age=--V2_0/a/}');
    Expect(1, 983040, '\p{Age=:\AV2_0\z:}', "");;
    Expect(0, 983037, '\p{Age=:\AV2_0\z:}', "");;
    Expect(1, 983040, '\p{Age=v20}', "");
    Expect(0, 983040, '\p{^Age=v20}', "");
    Expect(0, 983040, '\P{Age=v20}', "");
    Expect(1, 983040, '\P{^Age=v20}', "");
    Expect(0, 983037, '\p{Age=v20}', "");
    Expect(1, 983037, '\p{^Age=v20}', "");
    Expect(1, 983037, '\P{Age=v20}', "");
    Expect(0, 983037, '\P{^Age=v20}', "");
    Expect(1, 983040, '\p{Age=:\Av20\z:}', "");;
    Expect(0, 983037, '\p{Age=:\Av20\z:}', "");;
    Expect(1, 983040, '\p{Age= V2_0}', "");
    Expect(0, 983040, '\p{^Age= V2_0}', "");
    Expect(0, 983040, '\P{Age= V2_0}', "");
    Expect(1, 983040, '\P{^Age= V2_0}', "");
    Expect(0, 983037, '\p{Age= V2_0}', "");
    Expect(1, 983037, '\p{^Age= V2_0}', "");
    Expect(1, 983037, '\P{Age= V2_0}', "");
    Expect(0, 983037, '\P{^Age= V2_0}', "");
    Error('\p{Is_Age=	0_2.0/a/}');
    Error('\P{Is_Age=	0_2.0/a/}');
    Expect(1, 983040, '\p{Is_Age=+0000002.0}', "");
    Expect(0, 983040, '\p{^Is_Age=+0000002.0}', "");
    Expect(0, 983040, '\P{Is_Age=+0000002.0}', "");
    Expect(1, 983040, '\P{^Is_Age=+0000002.0}', "");
    Expect(0, 983037, '\p{Is_Age=+0000002.0}', "");
    Expect(1, 983037, '\p{^Is_Age=+0000002.0}', "");
    Expect(1, 983037, '\P{Is_Age=+0000002.0}', "");
    Expect(0, 983037, '\P{^Is_Age=+0000002.0}', "");
    Error('\p{Age=	V2_1/a/}');
    Error('\P{Age=	V2_1/a/}');
    Expect(1, 65532, '\p{Age=:\AV2_1\z:}', "");;
    Expect(0, 65533, '\p{Age=:\AV2_1\z:}', "");;
    Expect(1, 65532, '\p{Age=v21}', "");
    Expect(0, 65532, '\p{^Age=v21}', "");
    Expect(0, 65532, '\P{Age=v21}', "");
    Expect(1, 65532, '\P{^Age=v21}', "");
    Expect(0, 65533, '\p{Age=v21}', "");
    Expect(1, 65533, '\p{^Age=v21}', "");
    Expect(1, 65533, '\P{Age=v21}', "");
    Expect(0, 65533, '\P{^Age=v21}', "");
    Expect(1, 65532, '\p{Age=:\Av21\z:}', "");;
    Expect(0, 65533, '\p{Age=:\Av21\z:}', "");;
    Expect(1, 65532, '\p{Age=  V2_1}', "");
    Expect(0, 65532, '\p{^Age=  V2_1}', "");
    Expect(0, 65532, '\P{Age=  V2_1}', "");
    Expect(1, 65532, '\P{^Age=  V2_1}', "");
    Expect(0, 65533, '\p{Age=  V2_1}', "");
    Expect(1, 65533, '\p{^Age=  V2_1}', "");
    Expect(1, 65533, '\P{Age=  V2_1}', "");
    Expect(0, 65533, '\P{^Age=  V2_1}', "");
    Error('\p{Is_Age=:=	-+0000002.1}');
    Error('\P{Is_Age=:=	-+0000002.1}');
    Expect(1, 65532, '\p{Is_Age=00_00_00_2.1}', "");
    Expect(0, 65532, '\p{^Is_Age=00_00_00_2.1}', "");
    Expect(0, 65532, '\P{Is_Age=00_00_00_2.1}', "");
    Expect(1, 65532, '\P{^Is_Age=00_00_00_2.1}', "");
    Expect(0, 65533, '\p{Is_Age=00_00_00_2.1}', "");
    Expect(1, 65533, '\p{^Is_Age=00_00_00_2.1}', "");
    Expect(1, 65533, '\P{Is_Age=00_00_00_2.1}', "");
    Expect(0, 65533, '\P{^Is_Age=00_00_00_2.1}', "");
    Error('\p{Age= :=V3_0}');
    Error('\P{Age= :=V3_0}');
    Expect(1, 65531, '\p{Age=:\AV3_0\z:}', "");;
    Expect(0, 65532, '\p{Age=:\AV3_0\z:}', "");;
    Expect(1, 65531, '\p{Age=v30}', "");
    Expect(0, 65531, '\p{^Age=v30}', "");
    Expect(0, 65531, '\P{Age=v30}', "");
    Expect(1, 65531, '\P{^Age=v30}', "");
    Expect(0, 65532, '\p{Age=v30}', "");
    Expect(1, 65532, '\p{^Age=v30}', "");
    Expect(1, 65532, '\P{Age=v30}', "");
    Expect(0, 65532, '\P{^Age=v30}', "");
    Expect(1, 65531, '\p{Age=:\Av30\z:}', "");;
    Expect(0, 65532, '\p{Age=:\Av30\z:}', "");;
    Expect(1, 65531, '\p{Age=V3_0}', "");
    Expect(0, 65531, '\p{^Age=V3_0}', "");
    Expect(0, 65531, '\P{Age=V3_0}', "");
    Expect(1, 65531, '\P{^Age=V3_0}', "");
    Expect(0, 65532, '\p{Age=V3_0}', "");
    Expect(1, 65532, '\p{^Age=V3_0}', "");
    Expect(1, 65532, '\P{Age=V3_0}', "");
    Expect(0, 65532, '\P{^Age=V3_0}', "");
    Error('\p{Is_Age=/a/ -+0000003.0}');
    Error('\P{Is_Age=/a/ -+0000003.0}');
    Expect(1, 65531, '\p{Is_Age=3.0}', "");
    Expect(0, 65531, '\p{^Is_Age=3.0}', "");
    Expect(0, 65531, '\P{Is_Age=3.0}', "");
    Expect(1, 65531, '\P{^Is_Age=3.0}', "");
    Expect(0, 65532, '\p{Is_Age=3.0}', "");
    Expect(1, 65532, '\p{^Is_Age=3.0}', "");
    Expect(1, 65532, '\P{Is_Age=3.0}', "");
    Expect(0, 65532, '\P{^Is_Age=3.0}', "");
    Error('\p{Age: := _V3_1}');
    Error('\P{Age: := _V3_1}');
    Expect(1, 917631, '\p{Age=:\AV3_1\z:}', "");;
    Expect(0, 917632, '\p{Age=:\AV3_1\z:}', "");;
    Expect(1, 917631, '\p{Age=v31}', "");
    Expect(0, 917631, '\p{^Age=v31}', "");
    Expect(0, 917631, '\P{Age=v31}', "");
    Expect(1, 917631, '\P{^Age=v31}', "");
    Expect(0, 917632, '\p{Age=v31}', "");
    Expect(1, 917632, '\p{^Age=v31}', "");
    Expect(1, 917632, '\P{Age=v31}', "");
    Expect(0, 917632, '\P{^Age=v31}', "");
    Expect(1, 917631, '\p{Age=:\Av31\z:}', "");;
    Expect(0, 917632, '\p{Age=:\Av31\z:}', "");;
    Expect(1, 917631, '\p{Age=	_V3_1}', "");
    Expect(0, 917631, '\p{^Age=	_V3_1}', "");
    Expect(0, 917631, '\P{Age=	_V3_1}', "");
    Expect(1, 917631, '\P{^Age=	_V3_1}', "");
    Expect(0, 917632, '\p{Age=	_V3_1}', "");
    Expect(1, 917632, '\p{^Age=	_V3_1}', "");
    Expect(1, 917632, '\P{Age=	_V3_1}', "");
    Expect(0, 917632, '\P{^Age=	_V3_1}', "");
    Error('\p{Is_Age=:=  003.1}');
    Error('\P{Is_Age=:=  003.1}');
    Expect(1, 917631, '\p{Is_Age=+003.1}', "");
    Expect(0, 917631, '\p{^Is_Age=+003.1}', "");
    Expect(0, 917631, '\P{Is_Age=+003.1}', "");
    Expect(1, 917631, '\P{^Is_Age=+003.1}', "");
    Expect(0, 917632, '\p{Is_Age=+003.1}', "");
    Expect(1, 917632, '\p{^Is_Age=+003.1}', "");
    Expect(1, 917632, '\P{Is_Age=+003.1}', "");
    Expect(0, 917632, '\P{^Is_Age=+003.1}', "");
    Error('\p{Age=-/a/v3_2}');
    Error('\P{Age=-/a/v3_2}');
    Expect(1, 65376, '\p{Age=:\AV3_2\z:}', "");;
    Expect(0, 65377, '\p{Age=:\AV3_2\z:}', "");;
    Expect(1, 65376, '\p{Age=v32}', "");
    Expect(0, 65376, '\p{^Age=v32}', "");
    Expect(0, 65376, '\P{Age=v32}', "");
    Expect(1, 65376, '\P{^Age=v32}', "");
    Expect(0, 65377, '\p{Age=v32}', "");
    Expect(1, 65377, '\p{^Age=v32}', "");
    Expect(1, 65377, '\P{Age=v32}', "");
    Expect(0, 65377, '\P{^Age=v32}', "");
    Expect(1, 65376, '\p{Age=:\Av32\z:}', "");;
    Expect(0, 65377, '\p{Age=:\Av32\z:}', "");;
    Expect(1, 65376, '\p{Age=	V3_2}', "");
    Expect(0, 65376, '\p{^Age=	V3_2}', "");
    Expect(0, 65376, '\P{Age=	V3_2}', "");
    Expect(1, 65376, '\P{^Age=	V3_2}', "");
    Expect(0, 65377, '\p{Age=	V3_2}', "");
    Expect(1, 65377, '\p{^Age=	V3_2}', "");
    Expect(1, 65377, '\P{Age=	V3_2}', "");
    Expect(0, 65377, '\P{^Age=	V3_2}', "");
    Error('\p{Is_Age=:= 3.2}');
    Error('\P{Is_Age=:= 3.2}');
    Expect(1, 65376, '\p{Is_Age=3.2}', "");
    Expect(0, 65376, '\p{^Is_Age=3.2}', "");
    Expect(0, 65376, '\P{Is_Age=3.2}', "");
    Expect(1, 65376, '\P{^Is_Age=3.2}', "");
    Expect(0, 65377, '\p{Is_Age=3.2}', "");
    Expect(1, 65377, '\p{^Is_Age=3.2}', "");
    Expect(1, 65377, '\P{Is_Age=3.2}', "");
    Expect(0, 65377, '\P{^Is_Age=3.2}', "");
    Error('\p{Age=-/a/V4_0}');
    Error('\P{Age=-/a/V4_0}');
    Expect(1, 917999, '\p{Age=:\AV4_0\z:}', "");;
    Expect(0, 918000, '\p{Age=:\AV4_0\z:}', "");;
    Expect(1, 917999, '\p{Age=v40}', "");
    Expect(0, 917999, '\p{^Age=v40}', "");
    Expect(0, 917999, '\P{Age=v40}', "");
    Expect(1, 917999, '\P{^Age=v40}', "");
    Expect(0, 918000, '\p{Age=v40}', "");
    Expect(1, 918000, '\p{^Age=v40}', "");
    Expect(1, 918000, '\P{Age=v40}', "");
    Expect(0, 918000, '\P{^Age=v40}', "");
    Expect(1, 917999, '\p{Age=:\Av40\z:}', "");;
    Expect(0, 918000, '\p{Age=:\Av40\z:}', "");;
    Expect(1, 917999, '\p{Age=		V4_0}', "");
    Expect(0, 917999, '\p{^Age=		V4_0}', "");
    Expect(0, 917999, '\P{Age=		V4_0}', "");
    Expect(1, 917999, '\P{^Age=		V4_0}', "");
    Expect(0, 918000, '\p{Age=		V4_0}', "");
    Expect(1, 918000, '\p{^Age=		V4_0}', "");
    Expect(1, 918000, '\P{Age=		V4_0}', "");
    Expect(0, 918000, '\P{^Age=		V4_0}', "");
    Error('\p{Is_Age=:=- 0004.0}');
    Error('\P{Is_Age=:=- 0004.0}');
    Expect(1, 917999, '\p{Is_Age=+000004.0}', "");
    Expect(0, 917999, '\p{^Is_Age=+000004.0}', "");
    Expect(0, 917999, '\P{Is_Age=+000004.0}', "");
    Expect(1, 917999, '\P{^Is_Age=+000004.0}', "");
    Expect(0, 918000, '\p{Is_Age=+000004.0}', "");
    Expect(1, 918000, '\p{^Is_Age=+000004.0}', "");
    Expect(1, 918000, '\P{Is_Age=+000004.0}', "");
    Expect(0, 918000, '\P{^Is_Age=+000004.0}', "");
    Error('\p{Age=/a/__V4_1}');
    Error('\P{Age=/a/__V4_1}');
    Expect(1, 120485, '\p{Age=:\AV4_1\z:}', "");;
    Expect(0, 120486, '\p{Age=:\AV4_1\z:}', "");;
    Expect(1, 120485, '\p{Age=v41}', "");
    Expect(0, 120485, '\p{^Age=v41}', "");
    Expect(0, 120485, '\P{Age=v41}', "");
    Expect(1, 120485, '\P{^Age=v41}', "");
    Expect(0, 120486, '\p{Age=v41}', "");
    Expect(1, 120486, '\p{^Age=v41}', "");
    Expect(1, 120486, '\P{Age=v41}', "");
    Expect(0, 120486, '\P{^Age=v41}', "");
    Expect(1, 120485, '\p{Age=:\Av41\z:}', "");;
    Expect(0, 120486, '\p{Age=:\Av41\z:}', "");;
    Expect(1, 120485, '\p{Age=_	v4_1}', "");
    Expect(0, 120485, '\p{^Age=_	v4_1}', "");
    Expect(0, 120485, '\P{Age=_	v4_1}', "");
    Expect(1, 120485, '\P{^Age=_	v4_1}', "");
    Expect(0, 120486, '\p{Age=_	v4_1}', "");
    Expect(1, 120486, '\p{^Age=_	v4_1}', "");
    Expect(1, 120486, '\P{Age=_	v4_1}', "");
    Expect(0, 120486, '\P{^Age=_	v4_1}', "");
    Error('\p{Is_Age=:=-	0_0_04.1}');
    Error('\P{Is_Age=:=-	0_0_04.1}');
    Expect(1, 120485, '\p{Is_Age=+0000_4.1}', "");
    Expect(0, 120485, '\p{^Is_Age=+0000_4.1}', "");
    Expect(0, 120485, '\P{Is_Age=+0000_4.1}', "");
    Expect(1, 120485, '\P{^Is_Age=+0000_4.1}', "");
    Expect(0, 120486, '\p{Is_Age=+0000_4.1}', "");
    Expect(1, 120486, '\p{^Is_Age=+0000_4.1}', "");
    Expect(1, 120486, '\P{Is_Age=+0000_4.1}', "");
    Expect(0, 120486, '\P{^Is_Age=+0000_4.1}', "");
    Error('\p{Age=:=V5_0}');
    Error('\P{Age=:=V5_0}');
    Expect(1, 120779, '\p{Age=:\AV5_0\z:}', "");;
    Expect(0, 120780, '\p{Age=:\AV5_0\z:}', "");;
    Expect(1, 120779, '\p{Age:	v50}', "");
    Expect(0, 120779, '\p{^Age:	v50}', "");
    Expect(0, 120779, '\P{Age:	v50}', "");
    Expect(1, 120779, '\P{^Age:	v50}', "");
    Expect(0, 120780, '\p{Age:	v50}', "");
    Expect(1, 120780, '\p{^Age:	v50}', "");
    Expect(1, 120780, '\P{Age:	v50}', "");
    Expect(0, 120780, '\P{^Age:	v50}', "");
    Expect(1, 120779, '\p{Age=:\Av50\z:}', "");;
    Expect(0, 120780, '\p{Age=:\Av50\z:}', "");;
    Expect(1, 120779, '\p{Age= -v5_0}', "");
    Expect(0, 120779, '\p{^Age= -v5_0}', "");
    Expect(0, 120779, '\P{Age= -v5_0}', "");
    Expect(1, 120779, '\P{^Age= -v5_0}', "");
    Expect(0, 120780, '\p{Age= -v5_0}', "");
    Expect(1, 120780, '\p{^Age= -v5_0}', "");
    Expect(1, 120780, '\P{Age= -v5_0}', "");
    Expect(0, 120780, '\P{^Age= -v5_0}', "");
    Error('\p{Is_Age=_0_5.0:=}');
    Error('\P{Is_Age=_0_5.0:=}');
    Expect(1, 120779, '\p{Is_Age=+00005.0}', "");
    Expect(0, 120779, '\p{^Is_Age=+00005.0}', "");
    Expect(0, 120779, '\P{Is_Age=+00005.0}', "");
    Expect(1, 120779, '\P{^Is_Age=+00005.0}', "");
    Expect(0, 120780, '\p{Is_Age=+00005.0}', "");
    Expect(1, 120780, '\p{^Is_Age=+00005.0}', "");
    Expect(1, 120780, '\P{Is_Age=+00005.0}', "");
    Expect(0, 120780, '\P{^Is_Age=+00005.0}', "");
    Error('\p{Age=:=_V5_1}');
    Error('\P{Age=:=_V5_1}');
    Expect(1, 127123, '\p{Age=:\AV5_1\z:}', "");;
    Expect(0, 127124, '\p{Age=:\AV5_1\z:}', "");;
    Expect(1, 127123, '\p{Age:	v51}', "");
    Expect(0, 127123, '\p{^Age:	v51}', "");
    Expect(0, 127123, '\P{Age:	v51}', "");
    Expect(1, 127123, '\P{^Age:	v51}', "");
    Expect(0, 127124, '\p{Age:	v51}', "");
    Expect(1, 127124, '\p{^Age:	v51}', "");
    Expect(1, 127124, '\P{Age:	v51}', "");
    Expect(0, 127124, '\P{^Age:	v51}', "");
    Expect(1, 127123, '\p{Age=:\Av51\z:}', "");;
    Expect(0, 127124, '\p{Age=:\Av51\z:}', "");;
    Expect(1, 127123, '\p{Age=		v5_1}', "");
    Expect(0, 127123, '\p{^Age=		v5_1}', "");
    Expect(0, 127123, '\P{Age=		v5_1}', "");
    Expect(1, 127123, '\P{^Age=		v5_1}', "");
    Expect(0, 127124, '\p{Age=		v5_1}', "");
    Expect(1, 127124, '\p{^Age=		v5_1}', "");
    Expect(1, 127124, '\P{Age=		v5_1}', "");
    Expect(0, 127124, '\P{^Age=		v5_1}', "");
    Error('\p{Is_Age=:=00_5.1}');
    Error('\P{Is_Age=:=00_5.1}');
    Expect(1, 127123, '\p{Is_Age=00_00_5.1}', "");
    Expect(0, 127123, '\p{^Is_Age=00_00_5.1}', "");
    Expect(0, 127123, '\P{Is_Age=00_00_5.1}', "");
    Expect(1, 127123, '\P{^Is_Age=00_00_5.1}', "");
    Expect(0, 127124, '\p{Is_Age=00_00_5.1}', "");
    Expect(1, 127124, '\p{^Is_Age=00_00_5.1}', "");
    Expect(1, 127124, '\P{Is_Age=00_00_5.1}', "");
    Expect(0, 127124, '\P{^Is_Age=00_00_5.1}', "");
    Error('\p{Age:/a/_V5_2}');
    Error('\P{Age:/a/_V5_2}');
    Expect(1, 177972, '\p{Age=:\AV5_2\z:}', "");;
    Expect(0, 177973, '\p{Age=:\AV5_2\z:}', "");;
    Expect(1, 177972, '\p{Age=v52}', "");
    Expect(0, 177972, '\p{^Age=v52}', "");
    Expect(0, 177972, '\P{Age=v52}', "");
    Expect(1, 177972, '\P{^Age=v52}', "");
    Expect(0, 177973, '\p{Age=v52}', "");
    Expect(1, 177973, '\p{^Age=v52}', "");
    Expect(1, 177973, '\P{Age=v52}', "");
    Expect(0, 177973, '\P{^Age=v52}', "");
    Expect(1, 177972, '\p{Age=:\Av52\z:}', "");;
    Expect(0, 177973, '\p{Age=:\Av52\z:}', "");;
    Expect(1, 177972, '\p{Age=	-V5_2}', "");
    Expect(0, 177972, '\p{^Age=	-V5_2}', "");
    Expect(0, 177972, '\P{Age=	-V5_2}', "");
    Expect(1, 177972, '\P{^Age=	-V5_2}', "");
    Expect(0, 177973, '\p{Age=	-V5_2}', "");
    Expect(1, 177973, '\p{^Age=	-V5_2}', "");
    Expect(1, 177973, '\P{Age=	-V5_2}', "");
    Expect(0, 177973, '\P{^Age=	-V5_2}', "");
    Error('\p{Is_Age=/a/-_+0_5.2}');
    Error('\P{Is_Age=/a/-_+0_5.2}');
    Expect(1, 177972, '\p{Is_Age=+00_00_00_005.2}', "");
    Expect(0, 177972, '\p{^Is_Age=+00_00_00_005.2}', "");
    Expect(0, 177972, '\P{Is_Age=+00_00_00_005.2}', "");
    Expect(1, 177972, '\P{^Is_Age=+00_00_00_005.2}', "");
    Expect(0, 177973, '\p{Is_Age=+00_00_00_005.2}', "");
    Expect(1, 177973, '\p{^Is_Age=+00_00_00_005.2}', "");
    Expect(1, 177973, '\P{Is_Age=+00_00_00_005.2}', "");
    Expect(0, 177973, '\P{^Is_Age=+00_00_00_005.2}', "");
    Error('\p{Age=V6_0:=}');
    Error('\P{Age=V6_0:=}');
    Expect(1, 178205, '\p{Age=:\AV6_0\z:}', "");;
    Expect(0, 178206, '\p{Age=:\AV6_0\z:}', "");;
    Expect(1, 178205, '\p{Age=v60}', "");
    Expect(0, 178205, '\p{^Age=v60}', "");
    Expect(0, 178205, '\P{Age=v60}', "");
    Expect(1, 178205, '\P{^Age=v60}', "");
    Expect(0, 178206, '\p{Age=v60}', "");
    Expect(1, 178206, '\p{^Age=v60}', "");
    Expect(1, 178206, '\P{Age=v60}', "");
    Expect(0, 178206, '\P{^Age=v60}', "");
    Expect(1, 178205, '\p{Age=:\Av60\z:}', "");;
    Expect(0, 178206, '\p{Age=:\Av60\z:}', "");;
    Expect(1, 178205, '\p{Age=	V6_0}', "");
    Expect(0, 178205, '\p{^Age=	V6_0}', "");
    Expect(0, 178205, '\P{Age=	V6_0}', "");
    Expect(1, 178205, '\P{^Age=	V6_0}', "");
    Expect(0, 178206, '\p{Age=	V6_0}', "");
    Expect(1, 178206, '\p{^Age=	V6_0}', "");
    Expect(1, 178206, '\P{Age=	V6_0}', "");
    Expect(0, 178206, '\P{^Age=	V6_0}', "");
    Error('\p{Is_Age=/a/		6.0}');
    Error('\P{Is_Age=/a/		6.0}');
    Expect(1, 178205, '\p{Is_Age=0_0_0_06.0}', "");
    Expect(0, 178205, '\p{^Is_Age=0_0_0_06.0}', "");
    Expect(0, 178205, '\P{Is_Age=0_0_0_06.0}', "");
    Expect(1, 178205, '\P{^Is_Age=0_0_0_06.0}', "");
    Expect(0, 178206, '\p{Is_Age=0_0_0_06.0}', "");
    Expect(1, 178206, '\p{^Is_Age=0_0_0_06.0}', "");
    Expect(1, 178206, '\P{Is_Age=0_0_0_06.0}', "");
    Expect(0, 178206, '\P{^Is_Age=0_0_0_06.0}', "");
    Error('\p{Age=	:=V6_1}');
    Error('\P{Age=	:=V6_1}');
    Expect(1, 128564, '\p{Age=:\AV6_1\z:}', "");;
    Expect(0, 128565, '\p{Age=:\AV6_1\z:}', "");;
    Expect(1, 128564, '\p{Age: v61}', "");
    Expect(0, 128564, '\p{^Age: v61}', "");
    Expect(0, 128564, '\P{Age: v61}', "");
    Expect(1, 128564, '\P{^Age: v61}', "");
    Expect(0, 128565, '\p{Age: v61}', "");
    Expect(1, 128565, '\p{^Age: v61}', "");
    Expect(1, 128565, '\P{Age: v61}', "");
    Expect(0, 128565, '\P{^Age: v61}', "");
    Expect(1, 128564, '\p{Age=:\Av61\z:}', "");;
    Expect(0, 128565, '\p{Age=:\Av61\z:}', "");;
    Expect(1, 128564, '\p{Age= _V6_1}', "");
    Expect(0, 128564, '\p{^Age= _V6_1}', "");
    Expect(0, 128564, '\P{Age= _V6_1}', "");
    Expect(1, 128564, '\P{^Age= _V6_1}', "");
    Expect(0, 128565, '\p{Age= _V6_1}', "");
    Expect(1, 128565, '\p{^Age= _V6_1}', "");
    Expect(1, 128565, '\P{Age= _V6_1}', "");
    Expect(0, 128565, '\P{^Age= _V6_1}', "");
    Error('\p{Is_Age=_+000006.1:=}');
    Error('\P{Is_Age=_+000006.1:=}');
    Expect(1, 128564, '\p{Is_Age=+0000000006.1}', "");
    Expect(0, 128564, '\p{^Is_Age=+0000000006.1}', "");
    Expect(0, 128564, '\P{Is_Age=+0000000006.1}', "");
    Expect(1, 128564, '\P{^Is_Age=+0000000006.1}', "");
    Expect(0, 128565, '\p{Is_Age=+0000000006.1}', "");
    Expect(1, 128565, '\p{^Is_Age=+0000000006.1}', "");
    Expect(1, 128565, '\P{Is_Age=+0000000006.1}', "");
    Expect(0, 128565, '\P{^Is_Age=+0000000006.1}', "");
    Error('\p{Age:		/a/V6_2}');
    Error('\P{Age:		/a/V6_2}');
    Expect(1, 8378, '\p{Age=:\AV6_2\z:}', "");;
    Expect(0, 8379, '\p{Age=:\AV6_2\z:}', "");;
    Expect(1, 8378, '\p{Age=v62}', "");
    Expect(0, 8378, '\p{^Age=v62}', "");
    Expect(0, 8378, '\P{Age=v62}', "");
    Expect(1, 8378, '\P{^Age=v62}', "");
    Expect(0, 8379, '\p{Age=v62}', "");
    Expect(1, 8379, '\p{^Age=v62}', "");
    Expect(1, 8379, '\P{Age=v62}', "");
    Expect(0, 8379, '\P{^Age=v62}', "");
    Expect(1, 8378, '\p{Age=:\Av62\z:}', "");;
    Expect(0, 8379, '\p{Age=:\Av62\z:}', "");;
    Expect(1, 8378, '\p{Age=_ v6_2}', "");
    Expect(0, 8378, '\p{^Age=_ v6_2}', "");
    Expect(0, 8378, '\P{Age=_ v6_2}', "");
    Expect(1, 8378, '\P{^Age=_ v6_2}', "");
    Expect(0, 8379, '\p{Age=_ v6_2}', "");
    Expect(1, 8379, '\p{^Age=_ v6_2}', "");
    Expect(1, 8379, '\P{Age=_ v6_2}', "");
    Expect(0, 8379, '\P{^Age=_ v6_2}', "");
    Error('\p{Is_Age=- +00_6.2:=}');
    Error('\P{Is_Age=- +00_6.2:=}');
    Expect(1, 8378, '\p{Is_Age:	0_6.2}', "");
    Expect(0, 8378, '\p{^Is_Age:	0_6.2}', "");
    Expect(0, 8378, '\P{Is_Age:	0_6.2}', "");
    Expect(1, 8378, '\P{^Is_Age:	0_6.2}', "");
    Expect(0, 8379, '\p{Is_Age:	0_6.2}', "");
    Expect(1, 8379, '\p{^Is_Age:	0_6.2}', "");
    Expect(1, 8379, '\P{Is_Age:	0_6.2}', "");
    Expect(0, 8379, '\P{^Is_Age:	0_6.2}', "");
    Error('\p{Age=/a/V6_3}');
    Error('\P{Age=/a/V6_3}');
    Expect(1, 8297, '\p{Age=:\AV6_3\z:}', "");;
    Expect(0, 8298, '\p{Age=:\AV6_3\z:}', "");;
    Expect(1, 8297, '\p{Age=v63}', "");
    Expect(0, 8297, '\p{^Age=v63}', "");
    Expect(0, 8297, '\P{Age=v63}', "");
    Expect(1, 8297, '\P{^Age=v63}', "");
    Expect(0, 8298, '\p{Age=v63}', "");
    Expect(1, 8298, '\p{^Age=v63}', "");
    Expect(1, 8298, '\P{Age=v63}', "");
    Expect(0, 8298, '\P{^Age=v63}', "");
    Expect(1, 8297, '\p{Age=:\Av63\z:}', "");;
    Expect(0, 8298, '\p{Age=:\Av63\z:}', "");;
    Expect(1, 8297, '\p{Age=_V6_3}', "");
    Expect(0, 8297, '\p{^Age=_V6_3}', "");
    Expect(0, 8297, '\P{Age=_V6_3}', "");
    Expect(1, 8297, '\P{^Age=_V6_3}', "");
    Expect(0, 8298, '\p{Age=_V6_3}', "");
    Expect(1, 8298, '\p{^Age=_V6_3}', "");
    Expect(1, 8298, '\P{Age=_V6_3}', "");
    Expect(0, 8298, '\P{^Age=_V6_3}', "");
    Error('\p{Is_Age= 00000000_6.3:=}');
    Error('\P{Is_Age= 00000000_6.3:=}');
    Expect(1, 8297, '\p{Is_Age=+0_6.3}', "");
    Expect(0, 8297, '\p{^Is_Age=+0_6.3}', "");
    Expect(0, 8297, '\P{Is_Age=+0_6.3}', "");
    Expect(1, 8297, '\P{^Is_Age=+0_6.3}', "");
    Expect(0, 8298, '\p{Is_Age=+0_6.3}', "");
    Expect(1, 8298, '\p{^Is_Age=+0_6.3}', "");
    Expect(1, 8298, '\P{Is_Age=+0_6.3}', "");
    Expect(0, 8298, '\P{^Is_Age=+0_6.3}', "");
    Error('\p{Age=:=_v7_0}');
    Error('\P{Age=:=_v7_0}');
    Expect(1, 129197, '\p{Age=:\AV7_0\z:}', "");;
    Expect(0, 129198, '\p{Age=:\AV7_0\z:}', "");;
    Expect(1, 129197, '\p{Age=v70}', "");
    Expect(0, 129197, '\p{^Age=v70}', "");
    Expect(0, 129197, '\P{Age=v70}', "");
    Expect(1, 129197, '\P{^Age=v70}', "");
    Expect(0, 129198, '\p{Age=v70}', "");
    Expect(1, 129198, '\p{^Age=v70}', "");
    Expect(1, 129198, '\P{Age=v70}', "");
    Expect(0, 129198, '\P{^Age=v70}', "");
    Expect(1, 129197, '\p{Age=:\Av70\z:}', "");;
    Expect(0, 129198, '\p{Age=:\Av70\z:}', "");;
    Expect(1, 129197, '\p{Age=-V7_0}', "");
    Expect(0, 129197, '\p{^Age=-V7_0}', "");
    Expect(0, 129197, '\P{Age=-V7_0}', "");
    Expect(1, 129197, '\P{^Age=-V7_0}', "");
    Expect(0, 129198, '\p{Age=-V7_0}', "");
    Expect(1, 129198, '\p{^Age=-V7_0}', "");
    Expect(1, 129198, '\P{Age=-V7_0}', "");
    Expect(0, 129198, '\P{^Age=-V7_0}', "");
    Error('\p{Is_Age=_	0_7.0/a/}');
    Error('\P{Is_Age=_	0_7.0/a/}');
    Expect(1, 129197, '\p{Is_Age=00_00_00_00_7.0}', "");
    Expect(0, 129197, '\p{^Is_Age=00_00_00_00_7.0}', "");
    Expect(0, 129197, '\P{Is_Age=00_00_00_00_7.0}', "");
    Expect(1, 129197, '\P{^Is_Age=00_00_00_00_7.0}', "");
    Expect(0, 129198, '\p{Is_Age=00_00_00_00_7.0}', "");
    Expect(1, 129198, '\p{^Is_Age=00_00_00_00_7.0}', "");
    Expect(1, 129198, '\P{Is_Age=00_00_00_00_7.0}', "");
    Expect(0, 129198, '\P{^Is_Age=00_00_00_00_7.0}', "");
    Error('\p{Age=-	v8_0/a/}');
    Error('\P{Age=-	v8_0/a/}');
    Expect(1, 183969, '\p{Age=:\AV8_0\z:}', "");;
    Expect(0, 183970, '\p{Age=:\AV8_0\z:}', "");;
    Expect(1, 183969, '\p{Age=v80}', "");
    Expect(0, 183969, '\p{^Age=v80}', "");
    Expect(0, 183969, '\P{Age=v80}', "");
    Expect(1, 183969, '\P{^Age=v80}', "");
    Expect(0, 183970, '\p{Age=v80}', "");
    Expect(1, 183970, '\p{^Age=v80}', "");
    Expect(1, 183970, '\P{Age=v80}', "");
    Expect(0, 183970, '\P{^Age=v80}', "");
    Expect(1, 183969, '\p{Age=:\Av80\z:}', "");;
    Expect(0, 183970, '\p{Age=:\Av80\z:}', "");;
    Expect(1, 183969, '\p{Age=  V8_0}', "");
    Expect(0, 183969, '\p{^Age=  V8_0}', "");
    Expect(0, 183969, '\P{Age=  V8_0}', "");
    Expect(1, 183969, '\P{^Age=  V8_0}', "");
    Expect(0, 183970, '\p{Age=  V8_0}', "");
    Expect(1, 183970, '\p{^Age=  V8_0}', "");
    Expect(1, 183970, '\P{Age=  V8_0}', "");
    Expect(0, 183970, '\P{^Age=  V8_0}', "");
    Error('\p{Is_Age=_/a/008.0}');
    Error('\P{Is_Age=_/a/008.0}');
    Expect(1, 183969, '\p{Is_Age=00000000_8.0}', "");
    Expect(0, 183969, '\p{^Is_Age=00000000_8.0}', "");
    Expect(0, 183969, '\P{Is_Age=00000000_8.0}', "");
    Expect(1, 183969, '\P{^Is_Age=00000000_8.0}', "");
    Expect(0, 183970, '\p{Is_Age=00000000_8.0}', "");
    Expect(1, 183970, '\p{^Is_Age=00000000_8.0}', "");
    Expect(1, 183970, '\P{Is_Age=00000000_8.0}', "");
    Expect(0, 183970, '\P{^Is_Age=00000000_8.0}', "");
    Error('\p{Age=/a/- V9_0}');
    Error('\P{Age=/a/- V9_0}');
    Expect(1, 129425, '\p{Age=:\AV9_0\z:}', "");;
    Expect(0, 129426, '\p{Age=:\AV9_0\z:}', "");;
    Expect(1, 129425, '\p{Age=v90}', "");
    Expect(0, 129425, '\p{^Age=v90}', "");
    Expect(0, 129425, '\P{Age=v90}', "");
    Expect(1, 129425, '\P{^Age=v90}', "");
    Expect(0, 129426, '\p{Age=v90}', "");
    Expect(1, 129426, '\p{^Age=v90}', "");
    Expect(1, 129426, '\P{Age=v90}', "");
    Expect(0, 129426, '\P{^Age=v90}', "");
    Expect(1, 129425, '\p{Age=:\Av90\z:}', "");;
    Expect(0, 129426, '\p{Age=:\Av90\z:}', "");;
    Expect(1, 129425, '\p{Age=_	v9_0}', "");
    Expect(0, 129425, '\p{^Age=_	v9_0}', "");
    Expect(0, 129425, '\P{Age=_	v9_0}', "");
    Expect(1, 129425, '\P{^Age=_	v9_0}', "");
    Expect(0, 129426, '\p{Age=_	v9_0}', "");
    Expect(1, 129426, '\p{^Age=_	v9_0}', "");
    Expect(1, 129426, '\P{Age=_	v9_0}', "");
    Expect(0, 129426, '\P{^Age=_	v9_0}', "");
    Error('\p{Is_Age=:= _0000009.0}');
    Error('\P{Is_Age=:= _0000009.0}');
    Expect(1, 129425, '\p{Is_Age=+0000_0000_09.0}', "");
    Expect(0, 129425, '\p{^Is_Age=+0000_0000_09.0}', "");
    Expect(0, 129425, '\P{Is_Age=+0000_0000_09.0}', "");
    Expect(1, 129425, '\P{^Is_Age=+0000_0000_09.0}', "");
    Expect(0, 129426, '\p{Is_Age=+0000_0000_09.0}', "");
    Expect(1, 129426, '\p{^Is_Age=+0000_0000_09.0}', "");
    Expect(1, 129426, '\P{Is_Age=+0000_0000_09.0}', "");
    Expect(0, 129426, '\P{^Is_Age=+0000_0000_09.0}', "");
    Error('\p{Age=/a/- unassigned}');
    Error('\P{Age=/a/- unassigned}');
    Expect(1, 983037, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=unassigned}', "");
    Expect(0, 983037, '\p{^Age=unassigned}', "");
    Expect(0, 983037, '\P{Age=unassigned}', "");
    Expect(1, 983037, '\P{^Age=unassigned}', "");
    Expect(0, 983040, '\p{Age=unassigned}', "");
    Expect(1, 983040, '\p{^Age=unassigned}', "");
    Expect(1, 983040, '\P{Age=unassigned}', "");
    Expect(0, 983040, '\P{^Age=unassigned}', "");
    Expect(1, 983037, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=  Unassigned}', "");
    Expect(0, 983037, '\p{^Age=  Unassigned}', "");
    Expect(0, 983037, '\P{Age=  Unassigned}', "");
    Expect(1, 983037, '\P{^Age=  Unassigned}', "");
    Expect(0, 983040, '\p{Age=  Unassigned}', "");
    Expect(1, 983040, '\p{^Age=  Unassigned}', "");
    Expect(1, 983040, '\P{Age=  Unassigned}', "");
    Expect(0, 983040, '\P{^Age=  Unassigned}', "");
    Error('\p{Is_Age=/a/	-na}');
    Error('\P{Is_Age=/a/	-na}');
    Expect(1, 983037, '\p{Is_Age=na}', "");
    Expect(0, 983037, '\p{^Is_Age=na}', "");
    Expect(0, 983037, '\P{Is_Age=na}', "");
    Expect(1, 983037, '\P{^Is_Age=na}', "");
    Expect(0, 983040, '\p{Is_Age=na}', "");
    Expect(1, 983040, '\p{^Is_Age=na}', "");
    Expect(1, 983040, '\P{Is_Age=na}', "");
    Expect(0, 983040, '\P{^Is_Age=na}', "");
    Expect(1, 983037, '\p{Is_Age=	NA}', "");
    Expect(0, 983037, '\p{^Is_Age=	NA}', "");
    Expect(0, 983037, '\P{Is_Age=	NA}', "");
    Expect(1, 983037, '\P{^Is_Age=	NA}', "");
    Expect(0, 983040, '\p{Is_Age=	NA}', "");
    Expect(1, 983040, '\p{^Is_Age=	NA}', "");
    Expect(1, 983040, '\P{Is_Age=	NA}', "");
    Expect(0, 983040, '\P{^Is_Age=	NA}', "");
    Error('\p{ASCII_Hex_Digit=_:=no}');
    Error('\P{ASCII_Hex_Digit=_:=no}');
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=	-No}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=	-No}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=	-No}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=	-No}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=	-No}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=	-No}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=	-No}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=	-No}', "");
    Error('\p{AHex=:=n}');
    Error('\P{AHex=:=n}');
    Expect(1, 103, '\p{AHex=:\AN\z:}', "");;
    Expect(0, 102, '\p{AHex=:\AN\z:}', "");;
    Expect(1, 103, '\p{AHex=n}', "");
    Expect(0, 103, '\p{^AHex=n}', "");
    Expect(0, 103, '\P{AHex=n}', "");
    Expect(1, 103, '\P{^AHex=n}', "");
    Expect(0, 102, '\p{AHex=n}', "");
    Expect(1, 102, '\p{^AHex=n}', "");
    Expect(1, 102, '\P{AHex=n}', "");
    Expect(0, 102, '\P{^AHex=n}', "");
    Expect(1, 103, '\p{AHex=:\An\z:}', "");;
    Expect(0, 102, '\p{AHex=:\An\z:}', "");;
    Expect(1, 103, '\p{AHex=-_N}', "");
    Expect(0, 103, '\p{^AHex=-_N}', "");
    Expect(0, 103, '\P{AHex=-_N}', "");
    Expect(1, 103, '\P{^AHex=-_N}', "");
    Expect(0, 102, '\p{AHex=-_N}', "");
    Expect(1, 102, '\p{^AHex=-_N}', "");
    Expect(1, 102, '\P{AHex=-_N}', "");
    Expect(0, 102, '\P{^AHex=-_N}', "");
    Error('\p{Is_ASCII_Hex_Digit=_	F:=}');
    Error('\P{Is_ASCII_Hex_Digit=_	F:=}');
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=-F}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=-F}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=-F}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=-F}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=-F}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=-F}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=-F}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=-F}', "");
    Error('\p{Is_AHex: -/a/False}');
    Error('\P{Is_AHex: -/a/False}');
    Expect(1, 103, '\p{Is_AHex=false}', "");
    Expect(0, 103, '\p{^Is_AHex=false}', "");
    Expect(0, 103, '\P{Is_AHex=false}', "");
    Expect(1, 103, '\P{^Is_AHex=false}', "");
    Expect(0, 102, '\p{Is_AHex=false}', "");
    Expect(1, 102, '\p{^Is_AHex=false}', "");
    Expect(1, 102, '\P{Is_AHex=false}', "");
    Expect(0, 102, '\P{^Is_AHex=false}', "");
    Expect(1, 103, '\p{Is_AHex= _false}', "");
    Expect(0, 103, '\p{^Is_AHex= _false}', "");
    Expect(0, 103, '\P{Is_AHex= _false}', "");
    Expect(1, 103, '\P{^Is_AHex= _false}', "");
    Expect(0, 102, '\p{Is_AHex= _false}', "");
    Expect(1, 102, '\p{^Is_AHex= _false}', "");
    Expect(1, 102, '\P{Is_AHex= _false}', "");
    Expect(0, 102, '\P{^Is_AHex= _false}', "");
    Error('\p{ASCII_Hex_Digit=:= -Yes}');
    Error('\P{ASCII_Hex_Digit=:= -Yes}');
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=YES}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=YES}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=YES}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=YES}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=YES}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=YES}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=YES}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=YES}', "");
    Error('\p{AHex=	-Y/a/}');
    Error('\P{AHex=	-Y/a/}');
    Expect(1, 102, '\p{AHex=:\AY\z:}', "");;
    Expect(0, 103, '\p{AHex=:\AY\z:}', "");;
    Expect(1, 102, '\p{AHex=y}', "");
    Expect(0, 102, '\p{^AHex=y}', "");
    Expect(0, 102, '\P{AHex=y}', "");
    Expect(1, 102, '\P{^AHex=y}', "");
    Expect(0, 103, '\p{AHex=y}', "");
    Expect(1, 103, '\p{^AHex=y}', "");
    Expect(1, 103, '\P{AHex=y}', "");
    Expect(0, 103, '\P{^AHex=y}', "");
    Expect(1, 102, '\p{AHex=:\Ay\z:}', "");;
    Expect(0, 103, '\p{AHex=:\Ay\z:}', "");;
    Expect(1, 102, '\p{AHex=	-y}', "");
    Expect(0, 102, '\p{^AHex=	-y}', "");
    Expect(0, 102, '\P{AHex=	-y}', "");
    Expect(1, 102, '\P{^AHex=	-y}', "");
    Expect(0, 103, '\p{AHex=	-y}', "");
    Expect(1, 103, '\p{^AHex=	-y}', "");
    Expect(1, 103, '\P{AHex=	-y}', "");
    Expect(0, 103, '\P{^AHex=	-y}', "");
    Error('\p{Is_ASCII_Hex_Digit=-	T:=}');
    Error('\P{Is_ASCII_Hex_Digit=-	T:=}');
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit= 	T}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit= 	T}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit= 	T}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit= 	T}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit= 	T}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit= 	T}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit= 	T}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit= 	T}', "");
    Error('\p{Is_AHex=_True:=}');
    Error('\P{Is_AHex=_True:=}');
    Expect(1, 102, '\p{Is_AHex=true}', "");
    Expect(0, 102, '\p{^Is_AHex=true}', "");
    Expect(0, 102, '\P{Is_AHex=true}', "");
    Expect(1, 102, '\P{^Is_AHex=true}', "");
    Expect(0, 103, '\p{Is_AHex=true}', "");
    Expect(1, 103, '\p{^Is_AHex=true}', "");
    Expect(1, 103, '\P{Is_AHex=true}', "");
    Expect(0, 103, '\P{^Is_AHex=true}', "");
    Expect(1, 102, '\p{Is_AHex=	 TRUE}', "");
    Expect(0, 102, '\p{^Is_AHex=	 TRUE}', "");
    Expect(0, 102, '\P{Is_AHex=	 TRUE}', "");
    Expect(1, 102, '\P{^Is_AHex=	 TRUE}', "");
    Expect(0, 103, '\p{Is_AHex=	 TRUE}', "");
    Expect(1, 103, '\p{^Is_AHex=	 TRUE}', "");
    Expect(1, 103, '\P{Is_AHex=	 TRUE}', "");
    Expect(0, 103, '\P{^Is_AHex=	 TRUE}', "");
    Error('\p{Alphabetic: _:=no}');
    Error('\P{Alphabetic: _:=no}');
    Expect(1, 195102, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(0, 195101, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(1, 195102, '\p{Alphabetic=no}', "");
    Expect(0, 195102, '\p{^Alphabetic=no}', "");
    Expect(0, 195102, '\P{Alphabetic=no}', "");
    Expect(1, 195102, '\P{^Alphabetic=no}', "");
    Expect(0, 195101, '\p{Alphabetic=no}', "");
    Expect(1, 195101, '\p{^Alphabetic=no}', "");
    Expect(1, 195101, '\P{Alphabetic=no}', "");
    Expect(0, 195101, '\P{^Alphabetic=no}', "");
    Expect(1, 195102, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(0, 195101, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(1, 195102, '\p{Alphabetic=_No}', "");
    Expect(0, 195102, '\p{^Alphabetic=_No}', "");
    Expect(0, 195102, '\P{Alphabetic=_No}', "");
    Expect(1, 195102, '\P{^Alphabetic=_No}', "");
    Expect(0, 195101, '\p{Alphabetic=_No}', "");
    Expect(1, 195101, '\p{^Alphabetic=_No}', "");
    Expect(1, 195101, '\P{Alphabetic=_No}', "");
    Expect(0, 195101, '\P{^Alphabetic=_No}', "");
    Error('\p{Alpha=-:=N}');
    Error('\P{Alpha=-:=N}');
    Expect(1, 195102, '\p{Alpha=:\AN\z:}', "");;
    Expect(0, 195101, '\p{Alpha=:\AN\z:}', "");;
    Expect(1, 195102, '\p{Alpha=n}', "");
    Expect(0, 195102, '\p{^Alpha=n}', "");
    Expect(0, 195102, '\P{Alpha=n}', "");
    Expect(1, 195102, '\P{^Alpha=n}', "");
    Expect(0, 195101, '\p{Alpha=n}', "");
    Expect(1, 195101, '\p{^Alpha=n}', "");
    Expect(1, 195101, '\P{Alpha=n}', "");
    Expect(0, 195101, '\P{^Alpha=n}', "");
    Expect(1, 195102, '\p{Alpha=:\An\z:}', "");;
    Expect(0, 195101, '\p{Alpha=:\An\z:}', "");;
    Expect(1, 195102, '\p{Alpha=		N}', "");
    Expect(0, 195102, '\p{^Alpha=		N}', "");
    Expect(0, 195102, '\P{Alpha=		N}', "");
    Expect(1, 195102, '\P{^Alpha=		N}', "");
    Expect(0, 195101, '\p{Alpha=		N}', "");
    Expect(1, 195101, '\p{^Alpha=		N}', "");
    Expect(1, 195101, '\P{Alpha=		N}', "");
    Expect(0, 195101, '\P{^Alpha=		N}', "");
    Error('\p{Is_Alphabetic:   _/a/F}');
    Error('\P{Is_Alphabetic:   _/a/F}');
    Expect(1, 195102, '\p{Is_Alphabetic:   f}', "");
    Expect(0, 195102, '\p{^Is_Alphabetic:   f}', "");
    Expect(0, 195102, '\P{Is_Alphabetic:   f}', "");
    Expect(1, 195102, '\P{^Is_Alphabetic:   f}', "");
    Expect(0, 195101, '\p{Is_Alphabetic:   f}', "");
    Expect(1, 195101, '\p{^Is_Alphabetic:   f}', "");
    Expect(1, 195101, '\P{Is_Alphabetic:   f}', "");
    Expect(0, 195101, '\P{^Is_Alphabetic:   f}', "");
    Expect(1, 195102, '\p{Is_Alphabetic=-F}', "");
    Expect(0, 195102, '\p{^Is_Alphabetic=-F}', "");
    Expect(0, 195102, '\P{Is_Alphabetic=-F}', "");
    Expect(1, 195102, '\P{^Is_Alphabetic=-F}', "");
    Expect(0, 195101, '\p{Is_Alphabetic=-F}', "");
    Expect(1, 195101, '\p{^Is_Alphabetic=-F}', "");
    Expect(1, 195101, '\P{Is_Alphabetic=-F}', "");
    Expect(0, 195101, '\P{^Is_Alphabetic=-F}', "");
    Error('\p{Is_Alpha=:=_ FALSE}');
    Error('\P{Is_Alpha=:=_ FALSE}');
    Expect(1, 195102, '\p{Is_Alpha=false}', "");
    Expect(0, 195102, '\p{^Is_Alpha=false}', "");
    Expect(0, 195102, '\P{Is_Alpha=false}', "");
    Expect(1, 195102, '\P{^Is_Alpha=false}', "");
    Expect(0, 195101, '\p{Is_Alpha=false}', "");
    Expect(1, 195101, '\p{^Is_Alpha=false}', "");
    Expect(1, 195101, '\P{Is_Alpha=false}', "");
    Expect(0, 195101, '\P{^Is_Alpha=false}', "");
    Expect(1, 195102, '\p{Is_Alpha=	False}', "");
    Expect(0, 195102, '\p{^Is_Alpha=	False}', "");
    Expect(0, 195102, '\P{Is_Alpha=	False}', "");
    Expect(1, 195102, '\P{^Is_Alpha=	False}', "");
    Expect(0, 195101, '\p{Is_Alpha=	False}', "");
    Expect(1, 195101, '\p{^Is_Alpha=	False}', "");
    Expect(1, 195101, '\P{Is_Alpha=	False}', "");
    Expect(0, 195101, '\P{^Is_Alpha=	False}', "");
    Error('\p{Alphabetic=	/a/YES}');
    Error('\P{Alphabetic=	/a/YES}');
    Expect(1, 195101, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(0, 195102, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(1, 195101, '\p{Alphabetic=yes}', "");
    Expect(0, 195101, '\p{^Alphabetic=yes}', "");
    Expect(0, 195101, '\P{Alphabetic=yes}', "");
    Expect(1, 195101, '\P{^Alphabetic=yes}', "");
    Expect(0, 195102, '\p{Alphabetic=yes}', "");
    Expect(1, 195102, '\p{^Alphabetic=yes}', "");
    Expect(1, 195102, '\P{Alphabetic=yes}', "");
    Expect(0, 195102, '\P{^Alphabetic=yes}', "");
    Expect(1, 195101, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(0, 195102, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(1, 195101, '\p{Alphabetic=		yes}', "");
    Expect(0, 195101, '\p{^Alphabetic=		yes}', "");
    Expect(0, 195101, '\P{Alphabetic=		yes}', "");
    Expect(1, 195101, '\P{^Alphabetic=		yes}', "");
    Expect(0, 195102, '\p{Alphabetic=		yes}', "");
    Expect(1, 195102, '\p{^Alphabetic=		yes}', "");
    Expect(1, 195102, '\P{Alphabetic=		yes}', "");
    Expect(0, 195102, '\P{^Alphabetic=		yes}', "");
    Error('\p{Alpha=:=__Y}');
    Error('\P{Alpha=:=__Y}');
    Expect(1, 195101, '\p{Alpha=:\AY\z:}', "");;
    Expect(0, 195102, '\p{Alpha=:\AY\z:}', "");;
    Expect(1, 195101, '\p{Alpha=y}', "");
    Expect(0, 195101, '\p{^Alpha=y}', "");
    Expect(0, 195101, '\P{Alpha=y}', "");
    Expect(1, 195101, '\P{^Alpha=y}', "");
    Expect(0, 195102, '\p{Alpha=y}', "");
    Expect(1, 195102, '\p{^Alpha=y}', "");
    Expect(1, 195102, '\P{Alpha=y}', "");
    Expect(0, 195102, '\P{^Alpha=y}', "");
    Expect(1, 195101, '\p{Alpha=:\Ay\z:}', "");;
    Expect(0, 195102, '\p{Alpha=:\Ay\z:}', "");;
    Expect(1, 195101, '\p{Alpha=-y}', "");
    Expect(0, 195101, '\p{^Alpha=-y}', "");
    Expect(0, 195101, '\P{Alpha=-y}', "");
    Expect(1, 195101, '\P{^Alpha=-y}', "");
    Expect(0, 195102, '\p{Alpha=-y}', "");
    Expect(1, 195102, '\p{^Alpha=-y}', "");
    Expect(1, 195102, '\P{Alpha=-y}', "");
    Expect(0, 195102, '\P{^Alpha=-y}', "");
    Error('\p{Is_Alphabetic=-	T:=}');
    Error('\P{Is_Alphabetic=-	T:=}');
    Expect(1, 195101, '\p{Is_Alphabetic=t}', "");
    Expect(0, 195101, '\p{^Is_Alphabetic=t}', "");
    Expect(0, 195101, '\P{Is_Alphabetic=t}', "");
    Expect(1, 195101, '\P{^Is_Alphabetic=t}', "");
    Expect(0, 195102, '\p{Is_Alphabetic=t}', "");
    Expect(1, 195102, '\p{^Is_Alphabetic=t}', "");
    Expect(1, 195102, '\P{Is_Alphabetic=t}', "");
    Expect(0, 195102, '\P{^Is_Alphabetic=t}', "");
    Expect(1, 195101, '\p{Is_Alphabetic=	-T}', "");
    Expect(0, 195101, '\p{^Is_Alphabetic=	-T}', "");
    Expect(0, 195101, '\P{Is_Alphabetic=	-T}', "");
    Expect(1, 195101, '\P{^Is_Alphabetic=	-T}', "");
    Expect(0, 195102, '\p{Is_Alphabetic=	-T}', "");
    Expect(1, 195102, '\p{^Is_Alphabetic=	-T}', "");
    Expect(1, 195102, '\P{Is_Alphabetic=	-T}', "");
    Expect(0, 195102, '\P{^Is_Alphabetic=	-T}', "");
    Error('\p{Is_Alpha=:= -TRUE}');
    Error('\P{Is_Alpha=:= -TRUE}');
    Expect(1, 195101, '\p{Is_Alpha=true}', "");
    Expect(0, 195101, '\p{^Is_Alpha=true}', "");
    Expect(0, 195101, '\P{Is_Alpha=true}', "");
    Expect(1, 195101, '\P{^Is_Alpha=true}', "");
    Expect(0, 195102, '\p{Is_Alpha=true}', "");
    Expect(1, 195102, '\p{^Is_Alpha=true}', "");
    Expect(1, 195102, '\P{Is_Alpha=true}', "");
    Expect(0, 195102, '\P{^Is_Alpha=true}', "");
    Expect(1, 195101, '\p{Is_Alpha=		True}', "");
    Expect(0, 195101, '\p{^Is_Alpha=		True}', "");
    Expect(0, 195101, '\P{Is_Alpha=		True}', "");
    Expect(1, 195101, '\P{^Is_Alpha=		True}', "");
    Expect(0, 195102, '\p{Is_Alpha=		True}', "");
    Expect(1, 195102, '\p{^Is_Alpha=		True}', "");
    Expect(1, 195102, '\P{Is_Alpha=		True}', "");
    Expect(0, 195102, '\P{^Is_Alpha=		True}', "");
    Error('\p{bidiclass}');
    Error('\P{bidiclass}');
    Error('\p{bc}');
    Error('\P{bc}');
    Error('\p{Bidi_Class:	 /a/Arabic_Letter}');
    Error('\P{Bidi_Class:	 /a/Arabic_Letter}');
    Expect(1, 126719, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=_-Arabic_Letter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=_-Arabic_Letter}', "");
    Expect(0, 126719, '\P{Bidi_Class=_-Arabic_Letter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=_-Arabic_Letter}', "");
    Expect(0, 126720, '\p{Bidi_Class=_-Arabic_Letter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=_-Arabic_Letter}', "");
    Expect(1, 126720, '\P{Bidi_Class=_-Arabic_Letter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=_-Arabic_Letter}', "");
    Error('\p{Bc=-AL/a/}');
    Error('\P{Bc=-AL/a/}');
    Expect(1, 126719, '\p{Bc=:\AAL\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\AAL\z:}', "");;
    Expect(1, 126719, '\p{Bc=al}', "");
    Expect(0, 126719, '\p{^Bc=al}', "");
    Expect(0, 126719, '\P{Bc=al}', "");
    Expect(1, 126719, '\P{^Bc=al}', "");
    Expect(0, 126720, '\p{Bc=al}', "");
    Expect(1, 126720, '\p{^Bc=al}', "");
    Expect(1, 126720, '\P{Bc=al}', "");
    Expect(0, 126720, '\P{^Bc=al}', "");
    Expect(1, 126719, '\p{Bc=:\Aal\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\Aal\z:}', "");;
    Expect(1, 126719, '\p{Bc=--al}', "");
    Expect(0, 126719, '\p{^Bc=--al}', "");
    Expect(0, 126719, '\P{Bc=--al}', "");
    Expect(1, 126719, '\P{^Bc=--al}', "");
    Expect(0, 126720, '\p{Bc=--al}', "");
    Expect(1, 126720, '\p{^Bc=--al}', "");
    Expect(1, 126720, '\P{Bc=--al}', "");
    Expect(0, 126720, '\P{^Bc=--al}', "");
    Error('\p{Is_Bidi_Class=/a/	arabic_Letter}');
    Error('\P{Is_Bidi_Class=/a/	arabic_Letter}');
    Expect(1, 126719, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=-ARABIC_Letter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=-ARABIC_Letter}', "");
    Error('\p{Is_Bc: -/a/AL}');
    Error('\P{Is_Bc: -/a/AL}');
    Expect(1, 126719, '\p{Is_Bc=al}', "");
    Expect(0, 126719, '\p{^Is_Bc=al}', "");
    Expect(0, 126719, '\P{Is_Bc=al}', "");
    Expect(1, 126719, '\P{^Is_Bc=al}', "");
    Expect(0, 126720, '\p{Is_Bc=al}', "");
    Expect(1, 126720, '\p{^Is_Bc=al}', "");
    Expect(1, 126720, '\P{Is_Bc=al}', "");
    Expect(0, 126720, '\P{^Is_Bc=al}', "");
    Expect(1, 126719, '\p{Is_Bc= _AL}', "");
    Expect(0, 126719, '\p{^Is_Bc= _AL}', "");
    Expect(0, 126719, '\P{Is_Bc= _AL}', "");
    Expect(1, 126719, '\P{^Is_Bc= _AL}', "");
    Expect(0, 126720, '\p{Is_Bc= _AL}', "");
    Expect(1, 126720, '\p{^Is_Bc= _AL}', "");
    Expect(1, 126720, '\P{Is_Bc= _AL}', "");
    Expect(0, 126720, '\P{^Is_Bc= _AL}', "");
    Error('\p{Bidi_Class=	 ARABIC_Number/a/}');
    Error('\P{Bidi_Class=	 ARABIC_Number/a/}');
    Expect(1, 69246, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=Arabic_NUMBER}', "");
    Expect(0, 69246, '\p{^Bidi_Class=Arabic_NUMBER}', "");
    Expect(0, 69246, '\P{Bidi_Class=Arabic_NUMBER}', "");
    Expect(1, 69246, '\P{^Bidi_Class=Arabic_NUMBER}', "");
    Expect(0, 69247, '\p{Bidi_Class=Arabic_NUMBER}', "");
    Expect(1, 69247, '\p{^Bidi_Class=Arabic_NUMBER}', "");
    Expect(1, 69247, '\P{Bidi_Class=Arabic_NUMBER}', "");
    Expect(0, 69247, '\P{^Bidi_Class=Arabic_NUMBER}', "");
    Error('\p{Bc=:= -AN}');
    Error('\P{Bc=:= -AN}');
    Expect(1, 69246, '\p{Bc=:\AAN\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\AAN\z:}', "");;
    Expect(1, 69246, '\p{Bc=an}', "");
    Expect(0, 69246, '\p{^Bc=an}', "");
    Expect(0, 69246, '\P{Bc=an}', "");
    Expect(1, 69246, '\P{^Bc=an}', "");
    Expect(0, 69247, '\p{Bc=an}', "");
    Expect(1, 69247, '\p{^Bc=an}', "");
    Expect(1, 69247, '\P{Bc=an}', "");
    Expect(0, 69247, '\P{^Bc=an}', "");
    Expect(1, 69246, '\p{Bc=:\Aan\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\Aan\z:}', "");;
    Expect(1, 69246, '\p{Bc=- an}', "");
    Expect(0, 69246, '\p{^Bc=- an}', "");
    Expect(0, 69246, '\P{Bc=- an}', "");
    Expect(1, 69246, '\P{^Bc=- an}', "");
    Expect(0, 69247, '\p{Bc=- an}', "");
    Expect(1, 69247, '\p{^Bc=- an}', "");
    Expect(1, 69247, '\P{Bc=- an}', "");
    Expect(0, 69247, '\P{^Bc=- an}', "");
    Error('\p{Is_Bidi_Class=_/a/arabic_number}');
    Error('\P{Is_Bidi_Class=_/a/arabic_number}');
    Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Is_Bidi_Class:  ARABIC_number}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class:  ARABIC_number}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class:  ARABIC_number}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class:  ARABIC_number}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class:  ARABIC_number}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class:  ARABIC_number}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class:  ARABIC_number}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class:  ARABIC_number}', "");
    Error('\p{Is_Bc=:=-AN}');
    Error('\P{Is_Bc=:=-AN}');
    Expect(1, 69246, '\p{Is_Bc=an}', "");
    Expect(0, 69246, '\p{^Is_Bc=an}', "");
    Expect(0, 69246, '\P{Is_Bc=an}', "");
    Expect(1, 69246, '\P{^Is_Bc=an}', "");
    Expect(0, 69247, '\p{Is_Bc=an}', "");
    Expect(1, 69247, '\p{^Is_Bc=an}', "");
    Expect(1, 69247, '\P{Is_Bc=an}', "");
    Expect(0, 69247, '\P{^Is_Bc=an}', "");
    Expect(1, 69246, '\p{Is_Bc=-	AN}', "");
    Expect(0, 69246, '\p{^Is_Bc=-	AN}', "");
    Expect(0, 69246, '\P{Is_Bc=-	AN}', "");
    Expect(1, 69246, '\P{^Is_Bc=-	AN}', "");
    Expect(0, 69247, '\p{Is_Bc=-	AN}', "");
    Expect(1, 69247, '\p{^Is_Bc=-	AN}', "");
    Expect(1, 69247, '\P{Is_Bc=-	AN}', "");
    Expect(0, 69247, '\P{^Is_Bc=-	AN}', "");
    Error('\p{Bidi_Class=:= 	paragraph_Separator}');
    Error('\P{Bidi_Class=:= 	paragraph_Separator}');
    Expect(1, 8233, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class:    	Paragraph_Separator}', "");
    Expect(0, 8233, '\p{^Bidi_Class:    	Paragraph_Separator}', "");
    Expect(0, 8233, '\P{Bidi_Class:    	Paragraph_Separator}', "");
    Expect(1, 8233, '\P{^Bidi_Class:    	Paragraph_Separator}', "");
    Expect(0, 8234, '\p{Bidi_Class:    	Paragraph_Separator}', "");
    Expect(1, 8234, '\p{^Bidi_Class:    	Paragraph_Separator}', "");
    Expect(1, 8234, '\P{Bidi_Class:    	Paragraph_Separator}', "");
    Expect(0, 8234, '\P{^Bidi_Class:    	Paragraph_Separator}', "");
    Error('\p{Bc=- B:=}');
    Error('\P{Bc=- B:=}');
    Expect(1, 8233, '\p{Bc=:\AB\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\AB\z:}', "");;
    Expect(1, 8233, '\p{Bc=b}', "");
    Expect(0, 8233, '\p{^Bc=b}', "");
    Expect(0, 8233, '\P{Bc=b}', "");
    Expect(1, 8233, '\P{^Bc=b}', "");
    Expect(0, 8234, '\p{Bc=b}', "");
    Expect(1, 8234, '\p{^Bc=b}', "");
    Expect(1, 8234, '\P{Bc=b}', "");
    Expect(0, 8234, '\P{^Bc=b}', "");
    Expect(1, 8233, '\p{Bc=:\Ab\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\Ab\z:}', "");;
    Expect(1, 8233, '\p{Bc=	 b}', "");
    Expect(0, 8233, '\p{^Bc=	 b}', "");
    Expect(0, 8233, '\P{Bc=	 b}', "");
    Expect(1, 8233, '\P{^Bc=	 b}', "");
    Expect(0, 8234, '\p{Bc=	 b}', "");
    Expect(1, 8234, '\p{^Bc=	 b}', "");
    Expect(1, 8234, '\P{Bc=	 b}', "");
    Expect(0, 8234, '\P{^Bc=	 b}', "");
    Error('\p{Is_Bidi_Class=:=__Paragraph_separator}');
    Error('\P{Is_Bidi_Class=:=__Paragraph_separator}');
    Expect(1, 8233, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=		paragraph_SEPARATOR}', "");
    Error('\p{Is_Bc= b/a/}');
    Error('\P{Is_Bc= b/a/}');
    Expect(1, 8233, '\p{Is_Bc=b}', "");
    Expect(0, 8233, '\p{^Is_Bc=b}', "");
    Expect(0, 8233, '\P{Is_Bc=b}', "");
    Expect(1, 8233, '\P{^Is_Bc=b}', "");
    Expect(0, 8234, '\p{Is_Bc=b}', "");
    Expect(1, 8234, '\p{^Is_Bc=b}', "");
    Expect(1, 8234, '\P{Is_Bc=b}', "");
    Expect(0, 8234, '\P{^Is_Bc=b}', "");
    Expect(1, 8233, '\p{Is_Bc= 	B}', "");
    Expect(0, 8233, '\p{^Is_Bc= 	B}', "");
    Expect(0, 8233, '\P{Is_Bc= 	B}', "");
    Expect(1, 8233, '\P{^Is_Bc= 	B}', "");
    Expect(0, 8234, '\p{Is_Bc= 	B}', "");
    Expect(1, 8234, '\p{^Is_Bc= 	B}', "");
    Expect(1, 8234, '\P{Is_Bc= 	B}', "");
    Expect(0, 8234, '\P{^Is_Bc= 	B}', "");
    Error('\p{Bidi_Class= _Boundary_Neutral/a/}');
    Error('\P{Bidi_Class= _Boundary_Neutral/a/}');
    Expect(1, 921599, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(0, 921599, '\p{^Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(0, 921599, '\P{Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(1, 921599, '\P{^Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(0, 1114109, '\p{Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(1, 1114109, '\P{Bidi_Class=		Boundary_NEUTRAL}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=		Boundary_NEUTRAL}', "");
    Error('\p{Bc=__BN:=}');
    Error('\P{Bc=__BN:=}');
    Expect(1, 921599, '\p{Bc=:\ABN\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\ABN\z:}', "");;
    Expect(1, 921599, '\p{Bc=bn}', "");
    Expect(0, 921599, '\p{^Bc=bn}', "");
    Expect(0, 921599, '\P{Bc=bn}', "");
    Expect(1, 921599, '\P{^Bc=bn}', "");
    Expect(0, 1114109, '\p{Bc=bn}', "");
    Expect(1, 1114109, '\p{^Bc=bn}', "");
    Expect(1, 1114109, '\P{Bc=bn}', "");
    Expect(0, 1114109, '\P{^Bc=bn}', "");
    Expect(1, 921599, '\p{Bc=:\Abn\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\Abn\z:}', "");;
    Expect(1, 921599, '\p{Bc:   _	BN}', "");
    Expect(0, 921599, '\p{^Bc:   _	BN}', "");
    Expect(0, 921599, '\P{Bc:   _	BN}', "");
    Expect(1, 921599, '\P{^Bc:   _	BN}', "");
    Expect(0, 1114109, '\p{Bc:   _	BN}', "");
    Expect(1, 1114109, '\p{^Bc:   _	BN}', "");
    Expect(1, 1114109, '\P{Bc:   _	BN}', "");
    Expect(0, 1114109, '\P{^Bc:   _	BN}', "");
    Error('\p{Is_Bidi_Class=/a/boundary_neutral}');
    Error('\P{Is_Bidi_Class=/a/boundary_neutral}');
    Expect(1, 921599, '\p{Is_Bidi_Class:boundaryneutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class:boundaryneutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class:boundaryneutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class:boundaryneutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class:boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class:boundaryneutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class:boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class:boundaryneutral}', "");
    Expect(1, 921599, '\p{Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=_Boundary_NEUTRAL}', "");
    Error('\p{Is_Bc=_BN:=}');
    Error('\P{Is_Bc=_BN:=}');
    Expect(1, 921599, '\p{Is_Bc=bn}', "");
    Expect(0, 921599, '\p{^Is_Bc=bn}', "");
    Expect(0, 921599, '\P{Is_Bc=bn}', "");
    Expect(1, 921599, '\P{^Is_Bc=bn}', "");
    Expect(0, 1114109, '\p{Is_Bc=bn}', "");
    Expect(1, 1114109, '\p{^Is_Bc=bn}', "");
    Expect(1, 1114109, '\P{Is_Bc=bn}', "");
    Expect(0, 1114109, '\P{^Is_Bc=bn}', "");
    Expect(1, 921599, '\p{Is_Bc=- BN}', "");
    Expect(0, 921599, '\p{^Is_Bc=- BN}', "");
    Expect(0, 921599, '\P{Is_Bc=- BN}', "");
    Expect(1, 921599, '\P{^Is_Bc=- BN}', "");
    Expect(0, 1114109, '\p{Is_Bc=- BN}', "");
    Expect(1, 1114109, '\p{^Is_Bc=- BN}', "");
    Expect(1, 1114109, '\P{Is_Bc=- BN}', "");
    Expect(0, 1114109, '\P{^Is_Bc=- BN}', "");
    Error('\p{Bidi_Class=:=	common_separator}');
    Error('\P{Bidi_Class=:=	common_separator}');
    Expect(1, 65306, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class:	commonseparator}', "");
    Expect(0, 65306, '\p{^Bidi_Class:	commonseparator}', "");
    Expect(0, 65306, '\P{Bidi_Class:	commonseparator}', "");
    Expect(1, 65306, '\P{^Bidi_Class:	commonseparator}', "");
    Expect(0, 65307, '\p{Bidi_Class:	commonseparator}', "");
    Expect(1, 65307, '\p{^Bidi_Class:	commonseparator}', "");
    Expect(1, 65307, '\P{Bidi_Class:	commonseparator}', "");
    Expect(0, 65307, '\P{^Bidi_Class:	commonseparator}', "");
    Expect(1, 65306, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class=-_Common_Separator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=-_Common_Separator}', "");
    Expect(0, 65306, '\P{Bidi_Class=-_Common_Separator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=-_Common_Separator}', "");
    Expect(0, 65307, '\p{Bidi_Class=-_Common_Separator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=-_Common_Separator}', "");
    Expect(1, 65307, '\P{Bidi_Class=-_Common_Separator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=-_Common_Separator}', "");
    Error('\p{Bc= /a/CS}');
    Error('\P{Bc= /a/CS}');
    Expect(1, 65306, '\p{Bc=:\ACS\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\ACS\z:}', "");;
    Expect(1, 65306, '\p{Bc=cs}', "");
    Expect(0, 65306, '\p{^Bc=cs}', "");
    Expect(0, 65306, '\P{Bc=cs}', "");
    Expect(1, 65306, '\P{^Bc=cs}', "");
    Expect(0, 65307, '\p{Bc=cs}', "");
    Expect(1, 65307, '\p{^Bc=cs}', "");
    Expect(1, 65307, '\P{Bc=cs}', "");
    Expect(0, 65307, '\P{^Bc=cs}', "");
    Expect(1, 65306, '\p{Bc=:\Acs\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\Acs\z:}', "");;
    Expect(1, 65306, '\p{Bc:   _CS}', "");
    Expect(0, 65306, '\p{^Bc:   _CS}', "");
    Expect(0, 65306, '\P{Bc:   _CS}', "");
    Expect(1, 65306, '\P{^Bc:   _CS}', "");
    Expect(0, 65307, '\p{Bc:   _CS}', "");
    Expect(1, 65307, '\p{^Bc:   _CS}', "");
    Expect(1, 65307, '\P{Bc:   _CS}', "");
    Expect(0, 65307, '\P{^Bc:   _CS}', "");
    Error('\p{Is_Bidi_Class::=		Common_SEPARATOR}');
    Error('\P{Is_Bidi_Class::=		Common_SEPARATOR}');
    Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Is_Bidi_Class=	-common_Separator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=	-common_Separator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=	-common_Separator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=	-common_Separator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=	-common_Separator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=	-common_Separator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=	-common_Separator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=	-common_Separator}', "");
    Error('\p{Is_Bc:   :=	CS}');
    Error('\P{Is_Bc:   :=	CS}');
    Expect(1, 65306, '\p{Is_Bc=cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=cs}', "");
    Expect(0, 65306, '\P{Is_Bc=cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=cs}', "");
    Expect(0, 65307, '\p{Is_Bc=cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=cs}', "");
    Expect(1, 65307, '\P{Is_Bc=cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=cs}', "");
    Expect(1, 65306, '\p{Is_Bc=-CS}', "");
    Expect(0, 65306, '\p{^Is_Bc=-CS}', "");
    Expect(0, 65306, '\P{Is_Bc=-CS}', "");
    Expect(1, 65306, '\P{^Is_Bc=-CS}', "");
    Expect(0, 65307, '\p{Is_Bc=-CS}', "");
    Expect(1, 65307, '\p{^Is_Bc=-CS}', "");
    Expect(1, 65307, '\P{Is_Bc=-CS}', "");
    Expect(0, 65307, '\P{^Is_Bc=-CS}', "");
    Error('\p{Bidi_Class=/a/ _European_number}');
    Error('\P{Bidi_Class=/a/ _European_number}');
    Expect(1, 127242, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(0, 127243, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(1, 127242, '\p{Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\p{^Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\P{Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\P{^Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\p{Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\p{^Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\P{Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\P{^Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(0, 127243, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(1, 127242, '\p{Bidi_Class=- European_number}', "");
    Expect(0, 127242, '\p{^Bidi_Class=- European_number}', "");
    Expect(0, 127242, '\P{Bidi_Class=- European_number}', "");
    Expect(1, 127242, '\P{^Bidi_Class=- European_number}', "");
    Expect(0, 127243, '\p{Bidi_Class=- European_number}', "");
    Expect(1, 127243, '\p{^Bidi_Class=- European_number}', "");
    Expect(1, 127243, '\P{Bidi_Class=- European_number}', "");
    Expect(0, 127243, '\P{^Bidi_Class=- European_number}', "");
    Error('\p{Bc=_EN:=}');
    Error('\P{Bc=_EN:=}');
    Expect(1, 127242, '\p{Bc=:\AEN\z:}', "");;
    Expect(0, 127243, '\p{Bc=:\AEN\z:}', "");;
    Expect(1, 127242, '\p{Bc=en}', "");
    Expect(0, 127242, '\p{^Bc=en}', "");
    Expect(0, 127242, '\P{Bc=en}', "");
    Expect(1, 127242, '\P{^Bc=en}', "");
    Expect(0, 127243, '\p{Bc=en}', "");
    Expect(1, 127243, '\p{^Bc=en}', "");
    Expect(1, 127243, '\P{Bc=en}', "");
    Expect(0, 127243, '\P{^Bc=en}', "");
    Expect(1, 127242, '\p{Bc=:\Aen\z:}', "");;
    Expect(0, 127243, '\p{Bc=:\Aen\z:}', "");;
    Expect(1, 127242, '\p{Bc=_en}', "");
    Expect(0, 127242, '\p{^Bc=_en}', "");
    Expect(0, 127242, '\P{Bc=_en}', "");
    Expect(1, 127242, '\P{^Bc=_en}', "");
    Expect(0, 127243, '\p{Bc=_en}', "");
    Expect(1, 127243, '\p{^Bc=_en}', "");
    Expect(1, 127243, '\P{Bc=_en}', "");
    Expect(0, 127243, '\P{^Bc=_en}', "");
    Error('\p{Is_Bidi_Class=-/a/European_NUMBER}');
    Error('\P{Is_Bidi_Class=-/a/European_NUMBER}');
    Expect(1, 127242, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\p{Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 127242, '\p{^Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 127242, '\P{Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(1, 127242, '\P{^Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 127243, '\p{Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(1, 127243, '\p{^Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(1, 127243, '\P{Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 127243, '\P{^Is_Bidi_Class=_-EUROPEAN_Number}', "");
    Error('\p{Is_Bc=--en/a/}');
    Error('\P{Is_Bc=--en/a/}');
    Expect(1, 127242, '\p{Is_Bc=en}', "");
    Expect(0, 127242, '\p{^Is_Bc=en}', "");
    Expect(0, 127242, '\P{Is_Bc=en}', "");
    Expect(1, 127242, '\P{^Is_Bc=en}', "");
    Expect(0, 127243, '\p{Is_Bc=en}', "");
    Expect(1, 127243, '\p{^Is_Bc=en}', "");
    Expect(1, 127243, '\P{Is_Bc=en}', "");
    Expect(0, 127243, '\P{^Is_Bc=en}', "");
    Expect(1, 127242, '\p{Is_Bc=	EN}', "");
    Expect(0, 127242, '\p{^Is_Bc=	EN}', "");
    Expect(0, 127242, '\P{Is_Bc=	EN}', "");
    Expect(1, 127242, '\P{^Is_Bc=	EN}', "");
    Expect(0, 127243, '\p{Is_Bc=	EN}', "");
    Expect(1, 127243, '\p{^Is_Bc=	EN}', "");
    Expect(1, 127243, '\P{Is_Bc=	EN}', "");
    Expect(0, 127243, '\P{^Is_Bc=	EN}', "");
    Error('\p{Bidi_Class=	-European_separator:=}');
    Error('\P{Bidi_Class=	-European_separator:=}');
    Expect(1, 65293, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class:europeanseparator}', "");
    Expect(0, 65293, '\p{^Bidi_Class:europeanseparator}', "");
    Expect(0, 65293, '\P{Bidi_Class:europeanseparator}', "");
    Expect(1, 65293, '\P{^Bidi_Class:europeanseparator}', "");
    Expect(0, 65294, '\p{Bidi_Class:europeanseparator}', "");
    Expect(1, 65294, '\p{^Bidi_Class:europeanseparator}', "");
    Expect(1, 65294, '\P{Bidi_Class:europeanseparator}', "");
    Expect(0, 65294, '\P{^Bidi_Class:europeanseparator}', "");
    Expect(1, 65293, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=- European_Separator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=- European_Separator}', "");
    Expect(0, 65293, '\P{Bidi_Class=- European_Separator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=- European_Separator}', "");
    Expect(0, 65294, '\p{Bidi_Class=- European_Separator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=- European_Separator}', "");
    Expect(1, 65294, '\P{Bidi_Class=- European_Separator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=- European_Separator}', "");
    Error('\p{Bc=	/a/ES}');
    Error('\P{Bc=	/a/ES}');
    Expect(1, 65293, '\p{Bc=:\AES\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\AES\z:}', "");;
    Expect(1, 65293, '\p{Bc=es}', "");
    Expect(0, 65293, '\p{^Bc=es}', "");
    Expect(0, 65293, '\P{Bc=es}', "");
    Expect(1, 65293, '\P{^Bc=es}', "");
    Expect(0, 65294, '\p{Bc=es}', "");
    Expect(1, 65294, '\p{^Bc=es}', "");
    Expect(1, 65294, '\P{Bc=es}', "");
    Expect(0, 65294, '\P{^Bc=es}', "");
    Expect(1, 65293, '\p{Bc=:\Aes\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\Aes\z:}', "");;
    Expect(1, 65293, '\p{Bc=_-ES}', "");
    Expect(0, 65293, '\p{^Bc=_-ES}', "");
    Expect(0, 65293, '\P{Bc=_-ES}', "");
    Expect(1, 65293, '\P{^Bc=_-ES}', "");
    Expect(0, 65294, '\p{Bc=_-ES}', "");
    Expect(1, 65294, '\p{^Bc=_-ES}', "");
    Expect(1, 65294, '\P{Bc=_-ES}', "");
    Expect(0, 65294, '\P{^Bc=_-ES}', "");
    Error('\p{Is_Bidi_Class=/a/_-European_Separator}');
    Error('\P{Is_Bidi_Class=/a/_-European_Separator}');
    Expect(1, 65293, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Is_Bidi_Class=	-european_separator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=	-european_separator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=	-european_separator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=	-european_separator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=	-european_separator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=	-european_separator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=	-european_separator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=	-european_separator}', "");
    Error('\p{Is_Bc:-:=ES}');
    Error('\P{Is_Bc:-:=ES}');
    Expect(1, 65293, '\p{Is_Bc=es}', "");
    Expect(0, 65293, '\p{^Is_Bc=es}', "");
    Expect(0, 65293, '\P{Is_Bc=es}', "");
    Expect(1, 65293, '\P{^Is_Bc=es}', "");
    Expect(0, 65294, '\p{Is_Bc=es}', "");
    Expect(1, 65294, '\p{^Is_Bc=es}', "");
    Expect(1, 65294, '\P{Is_Bc=es}', "");
    Expect(0, 65294, '\P{^Is_Bc=es}', "");
    Expect(1, 65293, '\p{Is_Bc=	_ES}', "");
    Expect(0, 65293, '\p{^Is_Bc=	_ES}', "");
    Expect(0, 65293, '\P{Is_Bc=	_ES}', "");
    Expect(1, 65293, '\P{^Is_Bc=	_ES}', "");
    Expect(0, 65294, '\p{Is_Bc=	_ES}', "");
    Expect(1, 65294, '\p{^Is_Bc=	_ES}', "");
    Expect(1, 65294, '\P{Is_Bc=	_ES}', "");
    Expect(0, 65294, '\P{^Is_Bc=	_ES}', "");
    Error('\p{Bidi_Class=/a/__EUROPEAN_terminator}');
    Error('\P{Bidi_Class=/a/__EUROPEAN_terminator}');
    Expect(1, 123647, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class=	 european_terminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class=	 european_terminator}', "");
    Expect(0, 123647, '\P{Bidi_Class=	 european_terminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class=	 european_terminator}', "");
    Expect(0, 123648, '\p{Bidi_Class=	 european_terminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class=	 european_terminator}', "");
    Expect(1, 123648, '\P{Bidi_Class=	 european_terminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class=	 european_terminator}', "");
    Error('\p{Bc=_:=ET}');
    Error('\P{Bc=_:=ET}');
    Expect(1, 123647, '\p{Bc=:\AET\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\AET\z:}', "");;
    Expect(1, 123647, '\p{Bc:   et}', "");
    Expect(0, 123647, '\p{^Bc:   et}', "");
    Expect(0, 123647, '\P{Bc:   et}', "");
    Expect(1, 123647, '\P{^Bc:   et}', "");
    Expect(0, 123648, '\p{Bc:   et}', "");
    Expect(1, 123648, '\p{^Bc:   et}', "");
    Expect(1, 123648, '\P{Bc:   et}', "");
    Expect(0, 123648, '\P{^Bc:   et}', "");
    Expect(1, 123647, '\p{Bc=:\Aet\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\Aet\z:}', "");;
    Expect(1, 123647, '\p{Bc= _ET}', "");
    Expect(0, 123647, '\p{^Bc= _ET}', "");
    Expect(0, 123647, '\P{Bc= _ET}', "");
    Expect(1, 123647, '\P{^Bc= _ET}', "");
    Expect(0, 123648, '\p{Bc= _ET}', "");
    Expect(1, 123648, '\p{^Bc= _ET}', "");
    Expect(1, 123648, '\P{Bc= _ET}', "");
    Expect(0, 123648, '\P{^Bc= _ET}', "");
    Error('\p{Is_Bidi_Class= :=European_terminator}');
    Error('\P{Is_Bidi_Class= :=European_terminator}');
    Expect(1, 123647, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Is_Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class=-	European_Terminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class=-	European_Terminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class=-	European_Terminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class=-	European_Terminator}', "");
    Error('\p{Is_Bc=	ET/a/}');
    Error('\P{Is_Bc=	ET/a/}');
    Expect(1, 123647, '\p{Is_Bc=et}', "");
    Expect(0, 123647, '\p{^Is_Bc=et}', "");
    Expect(0, 123647, '\P{Is_Bc=et}', "");
    Expect(1, 123647, '\P{^Is_Bc=et}', "");
    Expect(0, 123648, '\p{Is_Bc=et}', "");
    Expect(1, 123648, '\p{^Is_Bc=et}', "");
    Expect(1, 123648, '\P{Is_Bc=et}', "");
    Expect(0, 123648, '\P{^Is_Bc=et}', "");
    Expect(1, 123647, '\p{Is_Bc=  et}', "");
    Expect(0, 123647, '\p{^Is_Bc=  et}', "");
    Expect(0, 123647, '\P{Is_Bc=  et}', "");
    Expect(1, 123647, '\P{^Is_Bc=  et}', "");
    Expect(0, 123648, '\p{Is_Bc=  et}', "");
    Expect(1, 123648, '\p{^Is_Bc=  et}', "");
    Expect(1, 123648, '\P{Is_Bc=  et}', "");
    Expect(0, 123648, '\P{^Is_Bc=  et}', "");
    Error('\p{Bidi_Class=	:=first_Strong_Isolate}');
    Error('\P{Bidi_Class=	:=first_Strong_Isolate}');
    Expect(1, 8296, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Bidi_Class= 	First_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class= 	First_Strong_Isolate}', "");
    Error('\p{Bc=	/a/FSI}');
    Error('\P{Bc=	/a/FSI}');
    Expect(1, 8296, '\p{Bc=:\AFSI\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\AFSI\z:}', "");;
    Expect(1, 8296, '\p{Bc=fsi}', "");
    Expect(0, 8296, '\p{^Bc=fsi}', "");
    Expect(0, 8296, '\P{Bc=fsi}', "");
    Expect(1, 8296, '\P{^Bc=fsi}', "");
    Expect(0, 8297, '\p{Bc=fsi}', "");
    Expect(1, 8297, '\p{^Bc=fsi}', "");
    Expect(1, 8297, '\P{Bc=fsi}', "");
    Expect(0, 8297, '\P{^Bc=fsi}', "");
    Expect(1, 8296, '\p{Bc=:\Afsi\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\Afsi\z:}', "");;
    Expect(1, 8296, '\p{Bc=- FSI}', "");
    Expect(0, 8296, '\p{^Bc=- FSI}', "");
    Expect(0, 8296, '\P{Bc=- FSI}', "");
    Expect(1, 8296, '\P{^Bc=- FSI}', "");
    Expect(0, 8297, '\p{Bc=- FSI}', "");
    Expect(1, 8297, '\p{^Bc=- FSI}', "");
    Expect(1, 8297, '\P{Bc=- FSI}', "");
    Expect(0, 8297, '\P{^Bc=- FSI}', "");
    Error('\p{Is_Bidi_Class=-First_STRONG_Isolate:=}');
    Error('\P{Is_Bidi_Class=-First_STRONG_Isolate:=}');
    Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=_first_Strong_Isolate}', "");
    Error('\p{Is_Bc=	:=FSI}');
    Error('\P{Is_Bc=	:=FSI}');
    Expect(1, 8296, '\p{Is_Bc=fsi}', "");
    Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
    Expect(0, 8296, '\P{Is_Bc=fsi}', "");
    Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
    Expect(0, 8297, '\p{Is_Bc=fsi}', "");
    Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
    Expect(1, 8297, '\P{Is_Bc=fsi}', "");
    Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
    Expect(1, 8296, '\p{Is_Bc=_-FSI}', "");
    Expect(0, 8296, '\p{^Is_Bc=_-FSI}', "");
    Expect(0, 8296, '\P{Is_Bc=_-FSI}', "");
    Expect(1, 8296, '\P{^Is_Bc=_-FSI}', "");
    Expect(0, 8297, '\p{Is_Bc=_-FSI}', "");
    Expect(1, 8297, '\p{^Is_Bc=_-FSI}', "");
    Expect(1, 8297, '\P{Is_Bc=_-FSI}', "");
    Expect(0, 8297, '\P{^Is_Bc=_-FSI}', "");
    Error('\p{Bidi_Class= 	LEFT_To_Right/a/}');
    Error('\P{Bidi_Class= 	LEFT_To_Right/a/}');
    Expect(1, 1114109, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=- Left_To_Right}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=- Left_To_Right}', "");
    Expect(0, 1114109, '\P{Bidi_Class=- Left_To_Right}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=- Left_To_Right}', "");
    Expect(0, 921599, '\p{Bidi_Class=- Left_To_Right}', "");
    Expect(1, 921599, '\p{^Bidi_Class=- Left_To_Right}', "");
    Expect(1, 921599, '\P{Bidi_Class=- Left_To_Right}', "");
    Expect(0, 921599, '\P{^Bidi_Class=- Left_To_Right}', "");
    Error('\p{Bc=_ L:=}');
    Error('\P{Bc=_ L:=}');
    Expect(1, 1114109, '\p{Bc=:\AL\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\AL\z:}', "");;
    Expect(1, 1114109, '\p{Bc=l}', "");
    Expect(0, 1114109, '\p{^Bc=l}', "");
    Expect(0, 1114109, '\P{Bc=l}', "");
    Expect(1, 1114109, '\P{^Bc=l}', "");
    Expect(0, 921599, '\p{Bc=l}', "");
    Expect(1, 921599, '\p{^Bc=l}', "");
    Expect(1, 921599, '\P{Bc=l}', "");
    Expect(0, 921599, '\P{^Bc=l}', "");
    Expect(1, 1114109, '\p{Bc=:\Al\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\Al\z:}', "");;
    Expect(1, 1114109, '\p{Bc=	 L}', "");
    Expect(0, 1114109, '\p{^Bc=	 L}', "");
    Expect(0, 1114109, '\P{Bc=	 L}', "");
    Expect(1, 1114109, '\P{^Bc=	 L}', "");
    Expect(0, 921599, '\p{Bc=	 L}', "");
    Expect(1, 921599, '\p{^Bc=	 L}', "");
    Expect(1, 921599, '\P{Bc=	 L}', "");
    Expect(0, 921599, '\P{^Bc=	 L}', "");
    Error('\p{Is_Bidi_Class=/a/-_Left_to_Right}');
    Error('\P{Is_Bidi_Class=/a/-_Left_to_Right}');
    Expect(1, 1114109, '\p{Is_Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class: _-LEFT_To_right}', "");
    Error('\p{Is_Bc:_/a/l}');
    Error('\P{Is_Bc:_/a/l}');
    Expect(1, 1114109, '\p{Is_Bc=l}', "");
    Expect(0, 1114109, '\p{^Is_Bc=l}', "");
    Expect(0, 1114109, '\P{Is_Bc=l}', "");
    Expect(1, 1114109, '\P{^Is_Bc=l}', "");
    Expect(0, 921599, '\p{Is_Bc=l}', "");
    Expect(1, 921599, '\p{^Is_Bc=l}', "");
    Expect(1, 921599, '\P{Is_Bc=l}', "");
    Expect(0, 921599, '\P{^Is_Bc=l}', "");
    Expect(1, 1114109, '\p{Is_Bc= _L}', "");
    Expect(0, 1114109, '\p{^Is_Bc= _L}', "");
    Expect(0, 1114109, '\P{Is_Bc= _L}', "");
    Expect(1, 1114109, '\P{^Is_Bc= _L}', "");
    Expect(0, 921599, '\p{Is_Bc= _L}', "");
    Expect(1, 921599, '\p{^Is_Bc= _L}', "");
    Expect(1, 921599, '\P{Is_Bc= _L}', "");
    Expect(0, 921599, '\P{^Is_Bc= _L}', "");
    Error('\p{Bidi_Class= /a/left_to_right_EMBEDDING}');
    Error('\P{Bidi_Class= /a/left_to_right_EMBEDDING}');
    Expect(1, 8234, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=left_TO_RIGHT_embedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=left_TO_RIGHT_embedding}', "");
    Error('\p{Bc=-	LRE/a/}');
    Error('\P{Bc=-	LRE/a/}');
    Expect(1, 8234, '\p{Bc=:\ALRE\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\ALRE\z:}', "");;
    Expect(1, 8234, '\p{Bc=lre}', "");
    Expect(0, 8234, '\p{^Bc=lre}', "");
    Expect(0, 8234, '\P{Bc=lre}', "");
    Expect(1, 8234, '\P{^Bc=lre}', "");
    Expect(0, 8235, '\p{Bc=lre}', "");
    Expect(1, 8235, '\p{^Bc=lre}', "");
    Expect(1, 8235, '\P{Bc=lre}', "");
    Expect(0, 8235, '\P{^Bc=lre}', "");
    Expect(1, 8234, '\p{Bc=:\Alre\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\Alre\z:}', "");;
    Expect(1, 8234, '\p{Bc=-LRE}', "");
    Expect(0, 8234, '\p{^Bc=-LRE}', "");
    Expect(0, 8234, '\P{Bc=-LRE}', "");
    Expect(1, 8234, '\P{^Bc=-LRE}', "");
    Expect(0, 8235, '\p{Bc=-LRE}', "");
    Expect(1, 8235, '\p{^Bc=-LRE}', "");
    Expect(1, 8235, '\P{Bc=-LRE}', "");
    Expect(0, 8235, '\P{^Bc=-LRE}', "");
    Error('\p{Is_Bidi_Class=:=	_left_to_Right_EMBEDDING}');
    Error('\P{Is_Bidi_Class=:=	_left_to_Right_EMBEDDING}');
    Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=- left_to_right_embedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=- left_to_right_embedding}', "");
    Error('\p{Is_Bc:   		LRE:=}');
    Error('\P{Is_Bc:   		LRE:=}');
    Expect(1, 8234, '\p{Is_Bc=lre}', "");
    Expect(0, 8234, '\p{^Is_Bc=lre}', "");
    Expect(0, 8234, '\P{Is_Bc=lre}', "");
    Expect(1, 8234, '\P{^Is_Bc=lre}', "");
    Expect(0, 8235, '\p{Is_Bc=lre}', "");
    Expect(1, 8235, '\p{^Is_Bc=lre}', "");
    Expect(1, 8235, '\P{Is_Bc=lre}', "");
    Expect(0, 8235, '\P{^Is_Bc=lre}', "");
    Expect(1, 8234, '\p{Is_Bc=-lre}', "");
    Expect(0, 8234, '\p{^Is_Bc=-lre}', "");
    Expect(0, 8234, '\P{Is_Bc=-lre}', "");
    Expect(1, 8234, '\P{^Is_Bc=-lre}', "");
    Expect(0, 8235, '\p{Is_Bc=-lre}', "");
    Expect(1, 8235, '\p{^Is_Bc=-lre}', "");
    Expect(1, 8235, '\P{Is_Bc=-lre}', "");
    Expect(0, 8235, '\P{^Is_Bc=-lre}', "");
    Error('\p{Bidi_Class=_	Left_To_RIGHT_ISOLATE/a/}');
    Error('\P{Bidi_Class=_	Left_To_RIGHT_ISOLATE/a/}');
    Expect(1, 8294, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(0, 8294, '\p{^Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(0, 8294, '\P{Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(1, 8294, '\P{^Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(0, 8295, '\p{Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(1, 8295, '\p{^Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(1, 8295, '\P{Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Expect(0, 8295, '\P{^Bidi_Class= LEFT_to_Right_ISOLATE}', "");
    Error('\p{Bc=		lri/a/}');
    Error('\P{Bc=		lri/a/}');
    Expect(1, 8294, '\p{Bc=:\ALRI\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\ALRI\z:}', "");;
    Expect(1, 8294, '\p{Bc=lri}', "");
    Expect(0, 8294, '\p{^Bc=lri}', "");
    Expect(0, 8294, '\P{Bc=lri}', "");
    Expect(1, 8294, '\P{^Bc=lri}', "");
    Expect(0, 8295, '\p{Bc=lri}', "");
    Expect(1, 8295, '\p{^Bc=lri}', "");
    Expect(1, 8295, '\P{Bc=lri}', "");
    Expect(0, 8295, '\P{^Bc=lri}', "");
    Expect(1, 8294, '\p{Bc=:\Alri\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\Alri\z:}', "");;
    Expect(1, 8294, '\p{Bc=-lri}', "");
    Expect(0, 8294, '\p{^Bc=-lri}', "");
    Expect(0, 8294, '\P{Bc=-lri}', "");
    Expect(1, 8294, '\P{^Bc=-lri}', "");
    Expect(0, 8295, '\p{Bc=-lri}', "");
    Expect(1, 8295, '\p{^Bc=-lri}', "");
    Expect(1, 8295, '\P{Bc=-lri}', "");
    Expect(0, 8295, '\P{^Bc=-lri}', "");
    Error('\p{Is_Bidi_Class=/a/Left_TO_right_ISOLATE}');
    Error('\P{Is_Bidi_Class=/a/Left_TO_right_ISOLATE}');
    Expect(1, 8294, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=		left_To_right_Isolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=		left_To_right_Isolate}', "");
    Error('\p{Is_Bc=/a/	-lri}');
    Error('\P{Is_Bc=/a/	-lri}');
    Expect(1, 8294, '\p{Is_Bc=lri}', "");
    Expect(0, 8294, '\p{^Is_Bc=lri}', "");
    Expect(0, 8294, '\P{Is_Bc=lri}', "");
    Expect(1, 8294, '\P{^Is_Bc=lri}', "");
    Expect(0, 8295, '\p{Is_Bc=lri}', "");
    Expect(1, 8295, '\p{^Is_Bc=lri}', "");
    Expect(1, 8295, '\P{Is_Bc=lri}', "");
    Expect(0, 8295, '\P{^Is_Bc=lri}', "");
    Expect(1, 8294, '\p{Is_Bc=__LRI}', "");
    Expect(0, 8294, '\p{^Is_Bc=__LRI}', "");
    Expect(0, 8294, '\P{Is_Bc=__LRI}', "");
    Expect(1, 8294, '\P{^Is_Bc=__LRI}', "");
    Expect(0, 8295, '\p{Is_Bc=__LRI}', "");
    Expect(1, 8295, '\p{^Is_Bc=__LRI}', "");
    Expect(1, 8295, '\P{Is_Bc=__LRI}', "");
    Expect(0, 8295, '\P{^Is_Bc=__LRI}', "");
    Error('\p{Bidi_Class=- Left_TO_Right_Override/a/}');
    Error('\P{Bidi_Class=- Left_TO_Right_Override/a/}');
    Expect(1, 8237, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class: -_Left_To_right_override}', "");
    Expect(0, 8237, '\p{^Bidi_Class: -_Left_To_right_override}', "");
    Expect(0, 8237, '\P{Bidi_Class: -_Left_To_right_override}', "");
    Expect(1, 8237, '\P{^Bidi_Class: -_Left_To_right_override}', "");
    Expect(0, 8238, '\p{Bidi_Class: -_Left_To_right_override}', "");
    Expect(1, 8238, '\p{^Bidi_Class: -_Left_To_right_override}', "");
    Expect(1, 8238, '\P{Bidi_Class: -_Left_To_right_override}', "");
    Expect(0, 8238, '\P{^Bidi_Class: -_Left_To_right_override}', "");
    Error('\p{Bc=	LRO:=}');
    Error('\P{Bc=	LRO:=}');
    Expect(1, 8237, '\p{Bc=:\ALRO\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\ALRO\z:}', "");;
    Expect(1, 8237, '\p{Bc=lro}', "");
    Expect(0, 8237, '\p{^Bc=lro}', "");
    Expect(0, 8237, '\P{Bc=lro}', "");
    Expect(1, 8237, '\P{^Bc=lro}', "");
    Expect(0, 8238, '\p{Bc=lro}', "");
    Expect(1, 8238, '\p{^Bc=lro}', "");
    Expect(1, 8238, '\P{Bc=lro}', "");
    Expect(0, 8238, '\P{^Bc=lro}', "");
    Expect(1, 8237, '\p{Bc=:\Alro\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\Alro\z:}', "");;
    Expect(1, 8237, '\p{Bc= _lro}', "");
    Expect(0, 8237, '\p{^Bc= _lro}', "");
    Expect(0, 8237, '\P{Bc= _lro}', "");
    Expect(1, 8237, '\P{^Bc= _lro}', "");
    Expect(0, 8238, '\p{Bc= _lro}', "");
    Expect(1, 8238, '\p{^Bc= _lro}', "");
    Expect(1, 8238, '\P{Bc= _lro}', "");
    Expect(0, 8238, '\P{^Bc= _lro}', "");
    Error('\p{Is_Bidi_Class=/a/  Left_TO_right_Override}');
    Error('\P{Is_Bidi_Class=/a/  Left_TO_right_Override}');
    Expect(1, 8237, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=--Left_To_RIGHT_OVERRIDE}', "");
    Error('\p{Is_Bc: _/a/LRO}');
    Error('\P{Is_Bc: _/a/LRO}');
    Expect(1, 8237, '\p{Is_Bc=lro}', "");
    Expect(0, 8237, '\p{^Is_Bc=lro}', "");
    Expect(0, 8237, '\P{Is_Bc=lro}', "");
    Expect(1, 8237, '\P{^Is_Bc=lro}', "");
    Expect(0, 8238, '\p{Is_Bc=lro}', "");
    Expect(1, 8238, '\p{^Is_Bc=lro}', "");
    Expect(1, 8238, '\P{Is_Bc=lro}', "");
    Expect(0, 8238, '\P{^Is_Bc=lro}', "");
    Expect(1, 8237, '\p{Is_Bc=_LRO}', "");
    Expect(0, 8237, '\p{^Is_Bc=_LRO}', "");
    Expect(0, 8237, '\P{Is_Bc=_LRO}', "");
    Expect(1, 8237, '\P{^Is_Bc=_LRO}', "");
    Expect(0, 8238, '\p{Is_Bc=_LRO}', "");
    Expect(1, 8238, '\p{^Is_Bc=_LRO}', "");
    Expect(1, 8238, '\P{Is_Bc=_LRO}', "");
    Expect(0, 8238, '\P{^Is_Bc=_LRO}', "");
    Error('\p{Bidi_Class:--NONSPACING_Mark:=}');
    Error('\P{Bidi_Class:--NONSPACING_Mark:=}');
    Expect(1, 917999, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=-nonspacing_Mark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=-nonspacing_Mark}', "");
    Expect(0, 917999, '\P{Bidi_Class=-nonspacing_Mark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=-nonspacing_Mark}', "");
    Expect(0, 918000, '\p{Bidi_Class=-nonspacing_Mark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=-nonspacing_Mark}', "");
    Expect(1, 918000, '\P{Bidi_Class=-nonspacing_Mark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=-nonspacing_Mark}', "");
    Error('\p{Bc=_NSM/a/}');
    Error('\P{Bc=_NSM/a/}');
    Expect(1, 917999, '\p{Bc=:\ANSM\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\ANSM\z:}', "");;
    Expect(1, 917999, '\p{Bc=nsm}', "");
    Expect(0, 917999, '\p{^Bc=nsm}', "");
    Expect(0, 917999, '\P{Bc=nsm}', "");
    Expect(1, 917999, '\P{^Bc=nsm}', "");
    Expect(0, 918000, '\p{Bc=nsm}', "");
    Expect(1, 918000, '\p{^Bc=nsm}', "");
    Expect(1, 918000, '\P{Bc=nsm}', "");
    Expect(0, 918000, '\P{^Bc=nsm}', "");
    Expect(1, 917999, '\p{Bc=:\Ansm\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\Ansm\z:}', "");;
    Expect(1, 917999, '\p{Bc:		-NSM}', "");
    Expect(0, 917999, '\p{^Bc:		-NSM}', "");
    Expect(0, 917999, '\P{Bc:		-NSM}', "");
    Expect(1, 917999, '\P{^Bc:		-NSM}', "");
    Expect(0, 918000, '\p{Bc:		-NSM}', "");
    Expect(1, 918000, '\p{^Bc:		-NSM}', "");
    Expect(1, 918000, '\P{Bc:		-NSM}', "");
    Expect(0, 918000, '\P{^Bc:		-NSM}', "");
    Error('\p{Is_Bidi_Class=_:=Nonspacing_Mark}');
    Error('\P{Is_Bidi_Class=_:=Nonspacing_Mark}');
    Expect(1, 917999, '\p{Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=  NONSPACING_Mark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=  NONSPACING_Mark}', "");
    Error('\p{Is_Bc= NSM/a/}');
    Error('\P{Is_Bc= NSM/a/}');
    Expect(1, 917999, '\p{Is_Bc=nsm}', "");
    Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
    Expect(0, 917999, '\P{Is_Bc=nsm}', "");
    Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
    Expect(0, 918000, '\p{Is_Bc=nsm}', "");
    Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
    Expect(1, 918000, '\P{Is_Bc=nsm}', "");
    Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
    Expect(1, 917999, '\p{Is_Bc=_-NSM}', "");
    Expect(0, 917999, '\p{^Is_Bc=_-NSM}', "");
    Expect(0, 917999, '\P{Is_Bc=_-NSM}', "");
    Expect(1, 917999, '\P{^Is_Bc=_-NSM}', "");
    Expect(0, 918000, '\p{Is_Bc=_-NSM}', "");
    Expect(1, 918000, '\p{^Is_Bc=_-NSM}', "");
    Expect(1, 918000, '\P{Is_Bc=_-NSM}', "");
    Expect(0, 918000, '\P{^Is_Bc=_-NSM}', "");
    Error('\p{Bidi_Class=_:=other_neutral}');
    Error('\P{Bidi_Class=_:=other_neutral}');
    Expect(1, 129685, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(0, 129686, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(1, 129685, '\p{Bidi_Class=otherneutral}', "");
    Expect(0, 129685, '\p{^Bidi_Class=otherneutral}', "");
    Expect(0, 129685, '\P{Bidi_Class=otherneutral}', "");
    Expect(1, 129685, '\P{^Bidi_Class=otherneutral}', "");
    Expect(0, 129686, '\p{Bidi_Class=otherneutral}', "");
    Expect(1, 129686, '\p{^Bidi_Class=otherneutral}', "");
    Expect(1, 129686, '\P{Bidi_Class=otherneutral}', "");
    Expect(0, 129686, '\P{^Bidi_Class=otherneutral}', "");
    Expect(1, 129685, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(0, 129686, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(1, 129685, '\p{Bidi_Class=	-other_NEUTRAL}', "");
    Expect(0, 129685, '\p{^Bidi_Class=	-other_NEUTRAL}', "");
    Expect(0, 129685, '\P{Bidi_Class=	-other_NEUTRAL}', "");
    Expect(1, 129685, '\P{^Bidi_Class=	-other_NEUTRAL}', "");
    Expect(0, 129686, '\p{Bidi_Class=	-other_NEUTRAL}', "");
    Expect(1, 129686, '\p{^Bidi_Class=	-other_NEUTRAL}', "");
    Expect(1, 129686, '\P{Bidi_Class=	-other_NEUTRAL}', "");
    Expect(0, 129686, '\P{^Bidi_Class=	-other_NEUTRAL}', "");
    Error('\p{Bc:    on/a/}');
    Error('\P{Bc:    on/a/}');
    Expect(1, 129685, '\p{Bc=:\AON\z:}', "");;
    Expect(0, 129686, '\p{Bc=:\AON\z:}', "");;
    Expect(1, 129685, '\p{Bc:	on}', "");
    Expect(0, 129685, '\p{^Bc:	on}', "");
    Expect(0, 129685, '\P{Bc:	on}', "");
    Expect(1, 129685, '\P{^Bc:	on}', "");
    Expect(0, 129686, '\p{Bc:	on}', "");
    Expect(1, 129686, '\p{^Bc:	on}', "");
    Expect(1, 129686, '\P{Bc:	on}', "");
    Expect(0, 129686, '\P{^Bc:	on}', "");
    Expect(1, 129685, '\p{Bc=:\Aon\z:}', "");;
    Expect(0, 129686, '\p{Bc=:\Aon\z:}', "");;
    Expect(1, 129685, '\p{Bc=-on}', "");
    Expect(0, 129685, '\p{^Bc=-on}', "");
    Expect(0, 129685, '\P{Bc=-on}', "");
    Expect(1, 129685, '\P{^Bc=-on}', "");
    Expect(0, 129686, '\p{Bc=-on}', "");
    Expect(1, 129686, '\p{^Bc=-on}', "");
    Expect(1, 129686, '\P{Bc=-on}', "");
    Expect(0, 129686, '\P{^Bc=-on}', "");
    Error('\p{Is_Bidi_Class=:=	 Other_neutral}');
    Error('\P{Is_Bidi_Class=:=	 Other_neutral}');
    Expect(1, 129685, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129685, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129685, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129685, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129686, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129686, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129686, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129686, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129685, '\p{Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(0, 129685, '\p{^Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(0, 129685, '\P{Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(1, 129685, '\P{^Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(0, 129686, '\p{Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(1, 129686, '\p{^Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(1, 129686, '\P{Is_Bidi_Class=_other_NEUTRAL}', "");
    Expect(0, 129686, '\P{^Is_Bidi_Class=_other_NEUTRAL}', "");
    Error('\p{Is_Bc=/a/- ON}');
    Error('\P{Is_Bc=/a/- ON}');
    Expect(1, 129685, '\p{Is_Bc=on}', "");
    Expect(0, 129685, '\p{^Is_Bc=on}', "");
    Expect(0, 129685, '\P{Is_Bc=on}', "");
    Expect(1, 129685, '\P{^Is_Bc=on}', "");
    Expect(0, 129686, '\p{Is_Bc=on}', "");
    Expect(1, 129686, '\p{^Is_Bc=on}', "");
    Expect(1, 129686, '\P{Is_Bc=on}', "");
    Expect(0, 129686, '\P{^Is_Bc=on}', "");
    Expect(1, 129685, '\p{Is_Bc=-ON}', "");
    Expect(0, 129685, '\p{^Is_Bc=-ON}', "");
    Expect(0, 129685, '\P{Is_Bc=-ON}', "");
    Expect(1, 129685, '\P{^Is_Bc=-ON}', "");
    Expect(0, 129686, '\p{Is_Bc=-ON}', "");
    Expect(1, 129686, '\p{^Is_Bc=-ON}', "");
    Expect(1, 129686, '\P{Is_Bc=-ON}', "");
    Expect(0, 129686, '\P{^Is_Bc=-ON}', "");
    Error('\p{Bidi_Class:-:=Pop_Directional_Format}');
    Error('\P{Bidi_Class:-:=Pop_Directional_Format}');
    Expect(1, 8236, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class:   	POP_Directional_Format}', "");
    Expect(0, 8236, '\p{^Bidi_Class:   	POP_Directional_Format}', "");
    Expect(0, 8236, '\P{Bidi_Class:   	POP_Directional_Format}', "");
    Expect(1, 8236, '\P{^Bidi_Class:   	POP_Directional_Format}', "");
    Expect(0, 8237, '\p{Bidi_Class:   	POP_Directional_Format}', "");
    Expect(1, 8237, '\p{^Bidi_Class:   	POP_Directional_Format}', "");
    Expect(1, 8237, '\P{Bidi_Class:   	POP_Directional_Format}', "");
    Expect(0, 8237, '\P{^Bidi_Class:   	POP_Directional_Format}', "");
    Error('\p{Bc=_/a/PDF}');
    Error('\P{Bc=_/a/PDF}');
    Expect(1, 8236, '\p{Bc=:\APDF\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\APDF\z:}', "");;
    Expect(1, 8236, '\p{Bc=pdf}', "");
    Expect(0, 8236, '\p{^Bc=pdf}', "");
    Expect(0, 8236, '\P{Bc=pdf}', "");
    Expect(1, 8236, '\P{^Bc=pdf}', "");
    Expect(0, 8237, '\p{Bc=pdf}', "");
    Expect(1, 8237, '\p{^Bc=pdf}', "");
    Expect(1, 8237, '\P{Bc=pdf}', "");
    Expect(0, 8237, '\P{^Bc=pdf}', "");
    Expect(1, 8236, '\p{Bc=:\Apdf\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\Apdf\z:}', "");;
    Expect(1, 8236, '\p{Bc= _PDF}', "");
    Expect(0, 8236, '\p{^Bc= _PDF}', "");
    Expect(0, 8236, '\P{Bc= _PDF}', "");
    Expect(1, 8236, '\P{^Bc= _PDF}', "");
    Expect(0, 8237, '\p{Bc= _PDF}', "");
    Expect(1, 8237, '\p{^Bc= _PDF}', "");
    Expect(1, 8237, '\P{Bc= _PDF}', "");
    Expect(0, 8237, '\P{^Bc= _PDF}', "");
    Error('\p{Is_Bidi_Class=	:=Pop_DIRECTIONAL_FORMAT}');
    Error('\P{Is_Bidi_Class=	:=Pop_DIRECTIONAL_FORMAT}');
    Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class= -Pop_DIRECTIONAL_format}', "");
    Error('\p{Is_Bc=-:=PDF}');
    Error('\P{Is_Bc=-:=PDF}');
    Expect(1, 8236, '\p{Is_Bc=pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=pdf}', "");
    Expect(1, 8236, '\p{Is_Bc=	_PDF}', "");
    Expect(0, 8236, '\p{^Is_Bc=	_PDF}', "");
    Expect(0, 8236, '\P{Is_Bc=	_PDF}', "");
    Expect(1, 8236, '\P{^Is_Bc=	_PDF}', "");
    Expect(0, 8237, '\p{Is_Bc=	_PDF}', "");
    Expect(1, 8237, '\p{^Is_Bc=	_PDF}', "");
    Expect(1, 8237, '\P{Is_Bc=	_PDF}', "");
    Expect(0, 8237, '\P{^Is_Bc=	_PDF}', "");
    Error('\p{Bidi_Class=_ pop_directional_isolate/a/}');
    Error('\P{Bidi_Class=_ pop_directional_isolate/a/}');
    Expect(1, 8297, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(0, 8297, '\P{Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(0, 8298, '\p{Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(1, 8298, '\P{Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class:- Pop_DIRECTIONAL_Isolate}', "");
    Error('\p{Bc=	pdi/a/}');
    Error('\P{Bc=	pdi/a/}');
    Expect(1, 8297, '\p{Bc=:\APDI\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\APDI\z:}', "");;
    Expect(1, 8297, '\p{Bc=pdi}', "");
    Expect(0, 8297, '\p{^Bc=pdi}', "");
    Expect(0, 8297, '\P{Bc=pdi}', "");
    Expect(1, 8297, '\P{^Bc=pdi}', "");
    Expect(0, 8298, '\p{Bc=pdi}', "");
    Expect(1, 8298, '\p{^Bc=pdi}', "");
    Expect(1, 8298, '\P{Bc=pdi}', "");
    Expect(0, 8298, '\P{^Bc=pdi}', "");
    Expect(1, 8297, '\p{Bc=:\Apdi\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\Apdi\z:}', "");;
    Expect(1, 8297, '\p{Bc=		PDI}', "");
    Expect(0, 8297, '\p{^Bc=		PDI}', "");
    Expect(0, 8297, '\P{Bc=		PDI}', "");
    Expect(1, 8297, '\P{^Bc=		PDI}', "");
    Expect(0, 8298, '\p{Bc=		PDI}', "");
    Expect(1, 8298, '\p{^Bc=		PDI}', "");
    Expect(1, 8298, '\P{Bc=		PDI}', "");
    Expect(0, 8298, '\P{^Bc=		PDI}', "");
    Error('\p{Is_Bidi_Class=- Pop_Directional_ISOLATE/a/}');
    Error('\P{Is_Bidi_Class=- Pop_Directional_ISOLATE/a/}');
    Expect(1, 8297, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=		pop_Directional_isolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=		pop_Directional_isolate}', "");
    Error('\p{Is_Bc:   /a/- PDI}');
    Error('\P{Is_Bc:   /a/- PDI}');
    Expect(1, 8297, '\p{Is_Bc=pdi}', "");
    Expect(0, 8297, '\p{^Is_Bc=pdi}', "");
    Expect(0, 8297, '\P{Is_Bc=pdi}', "");
    Expect(1, 8297, '\P{^Is_Bc=pdi}', "");
    Expect(0, 8298, '\p{Is_Bc=pdi}', "");
    Expect(1, 8298, '\p{^Is_Bc=pdi}', "");
    Expect(1, 8298, '\P{Is_Bc=pdi}', "");
    Expect(0, 8298, '\P{^Is_Bc=pdi}', "");
    Expect(1, 8297, '\p{Is_Bc=_PDI}', "");
    Expect(0, 8297, '\p{^Is_Bc=_PDI}', "");
    Expect(0, 8297, '\P{Is_Bc=_PDI}', "");
    Expect(1, 8297, '\P{^Is_Bc=_PDI}', "");
    Expect(0, 8298, '\p{Is_Bc=_PDI}', "");
    Expect(1, 8298, '\p{^Is_Bc=_PDI}', "");
    Expect(1, 8298, '\P{Is_Bc=_PDI}', "");
    Expect(0, 8298, '\P{^Is_Bc=_PDI}', "");
    Error('\p{Bidi_Class=:=RIGHT_To_LEFT}');
    Error('\P{Bidi_Class=:=RIGHT_To_LEFT}');
    Expect(1, 126975, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class=	-Right_To_left}', "");
    Expect(0, 126975, '\p{^Bidi_Class=	-Right_To_left}', "");
    Expect(0, 126975, '\P{Bidi_Class=	-Right_To_left}', "");
    Expect(1, 126975, '\P{^Bidi_Class=	-Right_To_left}', "");
    Expect(0, 126976, '\p{Bidi_Class=	-Right_To_left}', "");
    Expect(1, 126976, '\p{^Bidi_Class=	-Right_To_left}', "");
    Expect(1, 126976, '\P{Bidi_Class=	-Right_To_left}', "");
    Expect(0, 126976, '\P{^Bidi_Class=	-Right_To_left}', "");
    Error('\p{Bc=-R:=}');
    Error('\P{Bc=-R:=}');
    Expect(1, 126975, '\p{Bc=:\AR\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\AR\z:}', "");;
    Expect(1, 126975, '\p{Bc=r}', "");
    Expect(0, 126975, '\p{^Bc=r}', "");
    Expect(0, 126975, '\P{Bc=r}', "");
    Expect(1, 126975, '\P{^Bc=r}', "");
    Expect(0, 126976, '\p{Bc=r}', "");
    Expect(1, 126976, '\p{^Bc=r}', "");
    Expect(1, 126976, '\P{Bc=r}', "");
    Expect(0, 126976, '\P{^Bc=r}', "");
    Expect(1, 126975, '\p{Bc=:\Ar\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\Ar\z:}', "");;
    Expect(1, 126975, '\p{Bc=--R}', "");
    Expect(0, 126975, '\p{^Bc=--R}', "");
    Expect(0, 126975, '\P{Bc=--R}', "");
    Expect(1, 126975, '\P{^Bc=--R}', "");
    Expect(0, 126976, '\p{Bc=--R}', "");
    Expect(1, 126976, '\p{^Bc=--R}', "");
    Expect(1, 126976, '\P{Bc=--R}', "");
    Expect(0, 126976, '\P{^Bc=--R}', "");
    Error('\p{Is_Bidi_Class=:=  RIGHT_TO_left}');
    Error('\P{Is_Bidi_Class=:=  RIGHT_TO_left}');
    Expect(1, 126975, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=  Right_To_LEFT}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=  Right_To_LEFT}', "");
    Error('\p{Is_Bc=:= R}');
    Error('\P{Is_Bc=:= R}');
    Expect(1, 126975, '\p{Is_Bc=r}', "");
    Expect(0, 126975, '\p{^Is_Bc=r}', "");
    Expect(0, 126975, '\P{Is_Bc=r}', "");
    Expect(1, 126975, '\P{^Is_Bc=r}', "");
    Expect(0, 126976, '\p{Is_Bc=r}', "");
    Expect(1, 126976, '\p{^Is_Bc=r}', "");
    Expect(1, 126976, '\P{Is_Bc=r}', "");
    Expect(0, 126976, '\P{^Is_Bc=r}', "");
    Expect(1, 126975, '\p{Is_Bc:	 R}', "");
    Expect(0, 126975, '\p{^Is_Bc:	 R}', "");
    Expect(0, 126975, '\P{Is_Bc:	 R}', "");
    Expect(1, 126975, '\P{^Is_Bc:	 R}', "");
    Expect(0, 126976, '\p{Is_Bc:	 R}', "");
    Expect(1, 126976, '\p{^Is_Bc:	 R}', "");
    Expect(1, 126976, '\P{Is_Bc:	 R}', "");
    Expect(0, 126976, '\P{^Is_Bc:	 R}', "");
    Error('\p{Bidi_Class=/a/ right_to_left_EMBEDDING}');
    Error('\P{Bidi_Class=/a/ right_to_left_EMBEDDING}');
    Expect(1, 8235, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(0, 8235, '\P{Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(0, 8236, '\p{Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(1, 8236, '\P{Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class= _RIGHT_to_LEFT_embedding}', "");
    Error('\p{Bc= 	RLE/a/}');
    Error('\P{Bc= 	RLE/a/}');
    Expect(1, 8235, '\p{Bc=:\ARLE\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\ARLE\z:}', "");;
    Expect(1, 8235, '\p{Bc=rle}', "");
    Expect(0, 8235, '\p{^Bc=rle}', "");
    Expect(0, 8235, '\P{Bc=rle}', "");
    Expect(1, 8235, '\P{^Bc=rle}', "");
    Expect(0, 8236, '\p{Bc=rle}', "");
    Expect(1, 8236, '\p{^Bc=rle}', "");
    Expect(1, 8236, '\P{Bc=rle}', "");
    Expect(0, 8236, '\P{^Bc=rle}', "");
    Expect(1, 8235, '\p{Bc=:\Arle\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\Arle\z:}', "");;
    Expect(1, 8235, '\p{Bc=_-RLE}', "");
    Expect(0, 8235, '\p{^Bc=_-RLE}', "");
    Expect(0, 8235, '\P{Bc=_-RLE}', "");
    Expect(1, 8235, '\P{^Bc=_-RLE}', "");
    Expect(0, 8236, '\p{Bc=_-RLE}', "");
    Expect(1, 8236, '\p{^Bc=_-RLE}', "");
    Expect(1, 8236, '\P{Bc=_-RLE}', "");
    Expect(0, 8236, '\P{^Bc=_-RLE}', "");
    Error('\p{Is_Bidi_Class=  Right_to_left_Embedding:=}');
    Error('\P{Is_Bidi_Class=  Right_to_left_Embedding:=}');
    Expect(1, 8235, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=	Right_TO_Left_EMBEDDING}', "");
    Error('\p{Is_Bc:	 	RLE:=}');
    Error('\P{Is_Bc:	 	RLE:=}');
    Expect(1, 8235, '\p{Is_Bc=rle}', "");
    Expect(0, 8235, '\p{^Is_Bc=rle}', "");
    Expect(0, 8235, '\P{Is_Bc=rle}', "");
    Expect(1, 8235, '\P{^Is_Bc=rle}', "");
    Expect(0, 8236, '\p{Is_Bc=rle}', "");
    Expect(1, 8236, '\p{^Is_Bc=rle}', "");
    Expect(1, 8236, '\P{Is_Bc=rle}', "");
    Expect(0, 8236, '\P{^Is_Bc=rle}', "");
    Expect(1, 8235, '\p{Is_Bc= _RLE}', "");
    Expect(0, 8235, '\p{^Is_Bc= _RLE}', "");
    Expect(0, 8235, '\P{Is_Bc= _RLE}', "");
    Expect(1, 8235, '\P{^Is_Bc= _RLE}', "");
    Expect(0, 8236, '\p{Is_Bc= _RLE}', "");
    Expect(1, 8236, '\p{^Is_Bc= _RLE}', "");
    Expect(1, 8236, '\P{Is_Bc= _RLE}', "");
    Expect(0, 8236, '\P{^Is_Bc= _RLE}', "");
    Error('\p{Bidi_Class=-/a/RIGHT_to_left_ISOLATE}');
    Error('\P{Bidi_Class=-/a/RIGHT_to_left_ISOLATE}');
    Expect(1, 8295, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=	_Right_TO_Left_isolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=	_Right_TO_Left_isolate}', "");
    Error('\p{Bc=:=_ rli}');
    Error('\P{Bc=:=_ rli}');
    Expect(1, 8295, '\p{Bc=:\ARLI\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\ARLI\z:}', "");;
    Expect(1, 8295, '\p{Bc:   rli}', "");
    Expect(0, 8295, '\p{^Bc:   rli}', "");
    Expect(0, 8295, '\P{Bc:   rli}', "");
    Expect(1, 8295, '\P{^Bc:   rli}', "");
    Expect(0, 8296, '\p{Bc:   rli}', "");
    Expect(1, 8296, '\p{^Bc:   rli}', "");
    Expect(1, 8296, '\P{Bc:   rli}', "");
    Expect(0, 8296, '\P{^Bc:   rli}', "");
    Expect(1, 8295, '\p{Bc=:\Arli\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\Arli\z:}', "");;
    Expect(1, 8295, '\p{Bc=	_RLI}', "");
    Expect(0, 8295, '\p{^Bc=	_RLI}', "");
    Expect(0, 8295, '\P{Bc=	_RLI}', "");
    Expect(1, 8295, '\P{^Bc=	_RLI}', "");
    Expect(0, 8296, '\p{Bc=	_RLI}', "");
    Expect(1, 8296, '\p{^Bc=	_RLI}', "");
    Expect(1, 8296, '\P{Bc=	_RLI}', "");
    Expect(0, 8296, '\P{^Bc=	_RLI}', "");
    Error('\p{Is_Bidi_Class=	:=Right_To_Left_Isolate}');
    Error('\P{Is_Bidi_Class=	:=Right_To_Left_Isolate}');
    Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=Right_TO_Left_Isolate}', "");
    Error('\p{Is_Bc= 	RLI:=}');
    Error('\P{Is_Bc= 	RLI:=}');
    Expect(1, 8295, '\p{Is_Bc=rli}', "");
    Expect(0, 8295, '\p{^Is_Bc=rli}', "");
    Expect(0, 8295, '\P{Is_Bc=rli}', "");
    Expect(1, 8295, '\P{^Is_Bc=rli}', "");
    Expect(0, 8296, '\p{Is_Bc=rli}', "");
    Expect(1, 8296, '\p{^Is_Bc=rli}', "");
    Expect(1, 8296, '\P{Is_Bc=rli}', "");
    Expect(0, 8296, '\P{^Is_Bc=rli}', "");
    Expect(1, 8295, '\p{Is_Bc= RLI}', "");
    Expect(0, 8295, '\p{^Is_Bc= RLI}', "");
    Expect(0, 8295, '\P{Is_Bc= RLI}', "");
    Expect(1, 8295, '\P{^Is_Bc= RLI}', "");
    Expect(0, 8296, '\p{Is_Bc= RLI}', "");
    Expect(1, 8296, '\p{^Is_Bc= RLI}', "");
    Expect(1, 8296, '\P{Is_Bc= RLI}', "");
    Expect(0, 8296, '\P{^Is_Bc= RLI}', "");
    Error('\p{Bidi_Class=_	Right_TO_Left_OVERRIDE:=}');
    Error('\P{Bidi_Class=_	Right_TO_Left_OVERRIDE:=}');
    Expect(1, 8238, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=--right_to_LEFT_override}', "");
    Expect(0, 8238, '\p{^Bidi_Class=--right_to_LEFT_override}', "");
    Expect(0, 8238, '\P{Bidi_Class=--right_to_LEFT_override}', "");
    Expect(1, 8238, '\P{^Bidi_Class=--right_to_LEFT_override}', "");
    Expect(0, 8239, '\p{Bidi_Class=--right_to_LEFT_override}', "");
    Expect(1, 8239, '\p{^Bidi_Class=--right_to_LEFT_override}', "");
    Expect(1, 8239, '\P{Bidi_Class=--right_to_LEFT_override}', "");
    Expect(0, 8239, '\P{^Bidi_Class=--right_to_LEFT_override}', "");
    Error('\p{Bc=/a/rlo}');
    Error('\P{Bc=/a/rlo}');
    Expect(1, 8238, '\p{Bc=:\ARLO\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\ARLO\z:}', "");;
    Expect(1, 8238, '\p{Bc=rlo}', "");
    Expect(0, 8238, '\p{^Bc=rlo}', "");
    Expect(0, 8238, '\P{Bc=rlo}', "");
    Expect(1, 8238, '\P{^Bc=rlo}', "");
    Expect(0, 8239, '\p{Bc=rlo}', "");
    Expect(1, 8239, '\p{^Bc=rlo}', "");
    Expect(1, 8239, '\P{Bc=rlo}', "");
    Expect(0, 8239, '\P{^Bc=rlo}', "");
    Expect(1, 8238, '\p{Bc=:\Arlo\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\Arlo\z:}', "");;
    Expect(1, 8238, '\p{Bc= RLO}', "");
    Expect(0, 8238, '\p{^Bc= RLO}', "");
    Expect(0, 8238, '\P{Bc= RLO}', "");
    Expect(1, 8238, '\P{^Bc= RLO}', "");
    Expect(0, 8239, '\p{Bc= RLO}', "");
    Expect(1, 8239, '\p{^Bc= RLO}', "");
    Expect(1, 8239, '\P{Bc= RLO}', "");
    Expect(0, 8239, '\P{^Bc= RLO}', "");
    Error('\p{Is_Bidi_Class:   :=-_Right_To_left_Override}');
    Error('\P{Is_Bidi_Class:   :=-_Right_To_left_Override}');
    Expect(1, 8238, '\p{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class: __Right_To_Left_override}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class: __Right_To_Left_override}', "");
    Error('\p{Is_Bc=	rlo/a/}');
    Error('\P{Is_Bc=	rlo/a/}');
    Expect(1, 8238, '\p{Is_Bc=rlo}', "");
    Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
    Expect(0, 8238, '\P{Is_Bc=rlo}', "");
    Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
    Expect(0, 8239, '\p{Is_Bc=rlo}', "");
    Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
    Expect(1, 8239, '\P{Is_Bc=rlo}', "");
    Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
    Expect(1, 8238, '\p{Is_Bc= 	RLO}', "");
    Expect(0, 8238, '\p{^Is_Bc= 	RLO}', "");
    Expect(0, 8238, '\P{Is_Bc= 	RLO}', "");
    Expect(1, 8238, '\P{^Is_Bc= 	RLO}', "");
    Expect(0, 8239, '\p{Is_Bc= 	RLO}', "");
    Expect(1, 8239, '\p{^Is_Bc= 	RLO}', "");
    Expect(1, 8239, '\P{Is_Bc= 	RLO}', "");
    Expect(0, 8239, '\P{^Is_Bc= 	RLO}', "");
    Error('\p{Bidi_Class:		/a/segment_Separator}');
    Error('\P{Bidi_Class:		/a/segment_Separator}');
    Expect(1, 31, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class=	segment_separator}', "");
    Expect(0, 31, '\p{^Bidi_Class=	segment_separator}', "");
    Expect(0, 31, '\P{Bidi_Class=	segment_separator}', "");
    Expect(1, 31, '\P{^Bidi_Class=	segment_separator}', "");
    Expect(0, 32, '\p{Bidi_Class=	segment_separator}', "");
    Expect(1, 32, '\p{^Bidi_Class=	segment_separator}', "");
    Expect(1, 32, '\P{Bidi_Class=	segment_separator}', "");
    Expect(0, 32, '\P{^Bidi_Class=	segment_separator}', "");
    Error('\p{Bc=_/a/s}');
    Error('\P{Bc=_/a/s}');
    Expect(1, 31, '\p{Bc=:\AS\z:}', "");;
    Expect(0, 32, '\p{Bc=:\AS\z:}', "");;
    Expect(1, 31, '\p{Bc=s}', "");
    Expect(0, 31, '\p{^Bc=s}', "");
    Expect(0, 31, '\P{Bc=s}', "");
    Expect(1, 31, '\P{^Bc=s}', "");
    Expect(0, 32, '\p{Bc=s}', "");
    Expect(1, 32, '\p{^Bc=s}', "");
    Expect(1, 32, '\P{Bc=s}', "");
    Expect(0, 32, '\P{^Bc=s}', "");
    Expect(1, 31, '\p{Bc=:\As\z:}', "");;
    Expect(0, 32, '\p{Bc=:\As\z:}', "");;
    Expect(1, 31, '\p{Bc=	-S}', "");
    Expect(0, 31, '\p{^Bc=	-S}', "");
    Expect(0, 31, '\P{Bc=	-S}', "");
    Expect(1, 31, '\P{^Bc=	-S}', "");
    Expect(0, 32, '\p{Bc=	-S}', "");
    Expect(1, 32, '\p{^Bc=	-S}', "");
    Expect(1, 32, '\P{Bc=	-S}', "");
    Expect(0, 32, '\P{^Bc=	-S}', "");
    Error('\p{Is_Bidi_Class=:=_ Segment_Separator}');
    Error('\P{Is_Bidi_Class=:=_ Segment_Separator}');
    Expect(1, 31, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=	SEGMENT_separator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=	SEGMENT_separator}', "");
    Error('\p{Is_Bc=  s/a/}');
    Error('\P{Is_Bc=  s/a/}');
    Expect(1, 31, '\p{Is_Bc:   s}', "");
    Expect(0, 31, '\p{^Is_Bc:   s}', "");
    Expect(0, 31, '\P{Is_Bc:   s}', "");
    Expect(1, 31, '\P{^Is_Bc:   s}', "");
    Expect(0, 32, '\p{Is_Bc:   s}', "");
    Expect(1, 32, '\p{^Is_Bc:   s}', "");
    Expect(1, 32, '\P{Is_Bc:   s}', "");
    Expect(0, 32, '\P{^Is_Bc:   s}', "");
    Expect(1, 31, '\p{Is_Bc=_	S}', "");
    Expect(0, 31, '\p{^Is_Bc=_	S}', "");
    Expect(0, 31, '\P{Is_Bc=_	S}', "");
    Expect(1, 31, '\P{^Is_Bc=_	S}', "");
    Expect(0, 32, '\p{Is_Bc=_	S}', "");
    Expect(1, 32, '\p{^Is_Bc=_	S}', "");
    Expect(1, 32, '\P{Is_Bc=_	S}', "");
    Expect(0, 32, '\P{^Is_Bc=_	S}', "");
    Error('\p{Bidi_Class=:=	-White_space}');
    Error('\P{Bidi_Class=:=	-White_space}');
    Expect(1, 12288, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class:   _-WHITE_Space}', "");
    Expect(0, 12288, '\p{^Bidi_Class:   _-WHITE_Space}', "");
    Expect(0, 12288, '\P{Bidi_Class:   _-WHITE_Space}', "");
    Expect(1, 12288, '\P{^Bidi_Class:   _-WHITE_Space}', "");
    Expect(0, 12289, '\p{Bidi_Class:   _-WHITE_Space}', "");
    Expect(1, 12289, '\p{^Bidi_Class:   _-WHITE_Space}', "");
    Expect(1, 12289, '\P{Bidi_Class:   _-WHITE_Space}', "");
    Expect(0, 12289, '\P{^Bidi_Class:   _-WHITE_Space}', "");
    Error('\p{Bc= :=WS}');
    Error('\P{Bc= :=WS}');
    Expect(1, 12288, '\p{Bc=:\AWS\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\AWS\z:}', "");;
    Expect(1, 12288, '\p{Bc=ws}', "");
    Expect(0, 12288, '\p{^Bc=ws}', "");
    Expect(0, 12288, '\P{Bc=ws}', "");
    Expect(1, 12288, '\P{^Bc=ws}', "");
    Expect(0, 12289, '\p{Bc=ws}', "");
    Expect(1, 12289, '\p{^Bc=ws}', "");
    Expect(1, 12289, '\P{Bc=ws}', "");
    Expect(0, 12289, '\P{^Bc=ws}', "");
    Expect(1, 12288, '\p{Bc=:\Aws\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\Aws\z:}', "");;
    Expect(1, 12288, '\p{Bc=__WS}', "");
    Expect(0, 12288, '\p{^Bc=__WS}', "");
    Expect(0, 12288, '\P{Bc=__WS}', "");
    Expect(1, 12288, '\P{^Bc=__WS}', "");
    Expect(0, 12289, '\p{Bc=__WS}', "");
    Expect(1, 12289, '\p{^Bc=__WS}', "");
    Expect(1, 12289, '\P{Bc=__WS}', "");
    Expect(0, 12289, '\P{^Bc=__WS}', "");
    Error('\p{Is_Bidi_Class: :=-white_SPACE}');
    Error('\P{Is_Bidi_Class: :=-white_SPACE}');
    Expect(1, 12288, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Is_Bidi_Class=	white_Space}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=	white_Space}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=	white_Space}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=	white_Space}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=	white_Space}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=	white_Space}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=	white_Space}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=	white_Space}', "");
    Error('\p{Is_Bc=	 WS/a/}');
    Error('\P{Is_Bc=	 WS/a/}');
    Expect(1, 12288, '\p{Is_Bc=ws}', "");
    Expect(0, 12288, '\p{^Is_Bc=ws}', "");
    Expect(0, 12288, '\P{Is_Bc=ws}', "");
    Expect(1, 12288, '\P{^Is_Bc=ws}', "");
    Expect(0, 12289, '\p{Is_Bc=ws}', "");
    Expect(1, 12289, '\p{^Is_Bc=ws}', "");
    Expect(1, 12289, '\P{Is_Bc=ws}', "");
    Expect(0, 12289, '\P{^Is_Bc=ws}', "");
    Expect(1, 12288, '\p{Is_Bc=WS}', "");
    Expect(0, 12288, '\p{^Is_Bc=WS}', "");
    Expect(0, 12288, '\P{Is_Bc=WS}', "");
    Expect(1, 12288, '\P{^Is_Bc=WS}', "");
    Expect(0, 12289, '\p{Is_Bc=WS}', "");
    Expect(1, 12289, '\p{^Is_Bc=WS}', "");
    Expect(1, 12289, '\P{Is_Bc=WS}', "");
    Expect(0, 12289, '\P{^Is_Bc=WS}', "");
    Error('\p{Bidi_Control=		No:=}');
    Error('\P{Bidi_Control=		No:=}');
    Expect(1, 8298, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=no}', "");
    Expect(0, 8298, '\p{^Bidi_Control=no}', "");
    Expect(0, 8298, '\P{Bidi_Control=no}', "");
    Expect(1, 8298, '\P{^Bidi_Control=no}', "");
    Expect(0, 8297, '\p{Bidi_Control=no}', "");
    Expect(1, 8297, '\p{^Bidi_Control=no}', "");
    Expect(1, 8297, '\P{Bidi_Control=no}', "");
    Expect(0, 8297, '\P{^Bidi_Control=no}', "");
    Expect(1, 8298, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=-No}', "");
    Expect(0, 8298, '\p{^Bidi_Control=-No}', "");
    Expect(0, 8298, '\P{Bidi_Control=-No}', "");
    Expect(1, 8298, '\P{^Bidi_Control=-No}', "");
    Expect(0, 8297, '\p{Bidi_Control=-No}', "");
    Expect(1, 8297, '\p{^Bidi_Control=-No}', "");
    Expect(1, 8297, '\P{Bidi_Control=-No}', "");
    Expect(0, 8297, '\P{^Bidi_Control=-No}', "");
    Error('\p{Bidi_C=-:=N}');
    Error('\P{Bidi_C=-:=N}');
    Expect(1, 8298, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C=n}', "");
    Expect(0, 8298, '\p{^Bidi_C=n}', "");
    Expect(0, 8298, '\P{Bidi_C=n}', "");
    Expect(1, 8298, '\P{^Bidi_C=n}', "");
    Expect(0, 8297, '\p{Bidi_C=n}', "");
    Expect(1, 8297, '\p{^Bidi_C=n}', "");
    Expect(1, 8297, '\P{Bidi_C=n}', "");
    Expect(0, 8297, '\P{^Bidi_C=n}', "");
    Expect(1, 8298, '\p{Bidi_C=:\An\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\An\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C= N}', "");
    Expect(0, 8298, '\p{^Bidi_C= N}', "");
    Expect(0, 8298, '\P{Bidi_C= N}', "");
    Expect(1, 8298, '\P{^Bidi_C= N}', "");
    Expect(0, 8297, '\p{Bidi_C= N}', "");
    Expect(1, 8297, '\p{^Bidi_C= N}', "");
    Expect(1, 8297, '\P{Bidi_C= N}', "");
    Expect(0, 8297, '\P{^Bidi_C= N}', "");
    Error('\p{Is_Bidi_Control=:=--F}');
    Error('\P{Is_Bidi_Control=:=--F}');
    Expect(1, 8298, '\p{Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\p{Is_Bidi_Control= F}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control= F}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control= F}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control= F}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control= F}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control= F}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control= F}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control= F}', "");
    Error('\p{Is_Bidi_C= False:=}');
    Error('\P{Is_Bidi_C= False:=}');
    Expect(1, 8298, '\p{Is_Bidi_C:false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C:false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C:false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C:false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C:false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C:false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C:false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C:false}', "");
    Expect(1, 8298, '\p{Is_Bidi_C=-_false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=-_false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=-_false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=-_false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=-_false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=-_false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=-_false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=-_false}', "");
    Error('\p{Bidi_Control= -Yes/a/}');
    Error('\P{Bidi_Control= -Yes/a/}');
    Expect(1, 8297, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=yes}', "");
    Expect(1, 8297, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=__yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=__yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=__yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=__yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=__yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=__yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=__yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=__yes}', "");
    Error('\p{Bidi_C=  Y/a/}');
    Error('\P{Bidi_C=  Y/a/}');
    Expect(1, 8297, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C=y}', "");
    Expect(0, 8297, '\p{^Bidi_C=y}', "");
    Expect(0, 8297, '\P{Bidi_C=y}', "");
    Expect(1, 8297, '\P{^Bidi_C=y}', "");
    Expect(0, 8298, '\p{Bidi_C=y}', "");
    Expect(1, 8298, '\p{^Bidi_C=y}', "");
    Expect(1, 8298, '\P{Bidi_C=y}', "");
    Expect(0, 8298, '\P{^Bidi_C=y}', "");
    Expect(1, 8297, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C= -Y}', "");
    Expect(0, 8297, '\p{^Bidi_C= -Y}', "");
    Expect(0, 8297, '\P{Bidi_C= -Y}', "");
    Expect(1, 8297, '\P{^Bidi_C= -Y}', "");
    Expect(0, 8298, '\p{Bidi_C= -Y}', "");
    Expect(1, 8298, '\p{^Bidi_C= -Y}', "");
    Expect(1, 8298, '\P{Bidi_C= -Y}', "");
    Expect(0, 8298, '\P{^Bidi_C= -Y}', "");
    Error('\p{Is_Bidi_Control=/a/_-t}');
    Error('\P{Is_Bidi_Control=/a/_-t}');
    Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\p{Is_Bidi_Control= T}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control= T}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control= T}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control= T}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control= T}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control= T}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control= T}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control= T}', "");
    Error('\p{Is_Bidi_C=:=-True}');
    Error('\P{Is_Bidi_C=:=-True}');
    Expect(1, 8297, '\p{Is_Bidi_C:   true}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C:   true}', "");
    Expect(0, 8297, '\P{Is_Bidi_C:   true}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C:   true}', "");
    Expect(0, 8298, '\p{Is_Bidi_C:   true}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C:   true}', "");
    Expect(1, 8298, '\P{Is_Bidi_C:   true}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C:   true}', "");
    Expect(1, 8297, '\p{Is_Bidi_C=_-true}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=_-true}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=_-true}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=_-true}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=_-true}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=_-true}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=_-true}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=_-true}', "");
    Error('\p{Bidi_Mirrored=-/a/NO}');
    Error('\P{Bidi_Mirrored=-/a/NO}');
    Expect(1, 120772, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=_No}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=_No}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=_No}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=_No}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=_No}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=_No}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=_No}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=_No}', "");
    Error('\p{Bidi_M=	N/a/}');
    Error('\P{Bidi_M=	N/a/}');
    Expect(1, 120772, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=n}', "");
    Expect(0, 120772, '\p{^Bidi_M=n}', "");
    Expect(0, 120772, '\P{Bidi_M=n}', "");
    Expect(1, 120772, '\P{^Bidi_M=n}', "");
    Expect(0, 120771, '\p{Bidi_M=n}', "");
    Expect(1, 120771, '\p{^Bidi_M=n}', "");
    Expect(1, 120771, '\P{Bidi_M=n}', "");
    Expect(0, 120771, '\P{^Bidi_M=n}', "");
    Expect(1, 120772, '\p{Bidi_M=:\An\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\An\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=	n}', "");
    Expect(0, 120772, '\p{^Bidi_M=	n}', "");
    Expect(0, 120772, '\P{Bidi_M=	n}', "");
    Expect(1, 120772, '\P{^Bidi_M=	n}', "");
    Expect(0, 120771, '\p{Bidi_M=	n}', "");
    Expect(1, 120771, '\p{^Bidi_M=	n}', "");
    Expect(1, 120771, '\P{Bidi_M=	n}', "");
    Expect(0, 120771, '\P{^Bidi_M=	n}', "");
    Error('\p{Is_Bidi_Mirrored=--F:=}');
    Error('\P{Is_Bidi_Mirrored=--F:=}');
    Expect(1, 120772, '\p{Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=_ F}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=_ F}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=_ F}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=_ F}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=_ F}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=_ F}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=_ F}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=_ F}', "");
    Error('\p{Is_Bidi_M=/a/-_False}');
    Error('\P{Is_Bidi_M=/a/-_False}');
    Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
    Expect(1, 120772, '\p{Is_Bidi_M=	 False}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=	 False}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=	 False}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=	 False}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=	 False}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=	 False}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=	 False}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=	 False}', "");
    Error('\p{Bidi_Mirrored=/a/Yes}');
    Error('\P{Bidi_Mirrored=/a/Yes}');
    Expect(1, 120771, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=__Yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=__Yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=__Yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=__Yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=__Yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=__Yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=__Yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=__Yes}', "");
    Error('\p{Bidi_M=:= Y}');
    Error('\P{Bidi_M=:= Y}');
    Expect(1, 120771, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M:y}', "");
    Expect(0, 120771, '\p{^Bidi_M:y}', "");
    Expect(0, 120771, '\P{Bidi_M:y}', "");
    Expect(1, 120771, '\P{^Bidi_M:y}', "");
    Expect(0, 120772, '\p{Bidi_M:y}', "");
    Expect(1, 120772, '\p{^Bidi_M:y}', "");
    Expect(1, 120772, '\P{Bidi_M:y}', "");
    Expect(0, 120772, '\P{^Bidi_M:y}', "");
    Expect(1, 120771, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=_y}', "");
    Expect(0, 120771, '\p{^Bidi_M=_y}', "");
    Expect(0, 120771, '\P{Bidi_M=_y}', "");
    Expect(1, 120771, '\P{^Bidi_M=_y}', "");
    Expect(0, 120772, '\p{Bidi_M=_y}', "");
    Expect(1, 120772, '\p{^Bidi_M=_y}', "");
    Expect(1, 120772, '\P{Bidi_M=_y}', "");
    Expect(0, 120772, '\P{^Bidi_M=_y}', "");
    Error('\p{Is_Bidi_Mirrored=/a/ 	T}');
    Error('\P{Is_Bidi_Mirrored=/a/ 	T}');
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=	T}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=	T}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=	T}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=	T}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=	T}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=	T}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=	T}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=	T}', "");
    Error('\p{Is_Bidi_M:	-/a/true}');
    Error('\P{Is_Bidi_M:	-/a/true}');
    Expect(1, 120771, '\p{Is_Bidi_M=true}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=true}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=true}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=true}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=true}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=true}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=true}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=true}', "");
    Expect(1, 120771, '\p{Is_Bidi_M=TRUE}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=TRUE}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=TRUE}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=TRUE}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=TRUE}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=TRUE}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=TRUE}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=TRUE}', "");
    Error('\p{block}');
    Error('\P{block}');
    Error('\p{blk}');
    Error('\P{blk}');
    Error('\p{Block:	-_Adlam:=}');
    Error('\P{Block:	-_Adlam:=}');
    Expect(1, 125279, '\p{Block=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Block=adlam}', "");
    Expect(0, 125279, '\p{^Block=adlam}', "");
    Expect(0, 125279, '\P{Block=adlam}', "");
    Expect(1, 125279, '\P{^Block=adlam}', "");
    Expect(0, 125280, '\p{Block=adlam}', "");
    Expect(1, 125280, '\p{^Block=adlam}', "");
    Expect(1, 125280, '\P{Block=adlam}', "");
    Expect(0, 125280, '\P{^Block=adlam}', "");
    Expect(1, 125279, '\p{Block=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Block=_	Adlam}', "");
    Expect(0, 125279, '\p{^Block=_	Adlam}', "");
    Expect(0, 125279, '\P{Block=_	Adlam}', "");
    Expect(1, 125279, '\P{^Block=_	Adlam}', "");
    Expect(0, 125280, '\p{Block=_	Adlam}', "");
    Expect(1, 125280, '\p{^Block=_	Adlam}', "");
    Expect(1, 125280, '\P{Block=_	Adlam}', "");
    Expect(0, 125280, '\P{^Block=_	Adlam}', "");
    Error('\p{Blk=:=		adlam}');
    Error('\P{Blk=:=		adlam}');
    Expect(1, 125279, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Blk=adlam}', "");
    Expect(0, 125279, '\p{^Blk=adlam}', "");
    Expect(0, 125279, '\P{Blk=adlam}', "");
    Expect(1, 125279, '\P{^Blk=adlam}', "");
    Expect(0, 125280, '\p{Blk=adlam}', "");
    Expect(1, 125280, '\p{^Blk=adlam}', "");
    Expect(1, 125280, '\P{Blk=adlam}', "");
    Expect(0, 125280, '\P{^Blk=adlam}', "");
    Expect(1, 125279, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Blk=_	Adlam}', "");
    Expect(0, 125279, '\p{^Blk=_	Adlam}', "");
    Expect(0, 125279, '\P{Blk=_	Adlam}', "");
    Expect(1, 125279, '\P{^Blk=_	Adlam}', "");
    Expect(0, 125280, '\p{Blk=_	Adlam}', "");
    Expect(1, 125280, '\p{^Blk=_	Adlam}', "");
    Expect(1, 125280, '\P{Blk=_	Adlam}', "");
    Expect(0, 125280, '\P{^Blk=_	Adlam}', "");
    Error('\p{Is_Block:/a/		adlam}');
    Error('\P{Is_Block:/a/		adlam}');
    Expect(1, 125279, '\p{Is_Block:adlam}', "");
    Expect(0, 125279, '\p{^Is_Block:adlam}', "");
    Expect(0, 125279, '\P{Is_Block:adlam}', "");
    Expect(1, 125279, '\P{^Is_Block:adlam}', "");
    Expect(0, 125280, '\p{Is_Block:adlam}', "");
    Expect(1, 125280, '\p{^Is_Block:adlam}', "");
    Expect(1, 125280, '\P{Is_Block:adlam}', "");
    Expect(0, 125280, '\P{^Is_Block:adlam}', "");
    Expect(1, 125279, '\p{Is_Block=__Adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=__Adlam}', "");
    Expect(0, 125279, '\P{Is_Block=__Adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=__Adlam}', "");
    Expect(0, 125280, '\p{Is_Block=__Adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=__Adlam}', "");
    Expect(1, 125280, '\P{Is_Block=__Adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=__Adlam}', "");
    Error('\p{Is_Blk=:=_ adlam}');
    Error('\P{Is_Blk=:=_ adlam}');
    Expect(1, 125279, '\p{Is_Blk=adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=adlam}', "");
    Expect(1, 125279, '\p{Is_Blk=	_ADLAM}', "");
    Expect(0, 125279, '\p{^Is_Blk=	_ADLAM}', "");
    Expect(0, 125279, '\P{Is_Blk=	_ADLAM}', "");
    Expect(1, 125279, '\P{^Is_Blk=	_ADLAM}', "");
    Expect(0, 125280, '\p{Is_Blk=	_ADLAM}', "");
    Expect(1, 125280, '\p{^Is_Blk=	_ADLAM}', "");
    Expect(1, 125280, '\P{Is_Blk=	_ADLAM}', "");
    Expect(0, 125280, '\P{^Is_Blk=	_ADLAM}', "");
    Error('\p{Block:   		aegean_Numbers/a/}');
    Error('\P{Block:   		aegean_Numbers/a/}');
    Expect(1, 65855, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Block=	Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Block=	Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Block=	Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Block=	Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Block=	Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Block=	Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Block=	Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Block=	Aegean_Numbers}', "");
    Error('\p{Blk:		_Aegean_Numbers/a/}');
    Error('\P{Blk:		_Aegean_Numbers/a/}');
    Expect(1, 65855, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Blk= -Aegean_NUMBERS}', "");
    Expect(0, 65855, '\p{^Blk= -Aegean_NUMBERS}', "");
    Expect(0, 65855, '\P{Blk= -Aegean_NUMBERS}', "");
    Expect(1, 65855, '\P{^Blk= -Aegean_NUMBERS}', "");
    Expect(0, 65856, '\p{Blk= -Aegean_NUMBERS}', "");
    Expect(1, 65856, '\p{^Blk= -Aegean_NUMBERS}', "");
    Expect(1, 65856, '\P{Blk= -Aegean_NUMBERS}', "");
    Expect(0, 65856, '\P{^Blk= -Aegean_NUMBERS}', "");
    Error('\p{Is_Block=-:=Aegean_Numbers}');
    Error('\P{Is_Block=-:=Aegean_Numbers}');
    Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Block=- AEGEAN_numbers}', "");
    Expect(0, 65855, '\p{^Is_Block=- AEGEAN_numbers}', "");
    Expect(0, 65855, '\P{Is_Block=- AEGEAN_numbers}', "");
    Expect(1, 65855, '\P{^Is_Block=- AEGEAN_numbers}', "");
    Expect(0, 65856, '\p{Is_Block=- AEGEAN_numbers}', "");
    Expect(1, 65856, '\p{^Is_Block=- AEGEAN_numbers}', "");
    Expect(1, 65856, '\P{Is_Block=- AEGEAN_numbers}', "");
    Expect(0, 65856, '\P{^Is_Block=- AEGEAN_numbers}', "");
    Error('\p{Is_Blk=:=_ aegean_numbers}');
    Error('\P{Is_Blk=:=_ aegean_numbers}');
    Expect(1, 65855, '\p{Is_Blk:	aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Blk:	aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Blk:	aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Blk:	aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Blk:	aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Blk:	aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Blk:	aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Blk:	aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(0, 65855, '\p{^Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(0, 65855, '\P{Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(1, 65855, '\P{^Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(0, 65856, '\p{Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(1, 65856, '\p{^Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(1, 65856, '\P{Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Expect(0, 65856, '\P{^Is_Blk:   	_AEGEAN_NUMBERS}', "");
    Error('\p{Block=-:=AHOM}');
    Error('\P{Block=-:=AHOM}');
    Expect(1, 71487, '\p{Block=:\AAhom\z:}', "");;
    Expect(0, 71488, '\p{Block=:\AAhom\z:}', "");;
    Expect(1, 71487, '\p{Block=ahom}', "");
    Expect(0, 71487, '\p{^Block=ahom}', "");
    Expect(0, 71487, '\P{Block=ahom}', "");
    Expect(1, 71487, '\P{^Block=ahom}', "");
    Expect(0, 71488, '\p{Block=ahom}', "");
    Expect(1, 71488, '\p{^Block=ahom}', "");
    Expect(1, 71488, '\P{Block=ahom}', "");
    Expect(0, 71488, '\P{^Block=ahom}', "");
    Expect(1, 71487, '\p{Block=:\Aahom\z:}', "");;
    Expect(0, 71488, '\p{Block=:\Aahom\z:}', "");;
    Expect(1, 71487, '\p{Block=_AHOM}', "");
    Expect(0, 71487, '\p{^Block=_AHOM}', "");
    Expect(0, 71487, '\P{Block=_AHOM}', "");
    Expect(1, 71487, '\P{^Block=_AHOM}', "");
    Expect(0, 71488, '\p{Block=_AHOM}', "");
    Expect(1, 71488, '\p{^Block=_AHOM}', "");
    Expect(1, 71488, '\P{Block=_AHOM}', "");
    Expect(0, 71488, '\P{^Block=_AHOM}', "");
    Error('\p{Blk=-_Ahom/a/}');
    Error('\P{Blk=-_Ahom/a/}');
    Expect(1, 71487, '\p{Blk=:\AAhom\z:}', "");;
    Expect(0, 71488, '\p{Blk=:\AAhom\z:}', "");;
    Expect(1, 71487, '\p{Blk=ahom}', "");
    Expect(0, 71487, '\p{^Blk=ahom}', "");
    Expect(0, 71487, '\P{Blk=ahom}', "");
    Expect(1, 71487, '\P{^Blk=ahom}', "");
    Expect(0, 71488, '\p{Blk=ahom}', "");
    Expect(1, 71488, '\p{^Blk=ahom}', "");
    Expect(1, 71488, '\P{Blk=ahom}', "");
    Expect(0, 71488, '\P{^Blk=ahom}', "");
    Expect(1, 71487, '\p{Blk=:\Aahom\z:}', "");;
    Expect(0, 71488, '\p{Blk=:\Aahom\z:}', "");;
    Expect(1, 71487, '\p{Blk=	 Ahom}', "");
    Expect(0, 71487, '\p{^Blk=	 Ahom}', "");
    Expect(0, 71487, '\P{Blk=	 Ahom}', "");
    Expect(1, 71487, '\P{^Blk=	 Ahom}', "");
    Expect(0, 71488, '\p{Blk=	 Ahom}', "");
    Expect(1, 71488, '\p{^Blk=	 Ahom}', "");
    Expect(1, 71488, '\P{Blk=	 Ahom}', "");
    Expect(0, 71488, '\P{^Blk=	 Ahom}', "");
    Error('\p{Is_Block=_/a/AHOM}');
    Error('\P{Is_Block=_/a/AHOM}');
    Expect(1, 71487, '\p{Is_Block=ahom}', "");
    Expect(0, 71487, '\p{^Is_Block=ahom}', "");
    Expect(0, 71487, '\P{Is_Block=ahom}', "");
    Expect(1, 71487, '\P{^Is_Block=ahom}', "");
    Expect(0, 71488, '\p{Is_Block=ahom}', "");
    Expect(1, 71488, '\p{^Is_Block=ahom}', "");
    Expect(1, 71488, '\P{Is_Block=ahom}', "");
    Expect(0, 71488, '\P{^Is_Block=ahom}', "");
    Expect(1, 71487, '\p{Is_Block=_-Ahom}', "");
    Expect(0, 71487, '\p{^Is_Block=_-Ahom}', "");
    Expect(0, 71487, '\P{Is_Block=_-Ahom}', "");
    Expect(1, 71487, '\P{^Is_Block=_-Ahom}', "");
    Expect(0, 71488, '\p{Is_Block=_-Ahom}', "");
    Expect(1, 71488, '\p{^Is_Block=_-Ahom}', "");
    Expect(1, 71488, '\P{Is_Block=_-Ahom}', "");
    Expect(0, 71488, '\P{^Is_Block=_-Ahom}', "");
    Error('\p{Is_Blk=-:=AHOM}');
    Error('\P{Is_Blk=-:=AHOM}');
    Expect(1, 71487, '\p{Is_Blk=ahom}', "");
    Expect(0, 71487, '\p{^Is_Blk=ahom}', "");
    Expect(0, 71487, '\P{Is_Blk=ahom}', "");
    Expect(1, 71487, '\P{^Is_Blk=ahom}', "");
    Expect(0, 71488, '\p{Is_Blk=ahom}', "");
    Expect(1, 71488, '\p{^Is_Blk=ahom}', "");
    Expect(1, 71488, '\P{Is_Blk=ahom}', "");
    Expect(0, 71488, '\P{^Is_Blk=ahom}', "");
    Expect(1, 71487, '\p{Is_Blk=-ahom}', "");
    Expect(0, 71487, '\p{^Is_Blk=-ahom}', "");
    Expect(0, 71487, '\P{Is_Blk=-ahom}', "");
    Expect(1, 71487, '\P{^Is_Blk=-ahom}', "");
    Expect(0, 71488, '\p{Is_Blk=-ahom}', "");
    Expect(1, 71488, '\p{^Is_Blk=-ahom}', "");
    Expect(1, 71488, '\P{Is_Blk=-ahom}', "");
    Expect(0, 71488, '\P{^Is_Blk=-ahom}', "");
    Error('\p{Block=:= 	Alchemical_symbols}');
    Error('\P{Block=:= 	Alchemical_symbols}');
    Expect(1, 128895, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(1, 128895, '\p{Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(1, 128895, '\p{Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(0, 128895, '\p{^Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(0, 128895, '\P{Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(1, 128895, '\P{^Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(0, 128896, '\p{Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(1, 128896, '\p{^Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(1, 128896, '\P{Block=-_ALCHEMICAL_SYMBOLS}', "");
    Expect(0, 128896, '\P{^Block=-_ALCHEMICAL_SYMBOLS}', "");
    Error('\p{Blk=-:=Alchemical}');
    Error('\P{Blk=-:=Alchemical}');
    Expect(1, 128895, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Blk=alchemical}', "");
    Expect(0, 128895, '\P{Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Blk=alchemical}', "");
    Expect(0, 128896, '\p{Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Blk=alchemical}', "");
    Expect(1, 128896, '\P{Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Blk=alchemical}', "");
    Expect(1, 128895, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=	-alchemical}', "");
    Expect(0, 128895, '\p{^Blk=	-alchemical}', "");
    Expect(0, 128895, '\P{Blk=	-alchemical}', "");
    Expect(1, 128895, '\P{^Blk=	-alchemical}', "");
    Expect(0, 128896, '\p{Blk=	-alchemical}', "");
    Expect(1, 128896, '\p{^Blk=	-alchemical}', "");
    Expect(1, 128896, '\P{Blk=	-alchemical}', "");
    Expect(0, 128896, '\P{^Blk=	-alchemical}', "");
    Error('\p{Is_Block=:=	_ALCHEMICAL_symbols}');
    Error('\P{Is_Block=:=	_ALCHEMICAL_symbols}');
    Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(0, 128895, '\p{^Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(0, 128895, '\P{Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(1, 128895, '\P{^Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(0, 128896, '\p{Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(1, 128896, '\p{^Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(1, 128896, '\P{Is_Block= -ALCHEMICAL_Symbols}', "");
    Expect(0, 128896, '\P{^Is_Block= -ALCHEMICAL_Symbols}', "");
    Error('\p{Is_Blk=-/a/Alchemical}');
    Error('\P{Is_Blk=-/a/Alchemical}');
    Expect(1, 128895, '\p{Is_Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk=alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk=alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk=alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk=alchemical}', "");
    Expect(1, 128895, '\p{Is_Blk=  Alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk=  Alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk=  Alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk=  Alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk=  Alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk=  Alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk=  Alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk=  Alchemical}', "");
    Error('\p{Block=/a/-Alphabetic_Presentation_Forms}');
    Error('\P{Block=/a/-Alphabetic_Presentation_Forms}');
    Expect(1, 64335, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(1, 64335, '\p{Block:alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Block:alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Block:alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Block:alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Block:alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Block:alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Block:alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Block:alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(1, 64335, '\p{Block: _alphabetic_presentation_Forms}', "");
    Expect(0, 64335, '\p{^Block: _alphabetic_presentation_Forms}', "");
    Expect(0, 64335, '\P{Block: _alphabetic_presentation_Forms}', "");
    Expect(1, 64335, '\P{^Block: _alphabetic_presentation_Forms}', "");
    Expect(0, 64336, '\p{Block: _alphabetic_presentation_Forms}', "");
    Expect(1, 64336, '\p{^Block: _alphabetic_presentation_Forms}', "");
    Expect(1, 64336, '\P{Block: _alphabetic_presentation_Forms}', "");
    Expect(0, 64336, '\P{^Block: _alphabetic_presentation_Forms}', "");
    Error('\p{Blk= -ALPHABETIC_PF/a/}');
    Error('\P{Blk= -ALPHABETIC_PF/a/}');
    Expect(1, 64335, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(1, 64335, '\p{Blk=-ALPHABETIC_PF}', "");
    Expect(0, 64335, '\p{^Blk=-ALPHABETIC_PF}', "");
    Expect(0, 64335, '\P{Blk=-ALPHABETIC_PF}', "");
    Expect(1, 64335, '\P{^Blk=-ALPHABETIC_PF}', "");
    Expect(0, 64336, '\p{Blk=-ALPHABETIC_PF}', "");
    Expect(1, 64336, '\p{^Blk=-ALPHABETIC_PF}', "");
    Expect(1, 64336, '\P{Blk=-ALPHABETIC_PF}', "");
    Expect(0, 64336, '\P{^Blk=-ALPHABETIC_PF}', "");
    Error('\p{Is_Block=/a/--ALPHABETIC_presentation_Forms}');
    Error('\P{Is_Block=/a/--ALPHABETIC_presentation_Forms}');
    Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(0, 64335, '\p{^Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(0, 64335, '\P{Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(1, 64335, '\P{^Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(0, 64336, '\p{Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(1, 64336, '\p{^Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(1, 64336, '\P{Is_Block=	_Alphabetic_Presentation_forms}', "");
    Expect(0, 64336, '\P{^Is_Block=	_Alphabetic_Presentation_forms}', "");
    Error('\p{Is_Blk=/a/_	Alphabetic_PF}');
    Error('\P{Is_Blk=/a/_	Alphabetic_PF}');
    Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(0, 64335, '\p{^Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(0, 64335, '\P{Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(1, 64335, '\P{^Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(0, 64336, '\p{Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(1, 64336, '\p{^Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(1, 64336, '\P{Is_Blk=-_ALPHABETIC_PF}', "");
    Expect(0, 64336, '\P{^Is_Blk=-_ALPHABETIC_PF}', "");
    Error('\p{Block: --Anatolian_Hieroglyphs/a/}');
    Error('\P{Block: --Anatolian_Hieroglyphs/a/}');
    Expect(1, 83583, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block:anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Block:anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Block:anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Block:anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Block:anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Block:anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Block:anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Block:anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83583, '\p{^Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83583, '\P{Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83583, '\P{^Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83584, '\p{Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83584, '\p{^Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83584, '\P{Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83584, '\P{^Block=_ANATOLIAN_HIEROGLYPHS}', "");
    Error('\p{Blk=		anatolian_HIEROGLYPHS:=}');
    Error('\P{Blk=		anatolian_HIEROGLYPHS:=}');
    Expect(1, 83583, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=	anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=	anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=	anatolian_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=	anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=	anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=	anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=	anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=	anatolian_Hieroglyphs}', "");
    Error('\p{Is_Block=/a/-ANATOLIAN_Hieroglyphs}');
    Error('\P{Is_Block=/a/-ANATOLIAN_Hieroglyphs}');
    Expect(1, 83583, '\p{Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=	_Anatolian_Hieroglyphs}', "");
    Error('\p{Is_Blk:	Anatolian_Hieroglyphs:=}');
    Error('\P{Is_Blk:	Anatolian_Hieroglyphs:=}');
    Expect(1, 83583, '\p{Is_Blk:   anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk:   anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk:   anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk:   anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk:   anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk:   anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk:   anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk:   anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83583, '\p{^Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83583, '\P{Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83583, '\P{^Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83584, '\p{Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83584, '\p{^Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83584, '\P{Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83584, '\P{^Is_Blk= -ANATOLIAN_HIEROGLYPHS}', "");
    Error('\p{Block=	:=ancient_GREEK_MUSICAL_Notation}');
    Error('\P{Block=	:=ancient_GREEK_MUSICAL_Notation}');
    Expect(1, 119375, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(1, 119375, '\p{Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(0, 119375, '\p{^Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(0, 119375, '\P{Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(1, 119375, '\P{^Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(0, 119376, '\p{Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(1, 119376, '\p{^Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(1, 119376, '\P{Block=	-Ancient_Greek_musical_Notation}', "");
    Expect(0, 119376, '\P{^Block=	-Ancient_Greek_musical_Notation}', "");
    Error('\p{Blk=-	Ancient_Greek_Music:=}');
    Error('\P{Blk=-	Ancient_Greek_Music:=}');
    Expect(1, 119375, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(1, 119375, '\p{Blk= -ANCIENT_Greek_music}', "");
    Expect(0, 119375, '\p{^Blk= -ANCIENT_Greek_music}', "");
    Expect(0, 119375, '\P{Blk= -ANCIENT_Greek_music}', "");
    Expect(1, 119375, '\P{^Blk= -ANCIENT_Greek_music}', "");
    Expect(0, 119376, '\p{Blk= -ANCIENT_Greek_music}', "");
    Expect(1, 119376, '\p{^Blk= -ANCIENT_Greek_music}', "");
    Expect(1, 119376, '\P{Blk= -ANCIENT_Greek_music}', "");
    Expect(0, 119376, '\P{^Blk= -ANCIENT_Greek_music}', "");
    Error('\p{Is_Block=:= Ancient_greek_musical_NOTATION}');
    Error('\P{Is_Block=:= Ancient_greek_musical_NOTATION}');
    Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(0, 119375, '\p{^Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(0, 119375, '\P{Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(1, 119375, '\P{^Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(0, 119376, '\p{Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(1, 119376, '\p{^Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(1, 119376, '\P{Is_Block= _ancient_greek_musical_NOTATION}', "");
    Expect(0, 119376, '\P{^Is_Block= _ancient_greek_musical_NOTATION}', "");
    Error('\p{Is_Blk=:=	-ANCIENT_greek_Music}');
    Error('\P{Is_Blk=:=	-ANCIENT_greek_Music}');
    Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(0, 119375, '\p{^Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(0, 119375, '\P{Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(1, 119375, '\P{^Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(0, 119376, '\p{Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(1, 119376, '\p{^Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(1, 119376, '\P{Is_Blk=	-ANCIENT_Greek_Music}', "");
    Expect(0, 119376, '\P{^Is_Blk=	-ANCIENT_Greek_Music}', "");
    Error('\p{Block= /a/Ancient_Greek_NUMBERS}');
    Error('\P{Block= /a/Ancient_Greek_NUMBERS}');
    Expect(1, 65935, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Block: ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Block: ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Block: ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Block: ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Block: ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Block: ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Block: ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Block: ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Block=_-ancient_Greek_numbers}', "");
    Expect(0, 65935, '\p{^Block=_-ancient_Greek_numbers}', "");
    Expect(0, 65935, '\P{Block=_-ancient_Greek_numbers}', "");
    Expect(1, 65935, '\P{^Block=_-ancient_Greek_numbers}', "");
    Expect(0, 65936, '\p{Block=_-ancient_Greek_numbers}', "");
    Expect(1, 65936, '\p{^Block=_-ancient_Greek_numbers}', "");
    Expect(1, 65936, '\P{Block=_-ancient_Greek_numbers}', "");
    Expect(0, 65936, '\P{^Block=_-ancient_Greek_numbers}', "");
    Error('\p{Blk=_/a/ANCIENT_Greek_numbers}');
    Error('\P{Blk=_/a/ANCIENT_Greek_numbers}');
    Expect(1, 65935, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(0, 65935, '\p{^Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(0, 65935, '\P{Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(1, 65935, '\P{^Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(0, 65936, '\p{Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(1, 65936, '\p{^Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(1, 65936, '\P{Blk=ANCIENT_Greek_NUMBERS}', "");
    Expect(0, 65936, '\P{^Blk=ANCIENT_Greek_NUMBERS}', "");
    Error('\p{Is_Block=	_Ancient_greek_Numbers/a/}');
    Error('\P{Is_Block=	_Ancient_greek_Numbers/a/}');
    Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(0, 65935, '\p{^Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(0, 65935, '\P{Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(1, 65935, '\P{^Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(0, 65936, '\p{Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(1, 65936, '\p{^Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(1, 65936, '\P{Is_Block=--Ancient_Greek_NUMBERS}', "");
    Expect(0, 65936, '\P{^Is_Block=--Ancient_Greek_NUMBERS}', "");
    Error('\p{Is_Blk=:=	_ancient_GREEK_Numbers}');
    Error('\P{Is_Blk=:=	_ancient_GREEK_Numbers}');
    Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(0, 65935, '\p{^Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(0, 65935, '\P{Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(1, 65935, '\P{^Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(0, 65936, '\p{Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(1, 65936, '\p{^Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(1, 65936, '\P{Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Expect(0, 65936, '\P{^Is_Blk=_ Ancient_Greek_NUMBERS}', "");
    Error('\p{Block=	-Ancient_SYMBOLS:=}');
    Error('\P{Block=	-Ancient_SYMBOLS:=}');
    Expect(1, 65999, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Block= -Ancient_symbols}', "");
    Expect(0, 65999, '\p{^Block= -Ancient_symbols}', "");
    Expect(0, 65999, '\P{Block= -Ancient_symbols}', "");
    Expect(1, 65999, '\P{^Block= -Ancient_symbols}', "");
    Expect(0, 66000, '\p{Block= -Ancient_symbols}', "");
    Expect(1, 66000, '\p{^Block= -Ancient_symbols}', "");
    Expect(1, 66000, '\P{Block= -Ancient_symbols}', "");
    Expect(0, 66000, '\P{^Block= -Ancient_symbols}', "");
    Error('\p{Blk=	-ancient_Symbols/a/}');
    Error('\P{Blk=	-ancient_Symbols/a/}');
    Expect(1, 65999, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=  Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Blk=  Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Blk=  Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Blk=  Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Blk=  Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Blk=  Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Blk=  Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Blk=  Ancient_Symbols}', "");
    Error('\p{Is_Block=-ANCIENT_symbols:=}');
    Error('\P{Is_Block=-ANCIENT_symbols:=}');
    Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Block=	-Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Is_Block=	-Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Is_Block=	-Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Is_Block=	-Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Is_Block=	-Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Is_Block=	-Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Is_Block=	-Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Is_Block=	-Ancient_Symbols}', "");
    Error('\p{Is_Blk:   -_ancient_symbols:=}');
    Error('\P{Is_Blk:   -_ancient_symbols:=}');
    Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Blk=_	Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=_	Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Is_Blk=_	Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=_	Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Is_Blk=_	Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=_	Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Is_Blk=_	Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=_	Ancient_Symbols}', "");
    Error('\p{Block=_	Arabic/a/}');
    Error('\P{Block=_	Arabic/a/}');
    Expect(1, 1791, '\p{Block=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Block=arabic}', "");
    Expect(0, 1791, '\p{^Block=arabic}', "");
    Expect(0, 1791, '\P{Block=arabic}', "");
    Expect(1, 1791, '\P{^Block=arabic}', "");
    Expect(0, 1792, '\p{Block=arabic}', "");
    Expect(1, 1792, '\p{^Block=arabic}', "");
    Expect(1, 1792, '\P{Block=arabic}', "");
    Expect(0, 1792, '\P{^Block=arabic}', "");
    Expect(1, 1791, '\p{Block=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Block=	arabic}', "");
    Expect(0, 1791, '\p{^Block=	arabic}', "");
    Expect(0, 1791, '\P{Block=	arabic}', "");
    Expect(1, 1791, '\P{^Block=	arabic}', "");
    Expect(0, 1792, '\p{Block=	arabic}', "");
    Expect(1, 1792, '\p{^Block=	arabic}', "");
    Expect(1, 1792, '\P{Block=	arabic}', "");
    Expect(0, 1792, '\P{^Block=	arabic}', "");
    Error('\p{Blk=-:=Arabic}');
    Error('\P{Blk=-:=Arabic}');
    Expect(1, 1791, '\p{Blk=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=arabic}', "");
    Expect(0, 1791, '\p{^Blk=arabic}', "");
    Expect(0, 1791, '\P{Blk=arabic}', "");
    Expect(1, 1791, '\P{^Blk=arabic}', "");
    Expect(0, 1792, '\p{Blk=arabic}', "");
    Expect(1, 1792, '\p{^Blk=arabic}', "");
    Expect(1, 1792, '\P{Blk=arabic}', "");
    Expect(0, 1792, '\P{^Blk=arabic}', "");
    Expect(1, 1791, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=__arabic}', "");
    Expect(0, 1791, '\p{^Blk=__arabic}', "");
    Expect(0, 1791, '\P{Blk=__arabic}', "");
    Expect(1, 1791, '\P{^Blk=__arabic}', "");
    Expect(0, 1792, '\p{Blk=__arabic}', "");
    Expect(1, 1792, '\p{^Blk=__arabic}', "");
    Expect(1, 1792, '\P{Blk=__arabic}', "");
    Expect(0, 1792, '\P{^Blk=__arabic}', "");
    Error('\p{Is_Block: /a/Arabic}');
    Error('\P{Is_Block: /a/Arabic}');
    Expect(1, 1791, '\p{Is_Block=arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=arabic}', "");
    Expect(0, 1791, '\P{Is_Block=arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=arabic}', "");
    Expect(0, 1792, '\p{Is_Block=arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=arabic}', "");
    Expect(1, 1792, '\P{Is_Block=arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=arabic}', "");
    Expect(1, 1791, '\p{Is_Block=-	Arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=-	Arabic}', "");
    Expect(0, 1791, '\P{Is_Block=-	Arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=-	Arabic}', "");
    Expect(0, 1792, '\p{Is_Block=-	Arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=-	Arabic}', "");
    Expect(1, 1792, '\P{Is_Block=-	Arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=-	Arabic}', "");
    Error('\p{Is_Blk=:=__ARABIC}');
    Error('\P{Is_Blk=:=__ARABIC}');
    Expect(1, 1791, '\p{Is_Blk=arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
    Expect(1, 1791, '\p{Is_Blk=		arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=		arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=		arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=		arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=		arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=		arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=		arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=		arabic}', "");
    Error('\p{Block=:=Arabic_EXTENDED_A}');
    Error('\P{Block=:=Arabic_EXTENDED_A}');
    Expect(1, 2303, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(0, 2304, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(1, 2303, '\p{Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(0, 2304, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(1, 2303, '\p{Block=_ ARABIC_Extended_A}', "");
    Expect(0, 2303, '\p{^Block=_ ARABIC_Extended_A}', "");
    Expect(0, 2303, '\P{Block=_ ARABIC_Extended_A}', "");
    Expect(1, 2303, '\P{^Block=_ ARABIC_Extended_A}', "");
    Expect(0, 2304, '\p{Block=_ ARABIC_Extended_A}', "");
    Expect(1, 2304, '\p{^Block=_ ARABIC_Extended_A}', "");
    Expect(1, 2304, '\P{Block=_ ARABIC_Extended_A}', "");
    Expect(0, 2304, '\P{^Block=_ ARABIC_Extended_A}', "");
    Error('\p{Blk:-:=Arabic_Ext_A}');
    Error('\P{Blk:-:=Arabic_Ext_A}');
    Expect(1, 2303, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(1, 2303, '\p{Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(1, 2303, '\p{Blk=_Arabic_Ext_a}', "");
    Expect(0, 2303, '\p{^Blk=_Arabic_Ext_a}', "");
    Expect(0, 2303, '\P{Blk=_Arabic_Ext_a}', "");
    Expect(1, 2303, '\P{^Blk=_Arabic_Ext_a}', "");
    Expect(0, 2304, '\p{Blk=_Arabic_Ext_a}', "");
    Expect(1, 2304, '\p{^Blk=_Arabic_Ext_a}', "");
    Expect(1, 2304, '\P{Blk=_Arabic_Ext_a}', "");
    Expect(0, 2304, '\P{^Blk=_Arabic_Ext_a}', "");
    Error('\p{Is_Block=/a/	Arabic_EXTENDED_a}');
    Error('\P{Is_Block=/a/	Arabic_EXTENDED_a}');
    Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Is_Block=- arabic_extended_a}', "");
    Expect(0, 2303, '\p{^Is_Block=- arabic_extended_a}', "");
    Expect(0, 2303, '\P{Is_Block=- arabic_extended_a}', "");
    Expect(1, 2303, '\P{^Is_Block=- arabic_extended_a}', "");
    Expect(0, 2304, '\p{Is_Block=- arabic_extended_a}', "");
    Expect(1, 2304, '\p{^Is_Block=- arabic_extended_a}', "");
    Expect(1, 2304, '\P{Is_Block=- arabic_extended_a}', "");
    Expect(0, 2304, '\P{^Is_Block=- arabic_extended_a}', "");
    Error('\p{Is_Blk:	 _Arabic_Ext_A/a/}');
    Error('\P{Is_Blk:	 _Arabic_Ext_A/a/}');
    Expect(1, 2303, '\p{Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Is_Blk=_arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Is_Blk=_arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Is_Blk=_arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Is_Blk=_arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Is_Blk=_arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Is_Blk=_arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Is_Blk=_arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Is_Blk=_arabic_Ext_A}', "");
    Error('\p{Block=:=Arabic_MATHEMATICAL_Alphabetic_symbols}');
    Error('\P{Block=:=Arabic_MATHEMATICAL_Alphabetic_symbols}');
    Expect(1, 126719, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(1, 126719, '\p{Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Block:   arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(1, 126719, '\p{Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126719, '\p{^Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126719, '\P{Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(1, 126719, '\P{^Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126720, '\p{Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(1, 126720, '\p{^Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(1, 126720, '\P{Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126720, '\P{^Block=-ARABIC_Mathematical_Alphabetic_symbols}', "");
    Error('\p{Blk=- arabic_Math:=}');
    Error('\P{Blk=- arabic_Math:=}');
    Expect(1, 126719, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(1, 126719, '\p{Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(1, 126719, '\p{Blk=	_arabic_Math}', "");
    Expect(0, 126719, '\p{^Blk=	_arabic_Math}', "");
    Expect(0, 126719, '\P{Blk=	_arabic_Math}', "");
    Expect(1, 126719, '\P{^Blk=	_arabic_Math}', "");
    Expect(0, 126720, '\p{Blk=	_arabic_Math}', "");
    Expect(1, 126720, '\p{^Blk=	_arabic_Math}', "");
    Expect(1, 126720, '\P{Blk=	_arabic_Math}', "");
    Expect(0, 126720, '\P{^Blk=	_arabic_Math}', "");
    Error('\p{Is_Block=_:=ARABIC_MATHEMATICAL_Alphabetic_Symbols}');
    Error('\P{Is_Block=_:=ARABIC_MATHEMATICAL_Alphabetic_Symbols}');
    Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(0, 126719, '\p{^Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(0, 126719, '\P{Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(1, 126719, '\P{^Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(0, 126720, '\p{Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(1, 126720, '\p{^Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(1, 126720, '\P{Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Expect(0, 126720, '\P{^Is_Block=_ARABIC_MATHEMATICAL_ALPHABETIC_symbols}', "");
    Error('\p{Is_Blk=:=-	Arabic_MATH}');
    Error('\P{Is_Blk=:=-	Arabic_MATH}');
    Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Is_Blk:		_Arabic_math}', "");
    Expect(0, 126719, '\p{^Is_Blk:		_Arabic_math}', "");
    Expect(0, 126719, '\P{Is_Blk:		_Arabic_math}', "");
    Expect(1, 126719, '\P{^Is_Blk:		_Arabic_math}', "");
    Expect(0, 126720, '\p{Is_Blk:		_Arabic_math}', "");
    Expect(1, 126720, '\p{^Is_Blk:		_Arabic_math}', "");
    Expect(1, 126720, '\P{Is_Blk:		_Arabic_math}', "");
    Expect(0, 126720, '\P{^Is_Blk:		_Arabic_math}', "");
    Error('\p{Block= 	arabic_PRESENTATION_forms_A:=}');
    Error('\P{Block= 	arabic_PRESENTATION_forms_A:=}');
    Expect(1, 65023, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(0, 65024, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(0, 65024, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(1, 65023, '\p{Block=  ARABIC_presentation_Forms_A}', "");
    Expect(0, 65023, '\p{^Block=  ARABIC_presentation_Forms_A}', "");
    Expect(0, 65023, '\P{Block=  ARABIC_presentation_Forms_A}', "");
    Expect(1, 65023, '\P{^Block=  ARABIC_presentation_Forms_A}', "");
    Expect(0, 65024, '\p{Block=  ARABIC_presentation_Forms_A}', "");
    Expect(1, 65024, '\p{^Block=  ARABIC_presentation_Forms_A}', "");
    Expect(1, 65024, '\P{Block=  ARABIC_presentation_Forms_A}', "");
    Expect(0, 65024, '\P{^Block=  ARABIC_presentation_Forms_A}', "");
    Error('\p{Blk=-:=arabic_PF_a}');
    Error('\P{Blk=-:=arabic_PF_a}');
    Expect(1, 65023, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(1, 65023, '\p{Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(1, 65023, '\p{Blk=_ Arabic_pf_A}', "");
    Expect(0, 65023, '\p{^Blk=_ Arabic_pf_A}', "");
    Expect(0, 65023, '\P{Blk=_ Arabic_pf_A}', "");
    Expect(1, 65023, '\P{^Blk=_ Arabic_pf_A}', "");
    Expect(0, 65024, '\p{Blk=_ Arabic_pf_A}', "");
    Expect(1, 65024, '\p{^Blk=_ Arabic_pf_A}', "");
    Expect(1, 65024, '\P{Blk=_ Arabic_pf_A}', "");
    Expect(0, 65024, '\P{^Blk=_ Arabic_pf_A}', "");
    Error('\p{Is_Block=/a/-_arabic_PRESENTATION_Forms_A}');
    Error('\P{Is_Block=/a/-_arabic_PRESENTATION_Forms_A}');
    Expect(1, 65023, '\p{Is_Block:arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Is_Block:arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Is_Block:arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Is_Block:arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Is_Block:arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Is_Block:arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Is_Block:arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Is_Block:arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(0, 65023, '\p{^Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(0, 65023, '\P{Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(1, 65023, '\P{^Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(0, 65024, '\p{Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(1, 65024, '\p{^Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(1, 65024, '\P{Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Expect(0, 65024, '\P{^Is_Block=-_ARABIC_presentation_FORMS_A}', "");
    Error('\p{Is_Blk: /a/__Arabic_PF_a}');
    Error('\P{Is_Blk: /a/__Arabic_PF_a}');
    Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Is_Blk=_ARABIC_pf_A}', "");
    Expect(0, 65023, '\p{^Is_Blk=_ARABIC_pf_A}', "");
    Expect(0, 65023, '\P{Is_Blk=_ARABIC_pf_A}', "");
    Expect(1, 65023, '\P{^Is_Blk=_ARABIC_pf_A}', "");
    Expect(0, 65024, '\p{Is_Blk=_ARABIC_pf_A}', "");
    Expect(1, 65024, '\p{^Is_Blk=_ARABIC_pf_A}', "");
    Expect(1, 65024, '\P{Is_Blk=_ARABIC_pf_A}', "");
    Expect(0, 65024, '\P{^Is_Blk=_ARABIC_pf_A}', "");
    Error('\p{Block=  arabic_Presentation_forms_B:=}');
    Error('\P{Block=  arabic_Presentation_forms_B:=}');
    Expect(1, 65279, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(0, 65280, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(0, 65280, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(1, 65279, '\p{Block=-arabic_presentation_Forms_B}', "");
    Expect(0, 65279, '\p{^Block=-arabic_presentation_Forms_B}', "");
    Expect(0, 65279, '\P{Block=-arabic_presentation_Forms_B}', "");
    Expect(1, 65279, '\P{^Block=-arabic_presentation_Forms_B}', "");
    Expect(0, 65280, '\p{Block=-arabic_presentation_Forms_B}', "");
    Expect(1, 65280, '\p{^Block=-arabic_presentation_Forms_B}', "");
    Expect(1, 65280, '\P{Block=-arabic_presentation_Forms_B}', "");
    Expect(0, 65280, '\P{^Block=-arabic_presentation_Forms_B}', "");
    Error('\p{Blk=_:=Arabic_pf_B}');
    Error('\P{Blk=_:=Arabic_pf_B}');
    Expect(1, 65279, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(1, 65279, '\p{Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(1, 65279, '\p{Blk=_arabic_pf_B}', "");
    Expect(0, 65279, '\p{^Blk=_arabic_pf_B}', "");
    Expect(0, 65279, '\P{Blk=_arabic_pf_B}', "");
    Expect(1, 65279, '\P{^Blk=_arabic_pf_B}', "");
    Expect(0, 65280, '\p{Blk=_arabic_pf_B}', "");
    Expect(1, 65280, '\p{^Blk=_arabic_pf_B}', "");
    Expect(1, 65280, '\P{Blk=_arabic_pf_B}', "");
    Expect(0, 65280, '\P{^Blk=_arabic_pf_B}', "");
    Error('\p{Is_Block= _arabic_Presentation_Forms_b:=}');
    Error('\P{Is_Block= _arabic_Presentation_Forms_b:=}');
    Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(0, 65279, '\p{^Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(0, 65279, '\P{Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(1, 65279, '\P{^Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(0, 65280, '\p{Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(1, 65280, '\p{^Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(1, 65280, '\P{Is_Block= -Arabic_Presentation_Forms_B}', "");
    Expect(0, 65280, '\P{^Is_Block= -Arabic_Presentation_Forms_B}', "");
    Error('\p{Is_Blk=-/a/ARABIC_pf_B}');
    Error('\P{Is_Blk=-/a/ARABIC_pf_B}');
    Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Is_Blk=Arabic_PF_B}', "");
    Expect(0, 65279, '\p{^Is_Blk=Arabic_PF_B}', "");
    Expect(0, 65279, '\P{Is_Blk=Arabic_PF_B}', "");
    Expect(1, 65279, '\P{^Is_Blk=Arabic_PF_B}', "");
    Expect(0, 65280, '\p{Is_Blk=Arabic_PF_B}', "");
    Expect(1, 65280, '\p{^Is_Blk=Arabic_PF_B}', "");
    Expect(1, 65280, '\P{Is_Blk=Arabic_PF_B}', "");
    Expect(0, 65280, '\P{^Is_Blk=Arabic_PF_B}', "");
    Error('\p{Block=/a/Arabic_supplement}');
    Error('\P{Block=/a/Arabic_supplement}');
    Expect(1, 1919, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(1, 1919, '\p{Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(1, 1919, '\p{Block=-arabic_Supplement}', "");
    Expect(0, 1919, '\p{^Block=-arabic_Supplement}', "");
    Expect(0, 1919, '\P{Block=-arabic_Supplement}', "");
    Expect(1, 1919, '\P{^Block=-arabic_Supplement}', "");
    Expect(0, 1920, '\p{Block=-arabic_Supplement}', "");
    Expect(1, 1920, '\p{^Block=-arabic_Supplement}', "");
    Expect(1, 1920, '\P{Block=-arabic_Supplement}', "");
    Expect(0, 1920, '\P{^Block=-arabic_Supplement}', "");
    Error('\p{Blk=:= arabic_Sup}');
    Error('\P{Blk=:= arabic_Sup}');
    Expect(1, 1919, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(1, 1919, '\p{Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(1, 1919, '\p{Blk= -Arabic_Sup}', "");
    Expect(0, 1919, '\p{^Blk= -Arabic_Sup}', "");
    Expect(0, 1919, '\P{Blk= -Arabic_Sup}', "");
    Expect(1, 1919, '\P{^Blk= -Arabic_Sup}', "");
    Expect(0, 1920, '\p{Blk= -Arabic_Sup}', "");
    Expect(1, 1920, '\p{^Blk= -Arabic_Sup}', "");
    Expect(1, 1920, '\P{Blk= -Arabic_Sup}', "");
    Expect(0, 1920, '\P{^Blk= -Arabic_Sup}', "");
    Error('\p{Is_Block=-arabic_Supplement/a/}');
    Error('\P{Is_Block=-arabic_Supplement/a/}');
    Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Is_Block=	Arabic_Supplement}', "");
    Expect(0, 1919, '\p{^Is_Block=	Arabic_Supplement}', "");
    Expect(0, 1919, '\P{Is_Block=	Arabic_Supplement}', "");
    Expect(1, 1919, '\P{^Is_Block=	Arabic_Supplement}', "");
    Expect(0, 1920, '\p{Is_Block=	Arabic_Supplement}', "");
    Expect(1, 1920, '\p{^Is_Block=	Arabic_Supplement}', "");
    Expect(1, 1920, '\P{Is_Block=	Arabic_Supplement}', "");
    Expect(0, 1920, '\P{^Is_Block=	Arabic_Supplement}', "");
    Error('\p{Is_Blk:_ ARABIC_Sup:=}');
    Error('\P{Is_Blk:_ ARABIC_Sup:=}');
    Expect(1, 1919, '\p{Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Is_Blk=-_Arabic_Sup}', "");
    Expect(0, 1919, '\p{^Is_Blk=-_Arabic_Sup}', "");
    Expect(0, 1919, '\P{Is_Blk=-_Arabic_Sup}', "");
    Expect(1, 1919, '\P{^Is_Blk=-_Arabic_Sup}', "");
    Expect(0, 1920, '\p{Is_Blk=-_Arabic_Sup}', "");
    Expect(1, 1920, '\p{^Is_Blk=-_Arabic_Sup}', "");
    Expect(1, 1920, '\P{Is_Blk=-_Arabic_Sup}', "");
    Expect(0, 1920, '\P{^Is_Blk=-_Arabic_Sup}', "");
    Error('\p{Block:    /a/armenian}');
    Error('\P{Block:    /a/armenian}');
    Expect(1, 1423, '\p{Block=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=armenian}', "");
    Expect(0, 1423, '\p{^Block=armenian}', "");
    Expect(0, 1423, '\P{Block=armenian}', "");
    Expect(1, 1423, '\P{^Block=armenian}', "");
    Expect(0, 1424, '\p{Block=armenian}', "");
    Expect(1, 1424, '\p{^Block=armenian}', "");
    Expect(1, 1424, '\P{Block=armenian}', "");
    Expect(0, 1424, '\P{^Block=armenian}', "");
    Expect(1, 1423, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=  ARMENIAN}', "");
    Expect(0, 1423, '\p{^Block=  ARMENIAN}', "");
    Expect(0, 1423, '\P{Block=  ARMENIAN}', "");
    Expect(1, 1423, '\P{^Block=  ARMENIAN}', "");
    Expect(0, 1424, '\p{Block=  ARMENIAN}', "");
    Expect(1, 1424, '\p{^Block=  ARMENIAN}', "");
    Expect(1, 1424, '\P{Block=  ARMENIAN}', "");
    Expect(0, 1424, '\P{^Block=  ARMENIAN}', "");
    Error('\p{Blk=	/a/Armenian}');
    Error('\P{Blk=	/a/Armenian}');
    Expect(1, 1423, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk:armenian}', "");
    Expect(0, 1423, '\p{^Blk:armenian}', "");
    Expect(0, 1423, '\P{Blk:armenian}', "");
    Expect(1, 1423, '\P{^Blk:armenian}', "");
    Expect(0, 1424, '\p{Blk:armenian}', "");
    Expect(1, 1424, '\p{^Blk:armenian}', "");
    Expect(1, 1424, '\P{Blk:armenian}', "");
    Expect(0, 1424, '\P{^Blk:armenian}', "");
    Expect(1, 1423, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk= -Armenian}', "");
    Expect(0, 1423, '\p{^Blk= -Armenian}', "");
    Expect(0, 1423, '\P{Blk= -Armenian}', "");
    Expect(1, 1423, '\P{^Blk= -Armenian}', "");
    Expect(0, 1424, '\p{Blk= -Armenian}', "");
    Expect(1, 1424, '\p{^Blk= -Armenian}', "");
    Expect(1, 1424, '\P{Blk= -Armenian}', "");
    Expect(0, 1424, '\P{^Blk= -Armenian}', "");
    Error('\p{Is_Block:		_armenian/a/}');
    Error('\P{Is_Block:		_armenian/a/}');
    Expect(1, 1423, '\p{Is_Block=armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=armenian}', "");
    Expect(0, 1423, '\P{Is_Block=armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=armenian}', "");
    Expect(0, 1424, '\p{Is_Block=armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=armenian}', "");
    Expect(1, 1424, '\P{Is_Block=armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=armenian}', "");
    Expect(1, 1423, '\p{Is_Block:		ARMENIAN}', "");
    Expect(0, 1423, '\p{^Is_Block:		ARMENIAN}', "");
    Expect(0, 1423, '\P{Is_Block:		ARMENIAN}', "");
    Expect(1, 1423, '\P{^Is_Block:		ARMENIAN}', "");
    Expect(0, 1424, '\p{Is_Block:		ARMENIAN}', "");
    Expect(1, 1424, '\p{^Is_Block:		ARMENIAN}', "");
    Expect(1, 1424, '\P{Is_Block:		ARMENIAN}', "");
    Expect(0, 1424, '\P{^Is_Block:		ARMENIAN}', "");
    Error('\p{Is_Blk=:=		Armenian}');
    Error('\P{Is_Blk=:=		Armenian}');
    Expect(1, 1423, '\p{Is_Blk=armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
    Expect(0, 1423, '\P{Is_Blk=armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
    Expect(0, 1424, '\p{Is_Blk=armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk=armenian}', "");
    Expect(1, 1424, '\P{Is_Blk=armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk=armenian}', "");
    Expect(1, 1423, '\p{Is_Blk=-ARMENIAN}', "");
    Expect(0, 1423, '\p{^Is_Blk=-ARMENIAN}', "");
    Expect(0, 1423, '\P{Is_Blk=-ARMENIAN}', "");
    Expect(1, 1423, '\P{^Is_Blk=-ARMENIAN}', "");
    Expect(0, 1424, '\p{Is_Blk=-ARMENIAN}', "");
    Expect(1, 1424, '\p{^Is_Blk=-ARMENIAN}', "");
    Expect(1, 1424, '\P{Is_Blk=-ARMENIAN}', "");
    Expect(0, 1424, '\P{^Is_Blk=-ARMENIAN}', "");
    Error('\p{Block=-:=Arrows}');
    Error('\P{Block=-:=Arrows}');
    Expect(1, 8703, '\p{Block=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Block:arrows}', "");
    Expect(0, 8703, '\p{^Block:arrows}', "");
    Expect(0, 8703, '\P{Block:arrows}', "");
    Expect(1, 8703, '\P{^Block:arrows}', "");
    Expect(0, 8704, '\p{Block:arrows}', "");
    Expect(1, 8704, '\p{^Block:arrows}', "");
    Expect(1, 8704, '\P{Block:arrows}', "");
    Expect(0, 8704, '\P{^Block:arrows}', "");
    Expect(1, 8703, '\p{Block=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Block=	_ARROWS}', "");
    Expect(0, 8703, '\p{^Block=	_ARROWS}', "");
    Expect(0, 8703, '\P{Block=	_ARROWS}', "");
    Expect(1, 8703, '\P{^Block=	_ARROWS}', "");
    Expect(0, 8704, '\p{Block=	_ARROWS}', "");
    Expect(1, 8704, '\p{^Block=	_ARROWS}', "");
    Expect(1, 8704, '\P{Block=	_ARROWS}', "");
    Expect(0, 8704, '\P{^Block=	_ARROWS}', "");
    Error('\p{Blk:_:=Arrows}');
    Error('\P{Blk:_:=Arrows}');
    Expect(1, 8703, '\p{Blk=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=arrows}', "");
    Expect(0, 8703, '\p{^Blk=arrows}', "");
    Expect(0, 8703, '\P{Blk=arrows}', "");
    Expect(1, 8703, '\P{^Blk=arrows}', "");
    Expect(0, 8704, '\p{Blk=arrows}', "");
    Expect(1, 8704, '\p{^Blk=arrows}', "");
    Expect(1, 8704, '\P{Blk=arrows}', "");
    Expect(0, 8704, '\P{^Blk=arrows}', "");
    Expect(1, 8703, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Blk:    arrows}', "");
    Expect(0, 8703, '\p{^Blk:    arrows}', "");
    Expect(0, 8703, '\P{Blk:    arrows}', "");
    Expect(1, 8703, '\P{^Blk:    arrows}', "");
    Expect(0, 8704, '\p{Blk:    arrows}', "");
    Expect(1, 8704, '\p{^Blk:    arrows}', "");
    Expect(1, 8704, '\P{Blk:    arrows}', "");
    Expect(0, 8704, '\P{^Blk:    arrows}', "");
    Error('\p{Is_Block=	_Arrows/a/}');
    Error('\P{Is_Block=	_Arrows/a/}');
    Expect(1, 8703, '\p{Is_Block=arrows}', "");
    Expect(0, 8703, '\p{^Is_Block=arrows}', "");
    Expect(0, 8703, '\P{Is_Block=arrows}', "");
    Expect(1, 8703, '\P{^Is_Block=arrows}', "");
    Expect(0, 8704, '\p{Is_Block=arrows}', "");
    Expect(1, 8704, '\p{^Is_Block=arrows}', "");
    Expect(1, 8704, '\P{Is_Block=arrows}', "");
    Expect(0, 8704, '\P{^Is_Block=arrows}', "");
    Expect(1, 8703, '\p{Is_Block=--ARROWS}', "");
    Expect(0, 8703, '\p{^Is_Block=--ARROWS}', "");
    Expect(0, 8703, '\P{Is_Block=--ARROWS}', "");
    Expect(1, 8703, '\P{^Is_Block=--ARROWS}', "");
    Expect(0, 8704, '\p{Is_Block=--ARROWS}', "");
    Expect(1, 8704, '\p{^Is_Block=--ARROWS}', "");
    Expect(1, 8704, '\P{Is_Block=--ARROWS}', "");
    Expect(0, 8704, '\P{^Is_Block=--ARROWS}', "");
    Error('\p{Is_Blk= Arrows:=}');
    Error('\P{Is_Blk= Arrows:=}');
    Expect(1, 8703, '\p{Is_Blk=arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=arrows}', "");
    Expect(1, 8703, '\p{Is_Blk:	-_arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk:	-_arrows}', "");
    Expect(0, 8703, '\P{Is_Blk:	-_arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk:	-_arrows}', "");
    Expect(0, 8704, '\p{Is_Blk:	-_arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk:	-_arrows}', "");
    Expect(1, 8704, '\P{Is_Blk:	-_arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk:	-_arrows}', "");
    Error('\p{Block= 	BASIC_Latin:=}');
    Error('\P{Block= 	BASIC_Latin:=}');
    Expect(1, 127, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(0, 128, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(1, 127, '\p{Block: basiclatin}', "");
    Expect(0, 127, '\p{^Block: basiclatin}', "");
    Expect(0, 127, '\P{Block: basiclatin}', "");
    Expect(1, 127, '\P{^Block: basiclatin}', "");
    Expect(0, 128, '\p{Block: basiclatin}', "");
    Expect(1, 128, '\p{^Block: basiclatin}', "");
    Expect(1, 128, '\P{Block: basiclatin}', "");
    Expect(0, 128, '\P{^Block: basiclatin}', "");
    Expect(1, 127, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(0, 128, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(1, 127, '\p{Block=	basic_LATIN}', "");
    Expect(0, 127, '\p{^Block=	basic_LATIN}', "");
    Expect(0, 127, '\P{Block=	basic_LATIN}', "");
    Expect(1, 127, '\P{^Block=	basic_LATIN}', "");
    Expect(0, 128, '\p{Block=	basic_LATIN}', "");
    Expect(1, 128, '\p{^Block=	basic_LATIN}', "");
    Expect(1, 128, '\P{Block=	basic_LATIN}', "");
    Expect(0, 128, '\P{^Block=	basic_LATIN}', "");
    Error('\p{Blk=:= -ASCII}');
    Error('\P{Blk=:= -ASCII}');
    Expect(1, 127, '\p{Blk=:\AASCII\z:}', "");;
    Expect(0, 128, '\p{Blk=:\AASCII\z:}', "");;
    Expect(1, 127, '\p{Blk=ascii}', "");
    Expect(0, 127, '\p{^Blk=ascii}', "");
    Expect(0, 127, '\P{Blk=ascii}', "");
    Expect(1, 127, '\P{^Blk=ascii}', "");
    Expect(0, 128, '\p{Blk=ascii}', "");
    Expect(1, 128, '\p{^Blk=ascii}', "");
    Expect(1, 128, '\P{Blk=ascii}', "");
    Expect(0, 128, '\P{^Blk=ascii}', "");
    Expect(1, 127, '\p{Blk=:\Aascii\z:}', "");;
    Expect(0, 128, '\p{Blk=:\Aascii\z:}', "");;
    Expect(1, 127, '\p{Blk: _	ASCII}', "");
    Expect(0, 127, '\p{^Blk: _	ASCII}', "");
    Expect(0, 127, '\P{Blk: _	ASCII}', "");
    Expect(1, 127, '\P{^Blk: _	ASCII}', "");
    Expect(0, 128, '\p{Blk: _	ASCII}', "");
    Expect(1, 128, '\p{^Blk: _	ASCII}', "");
    Expect(1, 128, '\P{Blk: _	ASCII}', "");
    Expect(0, 128, '\P{^Blk: _	ASCII}', "");
    Error('\p{Is_Block=:=		Basic_latin}');
    Error('\P{Is_Block=:=		Basic_latin}');
    Expect(1, 127, '\p{Is_Block=basiclatin}', "");
    Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
    Expect(0, 127, '\P{Is_Block=basiclatin}', "");
    Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
    Expect(0, 128, '\p{Is_Block=basiclatin}', "");
    Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
    Expect(1, 128, '\P{Is_Block=basiclatin}', "");
    Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
    Expect(1, 127, '\p{Is_Block=_	BASIC_Latin}', "");
    Expect(0, 127, '\p{^Is_Block=_	BASIC_Latin}', "");
    Expect(0, 127, '\P{Is_Block=_	BASIC_Latin}', "");
    Expect(1, 127, '\P{^Is_Block=_	BASIC_Latin}', "");
    Expect(0, 128, '\p{Is_Block=_	BASIC_Latin}', "");
    Expect(1, 128, '\p{^Is_Block=_	BASIC_Latin}', "");
    Expect(1, 128, '\P{Is_Block=_	BASIC_Latin}', "");
    Expect(0, 128, '\P{^Is_Block=_	BASIC_Latin}', "");
    Error('\p{Is_Blk=_ ASCII:=}');
    Error('\P{Is_Blk=_ ASCII:=}');
    Expect(1, 127, '\p{Is_Blk=ascii}', "");
    Expect(0, 127, '\p{^Is_Blk=ascii}', "");
    Expect(0, 127, '\P{Is_Blk=ascii}', "");
    Expect(1, 127, '\P{^Is_Blk=ascii}', "");
    Expect(0, 128, '\p{Is_Blk=ascii}', "");
    Expect(1, 128, '\p{^Is_Blk=ascii}', "");
    Expect(1, 128, '\P{Is_Blk=ascii}', "");
    Expect(0, 128, '\P{^Is_Blk=ascii}', "");
    Expect(1, 127, '\p{Is_Blk= -ascii}', "");
    Expect(0, 127, '\p{^Is_Blk= -ascii}', "");
    Expect(0, 127, '\P{Is_Blk= -ascii}', "");
    Expect(1, 127, '\P{^Is_Blk= -ascii}', "");
    Expect(0, 128, '\p{Is_Blk= -ascii}', "");
    Expect(1, 128, '\p{^Is_Blk= -ascii}', "");
    Expect(1, 128, '\P{Is_Blk= -ascii}', "");
    Expect(0, 128, '\P{^Is_Blk= -ascii}', "");
    Error('\p{Block= 	AVESTAN:=}');
    Error('\P{Block= 	AVESTAN:=}');
    Expect(1, 68415, '\p{Block=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Block=avestan}', "");
    Expect(0, 68415, '\p{^Block=avestan}', "");
    Expect(0, 68415, '\P{Block=avestan}', "");
    Expect(1, 68415, '\P{^Block=avestan}', "");
    Expect(0, 68416, '\p{Block=avestan}', "");
    Expect(1, 68416, '\p{^Block=avestan}', "");
    Expect(1, 68416, '\P{Block=avestan}', "");
    Expect(0, 68416, '\P{^Block=avestan}', "");
    Expect(1, 68415, '\p{Block=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Block=-_Avestan}', "");
    Expect(0, 68415, '\p{^Block=-_Avestan}', "");
    Expect(0, 68415, '\P{Block=-_Avestan}', "");
    Expect(1, 68415, '\P{^Block=-_Avestan}', "");
    Expect(0, 68416, '\p{Block=-_Avestan}', "");
    Expect(1, 68416, '\p{^Block=-_Avestan}', "");
    Expect(1, 68416, '\P{Block=-_Avestan}', "");
    Expect(0, 68416, '\P{^Block=-_Avestan}', "");
    Error('\p{Blk=_/a/Avestan}');
    Error('\P{Blk=_/a/Avestan}');
    Expect(1, 68415, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Blk=avestan}', "");
    Expect(0, 68415, '\p{^Blk=avestan}', "");
    Expect(0, 68415, '\P{Blk=avestan}', "");
    Expect(1, 68415, '\P{^Blk=avestan}', "");
    Expect(0, 68416, '\p{Blk=avestan}', "");
    Expect(1, 68416, '\p{^Blk=avestan}', "");
    Expect(1, 68416, '\P{Blk=avestan}', "");
    Expect(0, 68416, '\P{^Blk=avestan}', "");
    Expect(1, 68415, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Blk=	_Avestan}', "");
    Expect(0, 68415, '\p{^Blk=	_Avestan}', "");
    Expect(0, 68415, '\P{Blk=	_Avestan}', "");
    Expect(1, 68415, '\P{^Blk=	_Avestan}', "");
    Expect(0, 68416, '\p{Blk=	_Avestan}', "");
    Expect(1, 68416, '\p{^Blk=	_Avestan}', "");
    Expect(1, 68416, '\P{Blk=	_Avestan}', "");
    Expect(0, 68416, '\P{^Blk=	_Avestan}', "");
    Error('\p{Is_Block=--avestan/a/}');
    Error('\P{Is_Block=--avestan/a/}');
    Expect(1, 68415, '\p{Is_Block=avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=avestan}', "");
    Expect(0, 68415, '\P{Is_Block=avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=avestan}', "");
    Expect(0, 68416, '\p{Is_Block=avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=avestan}', "");
    Expect(1, 68416, '\P{Is_Block=avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=avestan}', "");
    Expect(1, 68415, '\p{Is_Block=-avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=-avestan}', "");
    Expect(0, 68415, '\P{Is_Block=-avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=-avestan}', "");
    Expect(0, 68416, '\p{Is_Block=-avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=-avestan}', "");
    Expect(1, 68416, '\P{Is_Block=-avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=-avestan}', "");
    Error('\p{Is_Blk=-Avestan/a/}');
    Error('\P{Is_Blk=-Avestan/a/}');
    Expect(1, 68415, '\p{Is_Blk=avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk=avestan}', "");
    Expect(0, 68415, '\P{Is_Blk=avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk=avestan}', "");
    Expect(0, 68416, '\p{Is_Blk=avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk=avestan}', "");
    Expect(1, 68416, '\P{Is_Blk=avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk=avestan}', "");
    Expect(1, 68415, '\p{Is_Blk:    Avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk:    Avestan}', "");
    Expect(0, 68415, '\P{Is_Blk:    Avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk:    Avestan}', "");
    Expect(0, 68416, '\p{Is_Blk:    Avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk:    Avestan}', "");
    Expect(1, 68416, '\P{Is_Blk:    Avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk:    Avestan}', "");
    Error('\p{Block= -BALINESE:=}');
    Error('\P{Block= -BALINESE:=}');
    Expect(1, 7039, '\p{Block=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Block:	balinese}', "");
    Expect(0, 7039, '\p{^Block:	balinese}', "");
    Expect(0, 7039, '\P{Block:	balinese}', "");
    Expect(1, 7039, '\P{^Block:	balinese}', "");
    Expect(0, 7040, '\p{Block:	balinese}', "");
    Expect(1, 7040, '\p{^Block:	balinese}', "");
    Expect(1, 7040, '\P{Block:	balinese}', "");
    Expect(0, 7040, '\P{^Block:	balinese}', "");
    Expect(1, 7039, '\p{Block=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Block=_ Balinese}', "");
    Expect(0, 7039, '\p{^Block=_ Balinese}', "");
    Expect(0, 7039, '\P{Block=_ Balinese}', "");
    Expect(1, 7039, '\P{^Block=_ Balinese}', "");
    Expect(0, 7040, '\p{Block=_ Balinese}', "");
    Expect(1, 7040, '\p{^Block=_ Balinese}', "");
    Expect(1, 7040, '\P{Block=_ Balinese}', "");
    Expect(0, 7040, '\P{^Block=_ Balinese}', "");
    Error('\p{Blk::=_BALINESE}');
    Error('\P{Blk::=_BALINESE}');
    Expect(1, 7039, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=balinese}', "");
    Expect(0, 7039, '\p{^Blk=balinese}', "");
    Expect(0, 7039, '\P{Blk=balinese}', "");
    Expect(1, 7039, '\P{^Blk=balinese}', "");
    Expect(0, 7040, '\p{Blk=balinese}', "");
    Expect(1, 7040, '\p{^Blk=balinese}', "");
    Expect(1, 7040, '\P{Blk=balinese}', "");
    Expect(0, 7040, '\P{^Blk=balinese}', "");
    Expect(1, 7039, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk:_balinese}', "");
    Expect(0, 7039, '\p{^Blk:_balinese}', "");
    Expect(0, 7039, '\P{Blk:_balinese}', "");
    Expect(1, 7039, '\P{^Blk:_balinese}', "");
    Expect(0, 7040, '\p{Blk:_balinese}', "");
    Expect(1, 7040, '\p{^Blk:_balinese}', "");
    Expect(1, 7040, '\P{Blk:_balinese}', "");
    Expect(0, 7040, '\P{^Blk:_balinese}', "");
    Error('\p{Is_Block=_	Balinese:=}');
    Error('\P{Is_Block=_	Balinese:=}');
    Expect(1, 7039, '\p{Is_Block=balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=balinese}', "");
    Expect(0, 7039, '\P{Is_Block=balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=balinese}', "");
    Expect(0, 7040, '\p{Is_Block=balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=balinese}', "");
    Expect(1, 7040, '\P{Is_Block=balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=balinese}', "");
    Expect(1, 7039, '\p{Is_Block=_balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=_balinese}', "");
    Expect(0, 7039, '\P{Is_Block=_balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=_balinese}', "");
    Expect(0, 7040, '\p{Is_Block=_balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=_balinese}', "");
    Expect(1, 7040, '\P{Is_Block=_balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=_balinese}', "");
    Error('\p{Is_Blk::=-	Balinese}');
    Error('\P{Is_Blk::=-	Balinese}');
    Expect(1, 7039, '\p{Is_Blk=balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
    Expect(1, 7039, '\p{Is_Blk=- Balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=- Balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=- Balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=- Balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=- Balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=- Balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=- Balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=- Balinese}', "");
    Error('\p{Block=/a/	_Bamum}');
    Error('\P{Block=/a/	_Bamum}');
    Expect(1, 42751, '\p{Block=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Block=bamum}', "");
    Expect(0, 42751, '\p{^Block=bamum}', "");
    Expect(0, 42751, '\P{Block=bamum}', "");
    Expect(1, 42751, '\P{^Block=bamum}', "");
    Expect(0, 42752, '\p{Block=bamum}', "");
    Expect(1, 42752, '\p{^Block=bamum}', "");
    Expect(1, 42752, '\P{Block=bamum}', "");
    Expect(0, 42752, '\P{^Block=bamum}', "");
    Expect(1, 42751, '\p{Block=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Block=__BAMUM}', "");
    Expect(0, 42751, '\p{^Block=__BAMUM}', "");
    Expect(0, 42751, '\P{Block=__BAMUM}', "");
    Expect(1, 42751, '\P{^Block=__BAMUM}', "");
    Expect(0, 42752, '\p{Block=__BAMUM}', "");
    Expect(1, 42752, '\p{^Block=__BAMUM}', "");
    Expect(1, 42752, '\P{Block=__BAMUM}', "");
    Expect(0, 42752, '\P{^Block=__BAMUM}', "");
    Error('\p{Blk=		bamum:=}');
    Error('\P{Blk=		bamum:=}');
    Expect(1, 42751, '\p{Blk=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=bamum}', "");
    Expect(0, 42751, '\p{^Blk=bamum}', "");
    Expect(0, 42751, '\P{Blk=bamum}', "");
    Expect(1, 42751, '\P{^Blk=bamum}', "");
    Expect(0, 42752, '\p{Blk=bamum}', "");
    Expect(1, 42752, '\p{^Blk=bamum}', "");
    Expect(1, 42752, '\P{Blk=bamum}', "");
    Expect(0, 42752, '\P{^Blk=bamum}', "");
    Expect(1, 42751, '\p{Blk=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=	 Bamum}', "");
    Expect(0, 42751, '\p{^Blk=	 Bamum}', "");
    Expect(0, 42751, '\P{Blk=	 Bamum}', "");
    Expect(1, 42751, '\P{^Blk=	 Bamum}', "");
    Expect(0, 42752, '\p{Blk=	 Bamum}', "");
    Expect(1, 42752, '\p{^Blk=	 Bamum}', "");
    Expect(1, 42752, '\P{Blk=	 Bamum}', "");
    Expect(0, 42752, '\P{^Blk=	 Bamum}', "");
    Error('\p{Is_Block=/a/	 Bamum}');
    Error('\P{Is_Block=/a/	 Bamum}');
    Expect(1, 42751, '\p{Is_Block=bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=bamum}', "");
    Expect(0, 42751, '\P{Is_Block=bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=bamum}', "");
    Expect(0, 42752, '\p{Is_Block=bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=bamum}', "");
    Expect(1, 42752, '\P{Is_Block=bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=bamum}', "");
    Expect(1, 42751, '\p{Is_Block=__Bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=__Bamum}', "");
    Expect(0, 42751, '\P{Is_Block=__Bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=__Bamum}', "");
    Expect(0, 42752, '\p{Is_Block=__Bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=__Bamum}', "");
    Expect(1, 42752, '\P{Is_Block=__Bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=__Bamum}', "");
    Error('\p{Is_Blk=/a/-Bamum}');
    Error('\P{Is_Blk=/a/-Bamum}');
    Expect(1, 42751, '\p{Is_Blk=bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
    Expect(1, 42751, '\p{Is_Blk=		BAMUM}', "");
    Expect(0, 42751, '\p{^Is_Blk=		BAMUM}', "");
    Expect(0, 42751, '\P{Is_Blk=		BAMUM}', "");
    Expect(1, 42751, '\P{^Is_Blk=		BAMUM}', "");
    Expect(0, 42752, '\p{Is_Blk=		BAMUM}', "");
    Expect(1, 42752, '\p{^Is_Blk=		BAMUM}', "");
    Expect(1, 42752, '\P{Is_Blk=		BAMUM}', "");
    Expect(0, 42752, '\P{^Is_Blk=		BAMUM}', "");
    Error('\p{Block= 	Bamum_Supplement:=}');
    Error('\P{Block= 	Bamum_Supplement:=}');
    Expect(1, 92735, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(1, 92735, '\p{Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(1, 92735, '\p{Block=--Bamum_Supplement}', "");
    Expect(0, 92735, '\p{^Block=--Bamum_Supplement}', "");
    Expect(0, 92735, '\P{Block=--Bamum_Supplement}', "");
    Expect(1, 92735, '\P{^Block=--Bamum_Supplement}', "");
    Expect(0, 92736, '\p{Block=--Bamum_Supplement}', "");
    Expect(1, 92736, '\p{^Block=--Bamum_Supplement}', "");
    Expect(1, 92736, '\P{Block=--Bamum_Supplement}', "");
    Expect(0, 92736, '\P{^Block=--Bamum_Supplement}', "");
    Error('\p{Blk=:=_bamum_SUP}');
    Error('\P{Blk=:=_bamum_SUP}');
    Expect(1, 92735, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(1, 92735, '\p{Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(1, 92735, '\p{Blk=-Bamum_Sup}', "");
    Expect(0, 92735, '\p{^Blk=-Bamum_Sup}', "");
    Expect(0, 92735, '\P{Blk=-Bamum_Sup}', "");
    Expect(1, 92735, '\P{^Blk=-Bamum_Sup}', "");
    Expect(0, 92736, '\p{Blk=-Bamum_Sup}', "");
    Expect(1, 92736, '\p{^Blk=-Bamum_Sup}', "");
    Expect(1, 92736, '\P{Blk=-Bamum_Sup}', "");
    Expect(0, 92736, '\P{^Blk=-Bamum_Sup}', "");
    Error('\p{Is_Block=_:=Bamum_SUPPLEMENT}');
    Error('\P{Is_Block=_:=Bamum_SUPPLEMENT}');
    Expect(1, 92735, '\p{Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(0, 92735, '\p{^Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(0, 92735, '\P{Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(1, 92735, '\P{^Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(0, 92736, '\p{Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(1, 92736, '\p{^Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(1, 92736, '\P{Is_Block=	_Bamum_SUPPLEMENT}', "");
    Expect(0, 92736, '\P{^Is_Block=	_Bamum_SUPPLEMENT}', "");
    Error('\p{Is_Blk=-/a/Bamum_Sup}');
    Error('\P{Is_Blk=-/a/Bamum_Sup}');
    Expect(1, 92735, '\p{Is_Blk:bamumsup}', "");
    Expect(0, 92735, '\p{^Is_Blk:bamumsup}', "");
    Expect(0, 92735, '\P{Is_Blk:bamumsup}', "");
    Expect(1, 92735, '\P{^Is_Blk:bamumsup}', "");
    Expect(0, 92736, '\p{Is_Blk:bamumsup}', "");
    Expect(1, 92736, '\p{^Is_Blk:bamumsup}', "");
    Expect(1, 92736, '\P{Is_Blk:bamumsup}', "");
    Expect(0, 92736, '\P{^Is_Blk:bamumsup}', "");
    Expect(1, 92735, '\p{Is_Blk= Bamum_Sup}', "");
    Expect(0, 92735, '\p{^Is_Blk= Bamum_Sup}', "");
    Expect(0, 92735, '\P{Is_Blk= Bamum_Sup}', "");
    Expect(1, 92735, '\P{^Is_Blk= Bamum_Sup}', "");
    Expect(0, 92736, '\p{Is_Blk= Bamum_Sup}', "");
    Expect(1, 92736, '\p{^Is_Blk= Bamum_Sup}', "");
    Expect(1, 92736, '\P{Is_Blk= Bamum_Sup}', "");
    Expect(0, 92736, '\P{^Is_Blk= Bamum_Sup}', "");
    Error('\p{Block=-/a/bassa_Vah}');
    Error('\P{Block=-/a/bassa_Vah}');
    Expect(1, 92927, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Block:   bassavah}', "");
    Expect(0, 92927, '\p{^Block:   bassavah}', "");
    Expect(0, 92927, '\P{Block:   bassavah}', "");
    Expect(1, 92927, '\P{^Block:   bassavah}', "");
    Expect(0, 92928, '\p{Block:   bassavah}', "");
    Expect(1, 92928, '\p{^Block:   bassavah}', "");
    Expect(1, 92928, '\P{Block:   bassavah}', "");
    Expect(0, 92928, '\P{^Block:   bassavah}', "");
    Expect(1, 92927, '\p{Block=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Block=-_BASSA_Vah}', "");
    Expect(0, 92927, '\p{^Block=-_BASSA_Vah}', "");
    Expect(0, 92927, '\P{Block=-_BASSA_Vah}', "");
    Expect(1, 92927, '\P{^Block=-_BASSA_Vah}', "");
    Expect(0, 92928, '\p{Block=-_BASSA_Vah}', "");
    Expect(1, 92928, '\p{^Block=-_BASSA_Vah}', "");
    Expect(1, 92928, '\P{Block=-_BASSA_Vah}', "");
    Expect(0, 92928, '\P{^Block=-_BASSA_Vah}', "");
    Error('\p{Blk=-/a/Bassa_vah}');
    Error('\P{Blk=-/a/Bassa_vah}');
    Expect(1, 92927, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Blk=bassavah}', "");
    Expect(0, 92927, '\P{Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Blk=bassavah}', "");
    Expect(0, 92928, '\p{Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Blk=bassavah}', "");
    Expect(1, 92928, '\P{Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Blk=bassavah}', "");
    Expect(1, 92927, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Blk:	_BASSA_VAH}', "");
    Expect(0, 92927, '\p{^Blk:	_BASSA_VAH}', "");
    Expect(0, 92927, '\P{Blk:	_BASSA_VAH}', "");
    Expect(1, 92927, '\P{^Blk:	_BASSA_VAH}', "");
    Expect(0, 92928, '\p{Blk:	_BASSA_VAH}', "");
    Expect(1, 92928, '\p{^Blk:	_BASSA_VAH}', "");
    Expect(1, 92928, '\P{Blk:	_BASSA_VAH}', "");
    Expect(0, 92928, '\P{^Blk:	_BASSA_VAH}', "");
    Error('\p{Is_Block=	bassa_Vah/a/}');
    Error('\P{Is_Block=	bassa_Vah/a/}');
    Expect(1, 92927, '\p{Is_Block:bassavah}', "");
    Expect(0, 92927, '\p{^Is_Block:bassavah}', "");
    Expect(0, 92927, '\P{Is_Block:bassavah}', "");
    Expect(1, 92927, '\P{^Is_Block:bassavah}', "");
    Expect(0, 92928, '\p{Is_Block:bassavah}', "");
    Expect(1, 92928, '\p{^Is_Block:bassavah}', "");
    Expect(1, 92928, '\P{Is_Block:bassavah}', "");
    Expect(0, 92928, '\P{^Is_Block:bassavah}', "");
    Expect(1, 92927, '\p{Is_Block=_-Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Is_Block=_-Bassa_Vah}', "");
    Expect(0, 92927, '\P{Is_Block=_-Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Is_Block=_-Bassa_Vah}', "");
    Expect(0, 92928, '\p{Is_Block=_-Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Is_Block=_-Bassa_Vah}', "");
    Expect(1, 92928, '\P{Is_Block=_-Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Is_Block=_-Bassa_Vah}', "");
    Error('\p{Is_Blk=-:=bassa_Vah}');
    Error('\P{Is_Blk=-:=bassa_Vah}');
    Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
    Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
    Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
    Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
    Expect(1, 92927, '\p{Is_Blk:   -BASSA_Vah}', "");
    Expect(0, 92927, '\p{^Is_Blk:   -BASSA_Vah}', "");
    Expect(0, 92927, '\P{Is_Blk:   -BASSA_Vah}', "");
    Expect(1, 92927, '\P{^Is_Blk:   -BASSA_Vah}', "");
    Expect(0, 92928, '\p{Is_Blk:   -BASSA_Vah}', "");
    Expect(1, 92928, '\p{^Is_Blk:   -BASSA_Vah}', "");
    Expect(1, 92928, '\P{Is_Blk:   -BASSA_Vah}', "");
    Expect(0, 92928, '\P{^Is_Blk:   -BASSA_Vah}', "");
    Error('\p{Block:-batak:=}');
    Error('\P{Block:-batak:=}');
    Expect(1, 7167, '\p{Block=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Block=batak}', "");
    Expect(0, 7167, '\p{^Block=batak}', "");
    Expect(0, 7167, '\P{Block=batak}', "");
    Expect(1, 7167, '\P{^Block=batak}', "");
    Expect(0, 7168, '\p{Block=batak}', "");
    Expect(1, 7168, '\p{^Block=batak}', "");
    Expect(1, 7168, '\P{Block=batak}', "");
    Expect(0, 7168, '\P{^Block=batak}', "");
    Expect(1, 7167, '\p{Block=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Block=--batak}', "");
    Expect(0, 7167, '\p{^Block=--batak}', "");
    Expect(0, 7167, '\P{Block=--batak}', "");
    Expect(1, 7167, '\P{^Block=--batak}', "");
    Expect(0, 7168, '\p{Block=--batak}', "");
    Expect(1, 7168, '\p{^Block=--batak}', "");
    Expect(1, 7168, '\P{Block=--batak}', "");
    Expect(0, 7168, '\P{^Block=--batak}', "");
    Error('\p{Blk=	 Batak/a/}');
    Error('\P{Blk=	 Batak/a/}');
    Expect(1, 7167, '\p{Blk=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Blk=batak}', "");
    Expect(0, 7167, '\p{^Blk=batak}', "");
    Expect(0, 7167, '\P{Blk=batak}', "");
    Expect(1, 7167, '\P{^Blk=batak}', "");
    Expect(0, 7168, '\p{Blk=batak}', "");
    Expect(1, 7168, '\p{^Blk=batak}', "");
    Expect(1, 7168, '\P{Blk=batak}', "");
    Expect(0, 7168, '\P{^Blk=batak}', "");
    Expect(1, 7167, '\p{Blk=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Blk= Batak}', "");
    Expect(0, 7167, '\p{^Blk= Batak}', "");
    Expect(0, 7167, '\P{Blk= Batak}', "");
    Expect(1, 7167, '\P{^Blk= Batak}', "");
    Expect(0, 7168, '\p{Blk= Batak}', "");
    Expect(1, 7168, '\p{^Blk= Batak}', "");
    Expect(1, 7168, '\P{Blk= Batak}', "");
    Expect(0, 7168, '\P{^Blk= Batak}', "");
    Error('\p{Is_Block=-:=batak}');
    Error('\P{Is_Block=-:=batak}');
    Expect(1, 7167, '\p{Is_Block=batak}', "");
    Expect(0, 7167, '\p{^Is_Block=batak}', "");
    Expect(0, 7167, '\P{Is_Block=batak}', "");
    Expect(1, 7167, '\P{^Is_Block=batak}', "");
    Expect(0, 7168, '\p{Is_Block=batak}', "");
    Expect(1, 7168, '\p{^Is_Block=batak}', "");
    Expect(1, 7168, '\P{Is_Block=batak}', "");
    Expect(0, 7168, '\P{^Is_Block=batak}', "");
    Expect(1, 7167, '\p{Is_Block=	-Batak}', "");
    Expect(0, 7167, '\p{^Is_Block=	-Batak}', "");
    Expect(0, 7167, '\P{Is_Block=	-Batak}', "");
    Expect(1, 7167, '\P{^Is_Block=	-Batak}', "");
    Expect(0, 7168, '\p{Is_Block=	-Batak}', "");
    Expect(1, 7168, '\p{^Is_Block=	-Batak}', "");
    Expect(1, 7168, '\P{Is_Block=	-Batak}', "");
    Expect(0, 7168, '\P{^Is_Block=	-Batak}', "");
    Error('\p{Is_Blk=	/a/Batak}');
    Error('\P{Is_Blk=	/a/Batak}');
    Expect(1, 7167, '\p{Is_Blk=batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=batak}', "");
    Expect(0, 7167, '\P{Is_Blk=batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=batak}', "");
    Expect(0, 7168, '\p{Is_Blk=batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=batak}', "");
    Expect(1, 7168, '\P{Is_Blk=batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=batak}', "");
    Expect(1, 7167, '\p{Is_Blk=	 Batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=	 Batak}', "");
    Expect(0, 7167, '\P{Is_Blk=	 Batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=	 Batak}', "");
    Expect(0, 7168, '\p{Is_Blk=	 Batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=	 Batak}', "");
    Expect(1, 7168, '\P{Is_Blk=	 Batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=	 Batak}', "");
    Error('\p{Block=:= BENGALI}');
    Error('\P{Block=:= BENGALI}');
    Expect(1, 2559, '\p{Block=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Block:   bengali}', "");
    Expect(0, 2559, '\p{^Block:   bengali}', "");
    Expect(0, 2559, '\P{Block:   bengali}', "");
    Expect(1, 2559, '\P{^Block:   bengali}', "");
    Expect(0, 2560, '\p{Block:   bengali}', "");
    Expect(1, 2560, '\p{^Block:   bengali}', "");
    Expect(1, 2560, '\P{Block:   bengali}', "");
    Expect(0, 2560, '\P{^Block:   bengali}', "");
    Expect(1, 2559, '\p{Block=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Block=-bengali}', "");
    Expect(0, 2559, '\p{^Block=-bengali}', "");
    Expect(0, 2559, '\P{Block=-bengali}', "");
    Expect(1, 2559, '\P{^Block=-bengali}', "");
    Expect(0, 2560, '\p{Block=-bengali}', "");
    Expect(1, 2560, '\p{^Block=-bengali}', "");
    Expect(1, 2560, '\P{Block=-bengali}', "");
    Expect(0, 2560, '\P{^Block=-bengali}', "");
    Error('\p{Blk=:=Bengali}');
    Error('\P{Blk=:=Bengali}');
    Expect(1, 2559, '\p{Blk=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Blk=bengali}', "");
    Expect(0, 2559, '\p{^Blk=bengali}', "");
    Expect(0, 2559, '\P{Blk=bengali}', "");
    Expect(1, 2559, '\P{^Blk=bengali}', "");
    Expect(0, 2560, '\p{Blk=bengali}', "");
    Expect(1, 2560, '\p{^Blk=bengali}', "");
    Expect(1, 2560, '\P{Blk=bengali}', "");
    Expect(0, 2560, '\P{^Blk=bengali}', "");
    Expect(1, 2559, '\p{Blk=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Blk= 	BENGALI}', "");
    Expect(0, 2559, '\p{^Blk= 	BENGALI}', "");
    Expect(0, 2559, '\P{Blk= 	BENGALI}', "");
    Expect(1, 2559, '\P{^Blk= 	BENGALI}', "");
    Expect(0, 2560, '\p{Blk= 	BENGALI}', "");
    Expect(1, 2560, '\p{^Blk= 	BENGALI}', "");
    Expect(1, 2560, '\P{Blk= 	BENGALI}', "");
    Expect(0, 2560, '\P{^Blk= 	BENGALI}', "");
    Error('\p{Is_Block=	:=bengali}');
    Error('\P{Is_Block=	:=bengali}');
    Expect(1, 2559, '\p{Is_Block=bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=bengali}', "");
    Expect(0, 2559, '\P{Is_Block=bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=bengali}', "");
    Expect(0, 2560, '\p{Is_Block=bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=bengali}', "");
    Expect(1, 2560, '\P{Is_Block=bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=bengali}', "");
    Expect(1, 2559, '\p{Is_Block=-bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=-bengali}', "");
    Expect(0, 2559, '\P{Is_Block=-bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=-bengali}', "");
    Expect(0, 2560, '\p{Is_Block=-bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=-bengali}', "");
    Expect(1, 2560, '\P{Is_Block=-bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=-bengali}', "");
    Error('\p{Is_Blk=/a/_BENGALI}');
    Error('\P{Is_Blk=/a/_BENGALI}');
    Expect(1, 2559, '\p{Is_Blk=bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
    Expect(0, 2559, '\P{Is_Blk=bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
    Expect(0, 2560, '\p{Is_Blk=bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk=bengali}', "");
    Expect(1, 2560, '\P{Is_Blk=bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk=bengali}', "");
    Expect(1, 2559, '\p{Is_Blk=- BENGALI}', "");
    Expect(0, 2559, '\p{^Is_Blk=- BENGALI}', "");
    Expect(0, 2559, '\P{Is_Blk=- BENGALI}', "");
    Expect(1, 2559, '\P{^Is_Blk=- BENGALI}', "");
    Expect(0, 2560, '\p{Is_Blk=- BENGALI}', "");
    Expect(1, 2560, '\p{^Is_Blk=- BENGALI}', "");
    Expect(1, 2560, '\P{Is_Blk=- BENGALI}', "");
    Expect(0, 2560, '\P{^Is_Blk=- BENGALI}', "");
    Error('\p{Block=  Bhaiksuki/a/}');
    Error('\P{Block=  Bhaiksuki/a/}');
    Expect(1, 72815, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block=-	Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=-	Bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=-	Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=-	Bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=-	Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=-	Bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=-	Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=-	Bhaiksuki}', "");
    Error('\p{Blk= _BHAIKSUKI:=}');
    Error('\P{Blk= _BHAIKSUKI:=}');
    Expect(1, 72815, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=-	Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=-	Bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=-	Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=-	Bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=-	Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=-	Bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=-	Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=-	Bhaiksuki}', "");
    Error('\p{Is_Block= 	BHAIKSUKI/a/}');
    Error('\P{Is_Block= 	BHAIKSUKI/a/}');
    Expect(1, 72815, '\p{Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Block=	 Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=	 Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=	 Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=	 Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=	 Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=	 Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=	 Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=	 Bhaiksuki}', "");
    Error('\p{Is_Blk=	-Bhaiksuki/a/}');
    Error('\P{Is_Blk=	-Bhaiksuki/a/}');
    Expect(1, 72815, '\p{Is_Blk:	bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk:	bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk:	bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk:	bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk:	bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk:	bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk:	bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk:	bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Blk=-bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=-bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=-bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=-bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=-bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=-bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=-bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=-bhaiksuki}', "");
    Error('\p{Block=-BLOCK_Elements:=}');
    Error('\P{Block=-BLOCK_Elements:=}');
    Expect(1, 9631, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Block=blockelements}', "");
    Expect(0, 9631, '\p{^Block=blockelements}', "");
    Expect(0, 9631, '\P{Block=blockelements}', "");
    Expect(1, 9631, '\P{^Block=blockelements}', "");
    Expect(0, 9632, '\p{Block=blockelements}', "");
    Expect(1, 9632, '\p{^Block=blockelements}', "");
    Expect(1, 9632, '\P{Block=blockelements}', "");
    Expect(0, 9632, '\P{^Block=blockelements}', "");
    Expect(1, 9631, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Block= -Block_elements}', "");
    Expect(0, 9631, '\p{^Block= -Block_elements}', "");
    Expect(0, 9631, '\P{Block= -Block_elements}', "");
    Expect(1, 9631, '\P{^Block= -Block_elements}', "");
    Expect(0, 9632, '\p{Block= -Block_elements}', "");
    Expect(1, 9632, '\p{^Block= -Block_elements}', "");
    Expect(1, 9632, '\P{Block= -Block_elements}', "");
    Expect(0, 9632, '\P{^Block= -Block_elements}', "");
    Error('\p{Blk: 	Block_elements/a/}');
    Error('\P{Blk: 	Block_elements/a/}');
    Expect(1, 9631, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Blk=blockelements}', "");
    Expect(0, 9631, '\P{Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Blk=blockelements}', "");
    Expect(0, 9632, '\p{Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Blk=blockelements}', "");
    Expect(1, 9632, '\P{Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Blk=blockelements}', "");
    Expect(1, 9631, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Blk:	_ Block_ELEMENTS}', "");
    Expect(0, 9631, '\p{^Blk:	_ Block_ELEMENTS}', "");
    Expect(0, 9631, '\P{Blk:	_ Block_ELEMENTS}', "");
    Expect(1, 9631, '\P{^Blk:	_ Block_ELEMENTS}', "");
    Expect(0, 9632, '\p{Blk:	_ Block_ELEMENTS}', "");
    Expect(1, 9632, '\p{^Blk:	_ Block_ELEMENTS}', "");
    Expect(1, 9632, '\P{Blk:	_ Block_ELEMENTS}', "");
    Expect(0, 9632, '\P{^Blk:	_ Block_ELEMENTS}', "");
    Error('\p{Is_Block=_BLOCK_Elements:=}');
    Error('\P{Is_Block=_BLOCK_Elements:=}');
    Expect(1, 9631, '\p{Is_Block=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
    Expect(0, 9631, '\P{Is_Block=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
    Expect(0, 9632, '\p{Is_Block=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
    Expect(1, 9632, '\P{Is_Block=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
    Expect(1, 9631, '\p{Is_Block=  Block_Elements}', "");
    Expect(0, 9631, '\p{^Is_Block=  Block_Elements}', "");
    Expect(0, 9631, '\P{Is_Block=  Block_Elements}', "");
    Expect(1, 9631, '\P{^Is_Block=  Block_Elements}', "");
    Expect(0, 9632, '\p{Is_Block=  Block_Elements}', "");
    Expect(1, 9632, '\p{^Is_Block=  Block_Elements}', "");
    Expect(1, 9632, '\P{Is_Block=  Block_Elements}', "");
    Expect(0, 9632, '\P{^Is_Block=  Block_Elements}', "");
    Error('\p{Is_Blk=-BLOCK_ELEMENTS/a/}');
    Error('\P{Is_Blk=-BLOCK_ELEMENTS/a/}');
    Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
    Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
    Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
    Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
    Expect(1, 9631, '\p{Is_Blk=	 Block_Elements}', "");
    Expect(0, 9631, '\p{^Is_Blk=	 Block_Elements}', "");
    Expect(0, 9631, '\P{Is_Blk=	 Block_Elements}', "");
    Expect(1, 9631, '\P{^Is_Blk=	 Block_Elements}', "");
    Expect(0, 9632, '\p{Is_Blk=	 Block_Elements}', "");
    Expect(1, 9632, '\p{^Is_Blk=	 Block_Elements}', "");
    Expect(1, 9632, '\P{Is_Blk=	 Block_Elements}', "");
    Expect(0, 9632, '\P{^Is_Blk=	 Block_Elements}', "");
    Error('\p{Block=:= 	Bopomofo}');
    Error('\P{Block=:= 	Bopomofo}');
    Expect(1, 12591, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Block=bopomofo}', "");
    Expect(0, 12591, '\P{Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Block=bopomofo}', "");
    Expect(0, 12592, '\p{Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Block=bopomofo}', "");
    Expect(1, 12592, '\P{Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Block=bopomofo}', "");
    Expect(1, 12591, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block=-bopomofo}', "");
    Expect(0, 12591, '\p{^Block=-bopomofo}', "");
    Expect(0, 12591, '\P{Block=-bopomofo}', "");
    Expect(1, 12591, '\P{^Block=-bopomofo}', "");
    Expect(0, 12592, '\p{Block=-bopomofo}', "");
    Expect(1, 12592, '\p{^Block=-bopomofo}', "");
    Expect(1, 12592, '\P{Block=-bopomofo}', "");
    Expect(0, 12592, '\P{^Block=-bopomofo}', "");
    Error('\p{Blk=/a/--bopomofo}');
    Error('\P{Blk=/a/--bopomofo}');
    Expect(1, 12591, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Blk=BOPOMOFO}', "");
    Expect(0, 12591, '\P{Blk=BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Blk=BOPOMOFO}', "");
    Expect(0, 12592, '\p{Blk=BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Blk=BOPOMOFO}', "");
    Expect(1, 12592, '\P{Blk=BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Blk=BOPOMOFO}', "");
    Error('\p{Is_Block=__Bopomofo:=}');
    Error('\P{Is_Block=__Bopomofo:=}');
    Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Block=	-Bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block=	-Bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block=	-Bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block=	-Bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block=	-Bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block=	-Bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block=	-Bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block=	-Bopomofo}', "");
    Error('\p{Is_Blk=/a/ 	Bopomofo}');
    Error('\P{Is_Blk=/a/ 	Bopomofo}');
    Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Blk=	Bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=	Bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=	Bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=	Bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=	Bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=	Bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=	Bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=	Bopomofo}', "");
    Error('\p{Block=/a/_Bopomofo_EXTENDED}');
    Error('\P{Block=/a/_Bopomofo_EXTENDED}');
    Expect(1, 12735, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(1, 12735, '\p{Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(1, 12735, '\p{Block= Bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Block= Bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Block= Bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Block= Bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Block= Bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Block= Bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Block= Bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Block= Bopomofo_Extended}', "");
    Error('\p{Blk=_bopomofo_EXT:=}');
    Error('\P{Blk=_bopomofo_EXT:=}');
    Expect(1, 12735, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(1, 12735, '\p{Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(1, 12735, '\p{Blk=-	bopomofo_Ext}', "");
    Expect(0, 12735, '\p{^Blk=-	bopomofo_Ext}', "");
    Expect(0, 12735, '\P{Blk=-	bopomofo_Ext}', "");
    Expect(1, 12735, '\P{^Blk=-	bopomofo_Ext}', "");
    Expect(0, 12736, '\p{Blk=-	bopomofo_Ext}', "");
    Expect(1, 12736, '\p{^Blk=-	bopomofo_Ext}', "");
    Expect(1, 12736, '\P{Blk=-	bopomofo_Ext}', "");
    Expect(0, 12736, '\P{^Blk=-	bopomofo_Ext}', "");
    Error('\p{Is_Block=:= 	Bopomofo_extended}');
    Error('\P{Is_Block=:= 	Bopomofo_extended}');
    Expect(1, 12735, '\p{Is_Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Is_Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Is_Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Is_Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Is_Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Is_Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Is_Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Is_Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Is_Block= bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Is_Block= bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Is_Block= bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Is_Block= bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Is_Block= bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Is_Block= bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Is_Block= bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Is_Block= bopomofo_Extended}', "");
    Error('\p{Is_Blk=/a/_-Bopomofo_EXT}');
    Error('\P{Is_Blk=/a/_-Bopomofo_EXT}');
    Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Is_Blk=	Bopomofo_Ext}', "");
    Expect(0, 12735, '\p{^Is_Blk=	Bopomofo_Ext}', "");
    Expect(0, 12735, '\P{Is_Blk=	Bopomofo_Ext}', "");
    Expect(1, 12735, '\P{^Is_Blk=	Bopomofo_Ext}', "");
    Expect(0, 12736, '\p{Is_Blk=	Bopomofo_Ext}', "");
    Expect(1, 12736, '\p{^Is_Blk=	Bopomofo_Ext}', "");
    Expect(1, 12736, '\P{Is_Blk=	Bopomofo_Ext}', "");
    Expect(0, 12736, '\P{^Is_Blk=	Bopomofo_Ext}', "");
    Error('\p{Block= /a/BOX_Drawing}');
    Error('\P{Block= /a/BOX_Drawing}');
    Expect(1, 9599, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Block= 	Box_drawing}', "");
    Expect(0, 9599, '\p{^Block= 	Box_drawing}', "");
    Expect(0, 9599, '\P{Block= 	Box_drawing}', "");
    Expect(1, 9599, '\P{^Block= 	Box_drawing}', "");
    Expect(0, 9600, '\p{Block= 	Box_drawing}', "");
    Expect(1, 9600, '\p{^Block= 	Box_drawing}', "");
    Expect(1, 9600, '\P{Block= 	Box_drawing}', "");
    Expect(0, 9600, '\P{^Block= 	Box_drawing}', "");
    Error('\p{Blk::=	 box_DRAWING}');
    Error('\P{Blk::=	 box_DRAWING}');
    Expect(1, 9599, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=	-box_Drawing}', "");
    Expect(0, 9599, '\p{^Blk=	-box_Drawing}', "");
    Expect(0, 9599, '\P{Blk=	-box_Drawing}', "");
    Expect(1, 9599, '\P{^Blk=	-box_Drawing}', "");
    Expect(0, 9600, '\p{Blk=	-box_Drawing}', "");
    Expect(1, 9600, '\p{^Blk=	-box_Drawing}', "");
    Expect(1, 9600, '\P{Blk=	-box_Drawing}', "");
    Expect(0, 9600, '\P{^Blk=	-box_Drawing}', "");
    Error('\p{Is_Block=/a/	Box_Drawing}');
    Error('\P{Is_Block=/a/	Box_Drawing}');
    Expect(1, 9599, '\p{Is_Block:   boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Block:   boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Block:   boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Block:   boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Block:   boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Block:   boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Block:   boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Block:   boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Block=	-BOX_DRAWING}', "");
    Expect(0, 9599, '\p{^Is_Block=	-BOX_DRAWING}', "");
    Expect(0, 9599, '\P{Is_Block=	-BOX_DRAWING}', "");
    Expect(1, 9599, '\P{^Is_Block=	-BOX_DRAWING}', "");
    Expect(0, 9600, '\p{Is_Block=	-BOX_DRAWING}', "");
    Expect(1, 9600, '\p{^Is_Block=	-BOX_DRAWING}', "");
    Expect(1, 9600, '\P{Is_Block=	-BOX_DRAWING}', "");
    Expect(0, 9600, '\P{^Is_Block=	-BOX_DRAWING}', "");
    Error('\p{Is_Blk=-:=Box_DRAWING}');
    Error('\P{Is_Blk=-:=Box_DRAWING}');
    Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Blk: _Box_drawing}', "");
    Expect(0, 9599, '\p{^Is_Blk: _Box_drawing}', "");
    Expect(0, 9599, '\P{Is_Blk: _Box_drawing}', "");
    Expect(1, 9599, '\P{^Is_Blk: _Box_drawing}', "");
    Expect(0, 9600, '\p{Is_Blk: _Box_drawing}', "");
    Expect(1, 9600, '\p{^Is_Blk: _Box_drawing}', "");
    Expect(1, 9600, '\P{Is_Blk: _Box_drawing}', "");
    Expect(0, 9600, '\P{^Is_Blk: _Box_drawing}', "");
    Error('\p{Block= /a/Brahmi}');
    Error('\P{Block= /a/Brahmi}');
    Expect(1, 69759, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=brahmi}', "");
    Expect(0, 69759, '\p{^Block=brahmi}', "");
    Expect(0, 69759, '\P{Block=brahmi}', "");
    Expect(1, 69759, '\P{^Block=brahmi}', "");
    Expect(0, 69760, '\p{Block=brahmi}', "");
    Expect(1, 69760, '\p{^Block=brahmi}', "");
    Expect(1, 69760, '\P{Block=brahmi}', "");
    Expect(0, 69760, '\P{^Block=brahmi}', "");
    Expect(1, 69759, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=-Brahmi}', "");
    Expect(0, 69759, '\p{^Block=-Brahmi}', "");
    Expect(0, 69759, '\P{Block=-Brahmi}', "");
    Expect(1, 69759, '\P{^Block=-Brahmi}', "");
    Expect(0, 69760, '\p{Block=-Brahmi}', "");
    Expect(1, 69760, '\p{^Block=-Brahmi}', "");
    Expect(1, 69760, '\P{Block=-Brahmi}', "");
    Expect(0, 69760, '\P{^Block=-Brahmi}', "");
    Error('\p{Blk=:=		Brahmi}');
    Error('\P{Blk=:=		Brahmi}');
    Expect(1, 69759, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Blk=brahmi}', "");
    Expect(0, 69759, '\P{Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Blk=brahmi}', "");
    Expect(0, 69760, '\p{Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Blk=brahmi}', "");
    Expect(1, 69760, '\P{Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Blk=brahmi}', "");
    Expect(1, 69759, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk:	- BRAHMI}', "");
    Expect(0, 69759, '\p{^Blk:	- BRAHMI}', "");
    Expect(0, 69759, '\P{Blk:	- BRAHMI}', "");
    Expect(1, 69759, '\P{^Blk:	- BRAHMI}', "");
    Expect(0, 69760, '\p{Blk:	- BRAHMI}', "");
    Expect(1, 69760, '\p{^Blk:	- BRAHMI}', "");
    Expect(1, 69760, '\P{Blk:	- BRAHMI}', "");
    Expect(0, 69760, '\P{^Blk:	- BRAHMI}', "");
    Error('\p{Is_Block=	/a/Brahmi}');
    Error('\P{Is_Block=	/a/Brahmi}');
    Expect(1, 69759, '\p{Is_Block=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
    Expect(1, 69759, '\p{Is_Block=Brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=Brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=Brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=Brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=Brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=Brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=Brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=Brahmi}', "");
    Error('\p{Is_Blk=:=		Brahmi}');
    Error('\P{Is_Blk=:=		Brahmi}');
    Expect(1, 69759, '\p{Is_Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=brahmi}', "");
    Expect(1, 69759, '\p{Is_Blk=	Brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=	Brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=	Brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=	Brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=	Brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=	Brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=	Brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=	Brahmi}', "");
    Error('\p{Block=  braille_Patterns:=}');
    Error('\P{Block=  braille_Patterns:=}');
    Expect(1, 10495, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(1, 10495, '\p{Block:	braillepatterns}', "");
    Expect(0, 10495, '\p{^Block:	braillepatterns}', "");
    Expect(0, 10495, '\P{Block:	braillepatterns}', "");
    Expect(1, 10495, '\P{^Block:	braillepatterns}', "");
    Expect(0, 10496, '\p{Block:	braillepatterns}', "");
    Expect(1, 10496, '\p{^Block:	braillepatterns}', "");
    Expect(1, 10496, '\P{Block:	braillepatterns}', "");
    Expect(0, 10496, '\P{^Block:	braillepatterns}', "");
    Expect(1, 10495, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(1, 10495, '\p{Block= BRAILLE_patterns}', "");
    Expect(0, 10495, '\p{^Block= BRAILLE_patterns}', "");
    Expect(0, 10495, '\P{Block= BRAILLE_patterns}', "");
    Expect(1, 10495, '\P{^Block= BRAILLE_patterns}', "");
    Expect(0, 10496, '\p{Block= BRAILLE_patterns}', "");
    Expect(1, 10496, '\p{^Block= BRAILLE_patterns}', "");
    Expect(1, 10496, '\P{Block= BRAILLE_patterns}', "");
    Expect(0, 10496, '\P{^Block= BRAILLE_patterns}', "");
    Error('\p{Blk: -	braille:=}');
    Error('\P{Blk: -	braille:=}');
    Expect(1, 10495, '\p{Blk=:\ABraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\ABraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=braille}', "");
    Expect(0, 10495, '\p{^Blk=braille}', "");
    Expect(0, 10495, '\P{Blk=braille}', "");
    Expect(1, 10495, '\P{^Blk=braille}', "");
    Expect(0, 10496, '\p{Blk=braille}', "");
    Expect(1, 10496, '\p{^Blk=braille}', "");
    Expect(1, 10496, '\P{Blk=braille}', "");
    Expect(0, 10496, '\P{^Blk=braille}', "");
    Expect(1, 10495, '\p{Blk=:\Abraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\Abraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=	 braille}', "");
    Expect(0, 10495, '\p{^Blk=	 braille}', "");
    Expect(0, 10495, '\P{Blk=	 braille}', "");
    Expect(1, 10495, '\P{^Blk=	 braille}', "");
    Expect(0, 10496, '\p{Blk=	 braille}', "");
    Expect(1, 10496, '\p{^Blk=	 braille}', "");
    Expect(1, 10496, '\P{Blk=	 braille}', "");
    Expect(0, 10496, '\P{^Blk=	 braille}', "");
    Error('\p{Is_Block=:=		BRAILLE_Patterns}');
    Error('\P{Is_Block=:=		BRAILLE_Patterns}');
    Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Is_Block=	_BRAILLE_patterns}', "");
    Expect(0, 10495, '\p{^Is_Block=	_BRAILLE_patterns}', "");
    Expect(0, 10495, '\P{Is_Block=	_BRAILLE_patterns}', "");
    Expect(1, 10495, '\P{^Is_Block=	_BRAILLE_patterns}', "");
    Expect(0, 10496, '\p{Is_Block=	_BRAILLE_patterns}', "");
    Expect(1, 10496, '\p{^Is_Block=	_BRAILLE_patterns}', "");
    Expect(1, 10496, '\P{Is_Block=	_BRAILLE_patterns}', "");
    Expect(0, 10496, '\P{^Is_Block=	_BRAILLE_patterns}', "");
    Error('\p{Is_Blk=:=	_braille}');
    Error('\P{Is_Blk=:=	_braille}');
    Expect(1, 10495, '\p{Is_Blk=braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=braille}', "");
    Expect(0, 10495, '\P{Is_Blk=braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=braille}', "");
    Expect(0, 10496, '\p{Is_Blk=braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=braille}', "");
    Expect(1, 10496, '\P{Is_Blk=braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=braille}', "");
    Expect(1, 10495, '\p{Is_Blk=	braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=	braille}', "");
    Expect(0, 10495, '\P{Is_Blk=	braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=	braille}', "");
    Expect(0, 10496, '\p{Is_Blk=	braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=	braille}', "");
    Expect(1, 10496, '\P{Is_Blk=	braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=	braille}', "");
    Error('\p{Block=_Buginese/a/}');
    Error('\P{Block=_Buginese/a/}');
    Expect(1, 6687, '\p{Block=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Block=buginese}', "");
    Expect(0, 6687, '\p{^Block=buginese}', "");
    Expect(0, 6687, '\P{Block=buginese}', "");
    Expect(1, 6687, '\P{^Block=buginese}', "");
    Expect(0, 6688, '\p{Block=buginese}', "");
    Expect(1, 6688, '\p{^Block=buginese}', "");
    Expect(1, 6688, '\P{Block=buginese}', "");
    Expect(0, 6688, '\P{^Block=buginese}', "");
    Expect(1, 6687, '\p{Block=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Block=BUGINESE}', "");
    Expect(0, 6687, '\p{^Block=BUGINESE}', "");
    Expect(0, 6687, '\P{Block=BUGINESE}', "");
    Expect(1, 6687, '\P{^Block=BUGINESE}', "");
    Expect(0, 6688, '\p{Block=BUGINESE}', "");
    Expect(1, 6688, '\p{^Block=BUGINESE}', "");
    Expect(1, 6688, '\P{Block=BUGINESE}', "");
    Expect(0, 6688, '\P{^Block=BUGINESE}', "");
    Error('\p{Blk=:=_Buginese}');
    Error('\P{Blk=:=_Buginese}');
    Expect(1, 6687, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk=buginese}', "");
    Expect(0, 6687, '\p{^Blk=buginese}', "");
    Expect(0, 6687, '\P{Blk=buginese}', "");
    Expect(1, 6687, '\P{^Blk=buginese}', "");
    Expect(0, 6688, '\p{Blk=buginese}', "");
    Expect(1, 6688, '\p{^Blk=buginese}', "");
    Expect(1, 6688, '\P{Blk=buginese}', "");
    Expect(0, 6688, '\P{^Blk=buginese}', "");
    Expect(1, 6687, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk=- Buginese}', "");
    Expect(0, 6687, '\p{^Blk=- Buginese}', "");
    Expect(0, 6687, '\P{Blk=- Buginese}', "");
    Expect(1, 6687, '\P{^Blk=- Buginese}', "");
    Expect(0, 6688, '\p{Blk=- Buginese}', "");
    Expect(1, 6688, '\p{^Blk=- Buginese}', "");
    Expect(1, 6688, '\P{Blk=- Buginese}', "");
    Expect(0, 6688, '\P{^Blk=- Buginese}', "");
    Error('\p{Is_Block=/a/_ BUGINESE}');
    Error('\P{Is_Block=/a/_ BUGINESE}');
    Expect(1, 6687, '\p{Is_Block=buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=buginese}', "");
    Expect(0, 6687, '\P{Is_Block=buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=buginese}', "");
    Expect(0, 6688, '\p{Is_Block=buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=buginese}', "");
    Expect(1, 6688, '\P{Is_Block=buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=buginese}', "");
    Expect(1, 6687, '\p{Is_Block= Buginese}', "");
    Expect(0, 6687, '\p{^Is_Block= Buginese}', "");
    Expect(0, 6687, '\P{Is_Block= Buginese}', "");
    Expect(1, 6687, '\P{^Is_Block= Buginese}', "");
    Expect(0, 6688, '\p{Is_Block= Buginese}', "");
    Expect(1, 6688, '\p{^Is_Block= Buginese}', "");
    Expect(1, 6688, '\P{Is_Block= Buginese}', "");
    Expect(0, 6688, '\P{^Is_Block= Buginese}', "");
    Error('\p{Is_Blk=/a/-BUGINESE}');
    Error('\P{Is_Blk=/a/-BUGINESE}');
    Expect(1, 6687, '\p{Is_Blk=buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
    Expect(1, 6687, '\p{Is_Blk=_Buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=_Buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=_Buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=_Buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=_Buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=_Buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=_Buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=_Buginese}', "");
    Error('\p{Block=/a/	-buhid}');
    Error('\P{Block=/a/	-buhid}');
    Expect(1, 5983, '\p{Block=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=buhid}', "");
    Expect(0, 5983, '\p{^Block=buhid}', "");
    Expect(0, 5983, '\P{Block=buhid}', "");
    Expect(1, 5983, '\P{^Block=buhid}', "");
    Expect(0, 5984, '\p{Block=buhid}', "");
    Expect(1, 5984, '\p{^Block=buhid}', "");
    Expect(1, 5984, '\P{Block=buhid}', "");
    Expect(0, 5984, '\P{^Block=buhid}', "");
    Expect(1, 5983, '\p{Block=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=		Buhid}', "");
    Expect(0, 5983, '\p{^Block=		Buhid}', "");
    Expect(0, 5983, '\P{Block=		Buhid}', "");
    Expect(1, 5983, '\P{^Block=		Buhid}', "");
    Expect(0, 5984, '\p{Block=		Buhid}', "");
    Expect(1, 5984, '\p{^Block=		Buhid}', "");
    Expect(1, 5984, '\P{Block=		Buhid}', "");
    Expect(0, 5984, '\P{^Block=		Buhid}', "");
    Error('\p{Blk=--Buhid:=}');
    Error('\P{Blk=--Buhid:=}');
    Expect(1, 5983, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk=buhid}', "");
    Expect(0, 5983, '\p{^Blk=buhid}', "");
    Expect(0, 5983, '\P{Blk=buhid}', "");
    Expect(1, 5983, '\P{^Blk=buhid}', "");
    Expect(0, 5984, '\p{Blk=buhid}', "");
    Expect(1, 5984, '\p{^Blk=buhid}', "");
    Expect(1, 5984, '\P{Blk=buhid}', "");
    Expect(0, 5984, '\P{^Blk=buhid}', "");
    Expect(1, 5983, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk=_	Buhid}', "");
    Expect(0, 5983, '\p{^Blk=_	Buhid}', "");
    Expect(0, 5983, '\P{Blk=_	Buhid}', "");
    Expect(1, 5983, '\P{^Blk=_	Buhid}', "");
    Expect(0, 5984, '\p{Blk=_	Buhid}', "");
    Expect(1, 5984, '\p{^Blk=_	Buhid}', "");
    Expect(1, 5984, '\P{Blk=_	Buhid}', "");
    Expect(0, 5984, '\P{^Blk=_	Buhid}', "");
    Error('\p{Is_Block= :=Buhid}');
    Error('\P{Is_Block= :=Buhid}');
    Expect(1, 5983, '\p{Is_Block=buhid}', "");
    Expect(0, 5983, '\p{^Is_Block=buhid}', "");
    Expect(0, 5983, '\P{Is_Block=buhid}', "");
    Expect(1, 5983, '\P{^Is_Block=buhid}', "");
    Expect(0, 5984, '\p{Is_Block=buhid}', "");
    Expect(1, 5984, '\p{^Is_Block=buhid}', "");
    Expect(1, 5984, '\P{Is_Block=buhid}', "");
    Expect(0, 5984, '\P{^Is_Block=buhid}', "");
    Expect(1, 5983, '\p{Is_Block= 	Buhid}', "");
    Expect(0, 5983, '\p{^Is_Block= 	Buhid}', "");
    Expect(0, 5983, '\P{Is_Block= 	Buhid}', "");
    Expect(1, 5983, '\P{^Is_Block= 	Buhid}', "");
    Expect(0, 5984, '\p{Is_Block= 	Buhid}', "");
    Expect(1, 5984, '\p{^Is_Block= 	Buhid}', "");
    Expect(1, 5984, '\P{Is_Block= 	Buhid}', "");
    Expect(0, 5984, '\P{^Is_Block= 	Buhid}', "");
    Error('\p{Is_Blk=:=	BUHID}');
    Error('\P{Is_Blk=:=	BUHID}');
    Expect(1, 5983, '\p{Is_Blk=buhid}', "");
    Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
    Expect(0, 5983, '\P{Is_Blk=buhid}', "");
    Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
    Expect(0, 5984, '\p{Is_Blk=buhid}', "");
    Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
    Expect(1, 5984, '\P{Is_Blk=buhid}', "");
    Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
    Expect(1, 5983, '\p{Is_Blk=	_buhid}', "");
    Expect(0, 5983, '\p{^Is_Blk=	_buhid}', "");
    Expect(0, 5983, '\P{Is_Blk=	_buhid}', "");
    Expect(1, 5983, '\P{^Is_Blk=	_buhid}', "");
    Expect(0, 5984, '\p{Is_Blk=	_buhid}', "");
    Expect(1, 5984, '\p{^Is_Blk=	_buhid}', "");
    Expect(1, 5984, '\P{Is_Blk=	_buhid}', "");
    Expect(0, 5984, '\P{^Is_Blk=	_buhid}', "");
    Error('\p{Block=-Byzantine_Musical_Symbols/a/}');
    Error('\P{Block=-Byzantine_Musical_Symbols/a/}');
    Expect(1, 119039, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(1, 119039, '\p{Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(0, 119039, '\p{^Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(0, 119039, '\P{Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(1, 119039, '\P{^Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(0, 119040, '\p{Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(1, 119040, '\p{^Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(1, 119040, '\P{Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Expect(0, 119040, '\P{^Block:    _BYZANTINE_Musical_SYMBOLS}', "");
    Error('\p{Blk=:=Byzantine_Music}');
    Error('\P{Blk=:=Byzantine_Music}');
    Expect(1, 119039, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(1, 119039, '\p{Blk=  byzantine_Music}', "");
    Expect(0, 119039, '\p{^Blk=  byzantine_Music}', "");
    Expect(0, 119039, '\P{Blk=  byzantine_Music}', "");
    Expect(1, 119039, '\P{^Blk=  byzantine_Music}', "");
    Expect(0, 119040, '\p{Blk=  byzantine_Music}', "");
    Expect(1, 119040, '\p{^Blk=  byzantine_Music}', "");
    Expect(1, 119040, '\P{Blk=  byzantine_Music}', "");
    Expect(0, 119040, '\P{^Blk=  byzantine_Music}', "");
    Error('\p{Is_Block=_:=Byzantine_musical_SYMBOLS}');
    Error('\P{Is_Block=_:=Byzantine_musical_SYMBOLS}');
    Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(0, 119039, '\p{^Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(0, 119039, '\P{Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(1, 119039, '\P{^Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(0, 119040, '\p{Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(1, 119040, '\p{^Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(1, 119040, '\P{Is_Block=	Byzantine_Musical_Symbols}', "");
    Expect(0, 119040, '\P{^Is_Block=	Byzantine_Musical_Symbols}', "");
    Error('\p{Is_Blk=-	byzantine_music:=}');
    Error('\P{Is_Blk=-	byzantine_music:=}');
    Expect(1, 119039, '\p{Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Is_Blk=- byzantine_Music}', "");
    Expect(0, 119039, '\p{^Is_Blk=- byzantine_Music}', "");
    Expect(0, 119039, '\P{Is_Blk=- byzantine_Music}', "");
    Expect(1, 119039, '\P{^Is_Blk=- byzantine_Music}', "");
    Expect(0, 119040, '\p{Is_Blk=- byzantine_Music}', "");
    Expect(1, 119040, '\p{^Is_Blk=- byzantine_Music}', "");
    Expect(1, 119040, '\P{Is_Blk=- byzantine_Music}', "");
    Expect(0, 119040, '\P{^Is_Blk=- byzantine_Music}', "");
    Error('\p{Block=CARIAN:=}');
    Error('\P{Block=CARIAN:=}');
    Expect(1, 66271, '\p{Block=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Block=carian}', "");
    Expect(0, 66271, '\p{^Block=carian}', "");
    Expect(0, 66271, '\P{Block=carian}', "");
    Expect(1, 66271, '\P{^Block=carian}', "");
    Expect(0, 66272, '\p{Block=carian}', "");
    Expect(1, 66272, '\p{^Block=carian}', "");
    Expect(1, 66272, '\P{Block=carian}', "");
    Expect(0, 66272, '\P{^Block=carian}', "");
    Expect(1, 66271, '\p{Block=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Block=	_carian}', "");
    Expect(0, 66271, '\p{^Block=	_carian}', "");
    Expect(0, 66271, '\P{Block=	_carian}', "");
    Expect(1, 66271, '\P{^Block=	_carian}', "");
    Expect(0, 66272, '\p{Block=	_carian}', "");
    Expect(1, 66272, '\p{^Block=	_carian}', "");
    Expect(1, 66272, '\P{Block=	_carian}', "");
    Expect(0, 66272, '\P{^Block=	_carian}', "");
    Error('\p{Blk=	-CARIAN:=}');
    Error('\P{Blk=	-CARIAN:=}');
    Expect(1, 66271, '\p{Blk=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Blk=carian}', "");
    Expect(0, 66271, '\p{^Blk=carian}', "");
    Expect(0, 66271, '\P{Blk=carian}', "");
    Expect(1, 66271, '\P{^Blk=carian}', "");
    Expect(0, 66272, '\p{Blk=carian}', "");
    Expect(1, 66272, '\p{^Blk=carian}', "");
    Expect(1, 66272, '\P{Blk=carian}', "");
    Expect(0, 66272, '\P{^Blk=carian}', "");
    Expect(1, 66271, '\p{Blk=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Blk=__carian}', "");
    Expect(0, 66271, '\p{^Blk=__carian}', "");
    Expect(0, 66271, '\P{Blk=__carian}', "");
    Expect(1, 66271, '\P{^Blk=__carian}', "");
    Expect(0, 66272, '\p{Blk=__carian}', "");
    Expect(1, 66272, '\p{^Blk=__carian}', "");
    Expect(1, 66272, '\P{Blk=__carian}', "");
    Expect(0, 66272, '\P{^Blk=__carian}', "");
    Error('\p{Is_Block=:=_Carian}');
    Error('\P{Is_Block=:=_Carian}');
    Expect(1, 66271, '\p{Is_Block=carian}', "");
    Expect(0, 66271, '\p{^Is_Block=carian}', "");
    Expect(0, 66271, '\P{Is_Block=carian}', "");
    Expect(1, 66271, '\P{^Is_Block=carian}', "");
    Expect(0, 66272, '\p{Is_Block=carian}', "");
    Expect(1, 66272, '\p{^Is_Block=carian}', "");
    Expect(1, 66272, '\P{Is_Block=carian}', "");
    Expect(0, 66272, '\P{^Is_Block=carian}', "");
    Expect(1, 66271, '\p{Is_Block=-_CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Block=-_CARIAN}', "");
    Expect(0, 66271, '\P{Is_Block=-_CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Block=-_CARIAN}', "");
    Expect(0, 66272, '\p{Is_Block=-_CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Block=-_CARIAN}', "");
    Expect(1, 66272, '\P{Is_Block=-_CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Block=-_CARIAN}', "");
    Error('\p{Is_Blk=	:=carian}');
    Error('\P{Is_Blk=	:=carian}');
    Expect(1, 66271, '\p{Is_Blk=carian}', "");
    Expect(0, 66271, '\p{^Is_Blk=carian}', "");
    Expect(0, 66271, '\P{Is_Blk=carian}', "");
    Expect(1, 66271, '\P{^Is_Blk=carian}', "");
    Expect(0, 66272, '\p{Is_Blk=carian}', "");
    Expect(1, 66272, '\p{^Is_Blk=carian}', "");
    Expect(1, 66272, '\P{Is_Blk=carian}', "");
    Expect(0, 66272, '\P{^Is_Blk=carian}', "");
    Expect(1, 66271, '\p{Is_Blk= CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Blk= CARIAN}', "");
    Expect(0, 66271, '\P{Is_Blk= CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Blk= CARIAN}', "");
    Expect(0, 66272, '\p{Is_Blk= CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Blk= CARIAN}', "");
    Expect(1, 66272, '\P{Is_Blk= CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Blk= CARIAN}', "");
    Error('\p{Block=:=_ Caucasian_Albanian}');
    Error('\P{Block=:=_ Caucasian_Albanian}');
    Expect(1, 66927, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\p{^Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\P{Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66927, '\P{^Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\p{Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\p{^Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\P{Block=-	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\P{^Block=-	CAUCASIAN_ALBANIAN}', "");
    Error('\p{Blk=-_CAUCASIAN_ALBANIAN:=}');
    Error('\P{Blk=-_CAUCASIAN_ALBANIAN:=}');
    Expect(1, 66927, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Blk:	caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Blk:	caucasianalbanian}', "");
    Expect(0, 66927, '\P{Blk:	caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Blk:	caucasianalbanian}', "");
    Expect(0, 66928, '\p{Blk:	caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Blk:	caucasianalbanian}', "");
    Expect(1, 66928, '\P{Blk:	caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Blk:	caucasianalbanian}', "");
    Expect(1, 66927, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Blk: _Caucasian_Albanian}', "");
    Expect(0, 66927, '\p{^Blk: _Caucasian_Albanian}', "");
    Expect(0, 66927, '\P{Blk: _Caucasian_Albanian}', "");
    Expect(1, 66927, '\P{^Blk: _Caucasian_Albanian}', "");
    Expect(0, 66928, '\p{Blk: _Caucasian_Albanian}', "");
    Expect(1, 66928, '\p{^Blk: _Caucasian_Albanian}', "");
    Expect(1, 66928, '\P{Blk: _Caucasian_Albanian}', "");
    Expect(0, 66928, '\P{^Blk: _Caucasian_Albanian}', "");
    Error('\p{Is_Block=/a/	-Caucasian_Albanian}');
    Error('\P{Is_Block=/a/	-Caucasian_Albanian}');
    Expect(1, 66927, '\p{Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(0, 66927, '\p{^Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(0, 66927, '\P{Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(1, 66927, '\P{^Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(0, 66928, '\p{Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(1, 66928, '\p{^Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(1, 66928, '\P{Is_Block=_CAUCASIAN_Albanian}', "");
    Expect(0, 66928, '\P{^Is_Block=_CAUCASIAN_Albanian}', "");
    Error('\p{Is_Blk=:=_Caucasian_Albanian}');
    Error('\P{Is_Blk=:=_Caucasian_Albanian}');
    Expect(1, 66927, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Blk:	-caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Is_Blk:	-caucasian_albanian}', "");
    Expect(0, 66927, '\P{Is_Blk:	-caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Is_Blk:	-caucasian_albanian}', "");
    Expect(0, 66928, '\p{Is_Blk:	-caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Is_Blk:	-caucasian_albanian}', "");
    Expect(1, 66928, '\P{Is_Blk:	-caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Is_Blk:	-caucasian_albanian}', "");
    Error('\p{Block=:=  CHAKMA}');
    Error('\P{Block=:=  CHAKMA}');
    Expect(1, 69967, '\p{Block=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Block: chakma}', "");
    Expect(0, 69967, '\p{^Block: chakma}', "");
    Expect(0, 69967, '\P{Block: chakma}', "");
    Expect(1, 69967, '\P{^Block: chakma}', "");
    Expect(0, 69968, '\p{Block: chakma}', "");
    Expect(1, 69968, '\p{^Block: chakma}', "");
    Expect(1, 69968, '\P{Block: chakma}', "");
    Expect(0, 69968, '\P{^Block: chakma}', "");
    Expect(1, 69967, '\p{Block=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Block=_	chakma}', "");
    Expect(0, 69967, '\p{^Block=_	chakma}', "");
    Expect(0, 69967, '\P{Block=_	chakma}', "");
    Expect(1, 69967, '\P{^Block=_	chakma}', "");
    Expect(0, 69968, '\p{Block=_	chakma}', "");
    Expect(1, 69968, '\p{^Block=_	chakma}', "");
    Expect(1, 69968, '\P{Block=_	chakma}', "");
    Expect(0, 69968, '\P{^Block=_	chakma}', "");
    Error('\p{Blk=__Chakma/a/}');
    Error('\P{Blk=__Chakma/a/}');
    Expect(1, 69967, '\p{Blk=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=chakma}', "");
    Expect(0, 69967, '\p{^Blk=chakma}', "");
    Expect(0, 69967, '\P{Blk=chakma}', "");
    Expect(1, 69967, '\P{^Blk=chakma}', "");
    Expect(0, 69968, '\p{Blk=chakma}', "");
    Expect(1, 69968, '\p{^Blk=chakma}', "");
    Expect(1, 69968, '\P{Blk=chakma}', "");
    Expect(0, 69968, '\P{^Blk=chakma}', "");
    Expect(1, 69967, '\p{Blk=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=CHAKMA}', "");
    Expect(0, 69967, '\p{^Blk=CHAKMA}', "");
    Expect(0, 69967, '\P{Blk=CHAKMA}', "");
    Expect(1, 69967, '\P{^Blk=CHAKMA}', "");
    Expect(0, 69968, '\p{Blk=CHAKMA}', "");
    Expect(1, 69968, '\p{^Blk=CHAKMA}', "");
    Expect(1, 69968, '\P{Blk=CHAKMA}', "");
    Expect(0, 69968, '\P{^Blk=CHAKMA}', "");
    Error('\p{Is_Block=/a/_ CHAKMA}');
    Error('\P{Is_Block=/a/_ CHAKMA}');
    Expect(1, 69967, '\p{Is_Block=chakma}', "");
    Expect(0, 69967, '\p{^Is_Block=chakma}', "");
    Expect(0, 69967, '\P{Is_Block=chakma}', "");
    Expect(1, 69967, '\P{^Is_Block=chakma}', "");
    Expect(0, 69968, '\p{Is_Block=chakma}', "");
    Expect(1, 69968, '\p{^Is_Block=chakma}', "");
    Expect(1, 69968, '\P{Is_Block=chakma}', "");
    Expect(0, 69968, '\P{^Is_Block=chakma}', "");
    Expect(1, 69967, '\p{Is_Block= 	chakma}', "");
    Expect(0, 69967, '\p{^Is_Block= 	chakma}', "");
    Expect(0, 69967, '\P{Is_Block= 	chakma}', "");
    Expect(1, 69967, '\P{^Is_Block= 	chakma}', "");
    Expect(0, 69968, '\p{Is_Block= 	chakma}', "");
    Expect(1, 69968, '\p{^Is_Block= 	chakma}', "");
    Expect(1, 69968, '\P{Is_Block= 	chakma}', "");
    Expect(0, 69968, '\P{^Is_Block= 	chakma}', "");
    Error('\p{Is_Blk=_/a/chakma}');
    Error('\P{Is_Blk=_/a/chakma}');
    Expect(1, 69967, '\p{Is_Blk=chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=chakma}', "");
    Expect(1, 69967, '\p{Is_Blk:   Chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk:   Chakma}', "");
    Expect(0, 69967, '\P{Is_Blk:   Chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk:   Chakma}', "");
    Expect(0, 69968, '\p{Is_Blk:   Chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk:   Chakma}', "");
    Expect(1, 69968, '\P{Is_Blk:   Chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk:   Chakma}', "");
    Error('\p{Block=-/a/CHAM}');
    Error('\P{Block=-/a/CHAM}');
    Expect(1, 43615, '\p{Block=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Block=cham}', "");
    Expect(0, 43615, '\p{^Block=cham}', "");
    Expect(0, 43615, '\P{Block=cham}', "");
    Expect(1, 43615, '\P{^Block=cham}', "");
    Expect(0, 43616, '\p{Block=cham}', "");
    Expect(1, 43616, '\p{^Block=cham}', "");
    Expect(1, 43616, '\P{Block=cham}', "");
    Expect(0, 43616, '\P{^Block=cham}', "");
    Expect(1, 43615, '\p{Block=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Block=_cham}', "");
    Expect(0, 43615, '\p{^Block=_cham}', "");
    Expect(0, 43615, '\P{Block=_cham}', "");
    Expect(1, 43615, '\P{^Block=_cham}', "");
    Expect(0, 43616, '\p{Block=_cham}', "");
    Expect(1, 43616, '\p{^Block=_cham}', "");
    Expect(1, 43616, '\P{Block=_cham}', "");
    Expect(0, 43616, '\P{^Block=_cham}', "");
    Error('\p{Blk= /a/CHAM}');
    Error('\P{Blk= /a/CHAM}');
    Expect(1, 43615, '\p{Blk=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Blk=cham}', "");
    Expect(0, 43615, '\p{^Blk=cham}', "");
    Expect(0, 43615, '\P{Blk=cham}', "");
    Expect(1, 43615, '\P{^Blk=cham}', "");
    Expect(0, 43616, '\p{Blk=cham}', "");
    Expect(1, 43616, '\p{^Blk=cham}', "");
    Expect(1, 43616, '\P{Blk=cham}', "");
    Expect(0, 43616, '\P{^Blk=cham}', "");
    Expect(1, 43615, '\p{Blk=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Blk= -Cham}', "");
    Expect(0, 43615, '\p{^Blk= -Cham}', "");
    Expect(0, 43615, '\P{Blk= -Cham}', "");
    Expect(1, 43615, '\P{^Blk= -Cham}', "");
    Expect(0, 43616, '\p{Blk= -Cham}', "");
    Expect(1, 43616, '\p{^Blk= -Cham}', "");
    Expect(1, 43616, '\P{Blk= -Cham}', "");
    Expect(0, 43616, '\P{^Blk= -Cham}', "");
    Error('\p{Is_Block=-/a/Cham}');
    Error('\P{Is_Block=-/a/Cham}');
    Expect(1, 43615, '\p{Is_Block=cham}', "");
    Expect(0, 43615, '\p{^Is_Block=cham}', "");
    Expect(0, 43615, '\P{Is_Block=cham}', "");
    Expect(1, 43615, '\P{^Is_Block=cham}', "");
    Expect(0, 43616, '\p{Is_Block=cham}', "");
    Expect(1, 43616, '\p{^Is_Block=cham}', "");
    Expect(1, 43616, '\P{Is_Block=cham}', "");
    Expect(0, 43616, '\P{^Is_Block=cham}', "");
    Expect(1, 43615, '\p{Is_Block=-	CHAM}', "");
    Expect(0, 43615, '\p{^Is_Block=-	CHAM}', "");
    Expect(0, 43615, '\P{Is_Block=-	CHAM}', "");
    Expect(1, 43615, '\P{^Is_Block=-	CHAM}', "");
    Expect(0, 43616, '\p{Is_Block=-	CHAM}', "");
    Expect(1, 43616, '\p{^Is_Block=-	CHAM}', "");
    Expect(1, 43616, '\P{Is_Block=-	CHAM}', "");
    Expect(0, 43616, '\P{^Is_Block=-	CHAM}', "");
    Error('\p{Is_Blk=/a/-Cham}');
    Error('\P{Is_Blk=/a/-Cham}');
    Expect(1, 43615, '\p{Is_Blk=cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=cham}', "");
    Expect(0, 43615, '\P{Is_Blk=cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=cham}', "");
    Expect(0, 43616, '\p{Is_Blk=cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=cham}', "");
    Expect(1, 43616, '\P{Is_Blk=cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=cham}', "");
    Expect(1, 43615, '\p{Is_Blk= cham}', "");
    Expect(0, 43615, '\p{^Is_Blk= cham}', "");
    Expect(0, 43615, '\P{Is_Blk= cham}', "");
    Expect(1, 43615, '\P{^Is_Blk= cham}', "");
    Expect(0, 43616, '\p{Is_Blk= cham}', "");
    Expect(1, 43616, '\p{^Is_Blk= cham}', "");
    Expect(1, 43616, '\P{Is_Blk= cham}', "");
    Expect(0, 43616, '\P{^Is_Blk= cham}', "");
    Error('\p{Block=/a/ -Cherokee}');
    Error('\P{Block=/a/ -Cherokee}');
    Expect(1, 5119, '\p{Block=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=cherokee}', "");
    Expect(0, 5119, '\p{^Block=cherokee}', "");
    Expect(0, 5119, '\P{Block=cherokee}', "");
    Expect(1, 5119, '\P{^Block=cherokee}', "");
    Expect(0, 5120, '\p{Block=cherokee}', "");
    Expect(1, 5120, '\p{^Block=cherokee}', "");
    Expect(1, 5120, '\P{Block=cherokee}', "");
    Expect(0, 5120, '\P{^Block=cherokee}', "");
    Expect(1, 5119, '\p{Block=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=  CHEROKEE}', "");
    Expect(0, 5119, '\p{^Block=  CHEROKEE}', "");
    Expect(0, 5119, '\P{Block=  CHEROKEE}', "");
    Expect(1, 5119, '\P{^Block=  CHEROKEE}', "");
    Expect(0, 5120, '\p{Block=  CHEROKEE}', "");
    Expect(1, 5120, '\p{^Block=  CHEROKEE}', "");
    Expect(1, 5120, '\P{Block=  CHEROKEE}', "");
    Expect(0, 5120, '\P{^Block=  CHEROKEE}', "");
    Error('\p{Blk=-CHEROKEE/a/}');
    Error('\P{Blk=-CHEROKEE/a/}');
    Expect(1, 5119, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Blk=cherokee}', "");
    Expect(0, 5119, '\P{Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Blk=cherokee}', "");
    Expect(0, 5120, '\p{Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Blk=cherokee}', "");
    Expect(1, 5120, '\P{Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Blk=cherokee}', "");
    Expect(1, 5119, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=--cherokee}', "");
    Expect(0, 5119, '\p{^Blk=--cherokee}', "");
    Expect(0, 5119, '\P{Blk=--cherokee}', "");
    Expect(1, 5119, '\P{^Blk=--cherokee}', "");
    Expect(0, 5120, '\p{Blk=--cherokee}', "");
    Expect(1, 5120, '\p{^Blk=--cherokee}', "");
    Expect(1, 5120, '\P{Blk=--cherokee}', "");
    Expect(0, 5120, '\P{^Blk=--cherokee}', "");
    Error('\p{Is_Block=CHEROKEE:=}');
    Error('\P{Is_Block=CHEROKEE:=}');
    Expect(1, 5119, '\p{Is_Block=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=cherokee}', "");
    Expect(1, 5119, '\p{Is_Block=  Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=  Cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=  Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=  Cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=  Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=  Cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=  Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=  Cherokee}', "");
    Error('\p{Is_Blk=/a/Cherokee}');
    Error('\P{Is_Blk=/a/Cherokee}');
    Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk=cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk=cherokee}', "");
    Expect(1, 5119, '\p{Is_Blk= -Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk= -Cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk= -Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk= -Cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk= -Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk= -Cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk= -Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk= -Cherokee}', "");
    Error('\p{Block=_Cherokee_Supplement:=}');
    Error('\P{Block=_Cherokee_Supplement:=}');
    Expect(1, 43967, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(1, 43967, '\p{Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(1, 43967, '\p{Block=-Cherokee_supplement}', "");
    Expect(0, 43967, '\p{^Block=-Cherokee_supplement}', "");
    Expect(0, 43967, '\P{Block=-Cherokee_supplement}', "");
    Expect(1, 43967, '\P{^Block=-Cherokee_supplement}', "");
    Expect(0, 43968, '\p{Block=-Cherokee_supplement}', "");
    Expect(1, 43968, '\p{^Block=-Cherokee_supplement}', "");
    Expect(1, 43968, '\P{Block=-Cherokee_supplement}', "");
    Expect(0, 43968, '\P{^Block=-Cherokee_supplement}', "");
    Error('\p{Blk=/a/_Cherokee_Sup}');
    Error('\P{Blk=/a/_Cherokee_Sup}');
    Expect(1, 43967, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(1, 43967, '\p{Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(1, 43967, '\p{Blk=- Cherokee_Sup}', "");
    Expect(0, 43967, '\p{^Blk=- Cherokee_Sup}', "");
    Expect(0, 43967, '\P{Blk=- Cherokee_Sup}', "");
    Expect(1, 43967, '\P{^Blk=- Cherokee_Sup}', "");
    Expect(0, 43968, '\p{Blk=- Cherokee_Sup}', "");
    Expect(1, 43968, '\p{^Blk=- Cherokee_Sup}', "");
    Expect(1, 43968, '\P{Blk=- Cherokee_Sup}', "");
    Expect(0, 43968, '\P{^Blk=- Cherokee_Sup}', "");
    Error('\p{Is_Block= 	cherokee_supplement/a/}');
    Error('\P{Is_Block= 	cherokee_supplement/a/}');
    Expect(1, 43967, '\p{Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Is_Block=--Cherokee_supplement}', "");
    Expect(0, 43967, '\p{^Is_Block=--Cherokee_supplement}', "");
    Expect(0, 43967, '\P{Is_Block=--Cherokee_supplement}', "");
    Expect(1, 43967, '\P{^Is_Block=--Cherokee_supplement}', "");
    Expect(0, 43968, '\p{Is_Block=--Cherokee_supplement}', "");
    Expect(1, 43968, '\p{^Is_Block=--Cherokee_supplement}', "");
    Expect(1, 43968, '\P{Is_Block=--Cherokee_supplement}', "");
    Expect(0, 43968, '\P{^Is_Block=--Cherokee_supplement}', "");
    Error('\p{Is_Blk=/a/_ CHEROKEE_sup}');
    Error('\P{Is_Blk=/a/_ CHEROKEE_sup}');
    Expect(1, 43967, '\p{Is_Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Is_Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Is_Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Is_Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Is_Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Is_Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Is_Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Is_Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Is_Blk:   _cherokee_Sup}', "");
    Expect(0, 43967, '\p{^Is_Blk:   _cherokee_Sup}', "");
    Expect(0, 43967, '\P{Is_Blk:   _cherokee_Sup}', "");
    Expect(1, 43967, '\P{^Is_Blk:   _cherokee_Sup}', "");
    Expect(0, 43968, '\p{Is_Blk:   _cherokee_Sup}', "");
    Expect(1, 43968, '\p{^Is_Blk:   _cherokee_Sup}', "");
    Expect(1, 43968, '\P{Is_Blk:   _cherokee_Sup}', "");
    Expect(0, 43968, '\P{^Is_Blk:   _cherokee_Sup}', "");
    Error('\p{Block=/a/  Chess_SYMBOLS}');
    Error('\P{Block=/a/  Chess_SYMBOLS}');
    Expect(1, 129647, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Block=chesssymbols}', "");
    Expect(0, 129647, '\p{^Block=chesssymbols}', "");
    Expect(0, 129647, '\P{Block=chesssymbols}', "");
    Expect(1, 129647, '\P{^Block=chesssymbols}', "");
    Expect(0, 129648, '\p{Block=chesssymbols}', "");
    Expect(1, 129648, '\p{^Block=chesssymbols}', "");
    Expect(1, 129648, '\P{Block=chesssymbols}', "");
    Expect(0, 129648, '\P{^Block=chesssymbols}', "");
    Expect(1, 129647, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Block= Chess_symbols}', "");
    Expect(0, 129647, '\p{^Block= Chess_symbols}', "");
    Expect(0, 129647, '\P{Block= Chess_symbols}', "");
    Expect(1, 129647, '\P{^Block= Chess_symbols}', "");
    Expect(0, 129648, '\p{Block= Chess_symbols}', "");
    Expect(1, 129648, '\p{^Block= Chess_symbols}', "");
    Expect(1, 129648, '\P{Block= Chess_symbols}', "");
    Expect(0, 129648, '\P{^Block= Chess_symbols}', "");
    Error('\p{Blk=	Chess_Symbols/a/}');
    Error('\P{Blk=	Chess_Symbols/a/}');
    Expect(1, 129647, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=-	Chess_symbols}', "");
    Expect(0, 129647, '\p{^Blk=-	Chess_symbols}', "");
    Expect(0, 129647, '\P{Blk=-	Chess_symbols}', "");
    Expect(1, 129647, '\P{^Blk=-	Chess_symbols}', "");
    Expect(0, 129648, '\p{Blk=-	Chess_symbols}', "");
    Expect(1, 129648, '\p{^Blk=-	Chess_symbols}', "");
    Expect(1, 129648, '\P{Blk=-	Chess_symbols}', "");
    Expect(0, 129648, '\P{^Blk=-	Chess_symbols}', "");
    Error('\p{Is_Block= -Chess_SYMBOLS:=}');
    Error('\P{Is_Block= -Chess_SYMBOLS:=}');
    Expect(1, 129647, '\p{Is_Block=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Block=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Block=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Block=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Block=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Block=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Block=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Block=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(0, 129647, '\p{^Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(0, 129647, '\P{Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(1, 129647, '\P{^Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(0, 129648, '\p{Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(1, 129648, '\p{^Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(1, 129648, '\P{Is_Block=_-CHESS_SYMBOLS}', "");
    Expect(0, 129648, '\P{^Is_Block=_-CHESS_SYMBOLS}', "");
    Error('\p{Is_Blk=/a/ _Chess_symbols}');
    Error('\P{Is_Blk=/a/ _Chess_symbols}');
    Expect(1, 129647, '\p{Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(0, 129647, '\p{^Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(0, 129647, '\P{Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(1, 129647, '\P{^Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(0, 129648, '\p{Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(1, 129648, '\p{^Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(1, 129648, '\P{Is_Blk=	-Chess_SYMBOLS}', "");
    Expect(0, 129648, '\P{^Is_Blk=	-Chess_SYMBOLS}', "");
    Error('\p{Block=/a/	CJK_Unified_Ideographs}');
    Error('\P{Block=/a/	CJK_Unified_Ideographs}');
    Expect(1, 40959, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(0, 40959, '\p{^Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(0, 40959, '\P{Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(1, 40959, '\P{^Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(0, 40960, '\p{Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(1, 40960, '\p{^Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(1, 40960, '\P{Block=	CJK_Unified_IDEOGRAPHS}', "");
    Expect(0, 40960, '\P{^Block=	CJK_Unified_IDEOGRAPHS}', "");
    Error('\p{Blk: := 	CJK}');
    Error('\P{Blk: := 	CJK}');
    Expect(1, 40959, '\p{Blk=:\ACJK\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\ACJK\z:}', "");;
    Expect(1, 40959, '\p{Blk=cjk}', "");
    Expect(0, 40959, '\p{^Blk=cjk}', "");
    Expect(0, 40959, '\P{Blk=cjk}', "");
    Expect(1, 40959, '\P{^Blk=cjk}', "");
    Expect(0, 40960, '\p{Blk=cjk}', "");
    Expect(1, 40960, '\p{^Blk=cjk}', "");
    Expect(1, 40960, '\P{Blk=cjk}', "");
    Expect(0, 40960, '\P{^Blk=cjk}', "");
    Expect(1, 40959, '\p{Blk=:\Acjk\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\Acjk\z:}', "");;
    Expect(1, 40959, '\p{Blk=CJK}', "");
    Expect(0, 40959, '\p{^Blk=CJK}', "");
    Expect(0, 40959, '\P{Blk=CJK}', "");
    Expect(1, 40959, '\P{^Blk=CJK}', "");
    Expect(0, 40960, '\p{Blk=CJK}', "");
    Expect(1, 40960, '\p{^Blk=CJK}', "");
    Expect(1, 40960, '\P{Blk=CJK}', "");
    Expect(0, 40960, '\P{^Blk=CJK}', "");
    Error('\p{Is_Block=:=_ cjk_UNIFIED_Ideographs}');
    Error('\P{Is_Block=:=_ cjk_UNIFIED_Ideographs}');
    Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Is_Block=_	CJK_unified_ideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=_	CJK_unified_ideographs}', "");
    Expect(0, 40959, '\P{Is_Block=_	CJK_unified_ideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=_	CJK_unified_ideographs}', "");
    Expect(0, 40960, '\p{Is_Block=_	CJK_unified_ideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=_	CJK_unified_ideographs}', "");
    Expect(1, 40960, '\P{Is_Block=_	CJK_unified_ideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=_	CJK_unified_ideographs}', "");
    Error('\p{Is_Blk=_/a/CJK}');
    Error('\P{Is_Blk=_/a/CJK}');
    Expect(1, 40959, '\p{Is_Blk=cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk=cjk}', "");
    Expect(0, 40959, '\P{Is_Blk=cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk=cjk}', "");
    Expect(0, 40960, '\p{Is_Blk=cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk=cjk}', "");
    Expect(1, 40960, '\P{Is_Blk=cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk=cjk}', "");
    Expect(1, 40959, '\p{Is_Blk=	cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk=	cjk}', "");
    Expect(0, 40959, '\P{Is_Blk=	cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk=	cjk}', "");
    Expect(0, 40960, '\p{Is_Blk=	cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk=	cjk}', "");
    Expect(1, 40960, '\P{Is_Blk=	cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk=	cjk}', "");
    Error('\p{Block=	/a/cjk_Compatibility}');
    Error('\P{Block=	/a/cjk_Compatibility}');
    Expect(1, 13311, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(1, 13311, '\p{Block=cjk_Compatibility}', "");
    Expect(0, 13311, '\p{^Block=cjk_Compatibility}', "");
    Expect(0, 13311, '\P{Block=cjk_Compatibility}', "");
    Expect(1, 13311, '\P{^Block=cjk_Compatibility}', "");
    Expect(0, 13312, '\p{Block=cjk_Compatibility}', "");
    Expect(1, 13312, '\p{^Block=cjk_Compatibility}', "");
    Expect(1, 13312, '\P{Block=cjk_Compatibility}', "");
    Expect(0, 13312, '\P{^Block=cjk_Compatibility}', "");
    Error('\p{Blk= :=CJK_Compat}');
    Error('\P{Blk= :=CJK_Compat}');
    Expect(1, 13311, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(1, 13311, '\p{Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(1, 13311, '\p{Blk=		CJK_Compat}', "");
    Expect(0, 13311, '\p{^Blk=		CJK_Compat}', "");
    Expect(0, 13311, '\P{Blk=		CJK_Compat}', "");
    Expect(1, 13311, '\P{^Blk=		CJK_Compat}', "");
    Expect(0, 13312, '\p{Blk=		CJK_Compat}', "");
    Expect(1, 13312, '\p{^Blk=		CJK_Compat}', "");
    Expect(1, 13312, '\P{Blk=		CJK_Compat}', "");
    Expect(0, 13312, '\P{^Blk=		CJK_Compat}', "");
    Error('\p{Is_Block=/a/cjk_COMPATIBILITY}');
    Error('\P{Is_Block=/a/cjk_COMPATIBILITY}');
    Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(0, 13311, '\p{^Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(0, 13311, '\P{Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(1, 13311, '\P{^Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(0, 13312, '\p{Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(1, 13312, '\p{^Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(1, 13312, '\P{Is_Block=__CJK_COMPATIBILITY}', "");
    Expect(0, 13312, '\P{^Is_Block=__CJK_COMPATIBILITY}', "");
    Error('\p{Is_Blk=:=_ CJK_Compat}');
    Error('\P{Is_Blk=:=_ CJK_Compat}');
    Expect(1, 13311, '\p{Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Is_Blk: -_CJK_compat}', "");
    Expect(0, 13311, '\p{^Is_Blk: -_CJK_compat}', "");
    Expect(0, 13311, '\P{Is_Blk: -_CJK_compat}', "");
    Expect(1, 13311, '\P{^Is_Blk: -_CJK_compat}', "");
    Expect(0, 13312, '\p{Is_Blk: -_CJK_compat}', "");
    Expect(1, 13312, '\p{^Is_Blk: -_CJK_compat}', "");
    Expect(1, 13312, '\P{Is_Blk: -_CJK_compat}', "");
    Expect(0, 13312, '\P{^Is_Blk: -_CJK_compat}', "");
    Error('\p{Block::=_-cjk_Compatibility_forms}');
    Error('\P{Block::=_-cjk_Compatibility_forms}');
    Expect(1, 65103, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(1, 65103, '\p{Block=_ CJK_Compatibility_forms}', "");
    Expect(0, 65103, '\p{^Block=_ CJK_Compatibility_forms}', "");
    Expect(0, 65103, '\P{Block=_ CJK_Compatibility_forms}', "");
    Expect(1, 65103, '\P{^Block=_ CJK_Compatibility_forms}', "");
    Expect(0, 65104, '\p{Block=_ CJK_Compatibility_forms}', "");
    Expect(1, 65104, '\p{^Block=_ CJK_Compatibility_forms}', "");
    Expect(1, 65104, '\P{Block=_ CJK_Compatibility_forms}', "");
    Expect(0, 65104, '\P{^Block=_ CJK_Compatibility_forms}', "");
    Error('\p{Blk=:=- CJK_compat_FORMS}');
    Error('\P{Blk=:=- CJK_compat_FORMS}');
    Expect(1, 65103, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(1, 65103, '\p{Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(1, 65103, '\p{Blk=_ CJK_Compat_FORMS}', "");
    Expect(0, 65103, '\p{^Blk=_ CJK_Compat_FORMS}', "");
    Expect(0, 65103, '\P{Blk=_ CJK_Compat_FORMS}', "");
    Expect(1, 65103, '\P{^Blk=_ CJK_Compat_FORMS}', "");
    Expect(0, 65104, '\p{Blk=_ CJK_Compat_FORMS}', "");
    Expect(1, 65104, '\p{^Blk=_ CJK_Compat_FORMS}', "");
    Expect(1, 65104, '\P{Blk=_ CJK_Compat_FORMS}', "");
    Expect(0, 65104, '\P{^Blk=_ CJK_Compat_FORMS}', "");
    Error('\p{Is_Block=:= _CJK_COMPATIBILITY_Forms}');
    Error('\P{Is_Block=:= _CJK_COMPATIBILITY_Forms}');
    Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Is_Block=	cjk_Compatibility_forms}', "");
    Expect(0, 65103, '\p{^Is_Block=	cjk_Compatibility_forms}', "");
    Expect(0, 65103, '\P{Is_Block=	cjk_Compatibility_forms}', "");
    Expect(1, 65103, '\P{^Is_Block=	cjk_Compatibility_forms}', "");
    Expect(0, 65104, '\p{Is_Block=	cjk_Compatibility_forms}', "");
    Expect(1, 65104, '\p{^Is_Block=	cjk_Compatibility_forms}', "");
    Expect(1, 65104, '\P{Is_Block=	cjk_Compatibility_forms}', "");
    Expect(0, 65104, '\P{^Is_Block=	cjk_Compatibility_forms}', "");
    Error('\p{Is_Blk:   CJK_COMPAT_forms/a/}');
    Error('\P{Is_Blk:   CJK_COMPAT_forms/a/}');
    Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(0, 65103, '\p{^Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(0, 65103, '\P{Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(1, 65103, '\P{^Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(0, 65104, '\p{Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(1, 65104, '\p{^Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(1, 65104, '\P{Is_Blk=_ CJK_compat_FORMS}', "");
    Expect(0, 65104, '\P{^Is_Blk=_ CJK_compat_FORMS}', "");
    Error('\p{Block=	/a/CJK_COMPATIBILITY_ideographs}');
    Error('\P{Block=	/a/CJK_COMPATIBILITY_ideographs}');
    Expect(1, 64255, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Block:cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Block:cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Block:cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Block:cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Block:cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Block:cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Block:cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Block:cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\p{^Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\P{Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(1, 64255, '\P{^Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\p{Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\p{^Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\P{Block=_ cjk_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\P{^Block=_ cjk_Compatibility_Ideographs}', "");
    Error('\p{Blk=	/a/CJK_Compat_Ideographs}');
    Error('\P{Blk=	/a/CJK_Compat_Ideographs}');
    Expect(1, 64255, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64255, '\p{^Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64255, '\P{Blk=CJK_Compat_ideographs}', "");
    Expect(1, 64255, '\P{^Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64256, '\p{Blk=CJK_Compat_ideographs}', "");
    Expect(1, 64256, '\p{^Blk=CJK_Compat_ideographs}', "");
    Expect(1, 64256, '\P{Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64256, '\P{^Blk=CJK_Compat_ideographs}', "");
    Error('\p{Is_Block=/a/		CJK_COMPATIBILITY_Ideographs}');
    Error('\P{Is_Block=/a/		CJK_COMPATIBILITY_Ideographs}');
    Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\p{^Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\P{Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(1, 64255, '\P{^Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\p{Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\p{^Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\P{Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\P{^Is_Block=-_CJK_Compatibility_Ideographs}', "");
    Error('\p{Is_Blk=:= _cjk_Compat_IDEOGRAPHS}');
    Error('\P{Is_Blk=:= _cjk_Compat_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(0, 64255, '\P{Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(0, 64256, '\p{Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(1, 64256, '\P{Is_Blk= 	cjk_Compat_ideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk= 	cjk_Compat_ideographs}', "");
    Error('\p{Block=	 CJK_compatibility_IDEOGRAPHS_supplement:=}');
    Error('\P{Block=	 CJK_compatibility_IDEOGRAPHS_supplement:=}');
    Expect(1, 195103, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(1, 195103, '\p{Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(1, 195103, '\p{Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(0, 195103, '\p{^Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(0, 195103, '\P{Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(1, 195103, '\P{^Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(0, 195104, '\p{Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(1, 195104, '\p{^Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(1, 195104, '\P{Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Expect(0, 195104, '\P{^Block=	CJK_COMPATIBILITY_ideographs_SUPPLEMENT}', "");
    Error('\p{Blk=:=_	CJK_COMPAT_Ideographs_Sup}');
    Error('\P{Blk=:=_	CJK_COMPAT_Ideographs_Sup}');
    Expect(1, 195103, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(1, 195103, '\p{Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(1, 195103, '\p{Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(0, 195103, '\p{^Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(0, 195103, '\P{Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(1, 195103, '\P{^Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(0, 195104, '\p{Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(1, 195104, '\p{^Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(1, 195104, '\P{Blk: --CJK_Compat_ideographs_Sup}', "");
    Expect(0, 195104, '\P{^Blk: --CJK_Compat_ideographs_Sup}', "");
    Error('\p{Is_Block=:=CJK_compatibility_Ideographs_Supplement}');
    Error('\P{Is_Block=:=CJK_compatibility_Ideographs_Supplement}');
    Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195103, '\p{^Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195103, '\P{Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(1, 195103, '\P{^Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195104, '\p{Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(1, 195104, '\p{^Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(1, 195104, '\P{Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Expect(0, 195104, '\P{^Is_Block=	CJK_Compatibility_Ideographs_SUPPLEMENT}', "");
    Error('\p{Is_Blk:   	 CJK_compat_ideographs_Sup/a/}');
    Error('\P{Is_Blk:   	 CJK_compat_ideographs_Sup/a/}');
    Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(0, 195103, '\p{^Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(0, 195103, '\P{Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(1, 195103, '\P{^Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(0, 195104, '\p{Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(1, 195104, '\p{^Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(1, 195104, '\P{Is_Blk=CJK_compat_ideographs_SUP}', "");
    Expect(0, 195104, '\P{^Is_Blk=CJK_compat_ideographs_SUP}', "");
    Error('\p{Block=:=  cjk_unified_Ideographs_Extension_A}');
    Error('\P{Block=:=  cjk_unified_Ideographs_Extension_A}');
    Expect(1, 19903, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(0, 19904, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(0, 19904, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(1, 19903, '\p{Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19903, '\p{^Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19903, '\P{Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(1, 19903, '\P{^Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19904, '\p{Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(1, 19904, '\p{^Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(1, 19904, '\P{Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19904, '\P{^Block=_	CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Error('\p{Blk=:=	 CJK_EXT_A}');
    Error('\P{Blk=:=	 CJK_EXT_A}');
    Expect(1, 19903, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(1, 19903, '\p{Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(1, 19903, '\p{Blk=		CJK_Ext_A}', "");
    Expect(0, 19903, '\p{^Blk=		CJK_Ext_A}', "");
    Expect(0, 19903, '\P{Blk=		CJK_Ext_A}', "");
    Expect(1, 19903, '\P{^Blk=		CJK_Ext_A}', "");
    Expect(0, 19904, '\p{Blk=		CJK_Ext_A}', "");
    Expect(1, 19904, '\p{^Blk=		CJK_Ext_A}', "");
    Expect(1, 19904, '\P{Blk=		CJK_Ext_A}', "");
    Expect(0, 19904, '\P{^Blk=		CJK_Ext_A}', "");
    Error('\p{Is_Block=:=		cjk_Unified_Ideographs_Extension_A}');
    Error('\P{Is_Block=:=		cjk_Unified_Ideographs_Extension_A}');
    Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19903, '\p{^Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19903, '\P{Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(1, 19903, '\P{^Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19904, '\p{Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(1, 19904, '\p{^Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(1, 19904, '\P{Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Expect(0, 19904, '\P{^Is_Block= -CJK_Unified_IDEOGRAPHS_Extension_A}', "");
    Error('\p{Is_Blk=-/a/cjk_Ext_A}');
    Error('\P{Is_Blk=-/a/cjk_Ext_A}');
    Expect(1, 19903, '\p{Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Is_Blk=_CJK_EXT_A}', "");
    Expect(0, 19903, '\p{^Is_Blk=_CJK_EXT_A}', "");
    Expect(0, 19903, '\P{Is_Blk=_CJK_EXT_A}', "");
    Expect(1, 19903, '\P{^Is_Blk=_CJK_EXT_A}', "");
    Expect(0, 19904, '\p{Is_Blk=_CJK_EXT_A}', "");
    Expect(1, 19904, '\p{^Is_Blk=_CJK_EXT_A}', "");
    Expect(1, 19904, '\P{Is_Blk=_CJK_EXT_A}', "");
    Expect(0, 19904, '\P{^Is_Blk=_CJK_EXT_A}', "");
    Error('\p{Block=/a/ -cjk_Unified_Ideographs_EXTENSION_B}');
    Error('\P{Block=/a/ -cjk_Unified_Ideographs_EXTENSION_B}');
    Expect(1, 173791, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(0, 173792, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(0, 173792, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(1, 173791, '\p{Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(0, 173791, '\p{^Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(0, 173791, '\P{Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(1, 173791, '\P{^Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(0, 173792, '\p{Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(1, 173792, '\p{^Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(1, 173792, '\P{Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Expect(0, 173792, '\P{^Block=-	CJK_Unified_Ideographs_EXTENSION_B}', "");
    Error('\p{Blk=	-CJK_EXT_B/a/}');
    Error('\P{Blk=	-CJK_EXT_B/a/}');
    Expect(1, 173791, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(1, 173791, '\p{Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(1, 173791, '\p{Blk=--CJK_ext_B}', "");
    Expect(0, 173791, '\p{^Blk=--CJK_ext_B}', "");
    Expect(0, 173791, '\P{Blk=--CJK_ext_B}', "");
    Expect(1, 173791, '\P{^Blk=--CJK_ext_B}', "");
    Expect(0, 173792, '\p{Blk=--CJK_ext_B}', "");
    Expect(1, 173792, '\p{^Blk=--CJK_ext_B}', "");
    Expect(1, 173792, '\P{Blk=--CJK_ext_B}', "");
    Expect(0, 173792, '\P{^Blk=--CJK_ext_B}', "");
    Error('\p{Is_Block=:=CJK_UNIFIED_Ideographs_Extension_B}');
    Error('\P{Is_Block=:=CJK_UNIFIED_Ideographs_Extension_B}');
    Expect(1, 173791, '\p{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(0, 173791, '\p{^Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(0, 173791, '\P{Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(1, 173791, '\P{^Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(0, 173792, '\p{Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(1, 173792, '\p{^Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(1, 173792, '\P{Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Expect(0, 173792, '\P{^Is_Block:-CJK_UNIFIED_Ideographs_EXTENSION_b}', "");
    Error('\p{Is_Blk= /a/CJK_ext_B}');
    Error('\P{Is_Blk= /a/CJK_ext_B}');
    Expect(1, 173791, '\p{Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Is_Blk:	CJK_EXT_B}', "");
    Expect(0, 173791, '\p{^Is_Blk:	CJK_EXT_B}', "");
    Expect(0, 173791, '\P{Is_Blk:	CJK_EXT_B}', "");
    Expect(1, 173791, '\P{^Is_Blk:	CJK_EXT_B}', "");
    Expect(0, 173792, '\p{Is_Blk:	CJK_EXT_B}', "");
    Expect(1, 173792, '\p{^Is_Blk:	CJK_EXT_B}', "");
    Expect(1, 173792, '\P{Is_Blk:	CJK_EXT_B}', "");
    Expect(0, 173792, '\P{^Is_Blk:	CJK_EXT_B}', "");
    Error('\p{Block=:=-	cjk_unified_Ideographs_Extension_c}');
    Error('\P{Block=:=-	cjk_unified_Ideographs_Extension_c}');
    Expect(1, 177983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(0, 177984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(0, 177984, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(1, 177983, '\p{Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(0, 177983, '\p{^Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(0, 177983, '\P{Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(1, 177983, '\P{^Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(0, 177984, '\p{Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(1, 177984, '\p{^Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(1, 177984, '\P{Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Expect(0, 177984, '\P{^Block=-_CJK_unified_ideographs_EXTENSION_C}', "");
    Error('\p{Blk= :=CJK_Ext_C}');
    Error('\P{Blk= :=CJK_Ext_C}');
    Expect(1, 177983, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(1, 177983, '\p{Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(1, 177983, '\p{Blk:  CJK_ext_C}', "");
    Expect(0, 177983, '\p{^Blk:  CJK_ext_C}', "");
    Expect(0, 177983, '\P{Blk:  CJK_ext_C}', "");
    Expect(1, 177983, '\P{^Blk:  CJK_ext_C}', "");
    Expect(0, 177984, '\p{Blk:  CJK_ext_C}', "");
    Expect(1, 177984, '\p{^Blk:  CJK_ext_C}', "");
    Expect(1, 177984, '\P{Blk:  CJK_ext_C}', "");
    Expect(0, 177984, '\P{^Blk:  CJK_ext_C}', "");
    Error('\p{Is_Block=_-CJK_Unified_IDEOGRAPHS_Extension_c:=}');
    Error('\P{Is_Block=_-CJK_Unified_IDEOGRAPHS_Extension_c:=}');
    Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(0, 177983, '\p{^Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(0, 177983, '\P{Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(1, 177983, '\P{^Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(0, 177984, '\p{Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(1, 177984, '\p{^Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(1, 177984, '\P{Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Expect(0, 177984, '\P{^Is_Block=  cjk_Unified_IDEOGRAPHS_extension_c}', "");
    Error('\p{Is_Blk=- cjk_ext_c/a/}');
    Error('\P{Is_Blk=- cjk_ext_c/a/}');
    Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Is_Blk=-cjk_EXT_C}', "");
    Expect(0, 177983, '\p{^Is_Blk=-cjk_EXT_C}', "");
    Expect(0, 177983, '\P{Is_Blk=-cjk_EXT_C}', "");
    Expect(1, 177983, '\P{^Is_Blk=-cjk_EXT_C}', "");
    Expect(0, 177984, '\p{Is_Blk=-cjk_EXT_C}', "");
    Expect(1, 177984, '\p{^Is_Blk=-cjk_EXT_C}', "");
    Expect(1, 177984, '\P{Is_Blk=-cjk_EXT_C}', "");
    Expect(0, 177984, '\P{^Is_Blk=-cjk_EXT_C}', "");
    Error('\p{Block=	CJK_UNIFIED_Ideographs_Extension_d:=}');
    Error('\P{Block=	CJK_UNIFIED_Ideographs_Extension_d:=}');
    Expect(1, 178207, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(0, 178208, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(1, 178207, '\p{Block:	cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Block:	cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Block:	cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Block:	cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Block:	cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Block:	cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Block:	cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Block:	cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(0, 178208, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(1, 178207, '\p{Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(0, 178207, '\p{^Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(0, 178207, '\P{Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(1, 178207, '\P{^Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(0, 178208, '\p{Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(1, 178208, '\p{^Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(1, 178208, '\P{Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Expect(0, 178208, '\P{^Block= -CJK_Unified_Ideographs_Extension_D}', "");
    Error('\p{Blk:-:=cjk_Ext_D}');
    Error('\P{Blk:-:=cjk_Ext_D}');
    Expect(1, 178207, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(1, 178207, '\p{Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(1, 178207, '\p{Blk=--CJK_Ext_d}', "");
    Expect(0, 178207, '\p{^Blk=--CJK_Ext_d}', "");
    Expect(0, 178207, '\P{Blk=--CJK_Ext_d}', "");
    Expect(1, 178207, '\P{^Blk=--CJK_Ext_d}', "");
    Expect(0, 178208, '\p{Blk=--CJK_Ext_d}', "");
    Expect(1, 178208, '\p{^Blk=--CJK_Ext_d}', "");
    Expect(1, 178208, '\P{Blk=--CJK_Ext_d}', "");
    Expect(0, 178208, '\P{^Blk=--CJK_Ext_d}', "");
    Error('\p{Is_Block=:= 	cjk_Unified_IDEOGRAPHS_EXTENSION_d}');
    Error('\P{Is_Block=:= 	cjk_Unified_IDEOGRAPHS_EXTENSION_d}');
    Expect(1, 178207, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178207, '\p{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178207, '\P{Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(1, 178207, '\P{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178208, '\p{Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(1, 178208, '\p{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(1, 178208, '\P{Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Expect(0, 178208, '\P{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_D}', "");
    Error('\p{Is_Blk:_CJK_EXT_D/a/}');
    Error('\P{Is_Blk:_CJK_EXT_D/a/}');
    Expect(1, 178207, '\p{Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Is_Blk=_CJK_Ext_D}', "");
    Expect(0, 178207, '\p{^Is_Blk=_CJK_Ext_D}', "");
    Expect(0, 178207, '\P{Is_Blk=_CJK_Ext_D}', "");
    Expect(1, 178207, '\P{^Is_Blk=_CJK_Ext_D}', "");
    Expect(0, 178208, '\p{Is_Blk=_CJK_Ext_D}', "");
    Expect(1, 178208, '\p{^Is_Blk=_CJK_Ext_D}', "");
    Expect(1, 178208, '\P{Is_Blk=_CJK_Ext_D}', "");
    Expect(0, 178208, '\P{^Is_Blk=_CJK_Ext_D}', "");
    Error('\p{Block:   	_CJK_Unified_ideographs_EXTENSION_E/a/}');
    Error('\P{Block:   	_CJK_Unified_ideographs_EXTENSION_E/a/}');
    Expect(1, 183983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(0, 183984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(1, 183983, '\p{Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(0, 183984, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(1, 183983, '\p{Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(0, 183983, '\p{^Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(0, 183983, '\P{Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(1, 183983, '\P{^Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(0, 183984, '\p{Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(1, 183984, '\p{^Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(1, 183984, '\P{Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Expect(0, 183984, '\P{^Block=	CJK_Unified_Ideographs_Extension_E}', "");
    Error('\p{Blk=CJK_ext_E:=}');
    Error('\P{Blk=CJK_ext_E:=}');
    Expect(1, 183983, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(1, 183983, '\p{Blk:cjkexte}', "");
    Expect(0, 183983, '\p{^Blk:cjkexte}', "");
    Expect(0, 183983, '\P{Blk:cjkexte}', "");
    Expect(1, 183983, '\P{^Blk:cjkexte}', "");
    Expect(0, 183984, '\p{Blk:cjkexte}', "");
    Expect(1, 183984, '\p{^Blk:cjkexte}', "");
    Expect(1, 183984, '\P{Blk:cjkexte}', "");
    Expect(0, 183984, '\P{^Blk:cjkexte}', "");
    Expect(1, 183983, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(1, 183983, '\p{Blk= _cjk_ext_E}', "");
    Expect(0, 183983, '\p{^Blk= _cjk_ext_E}', "");
    Expect(0, 183983, '\P{Blk= _cjk_ext_E}', "");
    Expect(1, 183983, '\P{^Blk= _cjk_ext_E}', "");
    Expect(0, 183984, '\p{Blk= _cjk_ext_E}', "");
    Expect(1, 183984, '\p{^Blk= _cjk_ext_E}', "");
    Expect(1, 183984, '\P{Blk= _cjk_ext_E}', "");
    Expect(0, 183984, '\P{^Blk= _cjk_ext_E}', "");
    Error('\p{Is_Block=_CJK_unified_IDEOGRAPHS_extension_e:=}');
    Error('\P{Is_Block=_CJK_unified_IDEOGRAPHS_extension_e:=}');
    Expect(1, 183983, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(0, 183983, '\p{^Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(0, 183983, '\P{Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(1, 183983, '\P{^Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(0, 183984, '\p{Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(1, 183984, '\p{^Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(1, 183984, '\P{Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Expect(0, 183984, '\P{^Is_Block=CJK_Unified_ideographs_Extension_E}', "");
    Error('\p{Is_Blk= -CJK_Ext_E/a/}');
    Error('\P{Is_Blk= -CJK_Ext_E/a/}');
    Expect(1, 183983, '\p{Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Is_Blk:    CJK_Ext_E}', "");
    Expect(0, 183983, '\p{^Is_Blk:    CJK_Ext_E}', "");
    Expect(0, 183983, '\P{Is_Blk:    CJK_Ext_E}', "");
    Expect(1, 183983, '\P{^Is_Blk:    CJK_Ext_E}', "");
    Expect(0, 183984, '\p{Is_Blk:    CJK_Ext_E}', "");
    Expect(1, 183984, '\p{^Is_Blk:    CJK_Ext_E}', "");
    Expect(1, 183984, '\P{Is_Blk:    CJK_Ext_E}', "");
    Expect(0, 183984, '\P{^Is_Blk:    CJK_Ext_E}', "");
    Error('\p{Block=:=__CJK_Unified_Ideographs_Extension_f}');
    Error('\P{Block=:=__CJK_Unified_Ideographs_Extension_f}');
    Expect(1, 191471, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(0, 191472, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(1, 191471, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(0, 191472, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(1, 191471, '\p{Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(0, 191471, '\p{^Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(0, 191471, '\P{Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(1, 191471, '\P{^Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(0, 191472, '\p{Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(1, 191472, '\p{^Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(1, 191472, '\P{Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Expect(0, 191472, '\P{^Block:	cjk_unified_IDEOGRAPHS_Extension_F}', "");
    Error('\p{Blk=	_CJK_Ext_F/a/}');
    Error('\P{Blk=	_CJK_Ext_F/a/}');
    Expect(1, 191471, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(1, 191471, '\p{Blk: cjkextf}', "");
    Expect(0, 191471, '\p{^Blk: cjkextf}', "");
    Expect(0, 191471, '\P{Blk: cjkextf}', "");
    Expect(1, 191471, '\P{^Blk: cjkextf}', "");
    Expect(0, 191472, '\p{Blk: cjkextf}', "");
    Expect(1, 191472, '\p{^Blk: cjkextf}', "");
    Expect(1, 191472, '\P{Blk: cjkextf}', "");
    Expect(0, 191472, '\P{^Blk: cjkextf}', "");
    Expect(1, 191471, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(1, 191471, '\p{Blk=_	CJK_Ext_F}', "");
    Expect(0, 191471, '\p{^Blk=_	CJK_Ext_F}', "");
    Expect(0, 191471, '\P{Blk=_	CJK_Ext_F}', "");
    Expect(1, 191471, '\P{^Blk=_	CJK_Ext_F}', "");
    Expect(0, 191472, '\p{Blk=_	CJK_Ext_F}', "");
    Expect(1, 191472, '\p{^Blk=_	CJK_Ext_F}', "");
    Expect(1, 191472, '\P{Blk=_	CJK_Ext_F}', "");
    Expect(0, 191472, '\P{^Blk=_	CJK_Ext_F}', "");
    Error('\p{Is_Block=:=	_CJK_Unified_Ideographs_Extension_F}');
    Error('\P{Is_Block=:=	_CJK_Unified_Ideographs_Extension_F}');
    Expect(1, 191471, '\p{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(0, 191471, '\p{^Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(0, 191471, '\P{Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(1, 191471, '\P{^Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(0, 191472, '\p{Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(1, 191472, '\p{^Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(1, 191472, '\P{Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Expect(0, 191472, '\P{^Is_Block=	 CJK_unified_ideographs_Extension_F}', "");
    Error('\p{Is_Blk= :=CJK_EXT_F}');
    Error('\P{Is_Blk= :=CJK_EXT_F}');
    Expect(1, 191471, '\p{Is_Blk: cjkextf}', "");
    Expect(0, 191471, '\p{^Is_Blk: cjkextf}', "");
    Expect(0, 191471, '\P{Is_Blk: cjkextf}', "");
    Expect(1, 191471, '\P{^Is_Blk: cjkextf}', "");
    Expect(0, 191472, '\p{Is_Blk: cjkextf}', "");
    Expect(1, 191472, '\p{^Is_Blk: cjkextf}', "");
    Expect(1, 191472, '\P{Is_Blk: cjkextf}', "");
    Expect(0, 191472, '\P{^Is_Blk: cjkextf}', "");
    Expect(1, 191471, '\p{Is_Blk=-_CJK_ext_F}', "");
    Expect(0, 191471, '\p{^Is_Blk=-_CJK_ext_F}', "");
    Expect(0, 191471, '\P{Is_Blk=-_CJK_ext_F}', "");
    Expect(1, 191471, '\P{^Is_Blk=-_CJK_ext_F}', "");
    Expect(0, 191472, '\p{Is_Blk=-_CJK_ext_F}', "");
    Expect(1, 191472, '\p{^Is_Blk=-_CJK_ext_F}', "");
    Expect(1, 191472, '\P{Is_Blk=-_CJK_ext_F}', "");
    Expect(0, 191472, '\P{^Is_Blk=-_CJK_ext_F}', "");
    Error('\p{Block=	 cjk_Radicals_SUPPLEMENT/a/}');
    Error('\P{Block=	 cjk_Radicals_SUPPLEMENT/a/}');
    Expect(1, 12031, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(1, 12031, '\p{Block:cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Block:cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Block:cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Block:cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Block:cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Block:cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Block:cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Block:cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(1, 12031, '\p{Block=_ cjk_Radicals_supplement}', "");
    Expect(0, 12031, '\p{^Block=_ cjk_Radicals_supplement}', "");
    Expect(0, 12031, '\P{Block=_ cjk_Radicals_supplement}', "");
    Expect(1, 12031, '\P{^Block=_ cjk_Radicals_supplement}', "");
    Expect(0, 12032, '\p{Block=_ cjk_Radicals_supplement}', "");
    Expect(1, 12032, '\p{^Block=_ cjk_Radicals_supplement}', "");
    Expect(1, 12032, '\P{Block=_ cjk_Radicals_supplement}', "");
    Expect(0, 12032, '\P{^Block=_ cjk_Radicals_supplement}', "");
    Error('\p{Blk=/a/__CJK_Radicals_Sup}');
    Error('\P{Blk=/a/__CJK_Radicals_Sup}');
    Expect(1, 12031, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(1, 12031, '\p{Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(1, 12031, '\p{Blk=	CJK_RADICALS_sup}', "");
    Expect(0, 12031, '\p{^Blk=	CJK_RADICALS_sup}', "");
    Expect(0, 12031, '\P{Blk=	CJK_RADICALS_sup}', "");
    Expect(1, 12031, '\P{^Blk=	CJK_RADICALS_sup}', "");
    Expect(0, 12032, '\p{Blk=	CJK_RADICALS_sup}', "");
    Expect(1, 12032, '\p{^Blk=	CJK_RADICALS_sup}', "");
    Expect(1, 12032, '\P{Blk=	CJK_RADICALS_sup}', "");
    Expect(0, 12032, '\P{^Blk=	CJK_RADICALS_sup}', "");
    Error('\p{Is_Block=	-CJK_RADICALS_supplement:=}');
    Error('\P{Is_Block=	-CJK_RADICALS_supplement:=}');
    Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(0, 12031, '\p{^Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(0, 12031, '\P{Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(1, 12031, '\P{^Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(0, 12032, '\p{Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(1, 12032, '\p{^Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(1, 12032, '\P{Is_Block=_CJK_Radicals_Supplement}', "");
    Expect(0, 12032, '\P{^Is_Block=_CJK_Radicals_Supplement}', "");
    Error('\p{Is_Blk=/a/_CJK_Radicals_Sup}');
    Error('\P{Is_Blk=/a/_CJK_Radicals_Sup}');
    Expect(1, 12031, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(0, 12031, '\p{^Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(0, 12031, '\P{Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(1, 12031, '\P{^Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(0, 12032, '\p{Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(1, 12032, '\p{^Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(1, 12032, '\P{Is_Blk=_	CJK_radicals_SUP}', "");
    Expect(0, 12032, '\P{^Is_Blk=_	CJK_radicals_SUP}', "");
    Error('\p{Block= :=CJK_Strokes}');
    Error('\P{Block= :=CJK_Strokes}');
    Expect(1, 12783, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Block=--CJK_STROKES}', "");
    Expect(0, 12783, '\p{^Block=--CJK_STROKES}', "");
    Expect(0, 12783, '\P{Block=--CJK_STROKES}', "");
    Expect(1, 12783, '\P{^Block=--CJK_STROKES}', "");
    Expect(0, 12784, '\p{Block=--CJK_STROKES}', "");
    Expect(1, 12784, '\p{^Block=--CJK_STROKES}', "");
    Expect(1, 12784, '\P{Block=--CJK_STROKES}', "");
    Expect(0, 12784, '\P{^Block=--CJK_STROKES}', "");
    Error('\p{Blk=:=CJK_Strokes}');
    Error('\P{Blk=:=CJK_Strokes}');
    Expect(1, 12783, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Blk=_-CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Blk=_-CJK_Strokes}', "");
    Expect(0, 12783, '\P{Blk=_-CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Blk=_-CJK_Strokes}', "");
    Expect(0, 12784, '\p{Blk=_-CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Blk=_-CJK_Strokes}', "");
    Expect(1, 12784, '\P{Blk=_-CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Blk=_-CJK_Strokes}', "");
    Error('\p{Is_Block=:=	-cjk_STROKES}');
    Error('\P{Is_Block=:=	-cjk_STROKES}');
    Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Block= CJK_strokes}', "");
    Expect(0, 12783, '\p{^Is_Block= CJK_strokes}', "");
    Expect(0, 12783, '\P{Is_Block= CJK_strokes}', "");
    Expect(1, 12783, '\P{^Is_Block= CJK_strokes}', "");
    Expect(0, 12784, '\p{Is_Block= CJK_strokes}', "");
    Expect(1, 12784, '\p{^Is_Block= CJK_strokes}', "");
    Expect(1, 12784, '\P{Is_Block= CJK_strokes}', "");
    Expect(0, 12784, '\P{^Is_Block= CJK_strokes}', "");
    Error('\p{Is_Blk=	:=CJK_Strokes}');
    Error('\P{Is_Blk=	:=CJK_Strokes}');
    Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Blk=_ CJK_strokes}', "");
    Expect(0, 12783, '\p{^Is_Blk=_ CJK_strokes}', "");
    Expect(0, 12783, '\P{Is_Blk=_ CJK_strokes}', "");
    Expect(1, 12783, '\P{^Is_Blk=_ CJK_strokes}', "");
    Expect(0, 12784, '\p{Is_Blk=_ CJK_strokes}', "");
    Expect(1, 12784, '\p{^Is_Blk=_ CJK_strokes}', "");
    Expect(1, 12784, '\P{Is_Blk=_ CJK_strokes}', "");
    Expect(0, 12784, '\P{^Is_Blk=_ CJK_strokes}', "");
    Error('\p{Block=	/a/CJK_Symbols_And_Punctuation}');
    Error('\P{Block=	/a/CJK_Symbols_And_Punctuation}');
    Expect(1, 12351, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 12351, '\p{Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(1, 12351, '\p{Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12351, '\p{^Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12351, '\P{Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(1, 12351, '\P{^Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12352, '\p{Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(1, 12352, '\p{^Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(1, 12352, '\P{Block:    _CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12352, '\P{^Block:    _CJK_Symbols_And_Punctuation}', "");
    Error('\p{Blk=:= CJK_SYMBOLS}');
    Error('\P{Blk=:= CJK_SYMBOLS}');
    Expect(1, 12351, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=-CJK_Symbols}', "");
    Expect(0, 12351, '\p{^Blk=-CJK_Symbols}', "");
    Expect(0, 12351, '\P{Blk=-CJK_Symbols}', "");
    Expect(1, 12351, '\P{^Blk=-CJK_Symbols}', "");
    Expect(0, 12352, '\p{Blk=-CJK_Symbols}', "");
    Expect(1, 12352, '\p{^Blk=-CJK_Symbols}', "");
    Expect(1, 12352, '\P{Blk=-CJK_Symbols}', "");
    Expect(0, 12352, '\P{^Blk=-CJK_Symbols}', "");
    Error('\p{Is_Block=_-CJK_Symbols_And_Punctuation/a/}');
    Error('\P{Is_Block=_-CJK_Symbols_And_Punctuation/a/}');
    Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(0, 12351, '\P{Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(0, 12352, '\p{Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(1, 12352, '\P{Is_Block=_CJK_symbols_and_punctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=_CJK_symbols_and_punctuation}', "");
    Error('\p{Is_Blk=	 CJK_symbols/a/}');
    Error('\P{Is_Blk=	 CJK_symbols/a/}');
    Expect(1, 12351, '\p{Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Is_Blk= CJK_symbols}', "");
    Expect(0, 12351, '\p{^Is_Blk= CJK_symbols}', "");
    Expect(0, 12351, '\P{Is_Blk= CJK_symbols}', "");
    Expect(1, 12351, '\P{^Is_Blk= CJK_symbols}', "");
    Expect(0, 12352, '\p{Is_Blk= CJK_symbols}', "");
    Expect(1, 12352, '\p{^Is_Blk= CJK_symbols}', "");
    Expect(1, 12352, '\P{Is_Blk= CJK_symbols}', "");
    Expect(0, 12352, '\P{^Is_Blk= CJK_symbols}', "");
    Error('\p{Block=/a/  Hangul_compatibility_jamo}');
    Error('\P{Block=/a/  Hangul_compatibility_jamo}');
    Expect(1, 12687, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(1, 12687, '\p{Block=-Hangul_Compatibility_jamo}', "");
    Expect(0, 12687, '\p{^Block=-Hangul_Compatibility_jamo}', "");
    Expect(0, 12687, '\P{Block=-Hangul_Compatibility_jamo}', "");
    Expect(1, 12687, '\P{^Block=-Hangul_Compatibility_jamo}', "");
    Expect(0, 12688, '\p{Block=-Hangul_Compatibility_jamo}', "");
    Expect(1, 12688, '\p{^Block=-Hangul_Compatibility_jamo}', "");
    Expect(1, 12688, '\P{Block=-Hangul_Compatibility_jamo}', "");
    Expect(0, 12688, '\P{^Block=-Hangul_Compatibility_jamo}', "");
    Error('\p{Blk=:=Compat_Jamo}');
    Error('\P{Blk=:=Compat_Jamo}');
    Expect(1, 12687, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=--COMPAT_Jamo}', "");
    Expect(0, 12687, '\p{^Blk=--COMPAT_Jamo}', "");
    Expect(0, 12687, '\P{Blk=--COMPAT_Jamo}', "");
    Expect(1, 12687, '\P{^Blk=--COMPAT_Jamo}', "");
    Expect(0, 12688, '\p{Blk=--COMPAT_Jamo}', "");
    Expect(1, 12688, '\p{^Blk=--COMPAT_Jamo}', "");
    Expect(1, 12688, '\P{Blk=--COMPAT_Jamo}', "");
    Expect(0, 12688, '\P{^Blk=--COMPAT_Jamo}', "");
    Error('\p{Is_Block=/a/hangul_COMPATIBILITY_Jamo}');
    Error('\P{Is_Block=/a/hangul_COMPATIBILITY_Jamo}');
    Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(0, 12687, '\p{^Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(0, 12687, '\P{Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(1, 12687, '\P{^Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(0, 12688, '\p{Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(1, 12688, '\p{^Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(1, 12688, '\P{Is_Block= _HANGUL_compatibility_JAMO}', "");
    Expect(0, 12688, '\P{^Is_Block= _HANGUL_compatibility_JAMO}', "");
    Error('\p{Is_Blk=	 Compat_Jamo/a/}');
    Error('\P{Is_Blk=	 Compat_Jamo/a/}');
    Expect(1, 12687, '\p{Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Is_Blk=--Compat_jamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=--Compat_jamo}', "");
    Expect(0, 12687, '\P{Is_Blk=--Compat_jamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=--Compat_jamo}', "");
    Expect(0, 12688, '\p{Is_Blk=--Compat_jamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=--Compat_jamo}', "");
    Expect(1, 12688, '\P{Is_Blk=--Compat_jamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=--Compat_jamo}', "");
    Error('\p{Block=/a/Control_Pictures}');
    Error('\P{Block=/a/Control_Pictures}');
    Expect(1, 9279, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Block=controlpictures}', "");
    Expect(0, 9279, '\P{Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Block=controlpictures}', "");
    Expect(0, 9280, '\p{Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Block=controlpictures}', "");
    Expect(1, 9280, '\P{Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Block=controlpictures}', "");
    Expect(1, 9279, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Block=CONTROL_PICTURES}', "");
    Expect(0, 9279, '\p{^Block=CONTROL_PICTURES}', "");
    Expect(0, 9279, '\P{Block=CONTROL_PICTURES}', "");
    Expect(1, 9279, '\P{^Block=CONTROL_PICTURES}', "");
    Expect(0, 9280, '\p{Block=CONTROL_PICTURES}', "");
    Expect(1, 9280, '\p{^Block=CONTROL_PICTURES}', "");
    Expect(1, 9280, '\P{Block=CONTROL_PICTURES}', "");
    Expect(0, 9280, '\P{^Block=CONTROL_PICTURES}', "");
    Error('\p{Blk=:=-CONTROL_Pictures}');
    Error('\P{Blk=:=-CONTROL_Pictures}');
    Expect(1, 9279, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Blk=	-Control_Pictures}', "");
    Expect(0, 9279, '\p{^Blk=	-Control_Pictures}', "");
    Expect(0, 9279, '\P{Blk=	-Control_Pictures}', "");
    Expect(1, 9279, '\P{^Blk=	-Control_Pictures}', "");
    Expect(0, 9280, '\p{Blk=	-Control_Pictures}', "");
    Expect(1, 9280, '\p{^Blk=	-Control_Pictures}', "");
    Expect(1, 9280, '\P{Blk=	-Control_Pictures}', "");
    Expect(0, 9280, '\P{^Blk=	-Control_Pictures}', "");
    Error('\p{Is_Block=	:=Control_Pictures}');
    Error('\P{Is_Block=	:=Control_Pictures}');
    Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Block=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Block=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Block=- control_Pictures}', "");
    Expect(0, 9279, '\p{^Is_Block=- control_Pictures}', "");
    Expect(0, 9279, '\P{Is_Block=- control_Pictures}', "");
    Expect(1, 9279, '\P{^Is_Block=- control_Pictures}', "");
    Expect(0, 9280, '\p{Is_Block=- control_Pictures}', "");
    Expect(1, 9280, '\p{^Is_Block=- control_Pictures}', "");
    Expect(1, 9280, '\P{Is_Block=- control_Pictures}', "");
    Expect(0, 9280, '\P{^Is_Block=- control_Pictures}', "");
    Error('\p{Is_Blk:_Control_Pictures/a/}');
    Error('\P{Is_Blk:_Control_Pictures/a/}');
    Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Blk=	control_pictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=	control_pictures}', "");
    Expect(0, 9279, '\P{Is_Blk=	control_pictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=	control_pictures}', "");
    Expect(0, 9280, '\p{Is_Blk=	control_pictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=	control_pictures}', "");
    Expect(1, 9280, '\P{Is_Blk=	control_pictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=	control_pictures}', "");
    Error('\p{Block=_:=Coptic}');
    Error('\P{Block=_:=Coptic}');
    Expect(1, 11519, '\p{Block=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=coptic}', "");
    Expect(0, 11519, '\p{^Block=coptic}', "");
    Expect(0, 11519, '\P{Block=coptic}', "");
    Expect(1, 11519, '\P{^Block=coptic}', "");
    Expect(0, 11520, '\p{Block=coptic}', "");
    Expect(1, 11520, '\p{^Block=coptic}', "");
    Expect(1, 11520, '\P{Block=coptic}', "");
    Expect(0, 11520, '\P{^Block=coptic}', "");
    Expect(1, 11519, '\p{Block=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=	Coptic}', "");
    Expect(0, 11519, '\p{^Block=	Coptic}', "");
    Expect(0, 11519, '\P{Block=	Coptic}', "");
    Expect(1, 11519, '\P{^Block=	Coptic}', "");
    Expect(0, 11520, '\p{Block=	Coptic}', "");
    Expect(1, 11520, '\p{^Block=	Coptic}', "");
    Expect(1, 11520, '\P{Block=	Coptic}', "");
    Expect(0, 11520, '\P{^Block=	Coptic}', "");
    Error('\p{Blk= COPTIC:=}');
    Error('\P{Blk= COPTIC:=}');
    Expect(1, 11519, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=coptic}', "");
    Expect(0, 11519, '\p{^Blk=coptic}', "");
    Expect(0, 11519, '\P{Blk=coptic}', "");
    Expect(1, 11519, '\P{^Blk=coptic}', "");
    Expect(0, 11520, '\p{Blk=coptic}', "");
    Expect(1, 11520, '\p{^Blk=coptic}', "");
    Expect(1, 11520, '\P{Blk=coptic}', "");
    Expect(0, 11520, '\P{^Blk=coptic}', "");
    Expect(1, 11519, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=	Coptic}', "");
    Expect(0, 11519, '\p{^Blk=	Coptic}', "");
    Expect(0, 11519, '\P{Blk=	Coptic}', "");
    Expect(1, 11519, '\P{^Blk=	Coptic}', "");
    Expect(0, 11520, '\p{Blk=	Coptic}', "");
    Expect(1, 11520, '\p{^Blk=	Coptic}', "");
    Expect(1, 11520, '\P{Blk=	Coptic}', "");
    Expect(0, 11520, '\P{^Blk=	Coptic}', "");
    Error('\p{Is_Block=/a/		Coptic}');
    Error('\P{Is_Block=/a/		Coptic}');
    Expect(1, 11519, '\p{Is_Block=coptic}', "");
    Expect(0, 11519, '\p{^Is_Block=coptic}', "");
    Expect(0, 11519, '\P{Is_Block=coptic}', "");
    Expect(1, 11519, '\P{^Is_Block=coptic}', "");
    Expect(0, 11520, '\p{Is_Block=coptic}', "");
    Expect(1, 11520, '\p{^Is_Block=coptic}', "");
    Expect(1, 11520, '\P{Is_Block=coptic}', "");
    Expect(0, 11520, '\P{^Is_Block=coptic}', "");
    Expect(1, 11519, '\p{Is_Block: 	Coptic}', "");
    Expect(0, 11519, '\p{^Is_Block: 	Coptic}', "");
    Expect(0, 11519, '\P{Is_Block: 	Coptic}', "");
    Expect(1, 11519, '\P{^Is_Block: 	Coptic}', "");
    Expect(0, 11520, '\p{Is_Block: 	Coptic}', "");
    Expect(1, 11520, '\p{^Is_Block: 	Coptic}', "");
    Expect(1, 11520, '\P{Is_Block: 	Coptic}', "");
    Expect(0, 11520, '\P{^Is_Block: 	Coptic}', "");
    Error('\p{Is_Blk=_-Coptic:=}');
    Error('\P{Is_Blk=_-Coptic:=}');
    Expect(1, 11519, '\p{Is_Blk=coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=coptic}', "");
    Expect(1, 11519, '\p{Is_Blk=_	Coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=_	Coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=_	Coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=_	Coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=_	Coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=_	Coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=_	Coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=_	Coptic}', "");
    Error('\p{Block=	:=COPTIC_Epact_Numbers}');
    Error('\P{Block=	:=COPTIC_Epact_Numbers}');
    Expect(1, 66303, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Block=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Block=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Block=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Block=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Block=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Block=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Block=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Block=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(0, 66303, '\p{^Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(0, 66303, '\P{Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(1, 66303, '\P{^Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(0, 66304, '\p{Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(1, 66304, '\p{^Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(1, 66304, '\P{Block=_	COPTIC_EPACT_NUMBERS}', "");
    Expect(0, 66304, '\P{^Block=_	COPTIC_EPACT_NUMBERS}', "");
    Error('\p{Blk=-/a/Coptic_epact_Numbers}');
    Error('\P{Blk=-/a/Coptic_epact_Numbers}');
    Expect(1, 66303, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Blk=		coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Blk=		coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Blk=		coptic_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Blk=		coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Blk=		coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Blk=		coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Blk=		coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Blk=		coptic_Epact_Numbers}', "");
    Error('\p{Is_Block=	_Coptic_Epact_NUMBERS:=}');
    Error('\P{Is_Block=	_Coptic_Epact_NUMBERS:=}');
    Expect(1, 66303, '\p{Is_Block=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Block=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Block=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Block=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Block=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Block=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Block=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Block=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(0, 66303, '\p{^Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(0, 66303, '\P{Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(1, 66303, '\P{^Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(0, 66304, '\p{Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(1, 66304, '\p{^Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(1, 66304, '\P{Is_Block=_coptic_EPACT_NUMBERS}', "");
    Expect(0, 66304, '\P{^Is_Block=_coptic_EPACT_NUMBERS}', "");
    Error('\p{Is_Blk=_-COPTIC_Epact_NUMBERS:=}');
    Error('\P{Is_Blk=_-COPTIC_Epact_NUMBERS:=}');
    Expect(1, 66303, '\p{Is_Blk: copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Blk: copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Blk: copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Blk: copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Blk: copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Blk: copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Blk: copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Blk: copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(0, 66303, '\P{Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(0, 66304, '\p{Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(1, 66304, '\P{Is_Blk=__Coptic_epact_Numbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=__Coptic_epact_Numbers}', "");
    Error('\p{Block=_:=COUNTING_ROD_Numerals}');
    Error('\P{Block=_:=COUNTING_ROD_Numerals}');
    Expect(1, 119679, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(1, 119679, '\p{Block=	-Counting_ROD_Numerals}', "");
    Expect(0, 119679, '\p{^Block=	-Counting_ROD_Numerals}', "");
    Expect(0, 119679, '\P{Block=	-Counting_ROD_Numerals}', "");
    Expect(1, 119679, '\P{^Block=	-Counting_ROD_Numerals}', "");
    Expect(0, 119680, '\p{Block=	-Counting_ROD_Numerals}', "");
    Expect(1, 119680, '\p{^Block=	-Counting_ROD_Numerals}', "");
    Expect(1, 119680, '\P{Block=	-Counting_ROD_Numerals}', "");
    Expect(0, 119680, '\P{^Block=	-Counting_ROD_Numerals}', "");
    Error('\p{Blk=-Counting_rod:=}');
    Error('\P{Blk=-Counting_rod:=}');
    Expect(1, 119679, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(1, 119679, '\p{Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Blk=countingrod}', "");
    Expect(0, 119679, '\P{Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Blk=countingrod}', "");
    Expect(0, 119680, '\p{Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Blk=countingrod}', "");
    Expect(1, 119680, '\P{Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Blk=countingrod}', "");
    Expect(1, 119679, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(1, 119679, '\p{Blk=_Counting_Rod}', "");
    Expect(0, 119679, '\p{^Blk=_Counting_Rod}', "");
    Expect(0, 119679, '\P{Blk=_Counting_Rod}', "");
    Expect(1, 119679, '\P{^Blk=_Counting_Rod}', "");
    Expect(0, 119680, '\p{Blk=_Counting_Rod}', "");
    Expect(1, 119680, '\p{^Blk=_Counting_Rod}', "");
    Expect(1, 119680, '\P{Blk=_Counting_Rod}', "");
    Expect(0, 119680, '\P{^Blk=_Counting_Rod}', "");
    Error('\p{Is_Block=	_Counting_rod_numerals:=}');
    Error('\P{Is_Block=	_Counting_rod_numerals:=}');
    Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Is_Block=--Counting_Rod_Numerals}', "");
    Expect(0, 119679, '\p{^Is_Block=--Counting_Rod_Numerals}', "");
    Expect(0, 119679, '\P{Is_Block=--Counting_Rod_Numerals}', "");
    Expect(1, 119679, '\P{^Is_Block=--Counting_Rod_Numerals}', "");
    Expect(0, 119680, '\p{Is_Block=--Counting_Rod_Numerals}', "");
    Expect(1, 119680, '\p{^Is_Block=--Counting_Rod_Numerals}', "");
    Expect(1, 119680, '\P{Is_Block=--Counting_Rod_Numerals}', "");
    Expect(0, 119680, '\P{^Is_Block=--Counting_Rod_Numerals}', "");
    Error('\p{Is_Blk=	COUNTING_Rod/a/}');
    Error('\P{Is_Blk=	COUNTING_Rod/a/}');
    Expect(1, 119679, '\p{Is_Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Is_Blk=countingrod}', "");
    Expect(0, 119679, '\P{Is_Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Is_Blk=countingrod}', "");
    Expect(0, 119680, '\p{Is_Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Is_Blk=countingrod}', "");
    Expect(1, 119680, '\P{Is_Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Is_Blk=countingrod}', "");
    Expect(1, 119679, '\p{Is_Blk= Counting_Rod}', "");
    Expect(0, 119679, '\p{^Is_Blk= Counting_Rod}', "");
    Expect(0, 119679, '\P{Is_Blk= Counting_Rod}', "");
    Expect(1, 119679, '\P{^Is_Blk= Counting_Rod}', "");
    Expect(0, 119680, '\p{Is_Blk= Counting_Rod}', "");
    Expect(1, 119680, '\p{^Is_Blk= Counting_Rod}', "");
    Expect(1, 119680, '\P{Is_Blk= Counting_Rod}', "");
    Expect(0, 119680, '\P{^Is_Blk= Counting_Rod}', "");
    Error('\p{Block=/a/- CUNEIFORM}');
    Error('\P{Block=/a/- CUNEIFORM}');
    Expect(1, 74751, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Block=cuneiform}', "");
    Expect(0, 74751, '\P{Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Block=cuneiform}', "");
    Expect(0, 74752, '\p{Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Block=cuneiform}', "");
    Expect(1, 74752, '\P{Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Block=cuneiform}', "");
    Expect(1, 74751, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block= 	cuneiform}', "");
    Expect(0, 74751, '\p{^Block= 	cuneiform}', "");
    Expect(0, 74751, '\P{Block= 	cuneiform}', "");
    Expect(1, 74751, '\P{^Block= 	cuneiform}', "");
    Expect(0, 74752, '\p{Block= 	cuneiform}', "");
    Expect(1, 74752, '\p{^Block= 	cuneiform}', "");
    Expect(1, 74752, '\P{Block= 	cuneiform}', "");
    Expect(0, 74752, '\P{^Block= 	cuneiform}', "");
    Error('\p{Blk=:=Cuneiform}');
    Error('\P{Blk=:=Cuneiform}');
    Expect(1, 74751, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk=-CUNEIFORM}', "");
    Expect(0, 74751, '\p{^Blk=-CUNEIFORM}', "");
    Expect(0, 74751, '\P{Blk=-CUNEIFORM}', "");
    Expect(1, 74751, '\P{^Blk=-CUNEIFORM}', "");
    Expect(0, 74752, '\p{Blk=-CUNEIFORM}', "");
    Expect(1, 74752, '\p{^Blk=-CUNEIFORM}', "");
    Expect(1, 74752, '\P{Blk=-CUNEIFORM}', "");
    Expect(0, 74752, '\P{^Blk=-CUNEIFORM}', "");
    Error('\p{Is_Block= :=CUNEIFORM}');
    Error('\P{Is_Block= :=CUNEIFORM}');
    Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Block= Cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block= Cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block= Cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block= Cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block= Cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block= Cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block= Cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block= Cuneiform}', "");
    Error('\p{Is_Blk:   	_Cuneiform:=}');
    Error('\P{Is_Blk:   	_Cuneiform:=}');
    Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Blk= CUNEIFORM}', "");
    Expect(0, 74751, '\p{^Is_Blk= CUNEIFORM}', "");
    Expect(0, 74751, '\P{Is_Blk= CUNEIFORM}', "");
    Expect(1, 74751, '\P{^Is_Blk= CUNEIFORM}', "");
    Expect(0, 74752, '\p{Is_Blk= CUNEIFORM}', "");
    Expect(1, 74752, '\p{^Is_Blk= CUNEIFORM}', "");
    Expect(1, 74752, '\P{Is_Blk= CUNEIFORM}', "");
    Expect(0, 74752, '\P{^Is_Blk= CUNEIFORM}', "");
    Error('\p{Block=_/a/cuneiform_numbers_AND_punctuation}');
    Error('\P{Block=_/a/cuneiform_numbers_AND_punctuation}');
    Expect(1, 74879, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(0, 74879, '\p{^Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(0, 74879, '\P{Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(1, 74879, '\P{^Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(0, 74880, '\p{Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(1, 74880, '\p{^Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(1, 74880, '\P{Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Expect(0, 74880, '\P{^Block=	-CUNEIFORM_Numbers_And_PUNCTUATION}', "");
    Error('\p{Blk=- CUNEIFORM_Numbers/a/}');
    Error('\P{Blk=- CUNEIFORM_Numbers/a/}');
    Expect(1, 74879, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=	 cuneiform_NUMBERS}', "");
    Expect(0, 74879, '\p{^Blk=	 cuneiform_NUMBERS}', "");
    Expect(0, 74879, '\P{Blk=	 cuneiform_NUMBERS}', "");
    Expect(1, 74879, '\P{^Blk=	 cuneiform_NUMBERS}', "");
    Expect(0, 74880, '\p{Blk=	 cuneiform_NUMBERS}', "");
    Expect(1, 74880, '\p{^Blk=	 cuneiform_NUMBERS}', "");
    Expect(1, 74880, '\P{Blk=	 cuneiform_NUMBERS}', "");
    Expect(0, 74880, '\P{^Blk=	 cuneiform_NUMBERS}', "");
    Error('\p{Is_Block=	:=cuneiform_numbers_And_punctuation}');
    Error('\P{Is_Block=	:=cuneiform_numbers_And_punctuation}');
    Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(0, 74879, '\p{^Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(0, 74879, '\P{Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(1, 74879, '\P{^Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(0, 74880, '\p{Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(1, 74880, '\p{^Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(1, 74880, '\P{Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Expect(0, 74880, '\P{^Is_Block=_CUNEIFORM_numbers_And_PUNCTUATION}', "");
    Error('\p{Is_Blk=__Cuneiform_Numbers:=}');
    Error('\P{Is_Blk=__Cuneiform_Numbers:=}');
    Expect(1, 74879, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Is_Blk= 	cuneiform_numbers}', "");
    Expect(0, 74879, '\p{^Is_Blk= 	cuneiform_numbers}', "");
    Expect(0, 74879, '\P{Is_Blk= 	cuneiform_numbers}', "");
    Expect(1, 74879, '\P{^Is_Blk= 	cuneiform_numbers}', "");
    Expect(0, 74880, '\p{Is_Blk= 	cuneiform_numbers}', "");
    Expect(1, 74880, '\p{^Is_Blk= 	cuneiform_numbers}', "");
    Expect(1, 74880, '\P{Is_Blk= 	cuneiform_numbers}', "");
    Expect(0, 74880, '\P{^Is_Blk= 	cuneiform_numbers}', "");
    Error('\p{Block= CURRENCY_SYMBOLS:=}');
    Error('\P{Block= CURRENCY_SYMBOLS:=}');
    Expect(1, 8399, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Block=--CURRENCY_symbols}', "");
    Expect(0, 8399, '\p{^Block=--CURRENCY_symbols}', "");
    Expect(0, 8399, '\P{Block=--CURRENCY_symbols}', "");
    Expect(1, 8399, '\P{^Block=--CURRENCY_symbols}', "");
    Expect(0, 8400, '\p{Block=--CURRENCY_symbols}', "");
    Expect(1, 8400, '\p{^Block=--CURRENCY_symbols}', "");
    Expect(1, 8400, '\P{Block=--CURRENCY_symbols}', "");
    Expect(0, 8400, '\P{^Block=--CURRENCY_symbols}', "");
    Error('\p{Blk:   _currency_symbols/a/}');
    Error('\P{Blk:   _currency_symbols/a/}');
    Expect(1, 8399, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=__Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Blk=__Currency_Symbols}', "");
    Expect(0, 8399, '\P{Blk=__Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Blk=__Currency_Symbols}', "");
    Expect(0, 8400, '\p{Blk=__Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Blk=__Currency_Symbols}', "");
    Expect(1, 8400, '\P{Blk=__Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Blk=__Currency_Symbols}', "");
    Error('\p{Is_Block= :=Currency_Symbols}');
    Error('\P{Is_Block= :=Currency_Symbols}');
    Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Block=_currency_Symbols}', "");
    Expect(0, 8399, '\p{^Is_Block=_currency_Symbols}', "");
    Expect(0, 8399, '\P{Is_Block=_currency_Symbols}', "");
    Expect(1, 8399, '\P{^Is_Block=_currency_Symbols}', "");
    Expect(0, 8400, '\p{Is_Block=_currency_Symbols}', "");
    Expect(1, 8400, '\p{^Is_Block=_currency_Symbols}', "");
    Expect(1, 8400, '\P{Is_Block=_currency_Symbols}', "");
    Expect(0, 8400, '\P{^Is_Block=_currency_Symbols}', "");
    Error('\p{Is_Blk=/a/ 	currency_symbols}');
    Error('\P{Is_Blk=/a/ 	currency_symbols}');
    Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Blk= _Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Is_Blk= _Currency_Symbols}', "");
    Expect(0, 8399, '\P{Is_Blk= _Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Is_Blk= _Currency_Symbols}', "");
    Expect(0, 8400, '\p{Is_Blk= _Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Is_Blk= _Currency_Symbols}', "");
    Expect(1, 8400, '\P{Is_Blk= _Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Is_Blk= _Currency_Symbols}', "");
    Error('\p{Block=/a/	 CYPRIOT_syllabary}');
    Error('\P{Block=/a/	 CYPRIOT_syllabary}');
    Expect(1, 67647, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Block= cypriot_SYLLABARY}', "");
    Expect(0, 67647, '\p{^Block= cypriot_SYLLABARY}', "");
    Expect(0, 67647, '\P{Block= cypriot_SYLLABARY}', "");
    Expect(1, 67647, '\P{^Block= cypriot_SYLLABARY}', "");
    Expect(0, 67648, '\p{Block= cypriot_SYLLABARY}', "");
    Expect(1, 67648, '\p{^Block= cypriot_SYLLABARY}', "");
    Expect(1, 67648, '\P{Block= cypriot_SYLLABARY}', "");
    Expect(0, 67648, '\P{^Block= cypriot_SYLLABARY}', "");
    Error('\p{Blk=/a/-	Cypriot_syllabary}');
    Error('\P{Blk=/a/-	Cypriot_syllabary}');
    Expect(1, 67647, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk= Cypriot_syllabary}', "");
    Expect(0, 67647, '\p{^Blk= Cypriot_syllabary}', "");
    Expect(0, 67647, '\P{Blk= Cypriot_syllabary}', "");
    Expect(1, 67647, '\P{^Blk= Cypriot_syllabary}', "");
    Expect(0, 67648, '\p{Blk= Cypriot_syllabary}', "");
    Expect(1, 67648, '\p{^Blk= Cypriot_syllabary}', "");
    Expect(1, 67648, '\P{Blk= Cypriot_syllabary}', "");
    Expect(0, 67648, '\P{^Blk= Cypriot_syllabary}', "");
    Error('\p{Is_Block=:= Cypriot_Syllabary}');
    Error('\P{Is_Block=:= Cypriot_Syllabary}');
    Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Block=- Cypriot_syllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=- Cypriot_syllabary}', "");
    Expect(0, 67647, '\P{Is_Block=- Cypriot_syllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=- Cypriot_syllabary}', "");
    Expect(0, 67648, '\p{Is_Block=- Cypriot_syllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=- Cypriot_syllabary}', "");
    Expect(1, 67648, '\P{Is_Block=- Cypriot_syllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=- Cypriot_syllabary}', "");
    Error('\p{Is_Blk=:=	Cypriot_syllabary}');
    Error('\P{Is_Blk=:=	Cypriot_syllabary}');
    Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=_ CYPRIOT_Syllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=_ CYPRIOT_Syllabary}', "");
    Error('\p{Block=:=	CYRILLIC}');
    Error('\P{Block=:=	CYRILLIC}');
    Expect(1, 1279, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Block=cyrillic}', "");
    Expect(0, 1279, '\P{Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Block=cyrillic}', "");
    Expect(0, 1280, '\p{Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Block=cyrillic}', "");
    Expect(1, 1280, '\P{Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Block=cyrillic}', "");
    Expect(1, 1279, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block:   	 Cyrillic}', "");
    Expect(0, 1279, '\p{^Block:   	 Cyrillic}', "");
    Expect(0, 1279, '\P{Block:   	 Cyrillic}', "");
    Expect(1, 1279, '\P{^Block:   	 Cyrillic}', "");
    Expect(0, 1280, '\p{Block:   	 Cyrillic}', "");
    Expect(1, 1280, '\p{^Block:   	 Cyrillic}', "");
    Expect(1, 1280, '\P{Block:   	 Cyrillic}', "");
    Expect(0, 1280, '\P{^Block:   	 Cyrillic}', "");
    Error('\p{Blk: /a/	-cyrillic}');
    Error('\P{Blk: /a/	-cyrillic}');
    Expect(1, 1279, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk= _cyrillic}', "");
    Expect(0, 1279, '\p{^Blk= _cyrillic}', "");
    Expect(0, 1279, '\P{Blk= _cyrillic}', "");
    Expect(1, 1279, '\P{^Blk= _cyrillic}', "");
    Expect(0, 1280, '\p{Blk= _cyrillic}', "");
    Expect(1, 1280, '\p{^Blk= _cyrillic}', "");
    Expect(1, 1280, '\P{Blk= _cyrillic}', "");
    Expect(0, 1280, '\P{^Blk= _cyrillic}', "");
    Error('\p{Is_Block=cyrillic/a/}');
    Error('\P{Is_Block=cyrillic/a/}');
    Expect(1, 1279, '\p{Is_Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Block=-Cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block=-Cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block=-Cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block=-Cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block=-Cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block=-Cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block=-Cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block=-Cyrillic}', "");
    Error('\p{Is_Blk= Cyrillic/a/}');
    Error('\P{Is_Blk= Cyrillic/a/}');
    Expect(1, 1279, '\p{Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Blk=	 CYRILLIC}', "");
    Expect(0, 1279, '\p{^Is_Blk=	 CYRILLIC}', "");
    Expect(0, 1279, '\P{Is_Blk=	 CYRILLIC}', "");
    Expect(1, 1279, '\P{^Is_Blk=	 CYRILLIC}', "");
    Expect(0, 1280, '\p{Is_Blk=	 CYRILLIC}', "");
    Expect(1, 1280, '\p{^Is_Blk=	 CYRILLIC}', "");
    Expect(1, 1280, '\P{Is_Blk=	 CYRILLIC}', "");
    Expect(0, 1280, '\P{^Is_Blk=	 CYRILLIC}', "");
    Error('\p{Block=-:=CYRILLIC_extended_A}');
    Error('\P{Block=-:=CYRILLIC_extended_A}');
    Expect(1, 11775, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(0, 11776, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(0, 11776, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(1, 11775, '\p{Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(0, 11775, '\p{^Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(0, 11775, '\P{Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(1, 11775, '\P{^Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(0, 11776, '\p{Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(1, 11776, '\p{^Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(1, 11776, '\P{Block=	 Cyrillic_EXTENDED_A}', "");
    Expect(0, 11776, '\P{^Block=	 Cyrillic_EXTENDED_A}', "");
    Error('\p{Blk=--cyrillic_ext_A/a/}');
    Error('\P{Blk=--cyrillic_ext_A/a/}');
    Expect(1, 11775, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(1, 11775, '\p{Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(1, 11775, '\p{Blk=_ Cyrillic_Ext_A}', "");
    Expect(0, 11775, '\p{^Blk=_ Cyrillic_Ext_A}', "");
    Expect(0, 11775, '\P{Blk=_ Cyrillic_Ext_A}', "");
    Expect(1, 11775, '\P{^Blk=_ Cyrillic_Ext_A}', "");
    Expect(0, 11776, '\p{Blk=_ Cyrillic_Ext_A}', "");
    Expect(1, 11776, '\p{^Blk=_ Cyrillic_Ext_A}', "");
    Expect(1, 11776, '\P{Blk=_ Cyrillic_Ext_A}', "");
    Expect(0, 11776, '\P{^Blk=_ Cyrillic_Ext_A}', "");
    Error('\p{Is_Block:	:=-	CYRILLIC_Extended_A}');
    Error('\P{Is_Block:	:=-	CYRILLIC_Extended_A}');
    Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Is_Block= 	Cyrillic_extended_A}', "");
    Expect(0, 11775, '\p{^Is_Block= 	Cyrillic_extended_A}', "");
    Expect(0, 11775, '\P{Is_Block= 	Cyrillic_extended_A}', "");
    Expect(1, 11775, '\P{^Is_Block= 	Cyrillic_extended_A}', "");
    Expect(0, 11776, '\p{Is_Block= 	Cyrillic_extended_A}', "");
    Expect(1, 11776, '\p{^Is_Block= 	Cyrillic_extended_A}', "");
    Expect(1, 11776, '\P{Is_Block= 	Cyrillic_extended_A}', "");
    Expect(0, 11776, '\P{^Is_Block= 	Cyrillic_extended_A}', "");
    Error('\p{Is_Blk:/a/_cyrillic_Ext_A}');
    Error('\P{Is_Blk:/a/_cyrillic_Ext_A}');
    Expect(1, 11775, '\p{Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Is_Blk= cyrillic_ext_A}', "");
    Expect(0, 11775, '\p{^Is_Blk= cyrillic_ext_A}', "");
    Expect(0, 11775, '\P{Is_Blk= cyrillic_ext_A}', "");
    Expect(1, 11775, '\P{^Is_Blk= cyrillic_ext_A}', "");
    Expect(0, 11776, '\p{Is_Blk= cyrillic_ext_A}', "");
    Expect(1, 11776, '\p{^Is_Blk= cyrillic_ext_A}', "");
    Expect(1, 11776, '\P{Is_Blk= cyrillic_ext_A}', "");
    Expect(0, 11776, '\P{^Is_Blk= cyrillic_ext_A}', "");
    Error('\p{Block=	/a/cyrillic_Extended_b}');
    Error('\P{Block=	/a/cyrillic_Extended_b}');
    Expect(1, 42655, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(0, 42656, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(1, 42655, '\p{Block:cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Block:cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Block:cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Block:cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Block:cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Block:cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Block:cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Block:cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(0, 42656, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(1, 42655, '\p{Block=__cyrillic_EXTENDED_B}', "");
    Expect(0, 42655, '\p{^Block=__cyrillic_EXTENDED_B}', "");
    Expect(0, 42655, '\P{Block=__cyrillic_EXTENDED_B}', "");
    Expect(1, 42655, '\P{^Block=__cyrillic_EXTENDED_B}', "");
    Expect(0, 42656, '\p{Block=__cyrillic_EXTENDED_B}', "");
    Expect(1, 42656, '\p{^Block=__cyrillic_EXTENDED_B}', "");
    Expect(1, 42656, '\P{Block=__cyrillic_EXTENDED_B}', "");
    Expect(0, 42656, '\P{^Block=__cyrillic_EXTENDED_B}', "");
    Error('\p{Blk=_:=Cyrillic_Ext_B}');
    Error('\P{Blk=_:=Cyrillic_Ext_B}');
    Expect(1, 42655, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(1, 42655, '\p{Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(1, 42655, '\p{Blk= -cyrillic_EXT_B}', "");
    Expect(0, 42655, '\p{^Blk= -cyrillic_EXT_B}', "");
    Expect(0, 42655, '\P{Blk= -cyrillic_EXT_B}', "");
    Expect(1, 42655, '\P{^Blk= -cyrillic_EXT_B}', "");
    Expect(0, 42656, '\p{Blk= -cyrillic_EXT_B}', "");
    Expect(1, 42656, '\p{^Blk= -cyrillic_EXT_B}', "");
    Expect(1, 42656, '\P{Blk= -cyrillic_EXT_B}', "");
    Expect(0, 42656, '\P{^Blk= -cyrillic_EXT_B}', "");
    Error('\p{Is_Block= CYRILLIC_EXTENDED_B/a/}');
    Error('\P{Is_Block= CYRILLIC_EXTENDED_B/a/}');
    Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(0, 42655, '\p{^Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(0, 42655, '\P{Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(1, 42655, '\P{^Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(0, 42656, '\p{Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(1, 42656, '\p{^Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(1, 42656, '\P{Is_Block:   _-Cyrillic_Extended_B}', "");
    Expect(0, 42656, '\P{^Is_Block:   _-Cyrillic_Extended_B}', "");
    Error('\p{Is_Blk=--Cyrillic_ext_B/a/}');
    Error('\P{Is_Blk=--Cyrillic_ext_B/a/}');
    Expect(1, 42655, '\p{Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(0, 42655, '\p{^Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(0, 42655, '\P{Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(1, 42655, '\P{^Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(0, 42656, '\p{Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(1, 42656, '\p{^Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(1, 42656, '\P{Is_Blk=__CYRILLIC_EXT_B}', "");
    Expect(0, 42656, '\P{^Is_Blk=__CYRILLIC_EXT_B}', "");
    Error('\p{Block=/a/	 cyrillic_Extended_C}');
    Error('\P{Block=/a/	 cyrillic_Extended_C}');
    Expect(1, 7311, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(0, 7312, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(1, 7311, '\p{Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(0, 7312, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(1, 7311, '\p{Block=_-CYRILLIC_Extended_C}', "");
    Expect(0, 7311, '\p{^Block=_-CYRILLIC_Extended_C}', "");
    Expect(0, 7311, '\P{Block=_-CYRILLIC_Extended_C}', "");
    Expect(1, 7311, '\P{^Block=_-CYRILLIC_Extended_C}', "");
    Expect(0, 7312, '\p{Block=_-CYRILLIC_Extended_C}', "");
    Expect(1, 7312, '\p{^Block=_-CYRILLIC_Extended_C}', "");
    Expect(1, 7312, '\P{Block=_-CYRILLIC_Extended_C}', "");
    Expect(0, 7312, '\P{^Block=_-CYRILLIC_Extended_C}', "");
    Error('\p{Blk=:=	 Cyrillic_EXT_C}');
    Error('\P{Blk=:=	 Cyrillic_EXT_C}');
    Expect(1, 7311, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(1, 7311, '\p{Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(1, 7311, '\p{Blk:   - CYRILLIC_Ext_C}', "");
    Expect(0, 7311, '\p{^Blk:   - CYRILLIC_Ext_C}', "");
    Expect(0, 7311, '\P{Blk:   - CYRILLIC_Ext_C}', "");
    Expect(1, 7311, '\P{^Blk:   - CYRILLIC_Ext_C}', "");
    Expect(0, 7312, '\p{Blk:   - CYRILLIC_Ext_C}', "");
    Expect(1, 7312, '\p{^Blk:   - CYRILLIC_Ext_C}', "");
    Expect(1, 7312, '\P{Blk:   - CYRILLIC_Ext_C}', "");
    Expect(0, 7312, '\P{^Blk:   - CYRILLIC_Ext_C}', "");
    Error('\p{Is_Block=__CYRILLIC_Extended_C:=}');
    Error('\P{Is_Block=__CYRILLIC_Extended_C:=}');
    Expect(1, 7311, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Is_Block=	-Cyrillic_extended_C}', "");
    Expect(0, 7311, '\p{^Is_Block=	-Cyrillic_extended_C}', "");
    Expect(0, 7311, '\P{Is_Block=	-Cyrillic_extended_C}', "");
    Expect(1, 7311, '\P{^Is_Block=	-Cyrillic_extended_C}', "");
    Expect(0, 7312, '\p{Is_Block=	-Cyrillic_extended_C}', "");
    Expect(1, 7312, '\p{^Is_Block=	-Cyrillic_extended_C}', "");
    Expect(1, 7312, '\P{Is_Block=	-Cyrillic_extended_C}', "");
    Expect(0, 7312, '\P{^Is_Block=	-Cyrillic_extended_C}', "");
    Error('\p{Is_Blk: /a/-Cyrillic_Ext_C}');
    Error('\P{Is_Blk: /a/-Cyrillic_Ext_C}');
    Expect(1, 7311, '\p{Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(0, 7311, '\p{^Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(0, 7311, '\P{Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(1, 7311, '\P{^Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(0, 7312, '\p{Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(1, 7312, '\p{^Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(1, 7312, '\P{Is_Blk=-_cyrillic_Ext_C}', "");
    Expect(0, 7312, '\P{^Is_Blk=-_cyrillic_Ext_C}', "");
    Error('\p{Block=:= cyrillic_supplement}');
    Error('\P{Block=:= cyrillic_supplement}');
    Expect(1, 1327, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(1, 1327, '\p{Block:_-Cyrillic_Supplement}', "");
    Expect(0, 1327, '\p{^Block:_-Cyrillic_Supplement}', "");
    Expect(0, 1327, '\P{Block:_-Cyrillic_Supplement}', "");
    Expect(1, 1327, '\P{^Block:_-Cyrillic_Supplement}', "");
    Expect(0, 1328, '\p{Block:_-Cyrillic_Supplement}', "");
    Expect(1, 1328, '\p{^Block:_-Cyrillic_Supplement}', "");
    Expect(1, 1328, '\P{Block:_-Cyrillic_Supplement}', "");
    Expect(0, 1328, '\P{^Block:_-Cyrillic_Supplement}', "");
    Error('\p{Blk=_CYRILLIC_Sup/a/}');
    Error('\P{Blk=_CYRILLIC_Sup/a/}');
    Expect(1, 1327, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(1, 1327, '\p{Blk=cyrillicsup}', "");
    Expect(0, 1327, '\p{^Blk=cyrillicsup}', "");
    Expect(0, 1327, '\P{Blk=cyrillicsup}', "");
    Expect(1, 1327, '\P{^Blk=cyrillicsup}', "");
    Expect(0, 1328, '\p{Blk=cyrillicsup}', "");
    Expect(1, 1328, '\p{^Blk=cyrillicsup}', "");
    Expect(1, 1328, '\P{Blk=cyrillicsup}', "");
    Expect(0, 1328, '\P{^Blk=cyrillicsup}', "");
    Expect(1, 1327, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(1, 1327, '\p{Blk=	_Cyrillic_Sup}', "");
    Expect(0, 1327, '\p{^Blk=	_Cyrillic_Sup}', "");
    Expect(0, 1327, '\P{Blk=	_Cyrillic_Sup}', "");
    Expect(1, 1327, '\P{^Blk=	_Cyrillic_Sup}', "");
    Expect(0, 1328, '\p{Blk=	_Cyrillic_Sup}', "");
    Expect(1, 1328, '\p{^Blk=	_Cyrillic_Sup}', "");
    Expect(1, 1328, '\P{Blk=	_Cyrillic_Sup}', "");
    Expect(0, 1328, '\P{^Blk=	_Cyrillic_Sup}', "");
    Error('\p{Is_Block: 	 cyrillic_Supplementary:=}');
    Error('\P{Is_Block: 	 cyrillic_Supplementary:=}');
    Expect(1, 1327, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\p{Is_Block:--Cyrillic_Supplementary}', "");
    Expect(0, 1327, '\p{^Is_Block:--Cyrillic_Supplementary}', "");
    Expect(0, 1327, '\P{Is_Block:--Cyrillic_Supplementary}', "");
    Expect(1, 1327, '\P{^Is_Block:--Cyrillic_Supplementary}', "");
    Expect(0, 1328, '\p{Is_Block:--Cyrillic_Supplementary}', "");
    Expect(1, 1328, '\p{^Is_Block:--Cyrillic_Supplementary}', "");
    Expect(1, 1328, '\P{Is_Block:--Cyrillic_Supplementary}', "");
    Expect(0, 1328, '\P{^Is_Block:--Cyrillic_Supplementary}', "");
    Error('\p{Is_Blk:   :=_Cyrillic_SUPPLEMENT}');
    Error('\P{Is_Blk:   :=_Cyrillic_SUPPLEMENT}');
    Expect(1, 1327, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Is_Blk=	-cyrillic_Supplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=	-cyrillic_Supplement}', "");
    Expect(0, 1327, '\P{Is_Blk=	-cyrillic_Supplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=	-cyrillic_Supplement}', "");
    Expect(0, 1328, '\p{Is_Blk=	-cyrillic_Supplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=	-cyrillic_Supplement}', "");
    Expect(1, 1328, '\P{Is_Blk=	-cyrillic_Supplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=	-cyrillic_Supplement}', "");
    Error('\p{Block= _DESERET/a/}');
    Error('\P{Block= _DESERET/a/}');
    Expect(1, 66639, '\p{Block=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=deseret}', "");
    Expect(0, 66639, '\p{^Block=deseret}', "");
    Expect(0, 66639, '\P{Block=deseret}', "");
    Expect(1, 66639, '\P{^Block=deseret}', "");
    Expect(0, 66640, '\p{Block=deseret}', "");
    Expect(1, 66640, '\p{^Block=deseret}', "");
    Expect(1, 66640, '\P{Block=deseret}', "");
    Expect(0, 66640, '\P{^Block=deseret}', "");
    Expect(1, 66639, '\p{Block=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=		deseret}', "");
    Expect(0, 66639, '\p{^Block=		deseret}', "");
    Expect(0, 66639, '\P{Block=		deseret}', "");
    Expect(1, 66639, '\P{^Block=		deseret}', "");
    Expect(0, 66640, '\p{Block=		deseret}', "");
    Expect(1, 66640, '\p{^Block=		deseret}', "");
    Expect(1, 66640, '\P{Block=		deseret}', "");
    Expect(0, 66640, '\P{^Block=		deseret}', "");
    Error('\p{Blk= /a/Deseret}');
    Error('\P{Blk= /a/Deseret}');
    Expect(1, 66639, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=deseret}', "");
    Expect(0, 66639, '\p{^Blk=deseret}', "");
    Expect(0, 66639, '\P{Blk=deseret}', "");
    Expect(1, 66639, '\P{^Blk=deseret}', "");
    Expect(0, 66640, '\p{Blk=deseret}', "");
    Expect(1, 66640, '\p{^Blk=deseret}', "");
    Expect(1, 66640, '\P{Blk=deseret}', "");
    Expect(0, 66640, '\P{^Blk=deseret}', "");
    Expect(1, 66639, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=_	Deseret}', "");
    Expect(0, 66639, '\p{^Blk=_	Deseret}', "");
    Expect(0, 66639, '\P{Blk=_	Deseret}', "");
    Expect(1, 66639, '\P{^Blk=_	Deseret}', "");
    Expect(0, 66640, '\p{Blk=_	Deseret}', "");
    Expect(1, 66640, '\p{^Blk=_	Deseret}', "");
    Expect(1, 66640, '\P{Blk=_	Deseret}', "");
    Expect(0, 66640, '\P{^Blk=_	Deseret}', "");
    Error('\p{Is_Block=:=DESERET}');
    Error('\P{Is_Block=:=DESERET}');
    Expect(1, 66639, '\p{Is_Block=deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=deseret}', "");
    Expect(0, 66639, '\P{Is_Block=deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=deseret}', "");
    Expect(0, 66640, '\p{Is_Block=deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=deseret}', "");
    Expect(1, 66640, '\P{Is_Block=deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=deseret}', "");
    Expect(1, 66639, '\p{Is_Block=_	Deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=_	Deseret}', "");
    Expect(0, 66639, '\P{Is_Block=_	Deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=_	Deseret}', "");
    Expect(0, 66640, '\p{Is_Block=_	Deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=_	Deseret}', "");
    Expect(1, 66640, '\P{Is_Block=_	Deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=_	Deseret}', "");
    Error('\p{Is_Blk=/a/_ Deseret}');
    Error('\P{Is_Blk=/a/_ Deseret}');
    Expect(1, 66639, '\p{Is_Blk=deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=deseret}', "");
    Expect(1, 66639, '\p{Is_Blk=__Deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=__Deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=__Deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=__Deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=__Deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=__Deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=__Deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=__Deseret}', "");
    Error('\p{Block=/a/_Devanagari}');
    Error('\P{Block=/a/_Devanagari}');
    Expect(1, 2431, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block:devanagari}', "");
    Expect(0, 2431, '\p{^Block:devanagari}', "");
    Expect(0, 2431, '\P{Block:devanagari}', "");
    Expect(1, 2431, '\P{^Block:devanagari}', "");
    Expect(0, 2432, '\p{Block:devanagari}', "");
    Expect(1, 2432, '\p{^Block:devanagari}', "");
    Expect(1, 2432, '\P{Block:devanagari}', "");
    Expect(0, 2432, '\P{^Block:devanagari}', "");
    Expect(1, 2431, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block=_DEVANAGARI}', "");
    Expect(0, 2431, '\p{^Block=_DEVANAGARI}', "");
    Expect(0, 2431, '\P{Block=_DEVANAGARI}', "");
    Expect(1, 2431, '\P{^Block=_DEVANAGARI}', "");
    Expect(0, 2432, '\p{Block=_DEVANAGARI}', "");
    Expect(1, 2432, '\p{^Block=_DEVANAGARI}', "");
    Expect(1, 2432, '\P{Block=_DEVANAGARI}', "");
    Expect(0, 2432, '\P{^Block=_DEVANAGARI}', "");
    Error('\p{Blk=:=devanagari}');
    Error('\P{Blk=:=devanagari}');
    Expect(1, 2431, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Blk=devanagari}', "");
    Expect(0, 2431, '\P{Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Blk=devanagari}', "");
    Expect(0, 2432, '\p{Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Blk=devanagari}', "");
    Expect(1, 2432, '\P{Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Blk=devanagari}', "");
    Expect(1, 2431, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk=Devanagari}', "");
    Expect(0, 2431, '\p{^Blk=Devanagari}', "");
    Expect(0, 2431, '\P{Blk=Devanagari}', "");
    Expect(1, 2431, '\P{^Blk=Devanagari}', "");
    Expect(0, 2432, '\p{Blk=Devanagari}', "");
    Expect(1, 2432, '\p{^Blk=Devanagari}', "");
    Expect(1, 2432, '\P{Blk=Devanagari}', "");
    Expect(0, 2432, '\P{^Blk=Devanagari}', "");
    Error('\p{Is_Block=_	Devanagari:=}');
    Error('\P{Is_Block=_	Devanagari:=}');
    Expect(1, 2431, '\p{Is_Block=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=devanagari}', "");
    Expect(1, 2431, '\p{Is_Block=	 DEVANAGARI}', "");
    Expect(0, 2431, '\p{^Is_Block=	 DEVANAGARI}', "");
    Expect(0, 2431, '\P{Is_Block=	 DEVANAGARI}', "");
    Expect(1, 2431, '\P{^Is_Block=	 DEVANAGARI}', "");
    Expect(0, 2432, '\p{Is_Block=	 DEVANAGARI}', "");
    Expect(1, 2432, '\p{^Is_Block=	 DEVANAGARI}', "");
    Expect(1, 2432, '\P{Is_Block=	 DEVANAGARI}', "");
    Expect(0, 2432, '\P{^Is_Block=	 DEVANAGARI}', "");
    Error('\p{Is_Blk: :=Devanagari}');
    Error('\P{Is_Blk: :=Devanagari}');
    Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=devanagari}', "");
    Expect(1, 2431, '\p{Is_Blk:	Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk:	Devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk:	Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk:	Devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk:	Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk:	Devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk:	Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk:	Devanagari}', "");
    Error('\p{Block= :=DEVANAGARI_Extended}');
    Error('\P{Block= :=DEVANAGARI_Extended}');
    Expect(1, 43263, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(1, 43263, '\p{Block:   devanagariextended}', "");
    Expect(0, 43263, '\p{^Block:   devanagariextended}', "");
    Expect(0, 43263, '\P{Block:   devanagariextended}', "");
    Expect(1, 43263, '\P{^Block:   devanagariextended}', "");
    Expect(0, 43264, '\p{Block:   devanagariextended}', "");
    Expect(1, 43264, '\p{^Block:   devanagariextended}', "");
    Expect(1, 43264, '\P{Block:   devanagariextended}', "");
    Expect(0, 43264, '\P{^Block:   devanagariextended}', "");
    Expect(1, 43263, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(1, 43263, '\p{Block=-devanagari_Extended}', "");
    Expect(0, 43263, '\p{^Block=-devanagari_Extended}', "");
    Expect(0, 43263, '\P{Block=-devanagari_Extended}', "");
    Expect(1, 43263, '\P{^Block=-devanagari_Extended}', "");
    Expect(0, 43264, '\p{Block=-devanagari_Extended}', "");
    Expect(1, 43264, '\p{^Block=-devanagari_Extended}', "");
    Expect(1, 43264, '\P{Block=-devanagari_Extended}', "");
    Expect(0, 43264, '\P{^Block=-devanagari_Extended}', "");
    Error('\p{Blk=:= Devanagari_EXT}');
    Error('\P{Blk=:= Devanagari_EXT}');
    Expect(1, 43263, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(1, 43263, '\p{Blk:	devanagariext}', "");
    Expect(0, 43263, '\p{^Blk:	devanagariext}', "");
    Expect(0, 43263, '\P{Blk:	devanagariext}', "");
    Expect(1, 43263, '\P{^Blk:	devanagariext}', "");
    Expect(0, 43264, '\p{Blk:	devanagariext}', "");
    Expect(1, 43264, '\p{^Blk:	devanagariext}', "");
    Expect(1, 43264, '\P{Blk:	devanagariext}', "");
    Expect(0, 43264, '\P{^Blk:	devanagariext}', "");
    Expect(1, 43263, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(1, 43263, '\p{Blk=-devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Blk=-devanagari_Ext}', "");
    Expect(0, 43263, '\P{Blk=-devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Blk=-devanagari_Ext}', "");
    Expect(0, 43264, '\p{Blk=-devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Blk=-devanagari_Ext}', "");
    Expect(1, 43264, '\P{Blk=-devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Blk=-devanagari_Ext}', "");
    Error('\p{Is_Block=/a/-Devanagari_Extended}');
    Error('\P{Is_Block=/a/-Devanagari_Extended}');
    Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(0, 43263, '\p{^Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(0, 43263, '\P{Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(1, 43263, '\P{^Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(0, 43264, '\p{Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(1, 43264, '\p{^Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(1, 43264, '\P{Is_Block=-_Devanagari_EXTENDED}', "");
    Expect(0, 43264, '\P{^Is_Block=-_Devanagari_EXTENDED}', "");
    Error('\p{Is_Blk=/a/- Devanagari_EXT}');
    Error('\P{Is_Blk=/a/- Devanagari_EXT}');
    Expect(1, 43263, '\p{Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Is_Blk=-	devanagari_ext}', "");
    Expect(0, 43263, '\p{^Is_Blk=-	devanagari_ext}', "");
    Expect(0, 43263, '\P{Is_Blk=-	devanagari_ext}', "");
    Expect(1, 43263, '\P{^Is_Blk=-	devanagari_ext}', "");
    Expect(0, 43264, '\p{Is_Blk=-	devanagari_ext}', "");
    Expect(1, 43264, '\p{^Is_Blk=-	devanagari_ext}', "");
    Expect(1, 43264, '\P{Is_Blk=-	devanagari_ext}', "");
    Expect(0, 43264, '\P{^Is_Blk=-	devanagari_ext}', "");
    Error('\p{Block=:=Combining_DIACRITICAL_Marks}');
    Error('\P{Block=:=Combining_DIACRITICAL_Marks}');
    Expect(1, 879, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(0, 880, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(0, 880, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(1, 879, '\p{Block=-_combining_Diacritical_marks}', "");
    Expect(0, 879, '\p{^Block=-_combining_Diacritical_marks}', "");
    Expect(0, 879, '\P{Block=-_combining_Diacritical_marks}', "");
    Expect(1, 879, '\P{^Block=-_combining_Diacritical_marks}', "");
    Expect(0, 880, '\p{Block=-_combining_Diacritical_marks}', "");
    Expect(1, 880, '\p{^Block=-_combining_Diacritical_marks}', "");
    Expect(1, 880, '\P{Block=-_combining_Diacritical_marks}', "");
    Expect(0, 880, '\P{^Block=-_combining_Diacritical_marks}', "");
    Error('\p{Blk=_/a/Diacriticals}');
    Error('\P{Blk=_/a/Diacriticals}');
    Expect(1, 879, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Blk=diacriticals}', "");
    Expect(0, 879, '\P{Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Blk=diacriticals}', "");
    Expect(0, 880, '\p{Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Blk=diacriticals}', "");
    Expect(1, 880, '\P{Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Blk=diacriticals}', "");
    Expect(1, 879, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk= DIACRITICALS}', "");
    Expect(0, 879, '\p{^Blk= DIACRITICALS}', "");
    Expect(0, 879, '\P{Blk= DIACRITICALS}', "");
    Expect(1, 879, '\P{^Blk= DIACRITICALS}', "");
    Expect(0, 880, '\p{Blk= DIACRITICALS}', "");
    Expect(1, 880, '\p{^Blk= DIACRITICALS}', "");
    Expect(1, 880, '\P{Blk= DIACRITICALS}', "");
    Expect(0, 880, '\P{^Blk= DIACRITICALS}', "");
    Error('\p{Is_Block=:=_combining_Diacritical_MARKS}');
    Error('\P{Is_Block=:=_combining_Diacritical_MARKS}');
    Expect(1, 879, '\p{Is_Block:combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Is_Block:combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Is_Block:combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Is_Block:combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Is_Block:combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Is_Block:combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Is_Block:combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Is_Block:combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(0, 879, '\p{^Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(0, 879, '\P{Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(1, 879, '\P{^Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(0, 880, '\p{Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(1, 880, '\p{^Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(1, 880, '\P{Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Expect(0, 880, '\P{^Is_Block=--COMBINING_DIACRITICAL_Marks}', "");
    Error('\p{Is_Blk: :=_Diacriticals}');
    Error('\P{Is_Blk: :=_Diacriticals}');
    Expect(1, 879, '\p{Is_Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk=diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk=diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk=diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk=diacriticals}', "");
    Expect(1, 879, '\p{Is_Blk=  Diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk=  Diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk=  Diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk=  Diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk=  Diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk=  Diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk=  Diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk=  Diacriticals}', "");
    Error('\p{Block= Combining_diacritical_Marks_EXTENDED/a/}');
    Error('\P{Block= Combining_diacritical_Marks_EXTENDED/a/}');
    Expect(1, 6911, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(1, 6911, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(1, 6911, '\p{Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(0, 6911, '\p{^Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(0, 6911, '\P{Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(1, 6911, '\P{^Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(0, 6912, '\p{Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(1, 6912, '\p{^Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(1, 6912, '\P{Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Expect(0, 6912, '\P{^Block:   -	COMBINING_diacritical_Marks_EXTENDED}', "");
    Error('\p{Blk=-Diacriticals_Ext/a/}');
    Error('\P{Blk=-Diacriticals_Ext/a/}');
    Expect(1, 6911, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(1, 6911, '\p{Blk:   diacriticalsext}', "");
    Expect(0, 6911, '\p{^Blk:   diacriticalsext}', "");
    Expect(0, 6911, '\P{Blk:   diacriticalsext}', "");
    Expect(1, 6911, '\P{^Blk:   diacriticalsext}', "");
    Expect(0, 6912, '\p{Blk:   diacriticalsext}', "");
    Expect(1, 6912, '\p{^Blk:   diacriticalsext}', "");
    Expect(1, 6912, '\P{Blk:   diacriticalsext}', "");
    Expect(0, 6912, '\P{^Blk:   diacriticalsext}', "");
    Expect(1, 6911, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(1, 6911, '\p{Blk=_Diacriticals_Ext}', "");
    Expect(0, 6911, '\p{^Blk=_Diacriticals_Ext}', "");
    Expect(0, 6911, '\P{Blk=_Diacriticals_Ext}', "");
    Expect(1, 6911, '\P{^Blk=_Diacriticals_Ext}', "");
    Expect(0, 6912, '\p{Blk=_Diacriticals_Ext}', "");
    Expect(1, 6912, '\p{^Blk=_Diacriticals_Ext}', "");
    Expect(1, 6912, '\P{Blk=_Diacriticals_Ext}', "");
    Expect(0, 6912, '\P{^Blk=_Diacriticals_Ext}', "");
    Error('\p{Is_Block=-:=COMBINING_diacritical_MARKS_extended}');
    Error('\P{Is_Block=-:=COMBINING_diacritical_MARKS_extended}');
    Expect(1, 6911, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(0, 6911, '\p{^Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(0, 6911, '\P{Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(1, 6911, '\P{^Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(0, 6912, '\p{Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(1, 6912, '\p{^Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(1, 6912, '\P{Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Expect(0, 6912, '\P{^Is_Block= 	combining_diacritical_MARKS_extended}', "");
    Error('\p{Is_Blk=_-Diacriticals_EXT/a/}');
    Error('\P{Is_Blk=_-Diacriticals_EXT/a/}');
    Expect(1, 6911, '\p{Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(0, 6911, '\p{^Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(0, 6911, '\P{Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(1, 6911, '\P{^Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(0, 6912, '\p{Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(1, 6912, '\p{^Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(1, 6912, '\P{Is_Blk= _DIACRITICALS_EXT}', "");
    Expect(0, 6912, '\P{^Is_Blk= _DIACRITICALS_EXT}', "");
    Error('\p{Block:	:= _COMBINING_Diacritical_marks_FOR_Symbols}');
    Error('\P{Block:	:= _COMBINING_Diacritical_marks_FOR_Symbols}');
    Expect(1, 8447, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8447, '\p{^Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8447, '\P{Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(1, 8447, '\P{^Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8448, '\p{Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(1, 8448, '\p{^Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(1, 8448, '\P{Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8448, '\P{^Block=- combining_diacritical_Marks_FOR_SYMBOLS}', "");
    Error('\p{Blk: /a/--Diacriticals_For_Symbols}');
    Error('\P{Blk: /a/--Diacriticals_For_Symbols}');
    Expect(1, 8447, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Blk= 	Diacriticals_For_Symbols}', "");
    Expect(0, 8447, '\p{^Blk= 	Diacriticals_For_Symbols}', "");
    Expect(0, 8447, '\P{Blk= 	Diacriticals_For_Symbols}', "");
    Expect(1, 8447, '\P{^Blk= 	Diacriticals_For_Symbols}', "");
    Expect(0, 8448, '\p{Blk= 	Diacriticals_For_Symbols}', "");
    Expect(1, 8448, '\p{^Blk= 	Diacriticals_For_Symbols}', "");
    Expect(1, 8448, '\P{Blk= 	Diacriticals_For_Symbols}', "");
    Expect(0, 8448, '\P{^Blk= 	Diacriticals_For_Symbols}', "");
    Error('\p{Is_Block=_:=COMBINING_marks_For_Symbols}');
    Error('\P{Is_Block=_:=COMBINING_marks_For_Symbols}');
    Expect(1, 8447, '\p{Is_Block:combiningmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Block:combiningmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Block:combiningmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Block:combiningmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Block:combiningmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Block:combiningmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Block:combiningmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Block:combiningmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(0, 8447, '\p{^Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(0, 8447, '\P{Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(1, 8447, '\P{^Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(0, 8448, '\p{Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(1, 8448, '\p{^Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(1, 8448, '\P{Is_Block=-Combining_marks_FOR_symbols}', "");
    Expect(0, 8448, '\P{^Is_Block=-Combining_marks_FOR_symbols}', "");
    Error('\p{Is_Blk=_combining_DIACRITICAL_Marks_For_Symbols:=}');
    Error('\P{Is_Blk=_combining_DIACRITICAL_Marks_For_Symbols:=}');
    Expect(1, 8447, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(0, 8447, '\p{^Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(0, 8447, '\P{Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(1, 8447, '\P{^Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(0, 8448, '\p{Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(1, 8448, '\p{^Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(1, 8448, '\P{Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Expect(0, 8448, '\P{^Is_Blk:			combining_Diacritical_MARKS_for_Symbols}', "");
    Error('\p{Block=/a/		Combining_DIACRITICAL_MARKS_Supplement}');
    Error('\P{Block=/a/		Combining_DIACRITICAL_MARKS_Supplement}');
    Expect(1, 7679, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(1, 7679, '\p{Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(0, 7679, '\p{^Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(0, 7679, '\P{Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(1, 7679, '\P{^Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(0, 7680, '\p{Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(1, 7680, '\p{^Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(1, 7680, '\P{Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Expect(0, 7680, '\P{^Block=__COMBINING_Diacritical_marks_Supplement}', "");
    Error('\p{Blk:	/a/  DIACRITICALS_sup}');
    Error('\P{Blk:	/a/  DIACRITICALS_sup}');
    Expect(1, 7679, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(1, 7679, '\p{Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(1, 7679, '\p{Blk=-	DIACRITICALS_Sup}', "");
    Expect(0, 7679, '\p{^Blk=-	DIACRITICALS_Sup}', "");
    Expect(0, 7679, '\P{Blk=-	DIACRITICALS_Sup}', "");
    Expect(1, 7679, '\P{^Blk=-	DIACRITICALS_Sup}', "");
    Expect(0, 7680, '\p{Blk=-	DIACRITICALS_Sup}', "");
    Expect(1, 7680, '\p{^Blk=-	DIACRITICALS_Sup}', "");
    Expect(1, 7680, '\P{Blk=-	DIACRITICALS_Sup}', "");
    Expect(0, 7680, '\P{^Blk=-	DIACRITICALS_Sup}', "");
    Error('\p{Is_Block: :=Combining_DIACRITICAL_MARKS_Supplement}');
    Error('\P{Is_Block: :=Combining_DIACRITICAL_MARKS_Supplement}');
    Expect(1, 7679, '\p{Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Is_Block:combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(0, 7679, '\p{^Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(0, 7679, '\P{Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(1, 7679, '\P{^Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(0, 7680, '\p{Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(1, 7680, '\p{^Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(1, 7680, '\P{Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Expect(0, 7680, '\P{^Is_Block=	 combining_DIACRITICAL_marks_supplement}', "");
    Error('\p{Is_Blk:	/a/ -diacriticals_SUP}');
    Error('\P{Is_Blk:	/a/ -diacriticals_SUP}');
    Expect(1, 7679, '\p{Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Is_Blk=	Diacriticals_sup}', "");
    Expect(0, 7679, '\p{^Is_Blk=	Diacriticals_sup}', "");
    Expect(0, 7679, '\P{Is_Blk=	Diacriticals_sup}', "");
    Expect(1, 7679, '\P{^Is_Blk=	Diacriticals_sup}', "");
    Expect(0, 7680, '\p{Is_Blk=	Diacriticals_sup}', "");
    Expect(1, 7680, '\p{^Is_Blk=	Diacriticals_sup}', "");
    Expect(1, 7680, '\P{Is_Blk=	Diacriticals_sup}', "");
    Expect(0, 7680, '\P{^Is_Blk=	Diacriticals_sup}', "");
    Error('\p{Block: :=DINGBATS}');
    Error('\P{Block: :=DINGBATS}');
    Expect(1, 10175, '\p{Block=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=dingbats}', "");
    Expect(0, 10175, '\p{^Block=dingbats}', "");
    Expect(0, 10175, '\P{Block=dingbats}', "");
    Expect(1, 10175, '\P{^Block=dingbats}', "");
    Expect(0, 10176, '\p{Block=dingbats}', "");
    Expect(1, 10176, '\p{^Block=dingbats}', "");
    Expect(1, 10176, '\P{Block=dingbats}', "");
    Expect(0, 10176, '\P{^Block=dingbats}', "");
    Expect(1, 10175, '\p{Block=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Block= DINGBATS}', "");
    Expect(0, 10175, '\p{^Block= DINGBATS}', "");
    Expect(0, 10175, '\P{Block= DINGBATS}', "");
    Expect(1, 10175, '\P{^Block= DINGBATS}', "");
    Expect(0, 10176, '\p{Block= DINGBATS}', "");
    Expect(1, 10176, '\p{^Block= DINGBATS}', "");
    Expect(1, 10176, '\P{Block= DINGBATS}', "");
    Expect(0, 10176, '\P{^Block= DINGBATS}', "");
    Error('\p{Blk=/a/dingbats}');
    Error('\P{Blk=/a/dingbats}');
    Expect(1, 10175, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Blk=dingbats}', "");
    Expect(0, 10175, '\P{Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Blk=dingbats}', "");
    Expect(0, 10176, '\p{Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Blk=dingbats}', "");
    Expect(1, 10176, '\P{Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Blk=dingbats}', "");
    Expect(1, 10175, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk:   Dingbats}', "");
    Expect(0, 10175, '\p{^Blk:   Dingbats}', "");
    Expect(0, 10175, '\P{Blk:   Dingbats}', "");
    Expect(1, 10175, '\P{^Blk:   Dingbats}', "");
    Expect(0, 10176, '\p{Blk:   Dingbats}', "");
    Expect(1, 10176, '\p{^Blk:   Dingbats}', "");
    Expect(1, 10176, '\P{Blk:   Dingbats}', "");
    Expect(0, 10176, '\P{^Blk:   Dingbats}', "");
    Error('\p{Is_Block=_/a/DINGBATS}');
    Error('\P{Is_Block=_/a/DINGBATS}');
    Expect(1, 10175, '\p{Is_Block:dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block:dingbats}', "");
    Expect(0, 10175, '\P{Is_Block:dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block:dingbats}', "");
    Expect(0, 10176, '\p{Is_Block:dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block:dingbats}', "");
    Expect(1, 10176, '\P{Is_Block:dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block:dingbats}', "");
    Expect(1, 10175, '\p{Is_Block=  DINGBATS}', "");
    Expect(0, 10175, '\p{^Is_Block=  DINGBATS}', "");
    Expect(0, 10175, '\P{Is_Block=  DINGBATS}', "");
    Expect(1, 10175, '\P{^Is_Block=  DINGBATS}', "");
    Expect(0, 10176, '\p{Is_Block=  DINGBATS}', "");
    Expect(1, 10176, '\p{^Is_Block=  DINGBATS}', "");
    Expect(1, 10176, '\P{Is_Block=  DINGBATS}', "");
    Expect(0, 10176, '\P{^Is_Block=  DINGBATS}', "");
    Error('\p{Is_Blk=:=Dingbats}');
    Error('\P{Is_Blk=:=Dingbats}');
    Expect(1, 10175, '\p{Is_Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=dingbats}', "");
    Expect(1, 10175, '\p{Is_Blk=_dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=_dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=_dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=_dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=_dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=_dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=_dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=_dingbats}', "");
    Error('\p{Block=-_Dogra:=}');
    Error('\P{Block=-_Dogra:=}');
    Expect(1, 71759, '\p{Block=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Block:dogra}', "");
    Expect(0, 71759, '\p{^Block:dogra}', "");
    Expect(0, 71759, '\P{Block:dogra}', "");
    Expect(1, 71759, '\P{^Block:dogra}', "");
    Expect(0, 71760, '\p{Block:dogra}', "");
    Expect(1, 71760, '\p{^Block:dogra}', "");
    Expect(1, 71760, '\P{Block:dogra}', "");
    Expect(0, 71760, '\P{^Block:dogra}', "");
    Expect(1, 71759, '\p{Block=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Block=  Dogra}', "");
    Expect(0, 71759, '\p{^Block=  Dogra}', "");
    Expect(0, 71759, '\P{Block=  Dogra}', "");
    Expect(1, 71759, '\P{^Block=  Dogra}', "");
    Expect(0, 71760, '\p{Block=  Dogra}', "");
    Expect(1, 71760, '\p{^Block=  Dogra}', "");
    Expect(1, 71760, '\P{Block=  Dogra}', "");
    Expect(0, 71760, '\P{^Block=  Dogra}', "");
    Error('\p{Blk=/a/ 	DOGRA}');
    Error('\P{Blk=/a/ 	DOGRA}');
    Expect(1, 71759, '\p{Blk=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=dogra}', "");
    Expect(0, 71759, '\p{^Blk=dogra}', "");
    Expect(0, 71759, '\P{Blk=dogra}', "");
    Expect(1, 71759, '\P{^Blk=dogra}', "");
    Expect(0, 71760, '\p{Blk=dogra}', "");
    Expect(1, 71760, '\p{^Blk=dogra}', "");
    Expect(1, 71760, '\P{Blk=dogra}', "");
    Expect(0, 71760, '\P{^Blk=dogra}', "");
    Expect(1, 71759, '\p{Blk=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Blk= _DOGRA}', "");
    Expect(0, 71759, '\p{^Blk= _DOGRA}', "");
    Expect(0, 71759, '\P{Blk= _DOGRA}', "");
    Expect(1, 71759, '\P{^Blk= _DOGRA}', "");
    Expect(0, 71760, '\p{Blk= _DOGRA}', "");
    Expect(1, 71760, '\p{^Blk= _DOGRA}', "");
    Expect(1, 71760, '\P{Blk= _DOGRA}', "");
    Expect(0, 71760, '\P{^Blk= _DOGRA}', "");
    Error('\p{Is_Block=:= -Dogra}');
    Error('\P{Is_Block=:= -Dogra}');
    Expect(1, 71759, '\p{Is_Block=dogra}', "");
    Expect(0, 71759, '\p{^Is_Block=dogra}', "");
    Expect(0, 71759, '\P{Is_Block=dogra}', "");
    Expect(1, 71759, '\P{^Is_Block=dogra}', "");
    Expect(0, 71760, '\p{Is_Block=dogra}', "");
    Expect(1, 71760, '\p{^Is_Block=dogra}', "");
    Expect(1, 71760, '\P{Is_Block=dogra}', "");
    Expect(0, 71760, '\P{^Is_Block=dogra}', "");
    Expect(1, 71759, '\p{Is_Block=	_Dogra}', "");
    Expect(0, 71759, '\p{^Is_Block=	_Dogra}', "");
    Expect(0, 71759, '\P{Is_Block=	_Dogra}', "");
    Expect(1, 71759, '\P{^Is_Block=	_Dogra}', "");
    Expect(0, 71760, '\p{Is_Block=	_Dogra}', "");
    Expect(1, 71760, '\p{^Is_Block=	_Dogra}', "");
    Expect(1, 71760, '\P{Is_Block=	_Dogra}', "");
    Expect(0, 71760, '\P{^Is_Block=	_Dogra}', "");
    Error('\p{Is_Blk:   /a/-	dogra}');
    Error('\P{Is_Blk:   /a/-	dogra}');
    Expect(1, 71759, '\p{Is_Blk=dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=dogra}', "");
    Expect(1, 71759, '\p{Is_Blk=	 Dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=	 Dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=	 Dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=	 Dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=	 Dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=	 Dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=	 Dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=	 Dogra}', "");
    Error('\p{Block=/a/domino_Tiles}');
    Error('\P{Block=/a/domino_Tiles}');
    Expect(1, 127135, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(1, 127135, '\p{Block:   dominotiles}', "");
    Expect(0, 127135, '\p{^Block:   dominotiles}', "");
    Expect(0, 127135, '\P{Block:   dominotiles}', "");
    Expect(1, 127135, '\P{^Block:   dominotiles}', "");
    Expect(0, 127136, '\p{Block:   dominotiles}', "");
    Expect(1, 127136, '\p{^Block:   dominotiles}', "");
    Expect(1, 127136, '\P{Block:   dominotiles}', "");
    Expect(0, 127136, '\P{^Block:   dominotiles}', "");
    Expect(1, 127135, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(1, 127135, '\p{Block=  Domino_TILES}', "");
    Expect(0, 127135, '\p{^Block=  Domino_TILES}', "");
    Expect(0, 127135, '\P{Block=  Domino_TILES}', "");
    Expect(1, 127135, '\P{^Block=  Domino_TILES}', "");
    Expect(0, 127136, '\p{Block=  Domino_TILES}', "");
    Expect(1, 127136, '\p{^Block=  Domino_TILES}', "");
    Expect(1, 127136, '\P{Block=  Domino_TILES}', "");
    Expect(0, 127136, '\P{^Block=  Domino_TILES}', "");
    Error('\p{Blk= _Domino:=}');
    Error('\P{Blk= _Domino:=}');
    Expect(1, 127135, '\p{Blk=:\ADomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\ADomino\z:}', "");;
    Expect(1, 127135, '\p{Blk=domino}', "");
    Expect(0, 127135, '\p{^Blk=domino}', "");
    Expect(0, 127135, '\P{Blk=domino}', "");
    Expect(1, 127135, '\P{^Blk=domino}', "");
    Expect(0, 127136, '\p{Blk=domino}', "");
    Expect(1, 127136, '\p{^Blk=domino}', "");
    Expect(1, 127136, '\P{Blk=domino}', "");
    Expect(0, 127136, '\P{^Blk=domino}', "");
    Expect(1, 127135, '\p{Blk=:\Adomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\Adomino\z:}', "");;
    Expect(1, 127135, '\p{Blk= -domino}', "");
    Expect(0, 127135, '\p{^Blk= -domino}', "");
    Expect(0, 127135, '\P{Blk= -domino}', "");
    Expect(1, 127135, '\P{^Blk= -domino}', "");
    Expect(0, 127136, '\p{Blk= -domino}', "");
    Expect(1, 127136, '\p{^Blk= -domino}', "");
    Expect(1, 127136, '\P{Blk= -domino}', "");
    Expect(0, 127136, '\P{^Blk= -domino}', "");
    Error('\p{Is_Block=	/a/Domino_tiles}');
    Error('\P{Is_Block=	/a/Domino_tiles}');
    Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
    Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
    Expect(0, 127136, '\p{Is_Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Is_Block=dominotiles}', "");
    Expect(1, 127136, '\P{Is_Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Is_Block=dominotiles}', "");
    Expect(1, 127135, '\p{Is_Block=-domino_Tiles}', "");
    Expect(0, 127135, '\p{^Is_Block=-domino_Tiles}', "");
    Expect(0, 127135, '\P{Is_Block=-domino_Tiles}', "");
    Expect(1, 127135, '\P{^Is_Block=-domino_Tiles}', "");
    Expect(0, 127136, '\p{Is_Block=-domino_Tiles}', "");
    Expect(1, 127136, '\p{^Is_Block=-domino_Tiles}', "");
    Expect(1, 127136, '\P{Is_Block=-domino_Tiles}', "");
    Expect(0, 127136, '\P{^Is_Block=-domino_Tiles}', "");
    Error('\p{Is_Blk=	Domino:=}');
    Error('\P{Is_Blk=	Domino:=}');
    Expect(1, 127135, '\p{Is_Blk=domino}', "");
    Expect(0, 127135, '\p{^Is_Blk=domino}', "");
    Expect(0, 127135, '\P{Is_Blk=domino}', "");
    Expect(1, 127135, '\P{^Is_Blk=domino}', "");
    Expect(0, 127136, '\p{Is_Blk=domino}', "");
    Expect(1, 127136, '\p{^Is_Blk=domino}', "");
    Expect(1, 127136, '\P{Is_Blk=domino}', "");
    Expect(0, 127136, '\P{^Is_Blk=domino}', "");
    Expect(1, 127135, '\p{Is_Blk:   	-DOMINO}', "");
    Expect(0, 127135, '\p{^Is_Blk:   	-DOMINO}', "");
    Expect(0, 127135, '\P{Is_Blk:   	-DOMINO}', "");
    Expect(1, 127135, '\P{^Is_Blk:   	-DOMINO}', "");
    Expect(0, 127136, '\p{Is_Blk:   	-DOMINO}', "");
    Expect(1, 127136, '\p{^Is_Blk:   	-DOMINO}', "");
    Expect(1, 127136, '\P{Is_Blk:   	-DOMINO}', "");
    Expect(0, 127136, '\P{^Is_Blk:   	-DOMINO}', "");
    Error('\p{Block= 	Duployan/a/}');
    Error('\P{Block= 	Duployan/a/}');
    Expect(1, 113823, '\p{Block=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Block=duployan}', "");
    Expect(0, 113823, '\p{^Block=duployan}', "");
    Expect(0, 113823, '\P{Block=duployan}', "");
    Expect(1, 113823, '\P{^Block=duployan}', "");
    Expect(0, 113824, '\p{Block=duployan}', "");
    Expect(1, 113824, '\p{^Block=duployan}', "");
    Expect(1, 113824, '\P{Block=duployan}', "");
    Expect(0, 113824, '\P{^Block=duployan}', "");
    Expect(1, 113823, '\p{Block=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Block= Duployan}', "");
    Expect(0, 113823, '\p{^Block= Duployan}', "");
    Expect(0, 113823, '\P{Block= Duployan}', "");
    Expect(1, 113823, '\P{^Block= Duployan}', "");
    Expect(0, 113824, '\p{Block= Duployan}', "");
    Expect(1, 113824, '\p{^Block= Duployan}', "");
    Expect(1, 113824, '\P{Block= Duployan}', "");
    Expect(0, 113824, '\P{^Block= Duployan}', "");
    Error('\p{Blk=/a/duployan}');
    Error('\P{Blk=/a/duployan}');
    Expect(1, 113823, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=duployan}', "");
    Expect(0, 113823, '\p{^Blk=duployan}', "");
    Expect(0, 113823, '\P{Blk=duployan}', "");
    Expect(1, 113823, '\P{^Blk=duployan}', "");
    Expect(0, 113824, '\p{Blk=duployan}', "");
    Expect(1, 113824, '\p{^Blk=duployan}', "");
    Expect(1, 113824, '\P{Blk=duployan}', "");
    Expect(0, 113824, '\P{^Blk=duployan}', "");
    Expect(1, 113823, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=	duployan}', "");
    Expect(0, 113823, '\p{^Blk=	duployan}', "");
    Expect(0, 113823, '\P{Blk=	duployan}', "");
    Expect(1, 113823, '\P{^Blk=	duployan}', "");
    Expect(0, 113824, '\p{Blk=	duployan}', "");
    Expect(1, 113824, '\p{^Blk=	duployan}', "");
    Expect(1, 113824, '\P{Blk=	duployan}', "");
    Expect(0, 113824, '\P{^Blk=	duployan}', "");
    Error('\p{Is_Block:	:= 	DUPLOYAN}');
    Error('\P{Is_Block:	:= 	DUPLOYAN}');
    Expect(1, 113823, '\p{Is_Block=duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=duployan}', "");
    Expect(0, 113823, '\P{Is_Block=duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=duployan}', "");
    Expect(0, 113824, '\p{Is_Block=duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=duployan}', "");
    Expect(1, 113824, '\P{Is_Block=duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=duployan}', "");
    Expect(1, 113823, '\p{Is_Block=	Duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=	Duployan}', "");
    Expect(0, 113823, '\P{Is_Block=	Duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=	Duployan}', "");
    Expect(0, 113824, '\p{Is_Block=	Duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=	Duployan}', "");
    Expect(1, 113824, '\P{Is_Block=	Duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=	Duployan}', "");
    Error('\p{Is_Blk=:=	Duployan}');
    Error('\P{Is_Blk=:=	Duployan}');
    Expect(1, 113823, '\p{Is_Blk=duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk=duployan}', "");
    Expect(0, 113823, '\P{Is_Blk=duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk=duployan}', "");
    Expect(0, 113824, '\p{Is_Blk=duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk=duployan}', "");
    Expect(1, 113824, '\P{Is_Blk=duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk=duployan}', "");
    Expect(1, 113823, '\p{Is_Blk=	 Duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk=	 Duployan}', "");
    Expect(0, 113823, '\P{Is_Blk=	 Duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk=	 Duployan}', "");
    Expect(0, 113824, '\p{Is_Blk=	 Duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk=	 Duployan}', "");
    Expect(1, 113824, '\P{Is_Blk=	 Duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk=	 Duployan}', "");
    Error('\p{Block=_Early_dynastic_CUNEIFORM:=}');
    Error('\P{Block=_Early_dynastic_CUNEIFORM:=}');
    Expect(1, 75087, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block= 	early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Block= 	early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Block= 	early_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Block= 	early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Block= 	early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Block= 	early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Block= 	early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Block= 	early_Dynastic_Cuneiform}', "");
    Error('\p{Blk=_:=early_Dynastic_cuneiform}');
    Error('\P{Blk=_:=early_Dynastic_cuneiform}');
    Expect(1, 75087, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Blk=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Blk=--Early_Dynastic_Cuneiform}', "");
    Error('\p{Is_Block= /a/EARLY_Dynastic_Cuneiform}');
    Error('\P{Is_Block= /a/EARLY_Dynastic_Cuneiform}');
    Expect(1, 75087, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Is_Block= -Early_dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block= -Early_dynastic_Cuneiform}', "");
    Error('\p{Is_Blk=/a/-Early_Dynastic_CUNEIFORM}');
    Error('\P{Is_Blk=/a/-Early_Dynastic_CUNEIFORM}');
    Expect(1, 75087, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75087, '\p{^Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75087, '\P{Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(1, 75087, '\P{^Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75088, '\p{Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(1, 75088, '\p{^Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(1, 75088, '\P{Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75088, '\P{^Is_Blk:		early_Dynastic_CUNEIFORM}', "");
    Error('\p{Block=/a/-Egyptian_Hieroglyph_Format_CONTROLS}');
    Error('\P{Block=/a/-Egyptian_Hieroglyph_Format_CONTROLS}');
    Expect(1, 78911, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78912, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78911, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78912, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78911, '\p{Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78911, '\p{^Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78911, '\P{Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(1, 78911, '\P{^Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78912, '\p{Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(1, 78912, '\p{^Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(1, 78912, '\P{Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78912, '\P{^Block=--Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Error('\p{Blk=/a/--Egyptian_HIEROGLYPH_FORMAT_controls}');
    Error('\P{Blk=/a/--Egyptian_HIEROGLYPH_FORMAT_controls}');
    Expect(1, 78911, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78912, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78911, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78912, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78911, '\p{Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(0, 78911, '\p{^Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(0, 78911, '\P{Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(1, 78911, '\P{^Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(0, 78912, '\p{Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(1, 78912, '\p{^Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(1, 78912, '\P{Blk=Egyptian_hieroglyph_format_Controls}', "");
    Expect(0, 78912, '\P{^Blk=Egyptian_hieroglyph_format_Controls}', "");
    Error('\p{Is_Block=_	egyptian_Hieroglyph_Format_Controls:=}');
    Error('\P{Is_Block=_	egyptian_Hieroglyph_Format_Controls:=}');
    Expect(1, 78911, '\p{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(0, 78911, '\p{^Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(0, 78911, '\P{Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(1, 78911, '\P{^Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(0, 78912, '\p{Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(1, 78912, '\p{^Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(1, 78912, '\P{Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Expect(0, 78912, '\P{^Is_Block:  	EGYPTIAN_Hieroglyph_Format_CONTROLS}', "");
    Error('\p{Is_Blk=_:=EGYPTIAN_Hieroglyph_Format_Controls}');
    Error('\P{Is_Blk=_:=EGYPTIAN_Hieroglyph_Format_Controls}');
    Expect(1, 78911, '\p{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78911, '\p{^Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78911, '\P{Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(1, 78911, '\P{^Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78912, '\p{Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(1, 78912, '\p{^Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(1, 78912, '\P{Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78912, '\P{^Is_Blk= egyptian_Hieroglyph_format_CONTROLS}', "");
    Error('\p{Block=-/a/Egyptian_HIEROGLYPHS}');
    Error('\P{Block=-/a/Egyptian_HIEROGLYPHS}');
    Expect(1, 78895, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\p{^Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\P{Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(1, 78895, '\P{^Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\p{Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\p{^Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\P{Block=-	egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\P{^Block=-	egyptian_HIEROGLYPHS}', "");
    Error('\p{Blk=_/a/Egyptian_hieroglyphs}');
    Error('\P{Blk=_/a/Egyptian_hieroglyphs}');
    Expect(1, 78895, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk= Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk= Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Blk= Egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk= Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Blk= Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk= Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Blk= Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk= Egyptian_Hieroglyphs}', "");
    Error('\p{Is_Block=-/a/EGYPTIAN_hieroglyphs}');
    Error('\P{Is_Block=-/a/EGYPTIAN_hieroglyphs}');
    Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=	Egyptian_Hieroglyphs}', "");
    Error('\p{Is_Blk=:=_EGYPTIAN_Hieroglyphs}');
    Error('\P{Is_Blk=:=_EGYPTIAN_Hieroglyphs}');
    Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk: EGYPTIAN_Hieroglyphs}', "");
    Error('\p{Block=:=  Elbasan}');
    Error('\P{Block=:=  Elbasan}');
    Expect(1, 66863, '\p{Block=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Block=elbasan}', "");
    Expect(0, 66863, '\p{^Block=elbasan}', "");
    Expect(0, 66863, '\P{Block=elbasan}', "");
    Expect(1, 66863, '\P{^Block=elbasan}', "");
    Expect(0, 66864, '\p{Block=elbasan}', "");
    Expect(1, 66864, '\p{^Block=elbasan}', "");
    Expect(1, 66864, '\P{Block=elbasan}', "");
    Expect(0, 66864, '\P{^Block=elbasan}', "");
    Expect(1, 66863, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Block: _-ELBASAN}', "");
    Expect(0, 66863, '\p{^Block: _-ELBASAN}', "");
    Expect(0, 66863, '\P{Block: _-ELBASAN}', "");
    Expect(1, 66863, '\P{^Block: _-ELBASAN}', "");
    Expect(0, 66864, '\p{Block: _-ELBASAN}', "");
    Expect(1, 66864, '\p{^Block: _-ELBASAN}', "");
    Expect(1, 66864, '\P{Block: _-ELBASAN}', "");
    Expect(0, 66864, '\P{^Block: _-ELBASAN}', "");
    Error('\p{Blk=:=Elbasan}');
    Error('\P{Blk=:=Elbasan}');
    Expect(1, 66863, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Blk=elbasan}', "");
    Expect(0, 66863, '\P{Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Blk=elbasan}', "");
    Expect(0, 66864, '\p{Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Blk=elbasan}', "");
    Expect(1, 66864, '\P{Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Blk=elbasan}', "");
    Expect(1, 66863, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk=		Elbasan}', "");
    Expect(0, 66863, '\p{^Blk=		Elbasan}', "");
    Expect(0, 66863, '\P{Blk=		Elbasan}', "");
    Expect(1, 66863, '\P{^Blk=		Elbasan}', "");
    Expect(0, 66864, '\p{Blk=		Elbasan}', "");
    Expect(1, 66864, '\p{^Blk=		Elbasan}', "");
    Expect(1, 66864, '\P{Blk=		Elbasan}', "");
    Expect(0, 66864, '\P{^Blk=		Elbasan}', "");
    Error('\p{Is_Block= /a/Elbasan}');
    Error('\P{Is_Block= /a/Elbasan}');
    Expect(1, 66863, '\p{Is_Block=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=elbasan}', "");
    Expect(1, 66863, '\p{Is_Block=- Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=- Elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=- Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=- Elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=- Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=- Elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=- Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=- Elbasan}', "");
    Error('\p{Is_Blk=	-ELBASAN:=}');
    Error('\P{Is_Blk=	-ELBASAN:=}');
    Expect(1, 66863, '\p{Is_Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=elbasan}', "");
    Expect(1, 66863, '\p{Is_Blk=_Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=_Elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=_Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=_Elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=_Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=_Elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=_Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=_Elbasan}', "");
    Error('\p{Block=_:=ELYMAIC}');
    Error('\P{Block=_:=ELYMAIC}');
    Expect(1, 69631, '\p{Block=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Block:elymaic}', "");
    Expect(0, 69631, '\p{^Block:elymaic}', "");
    Expect(0, 69631, '\P{Block:elymaic}', "");
    Expect(1, 69631, '\P{^Block:elymaic}', "");
    Expect(0, 69632, '\p{Block:elymaic}', "");
    Expect(1, 69632, '\p{^Block:elymaic}', "");
    Expect(1, 69632, '\P{Block:elymaic}', "");
    Expect(0, 69632, '\P{^Block:elymaic}', "");
    Expect(1, 69631, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Block=		Elymaic}', "");
    Expect(0, 69631, '\p{^Block=		Elymaic}', "");
    Expect(0, 69631, '\P{Block=		Elymaic}', "");
    Expect(1, 69631, '\P{^Block=		Elymaic}', "");
    Expect(0, 69632, '\p{Block=		Elymaic}', "");
    Expect(1, 69632, '\p{^Block=		Elymaic}', "");
    Expect(1, 69632, '\P{Block=		Elymaic}', "");
    Expect(0, 69632, '\P{^Block=		Elymaic}', "");
    Error('\p{Blk=__ELYMAIC:=}');
    Error('\P{Blk=__ELYMAIC:=}');
    Expect(1, 69631, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Blk=elymaic}', "");
    Expect(0, 69631, '\P{Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Blk=elymaic}', "");
    Expect(0, 69632, '\p{Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Blk=elymaic}', "");
    Expect(1, 69632, '\P{Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Blk=elymaic}', "");
    Expect(1, 69631, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk= 	Elymaic}', "");
    Expect(0, 69631, '\p{^Blk= 	Elymaic}', "");
    Expect(0, 69631, '\P{Blk= 	Elymaic}', "");
    Expect(1, 69631, '\P{^Blk= 	Elymaic}', "");
    Expect(0, 69632, '\p{Blk= 	Elymaic}', "");
    Expect(1, 69632, '\p{^Blk= 	Elymaic}', "");
    Expect(1, 69632, '\P{Blk= 	Elymaic}', "");
    Expect(0, 69632, '\P{^Blk= 	Elymaic}', "");
    Error('\p{Is_Block= _ELYMAIC:=}');
    Error('\P{Is_Block= _ELYMAIC:=}');
    Expect(1, 69631, '\p{Is_Block=elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block=elymaic}', "");
    Expect(0, 69631, '\P{Is_Block=elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block=elymaic}', "");
    Expect(0, 69632, '\p{Is_Block=elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block=elymaic}', "");
    Expect(1, 69632, '\P{Is_Block=elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block=elymaic}', "");
    Expect(1, 69631, '\p{Is_Block=	_elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block=	_elymaic}', "");
    Expect(0, 69631, '\P{Is_Block=	_elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block=	_elymaic}', "");
    Expect(0, 69632, '\p{Is_Block=	_elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block=	_elymaic}', "");
    Expect(1, 69632, '\P{Is_Block=	_elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block=	_elymaic}', "");
    Error('\p{Is_Blk=/a/ELYMAIC}');
    Error('\P{Is_Blk=/a/ELYMAIC}');
    Expect(1, 69631, '\p{Is_Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk=elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk=elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk=elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk=elymaic}', "");
    Expect(1, 69631, '\p{Is_Blk= -Elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk= -Elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk= -Elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk= -Elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk= -Elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk= -Elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk= -Elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk= -Elymaic}', "");
    Error('\p{Block= 	Emoticons/a/}');
    Error('\P{Block= 	Emoticons/a/}');
    Expect(1, 128591, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=emoticons}', "");
    Expect(0, 128591, '\p{^Block=emoticons}', "");
    Expect(0, 128591, '\P{Block=emoticons}', "");
    Expect(1, 128591, '\P{^Block=emoticons}', "");
    Expect(0, 128592, '\p{Block=emoticons}', "");
    Expect(1, 128592, '\p{^Block=emoticons}', "");
    Expect(1, 128592, '\P{Block=emoticons}', "");
    Expect(0, 128592, '\P{^Block=emoticons}', "");
    Expect(1, 128591, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=	emoticons}', "");
    Expect(0, 128591, '\p{^Block=	emoticons}', "");
    Expect(0, 128591, '\P{Block=	emoticons}', "");
    Expect(1, 128591, '\P{^Block=	emoticons}', "");
    Expect(0, 128592, '\p{Block=	emoticons}', "");
    Expect(1, 128592, '\p{^Block=	emoticons}', "");
    Expect(1, 128592, '\P{Block=	emoticons}', "");
    Expect(0, 128592, '\P{^Block=	emoticons}', "");
    Error('\p{Blk=/a/-	Emoticons}');
    Error('\P{Blk=/a/-	Emoticons}');
    Expect(1, 128591, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Blk=emoticons}', "");
    Expect(0, 128591, '\P{Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Blk=emoticons}', "");
    Expect(0, 128592, '\p{Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Blk=emoticons}', "");
    Expect(1, 128592, '\P{Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Blk=emoticons}', "");
    Expect(1, 128591, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk=  emoticons}', "");
    Expect(0, 128591, '\p{^Blk=  emoticons}', "");
    Expect(0, 128591, '\P{Blk=  emoticons}', "");
    Expect(1, 128591, '\P{^Blk=  emoticons}', "");
    Expect(0, 128592, '\p{Blk=  emoticons}', "");
    Expect(1, 128592, '\p{^Blk=  emoticons}', "");
    Expect(1, 128592, '\P{Blk=  emoticons}', "");
    Expect(0, 128592, '\P{^Blk=  emoticons}', "");
    Error('\p{Is_Block: _Emoticons:=}');
    Error('\P{Is_Block: _Emoticons:=}');
    Expect(1, 128591, '\p{Is_Block=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=emoticons}', "");
    Expect(1, 128591, '\p{Is_Block: 		Emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block: 		Emoticons}', "");
    Expect(0, 128591, '\P{Is_Block: 		Emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block: 		Emoticons}', "");
    Expect(0, 128592, '\p{Is_Block: 		Emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block: 		Emoticons}', "");
    Expect(1, 128592, '\P{Is_Block: 		Emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block: 		Emoticons}', "");
    Error('\p{Is_Blk=/a/ 	emoticons}');
    Error('\P{Is_Blk=/a/ 	emoticons}');
    Expect(1, 128591, '\p{Is_Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=emoticons}', "");
    Expect(1, 128591, '\p{Is_Blk=		Emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=		Emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=		Emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=		Emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=		Emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=		Emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=		Emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=		Emoticons}', "");
    Error('\p{Block=:=		enclosed_ALPHANUMERICS}');
    Error('\P{Block=:=		enclosed_ALPHANUMERICS}');
    Expect(1, 9471, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=	ENCLOSED_Alphanumerics}', "");
    Expect(0, 9471, '\p{^Block=	ENCLOSED_Alphanumerics}', "");
    Expect(0, 9471, '\P{Block=	ENCLOSED_Alphanumerics}', "");
    Expect(1, 9471, '\P{^Block=	ENCLOSED_Alphanumerics}', "");
    Expect(0, 9472, '\p{Block=	ENCLOSED_Alphanumerics}', "");
    Expect(1, 9472, '\p{^Block=	ENCLOSED_Alphanumerics}', "");
    Expect(1, 9472, '\P{Block=	ENCLOSED_Alphanumerics}', "");
    Expect(0, 9472, '\P{^Block=	ENCLOSED_Alphanumerics}', "");
    Error('\p{Blk=/a/ENCLOSED_ALPHANUM}');
    Error('\P{Blk=/a/ENCLOSED_ALPHANUM}');
    Expect(1, 9471, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9471, '\p{^Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9471, '\P{Blk=	Enclosed_Alphanum}', "");
    Expect(1, 9471, '\P{^Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9472, '\p{Blk=	Enclosed_Alphanum}', "");
    Expect(1, 9472, '\p{^Blk=	Enclosed_Alphanum}', "");
    Expect(1, 9472, '\P{Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9472, '\P{^Blk=	Enclosed_Alphanum}', "");
    Error('\p{Is_Block= -Enclosed_Alphanumerics/a/}');
    Error('\P{Is_Block= -Enclosed_Alphanumerics/a/}');
    Expect(1, 9471, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block:	- Enclosed_Alphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block:	- Enclosed_Alphanumerics}', "");
    Error('\p{Is_Blk=--enclosed_Alphanum/a/}');
    Error('\P{Is_Blk=--enclosed_Alphanum/a/}');
    Expect(1, 9471, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=	 ENCLOSED_Alphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=	 ENCLOSED_Alphanum}', "");
    Error('\p{Block=-:=Enclosed_Alphanumeric_SUPPLEMENT}');
    Error('\P{Block=-:=Enclosed_Alphanumeric_SUPPLEMENT}');
    Expect(1, 127487, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(1, 127487, '\p{Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(0, 127487, '\p{^Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(0, 127487, '\P{Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(1, 127487, '\P{^Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(0, 127488, '\p{Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(1, 127488, '\p{^Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(1, 127488, '\P{Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Expect(0, 127488, '\P{^Block=-ENCLOSED_Alphanumeric_Supplement}', "");
    Error('\p{Blk: enclosed_ALPHANUM_SUP:=}');
    Error('\P{Blk: enclosed_ALPHANUM_SUP:=}');
    Expect(1, 127487, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(1, 127487, '\p{Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(1, 127487, '\p{Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\p{^Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\P{Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(1, 127487, '\P{^Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\p{Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\p{^Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\P{Blk=_ Enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\P{^Blk=_ Enclosed_Alphanum_Sup}', "");
    Error('\p{Is_Block=_	Enclosed_alphanumeric_supplement/a/}');
    Error('\P{Is_Block=_	Enclosed_alphanumeric_supplement/a/}');
    Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(0, 127487, '\p{^Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(0, 127487, '\P{Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(1, 127487, '\P{^Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(0, 127488, '\p{Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(1, 127488, '\p{^Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(1, 127488, '\P{Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Expect(0, 127488, '\P{^Is_Block=- enclosed_ALPHANUMERIC_Supplement}', "");
    Error('\p{Is_Blk=	/a/Enclosed_alphanum_sup}');
    Error('\P{Is_Blk=	/a/Enclosed_alphanum_sup}');
    Expect(1, 127487, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(0, 127487, '\p{^Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(0, 127487, '\P{Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(1, 127487, '\P{^Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(0, 127488, '\p{Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(1, 127488, '\p{^Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(1, 127488, '\P{Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Expect(0, 127488, '\P{^Is_Blk=	ENCLOSED_Alphanum_sup}', "");
    Error('\p{Block:	:=Enclosed_CJK_Letters_And_months}');
    Error('\P{Block:	:=Enclosed_CJK_Letters_And_months}');
    Expect(1, 13055, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(0, 13056, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(0, 13056, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(1, 13055, '\p{Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(0, 13055, '\p{^Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(0, 13055, '\P{Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(1, 13055, '\P{^Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(0, 13056, '\p{Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(1, 13056, '\p{^Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(1, 13056, '\P{Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Expect(0, 13056, '\P{^Block= _ENCLOSED_CJK_LETTERS_And_Months}', "");
    Error('\p{Blk: /a/_	Enclosed_CJK}');
    Error('\P{Blk: /a/_	Enclosed_CJK}');
    Expect(1, 13055, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(1, 13055, '\p{Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(1, 13055, '\p{Blk=	enclosed_CJK}', "");
    Expect(0, 13055, '\p{^Blk=	enclosed_CJK}', "");
    Expect(0, 13055, '\P{Blk=	enclosed_CJK}', "");
    Expect(1, 13055, '\P{^Blk=	enclosed_CJK}', "");
    Expect(0, 13056, '\p{Blk=	enclosed_CJK}', "");
    Expect(1, 13056, '\p{^Blk=	enclosed_CJK}', "");
    Expect(1, 13056, '\P{Blk=	enclosed_CJK}', "");
    Expect(0, 13056, '\P{^Blk=	enclosed_CJK}', "");
    Error('\p{Is_Block=	_Enclosed_CJK_Letters_and_MONTHS:=}');
    Error('\P{Is_Block=	_Enclosed_CJK_Letters_and_MONTHS:=}');
    Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13055, '\p{^Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13055, '\P{Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(1, 13055, '\P{^Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13056, '\p{Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(1, 13056, '\p{^Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(1, 13056, '\P{Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13056, '\P{^Is_Block=_	enclosed_CJK_letters_and_Months}', "");
    Error('\p{Is_Blk:	_:=Enclosed_CJK}');
    Error('\P{Is_Blk:	_:=Enclosed_CJK}');
    Expect(1, 13055, '\p{Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Is_Blk= ENCLOSED_CJK}', "");
    Expect(0, 13055, '\p{^Is_Blk= ENCLOSED_CJK}', "");
    Expect(0, 13055, '\P{Is_Blk= ENCLOSED_CJK}', "");
    Expect(1, 13055, '\P{^Is_Blk= ENCLOSED_CJK}', "");
    Expect(0, 13056, '\p{Is_Blk= ENCLOSED_CJK}', "");
    Expect(1, 13056, '\p{^Is_Blk= ENCLOSED_CJK}', "");
    Expect(1, 13056, '\P{Is_Blk= ENCLOSED_CJK}', "");
    Expect(0, 13056, '\P{^Is_Blk= ENCLOSED_CJK}', "");
    Error('\p{Block=:=-_enclosed_IDEOGRAPHIC_Supplement}');
    Error('\P{Block=:=-_enclosed_IDEOGRAPHIC_Supplement}');
    Expect(1, 127743, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(1, 127743, '\p{Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127743, '\p{^Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127743, '\P{Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(1, 127743, '\P{^Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127744, '\p{Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(1, 127744, '\p{^Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(1, 127744, '\P{Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127744, '\P{^Block=	_Enclosed_IDEOGRAPHIC_supplement}', "");
    Error('\p{Blk= /a/Enclosed_Ideographic_SUP}');
    Error('\P{Blk= /a/Enclosed_Ideographic_SUP}');
    Expect(1, 127743, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(1, 127743, '\p{Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(1, 127743, '\p{Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\p{^Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\P{Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(1, 127743, '\P{^Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\p{Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\p{^Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\P{Blk= 	enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\P{^Blk= 	enclosed_Ideographic_Sup}', "");
    Error('\p{Is_Block=	 Enclosed_ideographic_Supplement/a/}');
    Error('\P{Is_Block=	 Enclosed_ideographic_Supplement/a/}');
    Expect(1, 127743, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127743, '\p{^Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127743, '\P{Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(1, 127743, '\P{^Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127744, '\p{Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(1, 127744, '\p{^Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(1, 127744, '\P{Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Expect(0, 127744, '\P{^Is_Block=Enclosed_IDEOGRAPHIC_supplement}', "");
    Error('\p{Is_Blk=:=	-enclosed_Ideographic_sup}');
    Error('\P{Is_Blk=:=	-enclosed_Ideographic_sup}');
    Expect(1, 127743, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(0, 127743, '\p{^Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(0, 127743, '\P{Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(1, 127743, '\P{^Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(0, 127744, '\p{Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(1, 127744, '\p{^Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(1, 127744, '\P{Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Expect(0, 127744, '\P{^Is_Blk=_ ENCLOSED_IDEOGRAPHIC_Sup}', "");
    Error('\p{Block=-ethiopic:=}');
    Error('\P{Block=-ethiopic:=}');
    Expect(1, 4991, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Block=ethiopic}', "");
    Expect(0, 4991, '\P{Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Block=ethiopic}', "");
    Expect(0, 4992, '\p{Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Block=ethiopic}', "");
    Expect(1, 4992, '\P{Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Block=ethiopic}', "");
    Expect(1, 4991, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Block: Ethiopic}', "");
    Expect(0, 4991, '\p{^Block: Ethiopic}', "");
    Expect(0, 4991, '\P{Block: Ethiopic}', "");
    Expect(1, 4991, '\P{^Block: Ethiopic}', "");
    Expect(0, 4992, '\p{Block: Ethiopic}', "");
    Expect(1, 4992, '\p{^Block: Ethiopic}', "");
    Expect(1, 4992, '\P{Block: Ethiopic}', "");
    Expect(0, 4992, '\P{^Block: Ethiopic}', "");
    Error('\p{Blk=	 ETHIOPIC:=}');
    Error('\P{Blk=	 ETHIOPIC:=}');
    Expect(1, 4991, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=Ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=Ethiopic}', "");
    Expect(0, 4991, '\P{Blk=Ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=Ethiopic}', "");
    Expect(0, 4992, '\p{Blk=Ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=Ethiopic}', "");
    Expect(1, 4992, '\P{Blk=Ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=Ethiopic}', "");
    Error('\p{Is_Block= -Ethiopic:=}');
    Error('\P{Is_Block= -Ethiopic:=}');
    Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Block=--Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=--Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=--Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=--Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=--Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=--Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=--Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=--Ethiopic}', "");
    Error('\p{Is_Blk=:=	-Ethiopic}');
    Error('\P{Is_Blk=:=	-Ethiopic}');
    Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Blk=	 Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=	 Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=	 Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=	 Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=	 Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=	 Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=	 Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=	 Ethiopic}', "");
    Error('\p{Block=:= -ETHIOPIC_Extended}');
    Error('\P{Block=:= -ETHIOPIC_Extended}');
    Expect(1, 11743, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(1, 11743, '\p{Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(1, 11743, '\p{Block=-Ethiopic_extended}', "");
    Expect(0, 11743, '\p{^Block=-Ethiopic_extended}', "");
    Expect(0, 11743, '\P{Block=-Ethiopic_extended}', "");
    Expect(1, 11743, '\P{^Block=-Ethiopic_extended}', "");
    Expect(0, 11744, '\p{Block=-Ethiopic_extended}', "");
    Expect(1, 11744, '\p{^Block=-Ethiopic_extended}', "");
    Expect(1, 11744, '\P{Block=-Ethiopic_extended}', "");
    Expect(0, 11744, '\P{^Block=-Ethiopic_extended}', "");
    Error('\p{Blk=:=-	ethiopic_ext}');
    Error('\P{Blk=:=-	ethiopic_ext}');
    Expect(1, 11743, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(1, 11743, '\p{Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(1, 11743, '\p{Blk=_Ethiopic_Ext}', "");
    Expect(0, 11743, '\p{^Blk=_Ethiopic_Ext}', "");
    Expect(0, 11743, '\P{Blk=_Ethiopic_Ext}', "");
    Expect(1, 11743, '\P{^Blk=_Ethiopic_Ext}', "");
    Expect(0, 11744, '\p{Blk=_Ethiopic_Ext}', "");
    Expect(1, 11744, '\p{^Blk=_Ethiopic_Ext}', "");
    Expect(1, 11744, '\P{Blk=_Ethiopic_Ext}', "");
    Expect(0, 11744, '\P{^Blk=_Ethiopic_Ext}', "");
    Error('\p{Is_Block=-/a/ethiopic_extended}');
    Error('\P{Is_Block=-/a/ethiopic_extended}');
    Expect(1, 11743, '\p{Is_Block: ethiopicextended}', "");
    Expect(0, 11743, '\p{^Is_Block: ethiopicextended}', "");
    Expect(0, 11743, '\P{Is_Block: ethiopicextended}', "");
    Expect(1, 11743, '\P{^Is_Block: ethiopicextended}', "");
    Expect(0, 11744, '\p{Is_Block: ethiopicextended}', "");
    Expect(1, 11744, '\p{^Is_Block: ethiopicextended}', "");
    Expect(1, 11744, '\P{Is_Block: ethiopicextended}', "");
    Expect(0, 11744, '\P{^Is_Block: ethiopicextended}', "");
    Expect(1, 11743, '\p{Is_Block=	ETHIOPIC_Extended}', "");
    Expect(0, 11743, '\p{^Is_Block=	ETHIOPIC_Extended}', "");
    Expect(0, 11743, '\P{Is_Block=	ETHIOPIC_Extended}', "");
    Expect(1, 11743, '\P{^Is_Block=	ETHIOPIC_Extended}', "");
    Expect(0, 11744, '\p{Is_Block=	ETHIOPIC_Extended}', "");
    Expect(1, 11744, '\p{^Is_Block=	ETHIOPIC_Extended}', "");
    Expect(1, 11744, '\P{Is_Block=	ETHIOPIC_Extended}', "");
    Expect(0, 11744, '\P{^Is_Block=	ETHIOPIC_Extended}', "");
    Error('\p{Is_Blk=:=	 Ethiopic_ext}');
    Error('\P{Is_Blk=:=	 Ethiopic_ext}');
    Expect(1, 11743, '\p{Is_Blk:	ethiopicext}', "");
    Expect(0, 11743, '\p{^Is_Blk:	ethiopicext}', "");
    Expect(0, 11743, '\P{Is_Blk:	ethiopicext}', "");
    Expect(1, 11743, '\P{^Is_Blk:	ethiopicext}', "");
    Expect(0, 11744, '\p{Is_Blk:	ethiopicext}', "");
    Expect(1, 11744, '\p{^Is_Blk:	ethiopicext}', "");
    Expect(1, 11744, '\P{Is_Blk:	ethiopicext}', "");
    Expect(0, 11744, '\P{^Is_Blk:	ethiopicext}', "");
    Expect(1, 11743, '\p{Is_Blk=  Ethiopic_Ext}', "");
    Expect(0, 11743, '\p{^Is_Blk=  Ethiopic_Ext}', "");
    Expect(0, 11743, '\P{Is_Blk=  Ethiopic_Ext}', "");
    Expect(1, 11743, '\P{^Is_Blk=  Ethiopic_Ext}', "");
    Expect(0, 11744, '\p{Is_Blk=  Ethiopic_Ext}', "");
    Expect(1, 11744, '\p{^Is_Blk=  Ethiopic_Ext}', "");
    Expect(1, 11744, '\P{Is_Blk=  Ethiopic_Ext}', "");
    Expect(0, 11744, '\P{^Is_Blk=  Ethiopic_Ext}', "");
    Error('\p{Block=/a/_-Ethiopic_Extended_a}');
    Error('\P{Block=/a/_-Ethiopic_Extended_a}');
    Expect(1, 43823, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(0, 43824, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(1, 43823, '\p{Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(0, 43824, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(1, 43823, '\p{Block= ethiopic_Extended_A}', "");
    Expect(0, 43823, '\p{^Block= ethiopic_Extended_A}', "");
    Expect(0, 43823, '\P{Block= ethiopic_Extended_A}', "");
    Expect(1, 43823, '\P{^Block= ethiopic_Extended_A}', "");
    Expect(0, 43824, '\p{Block= ethiopic_Extended_A}', "");
    Expect(1, 43824, '\p{^Block= ethiopic_Extended_A}', "");
    Expect(1, 43824, '\P{Block= ethiopic_Extended_A}', "");
    Expect(0, 43824, '\P{^Block= ethiopic_Extended_A}', "");
    Error('\p{Blk=/a/_ Ethiopic_ext_a}');
    Error('\P{Blk=/a/_ Ethiopic_ext_a}');
    Expect(1, 43823, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(1, 43823, '\p{Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(1, 43823, '\p{Blk=	ETHIOPIC_EXT_A}', "");
    Expect(0, 43823, '\p{^Blk=	ETHIOPIC_EXT_A}', "");
    Expect(0, 43823, '\P{Blk=	ETHIOPIC_EXT_A}', "");
    Expect(1, 43823, '\P{^Blk=	ETHIOPIC_EXT_A}', "");
    Expect(0, 43824, '\p{Blk=	ETHIOPIC_EXT_A}', "");
    Expect(1, 43824, '\p{^Blk=	ETHIOPIC_EXT_A}', "");
    Expect(1, 43824, '\P{Blk=	ETHIOPIC_EXT_A}', "");
    Expect(0, 43824, '\P{^Blk=	ETHIOPIC_EXT_A}', "");
    Error('\p{Is_Block= _ETHIOPIC_EXTENDED_A/a/}');
    Error('\P{Is_Block= _ETHIOPIC_EXTENDED_A/a/}');
    Expect(1, 43823, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Is_Block=_	Ethiopic_extended_A}', "");
    Expect(0, 43823, '\p{^Is_Block=_	Ethiopic_extended_A}', "");
    Expect(0, 43823, '\P{Is_Block=_	Ethiopic_extended_A}', "");
    Expect(1, 43823, '\P{^Is_Block=_	Ethiopic_extended_A}', "");
    Expect(0, 43824, '\p{Is_Block=_	Ethiopic_extended_A}', "");
    Expect(1, 43824, '\p{^Is_Block=_	Ethiopic_extended_A}', "");
    Expect(1, 43824, '\P{Is_Block=_	Ethiopic_extended_A}', "");
    Expect(0, 43824, '\P{^Is_Block=_	Ethiopic_extended_A}', "");
    Error('\p{Is_Blk=:=ethiopic_Ext_a}');
    Error('\P{Is_Blk=:=ethiopic_Ext_a}');
    Expect(1, 43823, '\p{Is_Blk:   ethiopicexta}', "");
    Expect(0, 43823, '\p{^Is_Blk:   ethiopicexta}', "");
    Expect(0, 43823, '\P{Is_Blk:   ethiopicexta}', "");
    Expect(1, 43823, '\P{^Is_Blk:   ethiopicexta}', "");
    Expect(0, 43824, '\p{Is_Blk:   ethiopicexta}', "");
    Expect(1, 43824, '\p{^Is_Blk:   ethiopicexta}', "");
    Expect(1, 43824, '\P{Is_Blk:   ethiopicexta}', "");
    Expect(0, 43824, '\P{^Is_Blk:   ethiopicexta}', "");
    Expect(1, 43823, '\p{Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(0, 43823, '\p{^Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(0, 43823, '\P{Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(1, 43823, '\P{^Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(0, 43824, '\p{Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(1, 43824, '\p{^Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(1, 43824, '\P{Is_Blk=-	Ethiopic_Ext_a}', "");
    Expect(0, 43824, '\P{^Is_Blk=-	Ethiopic_Ext_a}', "");
    Error('\p{Block=/a/-	Ethiopic_Supplement}');
    Error('\P{Block=/a/-	Ethiopic_Supplement}');
    Expect(1, 5023, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(1, 5023, '\p{Block= ethiopic_supplement}', "");
    Expect(0, 5023, '\p{^Block= ethiopic_supplement}', "");
    Expect(0, 5023, '\P{Block= ethiopic_supplement}', "");
    Expect(1, 5023, '\P{^Block= ethiopic_supplement}', "");
    Expect(0, 5024, '\p{Block= ethiopic_supplement}', "");
    Expect(1, 5024, '\p{^Block= ethiopic_supplement}', "");
    Expect(1, 5024, '\P{Block= ethiopic_supplement}', "");
    Expect(0, 5024, '\P{^Block= ethiopic_supplement}', "");
    Error('\p{Blk=-_Ethiopic_SUP/a/}');
    Error('\P{Blk=-_Ethiopic_SUP/a/}');
    Expect(1, 5023, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(1, 5023, '\p{Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(1, 5023, '\p{Blk= _ETHIOPIC_SUP}', "");
    Expect(0, 5023, '\p{^Blk= _ETHIOPIC_SUP}', "");
    Expect(0, 5023, '\P{Blk= _ETHIOPIC_SUP}', "");
    Expect(1, 5023, '\P{^Blk= _ETHIOPIC_SUP}', "");
    Expect(0, 5024, '\p{Blk= _ETHIOPIC_SUP}', "");
    Expect(1, 5024, '\p{^Blk= _ETHIOPIC_SUP}', "");
    Expect(1, 5024, '\P{Blk= _ETHIOPIC_SUP}', "");
    Expect(0, 5024, '\P{^Blk= _ETHIOPIC_SUP}', "");
    Error('\p{Is_Block: /a/--ethiopic_SUPPLEMENT}');
    Error('\P{Is_Block: /a/--ethiopic_SUPPLEMENT}');
    Expect(1, 5023, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Is_Block=-_Ethiopic_supplement}', "");
    Expect(0, 5023, '\p{^Is_Block=-_Ethiopic_supplement}', "");
    Expect(0, 5023, '\P{Is_Block=-_Ethiopic_supplement}', "");
    Expect(1, 5023, '\P{^Is_Block=-_Ethiopic_supplement}', "");
    Expect(0, 5024, '\p{Is_Block=-_Ethiopic_supplement}', "");
    Expect(1, 5024, '\p{^Is_Block=-_Ethiopic_supplement}', "");
    Expect(1, 5024, '\P{Is_Block=-_Ethiopic_supplement}', "");
    Expect(0, 5024, '\P{^Is_Block=-_Ethiopic_supplement}', "");
    Error('\p{Is_Blk= :=Ethiopic_sup}');
    Error('\P{Is_Blk= :=Ethiopic_sup}');
    Expect(1, 5023, '\p{Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Is_Blk=  ethiopic_SUP}', "");
    Expect(0, 5023, '\p{^Is_Blk=  ethiopic_SUP}', "");
    Expect(0, 5023, '\P{Is_Blk=  ethiopic_SUP}', "");
    Expect(1, 5023, '\P{^Is_Blk=  ethiopic_SUP}', "");
    Expect(0, 5024, '\p{Is_Blk=  ethiopic_SUP}', "");
    Expect(1, 5024, '\p{^Is_Blk=  ethiopic_SUP}', "");
    Expect(1, 5024, '\P{Is_Blk=  ethiopic_SUP}', "");
    Expect(0, 5024, '\P{^Is_Blk=  ethiopic_SUP}', "");
    Error('\p{Block=-:=Geometric_shapes}');
    Error('\P{Block=-:=Geometric_shapes}');
    Expect(1, 9727, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Block=_Geometric_SHAPES}', "");
    Expect(0, 9727, '\p{^Block=_Geometric_SHAPES}', "");
    Expect(0, 9727, '\P{Block=_Geometric_SHAPES}', "");
    Expect(1, 9727, '\P{^Block=_Geometric_SHAPES}', "");
    Expect(0, 9728, '\p{Block=_Geometric_SHAPES}', "");
    Expect(1, 9728, '\p{^Block=_Geometric_SHAPES}', "");
    Expect(1, 9728, '\P{Block=_Geometric_SHAPES}', "");
    Expect(0, 9728, '\P{^Block=_Geometric_SHAPES}', "");
    Error('\p{Blk=:=	_geometric_Shapes}');
    Error('\P{Blk=:=	_geometric_Shapes}');
    Expect(1, 9727, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Blk:--GEOMETRIC_SHAPES}', "");
    Expect(0, 9727, '\p{^Blk:--GEOMETRIC_SHAPES}', "");
    Expect(0, 9727, '\P{Blk:--GEOMETRIC_SHAPES}', "");
    Expect(1, 9727, '\P{^Blk:--GEOMETRIC_SHAPES}', "");
    Expect(0, 9728, '\p{Blk:--GEOMETRIC_SHAPES}', "");
    Expect(1, 9728, '\p{^Blk:--GEOMETRIC_SHAPES}', "");
    Expect(1, 9728, '\P{Blk:--GEOMETRIC_SHAPES}', "");
    Expect(0, 9728, '\P{^Blk:--GEOMETRIC_SHAPES}', "");
    Error('\p{Is_Block=:=	-Geometric_SHAPES}');
    Error('\P{Is_Block=:=	-Geometric_SHAPES}');
    Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Block=	geometric_SHAPES}', "");
    Expect(0, 9727, '\p{^Is_Block=	geometric_SHAPES}', "");
    Expect(0, 9727, '\P{Is_Block=	geometric_SHAPES}', "");
    Expect(1, 9727, '\P{^Is_Block=	geometric_SHAPES}', "");
    Expect(0, 9728, '\p{Is_Block=	geometric_SHAPES}', "");
    Expect(1, 9728, '\p{^Is_Block=	geometric_SHAPES}', "");
    Expect(1, 9728, '\P{Is_Block=	geometric_SHAPES}', "");
    Expect(0, 9728, '\P{^Is_Block=	geometric_SHAPES}', "");
    Error('\p{Is_Blk=_-Geometric_shapes/a/}');
    Error('\P{Is_Blk=_-Geometric_shapes/a/}');
    Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Blk: Geometric_shapes}', "");
    Expect(0, 9727, '\p{^Is_Blk: Geometric_shapes}', "");
    Expect(0, 9727, '\P{Is_Blk: Geometric_shapes}', "");
    Expect(1, 9727, '\P{^Is_Blk: Geometric_shapes}', "");
    Expect(0, 9728, '\p{Is_Blk: Geometric_shapes}', "");
    Expect(1, 9728, '\p{^Is_Blk: Geometric_shapes}', "");
    Expect(1, 9728, '\P{Is_Blk: Geometric_shapes}', "");
    Expect(0, 9728, '\P{^Is_Blk: Geometric_shapes}', "");
    Error('\p{Block=geometric_shapes_Extended/a/}');
    Error('\P{Block=geometric_shapes_Extended/a/}');
    Expect(1, 129023, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(1, 129023, '\p{Block:   geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Block:   geometricshapesextended}', "");
    Expect(0, 129023, '\P{Block:   geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Block:   geometricshapesextended}', "");
    Expect(0, 129024, '\p{Block:   geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Block:   geometricshapesextended}', "");
    Expect(1, 129024, '\P{Block:   geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Block:   geometricshapesextended}', "");
    Expect(1, 129023, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(1, 129023, '\p{Block=	-geometric_shapes_EXTENDED}', "");
    Expect(0, 129023, '\p{^Block=	-geometric_shapes_EXTENDED}', "");
    Expect(0, 129023, '\P{Block=	-geometric_shapes_EXTENDED}', "");
    Expect(1, 129023, '\P{^Block=	-geometric_shapes_EXTENDED}', "");
    Expect(0, 129024, '\p{Block=	-geometric_shapes_EXTENDED}', "");
    Expect(1, 129024, '\p{^Block=	-geometric_shapes_EXTENDED}', "");
    Expect(1, 129024, '\P{Block=	-geometric_shapes_EXTENDED}', "");
    Expect(0, 129024, '\P{^Block=	-geometric_shapes_EXTENDED}', "");
    Error('\p{Blk=_Geometric_SHAPES_Ext/a/}');
    Error('\P{Blk=_Geometric_SHAPES_Ext/a/}');
    Expect(1, 129023, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(1, 129023, '\p{Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(1, 129023, '\p{Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129023, '\p{^Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129023, '\P{Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(1, 129023, '\P{^Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129024, '\p{Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(1, 129024, '\p{^Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(1, 129024, '\P{Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129024, '\P{^Blk:	_GEOMETRIC_Shapes_Ext}', "");
    Error('\p{Is_Block:-	GEOMETRIC_Shapes_EXTENDED:=}');
    Error('\P{Is_Block:-	GEOMETRIC_Shapes_EXTENDED:=}');
    Expect(1, 129023, '\p{Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(0, 129023, '\p{^Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(0, 129023, '\P{Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(1, 129023, '\P{^Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(0, 129024, '\p{Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(1, 129024, '\p{^Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(1, 129024, '\P{Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Expect(0, 129024, '\P{^Is_Block=-	geometric_Shapes_EXTENDED}', "");
    Error('\p{Is_Blk=/a/Geometric_Shapes_Ext}');
    Error('\P{Is_Blk=/a/Geometric_Shapes_Ext}');
    Expect(1, 129023, '\p{Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(0, 129023, '\p{^Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(0, 129023, '\P{Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(1, 129023, '\P{^Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(0, 129024, '\p{Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(1, 129024, '\p{^Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(1, 129024, '\P{Is_Blk=_-Geometric_Shapes_ext}', "");
    Expect(0, 129024, '\P{^Is_Blk=_-Geometric_Shapes_ext}', "");
    Error('\p{Block=	GEORGIAN/a/}');
    Error('\P{Block=	GEORGIAN/a/}');
    Expect(1, 4351, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=georgian}', "");
    Expect(0, 4351, '\p{^Block=georgian}', "");
    Expect(0, 4351, '\P{Block=georgian}', "");
    Expect(1, 4351, '\P{^Block=georgian}', "");
    Expect(0, 4352, '\p{Block=georgian}', "");
    Expect(1, 4352, '\p{^Block=georgian}', "");
    Expect(1, 4352, '\P{Block=georgian}', "");
    Expect(0, 4352, '\P{^Block=georgian}', "");
    Expect(1, 4351, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=-_Georgian}', "");
    Expect(0, 4351, '\p{^Block=-_Georgian}', "");
    Expect(0, 4351, '\P{Block=-_Georgian}', "");
    Expect(1, 4351, '\P{^Block=-_Georgian}', "");
    Expect(0, 4352, '\p{Block=-_Georgian}', "");
    Expect(1, 4352, '\p{^Block=-_Georgian}', "");
    Expect(1, 4352, '\P{Block=-_Georgian}', "");
    Expect(0, 4352, '\P{^Block=-_Georgian}', "");
    Error('\p{Blk= /a/GEORGIAN}');
    Error('\P{Blk= /a/GEORGIAN}');
    Expect(1, 4351, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=georgian}', "");
    Expect(0, 4351, '\p{^Blk=georgian}', "");
    Expect(0, 4351, '\P{Blk=georgian}', "");
    Expect(1, 4351, '\P{^Blk=georgian}', "");
    Expect(0, 4352, '\p{Blk=georgian}', "");
    Expect(1, 4352, '\p{^Blk=georgian}', "");
    Expect(1, 4352, '\P{Blk=georgian}', "");
    Expect(0, 4352, '\P{^Blk=georgian}', "");
    Expect(1, 4351, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=_Georgian}', "");
    Expect(0, 4351, '\p{^Blk=_Georgian}', "");
    Expect(0, 4351, '\P{Blk=_Georgian}', "");
    Expect(1, 4351, '\P{^Blk=_Georgian}', "");
    Expect(0, 4352, '\p{Blk=_Georgian}', "");
    Expect(1, 4352, '\p{^Blk=_Georgian}', "");
    Expect(1, 4352, '\P{Blk=_Georgian}', "");
    Expect(0, 4352, '\P{^Blk=_Georgian}', "");
    Error('\p{Is_Block=:=	GEORGIAN}');
    Error('\P{Is_Block=:=	GEORGIAN}');
    Expect(1, 4351, '\p{Is_Block: georgian}', "");
    Expect(0, 4351, '\p{^Is_Block: georgian}', "");
    Expect(0, 4351, '\P{Is_Block: georgian}', "");
    Expect(1, 4351, '\P{^Is_Block: georgian}', "");
    Expect(0, 4352, '\p{Is_Block: georgian}', "");
    Expect(1, 4352, '\p{^Is_Block: georgian}', "");
    Expect(1, 4352, '\P{Is_Block: georgian}', "");
    Expect(0, 4352, '\P{^Is_Block: georgian}', "");
    Expect(1, 4351, '\p{Is_Block=_Georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=_Georgian}', "");
    Expect(0, 4351, '\P{Is_Block=_Georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=_Georgian}', "");
    Expect(0, 4352, '\p{Is_Block=_Georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=_Georgian}', "");
    Expect(1, 4352, '\P{Is_Block=_Georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=_Georgian}', "");
    Error('\p{Is_Blk: /a/_-georgian}');
    Error('\P{Is_Blk: /a/_-georgian}');
    Expect(1, 4351, '\p{Is_Blk=georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
    Expect(0, 4351, '\P{Is_Blk=georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
    Expect(0, 4352, '\p{Is_Blk=georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk=georgian}', "");
    Expect(1, 4352, '\P{Is_Blk=georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk=georgian}', "");
    Expect(1, 4351, '\p{Is_Blk=--georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk=--georgian}', "");
    Expect(0, 4351, '\P{Is_Blk=--georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk=--georgian}', "");
    Expect(0, 4352, '\p{Is_Blk=--georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk=--georgian}', "");
    Expect(1, 4352, '\P{Is_Blk=--georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk=--georgian}', "");
    Error('\p{Block:	/a/Georgian_Extended}');
    Error('\P{Block:	/a/Georgian_Extended}');
    Expect(1, 7359, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(1, 7359, '\p{Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Block=georgianextended}', "");
    Expect(0, 7359, '\P{Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Block=georgianextended}', "");
    Expect(0, 7360, '\p{Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Block=georgianextended}', "");
    Expect(1, 7360, '\P{Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Block=georgianextended}', "");
    Expect(1, 7359, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(1, 7359, '\p{Block=- Georgian_EXTENDED}', "");
    Expect(0, 7359, '\p{^Block=- Georgian_EXTENDED}', "");
    Expect(0, 7359, '\P{Block=- Georgian_EXTENDED}', "");
    Expect(1, 7359, '\P{^Block=- Georgian_EXTENDED}', "");
    Expect(0, 7360, '\p{Block=- Georgian_EXTENDED}', "");
    Expect(1, 7360, '\p{^Block=- Georgian_EXTENDED}', "");
    Expect(1, 7360, '\P{Block=- Georgian_EXTENDED}', "");
    Expect(0, 7360, '\P{^Block=- Georgian_EXTENDED}', "");
    Error('\p{Blk=-_Georgian_EXT:=}');
    Error('\P{Blk=-_Georgian_EXT:=}');
    Expect(1, 7359, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(1, 7359, '\p{Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Blk=georgianext}', "");
    Expect(0, 7359, '\P{Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Blk=georgianext}', "");
    Expect(0, 7360, '\p{Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Blk=georgianext}', "");
    Expect(1, 7360, '\P{Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Blk=georgianext}', "");
    Expect(1, 7359, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(1, 7359, '\p{Blk=-	Georgian_Ext}', "");
    Expect(0, 7359, '\p{^Blk=-	Georgian_Ext}', "");
    Expect(0, 7359, '\P{Blk=-	Georgian_Ext}', "");
    Expect(1, 7359, '\P{^Blk=-	Georgian_Ext}', "");
    Expect(0, 7360, '\p{Blk=-	Georgian_Ext}', "");
    Expect(1, 7360, '\p{^Blk=-	Georgian_Ext}', "");
    Expect(1, 7360, '\P{Blk=-	Georgian_Ext}', "");
    Expect(0, 7360, '\P{^Blk=-	Georgian_Ext}', "");
    Error('\p{Is_Block=_	GEORGIAN_extended:=}');
    Error('\P{Is_Block=_	GEORGIAN_extended:=}');
    Expect(1, 7359, '\p{Is_Block:georgianextended}', "");
    Expect(0, 7359, '\p{^Is_Block:georgianextended}', "");
    Expect(0, 7359, '\P{Is_Block:georgianextended}', "");
    Expect(1, 7359, '\P{^Is_Block:georgianextended}', "");
    Expect(0, 7360, '\p{Is_Block:georgianextended}', "");
    Expect(1, 7360, '\p{^Is_Block:georgianextended}', "");
    Expect(1, 7360, '\P{Is_Block:georgianextended}', "");
    Expect(0, 7360, '\P{^Is_Block:georgianextended}', "");
    Expect(1, 7359, '\p{Is_Block=	_georgian_EXTENDED}', "");
    Expect(0, 7359, '\p{^Is_Block=	_georgian_EXTENDED}', "");
    Expect(0, 7359, '\P{Is_Block=	_georgian_EXTENDED}', "");
    Expect(1, 7359, '\P{^Is_Block=	_georgian_EXTENDED}', "");
    Expect(0, 7360, '\p{Is_Block=	_georgian_EXTENDED}', "");
    Expect(1, 7360, '\p{^Is_Block=	_georgian_EXTENDED}', "");
    Expect(1, 7360, '\P{Is_Block=	_georgian_EXTENDED}', "");
    Expect(0, 7360, '\P{^Is_Block=	_georgian_EXTENDED}', "");
    Error('\p{Is_Blk:   /a/-Georgian_Ext}');
    Error('\P{Is_Blk:   /a/-Georgian_Ext}');
    Expect(1, 7359, '\p{Is_Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Is_Blk=georgianext}', "");
    Expect(0, 7359, '\P{Is_Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Is_Blk=georgianext}', "");
    Expect(0, 7360, '\p{Is_Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Is_Blk=georgianext}', "");
    Expect(1, 7360, '\P{Is_Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Is_Blk=georgianext}', "");
    Expect(1, 7359, '\p{Is_Blk=  GEORGIAN_ext}', "");
    Expect(0, 7359, '\p{^Is_Blk=  GEORGIAN_ext}', "");
    Expect(0, 7359, '\P{Is_Blk=  GEORGIAN_ext}', "");
    Expect(1, 7359, '\P{^Is_Blk=  GEORGIAN_ext}', "");
    Expect(0, 7360, '\p{Is_Blk=  GEORGIAN_ext}', "");
    Expect(1, 7360, '\p{^Is_Blk=  GEORGIAN_ext}', "");
    Expect(1, 7360, '\P{Is_Blk=  GEORGIAN_ext}', "");
    Expect(0, 7360, '\P{^Is_Blk=  GEORGIAN_ext}', "");
    Error('\p{Block=_-Georgian_supplement:=}');
    Error('\P{Block=_-Georgian_supplement:=}');
    Expect(1, 11567, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(1, 11567, '\p{Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(1, 11567, '\p{Block=	-georgian_SUPPLEMENT}', "");
    Expect(0, 11567, '\p{^Block=	-georgian_SUPPLEMENT}', "");
    Expect(0, 11567, '\P{Block=	-georgian_SUPPLEMENT}', "");
    Expect(1, 11567, '\P{^Block=	-georgian_SUPPLEMENT}', "");
    Expect(0, 11568, '\p{Block=	-georgian_SUPPLEMENT}', "");
    Expect(1, 11568, '\p{^Block=	-georgian_SUPPLEMENT}', "");
    Expect(1, 11568, '\P{Block=	-georgian_SUPPLEMENT}', "");
    Expect(0, 11568, '\P{^Block=	-georgian_SUPPLEMENT}', "");
    Error('\p{Blk=:= 	GEORGIAN_Sup}');
    Error('\P{Blk=:= 	GEORGIAN_Sup}');
    Expect(1, 11567, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(1, 11567, '\p{Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(1, 11567, '\p{Blk=-georgian_sup}', "");
    Expect(0, 11567, '\p{^Blk=-georgian_sup}', "");
    Expect(0, 11567, '\P{Blk=-georgian_sup}', "");
    Expect(1, 11567, '\P{^Blk=-georgian_sup}', "");
    Expect(0, 11568, '\p{Blk=-georgian_sup}', "");
    Expect(1, 11568, '\p{^Blk=-georgian_sup}', "");
    Expect(1, 11568, '\P{Blk=-georgian_sup}', "");
    Expect(0, 11568, '\P{^Blk=-georgian_sup}', "");
    Error('\p{Is_Block=- GEORGIAN_SUPPLEMENT/a/}');
    Error('\P{Is_Block=- GEORGIAN_SUPPLEMENT/a/}');
    Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Is_Block=  GEORGIAN_Supplement}', "");
    Expect(0, 11567, '\p{^Is_Block=  GEORGIAN_Supplement}', "");
    Expect(0, 11567, '\P{Is_Block=  GEORGIAN_Supplement}', "");
    Expect(1, 11567, '\P{^Is_Block=  GEORGIAN_Supplement}', "");
    Expect(0, 11568, '\p{Is_Block=  GEORGIAN_Supplement}', "");
    Expect(1, 11568, '\p{^Is_Block=  GEORGIAN_Supplement}', "");
    Expect(1, 11568, '\P{Is_Block=  GEORGIAN_Supplement}', "");
    Expect(0, 11568, '\P{^Is_Block=  GEORGIAN_Supplement}', "");
    Error('\p{Is_Blk=_:=georgian_Sup}');
    Error('\P{Is_Blk=_:=georgian_Sup}');
    Expect(1, 11567, '\p{Is_Blk:   georgiansup}', "");
    Expect(0, 11567, '\p{^Is_Blk:   georgiansup}', "");
    Expect(0, 11567, '\P{Is_Blk:   georgiansup}', "");
    Expect(1, 11567, '\P{^Is_Blk:   georgiansup}', "");
    Expect(0, 11568, '\p{Is_Blk:   georgiansup}', "");
    Expect(1, 11568, '\p{^Is_Blk:   georgiansup}', "");
    Expect(1, 11568, '\P{Is_Blk:   georgiansup}', "");
    Expect(0, 11568, '\P{^Is_Blk:   georgiansup}', "");
    Expect(1, 11567, '\p{Is_Blk= _GEORGIAN_Sup}', "");
    Expect(0, 11567, '\p{^Is_Blk= _GEORGIAN_Sup}', "");
    Expect(0, 11567, '\P{Is_Blk= _GEORGIAN_Sup}', "");
    Expect(1, 11567, '\P{^Is_Blk= _GEORGIAN_Sup}', "");
    Expect(0, 11568, '\p{Is_Blk= _GEORGIAN_Sup}', "");
    Expect(1, 11568, '\p{^Is_Blk= _GEORGIAN_Sup}', "");
    Expect(1, 11568, '\P{Is_Blk= _GEORGIAN_Sup}', "");
    Expect(0, 11568, '\P{^Is_Blk= _GEORGIAN_Sup}', "");
    Error('\p{Block=-_Glagolitic:=}');
    Error('\P{Block=-_Glagolitic:=}');
    Expect(1, 11359, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Block=glagolitic}', "");
    Expect(0, 11359, '\P{Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Block=glagolitic}', "");
    Expect(0, 11360, '\p{Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Block=glagolitic}', "");
    Expect(1, 11360, '\P{Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Block=glagolitic}', "");
    Expect(1, 11359, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block:   __Glagolitic}', "");
    Expect(0, 11359, '\p{^Block:   __Glagolitic}', "");
    Expect(0, 11359, '\P{Block:   __Glagolitic}', "");
    Expect(1, 11359, '\P{^Block:   __Glagolitic}', "");
    Expect(0, 11360, '\p{Block:   __Glagolitic}', "");
    Expect(1, 11360, '\p{^Block:   __Glagolitic}', "");
    Expect(1, 11360, '\P{Block:   __Glagolitic}', "");
    Expect(0, 11360, '\P{^Block:   __Glagolitic}', "");
    Error('\p{Blk=-	GLAGOLITIC/a/}');
    Error('\P{Blk=-	GLAGOLITIC/a/}');
    Expect(1, 11359, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=-Glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=-Glagolitic}', "");
    Expect(0, 11359, '\P{Blk=-Glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=-Glagolitic}', "");
    Expect(0, 11360, '\p{Blk=-Glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=-Glagolitic}', "");
    Expect(1, 11360, '\P{Blk=-Glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=-Glagolitic}', "");
    Error('\p{Is_Block=_/a/glagolitic}');
    Error('\P{Is_Block=_/a/glagolitic}');
    Expect(1, 11359, '\p{Is_Block:	glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block:	glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block:	glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block:	glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block:	glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block:	glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block:	glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block:	glagolitic}', "");
    Expect(1, 11359, '\p{Is_Block= Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block= Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block= Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block= Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block= Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block= Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block= Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block= Glagolitic}', "");
    Error('\p{Is_Blk=	GLAGOLITIC:=}');
    Error('\P{Is_Blk=	GLAGOLITIC:=}');
    Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Blk= Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk= Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk= Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk= Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk= Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk= Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk= Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk= Glagolitic}', "");
    Error('\p{Block=Glagolitic_Supplement/a/}');
    Error('\P{Block=Glagolitic_Supplement/a/}');
    Expect(1, 122927, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(1, 122927, '\p{Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(1, 122927, '\p{Block=__Glagolitic_Supplement}', "");
    Expect(0, 122927, '\p{^Block=__Glagolitic_Supplement}', "");
    Expect(0, 122927, '\P{Block=__Glagolitic_Supplement}', "");
    Expect(1, 122927, '\P{^Block=__Glagolitic_Supplement}', "");
    Expect(0, 122928, '\p{Block=__Glagolitic_Supplement}', "");
    Expect(1, 122928, '\p{^Block=__Glagolitic_Supplement}', "");
    Expect(1, 122928, '\P{Block=__Glagolitic_Supplement}', "");
    Expect(0, 122928, '\P{^Block=__Glagolitic_Supplement}', "");
    Error('\p{Blk=:=		Glagolitic_Sup}');
    Error('\P{Blk=:=		Glagolitic_Sup}');
    Expect(1, 122927, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(1, 122927, '\p{Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(1, 122927, '\p{Blk=	Glagolitic_Sup}', "");
    Expect(0, 122927, '\p{^Blk=	Glagolitic_Sup}', "");
    Expect(0, 122927, '\P{Blk=	Glagolitic_Sup}', "");
    Expect(1, 122927, '\P{^Blk=	Glagolitic_Sup}', "");
    Expect(0, 122928, '\p{Blk=	Glagolitic_Sup}', "");
    Expect(1, 122928, '\p{^Blk=	Glagolitic_Sup}', "");
    Expect(1, 122928, '\P{Blk=	Glagolitic_Sup}', "");
    Expect(0, 122928, '\P{^Blk=	Glagolitic_Sup}', "");
    Error('\p{Is_Block=Glagolitic_SUPPLEMENT:=}');
    Error('\P{Is_Block=Glagolitic_SUPPLEMENT:=}');
    Expect(1, 122927, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(0, 122927, '\p{^Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(0, 122927, '\P{Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(1, 122927, '\P{^Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(0, 122928, '\p{Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(1, 122928, '\p{^Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(1, 122928, '\P{Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Expect(0, 122928, '\P{^Is_Block:   -glagolitic_SUPPLEMENT}', "");
    Error('\p{Is_Blk=/a/GLAGOLITIC_SUP}');
    Error('\P{Is_Blk=/a/GLAGOLITIC_SUP}');
    Expect(1, 122927, '\p{Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Is_Blk=-Glagolitic_sup}', "");
    Expect(0, 122927, '\p{^Is_Blk=-Glagolitic_sup}', "");
    Expect(0, 122927, '\P{Is_Blk=-Glagolitic_sup}', "");
    Expect(1, 122927, '\P{^Is_Blk=-Glagolitic_sup}', "");
    Expect(0, 122928, '\p{Is_Blk=-Glagolitic_sup}', "");
    Expect(1, 122928, '\p{^Is_Blk=-Glagolitic_sup}', "");
    Expect(1, 122928, '\P{Is_Blk=-Glagolitic_sup}', "");
    Expect(0, 122928, '\P{^Is_Blk=-Glagolitic_sup}', "");
    Error('\p{Block=		Gothic:=}');
    Error('\P{Block=		Gothic:=}');
    Expect(1, 66383, '\p{Block=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Block=gothic}', "");
    Expect(0, 66383, '\p{^Block=gothic}', "");
    Expect(0, 66383, '\P{Block=gothic}', "");
    Expect(1, 66383, '\P{^Block=gothic}', "");
    Expect(0, 66384, '\p{Block=gothic}', "");
    Expect(1, 66384, '\p{^Block=gothic}', "");
    Expect(1, 66384, '\P{Block=gothic}', "");
    Expect(0, 66384, '\P{^Block=gothic}', "");
    Expect(1, 66383, '\p{Block=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Block=_Gothic}', "");
    Expect(0, 66383, '\p{^Block=_Gothic}', "");
    Expect(0, 66383, '\P{Block=_Gothic}', "");
    Expect(1, 66383, '\P{^Block=_Gothic}', "");
    Expect(0, 66384, '\p{Block=_Gothic}', "");
    Expect(1, 66384, '\p{^Block=_Gothic}', "");
    Expect(1, 66384, '\P{Block=_Gothic}', "");
    Expect(0, 66384, '\P{^Block=_Gothic}', "");
    Error('\p{Blk=:=-Gothic}');
    Error('\P{Blk=:=-Gothic}');
    Expect(1, 66383, '\p{Blk=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Blk=gothic}', "");
    Expect(0, 66383, '\p{^Blk=gothic}', "");
    Expect(0, 66383, '\P{Blk=gothic}', "");
    Expect(1, 66383, '\P{^Blk=gothic}', "");
    Expect(0, 66384, '\p{Blk=gothic}', "");
    Expect(1, 66384, '\p{^Blk=gothic}', "");
    Expect(1, 66384, '\P{Blk=gothic}', "");
    Expect(0, 66384, '\P{^Blk=gothic}', "");
    Expect(1, 66383, '\p{Blk=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Blk=	Gothic}', "");
    Expect(0, 66383, '\p{^Blk=	Gothic}', "");
    Expect(0, 66383, '\P{Blk=	Gothic}', "");
    Expect(1, 66383, '\P{^Blk=	Gothic}', "");
    Expect(0, 66384, '\p{Blk=	Gothic}', "");
    Expect(1, 66384, '\p{^Blk=	Gothic}', "");
    Expect(1, 66384, '\P{Blk=	Gothic}', "");
    Expect(0, 66384, '\P{^Blk=	Gothic}', "");
    Error('\p{Is_Block=	_Gothic/a/}');
    Error('\P{Is_Block=	_Gothic/a/}');
    Expect(1, 66383, '\p{Is_Block: gothic}', "");
    Expect(0, 66383, '\p{^Is_Block: gothic}', "");
    Expect(0, 66383, '\P{Is_Block: gothic}', "");
    Expect(1, 66383, '\P{^Is_Block: gothic}', "");
    Expect(0, 66384, '\p{Is_Block: gothic}', "");
    Expect(1, 66384, '\p{^Is_Block: gothic}', "");
    Expect(1, 66384, '\P{Is_Block: gothic}', "");
    Expect(0, 66384, '\P{^Is_Block: gothic}', "");
    Expect(1, 66383, '\p{Is_Block=	 gothic}', "");
    Expect(0, 66383, '\p{^Is_Block=	 gothic}', "");
    Expect(0, 66383, '\P{Is_Block=	 gothic}', "");
    Expect(1, 66383, '\P{^Is_Block=	 gothic}', "");
    Expect(0, 66384, '\p{Is_Block=	 gothic}', "");
    Expect(1, 66384, '\p{^Is_Block=	 gothic}', "");
    Expect(1, 66384, '\P{Is_Block=	 gothic}', "");
    Expect(0, 66384, '\P{^Is_Block=	 gothic}', "");
    Error('\p{Is_Blk=:=-gothic}');
    Error('\P{Is_Blk=:=-gothic}');
    Expect(1, 66383, '\p{Is_Blk=gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=gothic}', "");
    Expect(1, 66383, '\p{Is_Blk=		Gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=		Gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=		Gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=		Gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=		Gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=		Gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=		Gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=		Gothic}', "");
    Error('\p{Block=/a/__GRANTHA}');
    Error('\P{Block=/a/__GRANTHA}');
    Expect(1, 70527, '\p{Block=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=grantha}', "");
    Expect(0, 70527, '\p{^Block=grantha}', "");
    Expect(0, 70527, '\P{Block=grantha}', "");
    Expect(1, 70527, '\P{^Block=grantha}', "");
    Expect(0, 70528, '\p{Block=grantha}', "");
    Expect(1, 70528, '\p{^Block=grantha}', "");
    Expect(1, 70528, '\P{Block=grantha}', "");
    Expect(0, 70528, '\P{^Block=grantha}', "");
    Expect(1, 70527, '\p{Block=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=_	Grantha}', "");
    Expect(0, 70527, '\p{^Block=_	Grantha}', "");
    Expect(0, 70527, '\P{Block=_	Grantha}', "");
    Expect(1, 70527, '\P{^Block=_	Grantha}', "");
    Expect(0, 70528, '\p{Block=_	Grantha}', "");
    Expect(1, 70528, '\p{^Block=_	Grantha}', "");
    Expect(1, 70528, '\P{Block=_	Grantha}', "");
    Expect(0, 70528, '\P{^Block=_	Grantha}', "");
    Error('\p{Blk=--Grantha/a/}');
    Error('\P{Blk=--Grantha/a/}');
    Expect(1, 70527, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk: grantha}', "");
    Expect(0, 70527, '\p{^Blk: grantha}', "");
    Expect(0, 70527, '\P{Blk: grantha}', "");
    Expect(1, 70527, '\P{^Blk: grantha}', "");
    Expect(0, 70528, '\p{Blk: grantha}', "");
    Expect(1, 70528, '\p{^Blk: grantha}', "");
    Expect(1, 70528, '\P{Blk: grantha}', "");
    Expect(0, 70528, '\P{^Blk: grantha}', "");
    Expect(1, 70527, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk=-_Grantha}', "");
    Expect(0, 70527, '\p{^Blk=-_Grantha}', "");
    Expect(0, 70527, '\P{Blk=-_Grantha}', "");
    Expect(1, 70527, '\P{^Blk=-_Grantha}', "");
    Expect(0, 70528, '\p{Blk=-_Grantha}', "");
    Expect(1, 70528, '\p{^Blk=-_Grantha}', "");
    Expect(1, 70528, '\P{Blk=-_Grantha}', "");
    Expect(0, 70528, '\P{^Blk=-_Grantha}', "");
    Error('\p{Is_Block:	/a/ 	Grantha}');
    Error('\P{Is_Block:	/a/ 	Grantha}');
    Expect(1, 70527, '\p{Is_Block=grantha}', "");
    Expect(0, 70527, '\p{^Is_Block=grantha}', "");
    Expect(0, 70527, '\P{Is_Block=grantha}', "");
    Expect(1, 70527, '\P{^Is_Block=grantha}', "");
    Expect(0, 70528, '\p{Is_Block=grantha}', "");
    Expect(1, 70528, '\p{^Is_Block=grantha}', "");
    Expect(1, 70528, '\P{Is_Block=grantha}', "");
    Expect(0, 70528, '\P{^Is_Block=grantha}', "");
    Expect(1, 70527, '\p{Is_Block=-	Grantha}', "");
    Expect(0, 70527, '\p{^Is_Block=-	Grantha}', "");
    Expect(0, 70527, '\P{Is_Block=-	Grantha}', "");
    Expect(1, 70527, '\P{^Is_Block=-	Grantha}', "");
    Expect(0, 70528, '\p{Is_Block=-	Grantha}', "");
    Expect(1, 70528, '\p{^Is_Block=-	Grantha}', "");
    Expect(1, 70528, '\P{Is_Block=-	Grantha}', "");
    Expect(0, 70528, '\P{^Is_Block=-	Grantha}', "");
    Error('\p{Is_Blk=  Grantha:=}');
    Error('\P{Is_Blk=  Grantha:=}');
    Expect(1, 70527, '\p{Is_Blk=grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk=grantha}', "");
    Expect(0, 70527, '\P{Is_Blk=grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk=grantha}', "");
    Expect(0, 70528, '\p{Is_Blk=grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk=grantha}', "");
    Expect(1, 70528, '\P{Is_Blk=grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk=grantha}', "");
    Expect(1, 70527, '\p{Is_Blk=	 GRANTHA}', "");
    Expect(0, 70527, '\p{^Is_Blk=	 GRANTHA}', "");
    Expect(0, 70527, '\P{Is_Blk=	 GRANTHA}', "");
    Expect(1, 70527, '\P{^Is_Blk=	 GRANTHA}', "");
    Expect(0, 70528, '\p{Is_Blk=	 GRANTHA}', "");
    Expect(1, 70528, '\p{^Is_Blk=	 GRANTHA}', "");
    Expect(1, 70528, '\P{Is_Blk=	 GRANTHA}', "");
    Expect(0, 70528, '\P{^Is_Blk=	 GRANTHA}', "");
    Error('\p{Block=_GREEK_And_coptic:=}');
    Error('\P{Block=_GREEK_And_coptic:=}');
    Expect(1, 1023, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(1, 1023, '\p{Block=greekandcoptic}', "");
    Expect(0, 1023, '\p{^Block=greekandcoptic}', "");
    Expect(0, 1023, '\P{Block=greekandcoptic}', "");
    Expect(1, 1023, '\P{^Block=greekandcoptic}', "");
    Expect(0, 1024, '\p{Block=greekandcoptic}', "");
    Expect(1, 1024, '\p{^Block=greekandcoptic}', "");
    Expect(1, 1024, '\P{Block=greekandcoptic}', "");
    Expect(0, 1024, '\P{^Block=greekandcoptic}', "");
    Expect(1, 1023, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(1, 1023, '\p{Block= Greek_And_coptic}', "");
    Expect(0, 1023, '\p{^Block= Greek_And_coptic}', "");
    Expect(0, 1023, '\P{Block= Greek_And_coptic}', "");
    Expect(1, 1023, '\P{^Block= Greek_And_coptic}', "");
    Expect(0, 1024, '\p{Block= Greek_And_coptic}', "");
    Expect(1, 1024, '\p{^Block= Greek_And_coptic}', "");
    Expect(1, 1024, '\P{Block= Greek_And_coptic}', "");
    Expect(0, 1024, '\P{^Block= Greek_And_coptic}', "");
    Error('\p{Blk=:=- Greek}');
    Error('\P{Blk=:=- Greek}');
    Expect(1, 1023, '\p{Blk=:\AGreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\AGreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=greek}', "");
    Expect(0, 1023, '\p{^Blk=greek}', "");
    Expect(0, 1023, '\P{Blk=greek}', "");
    Expect(1, 1023, '\P{^Blk=greek}', "");
    Expect(0, 1024, '\p{Blk=greek}', "");
    Expect(1, 1024, '\p{^Blk=greek}', "");
    Expect(1, 1024, '\P{Blk=greek}', "");
    Expect(0, 1024, '\P{^Blk=greek}', "");
    Expect(1, 1023, '\p{Blk=:\Agreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\Agreek\z:}', "");;
    Expect(1, 1023, '\p{Blk= _GREEK}', "");
    Expect(0, 1023, '\p{^Blk= _GREEK}', "");
    Expect(0, 1023, '\P{Blk= _GREEK}', "");
    Expect(1, 1023, '\P{^Blk= _GREEK}', "");
    Expect(0, 1024, '\p{Blk= _GREEK}', "");
    Expect(1, 1024, '\p{^Blk= _GREEK}', "");
    Expect(1, 1024, '\P{Blk= _GREEK}', "");
    Expect(0, 1024, '\P{^Blk= _GREEK}', "");
    Error('\p{Is_Block: /a/greek_And_COPTIC}');
    Error('\P{Is_Block: /a/greek_And_COPTIC}');
    Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\p{Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\p{^Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\P{Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\P{^Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\p{Is_Block=-	greek_And_Coptic}', "");
    Expect(0, 1023, '\p{^Is_Block=-	greek_And_Coptic}', "");
    Expect(0, 1023, '\P{Is_Block=-	greek_And_Coptic}', "");
    Expect(1, 1023, '\P{^Is_Block=-	greek_And_Coptic}', "");
    Expect(0, 1024, '\p{Is_Block=-	greek_And_Coptic}', "");
    Expect(1, 1024, '\p{^Is_Block=-	greek_And_Coptic}', "");
    Expect(1, 1024, '\P{Is_Block=-	greek_And_Coptic}', "");
    Expect(0, 1024, '\P{^Is_Block=-	greek_And_Coptic}', "");
    Error('\p{Is_Blk:		greek/a/}');
    Error('\P{Is_Blk:		greek/a/}');
    Expect(1, 1023, '\p{Is_Blk: greek}', "");
    Expect(0, 1023, '\p{^Is_Blk: greek}', "");
    Expect(0, 1023, '\P{Is_Blk: greek}', "");
    Expect(1, 1023, '\P{^Is_Blk: greek}', "");
    Expect(0, 1024, '\p{Is_Blk: greek}', "");
    Expect(1, 1024, '\p{^Is_Blk: greek}', "");
    Expect(1, 1024, '\P{Is_Blk: greek}', "");
    Expect(0, 1024, '\P{^Is_Blk: greek}', "");
    Expect(1, 1023, '\p{Is_Blk=  Greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=  Greek}', "");
    Expect(0, 1023, '\P{Is_Blk=  Greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=  Greek}', "");
    Expect(0, 1024, '\p{Is_Blk=  Greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=  Greek}', "");
    Expect(1, 1024, '\P{Is_Blk=  Greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=  Greek}', "");
    Error('\p{Block= :=Greek_EXTENDED}');
    Error('\P{Block= :=Greek_EXTENDED}');
    Expect(1, 8191, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(1, 8191, '\p{Block=greekextended}', "");
    Expect(0, 8191, '\p{^Block=greekextended}', "");
    Expect(0, 8191, '\P{Block=greekextended}', "");
    Expect(1, 8191, '\P{^Block=greekextended}', "");
    Expect(0, 8192, '\p{Block=greekextended}', "");
    Expect(1, 8192, '\p{^Block=greekextended}', "");
    Expect(1, 8192, '\P{Block=greekextended}', "");
    Expect(0, 8192, '\P{^Block=greekextended}', "");
    Expect(1, 8191, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(1, 8191, '\p{Block=	 greek_EXTENDED}', "");
    Expect(0, 8191, '\p{^Block=	 greek_EXTENDED}', "");
    Expect(0, 8191, '\P{Block=	 greek_EXTENDED}', "");
    Expect(1, 8191, '\P{^Block=	 greek_EXTENDED}', "");
    Expect(0, 8192, '\p{Block=	 greek_EXTENDED}', "");
    Expect(1, 8192, '\p{^Block=	 greek_EXTENDED}', "");
    Expect(1, 8192, '\P{Block=	 greek_EXTENDED}', "");
    Expect(0, 8192, '\P{^Block=	 greek_EXTENDED}', "");
    Error('\p{Blk= -Greek_Ext/a/}');
    Error('\P{Blk= -Greek_Ext/a/}');
    Expect(1, 8191, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(1, 8191, '\p{Blk=greekext}', "");
    Expect(0, 8191, '\p{^Blk=greekext}', "");
    Expect(0, 8191, '\P{Blk=greekext}', "");
    Expect(1, 8191, '\P{^Blk=greekext}', "");
    Expect(0, 8192, '\p{Blk=greekext}', "");
    Expect(1, 8192, '\p{^Blk=greekext}', "");
    Expect(1, 8192, '\P{Blk=greekext}', "");
    Expect(0, 8192, '\P{^Blk=greekext}', "");
    Expect(1, 8191, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(1, 8191, '\p{Blk=-_Greek_ext}', "");
    Expect(0, 8191, '\p{^Blk=-_Greek_ext}', "");
    Expect(0, 8191, '\P{Blk=-_Greek_ext}', "");
    Expect(1, 8191, '\P{^Blk=-_Greek_ext}', "");
    Expect(0, 8192, '\p{Blk=-_Greek_ext}', "");
    Expect(1, 8192, '\p{^Blk=-_Greek_ext}', "");
    Expect(1, 8192, '\P{Blk=-_Greek_ext}', "");
    Expect(0, 8192, '\P{^Blk=-_Greek_ext}', "");
    Error('\p{Is_Block=:= Greek_extended}');
    Error('\P{Is_Block=:= Greek_extended}');
    Expect(1, 8191, '\p{Is_Block=greekextended}', "");
    Expect(0, 8191, '\p{^Is_Block=greekextended}', "");
    Expect(0, 8191, '\P{Is_Block=greekextended}', "");
    Expect(1, 8191, '\P{^Is_Block=greekextended}', "");
    Expect(0, 8192, '\p{Is_Block=greekextended}', "");
    Expect(1, 8192, '\p{^Is_Block=greekextended}', "");
    Expect(1, 8192, '\P{Is_Block=greekextended}', "");
    Expect(0, 8192, '\P{^Is_Block=greekextended}', "");
    Expect(1, 8191, '\p{Is_Block=_Greek_extended}', "");
    Expect(0, 8191, '\p{^Is_Block=_Greek_extended}', "");
    Expect(0, 8191, '\P{Is_Block=_Greek_extended}', "");
    Expect(1, 8191, '\P{^Is_Block=_Greek_extended}', "");
    Expect(0, 8192, '\p{Is_Block=_Greek_extended}', "");
    Expect(1, 8192, '\p{^Is_Block=_Greek_extended}', "");
    Expect(1, 8192, '\P{Is_Block=_Greek_extended}', "");
    Expect(0, 8192, '\P{^Is_Block=_Greek_extended}', "");
    Error('\p{Is_Blk=/a/GREEK_Ext}');
    Error('\P{Is_Blk=/a/GREEK_Ext}');
    Expect(1, 8191, '\p{Is_Blk=greekext}', "");
    Expect(0, 8191, '\p{^Is_Blk=greekext}', "");
    Expect(0, 8191, '\P{Is_Blk=greekext}', "");
    Expect(1, 8191, '\P{^Is_Blk=greekext}', "");
    Expect(0, 8192, '\p{Is_Blk=greekext}', "");
    Expect(1, 8192, '\p{^Is_Blk=greekext}', "");
    Expect(1, 8192, '\P{Is_Blk=greekext}', "");
    Expect(0, 8192, '\P{^Is_Blk=greekext}', "");
    Expect(1, 8191, '\p{Is_Blk:   	GREEK_ext}', "");
    Expect(0, 8191, '\p{^Is_Blk:   	GREEK_ext}', "");
    Expect(0, 8191, '\P{Is_Blk:   	GREEK_ext}', "");
    Expect(1, 8191, '\P{^Is_Blk:   	GREEK_ext}', "");
    Expect(0, 8192, '\p{Is_Blk:   	GREEK_ext}', "");
    Expect(1, 8192, '\p{^Is_Blk:   	GREEK_ext}', "");
    Expect(1, 8192, '\P{Is_Blk:   	GREEK_ext}', "");
    Expect(0, 8192, '\P{^Is_Blk:   	GREEK_ext}', "");
    Error('\p{Block=:=	_Gujarati}');
    Error('\P{Block=:=	_Gujarati}');
    Expect(1, 2815, '\p{Block=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=gujarati}', "");
    Expect(0, 2815, '\p{^Block=gujarati}', "");
    Expect(0, 2815, '\P{Block=gujarati}', "");
    Expect(1, 2815, '\P{^Block=gujarati}', "");
    Expect(0, 2816, '\p{Block=gujarati}', "");
    Expect(1, 2816, '\p{^Block=gujarati}', "");
    Expect(1, 2816, '\P{Block=gujarati}', "");
    Expect(0, 2816, '\P{^Block=gujarati}', "");
    Expect(1, 2815, '\p{Block=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=- gujarati}', "");
    Expect(0, 2815, '\p{^Block=- gujarati}', "");
    Expect(0, 2815, '\P{Block=- gujarati}', "");
    Expect(1, 2815, '\P{^Block=- gujarati}', "");
    Expect(0, 2816, '\p{Block=- gujarati}', "");
    Expect(1, 2816, '\p{^Block=- gujarati}', "");
    Expect(1, 2816, '\P{Block=- gujarati}', "");
    Expect(0, 2816, '\P{^Block=- gujarati}', "");
    Error('\p{Blk=--gujarati/a/}');
    Error('\P{Blk=--gujarati/a/}');
    Expect(1, 2815, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Blk=gujarati}', "");
    Expect(0, 2815, '\P{Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Blk=gujarati}', "");
    Expect(0, 2816, '\p{Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Blk=gujarati}', "");
    Expect(1, 2816, '\P{Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Blk=gujarati}', "");
    Expect(1, 2815, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=	-GUJARATI}', "");
    Expect(0, 2815, '\p{^Blk=	-GUJARATI}', "");
    Expect(0, 2815, '\P{Blk=	-GUJARATI}', "");
    Expect(1, 2815, '\P{^Blk=	-GUJARATI}', "");
    Expect(0, 2816, '\p{Blk=	-GUJARATI}', "");
    Expect(1, 2816, '\p{^Blk=	-GUJARATI}', "");
    Expect(1, 2816, '\P{Blk=	-GUJARATI}', "");
    Expect(0, 2816, '\P{^Blk=	-GUJARATI}', "");
    Error('\p{Is_Block=:=	Gujarati}');
    Error('\P{Is_Block=:=	Gujarati}');
    Expect(1, 2815, '\p{Is_Block=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block=gujarati}', "");
    Expect(0, 2815, '\P{Is_Block=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block=gujarati}', "");
    Expect(0, 2816, '\p{Is_Block=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block=gujarati}', "");
    Expect(1, 2816, '\P{Is_Block=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block=gujarati}', "");
    Error('\p{Is_Blk=:=	 GUJARATI}');
    Error('\P{Is_Blk=:=	 GUJARATI}');
    Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk=gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk=gujarati}', "");
    Expect(1, 2815, '\p{Is_Blk= Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk= Gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk= Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk= Gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk= Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk= Gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk= Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk= Gujarati}', "");
    Error('\p{Block=/a/  Gunjala_gondi}');
    Error('\P{Block=/a/  Gunjala_gondi}');
    Expect(1, 73135, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Block:	gunjalagondi}', "");
    Expect(0, 73135, '\p{^Block:	gunjalagondi}', "");
    Expect(0, 73135, '\P{Block:	gunjalagondi}', "");
    Expect(1, 73135, '\P{^Block:	gunjalagondi}', "");
    Expect(0, 73136, '\p{Block:	gunjalagondi}', "");
    Expect(1, 73136, '\p{^Block:	gunjalagondi}', "");
    Expect(1, 73136, '\P{Block:	gunjalagondi}', "");
    Expect(0, 73136, '\P{^Block:	gunjalagondi}', "");
    Expect(1, 73135, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Block:    Gunjala_Gondi}', "");
    Expect(0, 73135, '\p{^Block:    Gunjala_Gondi}', "");
    Expect(0, 73135, '\P{Block:    Gunjala_Gondi}', "");
    Expect(1, 73135, '\P{^Block:    Gunjala_Gondi}', "");
    Expect(0, 73136, '\p{Block:    Gunjala_Gondi}', "");
    Expect(1, 73136, '\p{^Block:    Gunjala_Gondi}', "");
    Expect(1, 73136, '\P{Block:    Gunjala_Gondi}', "");
    Expect(0, 73136, '\P{^Block:    Gunjala_Gondi}', "");
    Error('\p{Blk=-	Gunjala_GONDI/a/}');
    Error('\P{Blk=-	Gunjala_GONDI/a/}');
    Expect(1, 73135, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=__gunjala_Gondi}', "");
    Expect(0, 73135, '\p{^Blk=__gunjala_Gondi}', "");
    Expect(0, 73135, '\P{Blk=__gunjala_Gondi}', "");
    Expect(1, 73135, '\P{^Blk=__gunjala_Gondi}', "");
    Expect(0, 73136, '\p{Blk=__gunjala_Gondi}', "");
    Expect(1, 73136, '\p{^Blk=__gunjala_Gondi}', "");
    Expect(1, 73136, '\P{Blk=__gunjala_Gondi}', "");
    Expect(0, 73136, '\P{^Blk=__gunjala_Gondi}', "");
    Error('\p{Is_Block=/a/  gunjala_Gondi}');
    Error('\P{Is_Block=/a/  gunjala_Gondi}');
    Expect(1, 73135, '\p{Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Block=-gunjala_gondi}', "");
    Expect(0, 73135, '\p{^Is_Block=-gunjala_gondi}', "");
    Expect(0, 73135, '\P{Is_Block=-gunjala_gondi}', "");
    Expect(1, 73135, '\P{^Is_Block=-gunjala_gondi}', "");
    Expect(0, 73136, '\p{Is_Block=-gunjala_gondi}', "");
    Expect(1, 73136, '\p{^Is_Block=-gunjala_gondi}', "");
    Expect(1, 73136, '\P{Is_Block=-gunjala_gondi}', "");
    Expect(0, 73136, '\P{^Is_Block=-gunjala_gondi}', "");
    Error('\p{Is_Blk:	_/a/Gunjala_gondi}');
    Error('\P{Is_Blk:	_/a/Gunjala_gondi}');
    Expect(1, 73135, '\p{Is_Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(0, 73135, '\p{^Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(0, 73135, '\P{Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(1, 73135, '\P{^Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(0, 73136, '\p{Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(1, 73136, '\p{^Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(1, 73136, '\P{Is_Blk:-	GUNJALA_Gondi}', "");
    Expect(0, 73136, '\P{^Is_Blk:-	GUNJALA_Gondi}', "");
    Error('\p{Block=/a/ Gurmukhi}');
    Error('\P{Block=/a/ Gurmukhi}');
    Expect(1, 2687, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block: gurmukhi}', "");
    Expect(0, 2687, '\p{^Block: gurmukhi}', "");
    Expect(0, 2687, '\P{Block: gurmukhi}', "");
    Expect(1, 2687, '\P{^Block: gurmukhi}', "");
    Expect(0, 2688, '\p{Block: gurmukhi}', "");
    Expect(1, 2688, '\p{^Block: gurmukhi}', "");
    Expect(1, 2688, '\P{Block: gurmukhi}', "");
    Expect(0, 2688, '\P{^Block: gurmukhi}', "");
    Expect(1, 2687, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block=_	GURMUKHI}', "");
    Expect(0, 2687, '\p{^Block=_	GURMUKHI}', "");
    Expect(0, 2687, '\P{Block=_	GURMUKHI}', "");
    Expect(1, 2687, '\P{^Block=_	GURMUKHI}', "");
    Expect(0, 2688, '\p{Block=_	GURMUKHI}', "");
    Expect(1, 2688, '\p{^Block=_	GURMUKHI}', "");
    Expect(1, 2688, '\P{Block=_	GURMUKHI}', "");
    Expect(0, 2688, '\P{^Block=_	GURMUKHI}', "");
    Error('\p{Blk=:=- GURMUKHI}');
    Error('\P{Blk=:=- GURMUKHI}');
    Expect(1, 2687, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=_Gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=_Gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=_Gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=_Gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=_Gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=_Gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=_Gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=_Gurmukhi}', "");
    Error('\p{Is_Block= :=Gurmukhi}');
    Error('\P{Is_Block= :=Gurmukhi}');
    Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Block=	Gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=	Gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=	Gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=	Gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=	Gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=	Gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=	Gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=	Gurmukhi}', "");
    Error('\p{Is_Blk=:=gurmukhi}');
    Error('\P{Is_Blk=:=gurmukhi}');
    Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Blk=		gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=		gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=		gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=		gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=		gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=		gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=		gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=		gurmukhi}', "");
    Error('\p{Block=/a/		Halfwidth_AND_FULLWIDTH_FORMS}');
    Error('\P{Block=/a/		Halfwidth_AND_FULLWIDTH_FORMS}');
    Expect(1, 65519, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(1, 65519, '\p{Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65519, '\p{^Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65519, '\P{Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(1, 65519, '\P{^Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65520, '\p{Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(1, 65520, '\p{^Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(1, 65520, '\P{Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65520, '\P{^Block=	-Halfwidth_And_Fullwidth_Forms}', "");
    Error('\p{Blk=-Half_And_Full_FORMS:=}');
    Error('\P{Blk=-Half_And_Full_FORMS:=}');
    Expect(1, 65519, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(1, 65519, '\p{Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(1, 65519, '\p{Blk= half_AND_Full_forms}', "");
    Expect(0, 65519, '\p{^Blk= half_AND_Full_forms}', "");
    Expect(0, 65519, '\P{Blk= half_AND_Full_forms}', "");
    Expect(1, 65519, '\P{^Blk= half_AND_Full_forms}', "");
    Expect(0, 65520, '\p{Blk= half_AND_Full_forms}', "");
    Expect(1, 65520, '\p{^Blk= half_AND_Full_forms}', "");
    Expect(1, 65520, '\P{Blk= half_AND_Full_forms}', "");
    Expect(0, 65520, '\P{^Blk= half_AND_Full_forms}', "");
    Error('\p{Is_Block=/a/-	Halfwidth_And_Fullwidth_Forms}');
    Error('\P{Is_Block=/a/-	Halfwidth_And_Fullwidth_Forms}');
    Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65519, '\p{^Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65519, '\P{Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(1, 65519, '\P{^Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65520, '\p{Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(1, 65520, '\p{^Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(1, 65520, '\P{Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Expect(0, 65520, '\P{^Is_Block=__halfwidth_And_FULLWIDTH_FORMS}', "");
    Error('\p{Is_Blk=-/a/Half_And_full_Forms}');
    Error('\P{Is_Blk=-/a/Half_And_full_Forms}');
    Expect(1, 65519, '\p{Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Is_Blk=_Half_And_full_Forms}', "");
    Expect(0, 65519, '\p{^Is_Blk=_Half_And_full_Forms}', "");
    Expect(0, 65519, '\P{Is_Blk=_Half_And_full_Forms}', "");
    Expect(1, 65519, '\P{^Is_Blk=_Half_And_full_Forms}', "");
    Expect(0, 65520, '\p{Is_Blk=_Half_And_full_Forms}', "");
    Expect(1, 65520, '\p{^Is_Blk=_Half_And_full_Forms}', "");
    Expect(1, 65520, '\P{Is_Blk=_Half_And_full_Forms}', "");
    Expect(0, 65520, '\P{^Is_Blk=_Half_And_full_Forms}', "");
    Error('\p{Block=:=_	Combining_half_MARKS}');
    Error('\P{Block=:=_	Combining_half_MARKS}');
    Expect(1, 65071, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(1, 65071, '\p{Block=combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Block=combininghalfmarks}', "");
    Expect(0, 65071, '\P{Block=combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Block=combininghalfmarks}', "");
    Expect(0, 65072, '\p{Block=combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Block=combininghalfmarks}', "");
    Expect(1, 65072, '\P{Block=combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Block=combininghalfmarks}', "");
    Expect(1, 65071, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Block=-Combining_HALF_Marks}', "");
    Expect(0, 65071, '\p{^Block=-Combining_HALF_Marks}', "");
    Expect(0, 65071, '\P{Block=-Combining_HALF_Marks}', "");
    Expect(1, 65071, '\P{^Block=-Combining_HALF_Marks}', "");
    Expect(0, 65072, '\p{Block=-Combining_HALF_Marks}', "");
    Expect(1, 65072, '\p{^Block=-Combining_HALF_Marks}', "");
    Expect(1, 65072, '\P{Block=-Combining_HALF_Marks}', "");
    Expect(0, 65072, '\P{^Block=-Combining_HALF_Marks}', "");
    Error('\p{Blk=_/a/half_marks}');
    Error('\P{Blk=_/a/half_marks}');
    Expect(1, 65071, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(1, 65071, '\p{Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Blk=-Half_Marks}', "");
    Expect(0, 65071, '\p{^Blk=-Half_Marks}', "");
    Expect(0, 65071, '\P{Blk=-Half_Marks}', "");
    Expect(1, 65071, '\P{^Blk=-Half_Marks}', "");
    Expect(0, 65072, '\p{Blk=-Half_Marks}', "");
    Expect(1, 65072, '\p{^Blk=-Half_Marks}', "");
    Expect(1, 65072, '\P{Blk=-Half_Marks}', "");
    Expect(0, 65072, '\P{^Blk=-Half_Marks}', "");
    Error('\p{Is_Block= /a/COMBINING_HALF_Marks}');
    Error('\P{Is_Block= /a/COMBINING_HALF_Marks}');
    Expect(1, 65071, '\p{Is_Block:combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Is_Block:combininghalfmarks}', "");
    Expect(0, 65071, '\P{Is_Block:combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Is_Block:combininghalfmarks}', "");
    Expect(0, 65072, '\p{Is_Block:combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Is_Block:combininghalfmarks}', "");
    Expect(1, 65072, '\P{Is_Block:combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Is_Block:combininghalfmarks}', "");
    Expect(1, 65071, '\p{Is_Block= Combining_Half_Marks}', "");
    Expect(0, 65071, '\p{^Is_Block= Combining_Half_Marks}', "");
    Expect(0, 65071, '\P{Is_Block= Combining_Half_Marks}', "");
    Expect(1, 65071, '\P{^Is_Block= Combining_Half_Marks}', "");
    Expect(0, 65072, '\p{Is_Block= Combining_Half_Marks}', "");
    Expect(1, 65072, '\p{^Is_Block= Combining_Half_Marks}', "");
    Expect(1, 65072, '\P{Is_Block= Combining_Half_Marks}', "");
    Expect(0, 65072, '\P{^Is_Block= Combining_Half_Marks}', "");
    Error('\p{Is_Blk=	:=Half_Marks}');
    Error('\P{Is_Blk=	:=Half_Marks}');
    Expect(1, 65071, '\p{Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Is_Blk=-Half_MARKS}', "");
    Expect(0, 65071, '\p{^Is_Blk=-Half_MARKS}', "");
    Expect(0, 65071, '\P{Is_Blk=-Half_MARKS}', "");
    Expect(1, 65071, '\P{^Is_Blk=-Half_MARKS}', "");
    Expect(0, 65072, '\p{Is_Blk=-Half_MARKS}', "");
    Expect(1, 65072, '\p{^Is_Blk=-Half_MARKS}', "");
    Expect(1, 65072, '\P{Is_Blk=-Half_MARKS}', "");
    Expect(0, 65072, '\P{^Is_Blk=-Half_MARKS}', "");
    Error('\p{Block= :=Hangul_SYLLABLES}');
    Error('\P{Block= :=Hangul_SYLLABLES}');
    Expect(1, 55215, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(1, 55215, '\p{Block:	hangulsyllables}', "");
    Expect(0, 55215, '\p{^Block:	hangulsyllables}', "");
    Expect(0, 55215, '\P{Block:	hangulsyllables}', "");
    Expect(1, 55215, '\P{^Block:	hangulsyllables}', "");
    Expect(0, 55216, '\p{Block:	hangulsyllables}', "");
    Expect(1, 55216, '\p{^Block:	hangulsyllables}', "");
    Expect(1, 55216, '\P{Block:	hangulsyllables}', "");
    Expect(0, 55216, '\P{^Block:	hangulsyllables}', "");
    Expect(1, 55215, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(1, 55215, '\p{Block=  Hangul_syllables}', "");
    Expect(0, 55215, '\p{^Block=  Hangul_syllables}', "");
    Expect(0, 55215, '\P{Block=  Hangul_syllables}', "");
    Expect(1, 55215, '\P{^Block=  Hangul_syllables}', "");
    Expect(0, 55216, '\p{Block=  Hangul_syllables}', "");
    Expect(1, 55216, '\p{^Block=  Hangul_syllables}', "");
    Expect(1, 55216, '\P{Block=  Hangul_syllables}', "");
    Expect(0, 55216, '\P{^Block=  Hangul_syllables}', "");
    Error('\p{Blk=_:=Hangul}');
    Error('\P{Blk=_:=Hangul}');
    Expect(1, 55215, '\p{Blk=:\AHangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\AHangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=hangul}', "");
    Expect(0, 55215, '\p{^Blk=hangul}', "");
    Expect(0, 55215, '\P{Blk=hangul}', "");
    Expect(1, 55215, '\P{^Blk=hangul}', "");
    Expect(0, 55216, '\p{Blk=hangul}', "");
    Expect(1, 55216, '\p{^Blk=hangul}', "");
    Expect(1, 55216, '\P{Blk=hangul}', "");
    Expect(0, 55216, '\P{^Blk=hangul}', "");
    Expect(1, 55215, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=_-Hangul}', "");
    Expect(0, 55215, '\p{^Blk=_-Hangul}', "");
    Expect(0, 55215, '\P{Blk=_-Hangul}', "");
    Expect(1, 55215, '\P{^Blk=_-Hangul}', "");
    Expect(0, 55216, '\p{Blk=_-Hangul}', "");
    Expect(1, 55216, '\p{^Blk=_-Hangul}', "");
    Expect(1, 55216, '\P{Blk=_-Hangul}', "");
    Expect(0, 55216, '\P{^Blk=_-Hangul}', "");
    Error('\p{Is_Block=/a/__Hangul_Syllables}');
    Error('\P{Is_Block=/a/__Hangul_Syllables}');
    Expect(1, 55215, '\p{Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Is_Block=__HANGUL_Syllables}', "");
    Expect(0, 55215, '\p{^Is_Block=__HANGUL_Syllables}', "");
    Expect(0, 55215, '\P{Is_Block=__HANGUL_Syllables}', "");
    Expect(1, 55215, '\P{^Is_Block=__HANGUL_Syllables}', "");
    Expect(0, 55216, '\p{Is_Block=__HANGUL_Syllables}', "");
    Expect(1, 55216, '\p{^Is_Block=__HANGUL_Syllables}', "");
    Expect(1, 55216, '\P{Is_Block=__HANGUL_Syllables}', "");
    Expect(0, 55216, '\P{^Is_Block=__HANGUL_Syllables}', "");
    Error('\p{Is_Blk=_/a/Hangul}');
    Error('\P{Is_Blk=_/a/Hangul}');
    Expect(1, 55215, '\p{Is_Blk=hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=hangul}', "");
    Expect(1, 55215, '\p{Is_Blk=_Hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=_Hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=_Hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=_Hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=_Hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=_Hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=_Hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=_Hangul}', "");
    Error('\p{Block= _HANIFI_Rohingya/a/}');
    Error('\P{Block= _HANIFI_Rohingya/a/}');
    Expect(1, 68927, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=	hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\p{^Block=	hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\P{Block=	hanifi_ROHINGYA}', "");
    Expect(1, 68927, '\P{^Block=	hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\p{Block=	hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\p{^Block=	hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\P{Block=	hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\P{^Block=	hanifi_ROHINGYA}', "");
    Error('\p{Blk=__Hanifi_rohingya/a/}');
    Error('\P{Blk=__Hanifi_rohingya/a/}');
    Expect(1, 68927, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=  hanifi_rohingya}', "");
    Expect(0, 68927, '\p{^Blk=  hanifi_rohingya}', "");
    Expect(0, 68927, '\P{Blk=  hanifi_rohingya}', "");
    Expect(1, 68927, '\P{^Blk=  hanifi_rohingya}', "");
    Expect(0, 68928, '\p{Blk=  hanifi_rohingya}', "");
    Expect(1, 68928, '\p{^Blk=  hanifi_rohingya}', "");
    Expect(1, 68928, '\P{Blk=  hanifi_rohingya}', "");
    Expect(0, 68928, '\P{^Blk=  hanifi_rohingya}', "");
    Error('\p{Is_Block=:=-	hanifi_ROHINGYA}');
    Error('\P{Is_Block=:=-	hanifi_ROHINGYA}');
    Expect(1, 68927, '\p{Is_Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Block=	_HANIFI_Rohingya}', "");
    Expect(0, 68927, '\p{^Is_Block=	_HANIFI_Rohingya}', "");
    Expect(0, 68927, '\P{Is_Block=	_HANIFI_Rohingya}', "");
    Expect(1, 68927, '\P{^Is_Block=	_HANIFI_Rohingya}', "");
    Expect(0, 68928, '\p{Is_Block=	_HANIFI_Rohingya}', "");
    Expect(1, 68928, '\p{^Is_Block=	_HANIFI_Rohingya}', "");
    Expect(1, 68928, '\P{Is_Block=	_HANIFI_Rohingya}', "");
    Expect(0, 68928, '\P{^Is_Block=	_HANIFI_Rohingya}', "");
    Error('\p{Is_Blk=/a/Hanifi_ROHINGYA}');
    Error('\P{Is_Blk=/a/Hanifi_ROHINGYA}');
    Expect(1, 68927, '\p{Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Is_Blk:   --Hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk:   --Hanifi_Rohingya}', "");
    Error('\p{Block=__HANUNOO:=}');
    Error('\P{Block=__HANUNOO:=}');
    Expect(1, 5951, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Block=hanunoo}', "");
    Expect(0, 5951, '\P{Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Block=hanunoo}', "");
    Expect(0, 5952, '\p{Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Block=hanunoo}', "");
    Expect(1, 5952, '\P{Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Block=hanunoo}', "");
    Expect(1, 5951, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=__hanunoo}', "");
    Expect(0, 5951, '\p{^Block=__hanunoo}', "");
    Expect(0, 5951, '\P{Block=__hanunoo}', "");
    Expect(1, 5951, '\P{^Block=__hanunoo}', "");
    Expect(0, 5952, '\p{Block=__hanunoo}', "");
    Expect(1, 5952, '\p{^Block=__hanunoo}', "");
    Expect(1, 5952, '\P{Block=__hanunoo}', "");
    Expect(0, 5952, '\P{^Block=__hanunoo}', "");
    Error('\p{Blk=/a/- hanunoo}');
    Error('\P{Blk=/a/- hanunoo}');
    Expect(1, 5951, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=_hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=_hanunoo}', "");
    Expect(0, 5951, '\P{Blk=_hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=_hanunoo}', "");
    Expect(0, 5952, '\p{Blk=_hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=_hanunoo}', "");
    Expect(1, 5952, '\P{Blk=_hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=_hanunoo}', "");
    Error('\p{Is_Block=_HANUNOO:=}');
    Error('\P{Is_Block=_HANUNOO:=}');
    Expect(1, 5951, '\p{Is_Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Block:  hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block:  hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block:  hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block:  hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block:  hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block:  hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block:  hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block:  hanunoo}', "");
    Error('\p{Is_Blk=-:=Hanunoo}');
    Error('\P{Is_Blk=-:=Hanunoo}');
    Expect(1, 5951, '\p{Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Blk=Hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk=Hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk=Hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk=Hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk=Hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk=Hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk=Hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk=Hanunoo}', "");
    Error('\p{Block= /a/HATRAN}');
    Error('\P{Block= /a/HATRAN}');
    Expect(1, 67839, '\p{Block=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Block=hatran}', "");
    Expect(0, 67839, '\p{^Block=hatran}', "");
    Expect(0, 67839, '\P{Block=hatran}', "");
    Expect(1, 67839, '\P{^Block=hatran}', "");
    Expect(0, 67840, '\p{Block=hatran}', "");
    Expect(1, 67840, '\p{^Block=hatran}', "");
    Expect(1, 67840, '\P{Block=hatran}', "");
    Expect(0, 67840, '\P{^Block=hatran}', "");
    Expect(1, 67839, '\p{Block=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Block=  HATRAN}', "");
    Expect(0, 67839, '\p{^Block=  HATRAN}', "");
    Expect(0, 67839, '\P{Block=  HATRAN}', "");
    Expect(1, 67839, '\P{^Block=  HATRAN}', "");
    Expect(0, 67840, '\p{Block=  HATRAN}', "");
    Expect(1, 67840, '\p{^Block=  HATRAN}', "");
    Expect(1, 67840, '\P{Block=  HATRAN}', "");
    Expect(0, 67840, '\P{^Block=  HATRAN}', "");
    Error('\p{Blk=/a/-_HATRAN}');
    Error('\P{Blk=/a/-_HATRAN}');
    Expect(1, 67839, '\p{Blk=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=hatran}', "");
    Expect(0, 67839, '\p{^Blk=hatran}', "");
    Expect(0, 67839, '\P{Blk=hatran}', "");
    Expect(1, 67839, '\P{^Blk=hatran}', "");
    Expect(0, 67840, '\p{Blk=hatran}', "");
    Expect(1, 67840, '\p{^Blk=hatran}', "");
    Expect(1, 67840, '\P{Blk=hatran}', "");
    Expect(0, 67840, '\P{^Blk=hatran}', "");
    Expect(1, 67839, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Blk:   --Hatran}', "");
    Expect(0, 67839, '\p{^Blk:   --Hatran}', "");
    Expect(0, 67839, '\P{Blk:   --Hatran}', "");
    Expect(1, 67839, '\P{^Blk:   --Hatran}', "");
    Expect(0, 67840, '\p{Blk:   --Hatran}', "");
    Expect(1, 67840, '\p{^Blk:   --Hatran}', "");
    Expect(1, 67840, '\P{Blk:   --Hatran}', "");
    Expect(0, 67840, '\P{^Blk:   --Hatran}', "");
    Error('\p{Is_Block=:=	-HATRAN}');
    Error('\P{Is_Block=:=	-HATRAN}');
    Expect(1, 67839, '\p{Is_Block=hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=hatran}', "");
    Expect(0, 67839, '\P{Is_Block=hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=hatran}', "");
    Expect(0, 67840, '\p{Is_Block=hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=hatran}', "");
    Expect(1, 67840, '\P{Is_Block=hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=hatran}', "");
    Expect(1, 67839, '\p{Is_Block=-Hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=-Hatran}', "");
    Expect(0, 67839, '\P{Is_Block=-Hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=-Hatran}', "");
    Expect(0, 67840, '\p{Is_Block=-Hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=-Hatran}', "");
    Expect(1, 67840, '\P{Is_Block=-Hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=-Hatran}', "");
    Error('\p{Is_Blk=:=hatran}');
    Error('\P{Is_Blk=:=hatran}');
    Expect(1, 67839, '\p{Is_Blk=hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=hatran}', "");
    Expect(1, 67839, '\p{Is_Blk=Hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=Hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=Hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=Hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=Hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=Hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=Hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=Hatran}', "");
    Error('\p{Block=/a/	-Hebrew}');
    Error('\P{Block=/a/	-Hebrew}');
    Expect(1, 1535, '\p{Block=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Block=hebrew}', "");
    Expect(0, 1535, '\p{^Block=hebrew}', "");
    Expect(0, 1535, '\P{Block=hebrew}', "");
    Expect(1, 1535, '\P{^Block=hebrew}', "");
    Expect(0, 1536, '\p{Block=hebrew}', "");
    Expect(1, 1536, '\p{^Block=hebrew}', "");
    Expect(1, 1536, '\P{Block=hebrew}', "");
    Expect(0, 1536, '\P{^Block=hebrew}', "");
    Expect(1, 1535, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Block:   hebrew}', "");
    Expect(0, 1535, '\p{^Block:   hebrew}', "");
    Expect(0, 1535, '\P{Block:   hebrew}', "");
    Expect(1, 1535, '\P{^Block:   hebrew}', "");
    Expect(0, 1536, '\p{Block:   hebrew}', "");
    Expect(1, 1536, '\p{^Block:   hebrew}', "");
    Expect(1, 1536, '\P{Block:   hebrew}', "");
    Expect(0, 1536, '\P{^Block:   hebrew}', "");
    Error('\p{Blk: /a/  Hebrew}');
    Error('\P{Blk: /a/  Hebrew}');
    Expect(1, 1535, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Blk=hebrew}', "");
    Expect(0, 1535, '\P{Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Blk=hebrew}', "");
    Expect(0, 1536, '\p{Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Blk=hebrew}', "");
    Expect(1, 1536, '\P{Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Blk=hebrew}', "");
    Expect(1, 1535, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk= HEBREW}', "");
    Expect(0, 1535, '\p{^Blk= HEBREW}', "");
    Expect(0, 1535, '\P{Blk= HEBREW}', "");
    Expect(1, 1535, '\P{^Blk= HEBREW}', "");
    Expect(0, 1536, '\p{Blk= HEBREW}', "");
    Expect(1, 1536, '\p{^Blk= HEBREW}', "");
    Expect(1, 1536, '\P{Blk= HEBREW}', "");
    Expect(0, 1536, '\P{^Blk= HEBREW}', "");
    Error('\p{Is_Block=-HEBREW/a/}');
    Error('\P{Is_Block=-HEBREW/a/}');
    Expect(1, 1535, '\p{Is_Block=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=hebrew}', "");
    Expect(1, 1535, '\p{Is_Block=- Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=- Hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=- Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=- Hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=- Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=- Hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=- Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=- Hebrew}', "");
    Error('\p{Is_Blk=:=  Hebrew}');
    Error('\P{Is_Blk=:=  Hebrew}');
    Expect(1, 1535, '\p{Is_Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=hebrew}', "");
    Expect(1, 1535, '\p{Is_Blk=--Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=--Hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=--Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=--Hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=--Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=--Hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=--Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=--Hebrew}', "");
    Error('\p{Block=/a/_ High_PRIVATE_use_SURROGATES}');
    Error('\P{Block=/a/_ High_PRIVATE_use_SURROGATES}');
    Expect(1, 56319, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(1, 56319, '\p{Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(0, 56319, '\p{^Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(0, 56319, '\P{Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(1, 56319, '\P{^Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(0, 57344, '\p{Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(1, 57344, '\p{^Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(1, 57344, '\P{Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Expect(0, 57344, '\P{^Block=	HIGH_PRIVATE_Use_surrogates}', "");
    Error('\p{Blk=-_High_pu_SURROGATES/a/}');
    Error('\P{Blk=-_High_pu_SURROGATES/a/}');
    Expect(1, 56319, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk= 	HIGH_PU_Surrogates}', "");
    Expect(0, 56319, '\p{^Blk= 	HIGH_PU_Surrogates}', "");
    Expect(0, 56319, '\P{Blk= 	HIGH_PU_Surrogates}', "");
    Expect(1, 56319, '\P{^Blk= 	HIGH_PU_Surrogates}', "");
    Expect(0, 57344, '\p{Blk= 	HIGH_PU_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk= 	HIGH_PU_Surrogates}', "");
    Expect(1, 57344, '\P{Blk= 	HIGH_PU_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk= 	HIGH_PU_Surrogates}', "");
    Error('\p{Is_Block: /a/-	High_Private_use_Surrogates}');
    Error('\P{Is_Block: /a/-	High_Private_use_Surrogates}');
    Expect(1, 56319, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(0, 56319, '\p{^Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(0, 56319, '\P{Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(1, 56319, '\P{^Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Block=	 High_Private_Use_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Block=	 High_Private_Use_SURROGATES}', "");
    Error('\p{Is_Blk=	high_PU_Surrogates/a/}');
    Error('\P{Is_Blk=	high_PU_Surrogates/a/}');
    Expect(1, 56319, '\p{Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(0, 56319, '\P{Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk= HIGH_pu_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk= HIGH_pu_Surrogates}', "");
    Error('\p{Block=:=_-High_Surrogates}');
    Error('\P{Block=:=_-High_Surrogates}');
    Expect(1, 56191, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Block:	 High_surrogates}', "");
    Expect(0, 56191, '\p{^Block:	 High_surrogates}', "");
    Expect(0, 56191, '\P{Block:	 High_surrogates}', "");
    Expect(1, 56191, '\P{^Block:	 High_surrogates}', "");
    Expect(0, 57344, '\p{Block:	 High_surrogates}', "");
    Expect(1, 57344, '\p{^Block:	 High_surrogates}', "");
    Expect(1, 57344, '\P{Block:	 High_surrogates}', "");
    Expect(0, 57344, '\P{^Block:	 High_surrogates}', "");
    Error('\p{Blk= /a/high_SURROGATES}');
    Error('\P{Blk= /a/high_SURROGATES}');
    Expect(1, 56191, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=__HIGH_SURROGATES}', "");
    Expect(0, 56191, '\p{^Blk=__HIGH_SURROGATES}', "");
    Expect(0, 56191, '\P{Blk=__HIGH_SURROGATES}', "");
    Expect(1, 56191, '\P{^Blk=__HIGH_SURROGATES}', "");
    Expect(0, 57344, '\p{Blk=__HIGH_SURROGATES}', "");
    Expect(1, 57344, '\p{^Blk=__HIGH_SURROGATES}', "");
    Expect(1, 57344, '\P{Blk=__HIGH_SURROGATES}', "");
    Expect(0, 57344, '\P{^Blk=__HIGH_SURROGATES}', "");
    Error('\p{Is_Block=/a/  High_Surrogates}');
    Error('\P{Is_Block=/a/  High_Surrogates}');
    Expect(1, 56191, '\p{Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Block=		high_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=		high_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Block=		high_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=		high_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=		high_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=		high_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=		high_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=		high_Surrogates}', "");
    Error('\p{Is_Blk=:=__high_surrogates}');
    Error('\P{Is_Blk=:=__high_surrogates}');
    Expect(1, 56191, '\p{Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Blk=High_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=High_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=High_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=High_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=High_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=High_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=High_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=High_Surrogates}', "");
    Error('\p{Block= _Hiragana:=}');
    Error('\P{Block= _Hiragana:=}');
    Expect(1, 12447, '\p{Block=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Block=hiragana}', "");
    Expect(0, 12447, '\p{^Block=hiragana}', "");
    Expect(0, 12447, '\P{Block=hiragana}', "");
    Expect(1, 12447, '\P{^Block=hiragana}', "");
    Expect(0, 12448, '\p{Block=hiragana}', "");
    Expect(1, 12448, '\p{^Block=hiragana}', "");
    Expect(1, 12448, '\P{Block=hiragana}', "");
    Expect(0, 12448, '\P{^Block=hiragana}', "");
    Expect(1, 12447, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Block:	-	Hiragana}', "");
    Expect(0, 12447, '\p{^Block:	-	Hiragana}', "");
    Expect(0, 12447, '\P{Block:	-	Hiragana}', "");
    Expect(1, 12447, '\P{^Block:	-	Hiragana}', "");
    Expect(0, 12448, '\p{Block:	-	Hiragana}', "");
    Expect(1, 12448, '\p{^Block:	-	Hiragana}', "");
    Expect(1, 12448, '\P{Block:	-	Hiragana}', "");
    Expect(0, 12448, '\P{^Block:	-	Hiragana}', "");
    Error('\p{Blk=:=_Hiragana}');
    Error('\P{Blk=:=_Hiragana}');
    Expect(1, 12447, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Blk=hiragana}', "");
    Expect(0, 12447, '\P{Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Blk=hiragana}', "");
    Expect(0, 12448, '\p{Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Blk=hiragana}', "");
    Expect(1, 12448, '\P{Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Blk=hiragana}', "");
    Expect(1, 12447, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk=-_HIRAGANA}', "");
    Expect(0, 12447, '\p{^Blk=-_HIRAGANA}', "");
    Expect(0, 12447, '\P{Blk=-_HIRAGANA}', "");
    Expect(1, 12447, '\P{^Blk=-_HIRAGANA}', "");
    Expect(0, 12448, '\p{Blk=-_HIRAGANA}', "");
    Expect(1, 12448, '\p{^Blk=-_HIRAGANA}', "");
    Expect(1, 12448, '\P{Blk=-_HIRAGANA}', "");
    Expect(0, 12448, '\P{^Blk=-_HIRAGANA}', "");
    Error('\p{Is_Block=/a/ -Hiragana}');
    Error('\P{Is_Block=/a/ -Hiragana}');
    Expect(1, 12447, '\p{Is_Block=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=hiragana}', "");
    Expect(1, 12447, '\p{Is_Block=-	Hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=-	Hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=-	Hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=-	Hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=-	Hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=-	Hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=-	Hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=-	Hiragana}', "");
    Error('\p{Is_Blk= /a/Hiragana}');
    Error('\P{Is_Blk= /a/Hiragana}');
    Expect(1, 12447, '\p{Is_Blk:hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk:hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk:hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk:hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk:hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk:hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk:hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk:hiragana}', "");
    Expect(1, 12447, '\p{Is_Blk=	Hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk=	Hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk=	Hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk=	Hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk=	Hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk=	Hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk=	Hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk=	Hiragana}', "");
    Error('\p{Block=_:=Ideographic_description_CHARACTERS}');
    Error('\P{Block=_:=Ideographic_description_CHARACTERS}');
    Expect(1, 12287, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(1, 12287, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(1, 12287, '\p{Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(0, 12287, '\p{^Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(0, 12287, '\P{Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(1, 12287, '\P{^Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(0, 12288, '\p{Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(1, 12288, '\p{^Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(1, 12288, '\P{Block=	ideographic_DESCRIPTION_Characters}', "");
    Expect(0, 12288, '\P{^Block=	ideographic_DESCRIPTION_Characters}', "");
    Error('\p{Blk=-/a/IDC}');
    Error('\P{Blk=-/a/IDC}');
    Expect(1, 12287, '\p{Blk=:\AIDC\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\AIDC\z:}', "");;
    Expect(1, 12287, '\p{Blk=idc}', "");
    Expect(0, 12287, '\p{^Blk=idc}', "");
    Expect(0, 12287, '\P{Blk=idc}', "");
    Expect(1, 12287, '\P{^Blk=idc}', "");
    Expect(0, 12288, '\p{Blk=idc}', "");
    Expect(1, 12288, '\p{^Blk=idc}', "");
    Expect(1, 12288, '\P{Blk=idc}', "");
    Expect(0, 12288, '\P{^Blk=idc}', "");
    Expect(1, 12287, '\p{Blk=:\Aidc\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\Aidc\z:}', "");;
    Expect(1, 12287, '\p{Blk=_IDC}', "");
    Expect(0, 12287, '\p{^Blk=_IDC}', "");
    Expect(0, 12287, '\P{Blk=_IDC}', "");
    Expect(1, 12287, '\P{^Blk=_IDC}', "");
    Expect(0, 12288, '\p{Blk=_IDC}', "");
    Expect(1, 12288, '\p{^Blk=_IDC}', "");
    Expect(1, 12288, '\P{Blk=_IDC}', "");
    Expect(0, 12288, '\P{^Blk=_IDC}', "");
    Error('\p{Is_Block:  :=Ideographic_Description_Characters}');
    Error('\P{Is_Block:  :=Ideographic_Description_Characters}');
    Expect(1, 12287, '\p{Is_Block:ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Is_Block:ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Is_Block:ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Is_Block:ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Is_Block:ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Is_Block:ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Is_Block:ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Is_Block:ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(0, 12287, '\p{^Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(0, 12287, '\P{Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(1, 12287, '\P{^Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(0, 12288, '\p{Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(1, 12288, '\p{^Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(1, 12288, '\P{Is_Block=	-Ideographic_Description_Characters}', "");
    Expect(0, 12288, '\P{^Is_Block=	-Ideographic_Description_Characters}', "");
    Error('\p{Is_Blk=_ IDC/a/}');
    Error('\P{Is_Blk=_ IDC/a/}');
    Expect(1, 12287, '\p{Is_Blk=idc}', "");
    Expect(0, 12287, '\p{^Is_Blk=idc}', "");
    Expect(0, 12287, '\P{Is_Blk=idc}', "");
    Expect(1, 12287, '\P{^Is_Blk=idc}', "");
    Expect(0, 12288, '\p{Is_Blk=idc}', "");
    Expect(1, 12288, '\p{^Is_Blk=idc}', "");
    Expect(1, 12288, '\P{Is_Blk=idc}', "");
    Expect(0, 12288, '\P{^Is_Blk=idc}', "");
    Expect(1, 12287, '\p{Is_Blk=-	IDC}', "");
    Expect(0, 12287, '\p{^Is_Blk=-	IDC}', "");
    Expect(0, 12287, '\P{Is_Blk=-	IDC}', "");
    Expect(1, 12287, '\P{^Is_Blk=-	IDC}', "");
    Expect(0, 12288, '\p{Is_Blk=-	IDC}', "");
    Expect(1, 12288, '\p{^Is_Blk=-	IDC}', "");
    Expect(1, 12288, '\P{Is_Blk=-	IDC}', "");
    Expect(0, 12288, '\P{^Is_Blk=-	IDC}', "");
    Error('\p{Block=:=ideographic_symbols_And_punctuation}');
    Error('\P{Block=:=ideographic_symbols_And_punctuation}');
    Expect(1, 94207, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Block=_Ideographic_Symbols_And_PUNCTUATION}', "");
    Error('\p{Blk=:= 	IDEOGRAPHIC_Symbols}');
    Error('\P{Blk=:= 	IDEOGRAPHIC_Symbols}');
    Expect(1, 94207, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(1, 94207, '\p{Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(1, 94207, '\p{Blk=		ideographic_Symbols}', "");
    Expect(0, 94207, '\p{^Blk=		ideographic_Symbols}', "");
    Expect(0, 94207, '\P{Blk=		ideographic_Symbols}', "");
    Expect(1, 94207, '\P{^Blk=		ideographic_Symbols}', "");
    Expect(0, 94208, '\p{Blk=		ideographic_Symbols}', "");
    Expect(1, 94208, '\p{^Blk=		ideographic_Symbols}', "");
    Expect(1, 94208, '\P{Blk=		ideographic_Symbols}', "");
    Expect(0, 94208, '\P{^Blk=		ideographic_Symbols}', "");
    Error('\p{Is_Block=:=IDEOGRAPHIC_Symbols_and_punctuation}');
    Error('\P{Is_Block=:=IDEOGRAPHIC_Symbols_and_punctuation}');
    Expect(1, 94207, '\p{Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Is_Block: ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Is_Block=	ideographic_Symbols_And_PUNCTUATION}', "");
    Error('\p{Is_Blk=	:=IDEOGRAPHIC_Symbols}');
    Error('\P{Is_Blk=	:=IDEOGRAPHIC_Symbols}');
    Expect(1, 94207, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\P{Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\p{Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\P{Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=IDEOGRAPHIC_Symbols}', "");
    Error('\p{Block=- Imperial_Aramaic:=}');
    Error('\P{Block=- Imperial_Aramaic:=}');
    Expect(1, 67679, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Block= Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Block= Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\P{Block= Imperial_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Block= Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\p{Block= Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Block= Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\P{Block= Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Block= Imperial_ARAMAIC}', "");
    Error('\p{Blk=  Imperial_aramaic:=}');
    Error('\P{Blk=  Imperial_aramaic:=}');
    Expect(1, 67679, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk=-Imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Blk=-Imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Blk=-Imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Blk=-Imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Blk=-Imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Blk=-Imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Blk=-Imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Blk=-Imperial_Aramaic}', "");
    Error('\p{Is_Block=	:=Imperial_Aramaic}');
    Error('\P{Is_Block=	:=Imperial_Aramaic}');
    Expect(1, 67679, '\p{Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Block=--imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=--imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Is_Block=--imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=--imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Is_Block=--imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=--imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Is_Block=--imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=--imperial_Aramaic}', "");
    Error('\p{Is_Blk=:= Imperial_Aramaic}');
    Error('\P{Is_Blk=:= Imperial_Aramaic}');
    Expect(1, 67679, '\p{Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Blk= -Imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk= -Imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Is_Blk= -Imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk= -Imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Is_Blk= -Imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk= -Imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Is_Blk= -Imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk= -Imperial_Aramaic}', "");
    Error('\p{Block=:=- Common_indic_NUMBER_forms}');
    Error('\P{Block=:=- Common_indic_NUMBER_forms}');
    Expect(1, 43071, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(0, 43071, '\p{^Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(0, 43071, '\P{Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(1, 43071, '\P{^Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(0, 43072, '\p{Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(1, 43072, '\p{^Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(1, 43072, '\P{Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Expect(0, 43072, '\P{^Block=- COMMON_Indic_NUMBER_FORMS}', "");
    Error('\p{Blk:   -/a/Indic_Number_forms}');
    Error('\P{Blk:   -/a/Indic_Number_forms}');
    Expect(1, 43071, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Blk=_Indic_number_Forms}', "");
    Expect(0, 43071, '\p{^Blk=_Indic_number_Forms}', "");
    Expect(0, 43071, '\P{Blk=_Indic_number_Forms}', "");
    Expect(1, 43071, '\P{^Blk=_Indic_number_Forms}', "");
    Expect(0, 43072, '\p{Blk=_Indic_number_Forms}', "");
    Expect(1, 43072, '\p{^Blk=_Indic_number_Forms}', "");
    Expect(1, 43072, '\P{Blk=_Indic_number_Forms}', "");
    Expect(0, 43072, '\P{^Blk=_Indic_number_Forms}', "");
    Error('\p{Is_Block=	_Common_Indic_Number_Forms/a/}');
    Error('\P{Is_Block=	_Common_Indic_Number_Forms/a/}');
    Expect(1, 43071, '\p{Is_Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(0, 43071, '\p{^Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(0, 43071, '\P{Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(1, 43071, '\P{^Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(0, 43072, '\p{Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(1, 43072, '\p{^Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(1, 43072, '\P{Is_Block=	Common_indic_NUMBER_Forms}', "");
    Expect(0, 43072, '\P{^Is_Block=	Common_indic_NUMBER_Forms}', "");
    Error('\p{Is_Blk=/a/	INDIC_Number_Forms}');
    Error('\P{Is_Blk=/a/	INDIC_Number_Forms}');
    Expect(1, 43071, '\p{Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Blk=Indic_number_FORMS}', "");
    Expect(0, 43071, '\p{^Is_Blk=Indic_number_FORMS}', "");
    Expect(0, 43071, '\P{Is_Blk=Indic_number_FORMS}', "");
    Expect(1, 43071, '\P{^Is_Blk=Indic_number_FORMS}', "");
    Expect(0, 43072, '\p{Is_Blk=Indic_number_FORMS}', "");
    Expect(1, 43072, '\p{^Is_Blk=Indic_number_FORMS}', "");
    Expect(1, 43072, '\P{Is_Blk=Indic_number_FORMS}', "");
    Expect(0, 43072, '\P{^Is_Blk=Indic_number_FORMS}', "");
    Error('\p{Block=	-INDIC_siyaq_NUMBERS/a/}');
    Error('\P{Block=	-INDIC_siyaq_NUMBERS/a/}');
    Expect(1, 126143, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Block: 	_indic_siyaq_numbers}', "");
    Expect(0, 126143, '\p{^Block: 	_indic_siyaq_numbers}', "");
    Expect(0, 126143, '\P{Block: 	_indic_siyaq_numbers}', "");
    Expect(1, 126143, '\P{^Block: 	_indic_siyaq_numbers}', "");
    Expect(0, 126144, '\p{Block: 	_indic_siyaq_numbers}', "");
    Expect(1, 126144, '\p{^Block: 	_indic_siyaq_numbers}', "");
    Expect(1, 126144, '\P{Block: 	_indic_siyaq_numbers}', "");
    Expect(0, 126144, '\P{^Block: 	_indic_siyaq_numbers}', "");
    Error('\p{Blk= 	Indic_SIYAQ_Numbers:=}');
    Error('\P{Blk= 	Indic_SIYAQ_Numbers:=}');
    Expect(1, 126143, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Blk:_	Indic_siyaq_numbers}', "");
    Expect(0, 126143, '\p{^Blk:_	Indic_siyaq_numbers}', "");
    Expect(0, 126143, '\P{Blk:_	Indic_siyaq_numbers}', "");
    Expect(1, 126143, '\P{^Blk:_	Indic_siyaq_numbers}', "");
    Expect(0, 126144, '\p{Blk:_	Indic_siyaq_numbers}', "");
    Expect(1, 126144, '\p{^Blk:_	Indic_siyaq_numbers}', "");
    Expect(1, 126144, '\P{Blk:_	Indic_siyaq_numbers}', "");
    Expect(0, 126144, '\P{^Blk:_	Indic_siyaq_numbers}', "");
    Error('\p{Is_Block=:= Indic_SIYAQ_Numbers}');
    Error('\P{Is_Block=:= Indic_SIYAQ_Numbers}');
    Expect(1, 126143, '\p{Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(0, 126143, '\p{^Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(0, 126143, '\P{Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(1, 126143, '\P{^Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(0, 126144, '\p{Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(1, 126144, '\p{^Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(1, 126144, '\P{Is_Block=-_indic_Siyaq_Numbers}', "");
    Expect(0, 126144, '\P{^Is_Block=-_indic_Siyaq_Numbers}', "");
    Error('\p{Is_Blk= INDIC_SIYAQ_numbers:=}');
    Error('\P{Is_Blk= INDIC_SIYAQ_numbers:=}');
    Expect(1, 126143, '\p{Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(0, 126143, '\p{^Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(0, 126143, '\P{Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(1, 126143, '\P{^Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(0, 126144, '\p{Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(1, 126144, '\p{^Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(1, 126144, '\P{Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Expect(0, 126144, '\P{^Is_Blk=-	INDIC_siyaq_NUMBERS}', "");
    Error('\p{Block= _Inscriptional_PAHLAVI/a/}');
    Error('\P{Block= _Inscriptional_PAHLAVI/a/}');
    Expect(1, 68479, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=  Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Block=  Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\P{Block=  Inscriptional_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Block=  Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\p{Block=  Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Block=  Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\P{Block=  Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Block=  Inscriptional_PAHLAVI}', "");
    Error('\p{Blk= -Inscriptional_Pahlavi/a/}');
    Error('\P{Blk= -Inscriptional_Pahlavi/a/}');
    Expect(1, 68479, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=-Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\p{^Blk=-Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\P{Blk=-Inscriptional_pahlavi}', "");
    Expect(1, 68479, '\P{^Blk=-Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\p{Blk=-Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\p{^Blk=-Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\P{Blk=-Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\P{^Blk=-Inscriptional_pahlavi}', "");
    Error('\p{Is_Block=-	Inscriptional_pahlavi:=}');
    Error('\P{Is_Block=-	Inscriptional_pahlavi:=}');
    Expect(1, 68479, '\p{Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\P{Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\p{Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\P{Is_Block=_ Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block=_ Inscriptional_pahlavi}', "");
    Error('\p{Is_Blk:   /a/_inscriptional_PAHLAVI}');
    Error('\P{Is_Blk:   /a/_inscriptional_PAHLAVI}');
    Expect(1, 68479, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk=__Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk=__Inscriptional_Pahlavi}', "");
    Error('\p{Block= INSCRIPTIONAL_Parthian/a/}');
    Error('\P{Block= INSCRIPTIONAL_Parthian/a/}');
    Expect(1, 68447, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Block=		Inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Block=		Inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Block=		Inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Block=		Inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Block=		Inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Block=		Inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Block=		Inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Block=		Inscriptional_Parthian}', "");
    Error('\p{Blk=_ Inscriptional_PARTHIAN:=}');
    Error('\P{Blk=_ Inscriptional_PARTHIAN:=}');
    Expect(1, 68447, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Blk=-Inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Blk=-Inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Blk=-Inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Blk=-Inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Blk=-Inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Blk=-Inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Blk=-Inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Blk=-Inscriptional_Parthian}', "");
    Error('\p{Is_Block:    inscriptional_Parthian:=}');
    Error('\P{Is_Block:    inscriptional_Parthian:=}');
    Expect(1, 68447, '\p{Is_Block:   inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Block:   inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Block:   inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Block:   inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Block:   inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Block:   inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Block:   inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Block:   inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68447, '\P{Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68448, '\p{Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(1, 68448, '\P{Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Block=	_INSCRIPTIONAL_Parthian}', "");
    Error('\p{Is_Blk=-/a/INSCRIPTIONAL_parthian}');
    Error('\P{Is_Blk=-/a/INSCRIPTIONAL_parthian}');
    Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Blk=-_Inscriptional_parthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=-_Inscriptional_parthian}', "");
    Expect(0, 68447, '\P{Is_Blk=-_Inscriptional_parthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=-_Inscriptional_parthian}', "");
    Expect(0, 68448, '\p{Is_Blk=-_Inscriptional_parthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=-_Inscriptional_parthian}', "");
    Expect(1, 68448, '\P{Is_Blk=-_Inscriptional_parthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=-_Inscriptional_parthian}', "");
    Error('\p{Block=	:=IPA_Extensions}');
    Error('\P{Block=	:=IPA_Extensions}');
    Expect(1, 687, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(1, 687, '\p{Block:ipaextensions}', "");
    Expect(0, 687, '\p{^Block:ipaextensions}', "");
    Expect(0, 687, '\P{Block:ipaextensions}', "");
    Expect(1, 687, '\P{^Block:ipaextensions}', "");
    Expect(0, 688, '\p{Block:ipaextensions}', "");
    Expect(1, 688, '\p{^Block:ipaextensions}', "");
    Expect(1, 688, '\P{Block:ipaextensions}', "");
    Expect(0, 688, '\P{^Block:ipaextensions}', "");
    Expect(1, 687, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(1, 687, '\p{Block= IPA_Extensions}', "");
    Expect(0, 687, '\p{^Block= IPA_Extensions}', "");
    Expect(0, 687, '\P{Block= IPA_Extensions}', "");
    Expect(1, 687, '\P{^Block= IPA_Extensions}', "");
    Expect(0, 688, '\p{Block= IPA_Extensions}', "");
    Expect(1, 688, '\p{^Block= IPA_Extensions}', "");
    Expect(1, 688, '\P{Block= IPA_Extensions}', "");
    Expect(0, 688, '\P{^Block= IPA_Extensions}', "");
    Error('\p{Blk=_:=ipa_EXT}');
    Error('\P{Blk=_:=ipa_EXT}');
    Expect(1, 687, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(1, 687, '\p{Blk=ipaext}', "");
    Expect(0, 687, '\p{^Blk=ipaext}', "");
    Expect(0, 687, '\P{Blk=ipaext}', "");
    Expect(1, 687, '\P{^Blk=ipaext}', "");
    Expect(0, 688, '\p{Blk=ipaext}', "");
    Expect(1, 688, '\p{^Blk=ipaext}', "");
    Expect(1, 688, '\P{Blk=ipaext}', "");
    Expect(0, 688, '\P{^Blk=ipaext}', "");
    Expect(1, 687, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(1, 687, '\p{Blk=	IPA_Ext}', "");
    Expect(0, 687, '\p{^Blk=	IPA_Ext}', "");
    Expect(0, 687, '\P{Blk=	IPA_Ext}', "");
    Expect(1, 687, '\P{^Blk=	IPA_Ext}', "");
    Expect(0, 688, '\p{Blk=	IPA_Ext}', "");
    Expect(1, 688, '\p{^Blk=	IPA_Ext}', "");
    Expect(1, 688, '\P{Blk=	IPA_Ext}', "");
    Expect(0, 688, '\P{^Blk=	IPA_Ext}', "");
    Error('\p{Is_Block=		IPA_extensions:=}');
    Error('\P{Is_Block=		IPA_extensions:=}');
    Expect(1, 687, '\p{Is_Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Is_Block=ipaextensions}', "");
    Expect(0, 687, '\P{Is_Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Is_Block=ipaextensions}', "");
    Expect(0, 688, '\p{Is_Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Is_Block=ipaextensions}', "");
    Expect(1, 688, '\P{Is_Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Is_Block=ipaextensions}', "");
    Expect(1, 687, '\p{Is_Block=-IPA_Extensions}', "");
    Expect(0, 687, '\p{^Is_Block=-IPA_Extensions}', "");
    Expect(0, 687, '\P{Is_Block=-IPA_Extensions}', "");
    Expect(1, 687, '\P{^Is_Block=-IPA_Extensions}', "");
    Expect(0, 688, '\p{Is_Block=-IPA_Extensions}', "");
    Expect(1, 688, '\p{^Is_Block=-IPA_Extensions}', "");
    Expect(1, 688, '\P{Is_Block=-IPA_Extensions}', "");
    Expect(0, 688, '\P{^Is_Block=-IPA_Extensions}', "");
    Error('\p{Is_Blk=-/a/ipa_Ext}');
    Error('\P{Is_Blk=-/a/ipa_Ext}');
    Expect(1, 687, '\p{Is_Blk=ipaext}', "");
    Expect(0, 687, '\p{^Is_Blk=ipaext}', "");
    Expect(0, 687, '\P{Is_Blk=ipaext}', "");
    Expect(1, 687, '\P{^Is_Blk=ipaext}', "");
    Expect(0, 688, '\p{Is_Blk=ipaext}', "");
    Expect(1, 688, '\p{^Is_Blk=ipaext}', "");
    Expect(1, 688, '\P{Is_Blk=ipaext}', "");
    Expect(0, 688, '\P{^Is_Blk=ipaext}', "");
    Expect(1, 687, '\p{Is_Blk:	-ipa_Ext}', "");
    Expect(0, 687, '\p{^Is_Blk:	-ipa_Ext}', "");
    Expect(0, 687, '\P{Is_Blk:	-ipa_Ext}', "");
    Expect(1, 687, '\P{^Is_Blk:	-ipa_Ext}', "");
    Expect(0, 688, '\p{Is_Blk:	-ipa_Ext}', "");
    Expect(1, 688, '\p{^Is_Blk:	-ipa_Ext}', "");
    Expect(1, 688, '\P{Is_Blk:	-ipa_Ext}', "");
    Expect(0, 688, '\P{^Is_Blk:	-ipa_Ext}', "");
    Error('\p{Block=:=HANGUL_Jamo}');
    Error('\P{Block=:=HANGUL_Jamo}');
    Expect(1, 4607, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(1, 4607, '\p{Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(1, 4607, '\p{Block=	 Hangul_JAMO}', "");
    Expect(0, 4607, '\p{^Block=	 Hangul_JAMO}', "");
    Expect(0, 4607, '\P{Block=	 Hangul_JAMO}', "");
    Expect(1, 4607, '\P{^Block=	 Hangul_JAMO}', "");
    Expect(0, 4608, '\p{Block=	 Hangul_JAMO}', "");
    Expect(1, 4608, '\p{^Block=	 Hangul_JAMO}', "");
    Expect(1, 4608, '\P{Block=	 Hangul_JAMO}', "");
    Expect(0, 4608, '\P{^Block=	 Hangul_JAMO}', "");
    Error('\p{Blk=	JAMO/a/}');
    Error('\P{Blk=	JAMO/a/}');
    Expect(1, 4607, '\p{Blk=:\AJamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\AJamo\z:}', "");;
    Expect(1, 4607, '\p{Blk=jamo}', "");
    Expect(0, 4607, '\p{^Blk=jamo}', "");
    Expect(0, 4607, '\P{Blk=jamo}', "");
    Expect(1, 4607, '\P{^Blk=jamo}', "");
    Expect(0, 4608, '\p{Blk=jamo}', "");
    Expect(1, 4608, '\p{^Blk=jamo}', "");
    Expect(1, 4608, '\P{Blk=jamo}', "");
    Expect(0, 4608, '\P{^Blk=jamo}', "");
    Expect(1, 4607, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(1, 4607, '\p{Blk=-_JAMO}', "");
    Expect(0, 4607, '\p{^Blk=-_JAMO}', "");
    Expect(0, 4607, '\P{Blk=-_JAMO}', "");
    Expect(1, 4607, '\P{^Blk=-_JAMO}', "");
    Expect(0, 4608, '\p{Blk=-_JAMO}', "");
    Expect(1, 4608, '\p{^Blk=-_JAMO}', "");
    Expect(1, 4608, '\P{Blk=-_JAMO}', "");
    Expect(0, 4608, '\P{^Blk=-_JAMO}', "");
    Error('\p{Is_Block=/a/ _hangul_jamo}');
    Error('\P{Is_Block=/a/ _hangul_jamo}');
    Expect(1, 4607, '\p{Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Is_Block:		Hangul_Jamo}', "");
    Expect(0, 4607, '\p{^Is_Block:		Hangul_Jamo}', "");
    Expect(0, 4607, '\P{Is_Block:		Hangul_Jamo}', "");
    Expect(1, 4607, '\P{^Is_Block:		Hangul_Jamo}', "");
    Expect(0, 4608, '\p{Is_Block:		Hangul_Jamo}', "");
    Expect(1, 4608, '\p{^Is_Block:		Hangul_Jamo}', "");
    Expect(1, 4608, '\P{Is_Block:		Hangul_Jamo}', "");
    Expect(0, 4608, '\P{^Is_Block:		Hangul_Jamo}', "");
    Error('\p{Is_Blk=  jamo/a/}');
    Error('\P{Is_Blk=  jamo/a/}');
    Expect(1, 4607, '\p{Is_Blk=jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk=jamo}', "");
    Expect(0, 4607, '\P{Is_Blk=jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk=jamo}', "");
    Expect(0, 4608, '\p{Is_Blk=jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk=jamo}', "");
    Expect(1, 4608, '\P{Is_Blk=jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk=jamo}', "");
    Expect(1, 4607, '\p{Is_Blk=JAMO}', "");
    Expect(0, 4607, '\p{^Is_Blk=JAMO}', "");
    Expect(0, 4607, '\P{Is_Blk=JAMO}', "");
    Expect(1, 4607, '\P{^Is_Blk=JAMO}', "");
    Expect(0, 4608, '\p{Is_Blk=JAMO}', "");
    Expect(1, 4608, '\p{^Is_Blk=JAMO}', "");
    Expect(1, 4608, '\P{Is_Blk=JAMO}', "");
    Expect(0, 4608, '\P{^Is_Blk=JAMO}', "");
    Error('\p{Block=  Hangul_JAMO_Extended_A/a/}');
    Error('\P{Block=  Hangul_JAMO_Extended_A/a/}');
    Expect(1, 43391, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(0, 43392, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(1, 43391, '\p{Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(0, 43392, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(1, 43391, '\p{Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(0, 43391, '\p{^Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(0, 43391, '\P{Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(1, 43391, '\P{^Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(0, 43392, '\p{Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(1, 43392, '\p{^Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(1, 43392, '\P{Block= 	Hangul_Jamo_Extended_a}', "");
    Expect(0, 43392, '\P{^Block= 	Hangul_Jamo_Extended_a}', "");
    Error('\p{Blk= 	Jamo_ext_a:=}');
    Error('\P{Blk= 	Jamo_ext_a:=}');
    Expect(1, 43391, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(1, 43391, '\p{Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(1, 43391, '\p{Blk=Jamo_ext_a}', "");
    Expect(0, 43391, '\p{^Blk=Jamo_ext_a}', "");
    Expect(0, 43391, '\P{Blk=Jamo_ext_a}', "");
    Expect(1, 43391, '\P{^Blk=Jamo_ext_a}', "");
    Expect(0, 43392, '\p{Blk=Jamo_ext_a}', "");
    Expect(1, 43392, '\p{^Blk=Jamo_ext_a}', "");
    Expect(1, 43392, '\P{Blk=Jamo_ext_a}', "");
    Expect(0, 43392, '\P{^Blk=Jamo_ext_a}', "");
    Error('\p{Is_Block=_	hangul_Jamo_extended_A/a/}');
    Error('\P{Is_Block=_	hangul_Jamo_extended_A/a/}');
    Expect(1, 43391, '\p{Is_Block:	hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Is_Block:	hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Is_Block:	hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Is_Block:	hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Is_Block:	hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Is_Block:	hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Is_Block:	hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Is_Block:	hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(0, 43391, '\p{^Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(0, 43391, '\P{Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(1, 43391, '\P{^Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(0, 43392, '\p{Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(1, 43392, '\p{^Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(1, 43392, '\P{Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Expect(0, 43392, '\P{^Is_Block=	 HANGUL_jamo_Extended_a}', "");
    Error('\p{Is_Blk=_jamo_EXT_a/a/}');
    Error('\P{Is_Blk=_jamo_EXT_a/a/}');
    Expect(1, 43391, '\p{Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Is_Blk=- Jamo_Ext_a}', "");
    Expect(0, 43391, '\p{^Is_Blk=- Jamo_Ext_a}', "");
    Expect(0, 43391, '\P{Is_Blk=- Jamo_Ext_a}', "");
    Expect(1, 43391, '\P{^Is_Blk=- Jamo_Ext_a}', "");
    Expect(0, 43392, '\p{Is_Blk=- Jamo_Ext_a}', "");
    Expect(1, 43392, '\p{^Is_Blk=- Jamo_Ext_a}', "");
    Expect(1, 43392, '\P{Is_Blk=- Jamo_Ext_a}', "");
    Expect(0, 43392, '\P{^Is_Blk=- Jamo_Ext_a}', "");
    Error('\p{Block=/a/	_Hangul_jamo_EXTENDED_B}');
    Error('\P{Block=/a/	_Hangul_jamo_EXTENDED_B}');
    Expect(1, 55295, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(1, 55295, '\p{Block=	Hangul_JAMO_Extended_B}', "");
    Expect(0, 55295, '\p{^Block=	Hangul_JAMO_Extended_B}', "");
    Expect(0, 55295, '\P{Block=	Hangul_JAMO_Extended_B}', "");
    Expect(1, 55295, '\P{^Block=	Hangul_JAMO_Extended_B}', "");
    Expect(0, 57344, '\p{Block=	Hangul_JAMO_Extended_B}', "");
    Expect(1, 57344, '\p{^Block=	Hangul_JAMO_Extended_B}', "");
    Expect(1, 57344, '\P{Block=	Hangul_JAMO_Extended_B}', "");
    Expect(0, 57344, '\P{^Block=	Hangul_JAMO_Extended_B}', "");
    Error('\p{Blk: /a/_Jamo_Ext_B}');
    Error('\P{Blk: /a/_Jamo_Ext_B}');
    Expect(1, 55295, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(1, 55295, '\p{Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(1, 55295, '\p{Blk=- JAMO_EXT_B}', "");
    Expect(0, 55295, '\p{^Blk=- JAMO_EXT_B}', "");
    Expect(0, 55295, '\P{Blk=- JAMO_EXT_B}', "");
    Expect(1, 55295, '\P{^Blk=- JAMO_EXT_B}', "");
    Expect(0, 57344, '\p{Blk=- JAMO_EXT_B}', "");
    Expect(1, 57344, '\p{^Blk=- JAMO_EXT_B}', "");
    Expect(1, 57344, '\P{Blk=- JAMO_EXT_B}', "");
    Expect(0, 57344, '\P{^Blk=- JAMO_EXT_B}', "");
    Error('\p{Is_Block=-Hangul_Jamo_Extended_B:=}');
    Error('\P{Is_Block=-Hangul_Jamo_Extended_B:=}');
    Expect(1, 55295, '\p{Is_Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Is_Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Is_Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Is_Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Is_Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Is_Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Is_Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Is_Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\p{^Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\P{Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(1, 55295, '\P{^Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\p{Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\p{^Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\P{Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\P{^Is_Block=	_Hangul_Jamo_Extended_B}', "");
    Error('\p{Is_Blk=_/a/jamo_Ext_B}');
    Error('\P{Is_Blk=_/a/jamo_Ext_B}');
    Expect(1, 55295, '\p{Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Is_Blk=_ JAMO_Ext_b}', "");
    Expect(0, 55295, '\p{^Is_Blk=_ JAMO_Ext_b}', "");
    Expect(0, 55295, '\P{Is_Blk=_ JAMO_Ext_b}', "");
    Expect(1, 55295, '\P{^Is_Blk=_ JAMO_Ext_b}', "");
    Expect(0, 57344, '\p{Is_Blk=_ JAMO_Ext_b}', "");
    Expect(1, 57344, '\p{^Is_Blk=_ JAMO_Ext_b}', "");
    Expect(1, 57344, '\P{Is_Blk=_ JAMO_Ext_b}', "");
    Expect(0, 57344, '\P{^Is_Blk=_ JAMO_Ext_b}', "");
    Error('\p{Block=-/a/JAVANESE}');
    Error('\P{Block=-/a/JAVANESE}');
    Expect(1, 43487, '\p{Block=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Block=javanese}', "");
    Expect(0, 43487, '\p{^Block=javanese}', "");
    Expect(0, 43487, '\P{Block=javanese}', "");
    Expect(1, 43487, '\P{^Block=javanese}', "");
    Expect(0, 43488, '\p{Block=javanese}', "");
    Expect(1, 43488, '\p{^Block=javanese}', "");
    Expect(1, 43488, '\P{Block=javanese}', "");
    Expect(0, 43488, '\P{^Block=javanese}', "");
    Expect(1, 43487, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Block: - Javanese}', "");
    Expect(0, 43487, '\p{^Block: - Javanese}', "");
    Expect(0, 43487, '\P{Block: - Javanese}', "");
    Expect(1, 43487, '\P{^Block: - Javanese}', "");
    Expect(0, 43488, '\p{Block: - Javanese}', "");
    Expect(1, 43488, '\p{^Block: - Javanese}', "");
    Expect(1, 43488, '\P{Block: - Javanese}', "");
    Expect(0, 43488, '\P{^Block: - Javanese}', "");
    Error('\p{Blk= /a/javanese}');
    Error('\P{Blk= /a/javanese}');
    Expect(1, 43487, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=javanese}', "");
    Expect(0, 43487, '\p{^Blk=javanese}', "");
    Expect(0, 43487, '\P{Blk=javanese}', "");
    Expect(1, 43487, '\P{^Blk=javanese}', "");
    Expect(0, 43488, '\p{Blk=javanese}', "");
    Expect(1, 43488, '\p{^Blk=javanese}', "");
    Expect(1, 43488, '\P{Blk=javanese}', "");
    Expect(0, 43488, '\P{^Blk=javanese}', "");
    Expect(1, 43487, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk:  Javanese}', "");
    Expect(0, 43487, '\p{^Blk:  Javanese}', "");
    Expect(0, 43487, '\P{Blk:  Javanese}', "");
    Expect(1, 43487, '\P{^Blk:  Javanese}', "");
    Expect(0, 43488, '\p{Blk:  Javanese}', "");
    Expect(1, 43488, '\p{^Blk:  Javanese}', "");
    Expect(1, 43488, '\P{Blk:  Javanese}', "");
    Expect(0, 43488, '\P{^Blk:  Javanese}', "");
    Error('\p{Is_Block: --javanese/a/}');
    Error('\P{Is_Block: --javanese/a/}');
    Expect(1, 43487, '\p{Is_Block=javanese}', "");
    Expect(0, 43487, '\p{^Is_Block=javanese}', "");
    Expect(0, 43487, '\P{Is_Block=javanese}', "");
    Expect(1, 43487, '\P{^Is_Block=javanese}', "");
    Expect(0, 43488, '\p{Is_Block=javanese}', "");
    Expect(1, 43488, '\p{^Is_Block=javanese}', "");
    Expect(1, 43488, '\P{Is_Block=javanese}', "");
    Expect(0, 43488, '\P{^Is_Block=javanese}', "");
    Expect(1, 43487, '\p{Is_Block: _Javanese}', "");
    Expect(0, 43487, '\p{^Is_Block: _Javanese}', "");
    Expect(0, 43487, '\P{Is_Block: _Javanese}', "");
    Expect(1, 43487, '\P{^Is_Block: _Javanese}', "");
    Expect(0, 43488, '\p{Is_Block: _Javanese}', "");
    Expect(1, 43488, '\p{^Is_Block: _Javanese}', "");
    Expect(1, 43488, '\P{Is_Block: _Javanese}', "");
    Expect(0, 43488, '\P{^Is_Block: _Javanese}', "");
    Error('\p{Is_Blk=/a/-	JAVANESE}');
    Error('\P{Is_Blk=/a/-	JAVANESE}');
    Expect(1, 43487, '\p{Is_Blk:javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk:javanese}', "");
    Expect(0, 43487, '\P{Is_Blk:javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk:javanese}', "");
    Expect(0, 43488, '\p{Is_Blk:javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk:javanese}', "");
    Expect(1, 43488, '\P{Is_Blk:javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk:javanese}', "");
    Expect(1, 43487, '\p{Is_Blk=-javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=-javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=-javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=-javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=-javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=-javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=-javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=-javanese}', "");
    Error('\p{Block=:=Kaithi}');
    Error('\P{Block=:=Kaithi}');
    Expect(1, 69839, '\p{Block=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=kaithi}', "");
    Expect(0, 69839, '\p{^Block=kaithi}', "");
    Expect(0, 69839, '\P{Block=kaithi}', "");
    Expect(1, 69839, '\P{^Block=kaithi}', "");
    Expect(0, 69840, '\p{Block=kaithi}', "");
    Expect(1, 69840, '\p{^Block=kaithi}', "");
    Expect(1, 69840, '\P{Block=kaithi}', "");
    Expect(0, 69840, '\P{^Block=kaithi}', "");
    Expect(1, 69839, '\p{Block=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Block= KAITHI}', "");
    Expect(0, 69839, '\p{^Block= KAITHI}', "");
    Expect(0, 69839, '\P{Block= KAITHI}', "");
    Expect(1, 69839, '\P{^Block= KAITHI}', "");
    Expect(0, 69840, '\p{Block= KAITHI}', "");
    Expect(1, 69840, '\p{^Block= KAITHI}', "");
    Expect(1, 69840, '\P{Block= KAITHI}', "");
    Expect(0, 69840, '\P{^Block= KAITHI}', "");
    Error('\p{Blk=:=-Kaithi}');
    Error('\P{Blk=:=-Kaithi}');
    Expect(1, 69839, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Blk=kaithi}', "");
    Expect(0, 69839, '\P{Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Blk=kaithi}', "");
    Expect(0, 69840, '\p{Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Blk=kaithi}', "");
    Expect(1, 69840, '\P{Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Blk=kaithi}', "");
    Expect(1, 69839, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk= -kaithi}', "");
    Expect(0, 69839, '\p{^Blk= -kaithi}', "");
    Expect(0, 69839, '\P{Blk= -kaithi}', "");
    Expect(1, 69839, '\P{^Blk= -kaithi}', "");
    Expect(0, 69840, '\p{Blk= -kaithi}', "");
    Expect(1, 69840, '\p{^Blk= -kaithi}', "");
    Expect(1, 69840, '\P{Blk= -kaithi}', "");
    Expect(0, 69840, '\P{^Blk= -kaithi}', "");
    Error('\p{Is_Block= :=Kaithi}');
    Error('\P{Is_Block= :=Kaithi}');
    Expect(1, 69839, '\p{Is_Block=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=kaithi}', "");
    Expect(1, 69839, '\p{Is_Block=  Kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=  Kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=  Kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=  Kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=  Kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=  Kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=  Kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=  Kaithi}', "");
    Error('\p{Is_Blk=/a/-	kaithi}');
    Error('\P{Is_Blk=/a/-	kaithi}');
    Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=kaithi}', "");
    Expect(1, 69839, '\p{Is_Blk:_Kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk:_Kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk:_Kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk:_Kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk:_Kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk:_Kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk:_Kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk:_Kaithi}', "");
    Error('\p{Block::=kana_extended_A}');
    Error('\P{Block::=kana_extended_A}');
    Expect(1, 110895, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(0, 110896, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(1, 110895, '\p{Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(0, 110896, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(1, 110895, '\p{Block=_ kana_extended_A}', "");
    Expect(0, 110895, '\p{^Block=_ kana_extended_A}', "");
    Expect(0, 110895, '\P{Block=_ kana_extended_A}', "");
    Expect(1, 110895, '\P{^Block=_ kana_extended_A}', "");
    Expect(0, 110896, '\p{Block=_ kana_extended_A}', "");
    Expect(1, 110896, '\p{^Block=_ kana_extended_A}', "");
    Expect(1, 110896, '\P{Block=_ kana_extended_A}', "");
    Expect(0, 110896, '\P{^Block=_ kana_extended_A}', "");
    Error('\p{Blk=Kana_Ext_A/a/}');
    Error('\P{Blk=Kana_Ext_A/a/}');
    Expect(1, 110895, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(1, 110895, '\p{Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(1, 110895, '\p{Blk=-	kana_Ext_a}', "");
    Expect(0, 110895, '\p{^Blk=-	kana_Ext_a}', "");
    Expect(0, 110895, '\P{Blk=-	kana_Ext_a}', "");
    Expect(1, 110895, '\P{^Blk=-	kana_Ext_a}', "");
    Expect(0, 110896, '\p{Blk=-	kana_Ext_a}', "");
    Expect(1, 110896, '\p{^Blk=-	kana_Ext_a}', "");
    Expect(1, 110896, '\P{Blk=-	kana_Ext_a}', "");
    Expect(0, 110896, '\P{^Blk=-	kana_Ext_a}', "");
    Error('\p{Is_Block=:=Kana_Extended_a}');
    Error('\P{Is_Block=:=Kana_Extended_a}');
    Expect(1, 110895, '\p{Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Is_Block=-KANA_Extended_A}', "");
    Expect(0, 110895, '\p{^Is_Block=-KANA_Extended_A}', "");
    Expect(0, 110895, '\P{Is_Block=-KANA_Extended_A}', "");
    Expect(1, 110895, '\P{^Is_Block=-KANA_Extended_A}', "");
    Expect(0, 110896, '\p{Is_Block=-KANA_Extended_A}', "");
    Expect(1, 110896, '\p{^Is_Block=-KANA_Extended_A}', "");
    Expect(1, 110896, '\P{Is_Block=-KANA_Extended_A}', "");
    Expect(0, 110896, '\P{^Is_Block=-KANA_Extended_A}', "");
    Error('\p{Is_Blk= /a/Kana_EXT_A}');
    Error('\P{Is_Blk= /a/Kana_EXT_A}');
    Expect(1, 110895, '\p{Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Is_Blk= KANA_EXT_A}', "");
    Expect(0, 110895, '\p{^Is_Blk= KANA_EXT_A}', "");
    Expect(0, 110895, '\P{Is_Blk= KANA_EXT_A}', "");
    Expect(1, 110895, '\P{^Is_Blk= KANA_EXT_A}', "");
    Expect(0, 110896, '\p{Is_Blk= KANA_EXT_A}', "");
    Expect(1, 110896, '\p{^Is_Blk= KANA_EXT_A}', "");
    Expect(1, 110896, '\P{Is_Blk= KANA_EXT_A}', "");
    Expect(0, 110896, '\P{^Is_Blk= KANA_EXT_A}', "");
    Error('\p{Block:   /a/-	kana_Supplement}');
    Error('\P{Block:   /a/-	kana_Supplement}');
    Expect(1, 110847, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(1, 110847, '\p{Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(1, 110847, '\p{Block:-	Kana_supplement}', "");
    Expect(0, 110847, '\p{^Block:-	Kana_supplement}', "");
    Expect(0, 110847, '\P{Block:-	Kana_supplement}', "");
    Expect(1, 110847, '\P{^Block:-	Kana_supplement}', "");
    Expect(0, 110848, '\p{Block:-	Kana_supplement}', "");
    Expect(1, 110848, '\p{^Block:-	Kana_supplement}', "");
    Expect(1, 110848, '\P{Block:-	Kana_supplement}', "");
    Expect(0, 110848, '\P{^Block:-	Kana_supplement}', "");
    Error('\p{Blk::=kana_sup}');
    Error('\P{Blk::=kana_sup}');
    Expect(1, 110847, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(1, 110847, '\p{Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Blk=kanasup}', "");
    Expect(0, 110847, '\P{Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Blk=kanasup}', "");
    Expect(0, 110848, '\p{Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Blk=kanasup}', "");
    Expect(1, 110848, '\P{Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Blk=kanasup}', "");
    Expect(1, 110847, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(1, 110847, '\p{Blk= 	Kana_Sup}', "");
    Expect(0, 110847, '\p{^Blk= 	Kana_Sup}', "");
    Expect(0, 110847, '\P{Blk= 	Kana_Sup}', "");
    Expect(1, 110847, '\P{^Blk= 	Kana_Sup}', "");
    Expect(0, 110848, '\p{Blk= 	Kana_Sup}', "");
    Expect(1, 110848, '\p{^Blk= 	Kana_Sup}', "");
    Expect(1, 110848, '\P{Blk= 	Kana_Sup}', "");
    Expect(0, 110848, '\P{^Blk= 	Kana_Sup}', "");
    Error('\p{Is_Block=- Kana_SUPPLEMENT:=}');
    Error('\P{Is_Block=- Kana_SUPPLEMENT:=}');
    Expect(1, 110847, '\p{Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\p{^Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\P{Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(1, 110847, '\P{^Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\p{Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\p{^Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\P{Is_Block=_-kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\P{^Is_Block=_-kana_SUPPLEMENT}', "");
    Error('\p{Is_Blk=-:=Kana_Sup}');
    Error('\P{Is_Blk=-:=Kana_Sup}');
    Expect(1, 110847, '\p{Is_Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Is_Blk=kanasup}', "");
    Expect(0, 110847, '\P{Is_Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Is_Blk=kanasup}', "");
    Expect(0, 110848, '\p{Is_Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Is_Blk=kanasup}', "");
    Expect(1, 110848, '\P{Is_Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Is_Blk=kanasup}', "");
    Expect(1, 110847, '\p{Is_Blk:   	_KANA_SUP}', "");
    Expect(0, 110847, '\p{^Is_Blk:   	_KANA_SUP}', "");
    Expect(0, 110847, '\P{Is_Blk:   	_KANA_SUP}', "");
    Expect(1, 110847, '\P{^Is_Blk:   	_KANA_SUP}', "");
    Expect(0, 110848, '\p{Is_Blk:   	_KANA_SUP}', "");
    Expect(1, 110848, '\p{^Is_Blk:   	_KANA_SUP}', "");
    Expect(1, 110848, '\P{Is_Blk:   	_KANA_SUP}', "");
    Expect(0, 110848, '\P{^Is_Blk:   	_KANA_SUP}', "");
    Error('\p{Block=	Kanbun/a/}');
    Error('\P{Block=	Kanbun/a/}');
    Expect(1, 12703, '\p{Block=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Block=kanbun}', "");
    Expect(0, 12703, '\p{^Block=kanbun}', "");
    Expect(0, 12703, '\P{Block=kanbun}', "");
    Expect(1, 12703, '\P{^Block=kanbun}', "");
    Expect(0, 12704, '\p{Block=kanbun}', "");
    Expect(1, 12704, '\p{^Block=kanbun}', "");
    Expect(1, 12704, '\P{Block=kanbun}', "");
    Expect(0, 12704, '\P{^Block=kanbun}', "");
    Expect(1, 12703, '\p{Block=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Block= Kanbun}', "");
    Expect(0, 12703, '\p{^Block= Kanbun}', "");
    Expect(0, 12703, '\P{Block= Kanbun}', "");
    Expect(1, 12703, '\P{^Block= Kanbun}', "");
    Expect(0, 12704, '\p{Block= Kanbun}', "");
    Expect(1, 12704, '\p{^Block= Kanbun}', "");
    Expect(1, 12704, '\P{Block= Kanbun}', "");
    Expect(0, 12704, '\P{^Block= Kanbun}', "");
    Error('\p{Blk=	:=Kanbun}');
    Error('\P{Blk=	:=Kanbun}');
    Expect(1, 12703, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Blk=kanbun}', "");
    Expect(0, 12703, '\P{Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Blk=kanbun}', "");
    Expect(0, 12704, '\p{Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Blk=kanbun}', "");
    Expect(1, 12704, '\P{Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Blk=kanbun}', "");
    Expect(1, 12703, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=	_kanbun}', "");
    Expect(0, 12703, '\p{^Blk=	_kanbun}', "");
    Expect(0, 12703, '\P{Blk=	_kanbun}', "");
    Expect(1, 12703, '\P{^Blk=	_kanbun}', "");
    Expect(0, 12704, '\p{Blk=	_kanbun}', "");
    Expect(1, 12704, '\p{^Blk=	_kanbun}', "");
    Expect(1, 12704, '\P{Blk=	_kanbun}', "");
    Expect(0, 12704, '\P{^Blk=	_kanbun}', "");
    Error('\p{Is_Block=/a/-Kanbun}');
    Error('\P{Is_Block=/a/-Kanbun}');
    Expect(1, 12703, '\p{Is_Block: kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block: kanbun}', "");
    Expect(0, 12703, '\P{Is_Block: kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block: kanbun}', "");
    Expect(0, 12704, '\p{Is_Block: kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block: kanbun}', "");
    Expect(1, 12704, '\P{Is_Block: kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block: kanbun}', "");
    Expect(1, 12703, '\p{Is_Block=--Kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=--Kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=--Kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=--Kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=--Kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=--Kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=--Kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=--Kanbun}', "");
    Error('\p{Is_Blk= Kanbun:=}');
    Error('\P{Is_Blk= Kanbun:=}');
    Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=kanbun}', "");
    Expect(1, 12703, '\p{Is_Blk=_Kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=_Kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=_Kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=_Kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=_Kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=_Kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=_Kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=_Kanbun}', "");
    Error('\p{Block=__Kangxi_Radicals/a/}');
    Error('\P{Block=__Kangxi_Radicals/a/}');
    Expect(1, 12255, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(1, 12255, '\p{Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(1, 12255, '\p{Block=_-Kangxi_Radicals}', "");
    Expect(0, 12255, '\p{^Block=_-Kangxi_Radicals}', "");
    Expect(0, 12255, '\P{Block=_-Kangxi_Radicals}', "");
    Expect(1, 12255, '\P{^Block=_-Kangxi_Radicals}', "");
    Expect(0, 12256, '\p{Block=_-Kangxi_Radicals}', "");
    Expect(1, 12256, '\p{^Block=_-Kangxi_Radicals}', "");
    Expect(1, 12256, '\P{Block=_-Kangxi_Radicals}', "");
    Expect(0, 12256, '\P{^Block=_-Kangxi_Radicals}', "");
    Error('\p{Blk=/a/kangxi}');
    Error('\P{Blk=/a/kangxi}');
    Expect(1, 12255, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Blk=kangxi}', "");
    Expect(0, 12255, '\P{Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Blk=kangxi}', "");
    Expect(0, 12256, '\p{Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Blk=kangxi}', "");
    Expect(1, 12256, '\P{Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Blk=kangxi}', "");
    Expect(1, 12255, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=- kangxi}', "");
    Expect(0, 12255, '\p{^Blk=- kangxi}', "");
    Expect(0, 12255, '\P{Blk=- kangxi}', "");
    Expect(1, 12255, '\P{^Blk=- kangxi}', "");
    Expect(0, 12256, '\p{Blk=- kangxi}', "");
    Expect(1, 12256, '\p{^Blk=- kangxi}', "");
    Expect(1, 12256, '\P{Blk=- kangxi}', "");
    Expect(0, 12256, '\P{^Blk=- kangxi}', "");
    Error('\p{Is_Block=-kangxi_Radicals/a/}');
    Error('\P{Is_Block=-kangxi_Radicals/a/}');
    Expect(1, 12255, '\p{Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Is_Block:__Kangxi_Radicals}', "");
    Expect(0, 12255, '\p{^Is_Block:__Kangxi_Radicals}', "");
    Expect(0, 12255, '\P{Is_Block:__Kangxi_Radicals}', "");
    Expect(1, 12255, '\P{^Is_Block:__Kangxi_Radicals}', "");
    Expect(0, 12256, '\p{Is_Block:__Kangxi_Radicals}', "");
    Expect(1, 12256, '\p{^Is_Block:__Kangxi_Radicals}', "");
    Expect(1, 12256, '\P{Is_Block:__Kangxi_Radicals}', "");
    Expect(0, 12256, '\P{^Is_Block:__Kangxi_Radicals}', "");
    Error('\p{Is_Blk:/a/ 	Kangxi}');
    Error('\P{Is_Blk:/a/ 	Kangxi}');
    Expect(1, 12255, '\p{Is_Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=kangxi}', "");
    Expect(1, 12255, '\p{Is_Blk=	-kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=	-kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=	-kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=	-kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=	-kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=	-kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=	-kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=	-kangxi}', "");
    Error('\p{Block:   :=_KANNADA}');
    Error('\P{Block:   :=_KANNADA}');
    Expect(1, 3327, '\p{Block=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Block:kannada}', "");
    Expect(0, 3327, '\p{^Block:kannada}', "");
    Expect(0, 3327, '\P{Block:kannada}', "");
    Expect(1, 3327, '\P{^Block:kannada}', "");
    Expect(0, 3328, '\p{Block:kannada}', "");
    Expect(1, 3328, '\p{^Block:kannada}', "");
    Expect(1, 3328, '\P{Block:kannada}', "");
    Expect(0, 3328, '\P{^Block:kannada}', "");
    Expect(1, 3327, '\p{Block=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Block=-Kannada}', "");
    Expect(0, 3327, '\p{^Block=-Kannada}', "");
    Expect(0, 3327, '\P{Block=-Kannada}', "");
    Expect(1, 3327, '\P{^Block=-Kannada}', "");
    Expect(0, 3328, '\p{Block=-Kannada}', "");
    Expect(1, 3328, '\p{^Block=-Kannada}', "");
    Expect(1, 3328, '\P{Block=-Kannada}', "");
    Expect(0, 3328, '\P{^Block=-Kannada}', "");
    Error('\p{Blk:	_:=KANNADA}');
    Error('\P{Blk:	_:=KANNADA}');
    Expect(1, 3327, '\p{Blk=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=kannada}', "");
    Expect(0, 3327, '\p{^Blk=kannada}', "");
    Expect(0, 3327, '\P{Blk=kannada}', "");
    Expect(1, 3327, '\P{^Blk=kannada}', "");
    Expect(0, 3328, '\p{Blk=kannada}', "");
    Expect(1, 3328, '\p{^Blk=kannada}', "");
    Expect(1, 3328, '\P{Blk=kannada}', "");
    Expect(0, 3328, '\P{^Blk=kannada}', "");
    Expect(1, 3327, '\p{Blk=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Blk:		_Kannada}', "");
    Expect(0, 3327, '\p{^Blk:		_Kannada}', "");
    Expect(0, 3327, '\P{Blk:		_Kannada}', "");
    Expect(1, 3327, '\P{^Blk:		_Kannada}', "");
    Expect(0, 3328, '\p{Blk:		_Kannada}', "");
    Expect(1, 3328, '\p{^Blk:		_Kannada}', "");
    Expect(1, 3328, '\P{Blk:		_Kannada}', "");
    Expect(0, 3328, '\P{^Blk:		_Kannada}', "");
    Error('\p{Is_Block=_	kannada/a/}');
    Error('\P{Is_Block=_	kannada/a/}');
    Expect(1, 3327, '\p{Is_Block=kannada}', "");
    Expect(0, 3327, '\p{^Is_Block=kannada}', "");
    Expect(0, 3327, '\P{Is_Block=kannada}', "");
    Expect(1, 3327, '\P{^Is_Block=kannada}', "");
    Expect(0, 3328, '\p{Is_Block=kannada}', "");
    Expect(1, 3328, '\p{^Is_Block=kannada}', "");
    Expect(1, 3328, '\P{Is_Block=kannada}', "");
    Expect(0, 3328, '\P{^Is_Block=kannada}', "");
    Expect(1, 3327, '\p{Is_Block=-Kannada}', "");
    Expect(0, 3327, '\p{^Is_Block=-Kannada}', "");
    Expect(0, 3327, '\P{Is_Block=-Kannada}', "");
    Expect(1, 3327, '\P{^Is_Block=-Kannada}', "");
    Expect(0, 3328, '\p{Is_Block=-Kannada}', "");
    Expect(1, 3328, '\p{^Is_Block=-Kannada}', "");
    Expect(1, 3328, '\P{Is_Block=-Kannada}', "");
    Expect(0, 3328, '\P{^Is_Block=-Kannada}', "");
    Error('\p{Is_Blk=/a/_kannada}');
    Error('\P{Is_Blk=/a/_kannada}');
    Expect(1, 3327, '\p{Is_Blk=kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=kannada}', "");
    Expect(1, 3327, '\p{Is_Blk=		kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=		kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=		kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=		kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=		kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=		kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=		kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=		kannada}', "");
    Error('\p{Block=_/a/Katakana}');
    Error('\P{Block=_/a/Katakana}');
    Expect(1, 12543, '\p{Block=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Block=katakana}', "");
    Expect(0, 12543, '\p{^Block=katakana}', "");
    Expect(0, 12543, '\P{Block=katakana}', "");
    Expect(1, 12543, '\P{^Block=katakana}', "");
    Expect(0, 12544, '\p{Block=katakana}', "");
    Expect(1, 12544, '\p{^Block=katakana}', "");
    Expect(1, 12544, '\P{Block=katakana}', "");
    Expect(0, 12544, '\P{^Block=katakana}', "");
    Expect(1, 12543, '\p{Block=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Block= katakana}', "");
    Expect(0, 12543, '\p{^Block= katakana}', "");
    Expect(0, 12543, '\P{Block= katakana}', "");
    Expect(1, 12543, '\P{^Block= katakana}', "");
    Expect(0, 12544, '\p{Block= katakana}', "");
    Expect(1, 12544, '\p{^Block= katakana}', "");
    Expect(1, 12544, '\P{Block= katakana}', "");
    Expect(0, 12544, '\P{^Block= katakana}', "");
    Error('\p{Blk=/a/_ katakana}');
    Error('\P{Blk=/a/_ katakana}');
    Expect(1, 12543, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk:	katakana}', "");
    Expect(0, 12543, '\p{^Blk:	katakana}', "");
    Expect(0, 12543, '\P{Blk:	katakana}', "");
    Expect(1, 12543, '\P{^Blk:	katakana}', "");
    Expect(0, 12544, '\p{Blk:	katakana}', "");
    Expect(1, 12544, '\p{^Blk:	katakana}', "");
    Expect(1, 12544, '\P{Blk:	katakana}', "");
    Expect(0, 12544, '\P{^Blk:	katakana}', "");
    Expect(1, 12543, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk=Katakana}', "");
    Expect(0, 12543, '\p{^Blk=Katakana}', "");
    Expect(0, 12543, '\P{Blk=Katakana}', "");
    Expect(1, 12543, '\P{^Blk=Katakana}', "");
    Expect(0, 12544, '\p{Blk=Katakana}', "");
    Expect(1, 12544, '\p{^Blk=Katakana}', "");
    Expect(1, 12544, '\P{Blk=Katakana}', "");
    Expect(0, 12544, '\P{^Blk=Katakana}', "");
    Error('\p{Is_Block=:=_-Katakana}');
    Error('\P{Is_Block=:=_-Katakana}');
    Expect(1, 12543, '\p{Is_Block=katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=katakana}', "");
    Expect(0, 12543, '\P{Is_Block=katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=katakana}', "");
    Expect(0, 12544, '\p{Is_Block=katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=katakana}', "");
    Expect(1, 12544, '\P{Is_Block=katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=katakana}', "");
    Expect(1, 12543, '\p{Is_Block=_Katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=_Katakana}', "");
    Expect(0, 12543, '\P{Is_Block=_Katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=_Katakana}', "");
    Expect(0, 12544, '\p{Is_Block=_Katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=_Katakana}', "");
    Expect(1, 12544, '\P{Is_Block=_Katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=_Katakana}', "");
    Error('\p{Is_Blk=/a/katakana}');
    Error('\P{Is_Blk=/a/katakana}');
    Expect(1, 12543, '\p{Is_Blk=katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=katakana}', "");
    Expect(1, 12543, '\p{Is_Blk=		Katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=		Katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=		Katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=		Katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=		Katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=		Katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=		Katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=		Katakana}', "");
    Error('\p{Block: /a/	katakana_Phonetic_Extensions}');
    Error('\P{Block: /a/	katakana_Phonetic_Extensions}');
    Expect(1, 12799, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(1, 12799, '\p{Block:	KATAKANA_phonetic_extensions}', "");
    Expect(0, 12799, '\p{^Block:	KATAKANA_phonetic_extensions}', "");
    Expect(0, 12799, '\P{Block:	KATAKANA_phonetic_extensions}', "");
    Expect(1, 12799, '\P{^Block:	KATAKANA_phonetic_extensions}', "");
    Expect(0, 12800, '\p{Block:	KATAKANA_phonetic_extensions}', "");
    Expect(1, 12800, '\p{^Block:	KATAKANA_phonetic_extensions}', "");
    Expect(1, 12800, '\P{Block:	KATAKANA_phonetic_extensions}', "");
    Expect(0, 12800, '\P{^Block:	KATAKANA_phonetic_extensions}', "");
    Error('\p{Blk=_/a/Katakana_Ext}');
    Error('\P{Blk=_/a/Katakana_Ext}');
    Expect(1, 12799, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(1, 12799, '\p{Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(1, 12799, '\p{Blk=-_KATAKANA_ext}', "");
    Expect(0, 12799, '\p{^Blk=-_KATAKANA_ext}', "");
    Expect(0, 12799, '\P{Blk=-_KATAKANA_ext}', "");
    Expect(1, 12799, '\P{^Blk=-_KATAKANA_ext}', "");
    Expect(0, 12800, '\p{Blk=-_KATAKANA_ext}', "");
    Expect(1, 12800, '\p{^Blk=-_KATAKANA_ext}', "");
    Expect(1, 12800, '\P{Blk=-_KATAKANA_ext}', "");
    Expect(0, 12800, '\P{^Blk=-_KATAKANA_ext}', "");
    Error('\p{Is_Block=:=-	Katakana_Phonetic_Extensions}');
    Error('\P{Is_Block=:=-	Katakana_Phonetic_Extensions}');
    Expect(1, 12799, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(0, 12799, '\p{^Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(0, 12799, '\P{Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(1, 12799, '\P{^Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(0, 12800, '\p{Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(1, 12800, '\p{^Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(1, 12800, '\P{Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Expect(0, 12800, '\P{^Is_Block=-katakana_PHONETIC_EXTENSIONS}', "");
    Error('\p{Is_Blk= /a/Katakana_Ext}');
    Error('\P{Is_Blk= /a/Katakana_Ext}');
    Expect(1, 12799, '\p{Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Is_Blk=	 KATAKANA_ext}', "");
    Expect(0, 12799, '\p{^Is_Blk=	 KATAKANA_ext}', "");
    Expect(0, 12799, '\P{Is_Blk=	 KATAKANA_ext}', "");
    Expect(1, 12799, '\P{^Is_Blk=	 KATAKANA_ext}', "");
    Expect(0, 12800, '\p{Is_Blk=	 KATAKANA_ext}', "");
    Expect(1, 12800, '\p{^Is_Blk=	 KATAKANA_ext}', "");
    Expect(1, 12800, '\P{Is_Blk=	 KATAKANA_ext}', "");
    Expect(0, 12800, '\P{^Is_Blk=	 KATAKANA_ext}', "");
    Error('\p{Block=  Kayah_li/a/}');
    Error('\P{Block=  Kayah_li/a/}');
    Expect(1, 43311, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Block=kayahli}', "");
    Expect(0, 43311, '\p{^Block=kayahli}', "");
    Expect(0, 43311, '\P{Block=kayahli}', "");
    Expect(1, 43311, '\P{^Block=kayahli}', "");
    Expect(0, 43312, '\p{Block=kayahli}', "");
    Expect(1, 43312, '\p{^Block=kayahli}', "");
    Expect(1, 43312, '\P{Block=kayahli}', "");
    Expect(0, 43312, '\P{^Block=kayahli}', "");
    Expect(1, 43311, '\p{Block=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Block=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Block=	KAYAH_Li}', "");
    Expect(0, 43311, '\p{^Block=	KAYAH_Li}', "");
    Expect(0, 43311, '\P{Block=	KAYAH_Li}', "");
    Expect(1, 43311, '\P{^Block=	KAYAH_Li}', "");
    Expect(0, 43312, '\p{Block=	KAYAH_Li}', "");
    Expect(1, 43312, '\p{^Block=	KAYAH_Li}', "");
    Expect(1, 43312, '\P{Block=	KAYAH_Li}', "");
    Expect(0, 43312, '\P{^Block=	KAYAH_Li}', "");
    Error('\p{Blk=	 kayah_Li/a/}');
    Error('\P{Blk=	 kayah_Li/a/}');
    Expect(1, 43311, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Blk=kayahli}', "");
    Expect(0, 43311, '\P{Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Blk=kayahli}', "");
    Expect(0, 43312, '\p{Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Blk=kayahli}', "");
    Expect(1, 43312, '\P{Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Blk=kayahli}', "");
    Expect(1, 43311, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Blk=__kayah_Li}', "");
    Expect(0, 43311, '\p{^Blk=__kayah_Li}', "");
    Expect(0, 43311, '\P{Blk=__kayah_Li}', "");
    Expect(1, 43311, '\P{^Blk=__kayah_Li}', "");
    Expect(0, 43312, '\p{Blk=__kayah_Li}', "");
    Expect(1, 43312, '\p{^Blk=__kayah_Li}', "");
    Expect(1, 43312, '\P{Blk=__kayah_Li}', "");
    Expect(0, 43312, '\P{^Blk=__kayah_Li}', "");
    Error('\p{Is_Block=/a/	Kayah_LI}');
    Error('\P{Is_Block=/a/	Kayah_LI}');
    Expect(1, 43311, '\p{Is_Block=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Block=kayahli}', "");
    Expect(0, 43311, '\P{Is_Block=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Block=kayahli}', "");
    Expect(0, 43312, '\p{Is_Block=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Block=kayahli}', "");
    Expect(1, 43312, '\P{Is_Block=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Block=kayahli}', "");
    Expect(1, 43311, '\p{Is_Block=	Kayah_LI}', "");
    Expect(0, 43311, '\p{^Is_Block=	Kayah_LI}', "");
    Expect(0, 43311, '\P{Is_Block=	Kayah_LI}', "");
    Expect(1, 43311, '\P{^Is_Block=	Kayah_LI}', "");
    Expect(0, 43312, '\p{Is_Block=	Kayah_LI}', "");
    Expect(1, 43312, '\p{^Is_Block=	Kayah_LI}', "");
    Expect(1, 43312, '\P{Is_Block=	Kayah_LI}', "");
    Expect(0, 43312, '\P{^Is_Block=	Kayah_LI}', "");
    Error('\p{Is_Blk=:=-	Kayah_Li}');
    Error('\P{Is_Blk=:=-	Kayah_Li}');
    Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
    Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
    Expect(0, 43312, '\p{Is_Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Blk=kayahli}', "");
    Expect(1, 43312, '\P{Is_Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Blk=kayahli}', "");
    Expect(1, 43311, '\p{Is_Blk=-_Kayah_li}', "");
    Expect(0, 43311, '\p{^Is_Blk=-_Kayah_li}', "");
    Expect(0, 43311, '\P{Is_Blk=-_Kayah_li}', "");
    Expect(1, 43311, '\P{^Is_Blk=-_Kayah_li}', "");
    Expect(0, 43312, '\p{Is_Blk=-_Kayah_li}', "");
    Expect(1, 43312, '\p{^Is_Blk=-_Kayah_li}', "");
    Expect(1, 43312, '\P{Is_Blk=-_Kayah_li}', "");
    Expect(0, 43312, '\P{^Is_Blk=-_Kayah_li}', "");
    Error('\p{Block=:=	kharoshthi}');
    Error('\P{Block=:=	kharoshthi}');
    Expect(1, 68191, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=--KHAROSHTHI}', "");
    Expect(0, 68191, '\p{^Block=--KHAROSHTHI}', "");
    Expect(0, 68191, '\P{Block=--KHAROSHTHI}', "");
    Expect(1, 68191, '\P{^Block=--KHAROSHTHI}', "");
    Expect(0, 68192, '\p{Block=--KHAROSHTHI}', "");
    Expect(1, 68192, '\p{^Block=--KHAROSHTHI}', "");
    Expect(1, 68192, '\P{Block=--KHAROSHTHI}', "");
    Expect(0, 68192, '\P{^Block=--KHAROSHTHI}', "");
    Error('\p{Blk=:=-KHAROSHTHI}');
    Error('\P{Blk=:=-KHAROSHTHI}');
    Expect(1, 68191, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk=_ Kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk=_ Kharoshthi}', "");
    Expect(0, 68191, '\P{Blk=_ Kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk=_ Kharoshthi}', "");
    Expect(0, 68192, '\p{Blk=_ Kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk=_ Kharoshthi}', "");
    Expect(1, 68192, '\P{Blk=_ Kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk=_ Kharoshthi}', "");
    Error('\p{Is_Block=/a/ _Kharoshthi}');
    Error('\P{Is_Block=/a/ _Kharoshthi}');
    Expect(1, 68191, '\p{Is_Block:   kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block:   kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block:   kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block:   kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block:   kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block:   kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block:   kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block:   kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Block=-KHAROSHTHI}', "");
    Expect(0, 68191, '\p{^Is_Block=-KHAROSHTHI}', "");
    Expect(0, 68191, '\P{Is_Block=-KHAROSHTHI}', "");
    Expect(1, 68191, '\P{^Is_Block=-KHAROSHTHI}', "");
    Expect(0, 68192, '\p{Is_Block=-KHAROSHTHI}', "");
    Expect(1, 68192, '\p{^Is_Block=-KHAROSHTHI}', "");
    Expect(1, 68192, '\P{Is_Block=-KHAROSHTHI}', "");
    Expect(0, 68192, '\P{^Is_Block=-KHAROSHTHI}', "");
    Error('\p{Is_Blk=-:=Kharoshthi}');
    Error('\P{Is_Blk=-:=Kharoshthi}');
    Expect(1, 68191, '\p{Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Blk:	 _Kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk:	 _Kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk:	 _Kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk:	 _Kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk:	 _Kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk:	 _Kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk:	 _Kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk:	 _Kharoshthi}', "");
    Error('\p{Block=:= khmer}');
    Error('\P{Block=:= khmer}');
    Expect(1, 6143, '\p{Block=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Block=khmer}', "");
    Expect(0, 6143, '\p{^Block=khmer}', "");
    Expect(0, 6143, '\P{Block=khmer}', "");
    Expect(1, 6143, '\P{^Block=khmer}', "");
    Expect(0, 6144, '\p{Block=khmer}', "");
    Expect(1, 6144, '\p{^Block=khmer}', "");
    Expect(1, 6144, '\P{Block=khmer}', "");
    Expect(0, 6144, '\P{^Block=khmer}', "");
    Expect(1, 6143, '\p{Block=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\Akhmer\z:}', "");;
    Error('\p{Blk=	/a/KHMER}');
    Error('\P{Blk=	/a/KHMER}');
    Expect(1, 6143, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=khmer}', "");
    Expect(0, 6143, '\p{^Blk=khmer}', "");
    Expect(0, 6143, '\P{Blk=khmer}', "");
    Expect(1, 6143, '\P{^Blk=khmer}', "");
    Expect(0, 6144, '\p{Blk=khmer}', "");
    Expect(1, 6144, '\p{^Blk=khmer}', "");
    Expect(1, 6144, '\P{Blk=khmer}', "");
    Expect(0, 6144, '\P{^Blk=khmer}', "");
    Expect(1, 6143, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk:   khmer}', "");
    Expect(0, 6143, '\p{^Blk:   khmer}', "");
    Expect(0, 6143, '\P{Blk:   khmer}', "");
    Expect(1, 6143, '\P{^Blk:   khmer}', "");
    Expect(0, 6144, '\p{Blk:   khmer}', "");
    Expect(1, 6144, '\p{^Blk:   khmer}', "");
    Expect(1, 6144, '\P{Blk:   khmer}', "");
    Expect(0, 6144, '\P{^Blk:   khmer}', "");
    Error('\p{Is_Block=:=	_khmer}');
    Error('\P{Is_Block=:=	_khmer}');
    Expect(1, 6143, '\p{Is_Block=khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=khmer}', "");
    Expect(0, 6143, '\P{Is_Block=khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=khmer}', "");
    Expect(0, 6144, '\p{Is_Block=khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=khmer}', "");
    Expect(1, 6144, '\P{Is_Block=khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=khmer}', "");
    Expect(1, 6143, '\p{Is_Block= Khmer}', "");
    Expect(0, 6143, '\p{^Is_Block= Khmer}', "");
    Expect(0, 6143, '\P{Is_Block= Khmer}', "");
    Expect(1, 6143, '\P{^Is_Block= Khmer}', "");
    Expect(0, 6144, '\p{Is_Block= Khmer}', "");
    Expect(1, 6144, '\p{^Is_Block= Khmer}', "");
    Expect(1, 6144, '\P{Is_Block= Khmer}', "");
    Expect(0, 6144, '\P{^Is_Block= Khmer}', "");
    Error('\p{Is_Blk=_/a/Khmer}');
    Error('\P{Is_Blk=_/a/Khmer}');
    Expect(1, 6143, '\p{Is_Blk: khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk: khmer}', "");
    Expect(0, 6143, '\P{Is_Blk: khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk: khmer}', "");
    Expect(0, 6144, '\p{Is_Blk: khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk: khmer}', "");
    Expect(1, 6144, '\P{Is_Blk: khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk: khmer}', "");
    Expect(1, 6143, '\p{Is_Blk=	 KHMER}', "");
    Expect(0, 6143, '\p{^Is_Blk=	 KHMER}', "");
    Expect(0, 6143, '\P{Is_Blk=	 KHMER}', "");
    Expect(1, 6143, '\P{^Is_Blk=	 KHMER}', "");
    Expect(0, 6144, '\p{Is_Blk=	 KHMER}', "");
    Expect(1, 6144, '\p{^Is_Blk=	 KHMER}', "");
    Expect(1, 6144, '\P{Is_Blk=	 KHMER}', "");
    Expect(0, 6144, '\P{^Is_Blk=	 KHMER}', "");
    Error('\p{Block=-:=khmer_Symbols}');
    Error('\P{Block=-:=khmer_Symbols}');
    Expect(1, 6655, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Block:	khmersymbols}', "");
    Expect(0, 6655, '\p{^Block:	khmersymbols}', "");
    Expect(0, 6655, '\P{Block:	khmersymbols}', "");
    Expect(1, 6655, '\P{^Block:	khmersymbols}', "");
    Expect(0, 6656, '\p{Block:	khmersymbols}', "");
    Expect(1, 6656, '\p{^Block:	khmersymbols}', "");
    Expect(1, 6656, '\P{Block:	khmersymbols}', "");
    Expect(0, 6656, '\P{^Block:	khmersymbols}', "");
    Expect(1, 6655, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Block=Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Block=Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\P{Block=Khmer_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Block=Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\p{Block=Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Block=Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\P{Block=Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Block=Khmer_SYMBOLS}', "");
    Error('\p{Blk=:=--KHMER_Symbols}');
    Error('\P{Blk=:=--KHMER_Symbols}');
    Expect(1, 6655, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Blk=_khmer_symbols}', "");
    Expect(0, 6655, '\p{^Blk=_khmer_symbols}', "");
    Expect(0, 6655, '\P{Blk=_khmer_symbols}', "");
    Expect(1, 6655, '\P{^Blk=_khmer_symbols}', "");
    Expect(0, 6656, '\p{Blk=_khmer_symbols}', "");
    Expect(1, 6656, '\p{^Blk=_khmer_symbols}', "");
    Expect(1, 6656, '\P{Blk=_khmer_symbols}', "");
    Expect(0, 6656, '\P{^Blk=_khmer_symbols}', "");
    Error('\p{Is_Block=/a/_ KHMER_Symbols}');
    Error('\P{Is_Block=/a/_ KHMER_Symbols}');
    Expect(1, 6655, '\p{Is_Block=khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Block=khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Block=khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Block=khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Block=khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Block=khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Block=khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Block=khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Block=-khmer_Symbols}', "");
    Expect(0, 6655, '\p{^Is_Block=-khmer_Symbols}', "");
    Expect(0, 6655, '\P{Is_Block=-khmer_Symbols}', "");
    Expect(1, 6655, '\P{^Is_Block=-khmer_Symbols}', "");
    Expect(0, 6656, '\p{Is_Block=-khmer_Symbols}', "");
    Expect(1, 6656, '\p{^Is_Block=-khmer_Symbols}', "");
    Expect(1, 6656, '\P{Is_Block=-khmer_Symbols}', "");
    Expect(0, 6656, '\P{^Is_Block=-khmer_Symbols}', "");
    Error('\p{Is_Blk:-_Khmer_SYMBOLS/a/}');
    Error('\P{Is_Blk:-_Khmer_SYMBOLS/a/}');
    Expect(1, 6655, '\p{Is_Blk: khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Blk: khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Blk: khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Blk: khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Blk: khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Blk: khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Blk: khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Blk: khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Blk=-khmer_Symbols}', "");
    Expect(0, 6655, '\p{^Is_Blk=-khmer_Symbols}', "");
    Expect(0, 6655, '\P{Is_Blk=-khmer_Symbols}', "");
    Expect(1, 6655, '\P{^Is_Blk=-khmer_Symbols}', "");
    Expect(0, 6656, '\p{Is_Blk=-khmer_Symbols}', "");
    Expect(1, 6656, '\p{^Is_Blk=-khmer_Symbols}', "");
    Expect(1, 6656, '\P{Is_Blk=-khmer_Symbols}', "");
    Expect(0, 6656, '\P{^Is_Blk=-khmer_Symbols}', "");
    Error('\p{Block=-khojki:=}');
    Error('\P{Block=-khojki:=}');
    Expect(1, 70223, '\p{Block=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=khojki}', "");
    Expect(0, 70223, '\p{^Block=khojki}', "");
    Expect(0, 70223, '\P{Block=khojki}', "");
    Expect(1, 70223, '\P{^Block=khojki}', "");
    Expect(0, 70224, '\p{Block=khojki}', "");
    Expect(1, 70224, '\p{^Block=khojki}', "");
    Expect(1, 70224, '\P{Block=khojki}', "");
    Expect(0, 70224, '\P{^Block=khojki}', "");
    Expect(1, 70223, '\p{Block=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=-	KHOJKI}', "");
    Expect(0, 70223, '\p{^Block=-	KHOJKI}', "");
    Expect(0, 70223, '\P{Block=-	KHOJKI}', "");
    Expect(1, 70223, '\P{^Block=-	KHOJKI}', "");
    Expect(0, 70224, '\p{Block=-	KHOJKI}', "");
    Expect(1, 70224, '\p{^Block=-	KHOJKI}', "");
    Expect(1, 70224, '\P{Block=-	KHOJKI}', "");
    Expect(0, 70224, '\P{^Block=-	KHOJKI}', "");
    Error('\p{Blk=Khojki/a/}');
    Error('\P{Blk=Khojki/a/}');
    Expect(1, 70223, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=khojki}', "");
    Expect(0, 70223, '\p{^Blk=khojki}', "");
    Expect(0, 70223, '\P{Blk=khojki}', "");
    Expect(1, 70223, '\P{^Blk=khojki}', "");
    Expect(0, 70224, '\p{Blk=khojki}', "");
    Expect(1, 70224, '\p{^Blk=khojki}', "");
    Expect(1, 70224, '\P{Blk=khojki}', "");
    Expect(0, 70224, '\P{^Blk=khojki}', "");
    Expect(1, 70223, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk:			Khojki}', "");
    Expect(0, 70223, '\p{^Blk:			Khojki}', "");
    Expect(0, 70223, '\P{Blk:			Khojki}', "");
    Expect(1, 70223, '\P{^Blk:			Khojki}', "");
    Expect(0, 70224, '\p{Blk:			Khojki}', "");
    Expect(1, 70224, '\p{^Blk:			Khojki}', "");
    Expect(1, 70224, '\P{Blk:			Khojki}', "");
    Expect(0, 70224, '\P{^Blk:			Khojki}', "");
    Error('\p{Is_Block=	:=KHOJKI}');
    Error('\P{Is_Block=	:=KHOJKI}');
    Expect(1, 70223, '\p{Is_Block:khojki}', "");
    Expect(0, 70223, '\p{^Is_Block:khojki}', "");
    Expect(0, 70223, '\P{Is_Block:khojki}', "");
    Expect(1, 70223, '\P{^Is_Block:khojki}', "");
    Expect(0, 70224, '\p{Is_Block:khojki}', "");
    Expect(1, 70224, '\p{^Is_Block:khojki}', "");
    Expect(1, 70224, '\P{Is_Block:khojki}', "");
    Expect(0, 70224, '\P{^Is_Block:khojki}', "");
    Expect(1, 70223, '\p{Is_Block=- khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=- khojki}', "");
    Expect(0, 70223, '\P{Is_Block=- khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=- khojki}', "");
    Expect(0, 70224, '\p{Is_Block=- khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=- khojki}', "");
    Expect(1, 70224, '\P{Is_Block=- khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=- khojki}', "");
    Error('\p{Is_Blk:	/a/Khojki}');
    Error('\P{Is_Blk:	/a/Khojki}');
    Expect(1, 70223, '\p{Is_Blk=khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=khojki}', "");
    Expect(1, 70223, '\p{Is_Blk=		khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=		khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=		khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=		khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=		khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=		khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=		khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=		khojki}', "");
    Error('\p{Block=:=_ Khudawadi}');
    Error('\P{Block=:=_ Khudawadi}');
    Expect(1, 70399, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block:khudawadi}', "");
    Expect(0, 70399, '\p{^Block:khudawadi}', "");
    Expect(0, 70399, '\P{Block:khudawadi}', "");
    Expect(1, 70399, '\P{^Block:khudawadi}', "");
    Expect(0, 70400, '\p{Block:khudawadi}', "");
    Expect(1, 70400, '\p{^Block:khudawadi}', "");
    Expect(1, 70400, '\P{Block:khudawadi}', "");
    Expect(0, 70400, '\P{^Block:khudawadi}', "");
    Expect(1, 70399, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block=_khudawadi}', "");
    Expect(0, 70399, '\p{^Block=_khudawadi}', "");
    Expect(0, 70399, '\P{Block=_khudawadi}', "");
    Expect(1, 70399, '\P{^Block=_khudawadi}', "");
    Expect(0, 70400, '\p{Block=_khudawadi}', "");
    Expect(1, 70400, '\p{^Block=_khudawadi}', "");
    Expect(1, 70400, '\P{Block=_khudawadi}', "");
    Expect(0, 70400, '\P{^Block=_khudawadi}', "");
    Error('\p{Blk:	/a/	Khudawadi}');
    Error('\P{Blk:	/a/	Khudawadi}');
    Expect(1, 70399, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk:   _-KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Blk:   _-KHUDAWADI}', "");
    Expect(0, 70399, '\P{Blk:   _-KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Blk:   _-KHUDAWADI}', "");
    Expect(0, 70400, '\p{Blk:   _-KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Blk:   _-KHUDAWADI}', "");
    Expect(1, 70400, '\P{Blk:   _-KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Blk:   _-KHUDAWADI}', "");
    Error('\p{Is_Block=:=_KHUDAWADI}');
    Error('\P{Is_Block=:=_KHUDAWADI}');
    Expect(1, 70399, '\p{Is_Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Block= KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Is_Block= KHUDAWADI}', "");
    Expect(0, 70399, '\P{Is_Block= KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Is_Block= KHUDAWADI}', "");
    Expect(0, 70400, '\p{Is_Block= KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Is_Block= KHUDAWADI}', "");
    Expect(1, 70400, '\P{Is_Block= KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Is_Block= KHUDAWADI}', "");
    Error('\p{Is_Blk::=--Khudawadi}');
    Error('\P{Is_Blk::=--Khudawadi}');
    Expect(1, 70399, '\p{Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Blk= -Khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk= -Khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk= -Khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk= -Khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk= -Khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk= -Khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk= -Khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk= -Khudawadi}', "");
    Error('\p{Block=		Lao/a/}');
    Error('\P{Block=		Lao/a/}');
    Expect(1, 3839, '\p{Block=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Block=lao}', "");
    Expect(0, 3839, '\p{^Block=lao}', "");
    Expect(0, 3839, '\P{Block=lao}', "");
    Expect(1, 3839, '\P{^Block=lao}', "");
    Expect(0, 3840, '\p{Block=lao}', "");
    Expect(1, 3840, '\p{^Block=lao}', "");
    Expect(1, 3840, '\P{Block=lao}', "");
    Expect(0, 3840, '\P{^Block=lao}', "");
    Expect(1, 3839, '\p{Block=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Block:	-Lao}', "");
    Expect(0, 3839, '\p{^Block:	-Lao}', "");
    Expect(0, 3839, '\P{Block:	-Lao}', "");
    Expect(1, 3839, '\P{^Block:	-Lao}', "");
    Expect(0, 3840, '\p{Block:	-Lao}', "");
    Expect(1, 3840, '\p{^Block:	-Lao}', "");
    Expect(1, 3840, '\P{Block:	-Lao}', "");
    Expect(0, 3840, '\P{^Block:	-Lao}', "");
    Error('\p{Blk=/a/_-Lao}');
    Error('\P{Blk=/a/_-Lao}');
    Expect(1, 3839, '\p{Blk=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Blk:lao}', "");
    Expect(0, 3839, '\p{^Blk:lao}', "");
    Expect(0, 3839, '\P{Blk:lao}', "");
    Expect(1, 3839, '\P{^Blk:lao}', "");
    Expect(0, 3840, '\p{Blk:lao}', "");
    Expect(1, 3840, '\p{^Blk:lao}', "");
    Expect(1, 3840, '\P{Blk:lao}', "");
    Expect(0, 3840, '\P{^Blk:lao}', "");
    Expect(1, 3839, '\p{Blk=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Blk=--lao}', "");
    Expect(0, 3839, '\p{^Blk=--lao}', "");
    Expect(0, 3839, '\P{Blk=--lao}', "");
    Expect(1, 3839, '\P{^Blk=--lao}', "");
    Expect(0, 3840, '\p{Blk=--lao}', "");
    Expect(1, 3840, '\p{^Blk=--lao}', "");
    Expect(1, 3840, '\P{Blk=--lao}', "");
    Expect(0, 3840, '\P{^Blk=--lao}', "");
    Error('\p{Is_Block=/a/lao}');
    Error('\P{Is_Block=/a/lao}');
    Expect(1, 3839, '\p{Is_Block=lao}', "");
    Expect(0, 3839, '\p{^Is_Block=lao}', "");
    Expect(0, 3839, '\P{Is_Block=lao}', "");
    Expect(1, 3839, '\P{^Is_Block=lao}', "");
    Expect(0, 3840, '\p{Is_Block=lao}', "");
    Expect(1, 3840, '\p{^Is_Block=lao}', "");
    Expect(1, 3840, '\P{Is_Block=lao}', "");
    Expect(0, 3840, '\P{^Is_Block=lao}', "");
    Expect(1, 3839, '\p{Is_Block= -Lao}', "");
    Expect(0, 3839, '\p{^Is_Block= -Lao}', "");
    Expect(0, 3839, '\P{Is_Block= -Lao}', "");
    Expect(1, 3839, '\P{^Is_Block= -Lao}', "");
    Expect(0, 3840, '\p{Is_Block= -Lao}', "");
    Expect(1, 3840, '\p{^Is_Block= -Lao}', "");
    Expect(1, 3840, '\P{Is_Block= -Lao}', "");
    Expect(0, 3840, '\P{^Is_Block= -Lao}', "");
    Error('\p{Is_Blk=_Lao:=}');
    Error('\P{Is_Blk=_Lao:=}');
    Expect(1, 3839, '\p{Is_Blk=lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=lao}', "");
    Expect(0, 3839, '\P{Is_Blk=lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=lao}', "");
    Expect(0, 3840, '\p{Is_Blk=lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=lao}', "");
    Expect(1, 3840, '\P{Is_Blk=lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=lao}', "");
    Expect(1, 3839, '\p{Is_Blk=-	lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=-	lao}', "");
    Expect(0, 3839, '\P{Is_Blk=-	lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=-	lao}', "");
    Expect(0, 3840, '\p{Is_Blk=-	lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=-	lao}', "");
    Expect(1, 3840, '\P{Is_Blk=-	lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=-	lao}', "");
    Error('\p{Block=  LATIN_1_supplement/a/}');
    Error('\P{Block=  LATIN_1_supplement/a/}');
    Expect(1, 255, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(1, 255, '\p{Block=latin1supplement}', "");
    Expect(0, 255, '\p{^Block=latin1supplement}', "");
    Expect(0, 255, '\P{Block=latin1supplement}', "");
    Expect(1, 255, '\P{^Block=latin1supplement}', "");
    Expect(0, 256, '\p{Block=latin1supplement}', "");
    Expect(1, 256, '\p{^Block=latin1supplement}', "");
    Expect(1, 256, '\P{Block=latin1supplement}', "");
    Expect(0, 256, '\P{^Block=latin1supplement}', "");
    Expect(1, 255, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(1, 255, '\p{Block=	LATIN_1_Supplement}', "");
    Expect(0, 255, '\p{^Block=	LATIN_1_Supplement}', "");
    Expect(0, 255, '\P{Block=	LATIN_1_Supplement}', "");
    Expect(1, 255, '\P{^Block=	LATIN_1_Supplement}', "");
    Expect(0, 256, '\p{Block=	LATIN_1_Supplement}', "");
    Expect(1, 256, '\p{^Block=	LATIN_1_Supplement}', "");
    Expect(1, 256, '\P{Block=	LATIN_1_Supplement}', "");
    Expect(0, 256, '\P{^Block=	LATIN_1_Supplement}', "");
    Error('\p{Blk=	Latin_1_SUP/a/}');
    Error('\P{Blk=	Latin_1_SUP/a/}');
    Expect(1, 255, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(1, 255, '\p{Blk=latin1sup}', "");
    Expect(0, 255, '\p{^Blk=latin1sup}', "");
    Expect(0, 255, '\P{Blk=latin1sup}', "");
    Expect(1, 255, '\P{^Blk=latin1sup}', "");
    Expect(0, 256, '\p{Blk=latin1sup}', "");
    Expect(1, 256, '\p{^Blk=latin1sup}', "");
    Expect(1, 256, '\P{Blk=latin1sup}', "");
    Expect(0, 256, '\P{^Blk=latin1sup}', "");
    Expect(1, 255, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(1, 255, '\p{Blk=	_latin_1_Sup}', "");
    Expect(0, 255, '\p{^Blk=	_latin_1_Sup}', "");
    Expect(0, 255, '\P{Blk=	_latin_1_Sup}', "");
    Expect(1, 255, '\P{^Blk=	_latin_1_Sup}', "");
    Expect(0, 256, '\p{Blk=	_latin_1_Sup}', "");
    Expect(1, 256, '\p{^Blk=	_latin_1_Sup}', "");
    Expect(1, 256, '\P{Blk=	_latin_1_Sup}', "");
    Expect(0, 256, '\P{^Blk=	_latin_1_Sup}', "");
    Error('\p{Is_Block=_latin_1/a/}');
    Error('\P{Is_Block=_latin_1/a/}');
    Expect(1, 255, '\p{Is_Block=latin1}', "");
    Expect(0, 255, '\p{^Is_Block=latin1}', "");
    Expect(0, 255, '\P{Is_Block=latin1}', "");
    Expect(1, 255, '\P{^Is_Block=latin1}', "");
    Expect(0, 256, '\p{Is_Block=latin1}', "");
    Expect(1, 256, '\p{^Is_Block=latin1}', "");
    Expect(1, 256, '\P{Is_Block=latin1}', "");
    Expect(0, 256, '\P{^Is_Block=latin1}', "");
    Expect(1, 255, '\p{Is_Block=	_Latin_1}', "");
    Expect(0, 255, '\p{^Is_Block=	_Latin_1}', "");
    Expect(0, 255, '\P{Is_Block=	_Latin_1}', "");
    Expect(1, 255, '\P{^Is_Block=	_Latin_1}', "");
    Expect(0, 256, '\p{Is_Block=	_Latin_1}', "");
    Expect(1, 256, '\p{^Is_Block=	_Latin_1}', "");
    Expect(1, 256, '\P{Is_Block=	_Latin_1}', "");
    Expect(0, 256, '\P{^Is_Block=	_Latin_1}', "");
    Error('\p{Is_Blk=/a/LATIN_1_Supplement}');
    Error('\P{Is_Blk=/a/LATIN_1_Supplement}');
    Expect(1, 255, '\p{Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\P{Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\p{Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\P{Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\p{Is_Blk=_ LATIN_1_supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=_ LATIN_1_supplement}', "");
    Expect(0, 255, '\P{Is_Blk=_ LATIN_1_supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=_ LATIN_1_supplement}', "");
    Expect(0, 256, '\p{Is_Blk=_ LATIN_1_supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=_ LATIN_1_supplement}', "");
    Expect(1, 256, '\P{Is_Blk=_ LATIN_1_supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=_ LATIN_1_supplement}', "");
    Error('\p{Block=latin_Extended_A/a/}');
    Error('\P{Block=latin_Extended_A/a/}');
    Expect(1, 383, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(0, 384, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(1, 383, '\p{Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Block=latinextendeda}', "");
    Expect(0, 383, '\P{Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Block=latinextendeda}', "");
    Expect(0, 384, '\p{Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Block=latinextendeda}', "");
    Expect(1, 384, '\P{Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Block=latinextendeda}', "");
    Expect(1, 383, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(0, 384, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(1, 383, '\p{Block=	Latin_EXTENDED_A}', "");
    Expect(0, 383, '\p{^Block=	Latin_EXTENDED_A}', "");
    Expect(0, 383, '\P{Block=	Latin_EXTENDED_A}', "");
    Expect(1, 383, '\P{^Block=	Latin_EXTENDED_A}', "");
    Expect(0, 384, '\p{Block=	Latin_EXTENDED_A}', "");
    Expect(1, 384, '\p{^Block=	Latin_EXTENDED_A}', "");
    Expect(1, 384, '\P{Block=	Latin_EXTENDED_A}', "");
    Expect(0, 384, '\P{^Block=	Latin_EXTENDED_A}', "");
    Error('\p{Blk=:=LATIN_ext_a}');
    Error('\P{Blk=:=LATIN_ext_a}');
    Expect(1, 383, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(0, 384, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(1, 383, '\p{Blk=latinexta}', "");
    Expect(0, 383, '\p{^Blk=latinexta}', "");
    Expect(0, 383, '\P{Blk=latinexta}', "");
    Expect(1, 383, '\P{^Blk=latinexta}', "");
    Expect(0, 384, '\p{Blk=latinexta}', "");
    Expect(1, 384, '\p{^Blk=latinexta}', "");
    Expect(1, 384, '\P{Blk=latinexta}', "");
    Expect(0, 384, '\P{^Blk=latinexta}', "");
    Expect(1, 383, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(0, 384, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(1, 383, '\p{Blk=_-Latin_Ext_A}', "");
    Expect(0, 383, '\p{^Blk=_-Latin_Ext_A}', "");
    Expect(0, 383, '\P{Blk=_-Latin_Ext_A}', "");
    Expect(1, 383, '\P{^Blk=_-Latin_Ext_A}', "");
    Expect(0, 384, '\p{Blk=_-Latin_Ext_A}', "");
    Expect(1, 384, '\p{^Blk=_-Latin_Ext_A}', "");
    Expect(1, 384, '\P{Blk=_-Latin_Ext_A}', "");
    Expect(0, 384, '\P{^Blk=_-Latin_Ext_A}', "");
    Error('\p{Is_Block=	:=Latin_extended_A}');
    Error('\P{Is_Block=	:=Latin_extended_A}');
    Expect(1, 383, '\p{Is_Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Is_Block=latinextendeda}', "");
    Expect(0, 383, '\P{Is_Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Is_Block=latinextendeda}', "");
    Expect(0, 384, '\p{Is_Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Is_Block=latinextendeda}', "");
    Expect(1, 384, '\P{Is_Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Is_Block=latinextendeda}', "");
    Expect(1, 383, '\p{Is_Block= _LATIN_Extended_A}', "");
    Expect(0, 383, '\p{^Is_Block= _LATIN_Extended_A}', "");
    Expect(0, 383, '\P{Is_Block= _LATIN_Extended_A}', "");
    Expect(1, 383, '\P{^Is_Block= _LATIN_Extended_A}', "");
    Expect(0, 384, '\p{Is_Block= _LATIN_Extended_A}', "");
    Expect(1, 384, '\p{^Is_Block= _LATIN_Extended_A}', "");
    Expect(1, 384, '\P{Is_Block= _LATIN_Extended_A}', "");
    Expect(0, 384, '\P{^Is_Block= _LATIN_Extended_A}', "");
    Error('\p{Is_Blk=/a/ LATIN_EXT_A}');
    Error('\P{Is_Blk=/a/ LATIN_EXT_A}');
    Expect(1, 383, '\p{Is_Blk=latinexta}', "");
    Expect(0, 383, '\p{^Is_Blk=latinexta}', "");
    Expect(0, 383, '\P{Is_Blk=latinexta}', "");
    Expect(1, 383, '\P{^Is_Blk=latinexta}', "");
    Expect(0, 384, '\p{Is_Blk=latinexta}', "");
    Expect(1, 384, '\p{^Is_Blk=latinexta}', "");
    Expect(1, 384, '\P{Is_Blk=latinexta}', "");
    Expect(0, 384, '\P{^Is_Blk=latinexta}', "");
    Expect(1, 383, '\p{Is_Blk:    _Latin_EXT_A}', "");
    Expect(0, 383, '\p{^Is_Blk:    _Latin_EXT_A}', "");
    Expect(0, 383, '\P{Is_Blk:    _Latin_EXT_A}', "");
    Expect(1, 383, '\P{^Is_Blk:    _Latin_EXT_A}', "");
    Expect(0, 384, '\p{Is_Blk:    _Latin_EXT_A}', "");
    Expect(1, 384, '\p{^Is_Blk:    _Latin_EXT_A}', "");
    Expect(1, 384, '\P{Is_Blk:    _Latin_EXT_A}', "");
    Expect(0, 384, '\P{^Is_Blk:    _Latin_EXT_A}', "");
    Error('\p{Block= :=Latin_extended_Additional}');
    Error('\P{Block= :=Latin_extended_Additional}');
    Expect(1, 7935, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(1, 7935, '\p{Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(1, 7935, '\p{Block=	Latin_extended_Additional}', "");
    Expect(0, 7935, '\p{^Block=	Latin_extended_Additional}', "");
    Expect(0, 7935, '\P{Block=	Latin_extended_Additional}', "");
    Expect(1, 7935, '\P{^Block=	Latin_extended_Additional}', "");
    Expect(0, 7936, '\p{Block=	Latin_extended_Additional}', "");
    Expect(1, 7936, '\p{^Block=	Latin_extended_Additional}', "");
    Expect(1, 7936, '\P{Block=	Latin_extended_Additional}', "");
    Expect(0, 7936, '\P{^Block=	Latin_extended_Additional}', "");
    Error('\p{Blk= :=Latin_ext_Additional}');
    Error('\P{Blk= :=Latin_ext_Additional}');
    Expect(1, 7935, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(1, 7935, '\p{Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(1, 7935, '\p{Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(0, 7935, '\p{^Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(0, 7935, '\P{Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(1, 7935, '\P{^Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(0, 7936, '\p{Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(1, 7936, '\p{^Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(1, 7936, '\P{Blk=_Latin_ext_ADDITIONAL}', "");
    Expect(0, 7936, '\P{^Blk=_Latin_ext_ADDITIONAL}', "");
    Error('\p{Is_Block=/a/__Latin_extended_Additional}');
    Error('\P{Is_Block=/a/__Latin_extended_Additional}');
    Expect(1, 7935, '\p{Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Is_Block=--latin_extended_Additional}', "");
    Expect(0, 7935, '\p{^Is_Block=--latin_extended_Additional}', "");
    Expect(0, 7935, '\P{Is_Block=--latin_extended_Additional}', "");
    Expect(1, 7935, '\P{^Is_Block=--latin_extended_Additional}', "");
    Expect(0, 7936, '\p{Is_Block=--latin_extended_Additional}', "");
    Expect(1, 7936, '\p{^Is_Block=--latin_extended_Additional}', "");
    Expect(1, 7936, '\P{Is_Block=--latin_extended_Additional}', "");
    Expect(0, 7936, '\P{^Is_Block=--latin_extended_Additional}', "");
    Error('\p{Is_Blk=:=	_LATIN_EXT_additional}');
    Error('\P{Is_Blk=:=	_LATIN_EXT_additional}');
    Expect(1, 7935, '\p{Is_Blk: latinextadditional}', "");
    Expect(0, 7935, '\p{^Is_Blk: latinextadditional}', "");
    Expect(0, 7935, '\P{Is_Blk: latinextadditional}', "");
    Expect(1, 7935, '\P{^Is_Blk: latinextadditional}', "");
    Expect(0, 7936, '\p{Is_Blk: latinextadditional}', "");
    Expect(1, 7936, '\p{^Is_Blk: latinextadditional}', "");
    Expect(1, 7936, '\P{Is_Blk: latinextadditional}', "");
    Expect(0, 7936, '\P{^Is_Blk: latinextadditional}', "");
    Expect(1, 7935, '\p{Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(0, 7935, '\p{^Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(0, 7935, '\P{Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(1, 7935, '\P{^Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(0, 7936, '\p{Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(1, 7936, '\p{^Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(1, 7936, '\P{Is_Blk=_ Latin_EXT_Additional}', "");
    Expect(0, 7936, '\P{^Is_Blk=_ Latin_EXT_Additional}', "");
    Error('\p{Block= /a/LATIN_Extended_B}');
    Error('\P{Block= /a/LATIN_Extended_B}');
    Expect(1, 591, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(0, 592, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(1, 591, '\p{Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Block=latinextendedb}', "");
    Expect(0, 591, '\P{Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Block=latinextendedb}', "");
    Expect(0, 592, '\p{Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Block=latinextendedb}', "");
    Expect(1, 592, '\P{Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Block=latinextendedb}', "");
    Expect(1, 591, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(0, 592, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(1, 591, '\p{Block=_	Latin_Extended_b}', "");
    Expect(0, 591, '\p{^Block=_	Latin_Extended_b}', "");
    Expect(0, 591, '\P{Block=_	Latin_Extended_b}', "");
    Expect(1, 591, '\P{^Block=_	Latin_Extended_b}', "");
    Expect(0, 592, '\p{Block=_	Latin_Extended_b}', "");
    Expect(1, 592, '\p{^Block=_	Latin_Extended_b}', "");
    Expect(1, 592, '\P{Block=_	Latin_Extended_b}', "");
    Expect(0, 592, '\P{^Block=_	Latin_Extended_b}', "");
    Error('\p{Blk=-latin_Ext_B/a/}');
    Error('\P{Blk=-latin_Ext_B/a/}');
    Expect(1, 591, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(0, 592, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(1, 591, '\p{Blk=latinextb}', "");
    Expect(0, 591, '\p{^Blk=latinextb}', "");
    Expect(0, 591, '\P{Blk=latinextb}', "");
    Expect(1, 591, '\P{^Blk=latinextb}', "");
    Expect(0, 592, '\p{Blk=latinextb}', "");
    Expect(1, 592, '\p{^Blk=latinextb}', "");
    Expect(1, 592, '\P{Blk=latinextb}', "");
    Expect(0, 592, '\P{^Blk=latinextb}', "");
    Expect(1, 591, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(0, 592, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(1, 591, '\p{Blk= 	Latin_ext_b}', "");
    Expect(0, 591, '\p{^Blk= 	Latin_ext_b}', "");
    Expect(0, 591, '\P{Blk= 	Latin_ext_b}', "");
    Expect(1, 591, '\P{^Blk= 	Latin_ext_b}', "");
    Expect(0, 592, '\p{Blk= 	Latin_ext_b}', "");
    Expect(1, 592, '\p{^Blk= 	Latin_ext_b}', "");
    Expect(1, 592, '\P{Blk= 	Latin_ext_b}', "");
    Expect(0, 592, '\P{^Blk= 	Latin_ext_b}', "");
    Error('\p{Is_Block=	:=Latin_extended_B}');
    Error('\P{Is_Block=	:=Latin_extended_B}');
    Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
    Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
    Expect(0, 592, '\p{Is_Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Is_Block=latinextendedb}', "");
    Expect(1, 592, '\P{Is_Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Is_Block=latinextendedb}', "");
    Expect(1, 591, '\p{Is_Block=	-latin_Extended_B}', "");
    Expect(0, 591, '\p{^Is_Block=	-latin_Extended_B}', "");
    Expect(0, 591, '\P{Is_Block=	-latin_Extended_B}', "");
    Expect(1, 591, '\P{^Is_Block=	-latin_Extended_B}', "");
    Expect(0, 592, '\p{Is_Block=	-latin_Extended_B}', "");
    Expect(1, 592, '\p{^Is_Block=	-latin_Extended_B}', "");
    Expect(1, 592, '\P{Is_Block=	-latin_Extended_B}', "");
    Expect(0, 592, '\P{^Is_Block=	-latin_Extended_B}', "");
    Error('\p{Is_Blk=:=_ Latin_ext_B}');
    Error('\P{Is_Blk=:=_ Latin_ext_B}');
    Expect(1, 591, '\p{Is_Blk=latinextb}', "");
    Expect(0, 591, '\p{^Is_Blk=latinextb}', "");
    Expect(0, 591, '\P{Is_Blk=latinextb}', "");
    Expect(1, 591, '\P{^Is_Blk=latinextb}', "");
    Expect(0, 592, '\p{Is_Blk=latinextb}', "");
    Expect(1, 592, '\p{^Is_Blk=latinextb}', "");
    Expect(1, 592, '\P{Is_Blk=latinextb}', "");
    Expect(0, 592, '\P{^Is_Blk=latinextb}', "");
    Expect(1, 591, '\p{Is_Blk=--LATIN_ext_B}', "");
    Expect(0, 591, '\p{^Is_Blk=--LATIN_ext_B}', "");
    Expect(0, 591, '\P{Is_Blk=--LATIN_ext_B}', "");
    Expect(1, 591, '\P{^Is_Blk=--LATIN_ext_B}', "");
    Expect(0, 592, '\p{Is_Blk=--LATIN_ext_B}', "");
    Expect(1, 592, '\p{^Is_Blk=--LATIN_ext_B}', "");
    Expect(1, 592, '\P{Is_Blk=--LATIN_ext_B}', "");
    Expect(0, 592, '\P{^Is_Blk=--LATIN_ext_B}', "");
    Error('\p{Block=_/a/latin_Extended_C}');
    Error('\P{Block=_/a/latin_Extended_C}');
    Expect(1, 11391, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(0, 11392, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(1, 11391, '\p{Block:	latinextendedc}', "");
    Expect(0, 11391, '\p{^Block:	latinextendedc}', "");
    Expect(0, 11391, '\P{Block:	latinextendedc}', "");
    Expect(1, 11391, '\P{^Block:	latinextendedc}', "");
    Expect(0, 11392, '\p{Block:	latinextendedc}', "");
    Expect(1, 11392, '\p{^Block:	latinextendedc}', "");
    Expect(1, 11392, '\P{Block:	latinextendedc}', "");
    Expect(0, 11392, '\P{^Block:	latinextendedc}', "");
    Expect(1, 11391, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(0, 11392, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(1, 11391, '\p{Block=	_latin_Extended_C}', "");
    Expect(0, 11391, '\p{^Block=	_latin_Extended_C}', "");
    Expect(0, 11391, '\P{Block=	_latin_Extended_C}', "");
    Expect(1, 11391, '\P{^Block=	_latin_Extended_C}', "");
    Expect(0, 11392, '\p{Block=	_latin_Extended_C}', "");
    Expect(1, 11392, '\p{^Block=	_latin_Extended_C}', "");
    Expect(1, 11392, '\P{Block=	_latin_Extended_C}', "");
    Expect(0, 11392, '\P{^Block=	_latin_Extended_C}', "");
    Error('\p{Blk=-latin_Ext_C/a/}');
    Error('\P{Blk=-latin_Ext_C/a/}');
    Expect(1, 11391, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(1, 11391, '\p{Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Blk=latinextc}', "");
    Expect(0, 11391, '\P{Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Blk=latinextc}', "");
    Expect(0, 11392, '\p{Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Blk=latinextc}', "");
    Expect(1, 11392, '\P{Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Blk=latinextc}', "");
    Expect(1, 11391, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(1, 11391, '\p{Blk: -Latin_Ext_C}', "");
    Expect(0, 11391, '\p{^Blk: -Latin_Ext_C}', "");
    Expect(0, 11391, '\P{Blk: -Latin_Ext_C}', "");
    Expect(1, 11391, '\P{^Blk: -Latin_Ext_C}', "");
    Expect(0, 11392, '\p{Blk: -Latin_Ext_C}', "");
    Expect(1, 11392, '\p{^Blk: -Latin_Ext_C}', "");
    Expect(1, 11392, '\P{Blk: -Latin_Ext_C}', "");
    Expect(0, 11392, '\P{^Blk: -Latin_Ext_C}', "");
    Error('\p{Is_Block=:=Latin_Extended_C}');
    Error('\P{Is_Block=:=Latin_Extended_C}');
    Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Is_Block:	-	Latin_Extended_C}', "");
    Expect(0, 11391, '\p{^Is_Block:	-	Latin_Extended_C}', "");
    Expect(0, 11391, '\P{Is_Block:	-	Latin_Extended_C}', "");
    Expect(1, 11391, '\P{^Is_Block:	-	Latin_Extended_C}', "");
    Expect(0, 11392, '\p{Is_Block:	-	Latin_Extended_C}', "");
    Expect(1, 11392, '\p{^Is_Block:	-	Latin_Extended_C}', "");
    Expect(1, 11392, '\P{Is_Block:	-	Latin_Extended_C}', "");
    Expect(0, 11392, '\P{^Is_Block:	-	Latin_Extended_C}', "");
    Error('\p{Is_Blk=/a/Latin_EXT_c}');
    Error('\P{Is_Blk=/a/Latin_EXT_c}');
    Expect(1, 11391, '\p{Is_Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Is_Blk=latinextc}', "");
    Expect(0, 11391, '\P{Is_Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Is_Blk=latinextc}', "");
    Expect(0, 11392, '\p{Is_Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Is_Blk=latinextc}', "");
    Expect(1, 11392, '\P{Is_Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Is_Blk=latinextc}', "");
    Expect(1, 11391, '\p{Is_Blk=  LATIN_Ext_c}', "");
    Expect(0, 11391, '\p{^Is_Blk=  LATIN_Ext_c}', "");
    Expect(0, 11391, '\P{Is_Blk=  LATIN_Ext_c}', "");
    Expect(1, 11391, '\P{^Is_Blk=  LATIN_Ext_c}', "");
    Expect(0, 11392, '\p{Is_Blk=  LATIN_Ext_c}', "");
    Expect(1, 11392, '\p{^Is_Blk=  LATIN_Ext_c}', "");
    Expect(1, 11392, '\P{Is_Blk=  LATIN_Ext_c}', "");
    Expect(0, 11392, '\P{^Is_Blk=  LATIN_Ext_c}', "");
    Error('\p{Block=	latin_Extended_D:=}');
    Error('\P{Block=	latin_Extended_D:=}');
    Expect(1, 43007, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(0, 43008, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(1, 43007, '\p{Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(0, 43008, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(1, 43007, '\p{Block= -Latin_EXTENDED_D}', "");
    Expect(0, 43007, '\p{^Block= -Latin_EXTENDED_D}', "");
    Expect(0, 43007, '\P{Block= -Latin_EXTENDED_D}', "");
    Expect(1, 43007, '\P{^Block= -Latin_EXTENDED_D}', "");
    Expect(0, 43008, '\p{Block= -Latin_EXTENDED_D}', "");
    Expect(1, 43008, '\p{^Block= -Latin_EXTENDED_D}', "");
    Expect(1, 43008, '\P{Block= -Latin_EXTENDED_D}', "");
    Expect(0, 43008, '\P{^Block= -Latin_EXTENDED_D}', "");
    Error('\p{Blk=:= -LATIN_Ext_d}');
    Error('\P{Blk=:= -LATIN_Ext_d}');
    Expect(1, 43007, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(1, 43007, '\p{Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Blk=latinextd}', "");
    Expect(0, 43007, '\P{Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Blk=latinextd}', "");
    Expect(0, 43008, '\p{Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Blk=latinextd}', "");
    Expect(1, 43008, '\P{Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Blk=latinextd}', "");
    Expect(1, 43007, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(1, 43007, '\p{Blk=-	LATIN_EXT_D}', "");
    Expect(0, 43007, '\p{^Blk=-	LATIN_EXT_D}', "");
    Expect(0, 43007, '\P{Blk=-	LATIN_EXT_D}', "");
    Expect(1, 43007, '\P{^Blk=-	LATIN_EXT_D}', "");
    Expect(0, 43008, '\p{Blk=-	LATIN_EXT_D}', "");
    Expect(1, 43008, '\p{^Blk=-	LATIN_EXT_D}', "");
    Expect(1, 43008, '\P{Blk=-	LATIN_EXT_D}', "");
    Expect(0, 43008, '\P{^Blk=-	LATIN_EXT_D}', "");
    Error('\p{Is_Block=	/a/Latin_Extended_d}');
    Error('\P{Is_Block=	/a/Latin_Extended_d}');
    Expect(1, 43007, '\p{Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Is_Block=__Latin_EXTENDED_D}', "");
    Expect(0, 43007, '\p{^Is_Block=__Latin_EXTENDED_D}', "");
    Expect(0, 43007, '\P{Is_Block=__Latin_EXTENDED_D}', "");
    Expect(1, 43007, '\P{^Is_Block=__Latin_EXTENDED_D}', "");
    Expect(0, 43008, '\p{Is_Block=__Latin_EXTENDED_D}', "");
    Expect(1, 43008, '\p{^Is_Block=__Latin_EXTENDED_D}', "");
    Expect(1, 43008, '\P{Is_Block=__Latin_EXTENDED_D}', "");
    Expect(0, 43008, '\P{^Is_Block=__Latin_EXTENDED_D}', "");
    Error('\p{Is_Blk=:=_ LATIN_ext_D}');
    Error('\P{Is_Blk=:=_ LATIN_ext_D}');
    Expect(1, 43007, '\p{Is_Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Is_Blk=latinextd}', "");
    Expect(0, 43007, '\P{Is_Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Is_Blk=latinextd}', "");
    Expect(0, 43008, '\p{Is_Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Is_Blk=latinextd}', "");
    Expect(1, 43008, '\P{Is_Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Is_Blk=latinextd}', "");
    Expect(1, 43007, '\p{Is_Blk=- Latin_EXT_D}', "");
    Expect(0, 43007, '\p{^Is_Blk=- Latin_EXT_D}', "");
    Expect(0, 43007, '\P{Is_Blk=- Latin_EXT_D}', "");
    Expect(1, 43007, '\P{^Is_Blk=- Latin_EXT_D}', "");
    Expect(0, 43008, '\p{Is_Blk=- Latin_EXT_D}', "");
    Expect(1, 43008, '\p{^Is_Blk=- Latin_EXT_D}', "");
    Expect(1, 43008, '\P{Is_Blk=- Latin_EXT_D}', "");
    Expect(0, 43008, '\P{^Is_Blk=- Latin_EXT_D}', "");
    Error('\p{Block=:=Latin_Extended_e}');
    Error('\P{Block=:=Latin_Extended_e}');
    Expect(1, 43887, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(0, 43888, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(1, 43887, '\p{Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Block=latinextendede}', "");
    Expect(0, 43887, '\P{Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Block=latinextendede}', "");
    Expect(0, 43888, '\p{Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Block=latinextendede}', "");
    Expect(1, 43888, '\P{Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Block=latinextendede}', "");
    Expect(1, 43887, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(0, 43888, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(1, 43887, '\p{Block=  Latin_Extended_E}', "");
    Expect(0, 43887, '\p{^Block=  Latin_Extended_E}', "");
    Expect(0, 43887, '\P{Block=  Latin_Extended_E}', "");
    Expect(1, 43887, '\P{^Block=  Latin_Extended_E}', "");
    Expect(0, 43888, '\p{Block=  Latin_Extended_E}', "");
    Expect(1, 43888, '\p{^Block=  Latin_Extended_E}', "");
    Expect(1, 43888, '\P{Block=  Latin_Extended_E}', "");
    Expect(0, 43888, '\P{^Block=  Latin_Extended_E}', "");
    Error('\p{Blk:   /a/ -Latin_Ext_E}');
    Error('\P{Blk:   /a/ -Latin_Ext_E}');
    Expect(1, 43887, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(1, 43887, '\p{Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Blk=latinexte}', "");
    Expect(0, 43887, '\P{Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Blk=latinexte}', "");
    Expect(0, 43888, '\p{Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Blk=latinexte}', "");
    Expect(1, 43888, '\P{Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Blk=latinexte}', "");
    Expect(1, 43887, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(1, 43887, '\p{Blk=	 Latin_Ext_e}', "");
    Expect(0, 43887, '\p{^Blk=	 Latin_Ext_e}', "");
    Expect(0, 43887, '\P{Blk=	 Latin_Ext_e}', "");
    Expect(1, 43887, '\P{^Blk=	 Latin_Ext_e}', "");
    Expect(0, 43888, '\p{Blk=	 Latin_Ext_e}', "");
    Expect(1, 43888, '\p{^Blk=	 Latin_Ext_e}', "");
    Expect(1, 43888, '\P{Blk=	 Latin_Ext_e}', "");
    Expect(0, 43888, '\P{^Blk=	 Latin_Ext_e}', "");
    Error('\p{Is_Block=_	Latin_extended_e:=}');
    Error('\P{Is_Block=_	Latin_extended_e:=}');
    Expect(1, 43887, '\p{Is_Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Is_Block=latinextendede}', "");
    Expect(0, 43887, '\P{Is_Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Is_Block=latinextendede}', "");
    Expect(0, 43888, '\p{Is_Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Is_Block=latinextendede}', "");
    Expect(1, 43888, '\P{Is_Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Is_Block=latinextendede}', "");
    Expect(1, 43887, '\p{Is_Block: 	-Latin_extended_E}', "");
    Expect(0, 43887, '\p{^Is_Block: 	-Latin_extended_E}', "");
    Expect(0, 43887, '\P{Is_Block: 	-Latin_extended_E}', "");
    Expect(1, 43887, '\P{^Is_Block: 	-Latin_extended_E}', "");
    Expect(0, 43888, '\p{Is_Block: 	-Latin_extended_E}', "");
    Expect(1, 43888, '\p{^Is_Block: 	-Latin_extended_E}', "");
    Expect(1, 43888, '\P{Is_Block: 	-Latin_extended_E}', "");
    Expect(0, 43888, '\P{^Is_Block: 	-Latin_extended_E}', "");
    Error('\p{Is_Blk=:=Latin_EXT_e}');
    Error('\P{Is_Blk=:=Latin_EXT_e}');
    Expect(1, 43887, '\p{Is_Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Is_Blk=latinexte}', "");
    Expect(0, 43887, '\P{Is_Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Is_Blk=latinexte}', "");
    Expect(0, 43888, '\p{Is_Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Is_Blk=latinexte}', "");
    Expect(1, 43888, '\P{Is_Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Is_Blk=latinexte}', "");
    Expect(1, 43887, '\p{Is_Blk=- latin_Ext_E}', "");
    Expect(0, 43887, '\p{^Is_Blk=- latin_Ext_E}', "");
    Expect(0, 43887, '\P{Is_Blk=- latin_Ext_E}', "");
    Expect(1, 43887, '\P{^Is_Blk=- latin_Ext_E}', "");
    Expect(0, 43888, '\p{Is_Blk=- latin_Ext_E}', "");
    Expect(1, 43888, '\p{^Is_Blk=- latin_Ext_E}', "");
    Expect(1, 43888, '\P{Is_Blk=- latin_Ext_E}', "");
    Expect(0, 43888, '\P{^Is_Blk=- latin_Ext_E}', "");
    Error('\p{Block=:= Lepcha}');
    Error('\P{Block=:= Lepcha}');
    Expect(1, 7247, '\p{Block=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=lepcha}', "");
    Expect(0, 7247, '\p{^Block=lepcha}', "");
    Expect(0, 7247, '\P{Block=lepcha}', "");
    Expect(1, 7247, '\P{^Block=lepcha}', "");
    Expect(0, 7248, '\p{Block=lepcha}', "");
    Expect(1, 7248, '\p{^Block=lepcha}', "");
    Expect(1, 7248, '\P{Block=lepcha}', "");
    Expect(0, 7248, '\P{^Block=lepcha}', "");
    Expect(1, 7247, '\p{Block=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=	_LEPCHA}', "");
    Expect(0, 7247, '\p{^Block=	_LEPCHA}', "");
    Expect(0, 7247, '\P{Block=	_LEPCHA}', "");
    Expect(1, 7247, '\P{^Block=	_LEPCHA}', "");
    Expect(0, 7248, '\p{Block=	_LEPCHA}', "");
    Expect(1, 7248, '\p{^Block=	_LEPCHA}', "");
    Expect(1, 7248, '\P{Block=	_LEPCHA}', "");
    Expect(0, 7248, '\P{^Block=	_LEPCHA}', "");
    Error('\p{Blk=:=-LEPCHA}');
    Error('\P{Blk=:=-LEPCHA}');
    Expect(1, 7247, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Blk=lepcha}', "");
    Expect(0, 7247, '\P{Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Blk=lepcha}', "");
    Expect(0, 7248, '\p{Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Blk=lepcha}', "");
    Expect(1, 7248, '\P{Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Blk=lepcha}', "");
    Expect(1, 7247, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk= 	Lepcha}', "");
    Expect(0, 7247, '\p{^Blk= 	Lepcha}', "");
    Expect(0, 7247, '\P{Blk= 	Lepcha}', "");
    Expect(1, 7247, '\P{^Blk= 	Lepcha}', "");
    Expect(0, 7248, '\p{Blk= 	Lepcha}', "");
    Expect(1, 7248, '\p{^Blk= 	Lepcha}', "");
    Expect(1, 7248, '\P{Blk= 	Lepcha}', "");
    Expect(0, 7248, '\P{^Blk= 	Lepcha}', "");
    Error('\p{Is_Block= /a/lepcha}');
    Error('\P{Is_Block= /a/lepcha}');
    Expect(1, 7247, '\p{Is_Block=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
    Expect(0, 7247, '\P{Is_Block=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
    Expect(0, 7248, '\p{Is_Block=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block=lepcha}', "");
    Expect(1, 7248, '\P{Is_Block=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block=lepcha}', "");
    Expect(1, 7247, '\p{Is_Block=		LEPCHA}', "");
    Expect(0, 7247, '\p{^Is_Block=		LEPCHA}', "");
    Expect(0, 7247, '\P{Is_Block=		LEPCHA}', "");
    Expect(1, 7247, '\P{^Is_Block=		LEPCHA}', "");
    Expect(0, 7248, '\p{Is_Block=		LEPCHA}', "");
    Expect(1, 7248, '\p{^Is_Block=		LEPCHA}', "");
    Expect(1, 7248, '\P{Is_Block=		LEPCHA}', "");
    Expect(0, 7248, '\P{^Is_Block=		LEPCHA}', "");
    Error('\p{Is_Blk=:=		Lepcha}');
    Error('\P{Is_Blk=:=		Lepcha}');
    Expect(1, 7247, '\p{Is_Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=lepcha}', "");
    Expect(1, 7247, '\p{Is_Blk=_-Lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=_-Lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=_-Lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=_-Lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=_-Lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=_-Lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=_-Lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=_-Lepcha}', "");
    Error('\p{Block=_LETTERLIKE_Symbols:=}');
    Error('\P{Block=_LETTERLIKE_Symbols:=}');
    Expect(1, 8527, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Block=_	letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Block=_	letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Block=_	letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Block=_	letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Block=_	letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Block=_	letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Block=_	letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Block=_	letterlike_Symbols}', "");
    Error('\p{Blk=--LETTERLIKE_Symbols:=}');
    Error('\P{Blk=--LETTERLIKE_Symbols:=}');
    Expect(1, 8527, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=_	letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Blk=_	letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Blk=_	letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Blk=_	letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Blk=_	letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Blk=_	letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Blk=_	letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Blk=_	letterlike_Symbols}', "");
    Error('\p{Is_Block:	/a/-Letterlike_SYMBOLS}');
    Error('\P{Is_Block:	/a/-Letterlike_SYMBOLS}');
    Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Block=-LETTERLIKE_symbols}', "");
    Expect(0, 8527, '\p{^Is_Block=-LETTERLIKE_symbols}', "");
    Expect(0, 8527, '\P{Is_Block=-LETTERLIKE_symbols}', "");
    Expect(1, 8527, '\P{^Is_Block=-LETTERLIKE_symbols}', "");
    Expect(0, 8528, '\p{Is_Block=-LETTERLIKE_symbols}', "");
    Expect(1, 8528, '\p{^Is_Block=-LETTERLIKE_symbols}', "");
    Expect(1, 8528, '\P{Is_Block=-LETTERLIKE_symbols}', "");
    Expect(0, 8528, '\P{^Is_Block=-LETTERLIKE_symbols}', "");
    Error('\p{Is_Blk=-:=LETTERLIKE_symbols}');
    Error('\P{Is_Blk=-:=LETTERLIKE_symbols}');
    Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(0, 8527, '\p{^Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(0, 8527, '\P{Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(1, 8527, '\P{^Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(0, 8528, '\p{Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(1, 8528, '\p{^Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(1, 8528, '\P{Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Expect(0, 8528, '\P{^Is_Blk=-	LETTERLIKE_SYMBOLS}', "");
    Error('\p{Block=_-Limbu/a/}');
    Error('\P{Block=_-Limbu/a/}');
    Expect(1, 6479, '\p{Block=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Block:   limbu}', "");
    Expect(0, 6479, '\p{^Block:   limbu}', "");
    Expect(0, 6479, '\P{Block:   limbu}', "");
    Expect(1, 6479, '\P{^Block:   limbu}', "");
    Expect(0, 6480, '\p{Block:   limbu}', "");
    Expect(1, 6480, '\p{^Block:   limbu}', "");
    Expect(1, 6480, '\P{Block:   limbu}', "");
    Expect(0, 6480, '\P{^Block:   limbu}', "");
    Expect(1, 6479, '\p{Block=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Block:    Limbu}', "");
    Expect(0, 6479, '\p{^Block:    Limbu}', "");
    Expect(0, 6479, '\P{Block:    Limbu}', "");
    Expect(1, 6479, '\P{^Block:    Limbu}', "");
    Expect(0, 6480, '\p{Block:    Limbu}', "");
    Expect(1, 6480, '\p{^Block:    Limbu}', "");
    Expect(1, 6480, '\P{Block:    Limbu}', "");
    Expect(0, 6480, '\P{^Block:    Limbu}', "");
    Error('\p{Blk=/a/	 limbu}');
    Error('\P{Blk=/a/	 limbu}');
    Expect(1, 6479, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk=limbu}', "");
    Expect(0, 6479, '\p{^Blk=limbu}', "");
    Expect(0, 6479, '\P{Blk=limbu}', "");
    Expect(1, 6479, '\P{^Blk=limbu}', "");
    Expect(0, 6480, '\p{Blk=limbu}', "");
    Expect(1, 6480, '\p{^Blk=limbu}', "");
    Expect(1, 6480, '\P{Blk=limbu}', "");
    Expect(0, 6480, '\P{^Blk=limbu}', "");
    Expect(1, 6479, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk=-Limbu}', "");
    Expect(0, 6479, '\p{^Blk=-Limbu}', "");
    Expect(0, 6479, '\P{Blk=-Limbu}', "");
    Expect(1, 6479, '\P{^Blk=-Limbu}', "");
    Expect(0, 6480, '\p{Blk=-Limbu}', "");
    Expect(1, 6480, '\p{^Blk=-Limbu}', "");
    Expect(1, 6480, '\P{Blk=-Limbu}', "");
    Expect(0, 6480, '\P{^Blk=-Limbu}', "");
    Error('\p{Is_Block=:=-	Limbu}');
    Error('\P{Is_Block=:=-	Limbu}');
    Expect(1, 6479, '\p{Is_Block=limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=limbu}', "");
    Expect(0, 6479, '\P{Is_Block=limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=limbu}', "");
    Expect(0, 6480, '\p{Is_Block=limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=limbu}', "");
    Expect(1, 6480, '\P{Is_Block=limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=limbu}', "");
    Expect(1, 6479, '\p{Is_Block=_LIMBU}', "");
    Expect(0, 6479, '\p{^Is_Block=_LIMBU}', "");
    Expect(0, 6479, '\P{Is_Block=_LIMBU}', "");
    Expect(1, 6479, '\P{^Is_Block=_LIMBU}', "");
    Expect(0, 6480, '\p{Is_Block=_LIMBU}', "");
    Expect(1, 6480, '\p{^Is_Block=_LIMBU}', "");
    Expect(1, 6480, '\P{Is_Block=_LIMBU}', "");
    Expect(0, 6480, '\P{^Is_Block=_LIMBU}', "");
    Error('\p{Is_Blk=_/a/limbu}');
    Error('\P{Is_Blk=_/a/limbu}');
    Expect(1, 6479, '\p{Is_Blk=limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=limbu}', "");
    Expect(1, 6479, '\p{Is_Blk=	 Limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=	 Limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=	 Limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=	 Limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=	 Limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=	 Limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=	 Limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=	 Limbu}', "");
    Error('\p{Block=	Linear_A:=}');
    Error('\P{Block=	Linear_A:=}');
    Expect(1, 67455, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Block=lineara}', "");
    Expect(0, 67455, '\p{^Block=lineara}', "");
    Expect(0, 67455, '\P{Block=lineara}', "");
    Expect(1, 67455, '\P{^Block=lineara}', "");
    Expect(0, 67456, '\p{Block=lineara}', "");
    Expect(1, 67456, '\p{^Block=lineara}', "");
    Expect(1, 67456, '\P{Block=lineara}', "");
    Expect(0, 67456, '\P{^Block=lineara}', "");
    Expect(1, 67455, '\p{Block=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Block=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Block=Linear_A}', "");
    Expect(0, 67455, '\p{^Block=Linear_A}', "");
    Expect(0, 67455, '\P{Block=Linear_A}', "");
    Expect(1, 67455, '\P{^Block=Linear_A}', "");
    Expect(0, 67456, '\p{Block=Linear_A}', "");
    Expect(1, 67456, '\p{^Block=Linear_A}', "");
    Expect(1, 67456, '\P{Block=Linear_A}', "");
    Expect(0, 67456, '\P{^Block=Linear_A}', "");
    Error('\p{Blk= LINEAR_A:=}');
    Error('\P{Blk= LINEAR_A:=}');
    Expect(1, 67455, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Blk=lineara}', "");
    Expect(0, 67455, '\p{^Blk=lineara}', "");
    Expect(0, 67455, '\P{Blk=lineara}', "");
    Expect(1, 67455, '\P{^Blk=lineara}', "");
    Expect(0, 67456, '\p{Blk=lineara}', "");
    Expect(1, 67456, '\p{^Blk=lineara}', "");
    Expect(1, 67456, '\P{Blk=lineara}', "");
    Expect(0, 67456, '\P{^Blk=lineara}', "");
    Expect(1, 67455, '\p{Blk=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Blk: 	_Linear_A}', "");
    Expect(0, 67455, '\p{^Blk: 	_Linear_A}', "");
    Expect(0, 67455, '\P{Blk: 	_Linear_A}', "");
    Expect(1, 67455, '\P{^Blk: 	_Linear_A}', "");
    Expect(0, 67456, '\p{Blk: 	_Linear_A}', "");
    Expect(1, 67456, '\p{^Blk: 	_Linear_A}', "");
    Expect(1, 67456, '\P{Blk: 	_Linear_A}', "");
    Expect(0, 67456, '\P{^Blk: 	_Linear_A}', "");
    Error('\p{Is_Block=	/a/linear_A}');
    Error('\P{Is_Block=	/a/linear_A}');
    Expect(1, 67455, '\p{Is_Block=lineara}', "");
    Expect(0, 67455, '\p{^Is_Block=lineara}', "");
    Expect(0, 67455, '\P{Is_Block=lineara}', "");
    Expect(1, 67455, '\P{^Is_Block=lineara}', "");
    Expect(0, 67456, '\p{Is_Block=lineara}', "");
    Expect(1, 67456, '\p{^Is_Block=lineara}', "");
    Expect(1, 67456, '\P{Is_Block=lineara}', "");
    Expect(0, 67456, '\P{^Is_Block=lineara}', "");
    Expect(1, 67455, '\p{Is_Block=_Linear_A}', "");
    Expect(0, 67455, '\p{^Is_Block=_Linear_A}', "");
    Expect(0, 67455, '\P{Is_Block=_Linear_A}', "");
    Expect(1, 67455, '\P{^Is_Block=_Linear_A}', "");
    Expect(0, 67456, '\p{Is_Block=_Linear_A}', "");
    Expect(1, 67456, '\p{^Is_Block=_Linear_A}', "");
    Expect(1, 67456, '\P{Is_Block=_Linear_A}', "");
    Expect(0, 67456, '\P{^Is_Block=_Linear_A}', "");
    Error('\p{Is_Blk=_-LINEAR_A/a/}');
    Error('\P{Is_Blk=_-LINEAR_A/a/}');
    Expect(1, 67455, '\p{Is_Blk=lineara}', "");
    Expect(0, 67455, '\p{^Is_Blk=lineara}', "");
    Expect(0, 67455, '\P{Is_Blk=lineara}', "");
    Expect(1, 67455, '\P{^Is_Blk=lineara}', "");
    Expect(0, 67456, '\p{Is_Blk=lineara}', "");
    Expect(1, 67456, '\p{^Is_Blk=lineara}', "");
    Expect(1, 67456, '\P{Is_Blk=lineara}', "");
    Expect(0, 67456, '\P{^Is_Blk=lineara}', "");
    Expect(1, 67455, '\p{Is_Blk=-linear_A}', "");
    Expect(0, 67455, '\p{^Is_Blk=-linear_A}', "");
    Expect(0, 67455, '\P{Is_Blk=-linear_A}', "");
    Expect(1, 67455, '\P{^Is_Blk=-linear_A}', "");
    Expect(0, 67456, '\p{Is_Blk=-linear_A}', "");
    Expect(1, 67456, '\p{^Is_Blk=-linear_A}', "");
    Expect(1, 67456, '\P{Is_Blk=-linear_A}', "");
    Expect(0, 67456, '\P{^Is_Blk=-linear_A}', "");
    Error('\p{Block=		Linear_B_IDEOGRAMS/a/}');
    Error('\P{Block=		Linear_B_IDEOGRAMS/a/}');
    Expect(1, 65791, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Block=-_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Block=-_LINEAR_B_IDEOGRAMS}', "");
    Error('\p{Blk=_:=Linear_B_IDEOGRAMS}');
    Error('\P{Blk=_:=Linear_B_IDEOGRAMS}');
    Expect(1, 65791, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Blk=_Linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Blk=_Linear_B_IDEOGRAMS}', "");
    Error('\p{Is_Block=/a/  Linear_b_Ideograms}');
    Error('\P{Is_Block=/a/  Linear_b_Ideograms}');
    Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(0, 65791, '\P{Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(0, 65792, '\p{Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(1, 65792, '\P{Is_Block=	-LINEAR_B_ideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=	-LINEAR_B_ideograms}', "");
    Error('\p{Is_Blk=/a/-_linear_B_ideograms}');
    Error('\P{Is_Blk=/a/-_linear_B_ideograms}');
    Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Blk=--Linear_b_ideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=--Linear_b_ideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=--Linear_b_ideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=--Linear_b_ideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=--Linear_b_ideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=--Linear_b_ideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=--Linear_b_ideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=--Linear_b_ideograms}', "");
    Error('\p{Block: -LINEAR_b_SYLLABARY/a/}');
    Error('\P{Block: -LINEAR_b_SYLLABARY/a/}');
    Expect(1, 65663, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Block=_	Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Block=_	Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Block=_	Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Block=_	Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Block=_	Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Block=_	Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Block=_	Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Block=_	Linear_B_Syllabary}', "");
    Error('\p{Blk=_:=Linear_B_Syllabary}');
    Error('\P{Blk=_:=Linear_B_Syllabary}');
    Expect(1, 65663, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk= -LINEAR_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Blk= -LINEAR_B_Syllabary}', "");
    Expect(0, 65663, '\P{Blk= -LINEAR_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Blk= -LINEAR_B_Syllabary}', "");
    Expect(0, 65664, '\p{Blk= -LINEAR_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Blk= -LINEAR_B_Syllabary}', "");
    Expect(1, 65664, '\P{Blk= -LINEAR_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Blk= -LINEAR_B_Syllabary}', "");
    Error('\p{Is_Block=:=_	Linear_B_SYLLABARY}');
    Error('\P{Is_Block=:=_	Linear_B_SYLLABARY}');
    Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Block=-_linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=-_linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Is_Block=-_linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=-_linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Is_Block=-_linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=-_linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Is_Block=-_linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=-_linear_B_Syllabary}', "");
    Error('\p{Is_Blk=-/a/LINEAR_B_Syllabary}');
    Error('\P{Is_Blk=-/a/LINEAR_B_Syllabary}');
    Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(0, 65663, '\p{^Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(0, 65663, '\P{Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(1, 65663, '\P{^Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(0, 65664, '\p{Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(1, 65664, '\p{^Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(1, 65664, '\P{Is_Blk:LINEAR_B_SYLLABARY}', "");
    Expect(0, 65664, '\P{^Is_Blk:LINEAR_B_SYLLABARY}', "");
    Error('\p{Block=-/a/Lisu}');
    Error('\P{Block=-/a/Lisu}');
    Expect(1, 42239, '\p{Block=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Block=lisu}', "");
    Expect(0, 42239, '\p{^Block=lisu}', "");
    Expect(0, 42239, '\P{Block=lisu}', "");
    Expect(1, 42239, '\P{^Block=lisu}', "");
    Expect(0, 42240, '\p{Block=lisu}', "");
    Expect(1, 42240, '\p{^Block=lisu}', "");
    Expect(1, 42240, '\P{Block=lisu}', "");
    Expect(0, 42240, '\P{^Block=lisu}', "");
    Expect(1, 42239, '\p{Block=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Block=_-Lisu}', "");
    Expect(0, 42239, '\p{^Block=_-Lisu}', "");
    Expect(0, 42239, '\P{Block=_-Lisu}', "");
    Expect(1, 42239, '\P{^Block=_-Lisu}', "");
    Expect(0, 42240, '\p{Block=_-Lisu}', "");
    Expect(1, 42240, '\p{^Block=_-Lisu}', "");
    Expect(1, 42240, '\P{Block=_-Lisu}', "");
    Expect(0, 42240, '\P{^Block=_-Lisu}', "");
    Error('\p{Blk=		Lisu:=}');
    Error('\P{Blk=		Lisu:=}');
    Expect(1, 42239, '\p{Blk=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Blk:   lisu}', "");
    Expect(0, 42239, '\p{^Blk:   lisu}', "");
    Expect(0, 42239, '\P{Blk:   lisu}', "");
    Expect(1, 42239, '\P{^Blk:   lisu}', "");
    Expect(0, 42240, '\p{Blk:   lisu}', "");
    Expect(1, 42240, '\p{^Blk:   lisu}', "");
    Expect(1, 42240, '\P{Blk:   lisu}', "");
    Expect(0, 42240, '\P{^Blk:   lisu}', "");
    Expect(1, 42239, '\p{Blk=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Blk= _Lisu}', "");
    Expect(0, 42239, '\p{^Blk= _Lisu}', "");
    Expect(0, 42239, '\P{Blk= _Lisu}', "");
    Expect(1, 42239, '\P{^Blk= _Lisu}', "");
    Expect(0, 42240, '\p{Blk= _Lisu}', "");
    Expect(1, 42240, '\p{^Blk= _Lisu}', "");
    Expect(1, 42240, '\P{Blk= _Lisu}', "");
    Expect(0, 42240, '\P{^Blk= _Lisu}', "");
    Error('\p{Is_Block=/a/	_LISU}');
    Error('\P{Is_Block=/a/	_LISU}');
    Expect(1, 42239, '\p{Is_Block: lisu}', "");
    Expect(0, 42239, '\p{^Is_Block: lisu}', "");
    Expect(0, 42239, '\P{Is_Block: lisu}', "");
    Expect(1, 42239, '\P{^Is_Block: lisu}', "");
    Expect(0, 42240, '\p{Is_Block: lisu}', "");
    Expect(1, 42240, '\p{^Is_Block: lisu}', "");
    Expect(1, 42240, '\P{Is_Block: lisu}', "");
    Expect(0, 42240, '\P{^Is_Block: lisu}', "");
    Expect(1, 42239, '\p{Is_Block=- LISU}', "");
    Expect(0, 42239, '\p{^Is_Block=- LISU}', "");
    Expect(0, 42239, '\P{Is_Block=- LISU}', "");
    Expect(1, 42239, '\P{^Is_Block=- LISU}', "");
    Expect(0, 42240, '\p{Is_Block=- LISU}', "");
    Expect(1, 42240, '\p{^Is_Block=- LISU}', "");
    Expect(1, 42240, '\P{Is_Block=- LISU}', "");
    Expect(0, 42240, '\P{^Is_Block=- LISU}', "");
    Error('\p{Is_Blk=:=	LISU}');
    Error('\P{Is_Blk=:=	LISU}');
    Expect(1, 42239, '\p{Is_Blk=lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk=lisu}', "");
    Expect(0, 42239, '\P{Is_Blk=lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk=lisu}', "");
    Expect(0, 42240, '\p{Is_Blk=lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk=lisu}', "");
    Expect(1, 42240, '\P{Is_Blk=lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk=lisu}', "");
    Expect(1, 42239, '\p{Is_Blk= Lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk= Lisu}', "");
    Expect(0, 42239, '\P{Is_Blk= Lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk= Lisu}', "");
    Expect(0, 42240, '\p{Is_Blk= Lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk= Lisu}', "");
    Expect(1, 42240, '\P{Is_Blk= Lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk= Lisu}', "");
    Error('\p{Block=	_low_surrogates:=}');
    Error('\P{Block=	_low_surrogates:=}');
    Expect(1, 57343, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Block= 	Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Block= 	Low_Surrogates}', "");
    Expect(0, 57343, '\P{Block= 	Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Block= 	Low_Surrogates}', "");
    Expect(0, 57344, '\p{Block= 	Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Block= 	Low_Surrogates}', "");
    Expect(1, 57344, '\P{Block= 	Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Block= 	Low_Surrogates}', "");
    Error('\p{Blk=	Low_SURROGATES/a/}');
    Error('\P{Blk=	Low_SURROGATES/a/}');
    Expect(1, 57343, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=		low_Surrogates}', "");
    Expect(0, 57343, '\p{^Blk=		low_Surrogates}', "");
    Expect(0, 57343, '\P{Blk=		low_Surrogates}', "");
    Expect(1, 57343, '\P{^Blk=		low_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=		low_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=		low_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=		low_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=		low_Surrogates}', "");
    Error('\p{Is_Block= :=low_Surrogates}');
    Error('\P{Is_Block= :=low_Surrogates}');
    Expect(1, 57343, '\p{Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Block=_ Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=_ Low_Surrogates}', "");
    Expect(0, 57343, '\P{Is_Block=_ Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=_ Low_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=_ Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=_ Low_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=_ Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=_ Low_Surrogates}', "");
    Error('\p{Is_Blk= :=Low_surrogates}');
    Error('\P{Is_Blk= :=Low_surrogates}');
    Expect(1, 57343, '\p{Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Blk=	Low_surrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=	Low_surrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=	Low_surrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=	Low_surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=	Low_surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=	Low_surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=	Low_surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=	Low_surrogates}', "");
    Error('\p{Block= :=LYCIAN}');
    Error('\P{Block= :=LYCIAN}');
    Expect(1, 66207, '\p{Block=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Block=lycian}', "");
    Expect(0, 66207, '\p{^Block=lycian}', "");
    Expect(0, 66207, '\P{Block=lycian}', "");
    Expect(1, 66207, '\P{^Block=lycian}', "");
    Expect(0, 66208, '\p{Block=lycian}', "");
    Expect(1, 66208, '\p{^Block=lycian}', "");
    Expect(1, 66208, '\P{Block=lycian}', "");
    Expect(0, 66208, '\P{^Block=lycian}', "");
    Expect(1, 66207, '\p{Block=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Block= _Lycian}', "");
    Expect(0, 66207, '\p{^Block= _Lycian}', "");
    Expect(0, 66207, '\P{Block= _Lycian}', "");
    Expect(1, 66207, '\P{^Block= _Lycian}', "");
    Expect(0, 66208, '\p{Block= _Lycian}', "");
    Expect(1, 66208, '\p{^Block= _Lycian}', "");
    Expect(1, 66208, '\P{Block= _Lycian}', "");
    Expect(0, 66208, '\P{^Block= _Lycian}', "");
    Error('\p{Blk=_-lycian/a/}');
    Error('\P{Blk=_-lycian/a/}');
    Expect(1, 66207, '\p{Blk=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=lycian}', "");
    Expect(0, 66207, '\p{^Blk=lycian}', "");
    Expect(0, 66207, '\P{Blk=lycian}', "");
    Expect(1, 66207, '\P{^Blk=lycian}', "");
    Expect(0, 66208, '\p{Blk=lycian}', "");
    Expect(1, 66208, '\p{^Blk=lycian}', "");
    Expect(1, 66208, '\P{Blk=lycian}', "");
    Expect(0, 66208, '\P{^Blk=lycian}', "");
    Expect(1, 66207, '\p{Blk=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Blk= 	Lycian}', "");
    Expect(0, 66207, '\p{^Blk= 	Lycian}', "");
    Expect(0, 66207, '\P{Blk= 	Lycian}', "");
    Expect(1, 66207, '\P{^Blk= 	Lycian}', "");
    Expect(0, 66208, '\p{Blk= 	Lycian}', "");
    Expect(1, 66208, '\p{^Blk= 	Lycian}', "");
    Expect(1, 66208, '\P{Blk= 	Lycian}', "");
    Expect(0, 66208, '\P{^Blk= 	Lycian}', "");
    Error('\p{Is_Block=		Lycian/a/}');
    Error('\P{Is_Block=		Lycian/a/}');
    Expect(1, 66207, '\p{Is_Block=lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=lycian}', "");
    Expect(0, 66207, '\P{Is_Block=lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=lycian}', "");
    Expect(0, 66208, '\p{Is_Block=lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=lycian}', "");
    Expect(1, 66208, '\P{Is_Block=lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=lycian}', "");
    Expect(1, 66207, '\p{Is_Block=	-LYCIAN}', "");
    Expect(0, 66207, '\p{^Is_Block=	-LYCIAN}', "");
    Expect(0, 66207, '\P{Is_Block=	-LYCIAN}', "");
    Expect(1, 66207, '\P{^Is_Block=	-LYCIAN}', "");
    Expect(0, 66208, '\p{Is_Block=	-LYCIAN}', "");
    Expect(1, 66208, '\p{^Is_Block=	-LYCIAN}', "");
    Expect(1, 66208, '\P{Is_Block=	-LYCIAN}', "");
    Expect(0, 66208, '\P{^Is_Block=	-LYCIAN}', "");
    Error('\p{Is_Blk=:=	 lycian}');
    Error('\P{Is_Blk=:=	 lycian}');
    Expect(1, 66207, '\p{Is_Blk=lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=lycian}', "");
    Expect(1, 66207, '\p{Is_Blk:		lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk:		lycian}', "");
    Expect(0, 66207, '\P{Is_Blk:		lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk:		lycian}', "");
    Expect(0, 66208, '\p{Is_Blk:		lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk:		lycian}', "");
    Expect(1, 66208, '\P{Is_Blk:		lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk:		lycian}', "");
    Error('\p{Block= /a/LYDIAN}');
    Error('\P{Block= /a/LYDIAN}');
    Expect(1, 67903, '\p{Block=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Block=lydian}', "");
    Expect(0, 67903, '\p{^Block=lydian}', "");
    Expect(0, 67903, '\P{Block=lydian}', "");
    Expect(1, 67903, '\P{^Block=lydian}', "");
    Expect(0, 67904, '\p{Block=lydian}', "");
    Expect(1, 67904, '\p{^Block=lydian}', "");
    Expect(1, 67904, '\P{Block=lydian}', "");
    Expect(0, 67904, '\P{^Block=lydian}', "");
    Expect(1, 67903, '\p{Block=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Block= -Lydian}', "");
    Expect(0, 67903, '\p{^Block= -Lydian}', "");
    Expect(0, 67903, '\P{Block= -Lydian}', "");
    Expect(1, 67903, '\P{^Block= -Lydian}', "");
    Expect(0, 67904, '\p{Block= -Lydian}', "");
    Expect(1, 67904, '\p{^Block= -Lydian}', "");
    Expect(1, 67904, '\P{Block= -Lydian}', "");
    Expect(0, 67904, '\P{^Block= -Lydian}', "");
    Error('\p{Blk=/a/Lydian}');
    Error('\P{Blk=/a/Lydian}');
    Expect(1, 67903, '\p{Blk=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=lydian}', "");
    Expect(0, 67903, '\p{^Blk=lydian}', "");
    Expect(0, 67903, '\P{Blk=lydian}', "");
    Expect(1, 67903, '\P{^Blk=lydian}', "");
    Expect(0, 67904, '\p{Blk=lydian}', "");
    Expect(1, 67904, '\p{^Blk=lydian}', "");
    Expect(1, 67904, '\P{Blk=lydian}', "");
    Expect(0, 67904, '\P{^Blk=lydian}', "");
    Expect(1, 67903, '\p{Blk=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=--LYDIAN}', "");
    Expect(0, 67903, '\p{^Blk=--LYDIAN}', "");
    Expect(0, 67903, '\P{Blk=--LYDIAN}', "");
    Expect(1, 67903, '\P{^Blk=--LYDIAN}', "");
    Expect(0, 67904, '\p{Blk=--LYDIAN}', "");
    Expect(1, 67904, '\p{^Blk=--LYDIAN}', "");
    Expect(1, 67904, '\P{Blk=--LYDIAN}', "");
    Expect(0, 67904, '\P{^Blk=--LYDIAN}', "");
    Error('\p{Is_Block=/a/ Lydian}');
    Error('\P{Is_Block=/a/ Lydian}');
    Expect(1, 67903, '\p{Is_Block=lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=lydian}', "");
    Expect(0, 67903, '\P{Is_Block=lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=lydian}', "");
    Expect(0, 67904, '\p{Is_Block=lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=lydian}', "");
    Expect(1, 67904, '\P{Is_Block=lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=lydian}', "");
    Expect(1, 67903, '\p{Is_Block=	-LYDIAN}', "");
    Expect(0, 67903, '\p{^Is_Block=	-LYDIAN}', "");
    Expect(0, 67903, '\P{Is_Block=	-LYDIAN}', "");
    Expect(1, 67903, '\P{^Is_Block=	-LYDIAN}', "");
    Expect(0, 67904, '\p{Is_Block=	-LYDIAN}', "");
    Expect(1, 67904, '\p{^Is_Block=	-LYDIAN}', "");
    Expect(1, 67904, '\P{Is_Block=	-LYDIAN}', "");
    Expect(0, 67904, '\P{^Is_Block=	-LYDIAN}', "");
    Error('\p{Is_Blk=:= 	Lydian}');
    Error('\P{Is_Blk=:= 	Lydian}');
    Expect(1, 67903, '\p{Is_Blk=lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk=lydian}', "");
    Expect(0, 67903, '\P{Is_Blk=lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk=lydian}', "");
    Expect(0, 67904, '\p{Is_Blk=lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk=lydian}', "");
    Expect(1, 67904, '\P{Is_Blk=lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk=lydian}', "");
    Expect(1, 67903, '\p{Is_Blk=-Lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk=-Lydian}', "");
    Expect(0, 67903, '\P{Is_Blk=-Lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk=-Lydian}', "");
    Expect(0, 67904, '\p{Is_Blk=-Lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk=-Lydian}', "");
    Expect(1, 67904, '\P{Is_Blk=-Lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk=-Lydian}', "");
    Error('\p{Block= -Mahajani/a/}');
    Error('\P{Block= -Mahajani/a/}');
    Expect(1, 70015, '\p{Block=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Block=mahajani}', "");
    Expect(0, 70015, '\p{^Block=mahajani}', "");
    Expect(0, 70015, '\P{Block=mahajani}', "");
    Expect(1, 70015, '\P{^Block=mahajani}', "");
    Expect(0, 70016, '\p{Block=mahajani}', "");
    Expect(1, 70016, '\p{^Block=mahajani}', "");
    Expect(1, 70016, '\P{Block=mahajani}', "");
    Expect(0, 70016, '\P{^Block=mahajani}', "");
    Expect(1, 70015, '\p{Block=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Block= Mahajani}', "");
    Expect(0, 70015, '\p{^Block= Mahajani}', "");
    Expect(0, 70015, '\P{Block= Mahajani}', "");
    Expect(1, 70015, '\P{^Block= Mahajani}', "");
    Expect(0, 70016, '\p{Block= Mahajani}', "");
    Expect(1, 70016, '\p{^Block= Mahajani}', "");
    Expect(1, 70016, '\P{Block= Mahajani}', "");
    Expect(0, 70016, '\P{^Block= Mahajani}', "");
    Error('\p{Blk=_:=Mahajani}');
    Error('\P{Blk=_:=Mahajani}');
    Expect(1, 70015, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Blk=mahajani}', "");
    Expect(0, 70015, '\P{Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Blk=mahajani}', "");
    Expect(0, 70016, '\p{Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Blk=mahajani}', "");
    Expect(1, 70016, '\P{Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Blk=mahajani}', "");
    Expect(1, 70015, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk=- MAHAJANI}', "");
    Expect(0, 70015, '\p{^Blk=- MAHAJANI}', "");
    Expect(0, 70015, '\P{Blk=- MAHAJANI}', "");
    Expect(1, 70015, '\P{^Blk=- MAHAJANI}', "");
    Expect(0, 70016, '\p{Blk=- MAHAJANI}', "");
    Expect(1, 70016, '\p{^Blk=- MAHAJANI}', "");
    Expect(1, 70016, '\P{Blk=- MAHAJANI}', "");
    Expect(0, 70016, '\P{^Blk=- MAHAJANI}', "");
    Error('\p{Is_Block=/a/ Mahajani}');
    Error('\P{Is_Block=/a/ Mahajani}');
    Expect(1, 70015, '\p{Is_Block=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=mahajani}', "");
    Expect(1, 70015, '\p{Is_Block=_ mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=_ mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=_ mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=_ mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=_ mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=_ mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=_ mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=_ mahajani}', "");
    Error('\p{Is_Blk:    :=Mahajani}');
    Error('\P{Is_Blk:    :=Mahajani}');
    Expect(1, 70015, '\p{Is_Blk:	mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk:	mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk:	mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk:	mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk:	mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk:	mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk:	mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk:	mahajani}', "");
    Expect(1, 70015, '\p{Is_Blk= -mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk= -mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk= -mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk= -mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk= -mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk= -mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk= -mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk= -mahajani}', "");
    Error('\p{Block:   -mahjong_Tiles:=}');
    Error('\P{Block:   -mahjong_Tiles:=}');
    Expect(1, 127023, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(1, 127023, '\p{Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(1, 127023, '\p{Block=	-mahjong_TILES}', "");
    Expect(0, 127023, '\p{^Block=	-mahjong_TILES}', "");
    Expect(0, 127023, '\P{Block=	-mahjong_TILES}', "");
    Expect(1, 127023, '\P{^Block=	-mahjong_TILES}', "");
    Expect(0, 127024, '\p{Block=	-mahjong_TILES}', "");
    Expect(1, 127024, '\p{^Block=	-mahjong_TILES}', "");
    Expect(1, 127024, '\P{Block=	-mahjong_TILES}', "");
    Expect(0, 127024, '\P{^Block=	-mahjong_TILES}', "");
    Error('\p{Blk=_:=mahjong}');
    Error('\P{Blk=_:=mahjong}');
    Expect(1, 127023, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Blk=mahjong}', "");
    Expect(0, 127023, '\P{Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Blk=mahjong}', "");
    Expect(0, 127024, '\p{Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Blk=mahjong}', "");
    Expect(1, 127024, '\P{Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Blk=mahjong}', "");
    Expect(1, 127023, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=_Mahjong}', "");
    Expect(0, 127023, '\p{^Blk=_Mahjong}', "");
    Expect(0, 127023, '\P{Blk=_Mahjong}', "");
    Expect(1, 127023, '\P{^Blk=_Mahjong}', "");
    Expect(0, 127024, '\p{Blk=_Mahjong}', "");
    Expect(1, 127024, '\p{^Blk=_Mahjong}', "");
    Expect(1, 127024, '\P{Blk=_Mahjong}', "");
    Expect(0, 127024, '\P{^Blk=_Mahjong}', "");
    Error('\p{Is_Block=_ Mahjong_Tiles/a/}');
    Error('\P{Is_Block=_ Mahjong_Tiles/a/}');
    Expect(1, 127023, '\p{Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Is_Block=-_MAHJONG_Tiles}', "");
    Expect(0, 127023, '\p{^Is_Block=-_MAHJONG_Tiles}', "");
    Expect(0, 127023, '\P{Is_Block=-_MAHJONG_Tiles}', "");
    Expect(1, 127023, '\P{^Is_Block=-_MAHJONG_Tiles}', "");
    Expect(0, 127024, '\p{Is_Block=-_MAHJONG_Tiles}', "");
    Expect(1, 127024, '\p{^Is_Block=-_MAHJONG_Tiles}', "");
    Expect(1, 127024, '\P{Is_Block=-_MAHJONG_Tiles}', "");
    Expect(0, 127024, '\P{^Is_Block=-_MAHJONG_Tiles}', "");
    Error('\p{Is_Blk=/a/-	Mahjong}');
    Error('\P{Is_Blk=/a/-	Mahjong}');
    Expect(1, 127023, '\p{Is_Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk=mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk=mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk=mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk=mahjong}', "");
    Expect(1, 127023, '\p{Is_Blk:-_Mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk:-_Mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk:-_Mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk:-_Mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk:-_Mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk:-_Mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk:-_Mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk:-_Mahjong}', "");
    Error('\p{Block=:=-	makasar}');
    Error('\P{Block=:=-	makasar}');
    Expect(1, 73471, '\p{Block=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=makasar}', "");
    Expect(0, 73471, '\p{^Block=makasar}', "");
    Expect(0, 73471, '\P{Block=makasar}', "");
    Expect(1, 73471, '\P{^Block=makasar}', "");
    Expect(0, 73472, '\p{Block=makasar}', "");
    Expect(1, 73472, '\p{^Block=makasar}', "");
    Expect(1, 73472, '\P{Block=makasar}', "");
    Expect(0, 73472, '\P{^Block=makasar}', "");
    Expect(1, 73471, '\p{Block=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=	Makasar}', "");
    Expect(0, 73471, '\p{^Block=	Makasar}', "");
    Expect(0, 73471, '\P{Block=	Makasar}', "");
    Expect(1, 73471, '\P{^Block=	Makasar}', "");
    Expect(0, 73472, '\p{Block=	Makasar}', "");
    Expect(1, 73472, '\p{^Block=	Makasar}', "");
    Expect(1, 73472, '\P{Block=	Makasar}', "");
    Expect(0, 73472, '\P{^Block=	Makasar}', "");
    Error('\p{Blk=/a/ 	MAKASAR}');
    Error('\P{Blk=/a/ 	MAKASAR}');
    Expect(1, 73471, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk:makasar}', "");
    Expect(0, 73471, '\p{^Blk:makasar}', "");
    Expect(0, 73471, '\P{Blk:makasar}', "");
    Expect(1, 73471, '\P{^Blk:makasar}', "");
    Expect(0, 73472, '\p{Blk:makasar}', "");
    Expect(1, 73472, '\p{^Blk:makasar}', "");
    Expect(1, 73472, '\P{Blk:makasar}', "");
    Expect(0, 73472, '\P{^Blk:makasar}', "");
    Expect(1, 73471, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=_ makasar}', "");
    Expect(0, 73471, '\p{^Blk=_ makasar}', "");
    Expect(0, 73471, '\P{Blk=_ makasar}', "");
    Expect(1, 73471, '\P{^Blk=_ makasar}', "");
    Expect(0, 73472, '\p{Blk=_ makasar}', "");
    Expect(1, 73472, '\p{^Blk=_ makasar}', "");
    Expect(1, 73472, '\P{Blk=_ makasar}', "");
    Expect(0, 73472, '\P{^Blk=_ makasar}', "");
    Error('\p{Is_Block=/a/_-MAKASAR}');
    Error('\P{Is_Block=/a/_-MAKASAR}');
    Expect(1, 73471, '\p{Is_Block=makasar}', "");
    Expect(0, 73471, '\p{^Is_Block=makasar}', "");
    Expect(0, 73471, '\P{Is_Block=makasar}', "");
    Expect(1, 73471, '\P{^Is_Block=makasar}', "");
    Expect(0, 73472, '\p{Is_Block=makasar}', "");
    Expect(1, 73472, '\p{^Is_Block=makasar}', "");
    Expect(1, 73472, '\P{Is_Block=makasar}', "");
    Expect(0, 73472, '\P{^Is_Block=makasar}', "");
    Expect(1, 73471, '\p{Is_Block=_-Makasar}', "");
    Expect(0, 73471, '\p{^Is_Block=_-Makasar}', "");
    Expect(0, 73471, '\P{Is_Block=_-Makasar}', "");
    Expect(1, 73471, '\P{^Is_Block=_-Makasar}', "");
    Expect(0, 73472, '\p{Is_Block=_-Makasar}', "");
    Expect(1, 73472, '\p{^Is_Block=_-Makasar}', "");
    Expect(1, 73472, '\P{Is_Block=_-Makasar}', "");
    Expect(0, 73472, '\P{^Is_Block=_-Makasar}', "");
    Error('\p{Is_Blk=_makasar:=}');
    Error('\P{Is_Blk=_makasar:=}');
    Expect(1, 73471, '\p{Is_Blk=makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk=makasar}', "");
    Expect(0, 73471, '\P{Is_Blk=makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk=makasar}', "");
    Expect(0, 73472, '\p{Is_Blk=makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk=makasar}', "");
    Expect(1, 73472, '\P{Is_Blk=makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk=makasar}', "");
    Expect(1, 73471, '\p{Is_Blk:   -_MAKASAR}', "");
    Expect(0, 73471, '\p{^Is_Blk:   -_MAKASAR}', "");
    Expect(0, 73471, '\P{Is_Blk:   -_MAKASAR}', "");
    Expect(1, 73471, '\P{^Is_Blk:   -_MAKASAR}', "");
    Expect(0, 73472, '\p{Is_Blk:   -_MAKASAR}', "");
    Expect(1, 73472, '\p{^Is_Blk:   -_MAKASAR}', "");
    Expect(1, 73472, '\P{Is_Blk:   -_MAKASAR}', "");
    Expect(0, 73472, '\P{^Is_Blk:   -_MAKASAR}', "");
    Error('\p{Block=_Malayalam/a/}');
    Error('\P{Block=_Malayalam/a/}');
    Expect(1, 3455, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=malayalam}', "");
    Expect(0, 3455, '\p{^Block=malayalam}', "");
    Expect(0, 3455, '\P{Block=malayalam}', "");
    Expect(1, 3455, '\P{^Block=malayalam}', "");
    Expect(0, 3456, '\p{Block=malayalam}', "");
    Expect(1, 3456, '\p{^Block=malayalam}', "");
    Expect(1, 3456, '\P{Block=malayalam}', "");
    Expect(0, 3456, '\P{^Block=malayalam}', "");
    Expect(1, 3455, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=- MALAYALAM}', "");
    Expect(0, 3455, '\p{^Block=- MALAYALAM}', "");
    Expect(0, 3455, '\P{Block=- MALAYALAM}', "");
    Expect(1, 3455, '\P{^Block=- MALAYALAM}', "");
    Expect(0, 3456, '\p{Block=- MALAYALAM}', "");
    Expect(1, 3456, '\p{^Block=- MALAYALAM}', "");
    Expect(1, 3456, '\P{Block=- MALAYALAM}', "");
    Expect(0, 3456, '\P{^Block=- MALAYALAM}', "");
    Error('\p{Blk=	_malayalam/a/}');
    Error('\P{Blk=	_malayalam/a/}');
    Expect(1, 3455, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Blk=malayalam}', "");
    Expect(0, 3455, '\P{Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Blk=malayalam}', "");
    Expect(0, 3456, '\p{Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Blk=malayalam}', "");
    Expect(1, 3456, '\P{Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Blk=malayalam}', "");
    Expect(1, 3455, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk=-	MALAYALAM}', "");
    Expect(0, 3455, '\p{^Blk=-	MALAYALAM}', "");
    Expect(0, 3455, '\P{Blk=-	MALAYALAM}', "");
    Expect(1, 3455, '\P{^Blk=-	MALAYALAM}', "");
    Expect(0, 3456, '\p{Blk=-	MALAYALAM}', "");
    Expect(1, 3456, '\p{^Blk=-	MALAYALAM}', "");
    Expect(1, 3456, '\P{Blk=-	MALAYALAM}', "");
    Expect(0, 3456, '\P{^Blk=-	MALAYALAM}', "");
    Error('\p{Is_Block=__malayalam/a/}');
    Error('\P{Is_Block=__malayalam/a/}');
    Expect(1, 3455, '\p{Is_Block: malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block: malayalam}', "");
    Expect(0, 3455, '\P{Is_Block: malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block: malayalam}', "");
    Expect(0, 3456, '\p{Is_Block: malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block: malayalam}', "");
    Expect(1, 3456, '\P{Is_Block: malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block: malayalam}', "");
    Expect(1, 3455, '\p{Is_Block=_Malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=_Malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=_Malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=_Malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=_Malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=_Malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=_Malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=_Malayalam}', "");
    Error('\p{Is_Blk=	:=malayalam}');
    Error('\P{Is_Blk=	:=malayalam}');
    Expect(1, 3455, '\p{Is_Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk=malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk=malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk=malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk=malayalam}', "");
    Expect(1, 3455, '\p{Is_Blk: Malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk: Malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk: Malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk: Malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk: Malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk: Malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk: Malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk: Malayalam}', "");
    Error('\p{Block=:=-Mandaic}');
    Error('\P{Block=:=-Mandaic}');
    Expect(1, 2143, '\p{Block=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=mandaic}', "");
    Expect(0, 2143, '\p{^Block=mandaic}', "");
    Expect(0, 2143, '\P{Block=mandaic}', "");
    Expect(1, 2143, '\P{^Block=mandaic}', "");
    Expect(0, 2144, '\p{Block=mandaic}', "");
    Expect(1, 2144, '\p{^Block=mandaic}', "");
    Expect(1, 2144, '\P{Block=mandaic}', "");
    Expect(0, 2144, '\P{^Block=mandaic}', "");
    Expect(1, 2143, '\p{Block=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=-_Mandaic}', "");
    Expect(0, 2143, '\p{^Block=-_Mandaic}', "");
    Expect(0, 2143, '\P{Block=-_Mandaic}', "");
    Expect(1, 2143, '\P{^Block=-_Mandaic}', "");
    Expect(0, 2144, '\p{Block=-_Mandaic}', "");
    Expect(1, 2144, '\p{^Block=-_Mandaic}', "");
    Expect(1, 2144, '\P{Block=-_Mandaic}', "");
    Expect(0, 2144, '\P{^Block=-_Mandaic}', "");
    Error('\p{Blk=/a/__Mandaic}');
    Error('\P{Blk=/a/__Mandaic}');
    Expect(1, 2143, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Blk=mandaic}', "");
    Expect(0, 2143, '\P{Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Blk=mandaic}', "");
    Expect(0, 2144, '\p{Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Blk=mandaic}', "");
    Expect(1, 2144, '\P{Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Blk=mandaic}', "");
    Expect(1, 2143, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=_MANDAIC}', "");
    Expect(0, 2143, '\p{^Blk=_MANDAIC}', "");
    Expect(0, 2143, '\P{Blk=_MANDAIC}', "");
    Expect(1, 2143, '\P{^Blk=_MANDAIC}', "");
    Expect(0, 2144, '\p{Blk=_MANDAIC}', "");
    Expect(1, 2144, '\p{^Blk=_MANDAIC}', "");
    Expect(1, 2144, '\P{Blk=_MANDAIC}', "");
    Expect(0, 2144, '\P{^Blk=_MANDAIC}', "");
    Error('\p{Is_Block:  /a/Mandaic}');
    Error('\P{Is_Block:  /a/Mandaic}');
    Expect(1, 2143, '\p{Is_Block=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block=mandaic}', "");
    Expect(0, 2143, '\P{Is_Block=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block=mandaic}', "");
    Expect(0, 2144, '\p{Is_Block=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block=mandaic}', "");
    Expect(1, 2144, '\P{Is_Block=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block=mandaic}', "");
    Expect(1, 2143, '\p{Is_Block:  Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block:  Mandaic}', "");
    Expect(0, 2143, '\P{Is_Block:  Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block:  Mandaic}', "");
    Expect(0, 2144, '\p{Is_Block:  Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block:  Mandaic}', "");
    Expect(1, 2144, '\P{Is_Block:  Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block:  Mandaic}', "");
    Error('\p{Is_Blk=		Mandaic:=}');
    Error('\P{Is_Blk=		Mandaic:=}');
    Expect(1, 2143, '\p{Is_Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk=mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk=mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk=mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk=mandaic}', "");
    Expect(1, 2143, '\p{Is_Blk= Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk= Mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk= Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk= Mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk= Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk= Mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk= Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk= Mandaic}', "");
    Error('\p{Block=/a/	_MANICHAEAN}');
    Error('\P{Block=/a/	_MANICHAEAN}');
    Expect(1, 68351, '\p{Block=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=manichaean}', "");
    Expect(0, 68351, '\p{^Block=manichaean}', "");
    Expect(0, 68351, '\P{Block=manichaean}', "");
    Expect(1, 68351, '\P{^Block=manichaean}', "");
    Expect(0, 68352, '\p{Block=manichaean}', "");
    Expect(1, 68352, '\p{^Block=manichaean}', "");
    Expect(1, 68352, '\P{Block=manichaean}', "");
    Expect(0, 68352, '\P{^Block=manichaean}', "");
    Expect(1, 68351, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=_Manichaean}', "");
    Expect(0, 68351, '\p{^Block=_Manichaean}', "");
    Expect(0, 68351, '\P{Block=_Manichaean}', "");
    Expect(1, 68351, '\P{^Block=_Manichaean}', "");
    Expect(0, 68352, '\p{Block=_Manichaean}', "");
    Expect(1, 68352, '\p{^Block=_Manichaean}', "");
    Expect(1, 68352, '\P{Block=_Manichaean}', "");
    Expect(0, 68352, '\P{^Block=_Manichaean}', "");
    Error('\p{Blk=--Manichaean:=}');
    Error('\P{Blk=--Manichaean:=}');
    Expect(1, 68351, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Blk=manichaean}', "");
    Expect(0, 68351, '\P{Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Blk=manichaean}', "");
    Expect(0, 68352, '\p{Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Blk=manichaean}', "");
    Expect(1, 68352, '\P{Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Blk=manichaean}', "");
    Expect(1, 68351, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=-	Manichaean}', "");
    Expect(0, 68351, '\p{^Blk=-	Manichaean}', "");
    Expect(0, 68351, '\P{Blk=-	Manichaean}', "");
    Expect(1, 68351, '\P{^Blk=-	Manichaean}', "");
    Expect(0, 68352, '\p{Blk=-	Manichaean}', "");
    Expect(1, 68352, '\p{^Blk=-	Manichaean}', "");
    Expect(1, 68352, '\P{Blk=-	Manichaean}', "");
    Expect(0, 68352, '\P{^Blk=-	Manichaean}', "");
    Error('\p{Is_Block=/a/manichaean}');
    Error('\P{Is_Block=/a/manichaean}');
    Expect(1, 68351, '\p{Is_Block=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=manichaean}', "");
    Expect(1, 68351, '\p{Is_Block=	manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=	manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=	manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=	manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=	manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=	manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=	manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=	manichaean}', "");
    Error('\p{Is_Blk=:=	Manichaean}');
    Error('\P{Is_Blk=:=	Manichaean}');
    Expect(1, 68351, '\p{Is_Blk:   manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk:   manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk:   manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk:   manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk:   manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk:   manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk:   manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk:   manichaean}', "");
    Expect(1, 68351, '\p{Is_Blk=	-Manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk=	-Manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk=	-Manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk=	-Manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk=	-Manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk=	-Manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk=	-Manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk=	-Manichaean}', "");
    Error('\p{Block=--marchen/a/}');
    Error('\P{Block=--marchen/a/}');
    Expect(1, 72895, '\p{Block=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Block=marchen}', "");
    Expect(0, 72895, '\p{^Block=marchen}', "");
    Expect(0, 72895, '\P{Block=marchen}', "");
    Expect(1, 72895, '\P{^Block=marchen}', "");
    Expect(0, 72896, '\p{Block=marchen}', "");
    Expect(1, 72896, '\p{^Block=marchen}', "");
    Expect(1, 72896, '\P{Block=marchen}', "");
    Expect(0, 72896, '\P{^Block=marchen}', "");
    Expect(1, 72895, '\p{Block=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Block: _marchen}', "");
    Expect(0, 72895, '\p{^Block: _marchen}', "");
    Expect(0, 72895, '\P{Block: _marchen}', "");
    Expect(1, 72895, '\P{^Block: _marchen}', "");
    Expect(0, 72896, '\p{Block: _marchen}', "");
    Expect(1, 72896, '\p{^Block: _marchen}', "");
    Expect(1, 72896, '\P{Block: _marchen}', "");
    Expect(0, 72896, '\P{^Block: _marchen}', "");
    Error('\p{Blk=_:=marchen}');
    Error('\P{Blk=_:=marchen}');
    Expect(1, 72895, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=marchen}', "");
    Expect(0, 72895, '\p{^Blk=marchen}', "");
    Expect(0, 72895, '\P{Blk=marchen}', "");
    Expect(1, 72895, '\P{^Blk=marchen}', "");
    Expect(0, 72896, '\p{Blk=marchen}', "");
    Expect(1, 72896, '\p{^Blk=marchen}', "");
    Expect(1, 72896, '\P{Blk=marchen}', "");
    Expect(0, 72896, '\P{^Blk=marchen}', "");
    Expect(1, 72895, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=__Marchen}', "");
    Expect(0, 72895, '\p{^Blk=__Marchen}', "");
    Expect(0, 72895, '\P{Blk=__Marchen}', "");
    Expect(1, 72895, '\P{^Blk=__Marchen}', "");
    Expect(0, 72896, '\p{Blk=__Marchen}', "");
    Expect(1, 72896, '\p{^Blk=__Marchen}', "");
    Expect(1, 72896, '\P{Blk=__Marchen}', "");
    Expect(0, 72896, '\P{^Blk=__Marchen}', "");
    Error('\p{Is_Block= /a/MARCHEN}');
    Error('\P{Is_Block= /a/MARCHEN}');
    Expect(1, 72895, '\p{Is_Block=marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=marchen}', "");
    Expect(0, 72895, '\P{Is_Block=marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=marchen}', "");
    Expect(0, 72896, '\p{Is_Block=marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=marchen}', "");
    Expect(1, 72896, '\P{Is_Block=marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=marchen}', "");
    Expect(1, 72895, '\p{Is_Block=_	Marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=_	Marchen}', "");
    Expect(0, 72895, '\P{Is_Block=_	Marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=_	Marchen}', "");
    Expect(0, 72896, '\p{Is_Block=_	Marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=_	Marchen}', "");
    Expect(1, 72896, '\P{Is_Block=_	Marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=_	Marchen}', "");
    Error('\p{Is_Blk=/a/		marchen}');
    Error('\P{Is_Blk=/a/		marchen}');
    Expect(1, 72895, '\p{Is_Blk=marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=marchen}', "");
    Expect(1, 72895, '\p{Is_Blk= Marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk= Marchen}', "");
    Expect(0, 72895, '\P{Is_Blk= Marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk= Marchen}', "");
    Expect(0, 72896, '\p{Is_Blk= Marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk= Marchen}', "");
    Expect(1, 72896, '\P{Is_Blk= Marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk= Marchen}', "");
    Error('\p{Block= /a/Masaram_gondi}');
    Error('\P{Block= /a/Masaram_gondi}');
    Expect(1, 73055, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Block:	masaramgondi}', "");
    Expect(0, 73055, '\p{^Block:	masaramgondi}', "");
    Expect(0, 73055, '\P{Block:	masaramgondi}', "");
    Expect(1, 73055, '\P{^Block:	masaramgondi}', "");
    Expect(0, 73056, '\p{Block:	masaramgondi}', "");
    Expect(1, 73056, '\p{^Block:	masaramgondi}', "");
    Expect(1, 73056, '\P{Block:	masaramgondi}', "");
    Expect(0, 73056, '\P{^Block:	masaramgondi}', "");
    Expect(1, 73055, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Block=- MASARAM_GONDI}', "");
    Expect(0, 73055, '\p{^Block=- MASARAM_GONDI}', "");
    Expect(0, 73055, '\P{Block=- MASARAM_GONDI}', "");
    Expect(1, 73055, '\P{^Block=- MASARAM_GONDI}', "");
    Expect(0, 73056, '\p{Block=- MASARAM_GONDI}', "");
    Expect(1, 73056, '\p{^Block=- MASARAM_GONDI}', "");
    Expect(1, 73056, '\P{Block=- MASARAM_GONDI}', "");
    Expect(0, 73056, '\P{^Block=- MASARAM_GONDI}', "");
    Error('\p{Blk=/a/MASARAM_GONDI}');
    Error('\P{Blk=/a/MASARAM_GONDI}');
    Expect(1, 73055, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Blk:masaramgondi}', "");
    Expect(0, 73055, '\p{^Blk:masaramgondi}', "");
    Expect(0, 73055, '\P{Blk:masaramgondi}', "");
    Expect(1, 73055, '\P{^Blk:masaramgondi}', "");
    Expect(0, 73056, '\p{Blk:masaramgondi}', "");
    Expect(1, 73056, '\p{^Blk:masaramgondi}', "");
    Expect(1, 73056, '\P{Blk:masaramgondi}', "");
    Expect(0, 73056, '\P{^Blk:masaramgondi}', "");
    Expect(1, 73055, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Blk=	 Masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Blk=	 Masaram_Gondi}', "");
    Expect(0, 73055, '\P{Blk=	 Masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Blk=	 Masaram_Gondi}', "");
    Expect(0, 73056, '\p{Blk=	 Masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Blk=	 Masaram_Gondi}', "");
    Expect(1, 73056, '\P{Blk=	 Masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Blk=	 Masaram_Gondi}', "");
    Error('\p{Is_Block=-	Masaram_GONDI/a/}');
    Error('\P{Is_Block=-	Masaram_GONDI/a/}');
    Expect(1, 73055, '\p{Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Block= -MASARAM_GONDI}', "");
    Expect(0, 73055, '\p{^Is_Block= -MASARAM_GONDI}', "");
    Expect(0, 73055, '\P{Is_Block= -MASARAM_GONDI}', "");
    Expect(1, 73055, '\P{^Is_Block= -MASARAM_GONDI}', "");
    Expect(0, 73056, '\p{Is_Block= -MASARAM_GONDI}', "");
    Expect(1, 73056, '\p{^Is_Block= -MASARAM_GONDI}', "");
    Expect(1, 73056, '\P{Is_Block= -MASARAM_GONDI}', "");
    Expect(0, 73056, '\P{^Is_Block= -MASARAM_GONDI}', "");
    Error('\p{Is_Blk:	:=Masaram_GONDI}');
    Error('\P{Is_Blk:	:=Masaram_GONDI}');
    Expect(1, 73055, '\p{Is_Blk:   masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Blk:   masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Blk:   masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Blk:   masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Blk:   masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Blk:   masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Blk:   masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Blk:   masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Blk: 	Masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Is_Blk: 	Masaram_Gondi}', "");
    Expect(0, 73055, '\P{Is_Blk: 	Masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Is_Blk: 	Masaram_Gondi}', "");
    Expect(0, 73056, '\p{Is_Blk: 	Masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Is_Blk: 	Masaram_Gondi}', "");
    Expect(1, 73056, '\P{Is_Blk: 	Masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Is_Blk: 	Masaram_Gondi}', "");
    Error('\p{Block=/a/	 mathematical_alphanumeric_SYMBOLS}');
    Error('\P{Block=/a/	 mathematical_alphanumeric_SYMBOLS}');
    Expect(1, 120831, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(1, 120831, '\p{Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(1, 120831, '\p{Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120831, '\p{^Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120831, '\P{Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(1, 120831, '\P{^Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120832, '\p{Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(1, 120832, '\p{^Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(1, 120832, '\P{Block=__Mathematical_alphanumeric_Symbols}', "");
    Expect(0, 120832, '\P{^Block=__Mathematical_alphanumeric_Symbols}', "");
    Error('\p{Blk= /a/Math_alphanum}');
    Error('\P{Blk= /a/Math_alphanum}');
    Expect(1, 120831, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk= MATH_ALPHANUM}', "");
    Expect(0, 120831, '\p{^Blk= MATH_ALPHANUM}', "");
    Expect(0, 120831, '\P{Blk= MATH_ALPHANUM}', "");
    Expect(1, 120831, '\P{^Blk= MATH_ALPHANUM}', "");
    Expect(0, 120832, '\p{Blk= MATH_ALPHANUM}', "");
    Expect(1, 120832, '\p{^Blk= MATH_ALPHANUM}', "");
    Expect(1, 120832, '\P{Blk= MATH_ALPHANUM}', "");
    Expect(0, 120832, '\P{^Blk= MATH_ALPHANUM}', "");
    Error('\p{Is_Block= :=MATHEMATICAL_Alphanumeric_symbols}');
    Error('\P{Is_Block= :=MATHEMATICAL_Alphanumeric_symbols}');
    Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(0, 120831, '\p{^Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(0, 120831, '\P{Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(1, 120831, '\P{^Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(0, 120832, '\p{Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(1, 120832, '\p{^Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(1, 120832, '\P{Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Expect(0, 120832, '\P{^Is_Block=	 MATHEMATICAL_alphanumeric_SYMBOLS}', "");
    Error('\p{Is_Blk=	Math_ALPHANUM/a/}');
    Error('\P{Is_Blk=	Math_ALPHANUM/a/}');
    Expect(1, 120831, '\p{Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Is_Blk=_Math_ALPHANUM}', "");
    Expect(0, 120831, '\p{^Is_Blk=_Math_ALPHANUM}', "");
    Expect(0, 120831, '\P{Is_Blk=_Math_ALPHANUM}', "");
    Expect(1, 120831, '\P{^Is_Blk=_Math_ALPHANUM}', "");
    Expect(0, 120832, '\p{Is_Blk=_Math_ALPHANUM}', "");
    Expect(1, 120832, '\p{^Is_Blk=_Math_ALPHANUM}', "");
    Expect(1, 120832, '\P{Is_Blk=_Math_ALPHANUM}', "");
    Expect(0, 120832, '\P{^Is_Blk=_Math_ALPHANUM}', "");
    Error('\p{Block=-/a/Mathematical_Operators}');
    Error('\P{Block=-/a/Mathematical_Operators}');
    Expect(1, 8959, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(1, 8959, '\p{Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Block=:\Amathematicaloperators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\Amathematicaloperators\z:}', "");;
    Expect(1, 8959, '\p{Block=-Mathematical_Operators}', "");
    Expect(0, 8959, '\p{^Block=-Mathematical_Operators}', "");
    Expect(0, 8959, '\P{Block=-Mathematical_Operators}', "");
    Expect(1, 8959, '\P{^Block=-Mathematical_Operators}', "");
    Expect(0, 8960, '\p{Block=-Mathematical_Operators}', "");
    Expect(1, 8960, '\p{^Block=-Mathematical_Operators}', "");
    Expect(1, 8960, '\P{Block=-Mathematical_Operators}', "");
    Expect(0, 8960, '\P{^Block=-Mathematical_Operators}', "");
    Error('\p{Blk=/a/_ Math_Operators}');
    Error('\P{Blk=/a/_ Math_Operators}');
    Expect(1, 8959, '\p{Blk=:\AMath_Operators\z:}', "");;
    Expect(0, 8960, '\p{Blk=:\AMath_Operators\z:}', "");;
    Expect(1, 8959, '\p{Blk: mathoperators}', "");
    Expect(0, 8959, '\p{^Blk: mathoperators}', "");
    Expect(0, 8959, '\P{Blk: mathoperators}', "");
    Expect(1, 8959, '\P{^Blk: mathoperators}', "");
    Expect(0, 8960, '\p{Blk: mathoperators}', "");
    Expect(1, 8960, '\p{^Blk: mathoperators}', "");
    Expect(1, 8960, '\P{Blk: mathoperators}', "");
    Expect(0, 8960, '\P{^Blk: mathoperators}', "");
    Expect(1, 8959, '\p{Blk=:\Amathoperators\z:}', "");;
    Expect(0, 8960, '\p{Blk=:\Amathoperators\z:}', "");;
    Expect(1, 8959, '\p{Blk=-Math_Operators}', "");
    Expect(0, 8959, '\p{^Blk=-Math_Operators}', "");
    Expect(0, 8959, '\P{Blk=-Math_Operators}', "");
    Expect(1, 8959, '\P{^Blk=-Math_Operators}', "");
    Expect(0, 8960, '\p{Blk=-Math_Operators}', "");
    Expect(1, 8960, '\p{^Blk=-Math_Operators}', "");
    Expect(1, 8960, '\P{Blk=-Math_Operators}', "");
    Expect(0, 8960, '\P{^Blk=-Math_Operators}', "");
    Error('\p{Is_Block=/a/ Mathematical_Operators}');
    Error('\P{Is_Block=/a/ Mathematical_Operators}');
    Expect(1, 8959, '\p{Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Is_Block=__mathematical_Operators}', "");
    Expect(0, 8959, '\p{^Is_Block=__mathematical_Operators}', "");
    Expect(0, 8959, '\P{Is_Block=__mathematical_Operators}', "");
    Expect(1, 8959, '\P{^Is_Block=__mathematical_Operators}', "");
    Expect(0, 8960, '\p{Is_Block=__mathematical_Operators}', "");
    Expect(1, 8960, '\p{^Is_Block=__mathematical_Operators}', "");
    Expect(1, 8960, '\P{Is_Block=__mathematical_Operators}', "");
    Expect(0, 8960, '\P{^Is_Block=__mathematical_Operators}', "");
    Error('\p{Is_Blk:   /a/-MATH_operators}');
    Error('\P{Is_Blk:   /a/-MATH_operators}');
    Expect(1, 8959, '\p{Is_Blk:mathoperators}', "");
    Expect(0, 8959, '\p{^Is_Blk:mathoperators}', "");
    Expect(0, 8959, '\P{Is_Blk:mathoperators}', "");
    Expect(1, 8959, '\P{^Is_Blk:mathoperators}', "");
    Expect(0, 8960, '\p{Is_Blk:mathoperators}', "");
    Expect(1, 8960, '\p{^Is_Blk:mathoperators}', "");
    Expect(1, 8960, '\P{Is_Blk:mathoperators}', "");
    Expect(0, 8960, '\P{^Is_Blk:mathoperators}', "");
    Expect(1, 8959, '\p{Is_Blk=_MATH_operators}', "");
    Expect(0, 8959, '\p{^Is_Blk=_MATH_operators}', "");
    Expect(0, 8959, '\P{Is_Blk=_MATH_operators}', "");
    Expect(1, 8959, '\P{^Is_Blk=_MATH_operators}', "");
    Expect(0, 8960, '\p{Is_Blk=_MATH_operators}', "");
    Expect(1, 8960, '\p{^Is_Blk=_MATH_operators}', "");
    Expect(1, 8960, '\P{Is_Blk=_MATH_operators}', "");
    Expect(0, 8960, '\P{^Is_Blk=_MATH_operators}', "");
    Error('\p{Block= :=MAYAN_numerals}');
    Error('\P{Block= :=MAYAN_numerals}');
    Expect(1, 119551, '\p{Block=:\AMayan_Numerals\z:}', "");;
    Expect(0, 119552, '\p{Block=:\AMayan_Numerals\z:}', "");;
    Expect(1, 119551, '\p{Block=mayannumerals}', "");
    Expect(0, 119551, '\p{^Block=mayannumerals}', "");
    Expect(0, 119551, '\P{Block=mayannumerals}', "");
    Expect(1, 119551, '\P{^Block=mayannumerals}', "");
    Expect(0, 119552, '\p{Block=mayannumerals}', "");
    Expect(1, 119552, '\p{^Block=mayannumerals}', "");
    Expect(1, 119552, '\P{Block=mayannumerals}', "");
    Expect(0, 119552, '\P{^Block=mayannumerals}', "");
    Expect(1, 119551, '\p{Block=:\Amayannumerals\z:}', "");;
    Expect(0, 119552, '\p{Block=:\Amayannumerals\z:}', "");;
    Expect(1, 119551, '\p{Block= _mayan_Numerals}', "");
    Expect(0, 119551, '\p{^Block= _mayan_Numerals}', "");
    Expect(0, 119551, '\P{Block= _mayan_Numerals}', "");
    Expect(1, 119551, '\P{^Block= _mayan_Numerals}', "");
    Expect(0, 119552, '\p{Block= _mayan_Numerals}', "");
    Expect(1, 119552, '\p{^Block= _mayan_Numerals}', "");
    Expect(1, 119552, '\P{Block= _mayan_Numerals}', "");
    Expect(0, 119552, '\P{^Block= _mayan_Numerals}', "");
    Error('\p{Blk:	 mayan_numerals/a/}');
    Error('\P{Blk:	 mayan_numerals/a/}');
    Expect(1, 119551, '\p{Blk=:\AMayan_Numerals\z:}', "");;
    Expect(0, 119552, '\p{Blk=:\AMayan_Numerals\z:}', "");;
    Expect(1, 119551, '\p{Blk=mayannumerals}', "");
    Expect(0, 119551, '\p{^Blk=mayannumerals}', "");
    Expect(0, 119551, '\P{Blk=mayannumerals}', "");
    Expect(1, 119551, '\P{^Blk=mayannumerals}', "");
    Expect(0, 119552, '\p{Blk=mayannumerals}', "");
    Expect(1, 119552, '\p{^Blk=mayannumerals}', "");
    Expect(1, 119552, '\P{Blk=mayannumerals}', "");
    Expect(0, 119552, '\P{^Blk=mayannumerals}', "");
    Expect(1, 119551, '\p{Blk=:\Amayannumerals\z:}', "");;
    Expect(0, 119552, '\p{Blk=:\Amayannumerals\z:}', "");;
    Expect(1, 119551, '\p{Blk=_-Mayan_Numerals}', "");
    Expect(0, 119551, '\p{^Blk=_-Mayan_Numerals}', "");
    Expect(0, 119551, '\P{Blk=_-Mayan_Numerals}', "");
    Expect(1, 119551, '\P{^Blk=_-Mayan_Numerals}', "");
    Expect(0, 119552, '\p{Blk=_-Mayan_Numerals}', "");
    Expect(1, 119552, '\p{^Blk=_-Mayan_Numerals}', "");
    Expect(1, 119552, '\P{Blk=_-Mayan_Numerals}', "");
    Expect(0, 119552, '\P{^Blk=_-Mayan_Numerals}', "");
    Error('\p{Is_Block=-/a/MAYAN_Numerals}');
    Error('\P{Is_Block=-/a/MAYAN_Numerals}');
    Expect(1, 119551, '\p{Is_Block=mayannumerals}', "");
    Expect(0, 119551, '\p{^Is_Block=mayannumerals}', "");
    Expect(0, 119551, '\P{Is_Block=mayannumerals}', "");
    Expect(1, 119551, '\P{^Is_Block=mayannumerals}', "");
    Expect(0, 119552, '\p{Is_Block=mayannumerals}', "");
    Expect(1, 119552, '\p{^Is_Block=mayannumerals}', "");
    Expect(1, 119552, '\P{Is_Block=mayannumerals}', "");
    Expect(0, 119552, '\P{^Is_Block=mayannumerals}', "");
    Expect(1, 119551, '\p{Is_Block=__MAYAN_numerals}', "");
    Expect(0, 119551, '\p{^Is_Block=__MAYAN_numerals}', "");
    Expect(0, 119551, '\P{Is_Block=__MAYAN_numerals}', "");
    Expect(1, 119551, '\P{^Is_Block=__MAYAN_numerals}', "");
    Expect(0, 119552, '\p{Is_Block=__MAYAN_numerals}', "");
    Expect(1, 119552, '\p{^Is_Block=__MAYAN_numerals}', "");
    Expect(1, 119552, '\P{Is_Block=__MAYAN_numerals}', "");
    Expect(0, 119552, '\P{^Is_Block=__MAYAN_numerals}', "");
    Error('\p{Is_Blk=/a/mayan_Numerals}');
    Error('\P{Is_Blk=/a/mayan_Numerals}');
    Expect(1, 119551, '\p{Is_Blk=mayannumerals}', "");
    Expect(0, 119551, '\p{^Is_Blk=mayannumerals}', "");
    Expect(0, 119551, '\P{Is_Blk=mayannumerals}', "");
    Expect(1, 119551, '\P{^Is_Blk=mayannumerals}', "");
    Expect(0, 119552, '\p{Is_Blk=mayannumerals}', "");
    Expect(1, 119552, '\p{^Is_Blk=mayannumerals}', "");
    Expect(1, 119552, '\P{Is_Blk=mayannumerals}', "");
    Expect(0, 119552, '\P{^Is_Blk=mayannumerals}', "");
    Expect(1, 119551, '\p{Is_Blk=_mayan_Numerals}', "");
    Expect(0, 119551, '\p{^Is_Blk=_mayan_Numerals}', "");
    Expect(0, 119551, '\P{Is_Blk=_mayan_Numerals}', "");
    Expect(1, 119551, '\P{^Is_Blk=_mayan_Numerals}', "");
    Expect(0, 119552, '\p{Is_Blk=_mayan_Numerals}', "");
    Expect(1, 119552, '\p{^Is_Blk=_mayan_Numerals}', "");
    Expect(1, 119552, '\P{Is_Blk=_mayan_Numerals}', "");
    Expect(0, 119552, '\P{^Is_Blk=_mayan_Numerals}', "");
    Error('\p{Block::= Medefaidrin}');
    Error('\P{Block::= Medefaidrin}');
    Expect(1, 93855, '\p{Block=:\AMedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Block=:\AMedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Block=medefaidrin}', "");
    Expect(0, 93855, '\p{^Block=medefaidrin}', "");
    Expect(0, 93855, '\P{Block=medefaidrin}', "");
    Expect(1, 93855, '\P{^Block=medefaidrin}', "");
    Expect(0, 93856, '\p{Block=medefaidrin}', "");
    Expect(1, 93856, '\p{^Block=medefaidrin}', "");
    Expect(1, 93856, '\P{Block=medefaidrin}', "");
    Expect(0, 93856, '\P{^Block=medefaidrin}', "");
    Expect(1, 93855, '\p{Block=:\Amedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Block=:\Amedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Block= _MEDEFAIDRIN}', "");
    Expect(0, 93855, '\p{^Block= _MEDEFAIDRIN}', "");
    Expect(0, 93855, '\P{Block= _MEDEFAIDRIN}', "");
    Expect(1, 93855, '\P{^Block= _MEDEFAIDRIN}', "");
    Expect(0, 93856, '\p{Block= _MEDEFAIDRIN}', "");
    Expect(1, 93856, '\p{^Block= _MEDEFAIDRIN}', "");
    Expect(1, 93856, '\P{Block= _MEDEFAIDRIN}', "");
    Expect(0, 93856, '\P{^Block= _MEDEFAIDRIN}', "");
    Error('\p{Blk=	Medefaidrin:=}');
    Error('\P{Blk=	Medefaidrin:=}');
    Expect(1, 93855, '\p{Blk=:\AMedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Blk=:\AMedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Blk=medefaidrin}', "");
    Expect(0, 93855, '\p{^Blk=medefaidrin}', "");
    Expect(0, 93855, '\P{Blk=medefaidrin}', "");
    Expect(1, 93855, '\P{^Blk=medefaidrin}', "");
    Expect(0, 93856, '\p{Blk=medefaidrin}', "");
    Expect(1, 93856, '\p{^Blk=medefaidrin}', "");
    Expect(1, 93856, '\P{Blk=medefaidrin}', "");
    Expect(0, 93856, '\P{^Blk=medefaidrin}', "");
    Expect(1, 93855, '\p{Blk=:\Amedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Blk=:\Amedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Blk:   _ Medefaidrin}', "");
    Expect(0, 93855, '\p{^Blk:   _ Medefaidrin}', "");
    Expect(0, 93855, '\P{Blk:   _ Medefaidrin}', "");
    Expect(1, 93855, '\P{^Blk:   _ Medefaidrin}', "");
    Expect(0, 93856, '\p{Blk:   _ Medefaidrin}', "");
    Expect(1, 93856, '\p{^Blk:   _ Medefaidrin}', "");
    Expect(1, 93856, '\P{Blk:   _ Medefaidrin}', "");
    Expect(0, 93856, '\P{^Blk:   _ Medefaidrin}', "");
    Error('\p{Is_Block=_:=Medefaidrin}');
    Error('\P{Is_Block=_:=Medefaidrin}');
    Expect(1, 93855, '\p{Is_Block=medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Block=medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Block=medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Block=medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Block=medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Block=medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Block=medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Block=medefaidrin}', "");
    Expect(1, 93855, '\p{Is_Block=	 Medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Block=	 Medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Block=	 Medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Block=	 Medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Block=	 Medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Block=	 Medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Block=	 Medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Block=	 Medefaidrin}', "");
    Error('\p{Is_Blk=__Medefaidrin:=}');
    Error('\P{Is_Blk=__Medefaidrin:=}');
    Expect(1, 93855, '\p{Is_Blk=medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Blk=medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Blk=medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Blk=medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Blk=medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Blk=medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Blk=medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Blk=medefaidrin}', "");
    Error('\p{Block=-_MEETEI_Mayek/a/}');
    Error('\P{Block=-_MEETEI_Mayek/a/}');
    Expect(1, 44031, '\p{Block=:\AMeetei_Mayek\z:}', "");;
    Expect(0, 44032, '\p{Block=:\AMeetei_Mayek\z:}', "");;
    Expect(1, 44031, '\p{Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Block=:\Ameeteimayek\z:}', "");;
    Expect(0, 44032, '\p{Block=:\Ameeteimayek\z:}', "");;
    Expect(1, 44031, '\p{Block=-Meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Block=-Meetei_Mayek}', "");
    Expect(0, 44031, '\P{Block=-Meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Block=-Meetei_Mayek}', "");
    Expect(0, 44032, '\p{Block=-Meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Block=-Meetei_Mayek}', "");
    Expect(1, 44032, '\P{Block=-Meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Block=-Meetei_Mayek}', "");
    Error('\p{Blk=_/a/MEETEI_MAYEK}');
    Error('\P{Blk=_/a/MEETEI_MAYEK}');
    Expect(1, 44031, '\p{Blk=:\AMeetei_Mayek\z:}', "");;
    Expect(0, 44032, '\p{Blk=:\AMeetei_Mayek\z:}', "");;
    Expect(1, 44031, '\p{Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Blk=:\Ameeteimayek\z:}', "");;
    Expect(0, 44032, '\p{Blk=:\Ameeteimayek\z:}', "");;
    Expect(1, 44031, '\p{Blk=--Meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Blk=--Meetei_Mayek}', "");
    Expect(0, 44031, '\P{Blk=--Meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Blk=--Meetei_Mayek}', "");
    Expect(0, 44032, '\p{Blk=--Meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Blk=--Meetei_Mayek}', "");
    Expect(1, 44032, '\P{Blk=--Meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Blk=--Meetei_Mayek}', "");
    Error('\p{Is_Block=  Meetei_mayek/a/}');
    Error('\P{Is_Block=  Meetei_mayek/a/}');
    Expect(1, 44031, '\p{Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Block:   _	Meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Is_Block:   _	Meetei_Mayek}', "");
    Expect(0, 44031, '\P{Is_Block:   _	Meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Is_Block:   _	Meetei_Mayek}', "");
    Expect(0, 44032, '\p{Is_Block:   _	Meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Is_Block:   _	Meetei_Mayek}', "");
    Expect(1, 44032, '\P{Is_Block:   _	Meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Is_Block:   _	Meetei_Mayek}', "");
    Error('\p{Is_Blk::=_-meetei_Mayek}');
    Error('\P{Is_Blk::=_-meetei_Mayek}');
    Expect(1, 44031, '\p{Is_Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Blk=_-meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Is_Blk=_-meetei_Mayek}', "");
    Expect(0, 44031, '\P{Is_Blk=_-meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Is_Blk=_-meetei_Mayek}', "");
    Expect(0, 44032, '\p{Is_Blk=_-meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Is_Blk=_-meetei_Mayek}', "");
    Expect(1, 44032, '\P{Is_Blk=_-meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Is_Blk=_-meetei_Mayek}', "");
    Error('\p{Block=-Meetei_mayek_EXTENSIONS/a/}');
    Error('\P{Block=-Meetei_mayek_EXTENSIONS/a/}');
    Expect(1, 43775, '\p{Block=:\AMeetei_Mayek_Extensions\z:}', "");;
    Expect(0, 43776, '\p{Block=:\AMeetei_Mayek_Extensions\z:}', "");;
    Expect(1, 43775, '\p{Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Block=:\Ameeteimayekextensions\z:}', "");;
    Expect(0, 43776, '\p{Block=:\Ameeteimayekextensions\z:}', "");;
    Expect(1, 43775, '\p{Block= Meetei_Mayek_extensions}', "");
    Expect(0, 43775, '\p{^Block= Meetei_Mayek_extensions}', "");
    Expect(0, 43775, '\P{Block= Meetei_Mayek_extensions}', "");
    Expect(1, 43775, '\P{^Block= Meetei_Mayek_extensions}', "");
    Expect(0, 43776, '\p{Block= Meetei_Mayek_extensions}', "");
    Expect(1, 43776, '\p{^Block= Meetei_Mayek_extensions}', "");
    Expect(1, 43776, '\P{Block= Meetei_Mayek_extensions}', "");
    Expect(0, 43776, '\P{^Block= Meetei_Mayek_extensions}', "");
    Error('\p{Blk=/a/	MEETEI_Mayek_ext}');
    Error('\P{Blk=/a/	MEETEI_Mayek_ext}');
    Expect(1, 43775, '\p{Blk=:\AMeetei_Mayek_Ext\z:}', "");;
    Expect(0, 43776, '\p{Blk=:\AMeetei_Mayek_Ext\z:}', "");;
    Expect(1, 43775, '\p{Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Blk=:\Ameeteimayekext\z:}', "");;
    Expect(0, 43776, '\p{Blk=:\Ameeteimayekext\z:}', "");;
    Expect(1, 43775, '\p{Blk=_Meetei_mayek_EXT}', "");
    Expect(0, 43775, '\p{^Blk=_Meetei_mayek_EXT}', "");
    Expect(0, 43775, '\P{Blk=_Meetei_mayek_EXT}', "");
    Expect(1, 43775, '\P{^Blk=_Meetei_mayek_EXT}', "");
    Expect(0, 43776, '\p{Blk=_Meetei_mayek_EXT}', "");
    Expect(1, 43776, '\p{^Blk=_Meetei_mayek_EXT}', "");
    Expect(1, 43776, '\P{Blk=_Meetei_mayek_EXT}', "");
    Expect(0, 43776, '\P{^Blk=_Meetei_mayek_EXT}', "");
    Error('\p{Is_Block=_ Meetei_mayek_Extensions/a/}');
    Error('\P{Is_Block=_ Meetei_mayek_Extensions/a/}');
    Expect(1, 43775, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Is_Block= _meetei_mayek_extensions}', "");
    Expect(0, 43775, '\p{^Is_Block= _meetei_mayek_extensions}', "");
    Expect(0, 43775, '\P{Is_Block= _meetei_mayek_extensions}', "");
    Expect(1, 43775, '\P{^Is_Block= _meetei_mayek_extensions}', "");
    Expect(0, 43776, '\p{Is_Block= _meetei_mayek_extensions}', "");
    Expect(1, 43776, '\p{^Is_Block= _meetei_mayek_extensions}', "");
    Expect(1, 43776, '\P{Is_Block= _meetei_mayek_extensions}', "");
    Expect(0, 43776, '\P{^Is_Block= _meetei_mayek_extensions}', "");
    Error('\p{Is_Blk=/a/_Meetei_Mayek_Ext}');
    Error('\P{Is_Blk=/a/_Meetei_Mayek_Ext}');
    Expect(1, 43775, '\p{Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(0, 43775, '\p{^Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(0, 43775, '\P{Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(1, 43775, '\P{^Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(0, 43776, '\p{Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(1, 43776, '\p{^Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(1, 43776, '\P{Is_Blk=MEETEI_Mayek_ext}', "");
    Expect(0, 43776, '\P{^Is_Blk=MEETEI_Mayek_ext}', "");
    Error('\p{Block=/a/ _Mende_Kikakui}');
    Error('\P{Block=/a/ _Mende_Kikakui}');
    Expect(1, 125151, '\p{Block=:\AMende_Kikakui\z:}', "");;
    Expect(0, 125152, '\p{Block=:\AMende_Kikakui\z:}', "");;
    Expect(1, 125151, '\p{Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Block=:\Amendekikakui\z:}', "");;
    Expect(0, 125152, '\p{Block=:\Amendekikakui\z:}', "");;
    Expect(1, 125151, '\p{Block=_	Mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Block=_	Mende_Kikakui}', "");
    Expect(0, 125151, '\P{Block=_	Mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Block=_	Mende_Kikakui}', "");
    Expect(0, 125152, '\p{Block=_	Mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Block=_	Mende_Kikakui}', "");
    Expect(1, 125152, '\P{Block=_	Mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Block=_	Mende_Kikakui}', "");
    Error('\p{Blk=/a/	-Mende_kikakui}');
    Error('\P{Blk=/a/	-Mende_kikakui}');
    Expect(1, 125151, '\p{Blk=:\AMende_Kikakui\z:}', "");;
    Expect(0, 125152, '\p{Blk=:\AMende_Kikakui\z:}', "");;
    Expect(1, 125151, '\p{Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Blk=:\Amendekikakui\z:}', "");;
    Expect(0, 125152, '\p{Blk=:\Amendekikakui\z:}', "");;
    Expect(1, 125151, '\p{Blk=_-Mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Blk=_-Mende_Kikakui}', "");
    Expect(0, 125151, '\P{Blk=_-Mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Blk=_-Mende_Kikakui}', "");
    Expect(0, 125152, '\p{Blk=_-Mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Blk=_-Mende_Kikakui}', "");
    Expect(1, 125152, '\P{Blk=_-Mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Blk=_-Mende_Kikakui}', "");
    Error('\p{Is_Block=_:=mende_Kikakui}');
    Error('\P{Is_Block=_:=mende_Kikakui}');
    Expect(1, 125151, '\p{Is_Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Block= Mende_KIKAKUI}', "");
    Expect(0, 125151, '\p{^Is_Block= Mende_KIKAKUI}', "");
    Expect(0, 125151, '\P{Is_Block= Mende_KIKAKUI}', "");
    Expect(1, 125151, '\P{^Is_Block= Mende_KIKAKUI}', "");
    Expect(0, 125152, '\p{Is_Block= Mende_KIKAKUI}', "");
    Expect(1, 125152, '\p{^Is_Block= Mende_KIKAKUI}', "");
    Expect(1, 125152, '\P{Is_Block= Mende_KIKAKUI}', "");
    Expect(0, 125152, '\P{^Is_Block= Mende_KIKAKUI}', "");
    Error('\p{Is_Blk=/a/MENDE_KIKAKUI}');
    Error('\P{Is_Blk=/a/MENDE_KIKAKUI}');
    Expect(1, 125151, '\p{Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Blk= _mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk= _mende_Kikakui}', "");
    Expect(0, 125151, '\P{Is_Blk= _mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk= _mende_Kikakui}', "");
    Expect(0, 125152, '\p{Is_Blk= _mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk= _mende_Kikakui}', "");
    Expect(1, 125152, '\P{Is_Blk= _mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk= _mende_Kikakui}', "");
    Error('\p{Block=_/a/Meroitic_Cursive}');
    Error('\P{Block=_/a/Meroitic_Cursive}');
    Expect(1, 68095, '\p{Block=:\AMeroitic_Cursive\z:}', "");;
    Expect(0, 68096, '\p{Block=:\AMeroitic_Cursive\z:}', "");;
    Expect(1, 68095, '\p{Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Block=:\Ameroiticcursive\z:}', "");;
    Expect(0, 68096, '\p{Block=:\Ameroiticcursive\z:}', "");;
    Expect(1, 68095, '\p{Block=_meroitic_cursive}', "");
    Expect(0, 68095, '\p{^Block=_meroitic_cursive}', "");
    Expect(0, 68095, '\P{Block=_meroitic_cursive}', "");
    Expect(1, 68095, '\P{^Block=_meroitic_cursive}', "");
    Expect(0, 68096, '\p{Block=_meroitic_cursive}', "");
    Expect(1, 68096, '\p{^Block=_meroitic_cursive}', "");
    Expect(1, 68096, '\P{Block=_meroitic_cursive}', "");
    Expect(0, 68096, '\P{^Block=_meroitic_cursive}', "");
    Error('\p{Blk=_meroitic_Cursive/a/}');
    Error('\P{Blk=_meroitic_Cursive/a/}');
    Expect(1, 68095, '\p{Blk=:\AMeroitic_Cursive\z:}', "");;
    Expect(0, 68096, '\p{Blk=:\AMeroitic_Cursive\z:}', "");;
    Expect(1, 68095, '\p{Blk:   meroiticcursive}', "");
    Expect(0, 68095, '\p{^Blk:   meroiticcursive}', "");
    Expect(0, 68095, '\P{Blk:   meroiticcursive}', "");
    Expect(1, 68095, '\P{^Blk:   meroiticcursive}', "");
    Expect(0, 68096, '\p{Blk:   meroiticcursive}', "");
    Expect(1, 68096, '\p{^Blk:   meroiticcursive}', "");
    Expect(1, 68096, '\P{Blk:   meroiticcursive}', "");
    Expect(0, 68096, '\P{^Blk:   meroiticcursive}', "");
    Expect(1, 68095, '\p{Blk=:\Ameroiticcursive\z:}', "");;
    Expect(0, 68096, '\p{Blk=:\Ameroiticcursive\z:}', "");;
    Expect(1, 68095, '\p{Blk: _ meroitic_cursive}', "");
    Expect(0, 68095, '\p{^Blk: _ meroitic_cursive}', "");
    Expect(0, 68095, '\P{Blk: _ meroitic_cursive}', "");
    Expect(1, 68095, '\P{^Blk: _ meroitic_cursive}', "");
    Expect(0, 68096, '\p{Blk: _ meroitic_cursive}', "");
    Expect(1, 68096, '\p{^Blk: _ meroitic_cursive}', "");
    Expect(1, 68096, '\P{Blk: _ meroitic_cursive}', "");
    Expect(0, 68096, '\P{^Blk: _ meroitic_cursive}', "");
    Error('\p{Is_Block=-_Meroitic_cursive:=}');
    Error('\P{Is_Block=-_Meroitic_cursive:=}');
    Expect(1, 68095, '\p{Is_Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Is_Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Is_Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Is_Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Is_Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Is_Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Is_Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Is_Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Is_Block=--meroitic_CURSIVE}', "");
    Expect(0, 68095, '\p{^Is_Block=--meroitic_CURSIVE}', "");
    Expect(0, 68095, '\P{Is_Block=--meroitic_CURSIVE}', "");
    Expect(1, 68095, '\P{^Is_Block=--meroitic_CURSIVE}', "");
    Expect(0, 68096, '\p{Is_Block=--meroitic_CURSIVE}', "");
    Expect(1, 68096, '\p{^Is_Block=--meroitic_CURSIVE}', "");
    Expect(1, 68096, '\P{Is_Block=--meroitic_CURSIVE}', "");
    Expect(0, 68096, '\P{^Is_Block=--meroitic_CURSIVE}', "");
    Error('\p{Is_Blk= /a/Meroitic_cursive}');
    Error('\P{Is_Blk= /a/Meroitic_cursive}');
    Expect(1, 68095, '\p{Is_Blk=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Is_Blk=meroiticcursive}', "");
    Expect(0, 68095, '\P{Is_Blk=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Is_Blk=meroiticcursive}', "");
    Expect(0, 68096, '\p{Is_Blk=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Is_Blk=meroiticcursive}', "");
    Expect(1, 68096, '\P{Is_Blk=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Is_Blk=meroiticcursive}', "");
    Expect(1, 68095, '\p{Is_Blk=-_MEROITIC_cursive}', "");
    Expect(0, 68095, '\p{^Is_Blk=-_MEROITIC_cursive}', "");
    Expect(0, 68095, '\P{Is_Blk=-_MEROITIC_cursive}', "");
    Expect(1, 68095, '\P{^Is_Blk=-_MEROITIC_cursive}', "");
    Expect(0, 68096, '\p{Is_Blk=-_MEROITIC_cursive}', "");
    Expect(1, 68096, '\p{^Is_Blk=-_MEROITIC_cursive}', "");
    Expect(1, 68096, '\P{Is_Blk=-_MEROITIC_cursive}', "");
    Expect(0, 68096, '\P{^Is_Blk=-_MEROITIC_cursive}', "");
    Error('\p{Block=-:=MEROITIC_Hieroglyphs}');
    Error('\P{Block=-:=MEROITIC_Hieroglyphs}');
    Expect(1, 67999, '\p{Block=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Block=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Block:meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Block:meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Block:meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Block:meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Block:meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Block:meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Block:meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Block:meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Block=:\Ameroitichieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Block=:\Ameroitichieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Block:	-Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Block:	-Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Block:	-Meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Block:	-Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Block:	-Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Block:	-Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Block:	-Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Block:	-Meroitic_Hieroglyphs}', "");
    Error('\p{Blk:    /a/Meroitic_HIEROGLYPHS}');
    Error('\P{Blk:    /a/Meroitic_HIEROGLYPHS}');
    Expect(1, 67999, '\p{Blk=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Blk=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Blk=:\Ameroitichieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Blk=:\Ameroitichieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Blk= Meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Blk= Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Blk= Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Blk= Meroitic_Hieroglyphs}', "");
    Error('\p{Is_Block=_MEROITIC_Hieroglyphs/a/}');
    Error('\P{Is_Block=_MEROITIC_Hieroglyphs/a/}');
    Expect(1, 67999, '\p{Is_Block:   meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Block:   meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Block:   meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Block:   meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Block:   meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Block:   meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Block:   meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Block:   meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Block= MEROITIC_hieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Block= MEROITIC_hieroglyphs}', "");
    Error('\p{Is_Blk=MEROITIC_HIEROGLYPHS:=}');
    Error('\P{Is_Blk=MEROITIC_HIEROGLYPHS:=}');
    Expect(1, 67999, '\p{Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Blk= Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Blk= Meroitic_Hieroglyphs}', "");
    Error('\p{Block=_:=Miao}');
    Error('\P{Block=_:=Miao}');
    Expect(1, 94111, '\p{Block=:\AMiao\z:}', "");;
    Expect(0, 94112, '\p{Block=:\AMiao\z:}', "");;
    Expect(1, 94111, '\p{Block=miao}', "");
    Expect(0, 94111, '\p{^Block=miao}', "");
    Expect(0, 94111, '\P{Block=miao}', "");
    Expect(1, 94111, '\P{^Block=miao}', "");
    Expect(0, 94112, '\p{Block=miao}', "");
    Expect(1, 94112, '\p{^Block=miao}', "");
    Expect(1, 94112, '\P{Block=miao}', "");
    Expect(0, 94112, '\P{^Block=miao}', "");
    Expect(1, 94111, '\p{Block=:\Amiao\z:}', "");;
    Expect(0, 94112, '\p{Block=:\Amiao\z:}', "");;
    Expect(1, 94111, '\p{Block=	-Miao}', "");
    Expect(0, 94111, '\p{^Block=	-Miao}', "");
    Expect(0, 94111, '\P{Block=	-Miao}', "");
    Expect(1, 94111, '\P{^Block=	-Miao}', "");
    Expect(0, 94112, '\p{Block=	-Miao}', "");
    Expect(1, 94112, '\p{^Block=	-Miao}', "");
    Expect(1, 94112, '\P{Block=	-Miao}', "");
    Expect(0, 94112, '\P{^Block=	-Miao}', "");
    Error('\p{Blk= :=Miao}');
    Error('\P{Blk= :=Miao}');
    Expect(1, 94111, '\p{Blk=:\AMiao\z:}', "");;
    Expect(0, 94112, '\p{Blk=:\AMiao\z:}', "");;
    Expect(1, 94111, '\p{Blk=miao}', "");
    Expect(0, 94111, '\p{^Blk=miao}', "");
    Expect(0, 94111, '\P{Blk=miao}', "");
    Expect(1, 94111, '\P{^Blk=miao}', "");
    Expect(0, 94112, '\p{Blk=miao}', "");
    Expect(1, 94112, '\p{^Blk=miao}', "");
    Expect(1, 94112, '\P{Blk=miao}', "");
    Expect(0, 94112, '\P{^Blk=miao}', "");
    Expect(1, 94111, '\p{Blk=:\Amiao\z:}', "");;
    Expect(0, 94112, '\p{Blk=:\Amiao\z:}', "");;
    Expect(1, 94111, '\p{Blk=--Miao}', "");
    Expect(0, 94111, '\p{^Blk=--Miao}', "");
    Expect(0, 94111, '\P{Blk=--Miao}', "");
    Expect(1, 94111, '\P{^Blk=--Miao}', "");
    Expect(0, 94112, '\p{Blk=--Miao}', "");
    Expect(1, 94112, '\p{^Blk=--Miao}', "");
    Expect(1, 94112, '\P{Blk=--Miao}', "");
    Expect(0, 94112, '\P{^Blk=--Miao}', "");
    Error('\p{Is_Block=:=_	Miao}');
    Error('\P{Is_Block=:=_	Miao}');
    Expect(1, 94111, '\p{Is_Block=miao}', "");
    Expect(0, 94111, '\p{^Is_Block=miao}', "");
    Expect(0, 94111, '\P{Is_Block=miao}', "");
    Expect(1, 94111, '\P{^Is_Block=miao}', "");
    Expect(0, 94112, '\p{Is_Block=miao}', "");
    Expect(1, 94112, '\p{^Is_Block=miao}', "");
    Expect(1, 94112, '\P{Is_Block=miao}', "");
    Expect(0, 94112, '\P{^Is_Block=miao}', "");
    Expect(1, 94111, '\p{Is_Block=_Miao}', "");
    Expect(0, 94111, '\p{^Is_Block=_Miao}', "");
    Expect(0, 94111, '\P{Is_Block=_Miao}', "");
    Expect(1, 94111, '\P{^Is_Block=_Miao}', "");
    Expect(0, 94112, '\p{Is_Block=_Miao}', "");
    Expect(1, 94112, '\p{^Is_Block=_Miao}', "");
    Expect(1, 94112, '\P{Is_Block=_Miao}', "");
    Expect(0, 94112, '\P{^Is_Block=_Miao}', "");
    Error('\p{Is_Blk=:=Miao}');
    Error('\P{Is_Blk=:=Miao}');
    Expect(1, 94111, '\p{Is_Blk=miao}', "");
    Expect(0, 94111, '\p{^Is_Blk=miao}', "");
    Expect(0, 94111, '\P{Is_Blk=miao}', "");
    Expect(1, 94111, '\P{^Is_Blk=miao}', "");
    Expect(0, 94112, '\p{Is_Blk=miao}', "");
    Expect(1, 94112, '\p{^Is_Blk=miao}', "");
    Expect(1, 94112, '\P{Is_Blk=miao}', "");
    Expect(0, 94112, '\P{^Is_Blk=miao}', "");
    Expect(1, 94111, '\p{Is_Blk=	Miao}', "");
    Expect(0, 94111, '\p{^Is_Blk=	Miao}', "");
    Expect(0, 94111, '\P{Is_Blk=	Miao}', "");
    Expect(1, 94111, '\P{^Is_Blk=	Miao}', "");
    Expect(0, 94112, '\p{Is_Blk=	Miao}', "");
    Expect(1, 94112, '\p{^Is_Blk=	Miao}', "");
    Expect(1, 94112, '\P{Is_Blk=	Miao}', "");
    Expect(0, 94112, '\P{^Is_Blk=	Miao}', "");
    Error('\p{Block:	-:=miscellaneous_Symbols_AND_Arrows}');
    Error('\P{Block:	-:=miscellaneous_Symbols_AND_Arrows}');
    Expect(1, 11263, '\p{Block=:\AMiscellaneous_Symbols_And_Arrows\z:}', "");;
    Expect(0, 11264, '\p{Block=:\AMiscellaneous_Symbols_And_Arrows\z:}', "");;
    Expect(1, 11263, '\p{Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\p{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\P{Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\P{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\p{Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\p{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\P{Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\P{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\p{Block=:\Amiscellaneoussymbolsandarrows\z:}', "");;
    Expect(0, 11264, '\p{Block=:\Amiscellaneoussymbolsandarrows\z:}', "");;
    Expect(1, 11263, '\p{Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(0, 11263, '\p{^Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(0, 11263, '\P{Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(1, 11263, '\P{^Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(0, 11264, '\p{Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(1, 11264, '\p{^Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(1, 11264, '\P{Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Expect(0, 11264, '\P{^Block=_	MISCELLANEOUS_symbols_AND_ARROWS}', "");
    Error('\p{Blk=--Misc_ARROWS:=}');
    Error('\P{Blk=--Misc_ARROWS:=}');
    Expect(1, 11263, '\p{Blk=:\AMisc_Arrows\z:}', "");;
    Expect(0, 11264, '\p{Blk=:\AMisc_Arrows\z:}', "");;
    Expect(1, 11263, '\p{Blk=miscarrows}', "");
    Expect(0, 11263, '\p{^Blk=miscarrows}', "");
    Expect(0, 11263, '\P{Blk=miscarrows}', "");
    Expect(1, 11263, '\P{^Blk=miscarrows}', "");
    Expect(0, 11264, '\p{Blk=miscarrows}', "");
    Expect(1, 11264, '\p{^Blk=miscarrows}', "");
    Expect(1, 11264, '\P{Blk=miscarrows}', "");
    Expect(0, 11264, '\P{^Blk=miscarrows}', "");
    Expect(1, 11263, '\p{Blk=:\Amiscarrows\z:}', "");;
    Expect(0, 11264, '\p{Blk=:\Amiscarrows\z:}', "");;
    Expect(1, 11263, '\p{Blk=	 Misc_arrows}', "");
    Expect(0, 11263, '\p{^Blk=	 Misc_arrows}', "");
    Expect(0, 11263, '\P{Blk=	 Misc_arrows}', "");
    Expect(1, 11263, '\P{^Blk=	 Misc_arrows}', "");
    Expect(0, 11264, '\p{Blk=	 Misc_arrows}', "");
    Expect(1, 11264, '\p{^Blk=	 Misc_arrows}', "");
    Expect(1, 11264, '\P{Blk=	 Misc_arrows}', "");
    Expect(0, 11264, '\P{^Blk=	 Misc_arrows}', "");
    Error('\p{Is_Block= -MISCELLANEOUS_SYMBOLS_AND_arrows:=}');
    Error('\P{Is_Block= -MISCELLANEOUS_SYMBOLS_AND_arrows:=}');
    Expect(1, 11263, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\p{Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(0, 11263, '\p{^Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(0, 11263, '\P{Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(1, 11263, '\P{^Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(0, 11264, '\p{Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(1, 11264, '\p{^Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(1, 11264, '\P{Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Expect(0, 11264, '\P{^Is_Block=-Miscellaneous_symbols_And_Arrows}', "");
    Error('\p{Is_Blk:	_MISC_arrows:=}');
    Error('\P{Is_Blk:	_MISC_arrows:=}');
    Expect(1, 11263, '\p{Is_Blk=miscarrows}', "");
    Expect(0, 11263, '\p{^Is_Blk=miscarrows}', "");
    Expect(0, 11263, '\P{Is_Blk=miscarrows}', "");
    Expect(1, 11263, '\P{^Is_Blk=miscarrows}', "");
    Expect(0, 11264, '\p{Is_Blk=miscarrows}', "");
    Expect(1, 11264, '\p{^Is_Blk=miscarrows}', "");
    Expect(1, 11264, '\P{Is_Blk=miscarrows}', "");
    Expect(0, 11264, '\P{^Is_Blk=miscarrows}', "");
    Expect(1, 11263, '\p{Is_Blk=  MISC_ARROWS}', "");
    Expect(0, 11263, '\p{^Is_Blk=  MISC_ARROWS}', "");
    Expect(0, 11263, '\P{Is_Blk=  MISC_ARROWS}', "");
    Expect(1, 11263, '\P{^Is_Blk=  MISC_ARROWS}', "");
    Expect(0, 11264, '\p{Is_Blk=  MISC_ARROWS}', "");
    Expect(1, 11264, '\p{^Is_Blk=  MISC_ARROWS}', "");
    Expect(1, 11264, '\P{Is_Blk=  MISC_ARROWS}', "");
    Expect(0, 11264, '\P{^Is_Blk=  MISC_ARROWS}', "");
    Error('\p{Block=		MISCELLANEOUS_MATHEMATICAL_SYMBOLS_a/a/}');
    Error('\P{Block=		MISCELLANEOUS_MATHEMATICAL_SYMBOLS_a/a/}');
    Expect(1, 10223, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_A\z:}', "");;
    Expect(0, 10224, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_A\z:}', "");;
    Expect(1, 10223, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\p{Block=:\Amiscellaneousmathematicalsymbolsa\z:}', "");;
    Expect(0, 10224, '\p{Block=:\Amiscellaneousmathematicalsymbolsa\z:}', "");;
    Expect(1, 10223, '\p{Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10223, '\p{^Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10223, '\P{Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(1, 10223, '\P{^Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10224, '\p{Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(1, 10224, '\p{^Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(1, 10224, '\P{Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10224, '\P{^Block=_	miscellaneous_Mathematical_Symbols_a}', "");
    Error('\p{Blk=/a/_Misc_Math_Symbols_a}');
    Error('\P{Blk=/a/_Misc_Math_Symbols_a}');
    Expect(1, 10223, '\p{Blk=:\AMisc_Math_Symbols_A\z:}', "");;
    Expect(0, 10224, '\p{Blk=:\AMisc_Math_Symbols_A\z:}', "");;
    Expect(1, 10223, '\p{Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\p{^Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\P{Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\P{^Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\p{Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\p{^Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\P{Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\P{^Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\p{Blk=:\Amiscmathsymbolsa\z:}', "");;
    Expect(0, 10224, '\p{Blk=:\Amiscmathsymbolsa\z:}', "");;
    Expect(1, 10223, '\p{Blk=_Misc_Math_Symbols_A}', "");
    Expect(0, 10223, '\p{^Blk=_Misc_Math_Symbols_A}', "");
    Expect(0, 10223, '\P{Blk=_Misc_Math_Symbols_A}', "");
    Expect(1, 10223, '\P{^Blk=_Misc_Math_Symbols_A}', "");
    Expect(0, 10224, '\p{Blk=_Misc_Math_Symbols_A}', "");
    Expect(1, 10224, '\p{^Blk=_Misc_Math_Symbols_A}', "");
    Expect(1, 10224, '\P{Blk=_Misc_Math_Symbols_A}', "");
    Expect(0, 10224, '\P{^Blk=_Misc_Math_Symbols_A}', "");
    Error('\p{Is_Block=:=_	Miscellaneous_Mathematical_SYMBOLS_a}');
    Error('\P{Is_Block=:=_	Miscellaneous_Mathematical_SYMBOLS_a}');
    Expect(1, 10223, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\p{Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(0, 10223, '\p{^Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(0, 10223, '\P{Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(1, 10223, '\P{^Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(0, 10224, '\p{Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(1, 10224, '\p{^Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(1, 10224, '\P{Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Expect(0, 10224, '\P{^Is_Block=	 miscellaneous_MATHEMATICAL_Symbols_A}', "");
    Error('\p{Is_Blk=/a/	_Misc_MATH_SYMBOLS_a}');
    Error('\P{Is_Blk=/a/	_Misc_MATH_SYMBOLS_a}');
    Expect(1, 10223, '\p{Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\p{^Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\P{Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\P{^Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\p{Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\p{^Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\P{Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\P{^Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\p{Is_Blk= Misc_Math_symbols_A}', "");
    Expect(0, 10223, '\p{^Is_Blk= Misc_Math_symbols_A}', "");
    Expect(0, 10223, '\P{Is_Blk= Misc_Math_symbols_A}', "");
    Expect(1, 10223, '\P{^Is_Blk= Misc_Math_symbols_A}', "");
    Expect(0, 10224, '\p{Is_Blk= Misc_Math_symbols_A}', "");
    Expect(1, 10224, '\p{^Is_Blk= Misc_Math_symbols_A}', "");
    Expect(1, 10224, '\P{Is_Blk= Misc_Math_symbols_A}', "");
    Expect(0, 10224, '\P{^Is_Blk= Misc_Math_symbols_A}', "");
    Error('\p{Block=/a/-miscellaneous_Mathematical_Symbols_b}');
    Error('\P{Block=/a/-miscellaneous_Mathematical_Symbols_b}');
    Expect(1, 10751, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_B\z:}', "");;
    Expect(0, 10752, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_B\z:}', "");;
    Expect(1, 10751, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\p{Block=:\Amiscellaneousmathematicalsymbolsb\z:}', "");;
    Expect(0, 10752, '\p{Block=:\Amiscellaneousmathematicalsymbolsb\z:}', "");;
    Expect(1, 10751, '\p{Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(0, 10751, '\p{^Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(0, 10751, '\P{Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(1, 10751, '\P{^Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(0, 10752, '\p{Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(1, 10752, '\p{^Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(1, 10752, '\P{Block=- miscellaneous_mathematical_Symbols_B}', "");
    Expect(0, 10752, '\P{^Block=- miscellaneous_mathematical_Symbols_B}', "");
    Error('\p{Blk=:=MISC_Math_SYMBOLS_B}');
    Error('\P{Blk=:=MISC_Math_SYMBOLS_B}');
    Expect(1, 10751, '\p{Blk=:\AMisc_Math_Symbols_B\z:}', "");;
    Expect(0, 10752, '\p{Blk=:\AMisc_Math_Symbols_B\z:}', "");;
    Expect(1, 10751, '\p{Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\p{^Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\P{Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\P{^Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\p{Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\p{^Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\P{Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\P{^Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\p{Blk=:\Amiscmathsymbolsb\z:}', "");;
    Expect(0, 10752, '\p{Blk=:\Amiscmathsymbolsb\z:}', "");;
    Expect(1, 10751, '\p{Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(0, 10751, '\p{^Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(0, 10751, '\P{Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(1, 10751, '\P{^Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(0, 10752, '\p{Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(1, 10752, '\p{^Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(1, 10752, '\P{Blk=_ Misc_Math_SYMBOLS_B}', "");
    Expect(0, 10752, '\P{^Blk=_ Misc_Math_SYMBOLS_B}', "");
    Error('\p{Is_Block=- Miscellaneous_MATHEMATICAL_Symbols_b:=}');
    Error('\P{Is_Block=- Miscellaneous_MATHEMATICAL_Symbols_b:=}');
    Expect(1, 10751, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\p{Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(0, 10751, '\p{^Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(0, 10751, '\P{Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(1, 10751, '\P{^Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(0, 10752, '\p{Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(1, 10752, '\p{^Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(1, 10752, '\P{Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Expect(0, 10752, '\P{^Is_Block=_ Miscellaneous_MATHEMATICAL_Symbols_B}', "");
    Error('\p{Is_Blk=/a/Misc_math_SYMBOLS_b}');
    Error('\P{Is_Blk=/a/Misc_math_SYMBOLS_b}');
    Expect(1, 10751, '\p{Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\p{^Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\P{Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\P{^Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\p{Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\p{^Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\P{Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\P{^Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\p{Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(0, 10751, '\p{^Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(0, 10751, '\P{Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(1, 10751, '\P{^Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(0, 10752, '\p{Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(1, 10752, '\p{^Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(1, 10752, '\P{Is_Blk=-_MISC_math_Symbols_B}', "");
    Expect(0, 10752, '\P{^Is_Blk=-_MISC_math_Symbols_B}', "");
    Error('\p{Block=/a/  Miscellaneous_SYMBOLS_AND_pictographs}');
    Error('\P{Block=/a/  Miscellaneous_SYMBOLS_AND_pictographs}');
    Expect(1, 128511, '\p{Block=:\AMiscellaneous_Symbols_And_Pictographs\z:}', "");;
    Expect(0, 128512, '\p{Block=:\AMiscellaneous_Symbols_And_Pictographs\z:}', "");;
    Expect(1, 128511, '\p{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\p{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\P{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\P{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\p{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\p{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\P{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\P{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\p{Block=:\Amiscellaneoussymbolsandpictographs\z:}', "");;
    Expect(0, 128512, '\p{Block=:\Amiscellaneoussymbolsandpictographs\z:}', "");;
    Expect(1, 128511, '\p{Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(0, 128511, '\p{^Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(0, 128511, '\P{Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(1, 128511, '\P{^Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(0, 128512, '\p{Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(1, 128512, '\p{^Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(1, 128512, '\P{Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Expect(0, 128512, '\P{^Block=_miscellaneous_Symbols_AND_Pictographs}', "");
    Error('\p{Blk=	-Misc_Pictographs:=}');
    Error('\P{Blk=	-Misc_Pictographs:=}');
    Expect(1, 128511, '\p{Blk=:\AMisc_Pictographs\z:}', "");;
    Expect(0, 128512, '\p{Blk=:\AMisc_Pictographs\z:}', "");;
    Expect(1, 128511, '\p{Blk=miscpictographs}', "");
    Expect(0, 128511, '\p{^Blk=miscpictographs}', "");
    Expect(0, 128511, '\P{Blk=miscpictographs}', "");
    Expect(1, 128511, '\P{^Blk=miscpictographs}', "");
    Expect(0, 128512, '\p{Blk=miscpictographs}', "");
    Expect(1, 128512, '\p{^Blk=miscpictographs}', "");
    Expect(1, 128512, '\P{Blk=miscpictographs}', "");
    Expect(0, 128512, '\P{^Blk=miscpictographs}', "");
    Expect(1, 128511, '\p{Blk=:\Amiscpictographs\z:}', "");;
    Expect(0, 128512, '\p{Blk=:\Amiscpictographs\z:}', "");;
    Expect(1, 128511, '\p{Blk:	_	misc_Pictographs}', "");
    Expect(0, 128511, '\p{^Blk:	_	misc_Pictographs}', "");
    Expect(0, 128511, '\P{Blk:	_	misc_Pictographs}', "");
    Expect(1, 128511, '\P{^Blk:	_	misc_Pictographs}', "");
    Expect(0, 128512, '\p{Blk:	_	misc_Pictographs}', "");
    Expect(1, 128512, '\p{^Blk:	_	misc_Pictographs}', "");
    Expect(1, 128512, '\P{Blk:	_	misc_Pictographs}', "");
    Expect(0, 128512, '\P{^Blk:	_	misc_Pictographs}', "");
    Error('\p{Is_Block=miscellaneous_SYMBOLS_and_PICTOGRAPHS:=}');
    Error('\P{Is_Block=miscellaneous_SYMBOLS_and_PICTOGRAPHS:=}');
    Expect(1, 128511, '\p{Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\p{^Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\P{Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\P{^Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\p{Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\p{^Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\P{Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\P{^Is_Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\p{Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(0, 128511, '\p{^Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(0, 128511, '\P{Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(1, 128511, '\P{^Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(0, 128512, '\p{Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(1, 128512, '\p{^Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(1, 128512, '\P{Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Expect(0, 128512, '\P{^Is_Block=	_MISCELLANEOUS_symbols_And_pictographs}', "");
    Error('\p{Is_Blk= 	Misc_PICTOGRAPHS/a/}');
    Error('\P{Is_Blk= 	Misc_PICTOGRAPHS/a/}');
    Expect(1, 128511, '\p{Is_Blk=miscpictographs}', "");
    Expect(0, 128511, '\p{^Is_Blk=miscpictographs}', "");
    Expect(0, 128511, '\P{Is_Blk=miscpictographs}', "");
    Expect(1, 128511, '\P{^Is_Blk=miscpictographs}', "");
    Expect(0, 128512, '\p{Is_Blk=miscpictographs}', "");
    Expect(1, 128512, '\p{^Is_Blk=miscpictographs}', "");
    Expect(1, 128512, '\P{Is_Blk=miscpictographs}', "");
    Expect(0, 128512, '\P{^Is_Blk=miscpictographs}', "");
    Expect(1, 128511, '\p{Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(0, 128511, '\p{^Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(0, 128511, '\P{Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(1, 128511, '\P{^Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(0, 128512, '\p{Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(1, 128512, '\p{^Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(1, 128512, '\P{Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Expect(0, 128512, '\P{^Is_Blk=	-Misc_PICTOGRAPHS}', "");
    Error('\p{Block=	 Miscellaneous_SYMBOLS/a/}');
    Error('\P{Block=	 Miscellaneous_SYMBOLS/a/}');
    Expect(1, 9983, '\p{Block=:\AMiscellaneous_Symbols\z:}', "");;
    Expect(0, 9984, '\p{Block=:\AMiscellaneous_Symbols\z:}', "");;
    Expect(1, 9983, '\p{Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\p{^Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\P{Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\P{^Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\p{Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\p{^Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\P{Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\P{^Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\p{Block=:\Amiscellaneoussymbols\z:}', "");;
    Expect(0, 9984, '\p{Block=:\Amiscellaneoussymbols\z:}', "");;
    Expect(1, 9983, '\p{Block=	_Miscellaneous_Symbols}', "");
    Expect(0, 9983, '\p{^Block=	_Miscellaneous_Symbols}', "");
    Expect(0, 9983, '\P{Block=	_Miscellaneous_Symbols}', "");
    Expect(1, 9983, '\P{^Block=	_Miscellaneous_Symbols}', "");
    Expect(0, 9984, '\p{Block=	_Miscellaneous_Symbols}', "");
    Expect(1, 9984, '\p{^Block=	_Miscellaneous_Symbols}', "");
    Expect(1, 9984, '\P{Block=	_Miscellaneous_Symbols}', "");
    Expect(0, 9984, '\P{^Block=	_Miscellaneous_Symbols}', "");
    Error('\p{Blk=/a/Misc_Symbols}');
    Error('\P{Blk=/a/Misc_Symbols}');
    Expect(1, 9983, '\p{Blk=:\AMisc_Symbols\z:}', "");;
    Expect(0, 9984, '\p{Blk=:\AMisc_Symbols\z:}', "");;
    Expect(1, 9983, '\p{Blk=miscsymbols}', "");
    Expect(0, 9983, '\p{^Blk=miscsymbols}', "");
    Expect(0, 9983, '\P{Blk=miscsymbols}', "");
    Expect(1, 9983, '\P{^Blk=miscsymbols}', "");
    Expect(0, 9984, '\p{Blk=miscsymbols}', "");
    Expect(1, 9984, '\p{^Blk=miscsymbols}', "");
    Expect(1, 9984, '\P{Blk=miscsymbols}', "");
    Expect(0, 9984, '\P{^Blk=miscsymbols}', "");
    Expect(1, 9983, '\p{Blk=:\Amiscsymbols\z:}', "");;
    Expect(0, 9984, '\p{Blk=:\Amiscsymbols\z:}', "");;
    Expect(1, 9983, '\p{Blk=_Misc_symbols}', "");
    Expect(0, 9983, '\p{^Blk=_Misc_symbols}', "");
    Expect(0, 9983, '\P{Blk=_Misc_symbols}', "");
    Expect(1, 9983, '\P{^Blk=_Misc_symbols}', "");
    Expect(0, 9984, '\p{Blk=_Misc_symbols}', "");
    Expect(1, 9984, '\p{^Blk=_Misc_symbols}', "");
    Expect(1, 9984, '\P{Blk=_Misc_symbols}', "");
    Expect(0, 9984, '\P{^Blk=_Misc_symbols}', "");
    Error('\p{Is_Block=:=_	Miscellaneous_symbols}');
    Error('\P{Is_Block=:=_	Miscellaneous_symbols}');
    Expect(1, 9983, '\p{Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\p{^Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\P{Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\P{^Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\p{Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\p{^Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\P{Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\P{^Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\p{Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(0, 9983, '\p{^Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(0, 9983, '\P{Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(1, 9983, '\P{^Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(0, 9984, '\p{Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(1, 9984, '\p{^Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(1, 9984, '\P{Is_Block= -MISCELLANEOUS_Symbols}', "");
    Expect(0, 9984, '\P{^Is_Block= -MISCELLANEOUS_Symbols}', "");
    Error('\p{Is_Blk=:= misc_Symbols}');
    Error('\P{Is_Blk=:= misc_Symbols}');
    Expect(1, 9983, '\p{Is_Blk=miscsymbols}', "");
    Expect(0, 9983, '\p{^Is_Blk=miscsymbols}', "");
    Expect(0, 9983, '\P{Is_Blk=miscsymbols}', "");
    Expect(1, 9983, '\P{^Is_Blk=miscsymbols}', "");
    Expect(0, 9984, '\p{Is_Blk=miscsymbols}', "");
    Expect(1, 9984, '\p{^Is_Blk=miscsymbols}', "");
    Expect(1, 9984, '\P{Is_Blk=miscsymbols}', "");
    Expect(0, 9984, '\P{^Is_Blk=miscsymbols}', "");
    Expect(1, 9983, '\p{Is_Blk:-	Misc_symbols}', "");
    Expect(0, 9983, '\p{^Is_Blk:-	Misc_symbols}', "");
    Expect(0, 9983, '\P{Is_Blk:-	Misc_symbols}', "");
    Expect(1, 9983, '\P{^Is_Blk:-	Misc_symbols}', "");
    Expect(0, 9984, '\p{Is_Blk:-	Misc_symbols}', "");
    Expect(1, 9984, '\p{^Is_Blk:-	Misc_symbols}', "");
    Expect(1, 9984, '\P{Is_Blk:-	Misc_symbols}', "");
    Expect(0, 9984, '\P{^Is_Blk:-	Misc_symbols}', "");
    Error('\p{Block=:=-MISCELLANEOUS_Technical}');
    Error('\P{Block=:=-MISCELLANEOUS_Technical}');
    Expect(1, 9215, '\p{Block=:\AMiscellaneous_Technical\z:}', "");;
    Expect(0, 9216, '\p{Block=:\AMiscellaneous_Technical\z:}', "");;
    Expect(1, 9215, '\p{Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\p{^Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\P{Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\P{^Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\p{Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\p{^Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\P{Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\P{^Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\p{Block=:\Amiscellaneoustechnical\z:}', "");;
    Expect(0, 9216, '\p{Block=:\Amiscellaneoustechnical\z:}', "");;
    Expect(1, 9215, '\p{Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(0, 9215, '\p{^Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(0, 9215, '\P{Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(1, 9215, '\P{^Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(0, 9216, '\p{Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(1, 9216, '\p{^Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(1, 9216, '\P{Block:	_	MISCELLANEOUS_Technical}', "");
    Expect(0, 9216, '\P{^Block:	_	MISCELLANEOUS_Technical}', "");
    Error('\p{Blk=:=	Misc_Technical}');
    Error('\P{Blk=:=	Misc_Technical}');
    Expect(1, 9215, '\p{Blk=:\AMisc_Technical\z:}', "");;
    Expect(0, 9216, '\p{Blk=:\AMisc_Technical\z:}', "");;
    Expect(1, 9215, '\p{Blk=misctechnical}', "");
    Expect(0, 9215, '\p{^Blk=misctechnical}', "");
    Expect(0, 9215, '\P{Blk=misctechnical}', "");
    Expect(1, 9215, '\P{^Blk=misctechnical}', "");
    Expect(0, 9216, '\p{Blk=misctechnical}', "");
    Expect(1, 9216, '\p{^Blk=misctechnical}', "");
    Expect(1, 9216, '\P{Blk=misctechnical}', "");
    Expect(0, 9216, '\P{^Blk=misctechnical}', "");
    Expect(1, 9215, '\p{Blk=:\Amisctechnical\z:}', "");;
    Expect(0, 9216, '\p{Blk=:\Amisctechnical\z:}', "");;
    Expect(1, 9215, '\p{Blk:     misc_TECHNICAL}', "");
    Expect(0, 9215, '\p{^Blk:     misc_TECHNICAL}', "");
    Expect(0, 9215, '\P{Blk:     misc_TECHNICAL}', "");
    Expect(1, 9215, '\P{^Blk:     misc_TECHNICAL}', "");
    Expect(0, 9216, '\p{Blk:     misc_TECHNICAL}', "");
    Expect(1, 9216, '\p{^Blk:     misc_TECHNICAL}', "");
    Expect(1, 9216, '\P{Blk:     misc_TECHNICAL}', "");
    Expect(0, 9216, '\P{^Blk:     misc_TECHNICAL}', "");
    Error('\p{Is_Block=_ miscellaneous_technical/a/}');
    Error('\P{Is_Block=_ miscellaneous_technical/a/}');
    Expect(1, 9215, '\p{Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\p{^Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\P{Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\P{^Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\p{Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\p{^Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\P{Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\P{^Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\p{Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(0, 9215, '\p{^Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(0, 9215, '\P{Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(1, 9215, '\P{^Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(0, 9216, '\p{Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(1, 9216, '\p{^Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(1, 9216, '\P{Is_Block=_	MISCELLANEOUS_technical}', "");
    Expect(0, 9216, '\P{^Is_Block=_	MISCELLANEOUS_technical}', "");
    Error('\p{Is_Blk=:= _MISC_technical}');
    Error('\P{Is_Blk=:= _MISC_technical}');
    Expect(1, 9215, '\p{Is_Blk=misctechnical}', "");
    Expect(0, 9215, '\p{^Is_Blk=misctechnical}', "");
    Expect(0, 9215, '\P{Is_Blk=misctechnical}', "");
    Expect(1, 9215, '\P{^Is_Blk=misctechnical}', "");
    Expect(0, 9216, '\p{Is_Blk=misctechnical}', "");
    Expect(1, 9216, '\p{^Is_Blk=misctechnical}', "");
    Expect(1, 9216, '\P{Is_Blk=misctechnical}', "");
    Expect(0, 9216, '\P{^Is_Blk=misctechnical}', "");
    Expect(1, 9215, '\p{Is_Blk=-Misc_Technical}', "");
    Expect(0, 9215, '\p{^Is_Blk=-Misc_Technical}', "");
    Expect(0, 9215, '\P{Is_Blk=-Misc_Technical}', "");
    Expect(1, 9215, '\P{^Is_Blk=-Misc_Technical}', "");
    Expect(0, 9216, '\p{Is_Blk=-Misc_Technical}', "");
    Expect(1, 9216, '\p{^Is_Blk=-Misc_Technical}', "");
    Expect(1, 9216, '\P{Is_Blk=-Misc_Technical}', "");
    Expect(0, 9216, '\P{^Is_Blk=-Misc_Technical}', "");
    Error('\p{Block: 	 Modi/a/}');
    Error('\P{Block: 	 Modi/a/}');
    Expect(1, 71263, '\p{Block=:\AModi\z:}', "");;
    Expect(0, 71264, '\p{Block=:\AModi\z:}', "");;
    Expect(1, 71263, '\p{Block=modi}', "");
    Expect(0, 71263, '\p{^Block=modi}', "");
    Expect(0, 71263, '\P{Block=modi}', "");
    Expect(1, 71263, '\P{^Block=modi}', "");
    Expect(0, 71264, '\p{Block=modi}', "");
    Expect(1, 71264, '\p{^Block=modi}', "");
    Expect(1, 71264, '\P{Block=modi}', "");
    Expect(0, 71264, '\P{^Block=modi}', "");
    Expect(1, 71263, '\p{Block=:\Amodi\z:}', "");;
    Expect(0, 71264, '\p{Block=:\Amodi\z:}', "");;
    Expect(1, 71263, '\p{Block: Modi}', "");
    Expect(0, 71263, '\p{^Block: Modi}', "");
    Expect(0, 71263, '\P{Block: Modi}', "");
    Expect(1, 71263, '\P{^Block: Modi}', "");
    Expect(0, 71264, '\p{Block: Modi}', "");
    Expect(1, 71264, '\p{^Block: Modi}', "");
    Expect(1, 71264, '\P{Block: Modi}', "");
    Expect(0, 71264, '\P{^Block: Modi}', "");
    Error('\p{Blk=_/a/Modi}');
    Error('\P{Blk=_/a/Modi}');
    Expect(1, 71263, '\p{Blk=:\AModi\z:}', "");;
    Expect(0, 71264, '\p{Blk=:\AModi\z:}', "");;
    Expect(1, 71263, '\p{Blk=modi}', "");
    Expect(0, 71263, '\p{^Blk=modi}', "");
    Expect(0, 71263, '\P{Blk=modi}', "");
    Expect(1, 71263, '\P{^Blk=modi}', "");
    Expect(0, 71264, '\p{Blk=modi}', "");
    Expect(1, 71264, '\p{^Blk=modi}', "");
    Expect(1, 71264, '\P{Blk=modi}', "");
    Expect(0, 71264, '\P{^Blk=modi}', "");
    Expect(1, 71263, '\p{Blk=:\Amodi\z:}', "");;
    Expect(0, 71264, '\p{Blk=:\Amodi\z:}', "");;
    Expect(1, 71263, '\p{Blk=		modi}', "");
    Expect(0, 71263, '\p{^Blk=		modi}', "");
    Expect(0, 71263, '\P{Blk=		modi}', "");
    Expect(1, 71263, '\P{^Blk=		modi}', "");
    Expect(0, 71264, '\p{Blk=		modi}', "");
    Expect(1, 71264, '\p{^Blk=		modi}', "");
    Expect(1, 71264, '\P{Blk=		modi}', "");
    Expect(0, 71264, '\P{^Blk=		modi}', "");
    Error('\p{Is_Block=_:=Modi}');
    Error('\P{Is_Block=_:=Modi}');
    Expect(1, 71263, '\p{Is_Block=modi}', "");
    Expect(0, 71263, '\p{^Is_Block=modi}', "");
    Expect(0, 71263, '\P{Is_Block=modi}', "");
    Expect(1, 71263, '\P{^Is_Block=modi}', "");
    Expect(0, 71264, '\p{Is_Block=modi}', "");
    Expect(1, 71264, '\p{^Is_Block=modi}', "");
    Expect(1, 71264, '\P{Is_Block=modi}', "");
    Expect(0, 71264, '\P{^Is_Block=modi}', "");
    Expect(1, 71263, '\p{Is_Block=-Modi}', "");
    Expect(0, 71263, '\p{^Is_Block=-Modi}', "");
    Expect(0, 71263, '\P{Is_Block=-Modi}', "");
    Expect(1, 71263, '\P{^Is_Block=-Modi}', "");
    Expect(0, 71264, '\p{Is_Block=-Modi}', "");
    Expect(1, 71264, '\p{^Is_Block=-Modi}', "");
    Expect(1, 71264, '\P{Is_Block=-Modi}', "");
    Expect(0, 71264, '\P{^Is_Block=-Modi}', "");
    Error('\p{Is_Blk=		modi/a/}');
    Error('\P{Is_Blk=		modi/a/}');
    Expect(1, 71263, '\p{Is_Blk:modi}', "");
    Expect(0, 71263, '\p{^Is_Blk:modi}', "");
    Expect(0, 71263, '\P{Is_Blk:modi}', "");
    Expect(1, 71263, '\P{^Is_Blk:modi}', "");
    Expect(0, 71264, '\p{Is_Blk:modi}', "");
    Expect(1, 71264, '\p{^Is_Blk:modi}', "");
    Expect(1, 71264, '\P{Is_Blk:modi}', "");
    Expect(0, 71264, '\P{^Is_Blk:modi}', "");
    Expect(1, 71263, '\p{Is_Blk= 	modi}', "");
    Expect(0, 71263, '\p{^Is_Blk= 	modi}', "");
    Expect(0, 71263, '\P{Is_Blk= 	modi}', "");
    Expect(1, 71263, '\P{^Is_Blk= 	modi}', "");
    Expect(0, 71264, '\p{Is_Blk= 	modi}', "");
    Expect(1, 71264, '\p{^Is_Blk= 	modi}', "");
    Expect(1, 71264, '\P{Is_Blk= 	modi}', "");
    Expect(0, 71264, '\P{^Is_Blk= 	modi}', "");
    Error('\p{Block=/a/spacing_modifier_LETTERS}');
    Error('\P{Block=/a/spacing_modifier_LETTERS}');
    Expect(1, 767, '\p{Block=:\ASpacing_Modifier_Letters\z:}', "");;
    Expect(0, 768, '\p{Block=:\ASpacing_Modifier_Letters\z:}', "");;
    Expect(1, 767, '\p{Block=spacingmodifierletters}', "");
    Expect(0, 767, '\p{^Block=spacingmodifierletters}', "");
    Expect(0, 767, '\P{Block=spacingmodifierletters}', "");
    Expect(1, 767, '\P{^Block=spacingmodifierletters}', "");
    Expect(0, 768, '\p{Block=spacingmodifierletters}', "");
    Expect(1, 768, '\p{^Block=spacingmodifierletters}', "");
    Expect(1, 768, '\P{Block=spacingmodifierletters}', "");
    Expect(0, 768, '\P{^Block=spacingmodifierletters}', "");
    Expect(1, 767, '\p{Block=:\Aspacingmodifierletters\z:}', "");;
    Expect(0, 768, '\p{Block=:\Aspacingmodifierletters\z:}', "");;
    Expect(1, 767, '\p{Block=__SPACING_modifier_letters}', "");
    Expect(0, 767, '\p{^Block=__SPACING_modifier_letters}', "");
    Expect(0, 767, '\P{Block=__SPACING_modifier_letters}', "");
    Expect(1, 767, '\P{^Block=__SPACING_modifier_letters}', "");
    Expect(0, 768, '\p{Block=__SPACING_modifier_letters}', "");
    Expect(1, 768, '\p{^Block=__SPACING_modifier_letters}', "");
    Expect(1, 768, '\P{Block=__SPACING_modifier_letters}', "");
    Expect(0, 768, '\P{^Block=__SPACING_modifier_letters}', "");
    Error('\p{Blk=-:=Modifier_LETTERS}');
    Error('\P{Blk=-:=Modifier_LETTERS}');
    Expect(1, 767, '\p{Blk=:\AModifier_Letters\z:}', "");;
    Expect(0, 768, '\p{Blk=:\AModifier_Letters\z:}', "");;
    Expect(1, 767, '\p{Blk=modifierletters}', "");
    Expect(0, 767, '\p{^Blk=modifierletters}', "");
    Expect(0, 767, '\P{Blk=modifierletters}', "");
    Expect(1, 767, '\P{^Blk=modifierletters}', "");
    Expect(0, 768, '\p{Blk=modifierletters}', "");
    Expect(1, 768, '\p{^Blk=modifierletters}', "");
    Expect(1, 768, '\P{Blk=modifierletters}', "");
    Expect(0, 768, '\P{^Blk=modifierletters}', "");
    Expect(1, 767, '\p{Blk=:\Amodifierletters\z:}', "");;
    Expect(0, 768, '\p{Blk=:\Amodifierletters\z:}', "");;
    Expect(1, 767, '\p{Blk=_-Modifier_letters}', "");
    Expect(0, 767, '\p{^Blk=_-Modifier_letters}', "");
    Expect(0, 767, '\P{Blk=_-Modifier_letters}', "");
    Expect(1, 767, '\P{^Blk=_-Modifier_letters}', "");
    Expect(0, 768, '\p{Blk=_-Modifier_letters}', "");
    Expect(1, 768, '\p{^Blk=_-Modifier_letters}', "");
    Expect(1, 768, '\P{Blk=_-Modifier_letters}', "");
    Expect(0, 768, '\P{^Blk=_-Modifier_letters}', "");
    Error('\p{Is_Block=	Spacing_MODIFIER_Letters/a/}');
    Error('\P{Is_Block=	Spacing_MODIFIER_Letters/a/}');
    Expect(1, 767, '\p{Is_Block=spacingmodifierletters}', "");
    Expect(0, 767, '\p{^Is_Block=spacingmodifierletters}', "");
    Expect(0, 767, '\P{Is_Block=spacingmodifierletters}', "");
    Expect(1, 767, '\P{^Is_Block=spacingmodifierletters}', "");
    Expect(0, 768, '\p{Is_Block=spacingmodifierletters}', "");
    Expect(1, 768, '\p{^Is_Block=spacingmodifierletters}', "");
    Expect(1, 768, '\P{Is_Block=spacingmodifierletters}', "");
    Expect(0, 768, '\P{^Is_Block=spacingmodifierletters}', "");
    Expect(1, 767, '\p{Is_Block=-SPACING_modifier_Letters}', "");
    Expect(0, 767, '\p{^Is_Block=-SPACING_modifier_Letters}', "");
    Expect(0, 767, '\P{Is_Block=-SPACING_modifier_Letters}', "");
    Expect(1, 767, '\P{^Is_Block=-SPACING_modifier_Letters}', "");
    Expect(0, 768, '\p{Is_Block=-SPACING_modifier_Letters}', "");
    Expect(1, 768, '\p{^Is_Block=-SPACING_modifier_Letters}', "");
    Expect(1, 768, '\P{Is_Block=-SPACING_modifier_Letters}', "");
    Expect(0, 768, '\P{^Is_Block=-SPACING_modifier_Letters}', "");
    Error('\p{Is_Blk=/a/-MODIFIER_Letters}');
    Error('\P{Is_Blk=/a/-MODIFIER_Letters}');
    Expect(1, 767, '\p{Is_Blk=modifierletters}', "");
    Expect(0, 767, '\p{^Is_Blk=modifierletters}', "");
    Expect(0, 767, '\P{Is_Blk=modifierletters}', "");
    Expect(1, 767, '\P{^Is_Blk=modifierletters}', "");
    Expect(0, 768, '\p{Is_Blk=modifierletters}', "");
    Expect(1, 768, '\p{^Is_Blk=modifierletters}', "");
    Expect(1, 768, '\P{Is_Blk=modifierletters}', "");
    Expect(0, 768, '\P{^Is_Blk=modifierletters}', "");
    Expect(1, 767, '\p{Is_Blk=-Modifier_Letters}', "");
    Expect(0, 767, '\p{^Is_Blk=-Modifier_Letters}', "");
    Expect(0, 767, '\P{Is_Blk=-Modifier_Letters}', "");
    Expect(1, 767, '\P{^Is_Blk=-Modifier_Letters}', "");
    Expect(0, 768, '\p{Is_Blk=-Modifier_Letters}', "");
    Expect(1, 768, '\p{^Is_Blk=-Modifier_Letters}', "");
    Expect(1, 768, '\P{Is_Blk=-Modifier_Letters}', "");
    Expect(0, 768, '\P{^Is_Blk=-Modifier_Letters}', "");
    Error('\p{Block=:=_Modifier_Tone_letters}');
    Error('\P{Block=:=_Modifier_Tone_letters}');
    Expect(1, 42783, '\p{Block=:\AModifier_Tone_Letters\z:}', "");;
    Expect(0, 42784, '\p{Block=:\AModifier_Tone_Letters\z:}', "");;
    Expect(1, 42783, '\p{Block=modifiertoneletters}', "");
    Expect(0, 42783, '\p{^Block=modifiertoneletters}', "");
    Expect(0, 42783, '\P{Block=modifiertoneletters}', "");
    Expect(1, 42783, '\P{^Block=modifiertoneletters}', "");
    Expect(0, 42784, '\p{Block=modifiertoneletters}', "");
    Expect(1, 42784, '\p{^Block=modifiertoneletters}', "");
    Expect(1, 42784, '\P{Block=modifiertoneletters}', "");
    Expect(0, 42784, '\P{^Block=modifiertoneletters}', "");
    Expect(1, 42783, '\p{Block=:\Amodifiertoneletters\z:}', "");;
    Expect(0, 42784, '\p{Block=:\Amodifiertoneletters\z:}', "");;
    Expect(1, 42783, '\p{Block=	 Modifier_tone_Letters}', "");
    Expect(0, 42783, '\p{^Block=	 Modifier_tone_Letters}', "");
    Expect(0, 42783, '\P{Block=	 Modifier_tone_Letters}', "");
    Expect(1, 42783, '\P{^Block=	 Modifier_tone_Letters}', "");
    Expect(0, 42784, '\p{Block=	 Modifier_tone_Letters}', "");
    Expect(1, 42784, '\p{^Block=	 Modifier_tone_Letters}', "");
    Expect(1, 42784, '\P{Block=	 Modifier_tone_Letters}', "");
    Expect(0, 42784, '\P{^Block=	 Modifier_tone_Letters}', "");
    Error('\p{Blk=/a/Modifier_tone_Letters}');
    Error('\P{Blk=/a/Modifier_tone_Letters}');
    Expect(1, 42783, '\p{Blk=:\AModifier_Tone_Letters\z:}', "");;
    Expect(0, 42784, '\p{Blk=:\AModifier_Tone_Letters\z:}', "");;
    Expect(1, 42783, '\p{Blk=modifiertoneletters}', "");
    Expect(0, 42783, '\p{^Blk=modifiertoneletters}', "");
    Expect(0, 42783, '\P{Blk=modifiertoneletters}', "");
    Expect(1, 42783, '\P{^Blk=modifiertoneletters}', "");
    Expect(0, 42784, '\p{Blk=modifiertoneletters}', "");
    Expect(1, 42784, '\p{^Blk=modifiertoneletters}', "");
    Exp