/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.suretrak;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.AlphanumComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.common.MapRow;
import net.sf.mpxj.primavera.common.Table;
import net.sf.mpxj.primavera.suretrak.DatabaseReader;
import net.sf.mpxj.primavera.suretrak.SureTrakWbsFormat;
import net.sf.mpxj.reader.ProjectReader;

public final class SureTrakDatabaseReader
implements ProjectReader {
    private String m_projectName;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<String, Table> m_tables;
    private SureTrakWbsFormat m_wbsFormat;
    private Map<Integer, List<MapRow>> m_definitions;
    private Map<Integer, ProjectCalendar> m_calendarMap;
    private Map<String, Resource> m_resourceMap;
    private Map<String, Task> m_wbsMap;
    private Map<String, Task> m_activityMap;
    private static final Integer WBS_FORMAT_ID = 121;
    private static final Integer WBS_ENTRIES_ID = 122;
    private static final Map<String, FieldType> RESOURCE_FIELDS = new HashMap<String, FieldType>();
    private static final Map<String, FieldType> TASK_FIELDS = new HashMap<String, FieldType>();

    @Deprecated
    public static final ProjectFile setPrefixAndRead(File file) throws MPXJException {
        return SureTrakDatabaseReader.setProjectNameAndRead(file);
    }

    public static final ProjectFile setProjectNameAndRead(File file) throws MPXJException {
        List<String> list = SureTrakDatabaseReader.listProjectNames(file);
        if (!list.isEmpty()) {
            SureTrakDatabaseReader sureTrakDatabaseReader = new SureTrakDatabaseReader();
            sureTrakDatabaseReader.setProjectName(list.get(0));
            return sureTrakDatabaseReader.read(file);
        }
        return null;
    }

    public static final List<String> listProjectNames(String string) {
        return SureTrakDatabaseReader.listProjectNames(new File(string));
    }

    public static final List<String> listProjectNames(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith(".DIR");
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string = file2.getName();
                String string2 = string.substring(0, string.length() - 4);
                arrayList.add(string2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        return this.read(new File(string));
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setPrefix(String string) {
        this.m_projectName = string;
    }

    public void setProjectName(String string) {
        this.m_projectName = string;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        if (!file.isDirectory()) {
            throw new MPXJException("Directory expected");
        }
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoResourceID(true);
            projectConfig.setAutoResourceUniqueID(true);
            projectConfig.setAutoTaskID(true);
            projectConfig.setAutoTaskUniqueID(true);
            projectConfig.setAutoOutlineLevel(true);
            projectConfig.setAutoOutlineNumber(true);
            projectConfig.setAutoWBS(false);
            CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
            customFieldContainer.getCustomField(TaskField.TEXT1).setAlias("Code");
            customFieldContainer.getCustomField(TaskField.TEXT2).setAlias("Department");
            customFieldContainer.getCustomField(TaskField.TEXT3).setAlias("Manager");
            customFieldContainer.getCustomField(TaskField.TEXT4).setAlias("Section");
            customFieldContainer.getCustomField(TaskField.TEXT5).setAlias("Mail");
            this.m_projectFile.getProjectProperties().setFileApplication("SureTrak");
            this.m_projectFile.getProjectProperties().setFileType("STW");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            this.m_tables = new DatabaseReader().process(file, this.m_projectName);
            this.m_definitions = new HashMap<Integer, List<MapRow>>();
            this.m_calendarMap = new HashMap<Integer, ProjectCalendar>();
            this.m_resourceMap = new HashMap<String, Resource>();
            this.m_wbsMap = new HashMap<String, Task>();
            this.m_activityMap = new HashMap<String, Task>();
            this.readProjectHeader();
            this.readDefinitions();
            this.readCalendars();
            this.readHolidays();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            this.readResourceAssignments();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Failed to parse file", iOException);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_projectListeners = null;
            this.m_tables = null;
            this.m_definitions = null;
            this.m_wbsFormat = null;
            this.m_calendarMap = null;
            this.m_resourceMap = null;
            this.m_wbsMap = null;
            this.m_activityMap = null;
        }
    }

    private void readProjectHeader() {
    }

    private void readDefinitions() {
        for (MapRow mapRow : this.m_tables.get("TTL")) {
            Integer n = mapRow.getInteger("DEFINITION_ID");
            List<MapRow> list = this.m_definitions.get(n);
            if (list == null) {
                list = new ArrayList<MapRow>();
                this.m_definitions.put(n, list);
            }
            list.add(mapRow);
        }
        this.m_wbsFormat = new SureTrakWbsFormat(this.m_definitions.get(WBS_FORMAT_ID).get(0));
    }

    /*
     * WARNING - void declaration
     */
    private void readCalendars() {
        Table table = this.m_tables.get("CAL");
        for (MapRow mapRow : table) {
            void object;
            int n;
            ProjectCalendar projectCalendar = this.m_projectFile.addCalendar();
            this.m_calendarMap.put(mapRow.getInteger("CALENDAR_ID"), projectCalendar);
            Integer[] integerArray = new Integer[]{mapRow.getInteger("SUNDAY_HOURS"), mapRow.getInteger("MONDAY_HOURS"), mapRow.getInteger("TUESDAY_HOURS"), mapRow.getInteger("WEDNESDAY_HOURS"), mapRow.getInteger("THURSDAY_HOURS"), mapRow.getInteger("FRIDAY_HOURS"), mapRow.getInteger("SATURDAY_HOURS")};
            projectCalendar.setName(mapRow.getString("NAME"));
            this.readHours(projectCalendar, Day.SUNDAY, integerArray[0]);
            this.readHours(projectCalendar, Day.MONDAY, integerArray[1]);
            this.readHours(projectCalendar, Day.TUESDAY, integerArray[2]);
            this.readHours(projectCalendar, Day.WEDNESDAY, integerArray[3]);
            this.readHours(projectCalendar, Day.THURSDAY, integerArray[4]);
            this.readHours(projectCalendar, Day.FRIDAY, integerArray[5]);
            this.readHours(projectCalendar, Day.SATURDAY, integerArray[6]);
            int n2 = 0;
            Day[] dayArray = Day.values();
            int n3 = dayArray.length;
            for (n = 0; n < n3; ++n) {
                Day day = dayArray[n];
                if (!projectCalendar.isWorkingDay(day)) continue;
                ++n2;
            }
            Object var7_9 = null;
            for (n3 = 0; n3 < 7; ++n3) {
                if (integerArray[n3] == 0) continue;
                Integer n4 = integerArray[n3];
                break;
            }
            if (object == null) continue;
            n3 = this.countHours((Integer)object);
            n = n3 * 60;
            int n5 = n * n2;
            int n6 = 4 * n5;
            int n7 = 52 * n5;
            projectCalendar.setMinutesPerDay(n);
            projectCalendar.setMinutesPerWeek(n5);
            projectCalendar.setMinutesPerMonth(n6);
            projectCalendar.setMinutesPerYear(n7);
        }
    }

    private void readHours(ProjectCalendar projectCalendar, Day day, Integer n) {
        int n2 = n;
        int n3 = 0;
        ProjectCalendarHours projectCalendarHours = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        projectCalendar.setWorkingDay(day, false);
        while (n2 != 0) {
            int n4;
            while (n3 < 24 && (n2 & 1) == 0) {
                n2 >>= 1;
                ++n3;
            }
            if (n3 >= 24) break;
            for (n4 = n3; n4 < 24 && (n2 & 1) != 0; ++n4) {
                n2 >>= 1;
            }
            calendar.set(11, n3);
            Date date = calendar.getTime();
            calendar.set(11, n4);
            Date date2 = calendar.getTime();
            if (projectCalendarHours == null) {
                projectCalendarHours = projectCalendar.addCalendarHours(day);
                projectCalendar.setWorkingDay(day, true);
            }
            projectCalendarHours.addRange(new DateRange(date, date2));
            n3 = n4;
        }
    }

    private int countHours(Integer n) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            while (n4 < 24) {
                if ((n2 & 1) != 0) {
                    ++n3;
                }
                n2 >>= 1;
                ++n4;
            }
        }
        return n3;
    }

    private void readHolidays() {
        for (MapRow mapRow : this.m_tables.get("HOL")) {
            ProjectCalendar projectCalendar = this.m_calendarMap.get(mapRow.getInteger("CALENDAR_ID"));
            if (projectCalendar == null) continue;
            Date date = mapRow.getDate("DATE");
            ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date);
            if (!mapRow.getBoolean("ANNUAL")) continue;
            RecurringData recurringData = new RecurringData();
            recurringData.setRecurrenceType(RecurrenceType.YEARLY);
            recurringData.setYearlyAbsoluteFromDate(date);
            recurringData.setStartDate(date);
            projectCalendarException.setRecurring(recurringData);
        }
    }

    private void readResources() {
        this.m_resourceMap = new HashMap<String, Resource>();
        for (MapRow mapRow : this.m_tables.get("RLB")) {
            Resource resource = this.m_projectFile.addResource();
            this.setFields(RESOURCE_FIELDS, mapRow, resource);
            ProjectCalendar projectCalendar = this.m_calendarMap.get(mapRow.getInteger("CALENDAR_ID"));
            if (projectCalendar != null) {
                ProjectCalendar projectCalendar2 = this.m_calendarMap.get(mapRow.getInteger("BASE_CALENDAR_ID"));
                projectCalendar.setParent(projectCalendar2);
                resource.setResourceCalendar(projectCalendar);
            }
            this.m_resourceMap.put(resource.getCode(), resource);
        }
    }

    private void readTasks() {
        this.readWbs();
        this.readActivities();
        this.updateDates();
    }

    private void readWbs() {
        HashMap<Object, ArrayList<MapRow>> hashMap = new HashMap<Object, ArrayList<MapRow>>();
        List<MapRow> list = this.m_definitions.get(WBS_ENTRIES_ID);
        if (list != null) {
            List list2;
            Object object4;
            Object object2;
            for (MapRow object32 : list) {
                this.m_wbsFormat.parseRawValue(object32.getString("TEXT1"));
                object2 = this.m_wbsFormat.getLevel();
                object4 = (List)hashMap.get(object2);
                if (object4 == null) {
                    object4 = new ArrayList<MapRow>();
                    hashMap.put(object2, (ArrayList<MapRow>)object4);
                }
                object4.add(object32);
            }
            int n = 1;
            while ((list2 = (List)hashMap.get(n++)) != null) {
                String string;
                Object object3;
                for (Object object4 : list2) {
                    this.m_wbsFormat.parseRawValue(((MapRow)object4).getString("TEXT1"));
                    object3 = this.m_wbsFormat.getFormattedParentValue();
                    string = this.m_wbsFormat.getFormattedValue();
                    ((MapRow)object4).setObject("WBS", string);
                    ((MapRow)object4).setObject("PARENT_WBS", object3);
                }
                object2 = new AlphanumComparator();
                Collections.sort(list2, new Comparator<MapRow>((AlphanumComparator)object2){
                    final /* synthetic */ AlphanumComparator val$comparator;
                    {
                        this.val$comparator = alphanumComparator;
                    }

                    @Override
                    public int compare(MapRow mapRow, MapRow mapRow2) {
                        return this.val$comparator.compare(mapRow.getString("WBS"), mapRow2.getString("WBS"));
                    }
                });
                object4 = list2.iterator();
                while (object4.hasNext()) {
                    object3 = (MapRow)object4.next();
                    string = ((MapRow)object3).getString("WBS");
                    ChildTaskContainer childTaskContainer = this.m_wbsMap.get(((MapRow)object3).getString("PARENT_WBS"));
                    if (childTaskContainer == null) {
                        childTaskContainer = this.m_projectFile;
                    }
                    Task task = childTaskContainer.addTask();
                    String string2 = ((MapRow)object3).getString("TEXT2");
                    if (string2 == null || string2.isEmpty()) {
                        string2 = string;
                    }
                    task.setName(string2);
                    task.setWBS(string);
                    this.m_wbsMap.put(string, task);
                }
            }
        }
    }

    private void readActivities() {
        ArrayList<MapRow> arrayList = new ArrayList<MapRow>();
        for (Object object : this.m_tables.get("ACT")) {
            arrayList.add((MapRow)object);
        }
        final AlphanumComparator alphanumComparator = new AlphanumComparator();
        Collections.sort(arrayList, new Comparator<MapRow>(){

            @Override
            public int compare(MapRow mapRow, MapRow mapRow2) {
                return alphanumComparator.compare(mapRow.getString("ACTIVITY_ID"), mapRow2.getString("ACTIVITY_ID"));
            }
        });
        for (MapRow mapRow : arrayList) {
            String string = mapRow.getString("ACTIVITY_ID");
            this.m_wbsFormat.parseRawValue(mapRow.getString("WBS"));
            String string2 = this.m_wbsFormat.getFormattedValue();
            ChildTaskContainer childTaskContainer = this.m_wbsMap.get(string2);
            if (childTaskContainer == null) {
                childTaskContainer = this.m_projectFile;
            }
            Task task = childTaskContainer.addTask();
            this.setFields(TASK_FIELDS, mapRow, task);
            task.setStart(task.getEarlyStart());
            task.setFinish(task.getEarlyFinish());
            task.setMilestone(task.getDuration().getDuration() == 0.0);
            task.setWBS(string2);
            Duration duration = task.getDuration();
            Duration duration2 = task.getRemainingDuration();
            task.setActualDuration(Duration.getInstance(duration.getDuration() - duration2.getDuration(), TimeUnit.HOURS));
            this.m_activityMap.put(string, task);
        }
    }

    private void readRelationships() {
        for (MapRow mapRow : this.m_tables.get("REL")) {
            Task task = this.m_activityMap.get(mapRow.getString("PREDECESSOR_ACTIVITY_ID"));
            Task task2 = this.m_activityMap.get(mapRow.getString("SUCCESSOR_ACTIVITY_ID"));
            if (task == null || task2 == null) continue;
            Duration duration = mapRow.getDuration("LAG");
            RelationType relationType = mapRow.getRelationType("TYPE");
            task2.addPredecessor(task, relationType, duration);
        }
    }

    private void readResourceAssignments() {
        for (MapRow mapRow : this.m_tables.get("RES")) {
            Task task = this.m_activityMap.get(mapRow.getString("ACTIVITY_ID"));
            Resource resource = this.m_resourceMap.get(mapRow.getString("RESOURCE_ID"));
            if (task == null || resource == null) continue;
            task.addResourceAssignment(resource);
        }
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task task) {
        if (task.getSummary()) {
            int n = 0;
            Date date = task.getStart();
            Date date2 = task.getFinish();
            Date date3 = task.getActualStart();
            Date date4 = task.getActualFinish();
            Date date5 = task.getEarlyStart();
            Date date6 = task.getEarlyFinish();
            Date date7 = task.getLateStart();
            Date date8 = task.getLateFinish();
            for (Task task2 : task.getChildTasks()) {
                this.updateDates(task2);
                date = DateHelper.min(date, task2.getStart());
                date2 = DateHelper.max(date2, task2.getFinish());
                date3 = DateHelper.min(date3, task2.getActualStart());
                date4 = DateHelper.max(date4, task2.getActualFinish());
                date5 = DateHelper.min(date5, task2.getEarlyStart());
                date6 = DateHelper.max(date6, task2.getEarlyFinish());
                date7 = DateHelper.min(date7, task2.getLateStart());
                date8 = DateHelper.max(date8, task2.getLateFinish());
                if (task2.getActualFinish() == null) continue;
                ++n;
            }
            task.setStart(date);
            task.setFinish(date2);
            task.setActualStart(date3);
            task.setEarlyStart(date5);
            task.setEarlyFinish(date6);
            task.setLateStart(date7);
            task.setLateFinish(date8);
            if (n == task.getChildTasks().size()) {
                task.setActualFinish(date4);
            }
        }
    }

    private void setFields(Map<String, FieldType> map, MapRow mapRow, FieldContainer fieldContainer) {
        if (mapRow != null) {
            for (Map.Entry<String, FieldType> entry : map.entrySet()) {
                fieldContainer.set(entry.getValue(), mapRow.getObject(entry.getKey()));
            }
        }
    }

    private static void defineField(Map<String, FieldType> map, String string, FieldType fieldType) {
        SureTrakDatabaseReader.defineField(map, string, fieldType, null);
    }

    private static void defineField(Map<String, FieldType> map, String string, FieldType fieldType, String string2) {
        map.put(string, fieldType);
    }

    static {
        SureTrakDatabaseReader.defineField(RESOURCE_FIELDS, "NAME", ResourceField.NAME);
        SureTrakDatabaseReader.defineField(RESOURCE_FIELDS, "CODE", ResourceField.CODE);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "NAME", TaskField.NAME);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ACTIVITY_ID", TaskField.TEXT1);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "DEPARTMENT", TaskField.TEXT2);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "MANAGER", TaskField.TEXT3);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "SECTION", TaskField.TEXT4);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "MAIL", TaskField.TEXT5);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "PERCENT_COMPLETE", TaskField.PERCENT_COMPLETE);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "EARLY_START", TaskField.EARLY_START);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "LATE_START", TaskField.LATE_START);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "EARLY_FINISH", TaskField.EARLY_FINISH);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "LATE_FINISH", TaskField.LATE_FINISH);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ACTUAL_START", TaskField.ACTUAL_START);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ACTUAL_FINISH", TaskField.ACTUAL_FINISH);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ORIGINAL_DURATION", TaskField.DURATION);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "REMAINING_DURATION", TaskField.REMAINING_DURATION);
    }
}

