"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSavedSearchesService = createSavedSearchesService;

var _saved_objects = require("ui/saved_objects");

var _saved_search = require("./_saved_search");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function createSavedSearchesService(services) {
  var SavedSearchClass = (0, _saved_search.createSavedSearchClass)(services);
  var savedSearchLoader = new _saved_objects.SavedObjectLoader(SavedSearchClass, services.savedObjectsClient, services.chrome); // Customize loader properties since adding an 's' on type doesn't work for type 'search' .

  savedSearchLoader.loaderProperties = {
    name: 'searches',
    noun: 'Saved Search',
    nouns: 'saved searches'
  };

  savedSearchLoader.urlFor = function (id) {
    return "#/discover/".concat(encodeURIComponent(id));
  };

  return savedSearchLoader;
}