import getAllAffectedNodes from './utils/all-affected';
import { arrayFind, toArray } from './utils/array';

var focusInFrame = function focusInFrame(frame) {
  return frame === document.activeElement;
};

var focusInsideIframe = function focusInsideIframe(topNode) {
  return getAllAffectedNodes(topNode).reduce(function (result, node) {
    return result || !!arrayFind(toArray(node.querySelectorAll('iframe')), focusInFrame);
  }, false);
};

var focusInside = function focusInside(topNode) {
  var activeElement = document && document.activeElement;

  if (!activeElement || activeElement.dataset && activeElement.dataset.focusGuard) {
    return false;
  }
  return getAllAffectedNodes(topNode).reduce(function (result, node) {
    return result || node.contains(activeElement) || focusInsideIframe(topNode);
  }, false);
};

export default focusInside;