"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var compute_series_domains_1 = require("./compute_series_domains");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var axis_utils_1 = require("../../utils/axis_utils");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_specs_1 = require("./get_specs");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_bar_paddings_1 = require("./get_bar_paddings");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
exports.computeAxisTicksDimensionsSelector = re_reselect_1.default([
    get_bar_paddings_1.getBarPaddingsSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    get_specs_1.getAxisSpecsSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
], function (barsPadding, isHistogramMode, axesSpecs, chartTheme, settingsSpec, seriesDomainsAndData, totalBarsInCluster) {
    var xDomain = seriesDomainsAndData.xDomain, yDomain = seriesDomainsAndData.yDomain;
    var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var axesTicksDimensions = new Map();
    axesSpecs.forEach(function (axisSpec) {
        var id = axisSpec.id;
        var dimensions = axis_utils_1.computeAxisTicksDimensions(axisSpec, xDomain, yDomain, totalBarsInCluster, bboxCalculator, settingsSpec.rotation, chartTheme.axes, barsPadding, isHistogramMode);
        if (dimensions &&
            (!settingsSpec.hideDuplicateAxes || !axis_utils_1.isDuplicateAxis(axisSpec, dimensions, axesTicksDimensions, axesSpecs))) {
            axesTicksDimensions.set(id, dimensions);
        }
    });
    bboxCalculator.destroy();
    return axesTicksDimensions;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_axis_ticks_dimensions.js.map