"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var is_tooltip_visible_1 = require("../../state/selectors/is_tooltip_visible");
var get_tooltip_header_formatter_1 = require("../../state/selectors/get_tooltip_header_formatter");
var get_tooltip_position_1 = require("../../state/selectors/get_tooltip_position");
var get_tooltip_values_highlighted_geoms_1 = require("../../state/selectors/get_tooltip_values_highlighted_geoms");
var is_initialized_1 = require("../../../../state/selectors/is_initialized");
var react_dom_1 = require("react-dom");
var crosshair_utils_1 = require("../../crosshair/crosshair_utils");
var is_annotation_tooltip_visible_1 = require("../../state/selectors/is_annotation_tooltip_visible");
var TooltipsComponent = /** @class */ (function (_super) {
    __extends(TooltipsComponent, _super);
    function TooltipsComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.portalNode = null;
        _this.tooltipRef = react_1.default.createRef();
        return _this;
    }
    TooltipsComponent.prototype.createPortalNode = function () {
        var container = document.getElementById('echTooltipContainerPortal');
        if (container) {
            this.portalNode = container;
        }
        else {
            this.portalNode = document.createElement('div');
            this.portalNode.id = 'echTooltipContainerPortal';
            document.body.appendChild(this.portalNode);
        }
    };
    TooltipsComponent.prototype.componentDidMount = function () {
        this.createPortalNode();
    };
    TooltipsComponent.prototype.componentDidUpdate = function () {
        this.createPortalNode();
        var _a = this.props, getChartContainerRef = _a.getChartContainerRef, tooltipPosition = _a.tooltipPosition;
        var chartContainerRef = getChartContainerRef();
        if (!this.tooltipRef.current || !chartContainerRef.current || !this.portalNode || !tooltipPosition) {
            return;
        }
        var chartContainerBBox = chartContainerRef.current.getBoundingClientRect();
        var tooltipBBox = this.tooltipRef.current.getBoundingClientRect();
        var tooltipStyle = crosshair_utils_1.getFinalTooltipPosition(chartContainerBBox, tooltipBBox, tooltipPosition);
        if (tooltipStyle.left) {
            this.portalNode.style.left = tooltipStyle.left;
        }
        if (tooltipStyle.top) {
            this.portalNode.style.top = tooltipStyle.top;
        }
    };
    TooltipsComponent.prototype.componentWillUnmount = function () {
        if (this.portalNode && this.portalNode.parentNode) {
            this.portalNode.parentNode.removeChild(this.portalNode);
        }
    };
    TooltipsComponent.prototype.renderHeader = function (headerData, formatter) {
        if (!headerData) {
            return null;
        }
        return formatter ? formatter(headerData) : headerData.value;
    };
    TooltipsComponent.prototype.render = function () {
        var _a = this.props, isTooltipVisible = _a.isTooltipVisible, tooltipValues = _a.tooltipValues, tooltipHeaderFormatter = _a.tooltipHeaderFormatter, isAnnotationTooltipVisible = _a.isAnnotationTooltipVisible;
        if (!this.portalNode) {
            return null;
        }
        var getChartContainerRef = this.props.getChartContainerRef;
        var chartContainerRef = getChartContainerRef();
        var tooltip;
        if (chartContainerRef.current === null || !isTooltipVisible || isAnnotationTooltipVisible) {
            return null;
        }
        else {
            tooltip = (react_1.default.createElement("div", { className: "echTooltip", ref: this.tooltipRef },
                react_1.default.createElement("div", { className: "echTooltip__header" }, this.renderHeader(tooltipValues[0], tooltipHeaderFormatter)),
                react_1.default.createElement("div", { className: "echTooltip__list" }, tooltipValues.slice(1).map(function (_a) {
                    var name = _a.name, value = _a.value, color = _a.color, isHighlighted = _a.isHighlighted, seriesKey = _a.seriesKey, yAccessor = _a.yAccessor, isVisible = _a.isVisible;
                    if (!isVisible) {
                        return null;
                    }
                    var classes = classnames_1.default('echTooltip__item', {
                        /* eslint @typescript-eslint/camelcase:0 */
                        echTooltip__rowHighlighted: isHighlighted,
                    });
                    return (react_1.default.createElement("div", { key: seriesKey + "--" + yAccessor, className: classes, style: {
                            borderLeftColor: color,
                        } },
                        react_1.default.createElement("span", { className: "echTooltip__label" }, name),
                        react_1.default.createElement("span", { className: "echTooltip__value" }, value)));
                }))));
        }
        return react_dom_1.createPortal(tooltip, this.portalNode);
    };
    TooltipsComponent.displayName = 'Tooltips';
    return TooltipsComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (!is_initialized_1.isInitialized(state)) {
        return {
            isTooltipVisible: false,
            isAnnotationTooltipVisible: false,
            tooltipValues: [],
            tooltipPosition: null,
            tooltipHeaderFormatter: undefined,
        };
    }
    return {
        isTooltipVisible: is_tooltip_visible_1.isTooltipVisibleSelector(state),
        isAnnotationTooltipVisible: is_annotation_tooltip_visible_1.isAnnotationTooltipVisibleSelector(state),
        tooltipValues: get_tooltip_values_highlighted_geoms_1.getTooltipValuesSelector(state),
        tooltipPosition: get_tooltip_position_1.getTooltipPositionSelector(state),
        tooltipHeaderFormatter: get_tooltip_header_formatter_1.getTooltipHeaderFormatterSelector(state),
    };
};
exports.Tooltips = react_redux_1.connect(mapStateToProps)(TooltipsComponent);
//# sourceMappingURL=tooltips.js.map