/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.UIManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MultiSplitLayout
implements LayoutManager {
    private final Map<String, Component> childMap = new HashMap<String, Component>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Node model;
    private int dividerSize;
    private boolean floatingDividers = true;

    public MultiSplitLayout() {
        this(new Leaf("default"));
    }

    public MultiSplitLayout(Node model) {
        this.model = model;
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (this.dividerSize == 0) {
            this.dividerSize = 7;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void firePCS(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Node getModel() {
        return this.model;
    }

    public void setModel(Node model) {
        if (model == null || model instanceof Divider) {
            throw new IllegalArgumentException("invalid model");
        }
        Node oldModel = model;
        this.model = model;
        this.firePCS("model", oldModel, model);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize < 0) {
            throw new IllegalArgumentException("invalid dividerSize");
        }
        int oldDividerSize = this.dividerSize;
        this.dividerSize = dividerSize;
        this.firePCS("dividerSize", oldDividerSize, dividerSize);
    }

    public boolean getFloatingDividers() {
        return this.floatingDividers;
    }

    public void setFloatingDividers(boolean floatingDividers) {
        boolean oldFloatingDividers = this.floatingDividers;
        this.floatingDividers = floatingDividers;
        this.firePCS("floatingDividers", oldFloatingDividers, floatingDividers);
    }

    @Override
    public void addLayoutComponent(String name, Component child) {
        if (name == null) {
            throw new IllegalArgumentException("name not specified");
        }
        this.childMap.put(name, child);
    }

    @Override
    public void removeLayoutComponent(Component child) {
        String name = child.getName();
        if (name != null) {
            this.childMap.remove(name);
        } else {
            this.childMap.values().removeIf(child::equals);
        }
    }

    private Component childForNode(Node node) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String name = leaf.getName();
            return name != null ? this.childMap.get(name) : null;
        }
        return null;
    }

    private Dimension preferredComponentSize(Node node) {
        Component child = this.childForNode(node);
        return child != null ? child.getPreferredSize() : new Dimension(0, 0);
    }

    private Dimension preferredNodeSize(Node root) {
        if (root instanceof Leaf) {
            return this.preferredComponentSize(root);
        }
        if (root instanceof Divider) {
            int dividerSize = this.getDividerSize();
            return new Dimension(dividerSize, dividerSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                Dimension size = this.preferredNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                Dimension size = this.preferredNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    private Dimension minimumNodeSize(Node root) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            return child != null ? child.getMinimumSize() : new Dimension(0, 0);
        }
        if (root instanceof Divider) {
            int dividerSize = this.getDividerSize();
            return new Dimension(dividerSize, dividerSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                Dimension size = this.minimumNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                Dimension size = this.minimumNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    private static Dimension sizeWithInsets(Container parent, Dimension size) {
        Insets insets = parent.getInsets();
        int width = size.width + insets.left + insets.right;
        int height = size.height + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = this.preferredNodeSize(this.getModel());
        return MultiSplitLayout.sizeWithInsets(parent, size);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension size = this.minimumNodeSize(this.getModel());
        return MultiSplitLayout.sizeWithInsets(parent, size);
    }

    private static Rectangle boundsWithYandHeight(Rectangle bounds, double y, double height) {
        Rectangle r = new Rectangle();
        r.setBounds((int)bounds.getX(), (int)y, (int)bounds.getWidth(), (int)height);
        return r;
    }

    private static Rectangle boundsWithXandWidth(Rectangle bounds, double x, double width) {
        Rectangle r = new Rectangle();
        r.setBounds((int)x, (int)bounds.getY(), (int)width, (int)bounds.getHeight());
        return r;
    }

    private static void minimizeSplitBounds(Split split, Rectangle bounds) {
        Rectangle splitBounds = new Rectangle(bounds.x, bounds.y, 0, 0);
        List<Node> splitChildren = split.getChildren();
        Node lastChild = splitChildren.get(splitChildren.size() - 1);
        Rectangle lastChildBounds = lastChild.getBounds();
        if (split.isRowLayout()) {
            int lastChildMaxX = lastChildBounds.x + lastChildBounds.width;
            splitBounds.add(lastChildMaxX, bounds.y + bounds.height);
        } else {
            int lastChildMaxY = lastChildBounds.y + lastChildBounds.height;
            splitBounds.add(bounds.x + bounds.width, lastChildMaxY);
        }
        split.setBounds(splitBounds);
    }

    private void layoutShrink(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator<Node> splitChildren = split.getChildren().listIterator();
        if (split.isRowLayout()) {
            boolean onlyShrinkWeightedComponents;
            double extraWidth;
            int totalWidth = 0;
            int minWeightedWidth = 0;
            int totalWeightedWidth = 0;
            for (Node splitChild : split.getChildren()) {
                int nodeWidth = splitChild.getBounds().width;
                int nodeMinWidth = Math.min(nodeWidth, this.minimumNodeSize((Node)splitChild).width);
                totalWidth += nodeWidth;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedWidth += nodeMinWidth;
                totalWeightedWidth += nodeWidth;
            }
            double x = bounds.getX();
            double availableWidth = extraWidth = splitBounds.getWidth() - bounds.getWidth();
            boolean bl = onlyShrinkWeightedComponents = (double)(totalWeightedWidth - minWeightedWidth) > extraWidth;
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                double splitChildWeight;
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildWidth = this.minimumNodeSize(splitChild).getWidth();
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getWidth() / (double)totalWidth;
                if (!splitChildren.hasNext()) {
                    double newWidth = Math.max(minSplitChildWidth, bounds.getMaxX() - x);
                    newSplitChildBounds = MultiSplitLayout.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = Math.rint(splitChildWeight * extraWidth);
                    double oldWidth = splitChildBounds.getWidth();
                    double newWidth = Math.max(minSplitChildWidth, oldWidth - allocatedWidth);
                    Rectangle newSplitChildBounds2 = MultiSplitLayout.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= oldWidth - splitChild.getBounds().getWidth();
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = MultiSplitLayout.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            boolean onlyShrinkWeightedComponents;
            double extraHeight;
            int totalHeight = 0;
            int minWeightedHeight = 0;
            int totalWeightedHeight = 0;
            for (Node splitChild : split.getChildren()) {
                int nodeHeight = splitChild.getBounds().height;
                int nodeMinHeight = Math.min(nodeHeight, this.minimumNodeSize((Node)splitChild).height);
                totalHeight += nodeHeight;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedHeight += nodeMinHeight;
                totalWeightedHeight += nodeHeight;
            }
            double y = bounds.getY();
            double availableHeight = extraHeight = splitBounds.getHeight() - bounds.getHeight();
            boolean bl = onlyShrinkWeightedComponents = (double)(totalWeightedHeight - minWeightedHeight) > extraHeight;
            while (splitChildren.hasNext()) {
                double splitChildWeight;
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildHeight = this.minimumNodeSize(splitChild).getHeight();
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getHeight() / (double)totalHeight;
                if (!splitChildren.hasNext()) {
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = Math.max(minSplitChildHeight, bounds.getMaxY() - y);
                    Rectangle newSplitChildBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = Math.rint(splitChildWeight * extraHeight);
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = Math.max(minSplitChildHeight, oldHeight - allocatedHeight);
                    Rectangle newSplitChildBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
        MultiSplitLayout.minimizeSplitBounds(split, bounds);
    }

    private void layoutGrow(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator<Node> splitChildren = split.getChildren().listIterator();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double extraWidth;
            double x = bounds.getX();
            double availableWidth = extraWidth = bounds.getWidth() - splitBounds.getWidth();
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newWidth = bounds.getMaxX() - x;
                    newSplitChildBounds = MultiSplitLayout.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = splitChild.equals(lastWeightedChild) ? availableWidth : Math.rint(splitChildWeight * extraWidth);
                    double newWidth = splitChildBounds.getWidth() + allocatedWidth;
                    Rectangle newSplitChildBounds2 = MultiSplitLayout.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= allocatedWidth;
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = MultiSplitLayout.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            double extraHeight;
            double y = bounds.getY();
            double availableHeight = extraHeight = bounds.getMaxY() - splitBounds.getHeight();
            while (splitChildren.hasNext()) {
                Node splitChild = splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newHeight = bounds.getMaxY() - y;
                    Rectangle newSplitChildBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = splitChild.equals(lastWeightedChild) ? availableHeight : Math.rint(splitChildWeight * extraHeight);
                    double newHeight = splitChildBounds.getHeight() + allocatedHeight;
                    Rectangle newSplitChildBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= allocatedHeight;
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
    }

    private void layout2(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            if (child != null) {
                child.setBounds(bounds);
            }
            root.setBounds(bounds);
        } else if (root instanceof Divider) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            boolean grow;
            Split split = (Split)root;
            boolean bl = split.isRowLayout() ? split.getBounds().width <= bounds.width : (grow = split.getBounds().height <= bounds.height);
            if (grow) {
                this.layoutGrow(split, bounds);
                root.setBounds(bounds);
            } else {
                this.layoutShrink(split, bounds);
            }
        }
    }

    private void layout1(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            Split split = (Split)root;
            Iterator<Node> splitChildren = split.getChildren().iterator();
            int dividerSize = this.getDividerSize();
            if (split.isRowLayout()) {
                double x = bounds.getX();
                while (splitChildren.hasNext()) {
                    Node next;
                    Node splitChild = splitChildren.next();
                    Node dividerChild = null;
                    if (splitChildren.hasNext() && (next = splitChildren.next()) instanceof Divider) {
                        dividerChild = (Divider)next;
                    }
                    double childWidth = this.getFloatingDividers() ? this.preferredNodeSize(splitChild).getWidth() : (dividerChild != null ? dividerChild.getBounds().getX() - x : split.getBounds().getMaxX() - x);
                    Rectangle childBounds = MultiSplitLayout.boundsWithXandWidth(bounds, x, childWidth);
                    this.layout1(splitChild, childBounds);
                    if (this.getFloatingDividers() && dividerChild != null) {
                        double dividerX = childBounds.getMaxX();
                        Rectangle dividerBounds = MultiSplitLayout.boundsWithXandWidth(bounds, dividerX, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null) continue;
                    x = dividerChild.getBounds().getMaxX();
                }
            } else {
                double y = bounds.getY();
                while (splitChildren.hasNext()) {
                    Divider dividerChild;
                    Node splitChild = splitChildren.next();
                    Node nodeChild = splitChildren.hasNext() ? splitChildren.next() : null;
                    Divider divider = dividerChild = nodeChild instanceof Divider ? (Divider)nodeChild : null;
                    double childHeight = this.getFloatingDividers() ? this.preferredNodeSize(splitChild).getHeight() : (dividerChild != null ? dividerChild.getBounds().getY() - y : split.getBounds().getMaxY() - y);
                    Rectangle childBounds = MultiSplitLayout.boundsWithYandHeight(bounds, y, childHeight);
                    this.layout1(splitChild, childBounds);
                    if (this.getFloatingDividers() && dividerChild != null) {
                        double dividerY = childBounds.getMaxY();
                        Rectangle dividerBounds = MultiSplitLayout.boundsWithYandHeight(bounds, dividerY, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null) continue;
                    y = dividerChild.getBounds().getMaxY();
                }
            }
            MultiSplitLayout.minimizeSplitBounds(split, bounds);
        }
    }

    private static void throwInvalidLayout(String msg, Node node) {
        throw new InvalidLayoutException(msg, node);
    }

    private static void checkLayout(Node root) {
        if (root instanceof Split) {
            Split split = (Split)root;
            if (split.getChildren().size() <= 2) {
                MultiSplitLayout.throwInvalidLayout("Split must have > 2 children", root);
            }
            Iterator<Node> splitChildren = split.getChildren().iterator();
            double weight = 0.0;
            while (splitChildren.hasNext()) {
                Node dividerChild;
                Node splitChild = splitChildren.next();
                if (splitChild instanceof Divider) {
                    MultiSplitLayout.throwInvalidLayout("expected a Split or Leaf Node", splitChild);
                }
                if (splitChildren.hasNext() && !((dividerChild = splitChildren.next()) instanceof Divider)) {
                    MultiSplitLayout.throwInvalidLayout("expected a Divider Node", dividerChild);
                }
                weight += splitChild.getWeight();
                MultiSplitLayout.checkLayout(splitChild);
            }
            if (weight > 1.000000001) {
                MultiSplitLayout.throwInvalidLayout("Split children's total weight > 1.0", root);
            }
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        MultiSplitLayout.checkLayout(this.getModel());
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        Rectangle bounds = new Rectangle(insets.left, insets.top, width, height);
        this.layout1(this.getModel(), bounds);
        this.layout2(this.getModel(), bounds);
    }

    private static Divider dividerAt(Node root, int x, int y) {
        if (root instanceof Divider) {
            Divider divider = (Divider)root;
            return divider.getBounds().contains(x, y) ? divider : null;
        }
        if (root instanceof Split) {
            Split split = (Split)root;
            for (Node child : split.getChildren()) {
                if (!child.getBounds().contains(x, y)) continue;
                return MultiSplitLayout.dividerAt(child, x, y);
            }
        }
        return null;
    }

    public Divider dividerAt(int x, int y) {
        return MultiSplitLayout.dividerAt(this.getModel(), x, y);
    }

    private static boolean nodeOverlapsRectangle(Node node, Rectangle r2) {
        Rectangle r1 = node.getBounds();
        return r1.x <= r2.x + r2.width && r1.x + r1.width >= r2.x && r1.y <= r2.y + r2.height && r1.y + r1.height >= r2.y;
    }

    private static List<Divider> dividersThatOverlap(Node root, Rectangle r) {
        if (MultiSplitLayout.nodeOverlapsRectangle(root, r) && root instanceof Split) {
            ArrayList<Divider> dividers = new ArrayList<Divider>();
            for (Node child : ((Split)root).getChildren()) {
                if (child instanceof Divider) {
                    if (!MultiSplitLayout.nodeOverlapsRectangle(child, r)) continue;
                    dividers.add((Divider)child);
                    continue;
                }
                if (!(child instanceof Split)) continue;
                dividers.addAll(MultiSplitLayout.dividersThatOverlap(child, r));
            }
            return dividers;
        }
        return Collections.emptyList();
    }

    public List<Divider> dividersThatOverlap(Rectangle r) {
        CheckParameterUtil.ensureParameterNotNull(r, "r");
        return MultiSplitLayout.dividersThatOverlap(this.getModel(), r);
    }

    public static class Divider
    extends Node {
        public final boolean isVertical() {
            Split parent = this.getParent();
            return parent != null && parent.isRowLayout();
        }

        @Override
        public void setWeight(double weight) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "MultiSplitLayout.Divider " + this.getBounds();
        }
    }

    public static class Leaf
    extends Node {
        private String name = "";

        public Leaf() {
        }

        public Leaf(String name) {
            CheckParameterUtil.ensureParameterNotNull(name, "name");
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            CheckParameterUtil.ensureParameterNotNull(name, "name");
            this.name = name;
        }

        public String toString() {
            return "MultiSplitLayout.Leaf \"" + this.getName() + "\" weight=" + this.getWeight() + ' ' + this.getBounds();
        }
    }

    public static class Split
    extends Node {
        private List<Node> children = Collections.emptyList();
        private boolean rowLayout = true;

        public boolean isRowLayout() {
            return this.rowLayout;
        }

        public void setRowLayout(boolean rowLayout) {
            this.rowLayout = rowLayout;
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.children);
        }

        public void setChildren(List<Node> children) {
            if (children == null) {
                throw new IllegalArgumentException("children must be a non-null List");
            }
            for (Node child : this.children) {
                child.setParent(null);
            }
            this.children = new ArrayList<Node>(children);
            for (Node child : this.children) {
                child.setParent(this);
            }
        }

        public final Node lastWeightedChild() {
            List<Node> children = this.getChildren();
            Node weightedChild = null;
            for (Node child : children) {
                if (!(child.getWeight() > 0.0)) continue;
                weightedChild = child;
            }
            return weightedChild;
        }

        public String toString() {
            int nChildren = this.getChildren().size();
            StringBuilder sb = new StringBuilder("MultiSplitLayout.Split");
            sb.append(this.isRowLayout() ? " ROW [" : " COLUMN [").append(nChildren + (nChildren == 1 ? " child" : " children")).append("] ").append(this.getBounds());
            return sb.toString();
        }
    }

    public static class Node {
        private Split parent;
        private Rectangle bounds = new Rectangle();
        private double weight;

        protected Node() {
        }

        public Split getParent() {
            return this.parent;
        }

        public void setParent(Split parent) {
            this.parent = parent;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle bounds) {
            CheckParameterUtil.ensureParameterNotNull(bounds, "bounds");
            this.bounds = new Rectangle(bounds);
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            if (weight < 0.0 || weight > 1.0) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = weight;
        }

        private Node siblingAtOffset(int offset) {
            Split parent = this.getParent();
            if (parent == null) {
                return null;
            }
            List<Node> siblings = parent.getChildren();
            int index = siblings.indexOf(this);
            if (index == -1) {
                return null;
            }
            return (index += offset) > -1 && index < siblings.size() ? siblings.get(index) : null;
        }

        public Node nextSibling() {
            return this.siblingAtOffset(1);
        }

        public Node previousSibling() {
            return this.siblingAtOffset(-1);
        }
    }

    public static class InvalidLayoutException
    extends RuntimeException {
        private final transient Node node;

        public InvalidLayoutException(String msg, Node node) {
            super(msg);
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

