/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.tools.I18n;

public class PresetPrefHelper
extends SourcePrefHelper {
    public static final PresetPrefHelper INSTANCE = new PresetPrefHelper();

    public PresetPrefHelper() {
        super("taggingpreset.entries", SourceType.TAGGING_PRESET);
    }

    @Override
    public Collection<ExtendedSourceEntry> getDefault() {
        ExtendedSourceEntry i = new ExtendedSourceEntry(this.type, "defaultpresets.xml", "resource://data/defaultpresets.xml");
        i.title = I18n.tr("Internal Preset", new Object[0]);
        i.description = I18n.tr("The default preset for JOSM", new Object[0]);
        return Collections.singletonList(i);
    }

    @Override
    public Map<String, String> serialize(SourceEntry entry) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("url", entry.url);
        res.put("title", entry.title == null ? "" : entry.title);
        return res;
    }

    @Override
    public SourceEntry deserialize(Map<String, String> s) {
        return new SourceEntry(this.type, s.get("url"), null, s.get("title"), true);
    }
}

