/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DownloadOsmChangeTask
extends DownloadOsmTask {
    private static final String OSM_WEBSITE_PATTERN = "https?://www\\.(osm|openstreetmap)\\.org/changeset/(\\p{Digit}+).*";

    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/api/0.6/changeset/\\p{Digit}+/download", OSM_WEBSITE_PATTERN, "https?://.*/.*\\.osc"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Change", new Object[0]);
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        Matcher matcher = Pattern.compile(OSM_WEBSITE_PATTERN).matcher(url);
        if (matcher.matches()) {
            url = OsmApi.getOsmApi().getBaseUrl() + "changeset/" + Long.parseLong(matcher.group(2)) + "/download";
        }
        this.downloadTask = new DownloadTask(settings, (OsmServerReader)new OsmServerLocationReader(url), progressMonitor);
        this.extractOsmFilename(settings, "https?://.*/(.*\\.osc)", url);
        return MainApplication.worker.submit(this.downloadTask);
    }

    private static final class HistoryLoaderAndListener
    extends HistoryLoadTask
    implements HistoryDataSetListener {
        private final Map<OsmPrimitive, Date> toLoad;

        private HistoryLoaderAndListener(Map<OsmPrimitive, Date> toLoad) {
            this.toLoad = toLoad;
            this.setChangesetDataNeeded(false);
            this.add(toLoad.keySet());
            HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        }

        @Override
        public void historyUpdated(HistoryDataSet source, PrimitiveId id) {
            HashMap<OsmPrimitive, Date> toLoadNext = new HashMap<OsmPrimitive, Date>();
            Iterator<Map.Entry<OsmPrimitive, Date>> it = this.toLoad.entrySet().iterator();
            while (it.hasNext()) {
                PrimitiveData data;
                HistoryOsmPrimitive hp;
                Map.Entry<OsmPrimitive, Date> entry = it.next();
                OsmPrimitive p = entry.getKey();
                History history = source.getHistory(p.getPrimitiveId());
                Date date = entry.getValue();
                if (history == null || date == null || (hp = history.getByDate(date)) == null) continue;
                switch (p.getType()) {
                    case NODE: {
                        data = ((HistoryNode)hp).fillPrimitiveData(new NodeData());
                        break;
                    }
                    case WAY: {
                        data = ((HistoryWay)hp).fillPrimitiveData(new WayData());
                        for (Long nodeId : ((HistoryWay)hp).getNodes()) {
                            if (p.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE) != null) continue;
                            Node n = new Node(nodeId);
                            p.getDataSet().addPrimitive(n);
                            toLoadNext.put(n, date);
                        }
                        break;
                    }
                    case RELATION: {
                        data = ((HistoryRelation)hp).fillPrimitiveData(new RelationData());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown primitive type");
                    }
                }
                try {
                    p.load(data);
                    it.remove();
                }
                catch (AssertionError e) {
                    Logging.log(Logging.LEVEL_ERROR, "Cannot load " + p + ':', (Throwable)((Object)e));
                }
            }
            source.removeHistoryDataSetListener(this);
            if (toLoadNext.isEmpty()) {
                MainApplication.getMap().repaint();
            } else {
                MainApplication.worker.submit(new HistoryLoaderAndListener(toLoadNext));
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet source) {
        }
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(settings, reader, progressMonitor);
        }

        @Override
        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                HashMap<OsmPrimitive, Date> toLoad = new HashMap<OsmPrimitive, Date>();
                for (OsmPrimitive p : ((DataSet)DownloadOsmChangeTask.this.downloadedData).allNonDeletedPrimitives()) {
                    if (!p.isIncomplete()) continue;
                    Date timestamp = null;
                    for (OsmPrimitive ref : p.getReferrers()) {
                        if (ref.isTimestampEmpty()) continue;
                        timestamp = ref.getTimestamp();
                        break;
                    }
                    toLoad.put(p, timestamp);
                }
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                MainApplication.worker.submit(new HistoryLoaderAndListener(toLoad));
            }
            catch (RejectedExecutionException e) {
                DownloadOsmChangeTask.this.rememberException(e);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }
}

