export class ProfileFlameChartDataProvider{constructor(){this._colorGenerator=ProfileFlameChartDataProvider.colorGenerator();}
static colorGenerator(){if(!ProfileFlameChartDataProvider._colorGenerator){const colorGenerator=new Common.Color.Generator({min:30,max:330},{min:50,max:80,count:5},{min:80,max:90,count:3});colorGenerator.setColorForID('(idle)','hsl(0, 0%, 94%)');colorGenerator.setColorForID('(program)','hsl(0, 0%, 80%)');colorGenerator.setColorForID('(garbage collector)','hsl(0, 0%, 80%)');ProfileFlameChartDataProvider._colorGenerator=colorGenerator;}
return ProfileFlameChartDataProvider._colorGenerator;}
minimumBoundary(){return this._cpuProfile.profileStartTime;}
totalTime(){return this._cpuProfile.profileHead.total;}
formatValue(value,precision){return Number.preciseMillisToString(value,precision);}
maxStackDepth(){return this._maxStackDepth;}
timelineData(){return this._timelineData||this._calculateTimelineData();}
_calculateTimelineData(){throw'Not implemented.';}
prepareHighlightedEntryInfo(entryIndex){throw'Not implemented.';}
canJumpToEntry(entryIndex){return this._entryNodes[entryIndex].scriptId!=='0';}
entryTitle(entryIndex){const node=this._entryNodes[entryIndex];return UI.beautifyFunctionName(node.functionName);}
entryFont(entryIndex){if(!this._font){this._font='11px '+Host.fontFamily();this._boldFont='bold '+this._font;}
const node=this._entryNodes[entryIndex];return node.deoptReason?this._boldFont:this._font;}
entryColor(entryIndex){const node=this._entryNodes[entryIndex];return this._colorGenerator.colorForID(node.url||(node.scriptId!=='0'?node.scriptId:node.functionName));}
decorateEntry(entryIndex,context,text,barX,barY,barWidth,barHeight){return false;}
forceDecoration(entryIndex){return false;}
textColor(entryIndex){return'#333';}}
export class CPUProfileFlameChart extends UI.VBox{constructor(searchableView,dataProvider){super();this.element.id='cpu-flame-chart';this._searchableView=searchableView;this._overviewPane=new OverviewPane(dataProvider);this._overviewPane.show(this.element);this._mainPane=new PerfUI.FlameChart(dataProvider,this._overviewPane);this._mainPane.setBarHeight(15);this._mainPane.setTextBaseline(4);this._mainPane.setTextPadding(2);this._mainPane.show(this.element);this._mainPane.addEventListener(PerfUI.FlameChart.Events.EntrySelected,this._onEntrySelected,this);this._mainPane.addEventListener(PerfUI.FlameChart.Events.EntryInvoked,this._onEntryInvoked,this);this._entrySelected=false;this._mainPane.addEventListener(PerfUI.FlameChart.Events.CanvasFocused,this._onEntrySelected,this);this._overviewPane.addEventListener(PerfUI.OverviewGrid.Events.WindowChanged,this._onWindowChanged,this);this._dataProvider=dataProvider;this._searchResults=[];}
focus(){this._mainPane.focus();}
_onWindowChanged(event){const windowLeft=event.data.windowTimeLeft;const windowRight=event.data.windowTimeRight;this._mainPane.setWindowTimes(windowLeft,windowRight,true);}
selectRange(timeLeft,timeRight){this._overviewPane._selectRange(timeLeft,timeRight);}
_onEntrySelected(event){if(event.data){const eventIndex=Number(event.data);this._mainPane.setSelectedEntry(eventIndex);if(eventIndex===-1){this._entrySelected=false;}else{this._entrySelected=true;}}else if(!this._entrySelected){this._mainPane.setSelectedEntry(0);this._entrySelected=true;}}
_onEntryInvoked(event){this._onEntrySelected(event);this.dispatchEventToListeners(PerfUI.FlameChart.Events.EntryInvoked,event.data);}
update(){this._overviewPane.update();this._mainPane.update();}
performSearch(searchConfig,shouldJump,jumpBackwards){const matcher=createPlainTextSearchRegex(searchConfig.query,searchConfig.caseSensitive?'':'i');const selectedEntryIndex=this._searchResultIndex!==-1?this._searchResults[this._searchResultIndex]:-1;this._searchResults=[];const entriesCount=this._dataProvider._entryNodes.length;for(let index=0;index<entriesCount;++index){if(this._dataProvider.entryTitle(index).match(matcher)){this._searchResults.push(index);}}
if(this._searchResults.length){this._searchResultIndex=this._searchResults.indexOf(selectedEntryIndex);if(this._searchResultIndex===-1){this._searchResultIndex=jumpBackwards?this._searchResults.length-1:0;}
this._mainPane.setSelectedEntry(this._searchResults[this._searchResultIndex]);}else{this.searchCanceled();}
this._searchableView.updateSearchMatchesCount(this._searchResults.length);this._searchableView.updateCurrentMatchIndex(this._searchResultIndex);}
searchCanceled(){this._mainPane.setSelectedEntry(-1);this._searchResults=[];this._searchResultIndex=-1;}
jumpToNextSearchResult(){this._searchResultIndex=(this._searchResultIndex+1)%this._searchResults.length;this._mainPane.setSelectedEntry(this._searchResults[this._searchResultIndex]);this._searchableView.updateCurrentMatchIndex(this._searchResultIndex);}
jumpToPreviousSearchResult(){this._searchResultIndex=(this._searchResultIndex-1+this._searchResults.length)%this._searchResults.length;this._mainPane.setSelectedEntry(this._searchResults[this._searchResultIndex]);this._searchableView.updateCurrentMatchIndex(this._searchResultIndex);}
supportsCaseSensitiveSearch(){return true;}
supportsRegexSearch(){return false;}}
export class OverviewCalculator{constructor(dataProvider){this._dataProvider=dataProvider;}
_updateBoundaries(overviewPane){this._minimumBoundaries=overviewPane._dataProvider.minimumBoundary();const totalTime=overviewPane._dataProvider.totalTime();this._maximumBoundaries=this._minimumBoundaries+totalTime;this._xScaleFactor=overviewPane._overviewContainer.clientWidth/totalTime;}
computePosition(time){return(time-this._minimumBoundaries)*this._xScaleFactor;}
formatValue(value,precision){return this._dataProvider.formatValue(value-this._minimumBoundaries,precision);}
maximumBoundary(){return this._maximumBoundaries;}
minimumBoundary(){return this._minimumBoundaries;}
zeroTime(){return this._minimumBoundaries;}
boundarySpan(){return this._maximumBoundaries-this._minimumBoundaries;}}
export class OverviewPane extends UI.VBox{constructor(dataProvider){super();this.element.classList.add('cpu-profile-flame-chart-overview-pane');this._overviewContainer=this.element.createChild('div','cpu-profile-flame-chart-overview-container');this._overviewCalculator=new OverviewCalculator(dataProvider);this._overviewGrid=new PerfUI.OverviewGrid('cpu-profile-flame-chart',this._overviewCalculator);this._overviewGrid.element.classList.add('fill');this._overviewCanvas=this._overviewContainer.createChild('canvas','cpu-profile-flame-chart-overview-canvas');this._overviewContainer.appendChild(this._overviewGrid.element);this._dataProvider=dataProvider;this._overviewGrid.addEventListener(PerfUI.OverviewGrid.Events.WindowChanged,this._onWindowChanged,this);}
windowChanged(windowStartTime,windowEndTime){this._selectRange(windowStartTime,windowEndTime);}
updateRangeSelection(startTime,endTime){}
updateSelectedGroup(flameChart,group){}
_selectRange(timeLeft,timeRight){const startTime=this._dataProvider.minimumBoundary();const totalTime=this._dataProvider.totalTime();this._overviewGrid.setWindow((timeLeft-startTime)/totalTime,(timeRight-startTime)/totalTime);}
_onWindowChanged(event){const windowPosition={windowTimeLeft:event.data.rawStartValue,windowTimeRight:event.data.rawEndValue};this._windowTimeLeft=windowPosition.windowTimeLeft;this._windowTimeRight=windowPosition.windowTimeRight;this.dispatchEventToListeners(PerfUI.OverviewGrid.Events.WindowChanged,windowPosition);}
_timelineData(){return this._dataProvider.timelineData();}
onResize(){this._scheduleUpdate();}
_scheduleUpdate(){if(this._updateTimerId){return;}
this._updateTimerId=this.element.window().requestAnimationFrame(this.update.bind(this));}
update(){this._updateTimerId=0;const timelineData=this._timelineData();if(!timelineData){return;}
this._resetCanvas(this._overviewContainer.clientWidth,this._overviewContainer.clientHeight-PerfUI.FlameChart.HeaderHeight);this._overviewCalculator._updateBoundaries(this);this._overviewGrid.updateDividers(this._overviewCalculator);this._drawOverviewCanvas();}
_drawOverviewCanvas(){const canvasWidth=this._overviewCanvas.width;const canvasHeight=this._overviewCanvas.height;const drawData=this._calculateDrawData(canvasWidth);const context=this._overviewCanvas.getContext('2d');const ratio=window.devicePixelRatio;const offsetFromBottom=ratio;const lineWidth=1;const yScaleFactor=canvasHeight/(this._dataProvider.maxStackDepth()*1.1);context.lineWidth=lineWidth;context.translate(0.5,0.5);context.strokeStyle='rgba(20,0,0,0.4)';context.fillStyle='rgba(214,225,254,0.8)';context.moveTo(-lineWidth,canvasHeight+lineWidth);context.lineTo(-lineWidth,Math.round(canvasHeight-drawData[0]*yScaleFactor-offsetFromBottom));let value;for(let x=0;x<canvasWidth;++x){value=Math.round(canvasHeight-drawData[x]*yScaleFactor-offsetFromBottom);context.lineTo(x,value);}
context.lineTo(canvasWidth+lineWidth,value);context.lineTo(canvasWidth+lineWidth,canvasHeight+lineWidth);context.fill();context.stroke();context.closePath();}
_calculateDrawData(width){const dataProvider=this._dataProvider;const timelineData=this._timelineData();const entryStartTimes=timelineData.entryStartTimes;const entryTotalTimes=timelineData.entryTotalTimes;const entryLevels=timelineData.entryLevels;const length=entryStartTimes.length;const minimumBoundary=this._dataProvider.minimumBoundary();const drawData=new Uint8Array(width);const scaleFactor=width/dataProvider.totalTime();for(let entryIndex=0;entryIndex<length;++entryIndex){const start=Math.floor((entryStartTimes[entryIndex]-minimumBoundary)*scaleFactor);const finish=Math.floor((entryStartTimes[entryIndex]-minimumBoundary+entryTotalTimes[entryIndex])*scaleFactor);for(let x=start;x<=finish;++x){drawData[x]=Math.max(drawData[x],entryLevels[entryIndex]+1);}}
return drawData;}
_resetCanvas(width,height){const ratio=window.devicePixelRatio;this._overviewCanvas.width=width*ratio;this._overviewCanvas.height=height*ratio;this._overviewCanvas.style.width=width+'px';this._overviewCanvas.style.height=height+'px';}}