export class NodeStackTraceWidget extends UI.ThrottledWidget{constructor(){super(true);this.registerRequiredCSS('elements/nodeStackTraceWidget.css');this._noStackTraceElement=this.contentElement.createChild('div','gray-info-message');this._noStackTraceElement.textContent=ls`No stack trace available`;this._creationStackTraceElement=this.contentElement.createChild('div','stack-trace');this._linkifier=new Components.Linkifier(MaxLengthForLinks);}
wasShown(){self.UI.context.addFlavorChangeListener(SDK.DOMNode,this.update,this);this.update();}
willHide(){self.UI.context.removeFlavorChangeListener(SDK.DOMNode,this.update,this);}
async doUpdate(){const node=self.UI.context.flavor(SDK.DOMNode);if(!node){this._noStackTraceElement.classList.remove('hidden');this._creationStackTraceElement.classList.add('hidden');return;}
const creationStackTrace=await node.creationStackTrace();if(creationStackTrace){this._noStackTraceElement.classList.add('hidden');this._creationStackTraceElement.classList.remove('hidden');const stackTracePreview=Components.JSPresentationUtils.buildStackTracePreviewContents(node.domModel().target(),this._linkifier,{stackTrace:creationStackTrace});this._creationStackTraceElement.removeChildren();this._creationStackTraceElement.appendChild(stackTracePreview.element);}else{this._noStackTraceElement.classList.remove('hidden');this._creationStackTraceElement.classList.add('hidden');}}}
export const MaxLengthForLinks=40;