/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import twitter4j.Category;
import twitter4j.ResponseList;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CategoryJSONImpl
implements Category,
Serializable {
    private String name;
    private String slug;
    private int size;
    private static final long serialVersionUID = -6703617743623288566L;

    CategoryJSONImpl(JSONObject json) throws JSONException {
        this.init(json);
    }

    void init(JSONObject json) throws JSONException {
        this.name = json.getString("name");
        this.slug = json.getString("slug");
        this.size = z_T4JInternalParseUtil.getInt("size", json);
    }

    static ResponseList<Category> createCategoriesList(HttpResponse res, Configuration conf) throws TwitterException {
        return CategoryJSONImpl.createCategoriesList(res.asJSONArray(), res, conf);
    }

    static ResponseList<Category> createCategoriesList(JSONArray array, HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            ResponseListImpl<Category> categories = new ResponseListImpl<Category>(array.length(), res);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject json = array.getJSONObject(i);
                CategoryJSONImpl category = new CategoryJSONImpl(json);
                categories.add(category);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(category, json);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(categories, array);
            }
            return categories;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryJSONImpl that = (CategoryJSONImpl)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.slug != null ? !this.slug.equals(that.slug) : that.slug != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.slug != null ? this.slug.hashCode() : 0);
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        return new StringBuffer().append("CategoryJSONImpl{name='").append(this.name).append('\'').append(", slug='").append(this.slug).append('\'').append(", size=").append(this.size).append('}').toString();
    }
}

