/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.LocalizedMessages;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;

public class XRefChecker {
    private static final Pattern REGEX_SVG_VIEW = Pattern.compile("svgView\\(.*\\)");
    private final Map<String, Resource> resources = new HashMap<String, Resource>();
    private final HashSet<String> undeclared = new HashSet();
    private final List<Reference> references = new LinkedList<Reference>();
    private final Map<String, String> bindings = new HashMap<String, String>();
    private final Report report;
    private final OCFPackage ocf;
    private final EPUBVersion version;
    private final Locale locale;

    public XRefChecker(OCFPackage ocf, Report report, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.version = version;
        this.locale = report instanceof LocalizableReport ? ((LocalizableReport)report).getLocale() : Locale.ENGLISH;
    }

    public String getMimeType(String path) {
        return this.resources.get(path) != null ? this.resources.get((Object)path).item.getMimeType() : null;
    }

    public Optional<Boolean> hasValidFallback(String path) {
        return this.resources.get(path) != null ? Optional.of(this.resources.get((Object)path).hasValidItemFallback) : Optional.absent();
    }

    public Optional<OPFItem> getResource(String path) {
        return path == null || !this.resources.containsKey(path) ? Optional.absent() : Optional.of(this.resources.get((Object)path).item);
    }

    public Set<Type> getTypes(String path) {
        LinkedList<Type> types = new LinkedList<Type>();
        for (Reference reference : this.references) {
            if (!Preconditions.checkNotNull(path).equals(reference.refResource)) continue;
            types.add(reference.type);
        }
        return Sets.immutableEnumSet(types);
    }

    public Set<String> getBindingsMimeTypes() {
        return this.bindings.keySet();
    }

    public String getBindingHandlerId(String mimeType) {
        return this.bindings.get(mimeType);
    }

    public void registerBinding(String mimeType, String handlerId) {
        this.bindings.put(mimeType, handlerId);
    }

    public void registerResource(OPFItem item, boolean hasValidItemFallback, boolean hasValidImageFallback) {
        if (!this.resources.containsKey(item.getPath())) {
            this.resources.put(item.getPath(), new Resource(item, hasValidItemFallback, hasValidImageFallback));
        }
    }

    public void registerAnchor(String path, int lineNumber, int columnNumber, String id, Type type) {
        Resource res = Preconditions.checkNotNull(this.resources.get(path));
        if (!res.anchors.contains(id)) {
            res.anchors.put(id, new Anchor(id, res.anchors.size() + 1, type));
        }
    }

    public void registerReference(String srcResource, int srcLineNumber, int srcColumnNumber, String ref, Type type) {
        if (ref.startsWith("data:")) {
            return;
        }
        int query = ref.indexOf(63);
        if (query >= 0 && !PathUtil.isRemote(ref)) {
            ref = ref.substring(0, query).trim();
        }
        String refResource = PathUtil.removeFragment(ref);
        String refFragment = PathUtil.getFragment(ref);
        this.report.info(srcResource, FeatureEnum.RESOURCE, refResource);
        this.references.add(new Reference(srcResource, srcLineNumber, srcColumnNumber, ref, refResource, refFragment, type));
    }

    public void checkReferences() {
        LinkedList<Reference> tocLinks = new LinkedList<Reference>();
        LinkedList<Reference> pageListLinks = new LinkedList<Reference>();
        block5: for (Reference reference : this.references) {
            switch (reference.type) {
                case REGION_BASED_NAV: {
                    this.checkRegionBasedNav(reference);
                    continue block5;
                }
                case NAV_TOC_LINK: {
                    tocLinks.add(reference);
                    continue block5;
                }
                case NAV_PAGELIST_LINK: {
                    pageListLinks.add(reference);
                    continue block5;
                }
            }
            this.checkReference(reference);
        }
        this.checkReadingOrder(tocLinks, -1, -1);
        this.checkReadingOrder(pageListLinks, -1, -1);
    }

    private void checkReference(Reference ref) {
        Resource res = this.resources.get(ref.refResource);
        Resource host = this.resources.get(ref.source);
        if (!(!PathUtil.isRemote(ref.refResource) || EnumSet.of(Type.LINK, Type.HYPERLINK).contains((Object)ref.type) || this.version == EPUBVersion.VERSION_3 && res != null && res.item.isInSpine() || this.version == EPUBVersion.VERSION_3 && EnumSet.of(Type.AUDIO, Type.VIDEO, Type.FONT).contains((Object)ref.type))) {
            this.report.message(MessageId.RSC_006, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
            return;
        }
        if (res == null) {
            if (!this.ocf.hasEntry(ref.refResource) && !PathUtil.isRemote(ref.refResource)) {
                if (this.version == EPUBVersion.VERSION_3 && ref.type == Type.LINK) {
                    this.report.message(MessageId.RSC_007w, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource), ref.refResource);
                } else {
                    this.report.message(MessageId.RSC_007, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource), ref.refResource);
                }
            } else if (!(this.undeclared.contains(ref.refResource) || ref.type == Type.LINK || PathUtil.isRemote(ref.refResource) && ref.type == Type.HYPERLINK)) {
                this.undeclared.add(ref.refResource);
                this.report.message(MessageId.RSC_008, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource), ref.refResource);
            }
            return;
        }
        switch (ref.type) {
            case HYPERLINK: {
                if (!(OPFChecker.isBlessedItemType(res.item.getMimeType(), this.version) || OPFChecker.isDeprecatedBlessedItemType(res.item.getMimeType()) || res.hasValidItemFallback)) {
                    this.report.message(MessageId.RSC_010, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + (ref.fragment != null ? '#' + ref.fragment : "")), new Object[0]);
                    return;
                }
                if (res.item.isInSpine()) break;
                this.report.message(MessageId.RSC_011, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + (ref.fragment != null ? '#' + ref.fragment : "")), new Object[0]);
                return;
            }
            case IMAGE: 
            case PICTURE_SOURCE: 
            case PICTURE_SOURCE_FOREIGN: {
                if (ref.fragment != null && !res.item.getMimeType().equals("image/svg+xml")) {
                    this.report.message(MessageId.RSC_009, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                    return;
                }
                if (OPFChecker.isBlessedImageType(res.item.getMimeType())) break;
                if (this.version == EPUBVersion.VERSION_3 && ref.type == Type.PICTURE_SOURCE) {
                    this.report.message(MessageId.MED_007, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), ref.refResource, res.item.getMimeType());
                    return;
                }
                if (ref.type != Type.IMAGE || res.hasValidImageFallback) break;
                this.report.message(MessageId.MED_003, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), ref.refResource, res.item.getMimeType());
                break;
            }
            case SEARCH_KEY: {
                if (ref.fragment != null && ref.fragment.startsWith("epubcfi(") || res.item.isInSpine()) break;
                this.report.message(MessageId.RSC_021, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), ref.refResource);
                return;
            }
            case STYLESHEET: {
                if (ref.fragment == null) break;
                this.report.message(MessageId.RSC_013, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                return;
            }
            case SVG_CLIP_PATH: 
            case SVG_PAINT: 
            case SVG_SYMBOL: {
                if (ref.fragment != null) break;
                this.report.message(MessageId.RSC_015, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource), new Object[0]);
                return;
            }
        }
        if (ref.fragment != null) {
            if (ref.fragment.startsWith("epubcfi(")) {
                return;
            }
            if (ref.fragment.contains("=") && host != null && host.item.getProperties().contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV))) {
                return;
            }
            if (res.item.getMimeType().equals("image/svg+xml") && REGEX_SVG_VIEW.matcher(ref.fragment).matches()) {
                return;
            }
            if (!PathUtil.isRemote(ref.refResource)) {
                Anchor anchor = res.anchors.get(ref.fragment);
                if (anchor == null) {
                    this.report.message(MessageId.RSC_012, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                    return;
                }
                switch (ref.type) {
                    case SVG_CLIP_PATH: 
                    case SVG_PAINT: {
                        if (anchor.type == ref.type) break;
                        this.report.message(MessageId.RSC_014, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                        return;
                    }
                    case HYPERLINK: 
                    case SVG_SYMBOL: {
                        if (anchor.type == ref.type || anchor.type == Type.GENERIC) break;
                        this.report.message(MessageId.RSC_014, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber, ref.refResource + "#" + ref.fragment), new Object[0]);
                        return;
                    }
                }
            }
        }
    }

    private void checkRegionBasedNav(Reference ref) {
        Preconditions.checkArgument(ref.type == Type.REGION_BASED_NAV);
        Resource res = this.resources.get(ref.refResource);
        if (!res.item.isFixedLayout()) {
            this.report.message(MessageId.NAV_009, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), new Object[0]);
        }
    }

    private void checkReadingOrder(Queue<Reference> references, int lastSpinePosition, int lastAnchorPosition) {
        Reference ref = references.poll();
        if (ref == null) {
            return;
        }
        Preconditions.checkArgument(ref.type == Type.NAV_PAGELIST_LINK || ref.type == Type.NAV_TOC_LINK);
        Resource res = this.resources.get(ref.refResource);
        if (res == null || !res.item.isInSpine()) {
            return;
        }
        int targetSpinePosition = res.item.getSpinePosition();
        if (targetSpinePosition < lastSpinePosition) {
            String orderContext = LocalizedMessages.getInstance(this.locale).getSuggestion(MessageId.NAV_011, "spine");
            this.report.message(MessageId.NAV_011, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), ref.type == Type.NAV_TOC_LINK ? "toc" : "page-list", ref.value, orderContext);
            this.report.message(MessageId.INF_001, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), "https://github.com/w3c/publ-epub-revision/issues/1283");
            lastSpinePosition = targetSpinePosition;
            lastAnchorPosition = -1;
        } else {
            int targetAnchorPosition;
            if (targetSpinePosition > lastSpinePosition) {
                lastSpinePosition = targetSpinePosition;
                lastAnchorPosition = -1;
            }
            if ((targetAnchorPosition = res.getAnchorPosition(ref.fragment)) < lastAnchorPosition) {
                String orderContext = LocalizedMessages.getInstance(this.locale).getSuggestion(MessageId.NAV_011, "document");
                this.report.message(MessageId.NAV_011, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), ref.type == Type.NAV_TOC_LINK ? "toc" : "page-list", ref.value, orderContext);
                this.report.message(MessageId.INF_001, EPUBLocation.create(ref.source, ref.lineNumber, ref.columnNumber), "https://github.com/w3c/publ-epub-revision/issues/1283");
            }
            lastAnchorPosition = targetAnchorPosition;
        }
        this.checkReadingOrder(references, lastSpinePosition, lastAnchorPosition);
    }

    private static class Resource {
        public final OPFItem item;
        public final Hashtable<String, Anchor> anchors;
        public final boolean hasValidItemFallback;
        public final boolean hasValidImageFallback;

        Resource(OPFItem item, boolean hasValidItemFallback, boolean hasValidImageFallback) {
            this.item = item;
            this.hasValidItemFallback = hasValidItemFallback;
            this.hasValidImageFallback = hasValidImageFallback;
            this.anchors = new Hashtable();
        }

        public int getAnchorPosition(String id) {
            if (id == null || id.trim().isEmpty()) {
                return 0;
            }
            Anchor anchor = this.anchors.get(id);
            return anchor != null ? anchor.position : -1;
        }
    }

    private static class Anchor {
        public final String id;
        public final Type type;
        public final int position;

        public Anchor(String id, int position, Type type) {
            this.id = id;
            this.position = position;
            this.type = type;
        }
    }

    private static class Reference {
        public final String source;
        public final int lineNumber;
        public final int columnNumber;
        public final String value;
        public final String refResource;
        public final String fragment;
        public final Type type;

        public Reference(String srcResource, int srcLineNumber, int srcColumnNumber, String value, String refResource, String fragment, Type type) {
            this.source = srcResource;
            this.lineNumber = srcLineNumber;
            this.columnNumber = srcColumnNumber;
            this.value = value;
            this.refResource = refResource;
            this.fragment = fragment;
            this.type = type;
        }
    }

    public static enum Type {
        GENERIC,
        FONT,
        HYPERLINK,
        LINK,
        IMAGE,
        OBJECT,
        STYLESHEET,
        AUDIO,
        VIDEO,
        SVG_PAINT,
        SVG_CLIP_PATH,
        SVG_SYMBOL,
        REGION_BASED_NAV,
        SEARCH_KEY,
        NAV_TOC_LINK,
        NAV_PAGELIST_LINK,
        PICTURE_SOURCE,
        PICTURE_SOURCE_FOREIGN;

    }
}

