/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SSubEachIterable
extends AStatement {
    private AExpression expression;
    private final SBlock block;
    private final Locals.Variable variable;
    private PainlessCast cast = null;
    private Locals.Variable iterator = null;
    private PainlessMethod method = null;

    SSubEachIterable(Location location, Locals.Variable variable, AExpression expression, SBlock block) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.expression = Objects.requireNonNull(expression);
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.iterator = locals.addVariable(this.location, Iterator.class, "#itr" + this.location.getOffset(), true);
        if (this.expression.actual == def.class) {
            this.method = null;
        } else {
            this.method = scriptRoot.getPainlessLookup().lookupPainlessMethod(this.expression.actual, false, "iterator", 0);
            if (this.method == null) {
                throw this.createError(new IllegalArgumentException("method [" + PainlessLookupUtility.typeToCanonicalTypeName(this.expression.actual) + ", iterator/0] not found"));
            }
        }
        this.cast = AnalyzerCaster.getLegalCast(this.location, def.class, this.variable.clazz, true, true);
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        this.expression.write(classWriter, methodWriter, globals);
        if (this.method == null) {
            Type methodType = Type.getMethodType((Type)Type.getType(Iterator.class), (Type[])new Type[]{Type.getType(Object.class)});
            methodWriter.invokeDefCall("iterator", methodType, 5, new Object[0]);
        } else {
            methodWriter.invokeMethodCall(this.method);
        }
        methodWriter.visitVarInsn(MethodWriter.getType(this.iterator.clazz).getOpcode(54), this.iterator.getSlot());
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        methodWriter.visitVarInsn(MethodWriter.getType(this.iterator.clazz).getOpcode(21), this.iterator.getSlot());
        methodWriter.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_HASNEXT);
        methodWriter.ifZCmp(153, end);
        methodWriter.visitVarInsn(MethodWriter.getType(this.iterator.clazz).getOpcode(21), this.iterator.getSlot());
        methodWriter.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_NEXT);
        methodWriter.writeCast(this.cast);
        methodWriter.visitVarInsn(MethodWriter.getType(this.variable.clazz).getOpcode(54), this.variable.getSlot());
        if (this.loopCounter != null) {
            methodWriter.writeLoopCounter(this.loopCounter.getSlot(), this.statementCount, this.location);
        }
        this.block.continu = begin;
        this.block.brake = end;
        this.block.write(classWriter, methodWriter, globals);
        methodWriter.goTo(begin);
        methodWriter.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(PainlessLookupUtility.typeToCanonicalTypeName(this.variable.clazz), this.variable.name, this.expression, this.block);
    }
}

