/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class EComp
extends AExpression {
    private final Operation operation;
    private AExpression left;
    private AExpression right;
    private Class<?> promotedType;

    public EComp(Location location, Operation operation, AExpression left, AExpression right) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (this.operation == Operation.EQ) {
            this.analyzeEq(scriptRoot, locals);
        } else if (this.operation == Operation.EQR) {
            this.analyzeEqR(scriptRoot, locals);
        } else if (this.operation == Operation.NE) {
            this.analyzeNE(scriptRoot, locals);
        } else if (this.operation == Operation.NER) {
            this.analyzeNER(scriptRoot, locals);
        } else if (this.operation == Operation.GTE) {
            this.analyzeGTE(scriptRoot, locals);
        } else if (this.operation == Operation.GT) {
            this.analyzeGT(scriptRoot, locals);
        } else if (this.operation == Operation.LTE) {
            this.analyzeLTE(scriptRoot, locals);
        } else if (this.operation == Operation.LT) {
            this.analyzeLT(scriptRoot, locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    private void analyzeEq(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply equals [==] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (this.promotedType == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            if (this.promotedType == Boolean.TYPE) {
                this.constant = ((Boolean)this.left.constant).booleanValue() == ((Boolean)this.right.constant).booleanValue();
            } else if (this.promotedType == Integer.TYPE) {
                this.constant = ((Integer)this.left.constant).intValue() == ((Integer)this.right.constant).intValue();
            } else if (this.promotedType == Long.TYPE) {
                this.constant = ((Long)this.left.constant).longValue() == ((Long)this.right.constant).longValue();
            } else if (this.promotedType == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() == ((Float)this.right.constant).floatValue();
            } else if (this.promotedType == Double.TYPE) {
                this.constant = ((Double)this.left.constant).doubleValue() == ((Double)this.right.constant).doubleValue();
            } else if (!this.left.isNull) {
                this.constant = this.left.constant.equals(this.right.constant);
            } else if (!this.right.isNull) {
                this.constant = this.right.constant.equals(null);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeEqR(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply reference equals [===] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.left.expected = this.promotedType;
        this.right.expected = this.promotedType;
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            this.constant = this.promotedType == Boolean.TYPE ? Boolean.valueOf(((Boolean)this.left.constant).booleanValue() == ((Boolean)this.right.constant).booleanValue()) : (this.promotedType == Integer.TYPE ? Boolean.valueOf(((Integer)this.left.constant).intValue() == ((Integer)this.right.constant).intValue()) : (this.promotedType == Long.TYPE ? Boolean.valueOf(((Long)this.left.constant).longValue() == ((Long)this.right.constant).longValue()) : (this.promotedType == Float.TYPE ? Boolean.valueOf(((Float)this.left.constant).floatValue() == ((Float)this.right.constant).floatValue()) : (this.promotedType == Double.TYPE ? Boolean.valueOf(((Double)this.left.constant).doubleValue() == ((Double)this.right.constant).doubleValue()) : Boolean.valueOf(this.left.constant == this.right.constant)))));
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeNE(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply not equals [!=] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (this.promotedType == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            if (this.promotedType == Boolean.TYPE) {
                this.constant = ((Boolean)this.left.constant).booleanValue() != ((Boolean)this.right.constant).booleanValue();
            } else if (this.promotedType == Integer.TYPE) {
                this.constant = ((Integer)this.left.constant).intValue() != ((Integer)this.right.constant).intValue();
            } else if (this.promotedType == Long.TYPE) {
                this.constant = ((Long)this.left.constant).longValue() != ((Long)this.right.constant).longValue();
            } else if (this.promotedType == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() != ((Float)this.right.constant).floatValue();
            } else if (this.promotedType == Double.TYPE) {
                this.constant = ((Double)this.left.constant).doubleValue() != ((Double)this.right.constant).doubleValue();
            } else if (!this.left.isNull) {
                this.constant = !this.left.constant.equals(this.right.constant);
            } else if (!this.right.isNull) {
                this.constant = !this.right.constant.equals(null);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeNER(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply reference not equals [!==] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.left.expected = this.promotedType;
        this.right.expected = this.promotedType;
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            this.constant = this.promotedType == Boolean.TYPE ? Boolean.valueOf(((Boolean)this.left.constant).booleanValue() != ((Boolean)this.right.constant).booleanValue()) : (this.promotedType == Integer.TYPE ? Boolean.valueOf(((Integer)this.left.constant).intValue() != ((Integer)this.right.constant).intValue()) : (this.promotedType == Long.TYPE ? Boolean.valueOf(((Long)this.left.constant).longValue() != ((Long)this.right.constant).longValue()) : (this.promotedType == Float.TYPE ? Boolean.valueOf(((Float)this.left.constant).floatValue() != ((Float)this.right.constant).floatValue()) : (this.promotedType == Double.TYPE ? Boolean.valueOf(((Double)this.left.constant).doubleValue() != ((Double)this.right.constant).doubleValue()) : Boolean.valueOf(this.left.constant != this.right.constant)))));
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeGTE(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply greater than or equals [>=] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (this.promotedType == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promotedType == Integer.TYPE) {
                this.constant = (Integer)this.left.constant >= (Integer)this.right.constant;
            } else if (this.promotedType == Long.TYPE) {
                this.constant = (Long)this.left.constant >= (Long)this.right.constant;
            } else if (this.promotedType == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() >= ((Float)this.right.constant).floatValue();
            } else if (this.promotedType == Double.TYPE) {
                this.constant = (Double)this.left.constant >= (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeGT(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply greater than [>] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (this.promotedType == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promotedType == Integer.TYPE) {
                this.constant = (Integer)this.left.constant > (Integer)this.right.constant;
            } else if (this.promotedType == Long.TYPE) {
                this.constant = (Long)this.left.constant > (Long)this.right.constant;
            } else if (this.promotedType == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() > ((Float)this.right.constant).floatValue();
            } else if (this.promotedType == Double.TYPE) {
                this.constant = (Double)this.left.constant > (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeLTE(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply less than or equals [<=] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (this.promotedType == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promotedType == Integer.TYPE) {
                this.constant = (Integer)this.left.constant <= (Integer)this.right.constant;
            } else if (this.promotedType == Long.TYPE) {
                this.constant = (Long)this.left.constant <= (Long)this.right.constant;
            } else if (this.promotedType == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() <= ((Float)this.right.constant).floatValue();
            } else if (this.promotedType == Double.TYPE) {
                this.constant = (Double)this.left.constant <= (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    private void analyzeLT(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply less than [>=] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (this.promotedType == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promotedType == Integer.TYPE) {
                this.constant = (Integer)this.left.constant < (Integer)this.right.constant;
            } else if (this.promotedType == Long.TYPE) {
                this.constant = (Long)this.left.constant < (Long)this.right.constant;
            } else if (this.promotedType == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() < ((Float)this.right.constant).floatValue();
            } else if (this.promotedType == Double.TYPE) {
                this.constant = (Double)this.left.constant < (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        boolean writejump;
        Label end;
        Label jump;
        block31: {
            Type type;
            boolean ne;
            boolean eq;
            block37: {
                Type descriptor;
                boolean gte;
                boolean gt;
                boolean lte;
                boolean lt;
                block39: {
                    block38: {
                        block33: {
                            block36: {
                                block35: {
                                    block34: {
                                        block32: {
                                            methodWriter.writeDebugInfo(this.location);
                                            this.left.write(classWriter, methodWriter, globals);
                                            if (!this.right.isNull) {
                                                this.right.write(classWriter, methodWriter, globals);
                                            }
                                            jump = new Label();
                                            end = new Label();
                                            eq = this.operation == Operation.EQ || this.operation == Operation.EQR;
                                            ne = this.operation == Operation.NE || this.operation == Operation.NER;
                                            lt = this.operation == Operation.LT;
                                            lte = this.operation == Operation.LTE;
                                            gt = this.operation == Operation.GT;
                                            gte = this.operation == Operation.GTE;
                                            writejump = true;
                                            type = MethodWriter.getType(this.promotedType);
                                            if (this.promotedType == Void.TYPE) throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            if (this.promotedType == Byte.TYPE) throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            if (this.promotedType == Short.TYPE) throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            if (this.promotedType == Character.TYPE) {
                                                throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            }
                                            if (this.promotedType != Boolean.TYPE) break block32;
                                            if (eq) {
                                                methodWriter.ifCmp(type, 153, jump);
                                                break block31;
                                            } else {
                                                if (!ne) {
                                                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                                                }
                                                methodWriter.ifCmp(type, 154, jump);
                                            }
                                            break block31;
                                        }
                                        if (this.promotedType != Integer.TYPE && this.promotedType != Long.TYPE && this.promotedType != Float.TYPE && this.promotedType != Double.TYPE) break block33;
                                        if (!eq) break block34;
                                        methodWriter.ifCmp(type, 153, jump);
                                        break block31;
                                    }
                                    if (!ne) break block35;
                                    methodWriter.ifCmp(type, 154, jump);
                                    break block31;
                                }
                                if (!lt) break block36;
                                methodWriter.ifCmp(type, 155, jump);
                                break block31;
                            }
                            if (lte) {
                                methodWriter.ifCmp(type, 158, jump);
                                break block31;
                            } else if (gt) {
                                methodWriter.ifCmp(type, 157, jump);
                                break block31;
                            } else {
                                if (!gte) {
                                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                                }
                                methodWriter.ifCmp(type, 156, jump);
                            }
                            break block31;
                        }
                        if (this.promotedType != def.class) break block37;
                        Type booleanType = Type.getType(Boolean.TYPE);
                        descriptor = Type.getMethodType((Type)booleanType, (Type[])new Type[]{MethodWriter.getType(this.left.actual), MethodWriter.getType(this.right.actual)});
                        if (!eq) break block38;
                        if (this.right.isNull) {
                            methodWriter.ifNull(jump);
                            break block31;
                        } else {
                            if (!this.left.isNull && this.operation == Operation.EQ) {
                                methodWriter.invokeDefCall("eq", descriptor, 8, 1);
                                return;
                            }
                            methodWriter.ifCmp(type, 153, jump);
                        }
                        break block31;
                    }
                    if (!ne) break block39;
                    if (this.right.isNull) {
                        methodWriter.ifNonNull(jump);
                        break block31;
                    } else if (!this.left.isNull && this.operation == Operation.NE) {
                        methodWriter.invokeDefCall("eq", descriptor, 8, 1);
                        methodWriter.ifZCmp(153, jump);
                        break block31;
                    } else {
                        methodWriter.ifCmp(type, 154, jump);
                    }
                    break block31;
                }
                if (lt) {
                    methodWriter.invokeDefCall("lt", descriptor, 8, 0);
                    return;
                }
                if (lte) {
                    methodWriter.invokeDefCall("lte", descriptor, 8, 0);
                    return;
                }
                if (gt) {
                    methodWriter.invokeDefCall("gt", descriptor, 8, 0);
                    return;
                }
                if (!gte) {
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                methodWriter.invokeDefCall("gte", descriptor, 8, 0);
                return;
            }
            if (eq) {
                if (this.right.isNull) {
                    methodWriter.ifNull(jump);
                } else {
                    if (this.operation == Operation.EQ) {
                        methodWriter.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                        return;
                    }
                    methodWriter.ifCmp(type, 153, jump);
                }
            } else {
                if (!ne) {
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                if (this.right.isNull) {
                    methodWriter.ifNonNull(jump);
                } else if (this.operation == Operation.NE) {
                    methodWriter.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                    methodWriter.ifZCmp(153, jump);
                } else {
                    methodWriter.ifCmp(type, 154, jump);
                }
            }
        }
        if (!writejump) return;
        methodWriter.push(false);
        methodWriter.goTo(end);
        methodWriter.mark(jump);
        methodWriter.push(true);
        methodWriter.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.left, this.operation.symbol, this.right);
    }
}

