/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.view;

import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.toolwindow.table.model.TableAbstractRow;
import com.almworks.tracklink.toolwindow.table.model.TableCollectionRow;
import com.almworks.tracklink.toolwindow.table.view.IssueTableCellRenderer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class IssueTable {
    private final MyTable myTable;
    private final JScrollPane myScrollPanel;
    private final JTextField mySearchField;
    private final Document myDocument;
    private IssueTableModel myModel;
    private IssueTableCellRenderer myRenderer;

    public IssueTable(IssueTableModel model) {
        this.myModel = model;
        DefaultTableColumnModel tableColModel = new DefaultTableColumnModel();
        this.myTable = new MyTable(model, tableColModel);
        this.myScrollPanel = new JScrollPane(this.myTable);
        this.mySearchField = new JTextField();
        this.myDocument = this.mySearchField.getDocument();
        this.initFrame();
        this.initTableAppearence();
    }

    private void initFrame() {
        this.myDocument.addDocumentListener(new FilterModelHandler());
        this.mySearchField.addKeyListener(new SearchFieldKeyHandler());
    }

    private void initTableAppearence() {
        TableColumnModel cm = this.myTable.getColumnModel();
        TableColumn columnLeft = new TableColumn(0, 100);
        cm.addColumn(columnLeft);
        this.myRenderer = new IssueTableCellRenderer(this.myModel, this.myTable);
        columnLeft.setCellRenderer(this.myRenderer);
        columnLeft.setHeaderValue(this.myTable.getModel().getColumnName(0));
    }

    public JComponent getComponent() {
        return this.myScrollPanel;
    }

    public JComponent getTable() {
        return this.myTable;
    }

    public JComponent getSearchField() {
        return this.mySearchField;
    }

    public int getSingleSelection() {
        return this.myTable.getSelectedRow();
    }

    private void storeSelection(boolean storeCollectionSelection) {
        int selectedRow = this.getSingleSelection();
        if (selectedRow != -1) {
            this.myModel.setSelectedPos(selectedRow, storeCollectionSelection);
        }
    }

    private void setCollectionExpansion(TableAbstractRow row, boolean expand) {
        if (row instanceof ArtifactCollectionRow) {
            TableCollectionRow collection = (TableCollectionRow)row;
            collection.setCollectionExpanded(expand);
        }
    }

    private void toggleCollectionExpansion(TableAbstractRow row) {
        if (row instanceof ArtifactCollectionRow) {
            TableCollectionRow collection;
            collection.setCollectionExpanded(!(collection = (TableCollectionRow)row).isCollectionExpanded());
        }
    }

    private boolean isModifier(InputEvent e) {
        return e.isControlDown() || e.isShiftDown() || e.isAltDown() || e.isMetaDown();
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MouseEvent myLastEvent = null;

        private MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            this.processMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        private boolean isDoubleClick(MouseEvent event) {
            if (this.myLastEvent != null && this.myLastEvent.getX() == event.getX() && this.myLastEvent.getY() == event.getY() && event.getWhen() - this.myLastEvent.getWhen() < 500L) {
                this.myLastEvent = null;
                return true;
            }
            this.myLastEvent = event;
            return false;
        }

        private boolean inRect(MouseEvent e) {
            Rectangle rect = IssueTable.this.myRenderer.getExpandRect();
            return rect.getX() < (double)e.getX() && rect.getWidth() > (double)e.getX();
        }

        private void processMouseEvent(MouseEvent e) {
            IssueTableModel model = (IssueTableModel)IssueTable.this.myTable.getModel();
            int rowAtPoint = IssueTable.this.myTable.rowAtPoint(e.getPoint());
            TableAbstractRow row = model.getRowByPosition(rowAtPoint);
            boolean inRect = this.inRect(e);
            if (!inRect) {
                IssueTable.this.myTable.getSelectionModel().setSelectionInterval(rowAtPoint, rowAtPoint);
            }
            IssueTable.this.storeSelection(!inRect);
            if (inRect || this.isDoubleClick(e)) {
                IssueTable.this.toggleCollectionExpansion(row);
            }
        }
    }

    private class MyTable
    extends JTable {
        public MyTable(TableModel dm, TableColumnModel cm) {
            super(dm, cm);
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                }
            });
            this.setFocusable(true);
            this.setTableHeader(null);
            this.setShowGrid(false);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.addMouseListener(new MyMouseAdapter());
            this.addKeyListener(new MyKeyAdapter());
        }

        protected void processKeyEvent(KeyEvent event) {
            super.processKeyEvent(event);
        }

        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            this.restoreSelection(true);
        }

        public void restoreSelection(boolean findParent) {
            int newSelectedPos = IssueTable.this.myModel.getSelectedPos(findParent);
            int newPos = -1;
            if (newSelectedPos != -1) {
                newPos = newSelectedPos;
            } else if (IssueTable.this.myModel.getCollectionSize() > 0) {
                TableCollectionRow coll = IssueTable.this.myModel.getCollectionByRow(0);
                newPos = IssueTable.this.myModel.findFirstVisiblePos();
            }
            if (newPos != -1) {
                this.getSelectionModel().setSelectionInterval(newPos, newPos);
                Rectangle rectangle = new Rectangle(0, this.getRowHeight() * newPos, this.getWidth(), this.getRowHeight());
                this.scrollRectToVisible(rectangle);
            }
        }

        private class MyKeyAdapter
        extends KeyAdapter {
            private MyKeyAdapter() {
            }

            public void keyPressed(KeyEvent event) {
                IssueTable.this.storeSelection(true);
                int code = event.getKeyCode();
                switch (code) {
                    case 10: {
                        break;
                    }
                    case 37: {
                        if (IssueTable.this.getSingleSelection() == -1) break;
                        IssueTable.this.setCollectionExpansion(IssueTable.this.myModel.getCollectionByRow(IssueTable.this.getSingleSelection()), false);
                        break;
                    }
                    case 39: {
                        if (IssueTable.this.getSingleSelection() == -1) break;
                        IssueTable.this.setCollectionExpansion(IssueTable.this.myModel.getRowByPosition(IssueTable.this.getSingleSelection()), true);
                        break;
                    }
                    case 8: {
                        try {
                            if (IssueTable.this.myDocument.getLength() <= 0) break;
                            IssueTable.this.myDocument.remove(IssueTable.this.myDocument.getLength() - 1, 1);
                            break;
                        }
                        catch (BadLocationException e) {
                            assert (false) : "Wrong remove of first char : length = 0";
                            break;
                        }
                    }
                    default: {
                        char c = event.getKeyChar();
                        if (!IssueTable.this.isModifier(event)) {
                            if (event.isActionKey() || Character.isISOControl(c)) break;
                            IssueTable.this.mySearchField.requestFocus();
                            try {
                                IssueTable.this.myDocument.insertString(IssueTable.this.myDocument.getLength(), "" + c, null);
                                break;
                            }
                            catch (BadLocationException e) {
                                assert (false) : "Wrong insert params";
                                break;
                            }
                        }
                        if (!event.isControlDown()) break;
                        if (event.getKeyCode() == 70) {
                            IssueTable.this.mySearchField.requestFocus();
                            IssueTable.this.mySearchField.selectAll();
                            break;
                        }
                        if (event.getKeyCode() != 68) break;
                        IssueTable.this.mySearchField.setText("");
                    }
                }
            }
        }
    }

    private class SearchFieldKeyHandler
    extends KeyAdapter {
        private SearchFieldKeyHandler() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 27: {
                    IssueTable.this.myTable.requestFocus();
                }
                case 10: {
                    IssueTable.this.myTable.requestFocus();
                    break;
                }
                case 38: 
                case 40: {
                    if (!IssueTable.this.myTable.requestFocusInWindow()) break;
                    IssueTable.this.myTable.processKeyEvent(e);
                }
            }
        }
    }

    private class FilterModelHandler
    implements DocumentListener {
        private FilterModelHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            IssueTable.this.storeSelection(false);
            try {
                String filter = doc.getText(0, doc.getLength());
                IssueTable.this.myModel.setFilterString(filter);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }
    }
}

