/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.attribute.Attribute;

public class UsernameAttribute
extends Attribute {
    public static final String NAME = "USERNAME";
    private byte[] username = null;

    UsernameAttribute() {
        super('\u0006');
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) {
        this.username = new byte[length];
        System.arraycopy(attributeValue, offset, this.username, 0, length);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + (4 - this.getDataLength() % 4) % 4];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.username, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    public char getDataLength() {
        return (char)this.username.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getUsername() {
        return this.username == null ? null : (byte[])this.username.clone();
    }

    public void setUsername(byte[] username) {
        if (username == null) {
            this.username = null;
            return;
        }
        this.username = new byte[username.length];
        System.arraycopy(username, 0, this.username, 0, username.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UsernameAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UsernameAttribute att = (UsernameAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.username, this.username);
    }
}

