/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.DefaultValueGenerator;
import org.zaproxy.zap.model.ValueGenerator;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlFormParser
extends SpiderParser {
    private static final String ENCODING_TYPE = "UTF-8";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String METHOD_POST = "POST";
    private URI uri;
    private String url;
    private Map<String, String> envAttributes = new HashMap<String, String>();
    private final SpiderParam param;
    private final ValueGenerator valueGenerator;

    public SpiderHtmlFormParser(SpiderParam param) {
        this(param, new DefaultValueGenerator());
    }

    public SpiderHtmlFormParser(SpiderParam param, ValueGenerator valueGenerator) {
        if (param == null) {
            throw new IllegalArgumentException("Parameter param must not be null.");
        }
        if (valueGenerator == null) {
            throw new IllegalArgumentException("Parameter valueGenerator must not be null.");
        }
        this.param = param;
        this.valueGenerator = valueGenerator;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        log.debug((Object)"Parsing an HTML message for forms...");
        if (!this.param.isProcessForm()) {
            return false;
        }
        if (source == null) {
            source = new Source((CharSequence)message.getResponseBody().toString());
        }
        String baseURL = message.getRequestHeader().getURI().toString();
        this.uri = message.getRequestHeader().getURI();
        Element base = source.getFirstElement("base");
        if (base != null) {
            String href;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + base.getDebugInfo()));
            }
            if ((href = base.getAttributeValue("href")) != null && !href.isEmpty()) {
                baseURL = URLCanonicalizer.getCanonicalURL(href, baseURL);
            }
        }
        List forms = source.getAllElements("form");
        for (Element form : forms) {
            this.envAttributes.clear();
            for (Attribute att : form.getAttributes()) {
                this.envAttributes.put(att.getKey(), att.getValue());
            }
            String method = form.getAttributeValue("method");
            String action = form.getAttributeValue("action");
            log.debug((Object)("Found new form with method: '" + method + "' and action: " + action));
            if (action == null) {
                log.debug((Object)("No form 'action' defined. Using base URL: " + baseURL));
                action = baseURL;
            }
            if (!this.param.isPostForm() && method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                log.debug((Object)"Skipping form with POST method because of user settings.");
                continue;
            }
            if (action.contains("#")) {
                int fs = action.lastIndexOf("#");
                action = action.substring(0, fs);
            }
            this.url = URLCanonicalizer.getCanonicalURL(action, baseURL);
            FormData formData = this.prepareFormDataSet(form.getFormFields());
            if (method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                String fullURL = URLCanonicalizer.getCanonicalURL(action, baseURL);
                if (fullURL == null) {
                    return false;
                }
                log.debug((Object)("Canonical URL constructed using '" + action + "': " + fullURL));
                String baseRequestBody = this.buildEncodedUrlQuery(formData.getFields());
                if (formData.getSubmitFields().isEmpty()) {
                    this.notifyPostResourceFound(message, depth, fullURL, baseRequestBody);
                    continue;
                }
                for (HtmlParameter submitField : formData.getSubmitFields()) {
                    this.notifyPostResourceFound(message, depth, fullURL, SpiderHtmlFormParser.appendEncodedUrlQueryParameter(baseRequestBody, submitField));
                }
                continue;
            }
            if (action.contains("?")) {
                if (action.endsWith("?")) {
                    this.processGetForm(message, depth, action, baseURL, formData);
                    continue;
                }
                this.processGetForm(message, depth, action + "&", baseURL, formData);
                continue;
            }
            this.processGetForm(message, depth, action + "?", baseURL, formData);
        }
        return false;
    }

    private void processGetForm(HttpMessage message, int depth, String action, String baseURL, FormData formData) {
        String baseQuery = this.buildEncodedUrlQuery(formData.getFields());
        if (formData.getSubmitFields().isEmpty()) {
            log.debug((Object)("Submiting form with GET method and query with form parameters: " + baseQuery));
            this.processURL(message, depth, action + baseQuery, baseURL);
        } else {
            for (HtmlParameter submitField : formData.getSubmitFields()) {
                String query = SpiderHtmlFormParser.appendEncodedUrlQueryParameter(baseQuery, submitField);
                log.debug((Object)("Submiting form with GET method and query with form parameters: " + query));
                this.processURL(message, depth, action + query, baseURL);
            }
        }
    }

    private FormData prepareFormDataSet(FormFields form) {
        LinkedList<HtmlParameter> formDataSet = new LinkedList<HtmlParameter>();
        ArrayList<HtmlParameter> submitFields = new ArrayList<HtmlParameter>();
        for (FormField field : form) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New form field: " + field.getDebugInfo()));
            }
            AbstractList currentList = formDataSet;
            if (field.getFormControl().getFormControlType().isSubmit()) {
                currentList = submitFields;
            }
            for (String value : this.getDefaultTextValue(field)) {
                currentList.add((HtmlParameter)new HtmlParameter(HtmlParameter.Type.form, field.getName(), value));
            }
        }
        return new FormData(formDataSet, submitFields);
    }

    private List<String> getDefaultTextValue(FormField field) {
        String defaultValue;
        String fieldId = field.getName();
        HashMap<String, String> fieldAttributes = new HashMap<String, String>();
        ArrayList<String> definedValues = new ArrayList<String>();
        fieldAttributes.putAll(field.getFormControl().getAttributesMap());
        fieldAttributes.put("Control Type", field.getFormControl().getFormControlType().name());
        if (field.getFormControl().getFormControlType().isSubmit()) {
            ArrayList<String> submitFields = new ArrayList<String>();
            for (String value : field.getPredefinedValues()) {
                String finalValue = this.valueGenerator.getValue(this.uri, this.url, fieldId, value, definedValues, this.envAttributes, fieldAttributes);
                submitFields.add(finalValue);
            }
            return submitFields;
        }
        ArrayList<String> values = field.getValues();
        if (field.getFormControl().getAttributesMap().containsKey("value")) {
            String string = (String)field.getFormControl().getAttributesMap().get("value");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Existing values: " + values));
        }
        if (values.isEmpty() || values.size() == 1 && ((String)values.get(0)).isEmpty()) {
            defaultValue = DEFAULT_EMPTY_VALUE;
            Collection predefValues = field.getPredefinedValues();
            if (!predefValues.isEmpty()) {
                definedValues.addAll(predefValues);
                Iterator iterator = predefValues.iterator();
                defaultValue = (String)iterator.next();
                if (iterator.hasNext()) {
                    defaultValue = (String)iterator.next();
                }
            }
        } else {
            defaultValue = (String)values.get(0);
        }
        String finalValue = this.valueGenerator.getValue(this.uri, this.url, fieldId, defaultValue, definedValues, this.envAttributes, fieldAttributes);
        log.debug((Object)("Generated: " + finalValue + "For field " + field.getName()));
        values = new ArrayList<String>(1);
        values.add(finalValue);
        return values;
    }

    private void notifyPostResourceFound(HttpMessage message, int depth, String url, String requestBody) {
        log.debug((Object)("Submiting form with POST method and message body with form parameters (normal encoding): " + requestBody));
        this.notifyListenersPostResourceFound(message, depth + 1, url, requestBody);
    }

    private String buildEncodedUrlQuery(List<HtmlParameter> formDataSet) {
        StringBuilder request = new StringBuilder();
        for (HtmlParameter p : formDataSet) {
            try {
                String v = URLEncoder.encode(p.getName(), ENCODING_TYPE);
                request.append(v);
                request.append("=");
                v = URLEncoder.encode(p.getValue(), ENCODING_TYPE);
                request.append(v);
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"Error while encoding query for form.", (Throwable)e);
            }
            request.append("&");
        }
        if (request.length() > 0) {
            request.deleteCharAt(request.length() - 1);
        }
        return request.toString();
    }

    private static String appendEncodedUrlQueryParameter(String query, HtmlParameter parameter) {
        StringBuilder strBuilder = new StringBuilder(query);
        if (strBuilder.length() != 0) {
            strBuilder.append('&');
        }
        try {
            strBuilder.append(URLEncoder.encode(parameter.getName(), ENCODING_TYPE)).append('=').append(URLEncoder.encode(parameter.getValue(), ENCODING_TYPE));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"Error while encoding query for form.", (Throwable)e);
        }
        return strBuilder.toString();
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyConsumed) {
        return !wasAlreadyConsumed && message.getResponseHeader().isHtml();
    }

    private static class FormData {
        private final List<HtmlParameter> fields;
        private final List<HtmlParameter> submitFields;

        public FormData(List<HtmlParameter> fields, List<HtmlParameter> submitFields) {
            this.fields = fields;
            this.submitFields = submitFields;
        }

        public List<HtmlParameter> getFields() {
            return this.fields;
        }

        public List<HtmlParameter> getSubmitFields() {
            return this.submitFields;
        }
    }
}

