/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.generators;

import java.util.Random;

public final class RandomNumbers {
    public static int randomIntBetween(Random r, int min, int max) {
        assert (max >= min) : "max must be >= min: " + min + ", " + max;
        long range = (long)max - (long)min;
        if (range < Integer.MAX_VALUE) {
            return min + r.nextInt(1 + (int)range);
        }
        return RandomNumbers.toIntExact((long)min + RandomNumbers.nextLong(r, 1L + range));
    }

    public static long randomLongBetween(Random r, long min, long max) {
        assert (max >= min) : "max must be >= min: " + min + ", " + max;
        long range = max - min;
        if (range < 0L) {
            if ((range -= Long.MAX_VALUE) == Long.MIN_VALUE) {
                return r.nextLong();
            }
            long first = r.nextLong() & Long.MAX_VALUE;
            long second = range == Long.MAX_VALUE ? r.nextLong() & Long.MAX_VALUE : RandomNumbers.nextLong(r, range + 1L);
            return min + first + second;
        }
        long second = range == Long.MAX_VALUE ? r.nextLong() & Long.MAX_VALUE : RandomNumbers.nextLong(r, range + 1L);
        return min + second;
    }

    public static long nextLong(Random rnd, long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("n <= 0: " + n);
        }
        long value = rnd.nextLong();
        long range = n - 1L;
        if ((n & range) == 0L) {
            value &= range;
        } else {
            long u = value >>> 1;
            while (u + range - (value = u % n) < 0L) {
                u = rnd.nextLong() >>> 1;
            }
        }
        return value;
    }

    private static int toIntExact(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new ArithmeticException("Overflow: " + value);
        }
        return (int)value;
    }
}

