/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.json;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.json.JSONUtil;
import org.apache.solr.request.json.JsonQueryConverter;
import org.apache.solr.request.json.ObjectUtil;
import org.apache.solr.request.macro.MacroExpander;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class RequestUtil {
    public static void processParams(SolrRequestHandler handler, SolrQueryRequest req, SolrParams defaults, SolrParams appends, SolrParams invariants) {
        String key2;
        boolean hasAdditions;
        boolean searchHandler = handler instanceof SearchHandler;
        SolrParams params = req.getParams();
        if (searchHandler && req.getContentStreams() != null) {
            Map map = MultiMapSolrParams.asMultiMap((SolrParams)params, (boolean)false);
            if (!(params instanceof MultiMapSolrParams) && !(params instanceof ModifiableSolrParams)) {
                params = new MultiMapSolrParams(map);
                req.setParams(params);
            }
            String[] jsonFromParams = (String[])map.remove("json");
            for (ContentStream cs : req.getContentStreams()) {
                String contentType = cs.getContentType();
                if (contentType == null || !contentType.contains("/json")) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad contentType for search handler :" + contentType + " request=" + req);
                }
                try {
                    String jsonString = IOUtils.toString((Reader)cs.getReader());
                    if (jsonString == null) continue;
                    MultiMapSolrParams.addParam((String)"json", (String)jsonString, (Map)map);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception reading content stream for request:" + req, (Throwable)e);
                }
            }
            if (jsonFromParams != null) {
                for (String json : jsonFromParams) {
                    MultiMapSolrParams.addParam((String)"json", (String)json, (Map)map);
                }
            }
        }
        String[] jsonS = params.getParams("json");
        boolean bl = hasAdditions = defaults != null || invariants != null || appends != null || jsonS != null;
        if (!hasAdditions && !params.getBool("expandMacros", true)) {
            return;
        }
        boolean isShard = params.getBool("isShard", false);
        Map<String, String[]> newMap = MultiMapSolrParams.asMultiMap((SolrParams)params, (boolean)hasAdditions);
        if (jsonS != null && !isShard) {
            for (String json : jsonS) {
                RequestUtil.getParamsFromJSON(newMap, json);
            }
        }
        if (defaults != null) {
            Map defaultsMap = MultiMapSolrParams.asMultiMap((SolrParams)defaults);
            for (Map.Entry entry : defaultsMap.entrySet()) {
                key2 = (String)entry.getKey();
                if (newMap.containsKey(key2)) continue;
                newMap.put(key2, (String[])entry.getValue());
            }
        }
        if (appends != null) {
            Map appendsMap = MultiMapSolrParams.asMultiMap((SolrParams)appends);
            for (Map.Entry entry : appendsMap.entrySet()) {
                key2 = (String)entry.getKey();
                String[] arr = newMap.get(key2);
                if (arr == null) {
                    newMap.put(key2, (String[])entry.getValue());
                    continue;
                }
                String[] appendArr = (String[])entry.getValue();
                String[] newArr = new String[arr.length + appendArr.length];
                System.arraycopy(arr, 0, newArr, 0, arr.length);
                System.arraycopy(appendArr, 0, newArr, arr.length, appendArr.length);
                newMap.put(key2, newArr);
            }
        }
        if (invariants != null) {
            newMap.putAll(MultiMapSolrParams.asMultiMap((SolrParams)invariants));
        }
        if (!isShard) {
            String[] doMacrosStr = (String[])newMap.get("expandMacros");
            boolean doMacros = true;
            if (doMacrosStr != null) {
                doMacros = "true".equals(doMacrosStr[0]);
            }
            if (doMacros) {
                newMap = MacroExpander.expand(newMap);
            }
        }
        MultiMapSolrParams newParams = new MultiMapSolrParams((Map)newMap);
        req.setParams((SolrParams)newParams);
        if (!searchHandler) {
            return;
        }
        LinkedHashMap<String, Object> json = null;
        jsonS = newMap.get("json");
        if (jsonS != null) {
            if (json == null) {
                json = new LinkedHashMap<String, Object>();
            }
            RequestUtil.mergeJSON(json, "json", jsonS, new ObjectUtil.ConflictHandler());
        }
        for (String key2 : newMap.keySet()) {
            if (!key2.startsWith("json.") || "json.nl".equals(key2) || "json.wrf".equals(key2)) continue;
            if (json == null) {
                json = new LinkedHashMap();
            }
            RequestUtil.mergeJSON(json, key2, newMap.get(key2), new ObjectUtil.ConflictHandler());
        }
        JsonQueryConverter jsonQueryConverter = new JsonQueryConverter();
        if (json != null && !isShard) {
            for (Map.Entry entry : json.entrySet()) {
                String key3 = (String)entry.getKey();
                String out = null;
                boolean isQuery = false;
                boolean arr = false;
                if ("query".equals(key3)) {
                    out = "q";
                    isQuery = true;
                } else if ("filter".equals(key3)) {
                    out = "fq";
                    arr = true;
                    isQuery = true;
                } else if ("fields".equals(key3)) {
                    out = "fl";
                    arr = true;
                } else if ("offset".equals(key3)) {
                    out = "start";
                } else if ("limit".equals(key3)) {
                    out = "rows";
                } else if ("sort".equals(key3)) {
                    out = "sort";
                } else {
                    if ("params".equals(key3) || "facet".equals(key3)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown top-level key in JSON request : " + key3);
                }
                Object val = entry.getValue();
                if (arr) {
                    int i;
                    String[] existing = newMap.get(out);
                    List lst = val instanceof List ? (List)val : null;
                    int existingSize = existing == null ? 0 : existing.length;
                    int jsonSize = lst == null ? 1 : lst.size();
                    String[] newval = new String[existingSize + jsonSize];
                    for (i = 0; i < existingSize; ++i) {
                        newval[i] = existing[i];
                    }
                    if (lst != null) {
                        for (i = 0; i < jsonSize; ++i) {
                            Object v = lst.get(i);
                            newval[existingSize + i] = isQuery ? jsonQueryConverter.toLocalParams(v, newMap) : v.toString();
                        }
                    } else {
                        newval[newval.length - 1] = isQuery ? jsonQueryConverter.toLocalParams(val, newMap) : val.toString();
                    }
                    newMap.put(out, newval);
                    continue;
                }
                newMap.put(out, new String[]{isQuery ? jsonQueryConverter.toLocalParams(val, newMap) : val.toString()});
            }
        }
        if (json != null) {
            req.setJSON(json);
        }
    }

    private static void mergeJSON(Map<String, Object> json, String queryParamName, String[] vals, ObjectUtil.ConflictHandler handler) {
        try {
            List<String> path = StrUtils.splitSmart((String)queryParamName, (String)".", (boolean)true);
            path = path.subList(1, path.size());
            for (String jsonStr : vals) {
                Object o = ObjectBuilder.fromJSON((String)jsonStr);
                if (o == null) continue;
                ObjectUtil.mergeObjects(json, path, o, handler);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void getParamsFromJSON(Map<String, String[]> params, String json) {
        if (json.indexOf("params") < 0) {
            return;
        }
        JSONParser parser = new JSONParser(json);
        try {
            JSONUtil.expect(parser, 7);
            boolean found = JSONUtil.advanceToMapKey(parser, "params", false);
            if (!found) {
                return;
            }
            parser.nextEvent();
            Object o = ObjectBuilder.getVal((JSONParser)parser);
            if (!(o instanceof Map)) {
                return;
            }
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (params.get(key) != null) continue;
                if (val == null) {
                    params.remove(key);
                    continue;
                }
                if (val instanceof List) {
                    List lst = (List)val;
                    String[] vals = new String[lst.size()];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = lst.get(i).toString();
                    }
                    params.put(key, vals);
                    continue;
                }
                params.put(key, new String[]{val.toString()});
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

