/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Library;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.core.PApplet;
import processing.mode.android.AVD;
import processing.mode.android.AndroidMode;
import processing.mode.android.AndroidPreprocessor;
import processing.mode.android.AndroidSDK;
import processing.mode.android.Manifest;
import processing.mode.java.JavaBuild;

class AndroidBuild
extends JavaBuild {
    static final String basePackage = "processing.android.test";
    static final String sdkVersion = "7";
    static final String sdkTarget = "android-7";
    private final AndroidSDK sdk;
    private final File coreZipFile;
    private String target;
    private Manifest manifest;
    private File tmpFolder;
    private File buildFile;
    static final String ICON_72 = "icon-72.png";
    static final String ICON_48 = "icon-48.png";
    static final String ICON_36 = "icon-36.png";

    public AndroidBuild(Sketch sketch, AndroidMode mode) {
        super(sketch);
        this.sdk = mode.getSDK();
        this.coreZipFile = mode.getCoreZipLocation();
    }

    public File build(String target) throws IOException, SketchException {
        boolean avd = AVD.ensureEclairAVD(this.sdk);
        if (!avd) {
            SketchException se = new SketchException("Could not create a virtual device for the emulator.");
            se.hideStackTrace();
            throw se;
        }
        this.target = target;
        File folder = this.createProject();
        if (folder != null && !this.antBuild()) {
            return null;
        }
        return folder;
    }

    protected boolean ignorableImport(String pkg) {
        if (pkg.startsWith("android.")) {
            return true;
        }
        if (pkg.startsWith("java.")) {
            return true;
        }
        if (pkg.startsWith("javax.")) {
            return true;
        }
        if (pkg.startsWith("org.apache.http.")) {
            return true;
        }
        if (pkg.startsWith("org.json.")) {
            return true;
        }
        if (pkg.startsWith("org.w3c.dom.")) {
            return true;
        }
        return pkg.startsWith("org.xml.sax.");
    }

    public File createProject() throws IOException, SketchException {
        this.tmpFolder = this.createTempBuildFolder(this.sketch);
        this.binFolder = this.srcFolder = new File(this.tmpFolder, "src");
        if (Base.DEBUG) {
            Base.openFolder(this.tmpFolder);
        }
        this.manifest = new Manifest(this.sketch);
        AndroidPreprocessor preproc = new AndroidPreprocessor(this.sketch, this.getPackageName());
        if (!preproc.parseSketchSize()) {
            throw new SketchException("Could not parse the size() command.");
        }
        this.sketchClassName = this.preprocess(this.srcFolder, this.manifest.getPackageName(), preproc);
        if (this.sketchClassName != null) {
            File tempManifest = new File(this.tmpFolder, "AndroidManifest.xml");
            this.manifest.writeBuild(tempManifest, this.sketchClassName, this.target.equals("debug"));
            this.writeBuildProps(new File(this.tmpFolder, "build.properties"));
            this.buildFile = new File(this.tmpFolder, "build.xml");
            this.writeBuildXML(this.buildFile, this.sketch.getName());
            this.writeDefaultProps(new File(this.tmpFolder, "default.properties"));
            this.writeLocalProps(new File(this.tmpFolder, "local.properties"));
            this.writeRes(new File(this.tmpFolder, "res"), this.sketchClassName);
            File libsFolder = this.mkdirs(this.tmpFolder, "libs");
            File assetsFolder = this.mkdirs(this.tmpFolder, "assets");
            Base.copyFile(this.coreZipFile, new File(libsFolder, "processing-core.jar"));
            this.copyLibraries(libsFolder, assetsFolder);
            this.copyCodeFolder(libsFolder);
            File sketchDataFolder = this.sketch.getDataFolder();
            if (sketchDataFolder.exists()) {
                Base.copyDir(sketchDataFolder, assetsFolder);
            }
        }
        return this.tmpFolder;
    }

    private File createTempBuildFolder(Sketch sketch) throws IOException {
        File tmp = File.createTempFile("android", ".pde");
        if (!tmp.delete() || !tmp.mkdir()) {
            throw new IOException("Cannot create temp dir " + tmp + " to build android sketch");
        }
        return tmp;
    }

    protected File createExportFolder() throws IOException {
        File androidFolder = new File(this.sketch.getFolder(), "android");
        if (androidFolder.exists()) {
            String stamp = AndroidMode.getDateStamp(androidFolder.lastModified());
            File dest = new File(this.sketch.getFolder(), "android." + stamp);
            boolean result = androidFolder.renameTo(dest);
            if (!result) {
                ProcessResult pr;
                try {
                    System.err.println("createProject renameTo() failed, resorting to mv/move instead.");
                    ProcessHelper mv = new ProcessHelper("mv", androidFolder.getAbsolutePath(), dest.getAbsolutePath());
                    pr = mv.execute();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
                if (!pr.succeeded()) {
                    System.err.println(pr.getStderr());
                    Base.showWarning("Failed to rename", "Could not rename the old \u201candroid\u201d build folder.\nPlease delete, close, or rename the folder\n" + androidFolder.getAbsolutePath() + "\n" + "and try again.", null);
                    Base.openFolder(this.sketch.getFolder());
                    return null;
                }
            }
        } else {
            boolean result = androidFolder.mkdirs();
            if (!result) {
                Base.showWarning("Folders, folders, folders", "Could not create the necessary folders to build.\nPerhaps you have some file permissions to sort out?", null);
                return null;
            }
        }
        return androidFolder;
    }

    public File exportProject() throws IOException, SketchException {
        File projectFolder = this.build("debug");
        if (projectFolder == null) {
            return null;
        }
        File exportFolder = this.createExportFolder();
        Base.copyDir(projectFolder, exportFolder);
        return exportFolder;
    }

    public boolean exportPackage() throws IOException, SketchException {
        File projectFolder = this.build("release");
        if (projectFolder == null) {
            return false;
        }
        File exportFolder = this.createExportFolder();
        Base.copyDir(projectFolder, exportFolder);
        return true;
    }

    protected boolean antBuild() throws SketchException {
        Project p = new Project();
        String path = this.buildFile.getAbsolutePath().replace('\\', '/');
        p.setUserProperty("ant.file", path);
        p.setUserProperty("build.compiler", "extJavac");
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
        DefaultLogger errorLogger = new DefaultLogger();
        ByteArrayOutputStream errb = new ByteArrayOutputStream();
        PrintStream errp = new PrintStream(errb);
        errorLogger.setErrorPrintStream(errp);
        ByteArrayOutputStream outb = new ByteArrayOutputStream();
        PrintStream outp = new PrintStream(outb);
        errorLogger.setOutputPrintStream(outp);
        errorLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)errorLogger);
        try {
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)this.buildFile);
            p.executeTarget(this.target);
            return true;
        }
        catch (BuildException e) {
            String[] outLines;
            p.fireBuildFinished((Throwable)e);
            String outPile = new String(outb.toByteArray());
            for (String line : outLines = outPile.split(System.getProperty("line.separator"))) {
                int lineNumber;
                int offset;
                String[] pieces;
                String javacPrefix = "[javac]";
                int javacIndex = line.indexOf("[javac]");
                if (javacIndex == -1 || (pieces = PApplet.match((String)line.substring(offset = javacIndex + "[javac]".length() + 1), (String)"^(.+):([0-9]+):\\s+(.+)$")) == null) continue;
                String fileName = pieces[1];
                SketchException rex = this.placeException(pieces[3], fileName = fileName.substring(fileName.lastIndexOf(47) + 1), lineNumber = PApplet.parseInt((String)pieces[2]) - 1);
                if (rex == null) continue;
                throw rex;
            }
            SketchException skex = new SketchException("Error from inside the Android tools, check the console.");
            skex.hideStackTrace();
            throw skex;
        }
    }

    String getPathForAPK() {
        String suffix = this.target.equals("release") ? "unsigned" : "debug";
        String apkName = "bin/" + this.sketch.getName() + "-" + suffix + ".apk";
        File apkFile = new File(this.tmpFolder, apkName);
        return apkFile.getAbsolutePath();
    }

    private void writeBuildProps(File file) {
        PrintWriter writer = PApplet.createWriter((File)file);
        writer.println("application-package=" + this.getPackageName());
        writer.flush();
        writer.close();
    }

    private void writeBuildXML(File file, String projectName) {
        PrintWriter writer = PApplet.createWriter((File)file);
        writer.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.println("<project name=\"" + projectName + "\" default=\"help\">");
        writer.println("  <property file=\"local.properties\"/>");
        writer.println("  <property file=\"build.properties\"/>");
        writer.println("  <property file=\"default.properties\"/>");
        writer.println("  <path id=\"android.antlibs\">");
        writer.println("    <pathelement path=\"${sdk.dir}/tools/lib/anttasks.jar\" />");
        writer.println("    <pathelement path=\"${sdk.dir}/tools/lib/sdklib.jar\" />");
        writer.println("    <pathelement path=\"${sdk.dir}/tools/lib/androidprefs.jar\" />");
        writer.println("    <pathelement path=\"${sdk.dir}/tools/lib/apkbuilder.jar\" />");
        writer.println("    <pathelement path=\"${sdk.dir}/tools/lib/jarutils.jar\" />");
        writer.println("  </path>");
        writer.println("  <taskdef name=\"setup\"");
        writer.println("           classname=\"com.android.ant.SetupTask\"");
        writer.println("           classpathref=\"android.antlibs\" />");
        writer.println("  <setup />");
        writer.println("</project>");
        writer.flush();
        writer.close();
    }

    private void writeDefaultProps(File file) {
        PrintWriter writer = PApplet.createWriter((File)file);
        writer.println("target=android-7");
        writer.flush();
        writer.close();
    }

    private void writeLocalProps(File file) {
        PrintWriter writer = PApplet.createWriter((File)file);
        String sdkPath = this.sdk.getSdkFolder().getAbsolutePath();
        if (Base.isWindows()) {
            writer.println("sdk.dir=" + sdkPath.replace('\\', '/'));
        } else {
            writer.println("sdk.dir=" + sdkPath);
        }
        writer.flush();
        writer.close();
    }

    private void writeRes(File resFolder, String className) throws SketchException {
        block14: {
            File layoutFolder = this.mkdirs(resFolder, "layout");
            File layoutFile = new File(layoutFolder, "main.xml");
            this.writeResLayoutMain(layoutFile);
            File sketchFolder = this.sketch.getFolder();
            File localIcon36 = new File(sketchFolder, ICON_36);
            File localIcon48 = new File(sketchFolder, ICON_48);
            File localIcon72 = new File(sketchFolder, ICON_72);
            File buildIcon48 = new File(resFolder, "drawable/icon.png");
            File buildIcon36 = new File(resFolder, "drawable-ldpi/icon.png");
            File buildIcon72 = new File(resFolder, "drawable-hdpi/icon.png");
            if (!(localIcon36.exists() || localIcon48.exists() || localIcon72.exists())) {
                try {
                    if (buildIcon36.getParentFile().mkdirs()) {
                        Base.copyFile(this.mode.getContentFile("icons/icon-36.png"), buildIcon36);
                    } else {
                        System.err.println("Could not create \"drawable-ldpi\" folder.");
                    }
                    if (buildIcon48.getParentFile().mkdirs()) {
                        Base.copyFile(this.mode.getContentFile("icons/icon-48.png"), buildIcon48);
                    } else {
                        System.err.println("Could not create \"drawable\" folder.");
                    }
                    if (buildIcon72.getParentFile().mkdirs()) {
                        Base.copyFile(this.mode.getContentFile("icons/icon-72.png"), buildIcon72);
                        break block14;
                    }
                    System.err.println("Could not create \"drawable-hdpi\" folder.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (localIcon36.exists() && new File(resFolder, "drawable-ldpi").mkdirs()) {
                        Base.copyFile(localIcon36, buildIcon36);
                    }
                    if (localIcon48.exists() && new File(resFolder, "drawable").mkdirs()) {
                        Base.copyFile(localIcon48, buildIcon48);
                    }
                    if (localIcon72.exists() && new File(resFolder, "drawable-hdpi").mkdirs()) {
                        Base.copyFile(localIcon72, buildIcon72);
                    }
                }
                catch (IOException e) {
                    System.err.println("Problem while copying icons.");
                    e.printStackTrace();
                }
            }
        }
    }

    private File mkdirs(File parent, String name) throws SketchException {
        File result = new File(parent, name);
        if (!result.exists() && !result.mkdirs()) {
            throw new SketchException("Could not create " + result);
        }
        return result;
    }

    private void writeResLayoutMain(File file) {
        PrintWriter writer = PApplet.createWriter((File)file);
        writer.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.println("<LinearLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        writer.println("              android:orientation=\"vertical\"");
        writer.println("              android:layout_width=\"fill_parent\"");
        writer.println("              android:layout_height=\"fill_parent\">");
        writer.println("</LinearLayout>");
        writer.flush();
        writer.close();
    }

    private void copyLibraries(File libsFolder, File assetsFolder) throws IOException {
        for (Library library : this.getImportedLibraries()) {
            File libraryFolder = new File(library.getPath());
            File exportSettings = new File(libraryFolder, "export.txt");
            HashMap<String, String> exportTable = Base.readSettings(exportSettings);
            String androidList = exportTable.get("android");
            String[] exportList = null;
            exportList = androidList != null ? PApplet.splitTokens((String)androidList, (String)", ") : libraryFolder.list();
            for (int i = 0; i < exportList.length; ++i) {
                exportList[i] = PApplet.trim((String)exportList[i]);
                if (exportList[i].equals("") || exportList[i].equals(".") || exportList[i].equals("..")) continue;
                File exportFile = new File(libraryFolder, exportList[i]);
                if (!exportFile.exists()) {
                    System.err.println("File " + exportList[i] + " does not exist");
                    continue;
                }
                if (exportFile.isDirectory()) {
                    System.err.println("Ignoring sub-folder \"" + exportList[i] + "\"");
                    continue;
                }
                String name = exportFile.getName();
                String lcname = name.toLowerCase();
                if (lcname.endsWith(".zip") || lcname.endsWith(".jar")) {
                    String jarName = name.substring(0, name.length() - 4) + ".jar";
                    Base.copyFile(exportFile, new File(libsFolder, jarName));
                    continue;
                }
                Base.copyFile(exportFile, new File(assetsFolder, name));
            }
        }
    }

    private void copyCodeFolder(File libsFolder) throws IOException {
        File codeFolder = this.sketch.getCodeFolder();
        if (codeFolder != null && codeFolder.exists()) {
            for (File item : codeFolder.listFiles()) {
                String name;
                String lcname;
                if (item.isDirectory() || !(lcname = (name = item.getName()).toLowerCase()).endsWith(".jar") && !lcname.endsWith(".zip")) continue;
                String jarName = name.substring(0, name.length() - 4) + ".jar";
                Base.copyFile(item, new File(libsFolder, jarName));
            }
        }
    }

    protected String getPackageName() {
        return this.manifest.getPackageName();
    }

    public void cleanup() {
        this.tmpFolder.deleteOnExit();
    }
}

