/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawChar;
import de.escape.quincunx.dxf.DxfFont;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DxfFontFromStream
extends DxfFont {
    private static byte[] HEAD = new byte[]{68, 86, 70, 84};
    private DrawChar[] drawables = new DrawChar[256];
    private float height;
    private float[] advance = new float[256];
    private float[][][][] chars = new float[256][][][];

    public DxfFontFromStream(InputStream input) throws IOException {
        int charnum;
        byte[] head = new byte[HEAD.length];
        input.read(head);
        int b = 0;
        while (b < HEAD.length) {
            if (head[b] != HEAD[b]) {
                throw new IOException("No font file");
            }
            ++b;
        }
        this.height = DxfFontFromStream.readFloat(input);
        int c = 0;
        while (c < 256) {
            this.advance[c] = DxfFontFromStream.readFloat(input);
            ++c;
        }
        while ((charnum = DxfFontFromStream.readUShort(input)) != 256) {
            int lines = DxfFontFromStream.readUShort(input);
            this.chars[charnum] = new float[lines][][];
            int l = 0;
            while (l < lines) {
                int points = DxfFontFromStream.readUShort(input);
                this.chars[charnum][l] = new float[points][];
                int p = 0;
                while (p < points) {
                    float x = DxfFontFromStream.readFloat(input);
                    float y = DxfFontFromStream.readFloat(input);
                    this.chars[charnum][l][p] = new float[]{x, y};
                    ++p;
                }
                ++l;
            }
        }
    }

    private static int readUShort(InputStream input) throws IOException {
        int val2;
        int val1 = input.read();
        if ((val1 | (val2 = input.read())) < 0) {
            throw new EOFException();
        }
        return val1 << 8 | val2;
    }

    private static float readFloat(InputStream input) throws IOException {
        int val2;
        int val1 = DxfFontFromStream.readUShort(input);
        if ((val1 | (val2 = DxfFontFromStream.readUShort(input))) < 0) {
            throw new EOFException();
        }
        return Float.intBitsToFloat(val1 << 16 | val2);
    }

    public DrawChar getDrawChar(int charNum) {
        if (this.drawables[charNum = this.normalize(charNum)] == null) {
            this.drawables[charNum] = new DrawChar(this.chars[charNum], this.advance[charNum]);
        }
        return this.drawables[charNum];
    }

    public float getHeight() {
        return this.height;
    }
}

