/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.ImageUtil;
import com.sun.opengl.util.TGAWriter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class Screenshot {
    private Screenshot() {
    }

    public static void writeToTargaFile(File file, int n, int n2) throws GLException, IOException {
        Screenshot.writeToTargaFile(file, n, n2, false);
    }

    public static void writeToTargaFile(File file, int n, int n2, boolean bl) throws GLException, IOException {
        Screenshot.writeToTargaFile(file, 0, 0, n, n2, bl);
    }

    public static void writeToTargaFile(File file, int n, int n2, int n3, int n4, boolean bl) throws GLException, IOException {
        if (bl) {
            Screenshot.checkExtABGR();
        }
        TGAWriter tGAWriter = new TGAWriter();
        tGAWriter.open(file, n3, n4, bl);
        ByteBuffer byteBuffer = tGAWriter.getImageData();
        GL gL = GLU.getCurrentGL();
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        pixelStorageModes.save(gL);
        int n5 = bl ? 32768 : 32992;
        gL.glReadPixels(n, n2, n3, n4, n5, 5121, byteBuffer);
        pixelStorageModes.restore(gL);
        tGAWriter.close();
    }

    public static BufferedImage readToBufferedImage(int n, int n2) throws GLException {
        return Screenshot.readToBufferedImage(n, n2, false);
    }

    public static BufferedImage readToBufferedImage(int n, int n2, boolean bl) throws GLException {
        return Screenshot.readToBufferedImage(0, 0, n, n2, bl);
    }

    public static BufferedImage readToBufferedImage(int n, int n2, int n3, int n4, boolean bl) throws GLException {
        int n5;
        int n6 = bl ? 6 : 5;
        int n7 = n5 = bl ? 32768 : 32992;
        if (bl) {
            Screenshot.checkExtABGR();
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        GL gL = GLU.getCurrentGL();
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        pixelStorageModes.save(gL);
        gL.glReadPixels(n, n2, n3, n4, n5, 5121, ByteBuffer.wrap(((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData()));
        pixelStorageModes.restore(gL);
        ImageUtil.flipImageVertically(bufferedImage);
        return bufferedImage;
    }

    public static void writeToFile(File file, int n, int n2) throws IOException, GLException {
        Screenshot.writeToFile(file, n, n2, false);
    }

    public static void writeToFile(File file, int n, int n2, boolean bl) throws IOException, GLException {
        Screenshot.writeToFile(file, 0, 0, n, n2, bl);
    }

    public static void writeToFile(File file, int n, int n2, int n3, int n4, boolean bl) throws IOException, GLException {
        BufferedImage bufferedImage;
        String string = FileUtil.getFileSuffix(file);
        if (bl && (string.equals("jpg") || string.equals("jpeg"))) {
            bl = false;
        }
        if (!ImageIO.write((RenderedImage)(bufferedImage = Screenshot.readToBufferedImage(n, n2, n3, n4, bl)), string, file)) {
            throw new IOException("Unsupported file format " + string);
        }
    }

    private static int glGetInteger(GL gL, int n, int[] nArray) {
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    private static void checkExtABGR() {
        GL gL = GLU.getCurrentGL();
        if (!gL.isExtensionAvailable("GL_EXT_abgr")) {
            throw new IllegalArgumentException("Saving alpha channel requires GL_EXT_abgr");
        }
    }

    static class PixelStorageModes {
        int packAlignment;
        int packRowLength;
        int packSkipRows;
        int packSkipPixels;
        int packSwapBytes;
        int[] tmp = new int[1];

        PixelStorageModes() {
        }

        void save(GL gL) {
            this.packAlignment = Screenshot.glGetInteger(gL, 3333, this.tmp);
            this.packRowLength = Screenshot.glGetInteger(gL, 3330, this.tmp);
            this.packSkipRows = Screenshot.glGetInteger(gL, 3331, this.tmp);
            this.packSkipPixels = Screenshot.glGetInteger(gL, 3332, this.tmp);
            this.packSwapBytes = Screenshot.glGetInteger(gL, 3328, this.tmp);
            gL.glPixelStorei(3333, 1);
            gL.glPixelStorei(3330, 0);
            gL.glPixelStorei(3331, 0);
            gL.glPixelStorei(3332, 0);
            gL.glPixelStorei(3328, 0);
        }

        void restore(GL gL) {
            gL.glPixelStorei(3333, this.packAlignment);
            gL.glPixelStorei(3330, this.packRowLength);
            gL.glPixelStorei(3331, this.packSkipRows);
            gL.glPixelStorei(3332, this.packSkipPixels);
            gL.glPixelStorei(3328, this.packSwapBytes);
        }
    }
}

