
/*
 * ==== FILE AUTOGENERATED FROM .idl FILES UNDER THE FOLLOWING LICENSE ====
 *
 * Copyright (C) 2008 Apple Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Counter
 */
function Counter() { return ; }

Counter.prototype.identifier = '';

Counter.prototype.listStyle = '';

Counter.prototype.separator = '';

/*
 * CSSCharsetRule
 */
function CSSCharsetRule() { return ; }
CSSCharsetRule.prototype = CSSRule;

CSSCharsetRule.prototype.encoding = '';

CSSCharsetRule.prototype.encoding = '';

/*
 * CSSFontFaceRule
 */
function CSSFontFaceRule() { return ; }
CSSFontFaceRule.prototype = CSSRule;

CSSFontFaceRule.prototype.style = new CSSStyleDeclaration();

/*
 * CSSImportRule
 */
function CSSImportRule() { return ; }
CSSImportRule.prototype = CSSRule;

CSSImportRule.prototype.href = '';

CSSImportRule.prototype.media = new MediaList();

CSSImportRule.prototype.styleSheet = new CSSStyleSheet();

/*
 * CSSMediaRule
 */
function CSSMediaRule() { return ; }
CSSMediaRule.prototype = CSSRule;

CSSMediaRule.prototype.media = new MediaList();

CSSMediaRule.prototype.cssRules = new CSSRuleList();

CSSMediaRule.prototype.insertRule = function (rule, index) { return 1; };
CSSMediaRule.prototype.insertRule('', 1);

CSSMediaRule.prototype.deleteRule = function (index) { return ; };
CSSMediaRule.prototype.deleteRule(1);

/*
 * CSSPageRule
 */
function CSSPageRule() { return ; }
CSSPageRule.prototype = CSSRule;

CSSPageRule.prototype.selectorText = '';

CSSPageRule.prototype.style = new CSSStyleDeclaration();

/*
 * CSSPrimitiveValue
 */
function CSSPrimitiveValue() { return ; }
CSSPrimitiveValue.prototype = CSSValue;

CSSPrimitiveValue.prototype.primitiveType = 1;

CSSPrimitiveValue.prototype.setFloatValue = function (unitType, floatValue) { return ; };
CSSPrimitiveValue.prototype.setFloatValue(1, 1.0);

CSSPrimitiveValue.prototype.getFloatValue = function (unitType) { return 1.0; };
CSSPrimitiveValue.prototype.getFloatValue(1);

CSSPrimitiveValue.prototype.setStringValue = function (stringType, stringValue) { return ; };
CSSPrimitiveValue.prototype.setStringValue(1, '');

CSSPrimitiveValue.prototype.getStringValue = function () { return ''; };
CSSPrimitiveValue.prototype.getStringValue();

CSSPrimitiveValue.prototype.getCounterValue = function () { return new Counter(); };
CSSPrimitiveValue.prototype.getCounterValue();

CSSPrimitiveValue.prototype.getRectValue = function () { return new Rect(); };
CSSPrimitiveValue.prototype.getRectValue();

CSSPrimitiveValue.prototype.getRGBColorValue = function () { return new RGBColor(); };
CSSPrimitiveValue.prototype.getRGBColorValue();

/*
 * CSSRule
 */
function CSSRule() { return ; }

CSSRule.prototype.type = 1;

CSSRule.prototype.cssText = '';

CSSRule.prototype.parentStyleSheet = new CSSStyleSheet();

CSSRule.prototype.parentRule = new CSSRule();

/*
 * CSSRuleList
 */
function CSSRuleList() { return ; }

CSSRuleList.prototype.length = 1;

CSSRuleList.prototype.item = function (index) { return new CSSRule(); };
CSSRuleList.prototype.item(1);

/*
 * CSSStyleDeclaration
 */
function CSSStyleDeclaration() { return ; }

CSSStyleDeclaration.prototype.cssText = '';

CSSStyleDeclaration.prototype.getPropertyValue = function (propertyName) { return ''; };
CSSStyleDeclaration.prototype.getPropertyValue('');

CSSStyleDeclaration.prototype.getPropertyCSSValue = function (propertyName) { return new CSSValue(); };
CSSStyleDeclaration.prototype.getPropertyCSSValue('');

CSSStyleDeclaration.prototype.removeProperty = function (propertyName) { return ''; };
CSSStyleDeclaration.prototype.removeProperty('');

CSSStyleDeclaration.prototype.getPropertyPriority = function (propertyName) { return ''; };
CSSStyleDeclaration.prototype.getPropertyPriority('');

CSSStyleDeclaration.prototype.setProperty = function (propertyName, value, priority) { return ; };
CSSStyleDeclaration.prototype.setProperty('', '', '');

CSSStyleDeclaration.prototype.length = 1;

CSSStyleDeclaration.prototype.item = function (index) { return ''; };
CSSStyleDeclaration.prototype.item(1);

CSSStyleDeclaration.prototype.parentRule = new CSSRule();

CSSStyleDeclaration.prototype.getPropertyShorthand = function (propertyName) { return ''; };
CSSStyleDeclaration.prototype.getPropertyShorthand('');

CSSStyleDeclaration.prototype.isPropertyImplicit = function (propertyName) { return true; };
CSSStyleDeclaration.prototype.isPropertyImplicit('');

/*
 * CSSStyleRule
 */
function CSSStyleRule() { return ; }
CSSStyleRule.prototype = CSSRule;

CSSStyleRule.prototype.selectorText = '';

CSSStyleRule.prototype.style = new CSSStyleDeclaration();

/*
 * CSSStyleSheet
 */
function CSSStyleSheet() { return ; }
CSSStyleSheet.prototype = StyleSheet;

CSSStyleSheet.prototype.ownerRule = new CSSRule();

CSSStyleSheet.prototype.cssRules = new CSSRuleList();

CSSStyleSheet.prototype.insertRule = function (rule, index) { return 1; };
CSSStyleSheet.prototype.insertRule('', 1);

CSSStyleSheet.prototype.deleteRule = function (index) { return ; };
CSSStyleSheet.prototype.deleteRule(1);

CSSStyleSheet.prototype.rules = new CSSRuleList();

CSSStyleSheet.prototype.addRule = function (selector, style, index) { return 1; };
CSSStyleSheet.prototype.addRule('', '', 1);

CSSStyleSheet.prototype.removeRule = function (index) { return ; };
CSSStyleSheet.prototype.removeRule(1);

/*
 * CSSUnknownRule
 */
function CSSUnknownRule() { return ; }
CSSUnknownRule.prototype = CSSRule;

/*
 * CSSValue
 */
function CSSValue() { return ; }

CSSValue.prototype.cssText = '';

CSSValue.prototype.cssValueType = 1;

/*
 * CSSValueList
 */
function CSSValueList() { return ; }
CSSValueList.prototype = CSSValue;

CSSValueList.prototype.length = 1;

CSSValueList.prototype.item = function (index) { return new CSSValue(); };
CSSValueList.prototype.item(1);

/*
 * MediaList
 */
function MediaList() { return ; }

MediaList.prototype.mediaText = '';

MediaList.prototype.length = 1;

MediaList.prototype.item = function (index) { return ''; };
MediaList.prototype.item(1);

MediaList.prototype.deleteMedium = function (oldMedium) { return ; };
MediaList.prototype.deleteMedium('');

MediaList.prototype.appendMedium = function (newMedium) { return ; };
MediaList.prototype.appendMedium('');

/*
 * MediaQueryList
 */
function MediaQueryList() { return ; }

MediaQueryList.prototype.media = '';

MediaQueryList.prototype.matches = true;

MediaQueryList.prototype.addListener = function (listener) { return ; };
MediaQueryList.prototype.addListener(new MediaQueryListListener());

MediaQueryList.prototype.removeListener = function (listener) { return ; };
MediaQueryList.prototype.removeListener(new MediaQueryListListener());

/*
 * MediaQueryListListener
 */
function MediaQueryListListener() { return ; }

MediaQueryListListener.prototype.queryChanged = function (list) { return ; };
MediaQueryListListener.prototype.queryChanged(new MediaQueryList());

/*
 * Rect
 */
function Rect() { return ; }

Rect.prototype.top = new CSSPrimitiveValue();

Rect.prototype.right = new CSSPrimitiveValue();

Rect.prototype.bottom = new CSSPrimitiveValue();

Rect.prototype.left = new CSSPrimitiveValue();

/*
 * RGBColor
 */
function RGBColor() { return ; }

RGBColor.prototype.red = new CSSPrimitiveValue();

RGBColor.prototype.green = new CSSPrimitiveValue();

RGBColor.prototype.blue = new CSSPrimitiveValue();

RGBColor.prototype.alpha = new CSSPrimitiveValue();

RGBColor.prototype.color = new Color();

/*
 * StyleMedia
 */
function StyleMedia() { return ; }

StyleMedia.prototype.type = '';

StyleMedia.prototype.matchMedium = function (mediaquery) { return true; };
StyleMedia.prototype.matchMedium('');

/*
 * StyleSheet
 */
function StyleSheet() { return ; }

StyleSheet.prototype.type = '';

StyleSheet.prototype.disabled = true;

StyleSheet.prototype.ownerNode = new Node();

StyleSheet.prototype.parentStyleSheet = new StyleSheet();

StyleSheet.prototype.href = '';

StyleSheet.prototype.title = '';

StyleSheet.prototype.media = new MediaList();

StyleSheet.prototype.isCSSStyleSheet = function () { return true; };
StyleSheet.prototype.isCSSStyleSheet();

/*
 * StyleSheetList
 */
function StyleSheetList() { return ; }

StyleSheetList.prototype.length = 1;

StyleSheetList.prototype.item = function (index) { return new StyleSheet(); };
StyleSheetList.prototype.item(1);

/*
 * WebKitCSSKeyframeRule
 */
function WebKitCSSKeyframeRule() { return ; }
WebKitCSSKeyframeRule.prototype = CSSRule;

WebKitCSSKeyframeRule.prototype.keyText = '';

WebKitCSSKeyframeRule.prototype.style = new CSSStyleDeclaration();

/*
 * WebKitCSSKeyframesRule
 */
function WebKitCSSKeyframesRule() { return ; }
WebKitCSSKeyframesRule.prototype = CSSRule;

WebKitCSSKeyframesRule.prototype.name = '';

WebKitCSSKeyframesRule.prototype.cssRules = new CSSRuleList();

WebKitCSSKeyframesRule.prototype.insertRule = function (rule) { return ; };
WebKitCSSKeyframesRule.prototype.insertRule('');

WebKitCSSKeyframesRule.prototype.deleteRule = function (key) { return ; };
WebKitCSSKeyframesRule.prototype.deleteRule('');

WebKitCSSKeyframesRule.prototype.findRule = function (key) { return new WebKitCSSKeyframeRule(); };
WebKitCSSKeyframesRule.prototype.findRule('');

/*
 * WebKitCSSMatrix
 */
function WebKitCSSMatrix() { return ; }

WebKitCSSMatrix.prototype.a = 1.0;

WebKitCSSMatrix.prototype.b = 1.0;

WebKitCSSMatrix.prototype.c = 1.0;

WebKitCSSMatrix.prototype.d = 1.0;

WebKitCSSMatrix.prototype.e = 1.0;

WebKitCSSMatrix.prototype.f = 1.0;

WebKitCSSMatrix.prototype.m11 = 1.0;

WebKitCSSMatrix.prototype.m12 = 1.0;

WebKitCSSMatrix.prototype.m13 = 1.0;

WebKitCSSMatrix.prototype.m14 = 1.0;

WebKitCSSMatrix.prototype.m21 = 1.0;

WebKitCSSMatrix.prototype.m22 = 1.0;

WebKitCSSMatrix.prototype.m23 = 1.0;

WebKitCSSMatrix.prototype.m24 = 1.0;

WebKitCSSMatrix.prototype.m31 = 1.0;

WebKitCSSMatrix.prototype.m32 = 1.0;

WebKitCSSMatrix.prototype.m33 = 1.0;

WebKitCSSMatrix.prototype.m34 = 1.0;

WebKitCSSMatrix.prototype.m41 = 1.0;

WebKitCSSMatrix.prototype.m42 = 1.0;

WebKitCSSMatrix.prototype.m43 = 1.0;

WebKitCSSMatrix.prototype.m44 = 1.0;

WebKitCSSMatrix.prototype.setMatrixValue = function (string) { return ; };
WebKitCSSMatrix.prototype.setMatrixValue('');

WebKitCSSMatrix.prototype.multiply = function (secondMatrix) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.multiply(new WebKitCSSMatrix());

WebKitCSSMatrix.prototype.inverse = function () { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.inverse();

WebKitCSSMatrix.prototype.translate = function (x, y, z) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.translate(1.0, 1.0, 1.0);

WebKitCSSMatrix.prototype.scale = function (scaleX, scaleY, scaleZ) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.scale(1.0, 1.0, 1.0);

WebKitCSSMatrix.prototype.rotate = function (rotX, rotY, rotZ) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.rotate(1.0, 1.0, 1.0);

WebKitCSSMatrix.prototype.rotateAxisAngle = function (x, y, z, angle) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.rotateAxisAngle(1.0, 1.0, 1.0, 1.0);

WebKitCSSMatrix.prototype.skewX = function (angle) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.skewX(1.0);

WebKitCSSMatrix.prototype.skewY = function (angle) { return new WebKitCSSMatrix(); };
WebKitCSSMatrix.prototype.skewY(1.0);

WebKitCSSMatrix.prototype.toString = function () { return ''; };
WebKitCSSMatrix.prototype.toString();

/*
 * WebKitCSSTransformValue
 */
function WebKitCSSTransformValue() { return ; }
WebKitCSSTransformValue.prototype = CSSValueList;

WebKitCSSTransformValue.prototype.operationType = 1;

/*
 * Attr
 */
function Attr() { return ; }
Attr.prototype = Node;

Attr.prototype.name = '';

Attr.prototype.specified = true;

Attr.prototype.value = '';

Attr.prototype.ownerElement = new Element();

Attr.prototype.isId = true;

Attr.prototype.style = new CSSStyleDeclaration();

/*
 * BeforeLoadEvent
 */
function BeforeLoadEvent() { return ; }
BeforeLoadEvent.prototype = Event;

BeforeLoadEvent.prototype.initBeforeLoadEvent = function (type, canBubble, cancelable, url) { return ; };
BeforeLoadEvent.prototype.initBeforeLoadEvent('', true, true, '');

BeforeLoadEvent.prototype.url = '';

/*
 * BeforeProcessEvent
 */
function BeforeProcessEvent() { return ; }
BeforeProcessEvent.prototype = Event;

BeforeProcessEvent.prototype.initBeforeProcessEvent = function (type, canBubble, cancelable) { return ; };
BeforeProcessEvent.prototype.initBeforeProcessEvent('', true, true);

BeforeProcessEvent.prototype.text = '';

/*
 * CDATASection
 */
function CDATASection() { return ; }
CDATASection.prototype = Text;

/*
 * CharacterData
 */
function CharacterData() { return ; }
CharacterData.prototype = Node;

CharacterData.prototype.data = '';

CharacterData.prototype.length = 1;

CharacterData.prototype.substringData = function (offset, length) { return ''; };
CharacterData.prototype.substringData(1, 1);

CharacterData.prototype.appendData = function (data) { return ; };
CharacterData.prototype.appendData('');

CharacterData.prototype.insertData = function (offset, data) { return ; };
CharacterData.prototype.insertData(1, '');

CharacterData.prototype.deleteData = function (offset, length) { return ; };
CharacterData.prototype.deleteData(1, 1);

CharacterData.prototype.replaceData = function (offset, length, data) { return ; };
CharacterData.prototype.replaceData(1, 1, '');

/*
 * ClientRect
 */
function ClientRect() { return ; }

ClientRect.prototype.top = 1.0;

ClientRect.prototype.right = 1.0;

ClientRect.prototype.bottom = 1.0;

ClientRect.prototype.left = 1.0;

ClientRect.prototype.width = 1.0;

ClientRect.prototype.height = 1.0;

/*
 * ClientRectList
 */
function ClientRectList() { return ; }

ClientRectList.prototype.length = 1;

ClientRectList.prototype.item = function (index) { return new ClientRect(); };
ClientRectList.prototype.item(1);

/*
 * Clipboard
 */
function Clipboard() { return ; }

Clipboard.prototype.dropEffect = '';

Clipboard.prototype.effectAllowed = '';

Clipboard.prototype.types = [];

Clipboard.prototype.files = new FileList();

Clipboard.prototype.clearData = function (type) { return ; };
Clipboard.prototype.clearData('');

Clipboard.prototype.getData = function (type) { return ; };
Clipboard.prototype.getData('');

Clipboard.prototype.setData = function (type, data) { return true; };
Clipboard.prototype.setData('', '');

Clipboard.prototype.setDragImage = function (image, x, y) { return ; };
Clipboard.prototype.setDragImage(new HTMLImageElement(), 1, 1);

Clipboard.prototype.items = new DataTransferItems();

/*
 * Comment
 */
function Comment() { return ; }
Comment.prototype = CharacterData;

/*
 * CompositionEvent
 */
function CompositionEvent() { return ; }
CompositionEvent.prototype = UIEvent;

CompositionEvent.prototype.data = '';

CompositionEvent.prototype.initCompositionEvent = function (typeArg, canBubbleArg, cancelableArg, viewArg, dataArg) { return ; };
CompositionEvent.prototype.initCompositionEvent('', true, true, new DOMWindow(), '');

/*
 * CustomEvent
 */
function CustomEvent() { return ; }
CustomEvent.prototype = Event;

CustomEvent.prototype.detail = new Object();

CustomEvent.prototype.initCustomEvent = function (typeArg, canBubbleArg, cancelableArg, detailArg) { return ; };
CustomEvent.prototype.initCustomEvent('', true, true, new Object());

/*
 * DataTransferItem
 */
function DataTransferItem() { return ; }

DataTransferItem.prototype.kind = '';

DataTransferItem.prototype.type = '';

DataTransferItem.prototype.getAsString = function (callback) { return ; };
DataTransferItem.prototype.getAsString(function(){});

DataTransferItem.prototype.getAsFile = function () { return new Blob(); };
DataTransferItem.prototype.getAsFile();

/*
 * DataTransferItems
 */
function DataTransferItems() { return ; }

DataTransferItems.prototype.length = 1;

DataTransferItems.prototype.item = function (index) { return new DataTransferItem(); };
DataTransferItems.prototype.item(1);

DataTransferItems.prototype.clear = function () { return ; };
DataTransferItems.prototype.clear();

DataTransferItems.prototype.add = function (data, type) { return ; };
DataTransferItems.prototype.add('', '');

/*
 * DeviceMotionEvent
 */
function DeviceMotionEvent() { return ; }
DeviceMotionEvent.prototype = Event;

DeviceMotionEvent.prototype.acceleration = new Acceleration();

DeviceMotionEvent.prototype.accelerationIncludingGravity = new Acceleration();

DeviceMotionEvent.prototype.rotationRate = new RotationRate();

DeviceMotionEvent.prototype.interval = 1.0;

DeviceMotionEvent.prototype.initDeviceMotionEvent = function (type, bubbles, cancelable, acceleration, accelerationIncludingGravity, rotationRate, interval) { return ; };
DeviceMotionEvent.prototype.initDeviceMotionEvent('', true, true, new Acceleration(), new Acceleration(), new RotationRate(), 1.0);

/*
 * DeviceOrientationEvent
 */
function DeviceOrientationEvent() { return ; }
DeviceOrientationEvent.prototype = Event;

DeviceOrientationEvent.prototype.alpha = 1.0;

DeviceOrientationEvent.prototype.beta = 1.0;

DeviceOrientationEvent.prototype.gamma = 1.0;

DeviceOrientationEvent.prototype.initDeviceOrientationEvent = function (type, bubbles, cancelable, alpha, beta, gamma) { return ; };
DeviceOrientationEvent.prototype.initDeviceOrientationEvent('', true, true, 1.0, 1.0, 1.0);

/*
 * DocumentFragment
 */
function DocumentFragment() { return ; }
DocumentFragment.prototype = Node;

DocumentFragment.prototype.querySelector = function (selectors) { return new Element(); };
DocumentFragment.prototype.querySelector('');

DocumentFragment.prototype.querySelectorAll = function (selectors) { return new NodeList(); };
DocumentFragment.prototype.querySelectorAll('');

/*
 * Document
 */
function Document() { return ; }
Document.prototype = Node;

Document.prototype.doctype = new DocumentType();

Document.prototype.implementation = new DOMImplementation();

Document.prototype.documentElement = new Element();

Document.prototype.createElement = function (tagName) { return new Element(); };
Document.prototype.createElement('');

Document.prototype.createDocumentFragment = function () { return new DocumentFragment(); };
Document.prototype.createDocumentFragment();

Document.prototype.createTextNode = function (data) { return new Text(); };
Document.prototype.createTextNode('');

Document.prototype.createComment = function (data) { return new Comment(); };
Document.prototype.createComment('');

Document.prototype.createCDATASection = function (data) { return new CDATASection(); };
Document.prototype.createCDATASection('');

Document.prototype.createProcessingInstruction = function (target, data) { return new ProcessingInstruction(); };
Document.prototype.createProcessingInstruction('', '');

Document.prototype.createAttribute = function (name) { return new Attr(); };
Document.prototype.createAttribute('');

Document.prototype.createEntityReference = function (name) { return new EntityReference(); };
Document.prototype.createEntityReference('');

Document.prototype.getElementsByTagName = function (tagname) { return new NodeList(); };
Document.prototype.getElementsByTagName('');

Document.prototype.importNode = function (importedNode, deep) { return new Node(); };
Document.prototype.importNode(new Node(), true);

Document.prototype.createElementNS = function (namespaceURI, qualifiedName) { return new Element(); };
Document.prototype.createElementNS('', '');

Document.prototype.createAttributeNS = function (namespaceURI, qualifiedName) { return new Attr(); };
Document.prototype.createAttributeNS('', '');

Document.prototype.getElementsByTagNameNS = function (namespaceURI, localName) { return new NodeList(); };
Document.prototype.getElementsByTagNameNS('', '');

Document.prototype.getElementById = function (elementId) { return new Element(); };
Document.prototype.getElementById('');

Document.prototype.inputEncoding = '';

Document.prototype.xmlEncoding = '';

Document.prototype.xmlVersion = '';

Document.prototype.xmlStandalone = true;

Document.prototype.adoptNode = function (source) { return new Node(); };
Document.prototype.adoptNode(new Node());

Document.prototype.documentURI = '';

Document.prototype.createEvent = function (eventType) { return new Event(); };
Document.prototype.createEvent('');

Document.prototype.createRange = function () { return new Range(); };
Document.prototype.createRange();

Document.prototype.createNodeIterator = function (root, whatToShow, filter, expandEntityReferences) { return new NodeIterator(); };
Document.prototype.createNodeIterator(new Node(), 1, new NodeFilter(), true);

Document.prototype.createTreeWalker = function (root, whatToShow, filter, expandEntityReferences) { return new TreeWalker(); };
Document.prototype.createTreeWalker(new Node(), 1, new NodeFilter(), true);

Document.prototype.defaultView = new DOMWindow();

Document.prototype.styleSheets = new StyleSheetList();

Document.prototype.getOverrideStyle = function (element, pseudoElement) { return new CSSStyleDeclaration(); };
Document.prototype.getOverrideStyle(new Element(), '');

Document.prototype.createExpression = function (expression, resolver) { return new XPathExpression(); };
Document.prototype.createExpression('', new XPathNSResolver());

Document.prototype.createNSResolver = function (nodeResolver) { return new XPathNSResolver(); };
Document.prototype.createNSResolver(new Node());

Document.prototype.evaluate = function (expression, contextNode, resolver, type, inResult) { return new XPathResult(); };
Document.prototype.evaluate('', new Node(), new XPathNSResolver(), 1, new XPathResult());

Document.prototype.execCommand = function (command, userInterface, value) { return true; };
Document.prototype.execCommand('', true, '');

Document.prototype.execCommand = function (command, userInterface) { return true; };
Document.prototype.execCommand('', true);

Document.prototype.execCommand = function (command) { return true; };
Document.prototype.execCommand('');

Document.prototype.queryCommandEnabled = function (command) { return true; };
Document.prototype.queryCommandEnabled('');

Document.prototype.queryCommandIndeterm = function (command) { return true; };
Document.prototype.queryCommandIndeterm('');

Document.prototype.queryCommandState = function (command) { return true; };
Document.prototype.queryCommandState('');

Document.prototype.queryCommandSupported = function (command) { return true; };
Document.prototype.queryCommandSupported('');

Document.prototype.queryCommandValue = function (command) { return ''; };
Document.prototype.queryCommandValue('');

Document.prototype.title = '';

Document.prototype.referrer = '';

Document.prototype.domain = '';

Document.prototype.domain = '';

Document.prototype.URL = '';

Document.prototype.cookie = '';

Document.prototype.body = new HTMLElement();

Document.prototype.head = new HTMLHeadElement();

Document.prototype.images = new HTMLCollection();

Document.prototype.applets = new HTMLCollection();

Document.prototype.links = new HTMLCollection();

Document.prototype.forms = new HTMLCollection();

Document.prototype.anchors = new HTMLCollection();

Document.prototype.lastModified = '';

Document.prototype.getElementsByName = function (elementName) { return new NodeList(); };
Document.prototype.getElementsByName('');

Document.prototype.location = new Location();

Document.prototype.charset = '';

Document.prototype.defaultCharset = '';

Document.prototype.readyState = '';

Document.prototype.elementFromPoint = function (x, y) { return new Element(); };
Document.prototype.elementFromPoint(1, 1);

Document.prototype.caretRangeFromPoint = function (x, y) { return new Range(); };
Document.prototype.caretRangeFromPoint(1, 1);

Document.prototype.getSelection = function () { return new DOMSelection(); };
Document.prototype.getSelection();

Document.prototype.characterSet = '';

Document.prototype.preferredStylesheetSet = '';

Document.prototype.selectedStylesheetSet = '';

Document.prototype.createCSSStyleDeclaration = function () { return new CSSStyleDeclaration(); };
Document.prototype.createCSSStyleDeclaration();

Document.prototype.getComputedStyle = function (element, pseudoElement) { return new CSSStyleDeclaration(); };
Document.prototype.getComputedStyle(new Element(), '');

Document.prototype.getMatchedCSSRules = function (element, pseudoElement) { return new CSSRuleList(); };
Document.prototype.getMatchedCSSRules(new Element(), '');

Document.prototype.getMatchedCSSRules = function (element, pseudoElement, authorOnly) { return new CSSRuleList(); };
Document.prototype.getMatchedCSSRules(new Element(), '', true);

Document.prototype.getCSSCanvasContext = function (contextId, name, width, height) { return new Object(); };
Document.prototype.getCSSCanvasContext('', '', 1, 1);

Document.prototype.getElementsByClassName = function (tagname) { return new NodeList(); };
Document.prototype.getElementsByClassName('');

Document.prototype.compatMode = '';

Document.prototype.querySelector = function (selectors) { return new Element(); };
Document.prototype.querySelector('');

Document.prototype.querySelectorAll = function (selectors) { return new NodeList(); };
Document.prototype.querySelectorAll('');

Document.prototype.webkitIsFullScreen = true;

Document.prototype.webkitFullScreenKeyboardInputAllowed = true;

Document.prototype.webkitCurrentFullScreenElement = new Element();

Document.prototype.webkitCancelFullScreen = function () { return ; };
Document.prototype.webkitCancelFullScreen();

Document.prototype.onabort = new EventListener();

Document.prototype.onblur = new EventListener();

Document.prototype.onchange = new EventListener();

Document.prototype.onclick = new EventListener();

Document.prototype.oncontextmenu = new EventListener();

Document.prototype.ondblclick = new EventListener();

Document.prototype.ondrag = new EventListener();

Document.prototype.ondragend = new EventListener();

Document.prototype.ondragenter = new EventListener();

Document.prototype.ondragleave = new EventListener();

Document.prototype.ondragover = new EventListener();

Document.prototype.ondragstart = new EventListener();

Document.prototype.ondrop = new EventListener();

Document.prototype.onerror = new EventListener();

Document.prototype.onfocus = new EventListener();

Document.prototype.oninput = new EventListener();

Document.prototype.oninvalid = new EventListener();

Document.prototype.onkeydown = new EventListener();

Document.prototype.onkeypress = new EventListener();

Document.prototype.onkeyup = new EventListener();

Document.prototype.onload = new EventListener();

Document.prototype.onmousedown = new EventListener();

Document.prototype.onmousemove = new EventListener();

Document.prototype.onmouseout = new EventListener();

Document.prototype.onmouseover = new EventListener();

Document.prototype.onmouseup = new EventListener();

Document.prototype.onmousewheel = new EventListener();

Document.prototype.onreadystatechange = new EventListener();

Document.prototype.onscroll = new EventListener();

Document.prototype.onselect = new EventListener();

Document.prototype.onsubmit = new EventListener();

Document.prototype.onbeforecut = new EventListener();

Document.prototype.oncut = new EventListener();

Document.prototype.onbeforecopy = new EventListener();

Document.prototype.oncopy = new EventListener();

Document.prototype.onbeforepaste = new EventListener();

Document.prototype.onpaste = new EventListener();

Document.prototype.onreset = new EventListener();

Document.prototype.onsearch = new EventListener();

Document.prototype.onselectstart = new EventListener();

Document.prototype.onselectionchange = new EventListener();

Document.prototype.ontouchstart = new EventListener();

Document.prototype.ontouchmove = new EventListener();

Document.prototype.ontouchend = new EventListener();

Document.prototype.ontouchcancel = new EventListener();

Document.prototype.onwebkitfullscreenchange = new EventListener();

Document.prototype.createTouch = function (window, target, identifier, pageX, pageY, ScreenX, screenY) { return new Touch(); };
Document.prototype.createTouch(new DOMWindow(), new EventTarget(), 1, 1, 1, 1, 1);

Document.prototype.createTouchList = function () { return new TouchList(); };
Document.prototype.createTouchList();

Document.prototype.isHTMLDocument = function () { return true; };
Document.prototype.isHTMLDocument();

/*
 * DocumentType
 */
function DocumentType() { return ; }
DocumentType.prototype = Node;

DocumentType.prototype.name = '';

DocumentType.prototype.entities = new NamedNodeMap();

DocumentType.prototype.notations = new NamedNodeMap();

DocumentType.prototype.publicId = '';

DocumentType.prototype.systemId = '';

DocumentType.prototype.internalSubset = '';

/*
 * DOMCoreException
 */
function DOMCoreException() { return ; }

DOMCoreException.prototype.code = 1;

DOMCoreException.prototype.name = '';

DOMCoreException.prototype.message = '';

DOMCoreException.prototype.toString = function () { return ''; };
DOMCoreException.prototype.toString();

/*
 * DOMFormData
 */
function DOMFormData() { return ; }

DOMFormData.prototype.append = function (name, value) { return ; };
DOMFormData.prototype.append('', '');

/*
 * DOMImplementation
 */
function DOMImplementation() { return ; }

DOMImplementation.prototype.hasFeature = function (feature, version) { return true; };
DOMImplementation.prototype.hasFeature('', '');

DOMImplementation.prototype.createDocumentType = function (qualifiedName, publicId, systemId) { return new DocumentType(); };
DOMImplementation.prototype.createDocumentType('', '', '');

DOMImplementation.prototype.createDocument = function (namespaceURI, qualifiedName, doctype) { return new Document(); };
DOMImplementation.prototype.createDocument('', '', new DocumentType());

DOMImplementation.prototype.createCSSStyleSheet = function (title, media) { return new CSSStyleSheet(); };
DOMImplementation.prototype.createCSSStyleSheet('', '');

DOMImplementation.prototype.createHTMLDocument = function (title) { return new HTMLDocument(); };
DOMImplementation.prototype.createHTMLDocument('');

/*
 * DOMSettableTokenList
 */
function DOMSettableTokenList() { return ; }
DOMSettableTokenList.prototype = DOMTokenList;

DOMSettableTokenList.prototype.value = '';

/*
 * DOMStringList
 */
function DOMStringList() { return ; }

DOMStringList.prototype.length = 1;

DOMStringList.prototype.item = function (index) { return ''; };
DOMStringList.prototype.item(1);

DOMStringList.prototype.contains = function (string) { return true; };
DOMStringList.prototype.contains('');

/*
 * DOMStringMap
 */
function DOMStringMap() { return ; }

/*
 * DOMTokenList
 */
function DOMTokenList() { return ; }

DOMTokenList.prototype.length = 1;

DOMTokenList.prototype.item = function (index) { return ''; };
DOMTokenList.prototype.item(1);

DOMTokenList.prototype.contains = function (token) { return true; };
DOMTokenList.prototype.contains('');

DOMTokenList.prototype.add = function (token) { return ; };
DOMTokenList.prototype.add('');

DOMTokenList.prototype.remove = function (token) { return ; };
DOMTokenList.prototype.remove('');

DOMTokenList.prototype.toggle = function (token) { return true; };
DOMTokenList.prototype.toggle('');

DOMTokenList.prototype.toString = function () { return ''; };
DOMTokenList.prototype.toString();

/*
 * DOMURL
 */
function DOMURL() { return ; }

DOMURL.prototype.createObjectURL = function (blob) { return ''; };
DOMURL.prototype.createObjectURL(new Blob());

DOMURL.prototype.revokeObjectURL = function (url) { return ; };
DOMURL.prototype.revokeObjectURL('');

/*
 * Element
 */
function Element() { return ; }
Element.prototype = Node;

Element.prototype.tagName = '';

Element.prototype.getAttribute = function (name) { return ''; };
Element.prototype.getAttribute('');

Element.prototype.setAttribute = function (name, value) { return ; };
Element.prototype.setAttribute('', '');

Element.prototype.removeAttribute = function (name) { return ; };
Element.prototype.removeAttribute('');

Element.prototype.getAttributeNode = function (name) { return new Attr(); };
Element.prototype.getAttributeNode('');

Element.prototype.setAttributeNode = function (newAttr) { return new Attr(); };
Element.prototype.setAttributeNode(new Attr());

Element.prototype.removeAttributeNode = function (oldAttr) { return new Attr(); };
Element.prototype.removeAttributeNode(new Attr());

Element.prototype.getElementsByTagName = function (name) { return new NodeList(); };
Element.prototype.getElementsByTagName('');

Element.prototype.getAttributeNS = function (namespaceURI, localName) { return ''; };
Element.prototype.getAttributeNS('', '');

Element.prototype.setAttributeNS = function (namespaceURI, qualifiedName, value) { return ; };
Element.prototype.setAttributeNS('', '', '');

Element.prototype.removeAttributeNS = function (namespaceURI, localName) { return ; };
Element.prototype.removeAttributeNS('', '');

Element.prototype.getElementsByTagNameNS = function (namespaceURI, localName) { return new NodeList(); };
Element.prototype.getElementsByTagNameNS('', '');

Element.prototype.getAttributeNodeNS = function (namespaceURI, localName) { return new Attr(); };
Element.prototype.getAttributeNodeNS('', '');

Element.prototype.setAttributeNodeNS = function (newAttr) { return new Attr(); };
Element.prototype.setAttributeNodeNS(new Attr());

Element.prototype.hasAttribute = function (name) { return true; };
Element.prototype.hasAttribute('');

Element.prototype.hasAttributeNS = function (namespaceURI, localName) { return true; };
Element.prototype.hasAttributeNS('', '');

Element.prototype.style = new CSSStyleDeclaration();

Element.prototype.offsetLeft = 1;

Element.prototype.offsetTop = 1;

Element.prototype.offsetWidth = 1;

Element.prototype.offsetHeight = 1;

Element.prototype.offsetParent = new Element();

Element.prototype.clientLeft = 1;

Element.prototype.clientTop = 1;

Element.prototype.clientWidth = 1;

Element.prototype.clientHeight = 1;

Element.prototype.scrollLeft = 1;

Element.prototype.scrollTop = 1;

Element.prototype.scrollWidth = 1;

Element.prototype.scrollHeight = 1;

Element.prototype.focus = function () { return ; };
Element.prototype.focus();

Element.prototype.blur = function () { return ; };
Element.prototype.blur();

Element.prototype.scrollIntoView = function (alignWithTop) { return ; };
Element.prototype.scrollIntoView(true);

Element.prototype.contains = function (element) { return true; };
Element.prototype.contains(new Element());

Element.prototype.scrollIntoViewIfNeeded = function (centerIfNeeded) { return ; };
Element.prototype.scrollIntoViewIfNeeded(true);

Element.prototype.scrollByLines = function (lines) { return ; };
Element.prototype.scrollByLines(1);

Element.prototype.scrollByPages = function (pages) { return ; };
Element.prototype.scrollByPages(1);

Element.prototype.webkitGetAnimations = function () { return new WebKitAnimationList(); };
Element.prototype.webkitGetAnimations();

Element.prototype.getElementsByClassName = function (name) { return new NodeList(); };
Element.prototype.getElementsByClassName('');

Element.prototype.dataset = new DOMStringMap();

Element.prototype.querySelector = function (selectors) { return new Element(); };
Element.prototype.querySelector('');

Element.prototype.querySelectorAll = function (selectors) { return new NodeList(); };
Element.prototype.querySelectorAll('');

Element.prototype.webkitMatchesSelector = function (selectors) { return true; };
Element.prototype.webkitMatchesSelector('');

Element.prototype.firstElementChild = new Element();

Element.prototype.lastElementChild = new Element();

Element.prototype.previousElementSibling = new Element();

Element.prototype.nextElementSibling = new Element();

Element.prototype.childElementCount = 1;

Element.prototype.getClientRects = function () { return new ClientRectList(); };
Element.prototype.getClientRects();

Element.prototype.getBoundingClientRect = function () { return new ClientRect(); };
Element.prototype.getBoundingClientRect();

Element.prototype.innerText = '';

Element.prototype.webkitRequestFullScreen = function (flags) { return ; };
Element.prototype.webkitRequestFullScreen(1);

Element.prototype.onabort = new EventListener();

Element.prototype.onblur = new EventListener();

Element.prototype.onchange = new EventListener();

Element.prototype.onclick = new EventListener();

Element.prototype.oncontextmenu = new EventListener();

Element.prototype.ondblclick = new EventListener();

Element.prototype.ondrag = new EventListener();

Element.prototype.ondragend = new EventListener();

Element.prototype.ondragenter = new EventListener();

Element.prototype.ondragleave = new EventListener();

Element.prototype.ondragover = new EventListener();

Element.prototype.ondragstart = new EventListener();

Element.prototype.ondrop = new EventListener();

Element.prototype.onerror = new EventListener();

Element.prototype.onfocus = new EventListener();

Element.prototype.oninput = new EventListener();

Element.prototype.oninvalid = new EventListener();

Element.prototype.onkeydown = new EventListener();

Element.prototype.onkeypress = new EventListener();

Element.prototype.onkeyup = new EventListener();

Element.prototype.onload = new EventListener();

Element.prototype.onmousedown = new EventListener();

Element.prototype.onmousemove = new EventListener();

Element.prototype.onmouseout = new EventListener();

Element.prototype.onmouseover = new EventListener();

Element.prototype.onmouseup = new EventListener();

Element.prototype.onmousewheel = new EventListener();

Element.prototype.onscroll = new EventListener();

Element.prototype.onselect = new EventListener();

Element.prototype.onsubmit = new EventListener();

Element.prototype.onbeforecut = new EventListener();

Element.prototype.oncut = new EventListener();

Element.prototype.onbeforecopy = new EventListener();

Element.prototype.oncopy = new EventListener();

Element.prototype.onbeforepaste = new EventListener();

Element.prototype.onpaste = new EventListener();

Element.prototype.onreset = new EventListener();

Element.prototype.onsearch = new EventListener();

Element.prototype.onselectstart = new EventListener();

Element.prototype.ontouchstart = new EventListener();

Element.prototype.ontouchmove = new EventListener();

Element.prototype.ontouchend = new EventListener();

Element.prototype.ontouchcancel = new EventListener();

Element.prototype.onwebkitfullscreenchange = new EventListener();

/*
 * Entity
 */
function Entity() { return ; }
Entity.prototype = Node;

Entity.prototype.publicId = '';

Entity.prototype.systemId = '';

Entity.prototype.notationName = '';

/*
 * EntityReference
 */
function EntityReference() { return ; }
EntityReference.prototype = Node;

/*
 * ErrorEvent
 */
function ErrorEvent() { return ; }
ErrorEvent.prototype = Event;

ErrorEvent.prototype.message = '';

ErrorEvent.prototype.filename = '';

ErrorEvent.prototype.lineno = 1;

ErrorEvent.prototype.initErrorEvent = function (typeArg, canBubbleArg, cancelableArg, messageArg, filenameArg, linenoArg) { return ; };
ErrorEvent.prototype.initErrorEvent('', true, true, '', '', 1);

/*
 * EventException
 */
function EventException() { return ; }

EventException.prototype.code = 1;

EventException.prototype.name = '';

EventException.prototype.message = '';

EventException.prototype.toString = function () { return ''; };
EventException.prototype.toString();

/*
 * Event
 */
function Event() { return ; }

Event.prototype.type = '';

Event.prototype.target = new EventTarget();

Event.prototype.currentTarget = new EventTarget();

Event.prototype.eventPhase = 1;

Event.prototype.bubbles = true;

Event.prototype.cancelable = true;

Event.prototype.timeStamp = new Date();

Event.prototype.stopPropagation = function () { return ; };
Event.prototype.stopPropagation();

Event.prototype.preventDefault = function () { return ; };
Event.prototype.preventDefault();

Event.prototype.initEvent = function (eventTypeArg, canBubbleArg, cancelableArg) { return ; };
Event.prototype.initEvent('', true, true);

Event.prototype.defaultPrevented = true;

Event.prototype.stopImmediatePropagation = function () { return ; };
Event.prototype.stopImmediatePropagation();

Event.prototype.srcElement = new EventTarget();

Event.prototype.returnValue = true;

Event.prototype.cancelBubble = true;

Event.prototype.clipboardData = new Clipboard();

Event.prototype.isMutationEvent = function () { return true; };
Event.prototype.isMutationEvent();

Event.prototype.isMouseEvent = function () { return true; };
Event.prototype.isMouseEvent();

Event.prototype.isUIEvent = function () { return true; };
Event.prototype.isUIEvent();

/*
 * EventListener
 */
function EventListener() { return ; }

EventListener.prototype.handleEvent = function (evt) { return ; };
EventListener.prototype.handleEvent(new Event());

/*
 * EventTarget
 */
function EventTarget() { return ; }

EventTarget.prototype.addEventListener = function (type, listener, useCapture) { return ; };
EventTarget.prototype.addEventListener('', new EventListener(), true);

EventTarget.prototype.removeEventListener = function (type, listener, useCapture) { return ; };
EventTarget.prototype.removeEventListener('', new EventListener(), true);

EventTarget.prototype.dispatchEvent = function (event) { return true; };
EventTarget.prototype.dispatchEvent(new Event());

/*
 * HashChangeEvent
 */
function HashChangeEvent() { return ; }
HashChangeEvent.prototype = Event;

HashChangeEvent.prototype.initHashChangeEvent = function (type, canBubble, cancelable, oldURL, newURL) { return ; };
HashChangeEvent.prototype.initHashChangeEvent('', true, true, '', '');

HashChangeEvent.prototype.oldURL = '';

HashChangeEvent.prototype.newURL = '';

/*
 * KeyboardEvent
 */
function KeyboardEvent() { return ; }
KeyboardEvent.prototype = UIEvent;

KeyboardEvent.prototype.keyIdentifier = '';

KeyboardEvent.prototype.keyLocation = 1;

KeyboardEvent.prototype.ctrlKey = true;

KeyboardEvent.prototype.shiftKey = true;

KeyboardEvent.prototype.altKey = true;

KeyboardEvent.prototype.metaKey = true;

KeyboardEvent.prototype.altGraphKey = true;

KeyboardEvent.prototype.getModifierState = function (keyIdentifierArg) { return true; };
KeyboardEvent.prototype.getModifierState('');

KeyboardEvent.prototype.initKeyboardEvent = function (type, canBubble, cancelable, view, keyIdentifier, keyLocation, ctrlKey, altKey, shiftKey, metaKey, altGraphKey) { return ; };
KeyboardEvent.prototype.initKeyboardEvent('', true, true, new DOMWindow(), '', 1, true, true, true, true, true);

KeyboardEvent.prototype.keyCode = 1;

KeyboardEvent.prototype.charCode = 1;

KeyboardEvent.prototype.initKeyboardEvent = function (type, canBubble, cancelable, view, keyIdentifier, keyLocation, ctrlKey, altKey, shiftKey, metaKey) { return ; };
KeyboardEvent.prototype.initKeyboardEvent('', true, true, new DOMWindow(), '', 1, true, true, true, true);

/*
 * MessageChannel
 */
function MessageChannel() { return ; }

MessageChannel.prototype.port1 = new MessagePort();

MessageChannel.prototype.port2 = new MessagePort();

/*
 * MessageEvent
 */
function MessageEvent() { return ; }
MessageEvent.prototype = Event;

MessageEvent.prototype.data = new SerializedScriptValue();

MessageEvent.prototype.origin = '';

MessageEvent.prototype.lastEventId = '';

MessageEvent.prototype.source = new DOMWindow();

MessageEvent.prototype.ports = [];

MessageEvent.prototype.initMessageEvent = function (typeArg, canBubbleArg, cancelableArg, dataArg, originArg, lastEventIdArg, sourceArg, messagePorts) { return ; };
MessageEvent.prototype.initMessageEvent('', true, true, new SerializedScriptValue(), '', '', new DOMWindow(), []);

MessageEvent.prototype.messagePort = new MessagePort();

MessageEvent.prototype.initMessageEvent = function (typeArg, canBubbleArg, cancelableArg, dataArg, originArg, lastEventIdArg, sourceArg, messagePort) { return ; };
MessageEvent.prototype.initMessageEvent('', true, true, new SerializedScriptValue(), '', '', new DOMWindow(), new MessagePort());

/*
 * MessagePort
 */
function MessagePort() { return ; }

MessagePort.prototype.postMessage = function (message, messagePorts) { return ; };
MessagePort.prototype.postMessage('', []);

MessagePort.prototype.start = function () { return ; };
MessagePort.prototype.start();

MessagePort.prototype.close = function () { return ; };
MessagePort.prototype.close();

MessagePort.prototype.onmessage = new EventListener();

MessagePort.prototype.addEventListener = function (type, listener, useCapture) { return ; };
MessagePort.prototype.addEventListener('', new EventListener(), true);

MessagePort.prototype.removeEventListener = function (type, listener, useCapture) { return ; };
MessagePort.prototype.removeEventListener('', new EventListener(), true);

MessagePort.prototype.dispatchEvent = function (evt) { return true; };
MessagePort.prototype.dispatchEvent(new Event());

/*
 * MouseEvent
 */
function MouseEvent() { return ; }
MouseEvent.prototype = UIEvent;

MouseEvent.prototype.screenX = 1;

MouseEvent.prototype.screenY = 1;

MouseEvent.prototype.clientX = 1;

MouseEvent.prototype.clientY = 1;

MouseEvent.prototype.ctrlKey = true;

MouseEvent.prototype.shiftKey = true;

MouseEvent.prototype.altKey = true;

MouseEvent.prototype.metaKey = true;

MouseEvent.prototype.button = 1;

MouseEvent.prototype.relatedTarget = new EventTarget();

MouseEvent.prototype.initMouseEvent = function (type, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget) { return ; };
MouseEvent.prototype.initMouseEvent('', true, true, new DOMWindow(), 1, 1, 1, 1, 1, true, true, true, true, 1, new EventTarget());

MouseEvent.prototype.offsetX = 1;

MouseEvent.prototype.offsetY = 1;

MouseEvent.prototype.x = 1;

MouseEvent.prototype.y = 1;

MouseEvent.prototype.fromElement = new Node();

MouseEvent.prototype.toElement = new Node();

MouseEvent.prototype.dataTransfer = new Clipboard();

/*
 * MutationEvent
 */
function MutationEvent() { return ; }
MutationEvent.prototype = Event;

MutationEvent.prototype.relatedNode = new Node();

MutationEvent.prototype.prevValue = '';

MutationEvent.prototype.newValue = '';

MutationEvent.prototype.attrName = '';

MutationEvent.prototype.attrChange = 1;

MutationEvent.prototype.initMutationEvent = function (type, canBubble, cancelable, relatedNode, prevValue, newValue, attrName, attrChange) { return ; };
MutationEvent.prototype.initMutationEvent('', true, true, new Node(), '', '', '', 1);

/*
 * NamedNodeMap
 */
function NamedNodeMap() { return ; }

NamedNodeMap.prototype.getNamedItem = function (name) { return new Node(); };
NamedNodeMap.prototype.getNamedItem('');

NamedNodeMap.prototype.setNamedItem = function (node) { return new Node(); };
NamedNodeMap.prototype.setNamedItem(new Node());

NamedNodeMap.prototype.removeNamedItem = function (name) { return new Node(); };
NamedNodeMap.prototype.removeNamedItem('');

NamedNodeMap.prototype.item = function (index) { return new Node(); };
NamedNodeMap.prototype.item(1);

NamedNodeMap.prototype.length = 1;

NamedNodeMap.prototype.getNamedItemNS = function (namespaceURI, localName) { return new Node(); };
NamedNodeMap.prototype.getNamedItemNS('', '');

NamedNodeMap.prototype.setNamedItemNS = function (node) { return new Node(); };
NamedNodeMap.prototype.setNamedItemNS(new Node());

NamedNodeMap.prototype.removeNamedItemNS = function (namespaceURI, localName) { return new Node(); };
NamedNodeMap.prototype.removeNamedItemNS('', '');

/*
 * NodeFilter
 */
function NodeFilter() { return ; }

NodeFilter.prototype.acceptNode = function (n) { return 1; };
NodeFilter.prototype.acceptNode(new Node());

/*
 * Node
 */
function Node() { return ; }
Node.prototype = Object;

Node.prototype.nodeName = '';

Node.prototype.nodeValue = '';

Node.prototype.nodeType = 1;

Node.prototype.parentNode = new Node();

Node.prototype.childNodes = new NodeList();

Node.prototype.firstChild = new Node();

Node.prototype.lastChild = new Node();

Node.prototype.previousSibling = new Node();

Node.prototype.nextSibling = new Node();

Node.prototype.attributes = new NamedNodeMap();

Node.prototype.ownerDocument = new Document();

Node.prototype.insertBefore = function (newChild, refChild) { return new Node(); };
Node.prototype.insertBefore(new Node(), new Node());

Node.prototype.replaceChild = function (newChild, oldChild) { return new Node(); };
Node.prototype.replaceChild(new Node(), new Node());

Node.prototype.removeChild = function (oldChild) { return new Node(); };
Node.prototype.removeChild(new Node());

Node.prototype.appendChild = function (newChild) { return new Node(); };
Node.prototype.appendChild(new Node());

Node.prototype.hasChildNodes = function () { return true; };
Node.prototype.hasChildNodes();

Node.prototype.cloneNode = function (deep) { return new Node(); };
Node.prototype.cloneNode(true);

Node.prototype.normalize = function () { return ; };
Node.prototype.normalize();

Node.prototype.isSupported = function (feature, version) { return true; };
Node.prototype.isSupported('', '');

Node.prototype.namespaceURI = '';

Node.prototype.prefix = '';

Node.prototype.localName = '';

Node.prototype.hasAttributes = function () { return true; };
Node.prototype.hasAttributes();

Node.prototype.baseURI = '';

Node.prototype.textContent = '';

Node.prototype.isSameNode = function (other) { return true; };
Node.prototype.isSameNode(new Node());

Node.prototype.isEqualNode = function (other) { return true; };
Node.prototype.isEqualNode(new Node());

Node.prototype.lookupPrefix = function (namespaceURI) { return ''; };
Node.prototype.lookupPrefix('');

Node.prototype.isDefaultNamespace = function (namespaceURI) { return true; };
Node.prototype.isDefaultNamespace('');

Node.prototype.lookupNamespaceURI = function (prefix) { return ''; };
Node.prototype.lookupNamespaceURI('');

Node.prototype.compareDocumentPosition = function (other) { return 1; };
Node.prototype.compareDocumentPosition(new Node());

Node.prototype.getFeature = function (feature, version) { return new Object(); };
Node.prototype.getFeature('', '');

Node.prototype.setUserData = function (key, data, handler) { return new DOMUserData(); };
Node.prototype.setUserData('', new DOMUserData(), function(){});

Node.prototype.getUserData = function (key) { return new DOMUserData(); };
Node.prototype.getUserData('');

Node.prototype.parentElement = new Element();

Node.prototype.isContentEditable = true;

Node.prototype.addEventListener = function (type, listener, useCapture) { return ; };
Node.prototype.addEventListener('', new EventListener(), true);

Node.prototype.removeEventListener = function (type, listener, useCapture) { return ; };
Node.prototype.removeEventListener('', new EventListener(), true);

Node.prototype.dispatchEvent = function (event) { return true; };
Node.prototype.dispatchEvent(new Event());

Node.prototype.addEventListener = function (type, listener, useCapture) { return ; };
Node.prototype.addEventListener('', new EventListener(), true);

Node.prototype.removeEventListener = function (type, listener, useCapture) { return ; };
Node.prototype.removeEventListener('', new EventListener(), true);

Node.prototype.dispatchEvent = function (event) { return true; };
Node.prototype.dispatchEvent(new Event());

/*
 * NodeIterator
 */
function NodeIterator() { return ; }

NodeIterator.prototype.root = new Node();

NodeIterator.prototype.whatToShow = 1;

NodeIterator.prototype.filter = new NodeFilter();

NodeIterator.prototype.expandEntityReferences = true;

NodeIterator.prototype.referenceNode = new Node();

NodeIterator.prototype.pointerBeforeReferenceNode = true;

NodeIterator.prototype.nextNode = function () { return new Node(); };
NodeIterator.prototype.nextNode();

NodeIterator.prototype.previousNode = function () { return new Node(); };
NodeIterator.prototype.previousNode();

NodeIterator.prototype.detach = function () { return ; };
NodeIterator.prototype.detach();

/*
 * NodeList
 */
function NodeList() { return ; }

NodeList.prototype.item = function (index) { return new Node(); };
NodeList.prototype.item(1);

NodeList.prototype.length = 1;

/*
 * Notation
 */
function Notation() { return ; }
Notation.prototype = Node;

Notation.prototype.publicId = '';

Notation.prototype.systemId = '';

/*
 * OverflowEvent
 */
function OverflowEvent() { return ; }
OverflowEvent.prototype = Event;

OverflowEvent.prototype.orient = 1;

OverflowEvent.prototype.horizontalOverflow = true;

OverflowEvent.prototype.verticalOverflow = true;

OverflowEvent.prototype.initOverflowEvent = function (orient, horizontalOverflow, verticalOverflow) { return ; };
OverflowEvent.prototype.initOverflowEvent(1, true, true);

/*
 * PageTransitionEvent
 */
function PageTransitionEvent() { return ; }
PageTransitionEvent.prototype = Event;

PageTransitionEvent.prototype.persisted = true;

PageTransitionEvent.prototype.initPageTransitionEvent = function (typeArg, canBubbleArg, cancelableArg, persisted) { return ; };
PageTransitionEvent.prototype.initPageTransitionEvent('', true, true, true);

/*
 * PopStateEvent
 */
function PopStateEvent() { return ; }
PopStateEvent.prototype = Event;

PopStateEvent.prototype.initPopStateEvent = function (typeArg, canBubbleArg, cancelableArg, stateArg) { return ; };
PopStateEvent.prototype.initPopStateEvent('', true, true, new SerializedScriptValue());

PopStateEvent.prototype.state = _mixed;

/*
 * ProcessingInstruction
 */
function ProcessingInstruction() { return ; }
ProcessingInstruction.prototype = Node;

ProcessingInstruction.prototype.target = '';

ProcessingInstruction.prototype.data = '';

ProcessingInstruction.prototype.sheet = new StyleSheet();

/*
 * ProgressEvent
 */
function ProgressEvent() { return ; }
ProgressEvent.prototype = Event;

ProgressEvent.prototype.lengthComputable = true;

ProgressEvent.prototype.loaded = 1;

ProgressEvent.prototype.total = 1;

ProgressEvent.prototype.initProgressEvent = function (typeArg, canBubbleArg, cancelableArg, lengthComputableArg, loadedArg, totalArg) { return ; };
ProgressEvent.prototype.initProgressEvent('', true, true, true, 1, 1);

/*
 * RangeException
 */
function RangeException() { return ; }

RangeException.prototype.code = 1;

RangeException.prototype.name = '';

RangeException.prototype.message = '';

RangeException.prototype.toString = function () { return ''; };
RangeException.prototype.toString();

/*
 * Range
 */
function Range() { return ; }

Range.prototype.startContainer = new Node();

Range.prototype.startOffset = 1;

Range.prototype.endContainer = new Node();

Range.prototype.endOffset = 1;

Range.prototype.collapsed = true;

Range.prototype.commonAncestorContainer = new Node();

Range.prototype.setStart = function (refNode, offset) { return ; };
Range.prototype.setStart(new Node(), 1);

Range.prototype.setEnd = function (refNode, offset) { return ; };
Range.prototype.setEnd(new Node(), 1);

Range.prototype.setStartBefore = function (refNode) { return ; };
Range.prototype.setStartBefore(new Node());

Range.prototype.setStartAfter = function (refNode) { return ; };
Range.prototype.setStartAfter(new Node());

Range.prototype.setEndBefore = function (refNode) { return ; };
Range.prototype.setEndBefore(new Node());

Range.prototype.setEndAfter = function (refNode) { return ; };
Range.prototype.setEndAfter(new Node());

Range.prototype.collapse = function (toStart) { return ; };
Range.prototype.collapse(true);

Range.prototype.selectNode = function (refNode) { return ; };
Range.prototype.selectNode(new Node());

Range.prototype.selectNodeContents = function (refNode) { return ; };
Range.prototype.selectNodeContents(new Node());

Range.prototype.compareBoundaryPoints = function (how, sourceRange) { return 1; };
Range.prototype.compareBoundaryPoints(new CompareHow(), new Range());

Range.prototype.deleteContents = function () { return ; };
Range.prototype.deleteContents();

Range.prototype.extractContents = function () { return new DocumentFragment(); };
Range.prototype.extractContents();

Range.prototype.cloneContents = function () { return new DocumentFragment(); };
Range.prototype.cloneContents();

Range.prototype.insertNode = function (newNode) { return ; };
Range.prototype.insertNode(new Node());

Range.prototype.surroundContents = function (newParent) { return ; };
Range.prototype.surroundContents(new Node());

Range.prototype.cloneRange = function () { return new Range(); };
Range.prototype.cloneRange();

Range.prototype.toString = function () { return ''; };
Range.prototype.toString();

Range.prototype.detach = function () { return ; };
Range.prototype.detach();

Range.prototype.getClientRects = function () { return new ClientRectList(); };
Range.prototype.getClientRects();

Range.prototype.getBoundingClientRect = function () { return new ClientRect(); };
Range.prototype.getBoundingClientRect();

Range.prototype.createContextualFragment = function (html) { return new DocumentFragment(); };
Range.prototype.createContextualFragment('');

Range.prototype.intersectsNode = function (refNode) { return true; };
Range.prototype.intersectsNode(new Node());

Range.prototype.compareNode = function (refNode) { return 1; };
Range.prototype.compareNode(new Node());

Range.prototype.comparePoint = function (refNode, offset) { return 1; };
Range.prototype.comparePoint(new Node(), 1);

Range.prototype.isPointInRange = function (refNode, offset) { return true; };
Range.prototype.isPointInRange(new Node(), 1);

Range.prototype.expand = function (unit) { return ; };
Range.prototype.expand('');

Range.prototype.text = '';

/*
 * RequestAnimationFrameCallback
 */
function RequestAnimationFrameCallback() { return ; }

RequestAnimationFrameCallback.prototype.handleEvent = function (time) { return true; };
RequestAnimationFrameCallback.prototype.handleEvent(new Date());

/*
 * StringCallback
 */
function StringCallback() { return ; }

StringCallback.prototype.handleEvent = function (data) { return true; };
StringCallback.prototype.handleEvent('');

/*
 * TextEvent
 */
function TextEvent() { return ; }
TextEvent.prototype = UIEvent;

TextEvent.prototype.data = '';

TextEvent.prototype.initTextEvent = function (typeArg, canBubbleArg, cancelableArg, viewArg, dataArg) { return ; };
TextEvent.prototype.initTextEvent('', true, true, new DOMWindow(), '');

/*
 * Text
 */
function Text() { return ; }
Text.prototype = CharacterData;

Text.prototype.splitText = function (offset) { return new Text(); };
Text.prototype.splitText(1);

Text.prototype.wholeText = '';

Text.prototype.replaceWholeText = function (content) { return new Text(); };
Text.prototype.replaceWholeText('');

/*
 * TouchEvent
 */
function TouchEvent() { return ; }
TouchEvent.prototype = UIEvent;

TouchEvent.prototype.touches = new TouchList();

TouchEvent.prototype.targetTouches = new TouchList();

TouchEvent.prototype.changedTouches = new TouchList();

TouchEvent.prototype.ctrlKey = true;

TouchEvent.prototype.shiftKey = true;

TouchEvent.prototype.altKey = true;

TouchEvent.prototype.metaKey = true;

TouchEvent.prototype.initTouchEvent = function (touches, targetTouches, changedTouches, type, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey) { return ; };
TouchEvent.prototype.initTouchEvent(new TouchList(), new TouchList(), new TouchList(), '', new DOMWindow(), 1, 1, 1, 1, true, true, true, true);

/*
 * Touch
 */
function Touch() { return ; }

Touch.prototype.clientX = 1;

Touch.prototype.clientY = 1;

Touch.prototype.screenX = 1;

Touch.prototype.screenY = 1;

Touch.prototype.pageX = 1;

Touch.prototype.pageY = 1;

Touch.prototype.target = new EventTarget();

Touch.prototype.identifier = 1;

/*
 * TouchList
 */
function TouchList() { return ; }

TouchList.prototype.length = 1;

TouchList.prototype.item = function (index) { return new Touch(); };
TouchList.prototype.item(1);

/*
 * TreeWalker
 */
function TreeWalker() { return ; }

TreeWalker.prototype.root = new Node();

TreeWalker.prototype.whatToShow = 1;

TreeWalker.prototype.filter = new NodeFilter();

TreeWalker.prototype.expandEntityReferences = true;

TreeWalker.prototype.currentNode = new Node();

TreeWalker.prototype.parentNode = function () { return new Node(); };
TreeWalker.prototype.parentNode();

TreeWalker.prototype.firstChild = function () { return new Node(); };
TreeWalker.prototype.firstChild();

TreeWalker.prototype.lastChild = function () { return new Node(); };
TreeWalker.prototype.lastChild();

TreeWalker.prototype.previousSibling = function () { return new Node(); };
TreeWalker.prototype.previousSibling();

TreeWalker.prototype.nextSibling = function () { return new Node(); };
TreeWalker.prototype.nextSibling();

TreeWalker.prototype.previousNode = function () { return new Node(); };
TreeWalker.prototype.previousNode();

TreeWalker.prototype.nextNode = function () { return new Node(); };
TreeWalker.prototype.nextNode();

/*
 * UIEvent
 */
function UIEvent() { return ; }
UIEvent.prototype = Event;

UIEvent.prototype.view = new DOMWindow();

UIEvent.prototype.detail = 1;

UIEvent.prototype.initUIEvent = function (type, canBubble, cancelable, view, detail) { return ; };
UIEvent.prototype.initUIEvent('', true, true, new DOMWindow(), 1);

UIEvent.prototype.keyCode = 1;

UIEvent.prototype.charCode = 1;

UIEvent.prototype.layerX = 1;

UIEvent.prototype.layerY = 1;

UIEvent.prototype.pageX = 1;

UIEvent.prototype.pageY = 1;

UIEvent.prototype.which = 1;

/*
 * WebKitAnimationEvent
 */
function WebKitAnimationEvent() { return ; }
WebKitAnimationEvent.prototype = Event;

WebKitAnimationEvent.prototype.animationName = '';

WebKitAnimationEvent.prototype.elapsedTime = 1.0;

WebKitAnimationEvent.prototype.initWebKitAnimationEvent = function (typeArg, canBubbleArg, cancelableArg, animationNameArg, elapsedTimeArg) { return ; };
WebKitAnimationEvent.prototype.initWebKitAnimationEvent('', true, true, '', 1.0);

/*
 * WebKitTransitionEvent
 */
function WebKitTransitionEvent() { return ; }
WebKitTransitionEvent.prototype = Event;

WebKitTransitionEvent.prototype.propertyName = '';

WebKitTransitionEvent.prototype.elapsedTime = 1.0;

WebKitTransitionEvent.prototype.initWebKitTransitionEvent = function (typeArg, canBubbleArg, cancelableArg, propertyNameArg, elapsedTimeArg) { return ; };
WebKitTransitionEvent.prototype.initWebKitTransitionEvent('', true, true, '', 1.0);

/*
 * WheelEvent
 */
function WheelEvent() { return ; }
WheelEvent.prototype = UIEvent;

WheelEvent.prototype.screenX = 1;

WheelEvent.prototype.screenY = 1;

WheelEvent.prototype.clientX = 1;

WheelEvent.prototype.clientY = 1;

WheelEvent.prototype.ctrlKey = true;

WheelEvent.prototype.shiftKey = true;

WheelEvent.prototype.altKey = true;

WheelEvent.prototype.metaKey = true;

WheelEvent.prototype.wheelDelta = 1;

WheelEvent.prototype.wheelDeltaX = 1;

WheelEvent.prototype.wheelDeltaY = 1;

WheelEvent.prototype.offsetX = 1;

WheelEvent.prototype.offsetY = 1;

WheelEvent.prototype.x = 1;

WheelEvent.prototype.y = 1;

WheelEvent.prototype.isHorizontal = true;

WheelEvent.prototype.initWheelEvent = function (wheelDeltaX, wheelDeltaY, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey) { return ; };
WheelEvent.prototype.initWheelEvent(1, 1, new DOMWindow(), 1, 1, 1, 1, true, true, true, true);

WheelEvent.prototype.initWebKitWheelEvent = function (wheelDeltaX, wheelDeltaY, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey) { return ; };
WheelEvent.prototype.initWebKitWheelEvent(1, 1, new DOMWindow(), 1, 1, 1, 1, true, true, true, true);

/*
 * AbstractView
 */
function AbstractView() { return ; }

AbstractView.prototype.document = new Document();

AbstractView.prototype.styleMedia = new StyleMedia();

/*
 * BarInfo
 */
function BarInfo() { return ; }

BarInfo.prototype.visible = true;

/*
 * Console
 */
function Console() { return ; }

Console.prototype.debug = function () { return ; };
Console.prototype.debug();

Console.prototype.error = function () { return ; };
Console.prototype.error();

Console.prototype.info = function () { return ; };
Console.prototype.info();

Console.prototype.log = function () { return ; };
Console.prototype.log();

Console.prototype.warn = function () { return ; };
Console.prototype.warn();

Console.prototype.dir = function () { return ; };
Console.prototype.dir();

Console.prototype.dirxml = function () { return ; };
Console.prototype.dirxml();

Console.prototype.trace = function () { return ; };
Console.prototype.trace();

Console.prototype.assert = function (condition) { return ; };
Console.prototype.assert(true);

Console.prototype.count = function () { return ; };
Console.prototype.count();

Console.prototype.markTimeline = function () { return ; };
Console.prototype.markTimeline();

Console.prototype.profiles = [];

Console.prototype.profile = function (title) { return ; };
Console.prototype.profile('');

Console.prototype.profileEnd = function (title) { return ; };
Console.prototype.profileEnd('');

Console.prototype.time = function (title) { return ; };
Console.prototype.time('');

Console.prototype.timeEnd = function (title) { return ; };
Console.prototype.timeEnd('');

Console.prototype.group = function () { return ; };
Console.prototype.group();

Console.prototype.groupCollapsed = function () { return ; };
Console.prototype.groupCollapsed();

Console.prototype.groupEnd = function () { return ; };
Console.prototype.groupEnd();

Console.prototype.memory = new MemoryInfo();

/*
 * Coordinates
 */
function Coordinates() { return ; }

Coordinates.prototype.latitude = 1.0;

Coordinates.prototype.longitude = 1.0;

Coordinates.prototype.altitude = 1.0;

Coordinates.prototype.accuracy = 1.0;

Coordinates.prototype.altitudeAccuracy = 1.0;

Coordinates.prototype.heading = 1.0;

Coordinates.prototype.speed = 1.0;

/*
 * Crypto
 */
function Crypto() { return ; }

Crypto.prototype.getRandomValues = function (array) { return ; };
Crypto.prototype.getRandomValues(new ArrayBufferView());

/*
 * DOMSelection
 */
function DOMSelection() { return ; }

DOMSelection.prototype.anchorNode = new Node();

DOMSelection.prototype.anchorOffset = 1;

DOMSelection.prototype.focusNode = new Node();

DOMSelection.prototype.focusOffset = 1;

DOMSelection.prototype.isCollapsed = true;

DOMSelection.prototype.rangeCount = 1;

DOMSelection.prototype.collapse = function (node, index) { return ; };
DOMSelection.prototype.collapse(new Node(), 1);

DOMSelection.prototype.collapseToEnd = function () { return ; };
DOMSelection.prototype.collapseToEnd();

DOMSelection.prototype.collapseToStart = function () { return ; };
DOMSelection.prototype.collapseToStart();

DOMSelection.prototype.deleteFromDocument = function () { return ; };
DOMSelection.prototype.deleteFromDocument();

DOMSelection.prototype.containsNode = function (node, allowPartial) { return true; };
DOMSelection.prototype.containsNode(new Node(), true);

DOMSelection.prototype.selectAllChildren = function (node) { return ; };
DOMSelection.prototype.selectAllChildren(new Node());

DOMSelection.prototype.extend = function (node, offset) { return ; };
DOMSelection.prototype.extend(new Node(), 1);

DOMSelection.prototype.getRangeAt = function (index) { return new Range(); };
DOMSelection.prototype.getRangeAt(1);

DOMSelection.prototype.removeAllRanges = function () { return ; };
DOMSelection.prototype.removeAllRanges();

DOMSelection.prototype.addRange = function (range) { return ; };
DOMSelection.prototype.addRange(new Range());

DOMSelection.prototype.toString = function () { return ''; };
DOMSelection.prototype.toString();

DOMSelection.prototype.baseNode = new Node();

DOMSelection.prototype.baseOffset = 1;

DOMSelection.prototype.extentNode = new Node();

DOMSelection.prototype.extentOffset = 1;

DOMSelection.prototype.type = '';

DOMSelection.prototype.modify = function (alter, direction, granularity) { return ; };
DOMSelection.prototype.modify('', '', '');

DOMSelection.prototype.setBaseAndExtent = function (baseNode, baseOffset, extentNode, extentOffset) { return ; };
DOMSelection.prototype.setBaseAndExtent(new Node(), 1, new Node(), 1);

DOMSelection.prototype.setPosition = function (node, offset) { return ; };
DOMSelection.prototype.setPosition(new Node(), 1);

DOMSelection.prototype.empty = function () { return ; };
DOMSelection.prototype.empty();

module.exports = DOMWindow;
/*
 * DOMWindow
 */
function DOMWindow() { return ; }

DOMWindow.prototype.screen = new Screen();

DOMWindow.prototype.history = new History();

DOMWindow.prototype.locationbar = new BarInfo();

DOMWindow.prototype.menubar = new BarInfo();

DOMWindow.prototype.personalbar = new BarInfo();

DOMWindow.prototype.scrollbars = new BarInfo();

DOMWindow.prototype.statusbar = new BarInfo();

DOMWindow.prototype.toolbar = new BarInfo();

DOMWindow.prototype.navigator = new Navigator();

DOMWindow.prototype.clientInformation = new Navigator();

DOMWindow.prototype.crypto = new Crypto();

DOMWindow.prototype.location = new Location();

DOMWindow.prototype.event = new Event();

DOMWindow.prototype.getSelection = function () { return new DOMSelection(); };
DOMWindow.prototype.getSelection();

DOMWindow.prototype.frameElement = new Element();

DOMWindow.prototype.focus = function () { return ; };
DOMWindow.prototype.focus();

DOMWindow.prototype.blur = function () { return ; };
DOMWindow.prototype.blur();

DOMWindow.prototype.close = function () { return ; };
DOMWindow.prototype.close();

DOMWindow.prototype.print = function () { return ; };
DOMWindow.prototype.print();

DOMWindow.prototype.stop = function () { return ; };
DOMWindow.prototype.stop();

DOMWindow.prototype.open = function (url, name, options) { return new DOMWindow(); };
DOMWindow.prototype.open('', '', '');

DOMWindow.prototype.showModalDialog = function (url, dialogArgs, featureArgs) { return new Object(); };
DOMWindow.prototype.showModalDialog('', new Object(), '');

DOMWindow.prototype.alert = function (message) { return ; };
DOMWindow.prototype.alert('');

DOMWindow.prototype.confirm = function (message) { return true; };
DOMWindow.prototype.confirm('');

DOMWindow.prototype.prompt = function (message, defaultValue) { return ''; };
DOMWindow.prototype.prompt('', '');

DOMWindow.prototype.find = function (string, caseSensitive, backwards, wrap, wholeWord, searchInFrames, showDialog) { return true; };
DOMWindow.prototype.find('', true, true, true, true, true, true);

DOMWindow.prototype.offscreenBuffering = true;

DOMWindow.prototype.outerHeight = 1;

DOMWindow.prototype.outerWidth = 1;

DOMWindow.prototype.innerHeight = 1;

DOMWindow.prototype.innerWidth = 1;

DOMWindow.prototype.screenX = 1;

DOMWindow.prototype.screenY = 1;

DOMWindow.prototype.screenLeft = 1;

DOMWindow.prototype.screenTop = 1;

DOMWindow.prototype.scrollX = 1;

DOMWindow.prototype.scrollY = 1;

DOMWindow.prototype.pageXOffset = 1;

DOMWindow.prototype.pageYOffset = 1;

DOMWindow.prototype.scrollBy = function (x, y) { return ; };
DOMWindow.prototype.scrollBy(1, 1);

DOMWindow.prototype.scrollTo = function (x, y) { return ; };
DOMWindow.prototype.scrollTo(1, 1);

DOMWindow.prototype.scroll = function (x, y) { return ; };
DOMWindow.prototype.scroll(1, 1);

DOMWindow.prototype.moveBy = function (x, y) { return ; };
DOMWindow.prototype.moveBy(1.0, 1.0);

DOMWindow.prototype.moveTo = function (x, y) { return ; };
DOMWindow.prototype.moveTo(1.0, 1.0);

DOMWindow.prototype.resizeBy = function (x, y) { return ; };
DOMWindow.prototype.resizeBy(1.0, 1.0);

DOMWindow.prototype.resizeTo = function (width, height) { return ; };
DOMWindow.prototype.resizeTo(1.0, 1.0);

DOMWindow.prototype.closed = true;

DOMWindow.prototype.length = 1;

DOMWindow.prototype.name = '';

DOMWindow.prototype.status = '';

DOMWindow.prototype.defaultStatus = '';

DOMWindow.prototype.defaultstatus = '';

DOMWindow.prototype.self = new DOMWindow();

DOMWindow.prototype.window = new DOMWindow();

DOMWindow.prototype.frames = new DOMWindow();

DOMWindow.prototype.opener = new DOMWindow();

DOMWindow.prototype.parent = new DOMWindow();

DOMWindow.prototype.top = new DOMWindow();

DOMWindow.prototype.document = new Document();

DOMWindow.prototype.matchMedia = function (query) { return new MediaQueryList(); };
DOMWindow.prototype.matchMedia('');

DOMWindow.prototype.styleMedia = new StyleMedia();

DOMWindow.prototype.getComputedStyle = function (element, pseudoElement) { return new CSSStyleDeclaration(); };
DOMWindow.prototype.getComputedStyle(new Element(), '');

DOMWindow.prototype.getMatchedCSSRules = function (element, pseudoElement) { return new CSSRuleList(); };
DOMWindow.prototype.getMatchedCSSRules(new Element(), '');

DOMWindow.prototype.devicePixelRatio = 1.0;

DOMWindow.prototype.webkitConvertPointFromPageToNode = function (node, p) { return new WebKitPoint(); };
DOMWindow.prototype.webkitConvertPointFromPageToNode(new Node(), new WebKitPoint());

DOMWindow.prototype.webkitConvertPointFromNodeToPage = function (node, p) { return new WebKitPoint(); };
DOMWindow.prototype.webkitConvertPointFromNodeToPage(new Node(), new WebKitPoint());

DOMWindow.prototype.applicationCache = new DOMApplicationCache();

DOMWindow.prototype.openDatabase = function (name, version, displayName, estimatedSize, creationCallback) { return new Database(); };
DOMWindow.prototype.openDatabase('', '', '', 1, function(){});

DOMWindow.prototype.sessionStorage = new Storage();

DOMWindow.prototype.localStorage = new Storage();

DOMWindow.prototype.webkitNotifications = new NotificationCenter();

DOMWindow.prototype.webkitIndexedDB = new IDBFactory();

DOMWindow.prototype.webkitIDBCursor = IDBCursor;

DOMWindow.prototype.webkitIDBDatabase = IDBDatabase;

DOMWindow.prototype.webkitIDBDatabaseError = IDBDatabaseError;

DOMWindow.prototype.webkitIDBDatabaseException = IDBDatabaseException;

DOMWindow.prototype.webkitIDBFactory = IDBFactory;

DOMWindow.prototype.webkitIDBIndex = IDBIndex;

DOMWindow.prototype.webkitIDBKeyRange = IDBKeyRange;

DOMWindow.prototype.webkitIDBObjectStore = IDBObjectStore;

DOMWindow.prototype.webkitIDBRequest = IDBRequest;

DOMWindow.prototype.webkitIDBTransaction = IDBTransaction;

DOMWindow.prototype.webkitRequestFileSystem = function (type, size, successCallback, errorCallback) { return ; };
DOMWindow.prototype.webkitRequestFileSystem(1, 1, function(){}, function(){});

DOMWindow.prototype.webkitResolveLocalFileSystemURL = function (url, successCallback, errorCallback) { return ; };
DOMWindow.prototype.webkitResolveLocalFileSystemURL('', function(){}, function(){});

DOMWindow.prototype.WebKitFlags = WebKitFlags;

DOMWindow.prototype.orientation = 1;

DOMWindow.prototype.console = new Console();

DOMWindow.prototype.postMessage = function (message, messagePorts, targetOrigin) { return ; };
DOMWindow.prototype.postMessage(new SerializedScriptValue(), [], '');

DOMWindow.prototype.postMessage = function (message, messagePort, targetOrigin) { return ; };
DOMWindow.prototype.postMessage(new SerializedScriptValue(), new MessagePort(), '');

DOMWindow.prototype.performance = new Performance();

DOMWindow.prototype.setTimeout = function (handler, timeout) { return 1; };
DOMWindow.prototype.setTimeout(function(){}, 1);

DOMWindow.prototype.clearTimeout = function (handle) { return ; };
DOMWindow.prototype.clearTimeout(1);

DOMWindow.prototype.setInterval = function (handler, timeout) { return 1; };
DOMWindow.prototype.setInterval(function(){}, 1);

DOMWindow.prototype.clearInterval = function (handle) { return ; };
DOMWindow.prototype.clearInterval(1);

DOMWindow.prototype.webkitRequestAnimationFrame = function (callback, element) { return 1; };
DOMWindow.prototype.webkitRequestAnimationFrame(function(){}, new Element());

DOMWindow.prototype.webkitCancelRequestAnimationFrame = function (id) { return ; };
DOMWindow.prototype.webkitCancelRequestAnimationFrame(1);

DOMWindow.prototype.atob = function (string) { return ''; };
DOMWindow.prototype.atob('');

DOMWindow.prototype.btoa = function (string) { return ''; };
DOMWindow.prototype.btoa('');

DOMWindow.prototype.onabort = new EventListener();

DOMWindow.prototype.onbeforeunload = new EventListener();

DOMWindow.prototype.onblur = new EventListener();

DOMWindow.prototype.oncanplay = new EventListener();

DOMWindow.prototype.oncanplaythrough = new EventListener();

DOMWindow.prototype.onchange = new EventListener();

DOMWindow.prototype.onclick = new EventListener();

DOMWindow.prototype.oncontextmenu = new EventListener();

DOMWindow.prototype.ondblclick = new EventListener();

DOMWindow.prototype.ondrag = new EventListener();

DOMWindow.prototype.ondragend = new EventListener();

DOMWindow.prototype.ondragenter = new EventListener();

DOMWindow.prototype.ondragleave = new EventListener();

DOMWindow.prototype.ondragover = new EventListener();

DOMWindow.prototype.ondragstart = new EventListener();

DOMWindow.prototype.ondrop = new EventListener();

DOMWindow.prototype.ondurationchange = new EventListener();

DOMWindow.prototype.onemptied = new EventListener();

DOMWindow.prototype.onended = new EventListener();

DOMWindow.prototype.onerror = new EventListener();

DOMWindow.prototype.onfocus = new EventListener();

DOMWindow.prototype.onhashchange = new EventListener();

DOMWindow.prototype.oninput = new EventListener();

DOMWindow.prototype.oninvalid = new EventListener();

DOMWindow.prototype.onkeydown = new EventListener();

DOMWindow.prototype.onkeypress = new EventListener();

DOMWindow.prototype.onkeyup = new EventListener();

DOMWindow.prototype.onload = new EventListener();

DOMWindow.prototype.onloadeddata = new EventListener();

DOMWindow.prototype.onloadedmetadata = new EventListener();

DOMWindow.prototype.onloadstart = new EventListener();

DOMWindow.prototype.onmessage = new EventListener();

DOMWindow.prototype.onmousedown = new EventListener();

DOMWindow.prototype.onmousemove = new EventListener();

DOMWindow.prototype.onmouseout = new EventListener();

DOMWindow.prototype.onmouseover = new EventListener();

DOMWindow.prototype.onmouseup = new EventListener();

DOMWindow.prototype.onmousewheel = new EventListener();

DOMWindow.prototype.onoffline = new EventListener();

DOMWindow.prototype.ononline = new EventListener();

DOMWindow.prototype.onpagehide = new EventListener();

DOMWindow.prototype.onpageshow = new EventListener();

DOMWindow.prototype.onpause = new EventListener();

DOMWindow.prototype.onplay = new EventListener();

DOMWindow.prototype.onplaying = new EventListener();

DOMWindow.prototype.onpopstate = new EventListener();

DOMWindow.prototype.onprogress = new EventListener();

DOMWindow.prototype.onratechange = new EventListener();

DOMWindow.prototype.onresize = new EventListener();

DOMWindow.prototype.onscroll = new EventListener();

DOMWindow.prototype.onseeked = new EventListener();

DOMWindow.prototype.onseeking = new EventListener();

DOMWindow.prototype.onselect = new EventListener();

DOMWindow.prototype.onstalled = new EventListener();

DOMWindow.prototype.onstorage = new EventListener();

DOMWindow.prototype.onsubmit = new EventListener();

DOMWindow.prototype.onsuspend = new EventListener();

DOMWindow.prototype.ontimeupdate = new EventListener();

DOMWindow.prototype.onunload = new EventListener();

DOMWindow.prototype.onvolumechange = new EventListener();

DOMWindow.prototype.onwaiting = new EventListener();

DOMWindow.prototype.onreset = new EventListener();

DOMWindow.prototype.onsearch = new EventListener();

DOMWindow.prototype.onwebkitanimationend = new EventListener();

DOMWindow.prototype.onwebkitanimationiteration = new EventListener();

DOMWindow.prototype.onwebkitanimationstart = new EventListener();

DOMWindow.prototype.onwebkittransitionend = new EventListener();

DOMWindow.prototype.onorientationchange = new EventListener();

DOMWindow.prototype.ontouchstart = new EventListener();

DOMWindow.prototype.ontouchmove = new EventListener();

DOMWindow.prototype.ontouchend = new EventListener();

DOMWindow.prototype.ontouchcancel = new EventListener();

DOMWindow.prototype.DeviceMotionEvent = DeviceMotionEvent;

DOMWindow.prototype.ondevicemotion = new EventListener();

DOMWindow.prototype.DeviceOrientationEvent = DeviceOrientationEvent;

DOMWindow.prototype.ondeviceorientation = new EventListener();

DOMWindow.prototype.addEventListener = function (type, listener, useCapture) { return ; };
DOMWindow.prototype.addEventListener('', new EventListener(), true);

DOMWindow.prototype.removeEventListener = function (type, listener, useCapture) { return ; };
DOMWindow.prototype.removeEventListener('', new EventListener(), true);

DOMWindow.prototype.dispatchEvent = function (evt) { return true; };
DOMWindow.prototype.dispatchEvent(new Event());

DOMWindow.prototype.captureEvents = function () { return ; };
DOMWindow.prototype.captureEvents();

DOMWindow.prototype.releaseEvents = function () { return ; };
DOMWindow.prototype.releaseEvents();

DOMWindow.prototype.StyleSheet = StyleSheet;

DOMWindow.prototype.CSSStyleSheet = CSSStyleSheet;

DOMWindow.prototype.CSSValue = CSSValue;

DOMWindow.prototype.CSSPrimitiveValue = CSSPrimitiveValue;

DOMWindow.prototype.CSSValueList = CSSValueList;

DOMWindow.prototype.WebKitCSSTransformValue = WebKitCSSTransformValue;

DOMWindow.prototype.CSSRule = CSSRule;

DOMWindow.prototype.CSSCharsetRule = CSSCharsetRule;

DOMWindow.prototype.CSSFontFaceRule = CSSFontFaceRule;

DOMWindow.prototype.CSSImportRule = CSSImportRule;

DOMWindow.prototype.CSSMediaRule = CSSMediaRule;

DOMWindow.prototype.CSSPageRule = CSSPageRule;

DOMWindow.prototype.CSSStyleRule = CSSStyleRule;

DOMWindow.prototype.CSSStyleDeclaration = CSSStyleDeclaration;

DOMWindow.prototype.MediaList = MediaList;

DOMWindow.prototype.Counter = Counter;

DOMWindow.prototype.CSSRuleList = CSSRuleList;

DOMWindow.prototype.Rect = Rect;

DOMWindow.prototype.RGBColor = RGBColor;

DOMWindow.prototype.StyleSheetList = StyleSheetList;

DOMWindow.prototype.DOMException = DOMCoreException;

DOMWindow.prototype.DOMStringList = DOMStringList;

DOMWindow.prototype.DOMImplementation = DOMImplementation;

DOMWindow.prototype.DOMSettableTokenList = DOMSettableTokenList;

DOMWindow.prototype.DOMTokenList = DOMTokenList;

DOMWindow.prototype.DocumentFragment = DocumentFragment;

DOMWindow.prototype.Document = Document;

DOMWindow.prototype.Node = Node;

DOMWindow.prototype.NodeList = NodeList;

DOMWindow.prototype.NamedNodeMap = NamedNodeMap;

DOMWindow.prototype.CharacterData = CharacterData;

DOMWindow.prototype.Attr = Attr;

DOMWindow.prototype.Element = Element;

DOMWindow.prototype.Text = Text;

DOMWindow.prototype.Comment = Comment;

DOMWindow.prototype.CDATASection = CDATASection;

DOMWindow.prototype.DocumentType = DocumentType;

DOMWindow.prototype.Notation = Notation;

DOMWindow.prototype.Entity = Entity;

DOMWindow.prototype.EntityReference = EntityReference;

DOMWindow.prototype.ProcessingInstruction = ProcessingInstruction;

DOMWindow.prototype.DOMStringMap = DOMStringMap;

DOMWindow.prototype.DataView = DataView;

DOMWindow.prototype.Event = Event;

DOMWindow.prototype.BeforeLoadEvent = BeforeLoadEvent;

DOMWindow.prototype.HashChangeEvent = HashChangeEvent;

DOMWindow.prototype.KeyboardEvent = KeyboardEvent;

DOMWindow.prototype.MouseEvent = MouseEvent;

DOMWindow.prototype.MutationEvent = MutationEvent;

DOMWindow.prototype.OverflowEvent = OverflowEvent;

DOMWindow.prototype.PageTransitionEvent = PageTransitionEvent;

DOMWindow.prototype.ProgressEvent = ProgressEvent;

DOMWindow.prototype.TextEvent = TextEvent;

DOMWindow.prototype.UIEvent = UIEvent;

DOMWindow.prototype.WebKitAnimationEvent = WebKitAnimationEvent;

DOMWindow.prototype.WebKitTransitionEvent = WebKitTransitionEvent;

DOMWindow.prototype.WheelEvent = WheelEvent;

DOMWindow.prototype.MessageEvent = MessageEvent;

DOMWindow.prototype.EventException = EventException;

DOMWindow.prototype.WebKitCSSKeyframeRule = WebKitCSSKeyframeRule;

DOMWindow.prototype.WebKitCSSKeyframesRule = WebKitCSSKeyframesRule;

DOMWindow.prototype.WebKitCSSMatrix = WebKitCSSMatrix;

DOMWindow.prototype.WebKitPoint = WebKitPoint;

DOMWindow.prototype.Clipboard = Clipboard;

DOMWindow.prototype.File = File;

DOMWindow.prototype.FileList = FileList;

DOMWindow.prototype.Blob = Blob;

DOMWindow.prototype.NodeFilter = NodeFilter;

DOMWindow.prototype.Range = Range;

DOMWindow.prototype.RangeException = RangeException;

DOMWindow.prototype.EventSource = EventSource;

DOMWindow.prototype.XMLDocument = Document;

DOMWindow.prototype.MessagePort = MessagePort;

DOMWindow.prototype.MessageChannel = MessageChannel;

DOMWindow.prototype.ClientRect = ClientRect;

DOMWindow.prototype.ClientRectList = ClientRectList;

DOMWindow.prototype.WebKitAnimation = WebKitAnimation;

DOMWindow.prototype.WebKitAnimationList = WebKitAnimationList;

DOMWindow.prototype.TouchEvent = TouchEvent;

DOMWindow.prototype.FormData = DOMFormData;

DOMWindow.prototype.webkitURL = new DOMURL();

DOMWindow.prototype.toString = function () { return ''; };
DOMWindow.prototype.toString();

/*
 * EventSource
 */
function EventSource() { return ; }

EventSource.prototype.URL = '';

EventSource.prototype.readyState = 1;

EventSource.prototype.onopen = new EventListener();

EventSource.prototype.onmessage = new EventListener();

EventSource.prototype.onerror = new EventListener();

EventSource.prototype.close = function () { return ; };
EventSource.prototype.close();

EventSource.prototype.addEventListener = function (type, listener, useCapture) { return ; };
EventSource.prototype.addEventListener('', new EventListener(), true);

EventSource.prototype.removeEventListener = function (type, listener, useCapture) { return ; };
EventSource.prototype.removeEventListener('', new EventListener(), true);

EventSource.prototype.dispatchEvent = function (evt) { return true; };
EventSource.prototype.dispatchEvent(new Event());

/*
 * Geolocation
 */
function Geolocation() { return ; }

Geolocation.prototype.getCurrentPosition = function (successCallback, errorCallback, options) { return ; };
Geolocation.prototype.getCurrentPosition(function(){}, function(){}, new PositionOptions());

Geolocation.prototype.watchPosition = function (successCallback, errorCallback, options) { return 1; };
Geolocation.prototype.watchPosition(function(){}, function(){}, new PositionOptions());

Geolocation.prototype.clearWatch = function (watchId) { return ; };
Geolocation.prototype.clearWatch(1);

/*
 * Geoposition
 */
function Geoposition() { return ; }

Geoposition.prototype.coords = new Coordinates();

Geoposition.prototype.timestamp = new Date();

/*
 * History
 */
function History() { return ; }

History.prototype.length = 1;

History.prototype.back = function () { return ; };
History.prototype.back();

History.prototype.forward = function () { return ; };
History.prototype.forward();

History.prototype.go = function (distance) { return ; };
History.prototype.go(1);

History.prototype.pushState = function (data, title, url) { return ; };
History.prototype.pushState(_mixed, '', '');

History.prototype.replaceState = function (data, title, url) { return ; };
History.prototype.replaceState(_mixed, '', '');

/*
 * Location
 */
function Location() { return ; }

Location.prototype.href = '';

Location.prototype.assign = function (url) { return ; };
Location.prototype.assign('');

Location.prototype.replace = function (url) { return ; };
Location.prototype.replace('');

Location.prototype.reload = function () { return ; };
Location.prototype.reload();

Location.prototype.protocol = '';

Location.prototype.host = '';

Location.prototype.hostname = '';

Location.prototype.port = '';

Location.prototype.pathname = '';

Location.prototype.search = '';

Location.prototype.hash = '';

Location.prototype.origin = '';

Location.prototype.getParameter = function (name) { return ''; };
Location.prototype.getParameter('');

Location.prototype.toString = function () { return ''; };
Location.prototype.toString();

Location.prototype.valueOf = function () { return new Object(); };
Location.prototype.valueOf();

/*
 * MemoryInfo
 */
function MemoryInfo() { return ; }

MemoryInfo.prototype.totalJSHeapSize = 1;

MemoryInfo.prototype.usedJSHeapSize = 1;

MemoryInfo.prototype.jsHeapSizeLimit = 1;

/*
 * Navigator
 */
function Navigator() { return ; }

Navigator.prototype.appCodeName = '';

Navigator.prototype.appName = '';

Navigator.prototype.appVersion = '';

Navigator.prototype.language = '';

Navigator.prototype.userAgent = '';

Navigator.prototype.platform = '';

Navigator.prototype.plugins = new DOMPluginArray();

Navigator.prototype.mimeTypes = new DOMMimeTypeArray();

Navigator.prototype.product = '';

Navigator.prototype.productSub = '';

Navigator.prototype.vendor = '';

Navigator.prototype.vendorSub = '';

Navigator.prototype.cookieEnabled = true;

Navigator.prototype.javaEnabled = function () { return true; };
Navigator.prototype.javaEnabled();

Navigator.prototype.onLine = true;

Navigator.prototype.geolocation = new Geolocation();

Navigator.prototype.getStorageUpdates = function () { return ; };
Navigator.prototype.getStorageUpdates();

Navigator.prototype.registerProtocolHandler = function (scheme, url, title) { return ; };
Navigator.prototype.registerProtocolHandler('', '', '');

Navigator.prototype.webkitGetUserMedia = function (options, successCallback, errorCallback) { return ; };
Navigator.prototype.webkitGetUserMedia('', function(){}, function(){});

/*
 * NavigatorUserMediaErrorCallback
 */
function NavigatorUserMediaErrorCallback() { return ; }

NavigatorUserMediaErrorCallback.prototype.handleEvent = function (error) { return true; };
NavigatorUserMediaErrorCallback.prototype.handleEvent(new NavigatorUserMediaError());

/*
 * NavigatorUserMediaError
 */
function NavigatorUserMediaError() { return ; }

NavigatorUserMediaError.prototype.code = 1;

/*
 * NavigatorUserMediaSuccessCallback
 */
function NavigatorUserMediaSuccessCallback() { return ; }

NavigatorUserMediaSuccessCallback.prototype.handleEvent = function (dummy) { return true; };
NavigatorUserMediaSuccessCallback.prototype.handleEvent(1);

/*
 * Performance
 */
function Performance() { return ; }

Performance.prototype.navigation = new PerformanceNavigation();

Performance.prototype.timing = new PerformanceTiming();

Performance.prototype.memory = new MemoryInfo();

/*
 * PerformanceNavigation
 */
function PerformanceNavigation() { return ; }

PerformanceNavigation.prototype.type = 1;

PerformanceNavigation.prototype.redirectCount = 1;

/*
 * PerformanceTiming
 */
function PerformanceTiming() { return ; }

PerformanceTiming.prototype.navigationStart = 1;

PerformanceTiming.prototype.unloadEventStart = 1;

PerformanceTiming.prototype.unloadEventEnd = 1;

PerformanceTiming.prototype.redirectStart = 1;

PerformanceTiming.prototype.redirectEnd = 1;

PerformanceTiming.prototype.fetchStart = 1;

PerformanceTiming.prototype.domainLookupStart = 1;

PerformanceTiming.prototype.domainLookupEnd = 1;

PerformanceTiming.prototype.connectStart = 1;

PerformanceTiming.prototype.connectEnd = 1;

PerformanceTiming.prototype.secureConnectionStart = 1;

PerformanceTiming.prototype.requestStart = 1;

PerformanceTiming.prototype.responseStart = 1;

PerformanceTiming.prototype.responseEnd = 1;

PerformanceTiming.prototype.domLoading = 1;

PerformanceTiming.prototype.domInteractive = 1;

PerformanceTiming.prototype.domContentLoadedEventStart = 1;

PerformanceTiming.prototype.domContentLoadedEventEnd = 1;

PerformanceTiming.prototype.domComplete = 1;

PerformanceTiming.prototype.loadEventStart = 1;

PerformanceTiming.prototype.loadEventEnd = 1;

/*
 * PositionError
 */
function PositionError() { return ; }

PositionError.prototype.code = 1;

PositionError.prototype.message = '';

/*
 * Screen
 */
function Screen() { return ; }

Screen.prototype.height = 1;

Screen.prototype.width = 1;

Screen.prototype.colorDepth = 1;

Screen.prototype.pixelDepth = 1;

Screen.prototype.availLeft = 1;

Screen.prototype.availTop = 1;

Screen.prototype.availHeight = 1;

Screen.prototype.availWidth = 1;

/*
 * SpeechInputEvent
 */
function SpeechInputEvent() { return ; }
SpeechInputEvent.prototype = Event;

SpeechInputEvent.prototype.results = new SpeechInputResultList();

/*
 * SpeechInputResult
 */
function SpeechInputResult() { return ; }

SpeechInputResult.prototype.utterance = '';

SpeechInputResult.prototype.confidence = 1.0;

/*
 * SpeechInputResultList
 */
function SpeechInputResultList() { return ; }

SpeechInputResultList.prototype.length = 1;

SpeechInputResultList.prototype.item = function (index) { return new SpeechInputResult(); };
SpeechInputResultList.prototype.item(1);

/*
 * WebKitAnimation
 */
function WebKitAnimation() { return ; }

WebKitAnimation.prototype.name = '';

WebKitAnimation.prototype.duration = 1.0;

WebKitAnimation.prototype.elapsedTime = 1.0;

WebKitAnimation.prototype.delay = 1.0;

WebKitAnimation.prototype.iterationCount = 1;

WebKitAnimation.prototype.paused = true;

WebKitAnimation.prototype.ended = true;

WebKitAnimation.prototype.direction = 1;

WebKitAnimation.prototype.fillMode = 1;

WebKitAnimation.prototype.play = function () { return ; };
WebKitAnimation.prototype.play();

WebKitAnimation.prototype.pause = function () { return ; };
WebKitAnimation.prototype.pause();

/*
 * WebKitAnimationList
 */
function WebKitAnimationList() { return ; }

WebKitAnimationList.prototype.length = 1;

WebKitAnimationList.prototype.item = function (index) { return new WebKitAnimation(); };
WebKitAnimationList.prototype.item(1);

/*
 * WebKitPoint
 */
function WebKitPoint() { return ; }

WebKitPoint.prototype.x = 1.0;

WebKitPoint.prototype.y = 1.0;

/*
 * WorkerNavigator
 */
function WorkerNavigator() { return ; }

WorkerNavigator.prototype.appName = '';

WorkerNavigator.prototype.appVersion = '';

WorkerNavigator.prototype.platform = '';

WorkerNavigator.prototype.userAgent = '';

WorkerNavigator.prototype.onLine = true;

