/*
 * Decompiled with CFR 0.152.
 */
package elements;

import basic.Layout;
import basic.Oriented;
import conf.Dialog;
import elements.Brick;
import elements.BrickCollection;
import elements.Buttons;
import elements.Corner;
import elements.Field;
import elements.Level;
import elements.Scores;
import elements.Severity;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import values.BrickColor;
import values.GameType;
import values.Orientation;
import values.Settings;

public class Window
extends JPanel
implements MouseInputListener,
ActionListener,
WindowListener {
    private Brick activeBrick = null;
    private boolean isEmpty;
    private Settings settings;
    private Layout layout;
    private Field field;
    private Corner scores;
    private BrickCollection leftBricks;
    private BrickCollection rightBricks;
    private BrickCollection topBricks;
    private BrickCollection bottomBricks;
    private List<JMenuItem> saveSlots = new ArrayList<JMenuItem>();
    private List<JMenuItem> loadSlots = new ArrayList<JMenuItem>();

    public Window(Settings settings) {
        this.settings = settings;
        this.createBrickElements();
        this.setBackground(Settings.BACKGROUND);
        this.layout = new Layout();
        this.setLayout(this.layout);
        this.scores = new Scores(this.settings);
        Level level = new Level(this.settings);
        Buttons buttons = new Buttons(this.settings);
        Severity severity = new Severity(this.settings);
        this.add("corner,0,0", buttons);
        this.add("corner,0,1", severity);
        this.add("corner,1,0", this.scores);
        this.add("corner,1,1", level);
        this.updateLayoutFromField();
        this.updateLayoutFromCollections();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void createBrickElements() {
        this.settings.setGameOver(false);
        Integer n = this.settings.getDifficulty();
        GameType gameType = this.settings.getGameType();
        this.topBricks = new BrickCollection(n, gameType, Orientation.TOP);
        this.leftBricks = new BrickCollection(n, gameType, Orientation.LEFT);
        this.rightBricks = new BrickCollection(n, gameType, Orientation.RIGHT);
        this.bottomBricks = new BrickCollection(n, gameType, Orientation.BOTTOM);
        this.field = new Field(this.settings, this.leftBricks, this.rightBricks, this.topBricks, this.bottomBricks);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        JComponent jComponent;
        for (int i = 0; i < this.settings.getMenu().getComponentCount(); ++i) {
            jComponent = (JMenu)this.settings.getMenu().getComponent(i);
            if (!((JMenu)jComponent).isSelected()) continue;
            return;
        }
        if (this.settings.isGameOver().booleanValue()) {
            return;
        }
        Component component = this.getComponentAt(mouseEvent.getPoint());
        if (component != null && component.getClass().isAssignableFrom(Brick.class)) {
            Object object;
            jComponent = (Brick)component;
            Oriented oriented = ((Brick)jComponent).getParentCollection();
            Point point = this.layout.getPosition((Brick)jComponent);
            if (this.activeBrick != jComponent) {
                if (this.activeBrick != null && !this.field.contains(this.activeBrick) && this.activeBrick.getOrientation() != Orientation.NONE) {
                    this.activeBrick.setOrientation(Orientation.NONE);
                    object = this.activeBrick.getGraphics();
                    if (object != null) {
                        this.activeBrick.update((Graphics)object);
                    }
                }
                this.activeBrick = jComponent;
            }
            if (oriented != null && point != null) {
                int n;
                object = oriented.getOrientation();
                int n2 = this.field.check(point.x - 3, (Orientation)((Object)object));
                int n3 = this.field.check(point.y - 3, (Orientation)((Object)object));
                if ((((Orientation)((Object)object)).isVertical() && n2 >= 0 || ((Orientation)((Object)object)).isHorizontal() && n3 >= 0) && this.layout.isBorder((Brick)jComponent) && (n = n2 < 0 ? Math.abs(point.x - (n3 + 3)) : Math.abs(point.y - (n2 + 3))) != 1) {
                    ((Brick)jComponent).setOrientation(Orientation.switchOrientation((Orientation)((Object)object)));
                    jComponent.update(jComponent.getGraphics());
                }
            }
        } else if (this.activeBrick != null) {
            this.activeBrick.setOrientation(Orientation.NONE);
            this.activeBrick.update(this.activeBrick.getGraphics());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.settings.isGameOver().booleanValue()) {
            return;
        }
        if (this.activeBrick == null) {
            return;
        }
        if (this.field.contains(this.activeBrick) && mouseEvent.isAltDown() && mouseEvent.isControlDown() && mouseEvent.getClickCount() == 3) {
            int n = this.activeBrick.getColor().getIndex() + 1;
            if (n >= this.settings.getDifficulty()) {
                n = 0;
            }
            this.activeBrick.setColor(new BrickColor(n));
            this.activeBrick.repaint();
        } else if (this.activeBrick.getOrientation() != Orientation.NONE && !this.field.contains(this.activeBrick)) {
            int n;
            int n2;
            Brick brick;
            int n3;
            this.save();
            Point point = this.layout.getPosition(this.activeBrick);
            BrickCollection brickCollection = (BrickCollection)this.activeBrick.getParentCollection();
            if (brickCollection.getOrientation().isVertical()) {
                n3 = brickCollection.getOrientation() == Orientation.TOP ? 0 : 9;
                brick = brickCollection.shift(point.x - 3);
                this.field.setBrick(point.x - 3, n3, this.activeBrick);
            } else {
                n3 = brickCollection.getOrientation() == Orientation.LEFT ? 0 : 9;
                brick = brickCollection.shift(point.y - 3);
                this.field.setBrick(n3, point.y - 3, this.activeBrick);
            }
            this.activeBrick = brick;
            this.updateLayoutFromField();
            this.updateLayoutFromCollections();
            this.isEmpty = false;
            do {
                if ((n2 = this.field.move()) == 0) continue;
                this.sleep(this.settings.getMoveDelay());
                this.isEmpty = this.updateLayoutFromField();
                this.updateLayoutFromCollections();
                if (this.settings.getMoveDelay() == 0) continue;
                this.paintImmediately(this.getVisibleRect());
            } while (n2 != 0 || (n = this.removeBricks()) != 0);
            this.mouseMoved(mouseEvent);
            if (this.isEmpty) {
                this.settings.addScores(this.settings.getLevel() * 100);
                this.settings.upLevel();
                this.createBrickElements();
                this.updateLayoutFromField();
                this.updateLayoutFromCollections();
                this.activeBrick = null;
                this.settings.getUndo().setEnabled(false);
                this.repaint();
                this.removeBricks();
            }
            if (!this.field.canPlay()) {
                String string;
                JOptionPane.showMessageDialog(this, String.format(this.settings.getString("MESSAGE_GAME_END"), this.settings.getScores()), this.settings.getString("TITLE_GAME_END"), 1);
                Integer n4 = this.settings.checkHighScores();
                if (n4 >= 0 && (string = JOptionPane.showInputDialog(this, this.settings.getString("MESSAGE_GAME_HIGHSCORES"), this.settings.getString("TITLE_GAME_HIGHSCORES"), -1)) != null && !"".equals(string)) {
                    this.settings.setHighScores(n4, string);
                    this.showHighScores();
                }
                this.settings.setGameOver(true);
                this.settings.getUndo().setEnabled(false);
                this.repaint();
            }
        }
    }

    public void doResize() {
        this.updateLayoutFromField();
        this.updateLayoutFromCollections();
        this.repaint();
    }

    int removeBricks() {
        int n = this.field.analize();
        if (n != 0) {
            if (n > 0) {
                this.settings.addScores(n);
                this.scores.repaint();
            }
            this.highlightLayoutFromField();
            if (this.settings.getFireDelay() != 0) {
                this.paintImmediately(this.getVisibleRect());
            }
            this.sleep(this.settings.getFireDelay());
            this.isEmpty = this.updateLayoutFromField();
        }
        return n;
    }

    private void sleep(int n) {
        Thread.yield();
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
    }

    private boolean updateLayoutFromField() {
        boolean bl = true;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Brick brick = this.layout.getBrick(i + 3, j + 3);
                Brick brick2 = this.field.getBrick(i, j);
                if (bl && !brick2.hasSameColor(BrickColor.BLACK)) {
                    bl = false;
                }
                if (brick == brick2) continue;
                if (brick != null) {
                    this.remove(brick);
                }
                this.add(i + 3 + "," + (j + 3), brick2);
            }
        }
        this.doLayout();
        return bl;
    }

    private boolean highlightLayoutFromField() {
        boolean bl = true;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Brick brick = this.layout.getBrick(i + 3, j + 3);
                Brick brick2 = this.field.getBrick(i, j);
                if (bl && !brick2.hasSameColor(BrickColor.BLACK)) {
                    bl = false;
                }
                if (brick == brick2) continue;
                if (brick != null) {
                    this.remove(brick);
                }
                this.add(i + 3 + "," + (j + 3), new Brick(BrickColor.GRAY));
            }
        }
        this.doLayout();
        return bl;
    }

    private void updateLayoutFromCollections() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                Brick brick;
                Brick brick2 = this.layout.getBrick(i, j + 3);
                if (brick2 != (brick = this.leftBricks.getBrick(i + 1, j))) {
                    if (brick2 != null) {
                        this.remove(brick2);
                    }
                    this.add(i + "," + (j + 3), brick);
                }
                if ((brick2 = this.layout.getBrick(i + 3 + 10, j + 3)) != (brick = this.rightBricks.getBrick(i, j))) {
                    if (brick2 != null) {
                        this.remove(brick2);
                    }
                    this.add(i + 3 + 10 + "," + (j + 3), brick);
                }
                if ((brick2 = this.layout.getBrick(j + 3, i)) != (brick = this.topBricks.getBrick(j, i + 1))) {
                    if (brick2 != null) {
                        this.remove(brick2);
                    }
                    this.add(j + 3 + "," + i, brick);
                }
                if ((brick2 = this.layout.getBrick(j + 3, i + 3 + 10)) == (brick = this.bottomBricks.getBrick(j, i))) continue;
                if (brick2 != null) {
                    this.remove(brick2);
                }
                this.add(j + 3 + "," + (i + 3 + 10), brick);
            }
        }
        this.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().getClass().isAssignableFrom(JMenuItem.class)) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            if (string.equals(this.settings.getString("MENU_GAME_UNDO"))) {
                this.restore();
                this.updateLayoutFromField();
                this.updateLayoutFromCollections();
                jMenuItem.setEnabled(false);
                this.repaint();
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_SAVE"))) {
                this.performSave("");
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_LOAD"))) {
                this.performLoad("");
                return;
            }
            if (string.equals(this.settings.getString("MENU_ABOUT_HIGHSCORES"))) {
                this.showHighScores();
                return;
            }
            if (string.equals(this.settings.getString("MENU_ABOUT_GAME"))) {
                this.showAboutBox();
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_NEW"))) {
                this.newGame();
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_OPTIONS"))) {
                Dialog dialog = new Dialog(this.settings);
                if (dialog.isReInitRequired()) {
                    this.field.reInit();
                    this.topBricks.reInit();
                    this.leftBricks.reInit();
                    this.rightBricks.reInit();
                    this.bottomBricks.reInit();
                }
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_EXIT"))) {
                this.windowClosing(null);
                System.exit(0);
            }
            if (string.startsWith(this.settings.getString("MENU_GAME_SLOT"))) {
                if (jMenuItem.getName().startsWith(this.settings.getString("MENU_GAME_SAVE_SLOT"))) {
                    this.performSave(jMenuItem.getName().substring(jMenuItem.getName().length() - 1));
                    this.activateSlots();
                } else if (jMenuItem.getName().startsWith(this.settings.getString("MENU_GAME_LOAD_SLOT"))) {
                    this.performLoad(jMenuItem.getName().substring(jMenuItem.getName().length() - 1));
                }
            }
        }
    }

    private void performSave(String string) {
        File file = new File(Settings.HOME + "savegame" + string + ".dat");
        if (!"".equals(string) && file.exists() && file.isFile() && file.canRead() && JOptionPane.showConfirmDialog(this, this.settings.getString("MESSAGE_GAME_SAVE_OVER"), this.settings.getString("TITLE_GAME_SAVE"), 0) != 0) {
            return;
        }
        try {
            this.saveToFile(string);
            JOptionPane.showMessageDialog(this, this.settings.getString("MESSAGE_GAME_SAVE"), this.settings.getString("TITLE_GAME_SAVE"), 1);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.settings.getString("ERROR_SAVE"), this.settings.getString("TITLE_GAME_SAVE"), 0);
        }
    }

    private void performLoad(String string) {
        if (JOptionPane.showConfirmDialog(this, this.settings.getString("MESSAGE_GAME_LOAD"), this.settings.getString("TITLE_GAME_LOAD"), 0) == 0) {
            try {
                if (!this.loadFromFile(string)) {
                    JOptionPane.showMessageDialog(this, this.settings.getString("MESSAGE_GAME_LOAD_NO_FILE"), this.settings.getString("TITLE_GAME_LOAD"), 0);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, this.settings.getString("ERROR_LOAD"), this.settings.getString("TITLE_GAME_LOAD"), 0);
            }
        }
    }

    private void showAboutBox() {
        JOptionPane.showMessageDialog(this, this.settings.getString("MESSAGE_GAME_ABOUT"), this.settings.getString("TITLE_GAME_ABOUT"), 1, new ImageIcon(this.getClass().getClassLoader().getResource("images/icon.png")));
    }

    private void showHighScores() {
        JOptionPane.showMessageDialog(this, this.settings.getHighScores(), this.settings.getString("TITLE_GAME_HIGHSCORES"), 1);
    }

    private void newGame() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.settings.getString("MESSAGE_GAME_NEW_INVITATION"));
        JComboBox<String> jComboBox = new JComboBox<String>();
        String string = this.settings.getString("MESSAGE_GAME_NEW_COLORS");
        for (int i = 5; i <= 10; ++i) {
            jComboBox.addItem(i + " " + string);
        }
        jComboBox.setSelectedIndex(this.settings.getDifficulty() - 5);
        arrayList.add(jComboBox);
        arrayList.add(new JLabel(this.settings.getString("MESSAGE_GAME_NEW_TYPE")));
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < GameType.values().length; ++n) {
            jComboBox2.addItem(this.settings.getString(GameType.values()[n].getTitleId()));
        }
        jComboBox2.setSelectedIndex(this.settings.getGameType().toInt());
        arrayList.add(jComboBox2);
        n = JOptionPane.showConfirmDialog(this, arrayList.toArray(), this.settings.getString("TITLE_GAME_NEW"), 2, 3);
        if (n == 0) {
            this.settings.setDifficulty(jComboBox.getSelectedIndex() + 5);
            this.settings.setGameType(GameType.fromInt(jComboBox2.getSelectedIndex()));
            this.updateTitle();
            this.settings.setLevel(1);
            this.settings.setScores(0);
            this.createBrickElements();
            this.updateLayoutFromField();
            this.updateLayoutFromCollections();
            this.activeBrick = null;
            this.settings.getUndo().setEnabled(false);
            this.repaint();
        }
    }

    public void updateTitle() {
        String string = this.settings.getString(this.settings.getGameType().getTitleId());
        ((JDialog)this.getParent().getParent().getParent()).setTitle(this.settings.getString("TITLE") + " - " + string);
        ((JFrame)this.getParent().getParent().getParent().getParent()).setTitle(this.settings.getString("TITLE") + " - " + string);
    }

    public void saveToFile() throws IOException {
        this.saveToFile("");
    }

    public void saveToFile(String string) throws IOException {
        File file = new File(Settings.HOME);
        file.mkdir();
        File file2 = new File(Settings.HOME + "savegame" + string + ".dat");
        file2.createNewFile();
        if (!file2.isFile() || !file2.canWrite()) {
            throw new IOException();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(Settings.HOME + "savegame" + string + ".dat");
        this.settings.saveToStream(fileOutputStream);
        this.field.saveToStream(fileOutputStream);
        this.leftBricks.saveToStream(fileOutputStream);
        this.rightBricks.saveToStream(fileOutputStream);
        this.topBricks.saveToStream(fileOutputStream);
        this.bottomBricks.saveToStream(fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public boolean loadFromFile() throws IOException {
        return this.loadFromFile("");
    }

    public boolean loadFromFile(String string) throws IOException {
        File file = new File(Settings.HOME + "savegame" + string + ".dat");
        if (file.exists()) {
            if (file.isFile() && file.canRead()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.settings.loadFromStream(fileInputStream);
                this.field.loadFromStream(fileInputStream);
                this.leftBricks.loadFromStream(fileInputStream);
                this.leftBricks.setType(this.settings.getGameType());
                this.rightBricks.loadFromStream(fileInputStream);
                this.rightBricks.setType(this.settings.getGameType());
                this.topBricks.loadFromStream(fileInputStream);
                this.topBricks.setType(this.settings.getGameType());
                this.bottomBricks.loadFromStream(fileInputStream);
                this.bottomBricks.setType(this.settings.getGameType());
                fileInputStream.close();
                this.updateLayoutFromField();
                this.updateLayoutFromCollections();
                this.settings.getUndo().setEnabled(false);
                this.activeBrick = null;
                this.repaint();
                return true;
            }
            throw new IOException();
        }
        return false;
    }

    private void save() {
        this.settings.getUndo().setEnabled(true);
        this.field.save();
        this.leftBricks.save();
        this.rightBricks.save();
        this.topBricks.save();
        this.bottomBricks.save();
        this.settings.saveScores();
        this.scores.repaint();
    }

    private void restore() {
        this.field.restore();
        this.leftBricks.restore();
        this.rightBricks.restore();
        this.topBricks.restore();
        this.bottomBricks.restore();
        this.settings.restoreScores();
        this.scores.repaint();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.saveToFile();
            this.settings.saveHighScores();
            this.settings.saveConfiguration();
        }
        catch (IOException iOException) {
            System.out.println(this.settings.getString("ERROR_SAVE") + " (" + iOException.getMessage() + ")");
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.settings.isGameOver().booleanValue()) {
            String string = this.settings.getString("GAMEOVER");
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(Color.white);
            graphics.setFont(this.settings.getFont(true));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.drawString(string, (int)((double)this.getWidth() - rectangle2D.getWidth()) / 2, (int)((double)this.getHeight() + rectangle2D.getHeight()) / 2);
        }
    }

    public void addSaveSlot(JMenuItem jMenuItem) {
        this.saveSlots.add(jMenuItem);
    }

    public void addLoadSlot(JMenuItem jMenuItem) {
        this.loadSlots.add(jMenuItem);
    }

    public void activateSlots() {
        this.activateSaveSlots();
        this.activateLoadSlots();
    }

    private void activateSaveSlots() {
        for (JMenuItem jMenuItem : this.saveSlots) {
            String string = jMenuItem.getName();
            string = string.substring(string.length() - 1);
            File file = new File(Settings.HOME + "savegame" + string + ".dat");
            if (file.exists() && file.isFile() && file.canRead()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm");
                jMenuItem.setText(this.settings.getString("MENU_GAME_SLOT") + " " + string + " (" + simpleDateFormat.format(file.lastModified()) + ")");
                continue;
            }
            jMenuItem.setText(this.settings.getString("MENU_GAME_SLOT") + " " + string + " (none)");
        }
    }

    private void activateLoadSlots() {
        for (JMenuItem jMenuItem : this.loadSlots) {
            String string = jMenuItem.getName();
            string = string.substring(string.length() - 1);
            File file = new File(Settings.HOME + "savegame" + string + ".dat");
            if (file.exists() && file.isFile() && file.canRead()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm");
                jMenuItem.setText(this.settings.getString("MENU_GAME_SLOT") + " " + string + " (" + simpleDateFormat.format(file.lastModified()) + ")");
                jMenuItem.setEnabled(true);
                continue;
            }
            jMenuItem.setText(this.settings.getString("MENU_GAME_SLOT") + " " + string + " (none)");
            jMenuItem.setEnabled(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

