/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Factory;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;
import org.gradle.plugins.ide.idea.model.internal.IdeaDependenciesOptimizer;
import org.gradle.plugins.ide.idea.model.internal.ModuleDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.IdeDependencySet;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;
import org.gradle.plugins.ide.internal.resolver.UnresolvedIdeDependencyHandler;

public class IdeaDependenciesProvider {
    public static final String SCOPE_PLUS = "plus";
    public static final String SCOPE_MINUS = "minus";
    private final ModuleDependencyBuilder moduleDependencyBuilder;
    private final IdeaDependenciesOptimizer optimizer;
    private final ProjectComponentIdentifier currentProjectId;

    public IdeaDependenciesProvider(Project project, IdeArtifactRegistry artifactRegistry, ProjectStateRegistry projectRegistry) {
        this.moduleDependencyBuilder = new ModuleDependencyBuilder(artifactRegistry);
        this.currentProjectId = projectRegistry.stateFor(project).getComponentIdentifier();
        this.optimizer = new IdeaDependenciesOptimizer();
    }

    public Set<Dependency> provide(IdeaModule ideaModule) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.getOutputLocations(ideaModule));
        result.addAll(this.getDependencies(ideaModule));
        return result;
    }

    private Set<SingleEntryModuleLibrary> getOutputLocations(IdeaModule ideaModule) {
        if (ideaModule.getSingleEntryLibraries() == null) {
            return Collections.emptySet();
        }
        LinkedHashSet outputLocations = Sets.newLinkedHashSet();
        for (Map.Entry<String, Iterable<File>> outputLocation : ideaModule.getSingleEntryLibraries().entrySet()) {
            String scope = outputLocation.getKey();
            for (File file : outputLocation.getValue()) {
                if (file == null || !file.isDirectory()) continue;
                outputLocations.add(new SingleEntryModuleLibrary(this.toPath(ideaModule, file), scope));
            }
        }
        return outputLocations;
    }

    private Set<Dependency> getDependencies(IdeaModule ideaModule) {
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        LinkedHashMap unresolvedDependencies = Maps.newLinkedHashMap();
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            IdeaDependenciesVisitor visitor = this.visitDependencies(ideaModule, scope);
            dependencies.addAll(visitor.getDependencies());
            unresolvedDependencies.putAll(visitor.getUnresolvedDependencies());
        }
        this.optimizer.optimizeDeps(dependencies);
        new UnresolvedIdeDependencyHandler().log(unresolvedDependencies.values());
        return dependencies;
    }

    private IdeaDependenciesVisitor visitDependencies(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        ProjectInternal projectInternal = (ProjectInternal)ideaModule.getProject();
        final DependencyHandler handler = projectInternal.getDependencies();
        final Collection<Configuration> plusConfigurations = this.getPlusConfigurations(ideaModule, scope);
        final Collection<Configuration> minusConfigurations = this.getMinusConfigurations(ideaModule, scope);
        final IdeaDependenciesVisitor visitor = new IdeaDependenciesVisitor(ideaModule, scope.name());
        return (IdeaDependenciesVisitor)projectInternal.getMutationState().withMutableState((Factory)new Factory<IdeaDependenciesVisitor>(){

            @Nullable
            public IdeaDependenciesVisitor create() {
                new IdeDependencySet(handler, plusConfigurations, minusConfigurations).visit(visitor);
                return visitor;
            }
        });
    }

    private Collection<Configuration> getPlusConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        return this.getConfigurations(ideaModule, scope, SCOPE_PLUS);
    }

    private Collection<Configuration> getMinusConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        return this.getConfigurations(ideaModule, scope, SCOPE_MINUS);
    }

    private Collection<Configuration> getConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope, String plusMinus) {
        Map<String, Collection<Configuration>> plusMinusConfigurations = this.getPlusMinusConfigurations(ideaModule, scope);
        return plusMinusConfigurations.containsKey(plusMinus) ? plusMinusConfigurations.get(plusMinus) : Collections.emptyList();
    }

    private Map<String, Collection<Configuration>> getPlusMinusConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        Map<String, Collection<Configuration>> plusMinusConfigurations = ideaModule.getScopes().get(scope.name());
        return plusMinusConfigurations != null ? plusMinusConfigurations : Collections.emptyMap();
    }

    private FilePath toPath(IdeaModule ideaModule, File file) {
        return file != null ? ideaModule.getPathFactory().path(file) : null;
    }

    private class IdeaDependenciesVisitor
    implements IdeDependencyVisitor {
        private final IdeaModule ideaModule;
        private final UnresolvedIdeDependencyHandler unresolvedIdeDependencyHandler = new UnresolvedIdeDependencyHandler();
        private final String scope;
        private final List<Dependency> projectDependencies = Lists.newLinkedList();
        private final List<Dependency> moduleDependencies = Lists.newLinkedList();
        private final List<Dependency> fileDependencies = Lists.newLinkedList();
        private final Map<ComponentSelector, UnresolvedDependencyResult> unresolvedDependencies = Maps.newLinkedHashMap();

        private IdeaDependenciesVisitor(IdeaModule ideaModule, String scope) {
            this.ideaModule = ideaModule;
            this.scope = scope;
        }

        @Override
        public boolean isOffline() {
            return this.ideaModule.isOffline();
        }

        @Override
        public boolean downloadSources() {
            return this.ideaModule.isDownloadSources();
        }

        @Override
        public boolean downloadJavaDoc() {
            return this.ideaModule.isDownloadJavadoc();
        }

        @Override
        public void visitProjectDependency(ResolvedArtifactResult artifact) {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
            if (!projectId.equals(IdeaDependenciesProvider.this.currentProjectId)) {
                this.projectDependencies.add(IdeaDependenciesProvider.this.moduleDependencyBuilder.create(projectId, this.scope));
            }
        }

        @Override
        public void visitModuleDependency(ResolvedArtifactResult artifact, Set<ResolvedArtifactResult> sources, Set<ResolvedArtifactResult> javaDoc, boolean testDependency) {
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
            SingleEntryModuleLibrary library = new SingleEntryModuleLibrary(IdeaDependenciesProvider.this.toPath(this.ideaModule, artifact.getFile()), this.scope);
            library.setModuleVersion(DefaultModuleVersionIdentifier.newId((ModuleIdentifier)moduleId.getModuleIdentifier(), (String)moduleId.getVersion()));
            LinkedHashSet sourcePaths = Sets.newLinkedHashSet();
            for (ResolvedArtifactResult sourceArtifact : sources) {
                sourcePaths.add(IdeaDependenciesProvider.this.toPath(this.ideaModule, sourceArtifact.getFile()));
            }
            library.setSources(sourcePaths);
            LinkedHashSet javaDocPaths = Sets.newLinkedHashSet();
            for (ResolvedArtifactResult javaDocArtifact : javaDoc) {
                javaDocPaths.add(IdeaDependenciesProvider.this.toPath(this.ideaModule, javaDocArtifact.getFile()));
            }
            library.setJavadoc(javaDocPaths);
            this.moduleDependencies.add(library);
        }

        @Override
        public void visitFileDependency(ResolvedArtifactResult artifact, boolean testDependency) {
            this.fileDependencies.add(new SingleEntryModuleLibrary(IdeaDependenciesProvider.this.toPath(this.ideaModule, artifact.getFile()), this.scope));
        }

        @Override
        public void visitUnresolvedDependency(UnresolvedDependencyResult unresolvedDependency) {
            File unresolvedFile = this.unresolvedIdeDependencyHandler.asFile(unresolvedDependency, this.ideaModule.getContentRoot());
            this.fileDependencies.add(new SingleEntryModuleLibrary(IdeaDependenciesProvider.this.toPath(this.ideaModule, unresolvedFile), this.scope));
            this.unresolvedDependencies.put(unresolvedDependency.getAttempted(), unresolvedDependency);
        }

        public Collection<Dependency> getDependencies() {
            LinkedHashSet dependencies = Sets.newLinkedHashSet();
            dependencies.addAll(this.projectDependencies);
            dependencies.addAll(this.moduleDependencies);
            dependencies.addAll(this.fileDependencies);
            return dependencies;
        }

        public Map<ComponentSelector, UnresolvedDependencyResult> getUnresolvedDependencies() {
            return this.unresolvedDependencies;
        }
    }
}

