/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0019H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0015H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"BUILT_IN_FUNCTION_ARITY_COUNT", "", "getBUILT_IN_FUNCTION_ARITY_COUNT", "()I", "BUILT_IN_FUNCTION_CLASS_COUNT", "getBUILT_IN_FUNCTION_CLASS_COUNT", "BUILT_IN_UNIQ_ID_CLASS_OFFSET", "getBUILT_IN_UNIQ_ID_CLASS_OFFSET", "BUILT_IN_UNIQ_ID_GAP", "getBUILT_IN_UNIQ_ID_GAP", "functionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "functionalPackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinFqn", "builtInFunctionId", "", "value", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "builtInOffset", "function", "Lorg/jetbrains/kotlin/builtins/functions/FunctionInvokeDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isBuiltInFunction", "", "ir.serialization.js"})
public final class JsDeclarationTableUtilsKt {
    private static final Pattern functionPattern = Pattern.compile("^K?(Suspend)?Function\\d+$");
    private static final FqName kotlinFqn = new FqName("kotlin");
    private static final List<FqName> functionalPackages;
    private static final int BUILT_IN_FUNCTION_CLASS_COUNT = 4;
    private static final int BUILT_IN_FUNCTION_ARITY_COUNT = 256;
    private static final int BUILT_IN_UNIQ_ID_GAP = 2048;
    private static final int BUILT_IN_UNIQ_ID_CLASS_OFFSET = 1024;

    public static final int getBUILT_IN_FUNCTION_CLASS_COUNT() {
        return BUILT_IN_FUNCTION_CLASS_COUNT;
    }

    public static final int getBUILT_IN_FUNCTION_ARITY_COUNT() {
        return BUILT_IN_FUNCTION_ARITY_COUNT;
    }

    public static final int getBUILT_IN_UNIQ_ID_GAP() {
        return BUILT_IN_UNIQ_ID_GAP;
    }

    public static final int getBUILT_IN_UNIQ_ID_CLASS_OFFSET() {
        return BUILT_IN_UNIQ_ID_CLASS_OFFSET;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuiltInFunction(@NotNull IrDeclaration value) {
        FqName it;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        IrDeclaration irDeclaration = value;
        if (irDeclaration instanceof IrSimpleFunction) {
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)value).getName().asString(), (Object)"invoke")) return false;
            IrDeclarationParent irDeclarationParent = value.getParent();
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) return false;
            IrClass irClass2 = irClass;
            boolean bl = false;
            boolean bl2 = false;
            IrClass it2 = irClass2;
            boolean bl3 = false;
            if (!JsDeclarationTableUtilsKt.isBuiltInFunction(it2)) return false;
            return true;
        }
        if (!(irDeclaration instanceof IrClass)) return false;
        FqName fqn = AdditionalIrUtilsKt.getFqNameSafe(value.getParent());
        Iterable $this$any$iv = functionalPackages;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FqName)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)fqn));
        boolean bl = true;
        if (!bl) return false;
        String string = ((IrClass)value).getName().asString();
        boolean bl4 = false;
        boolean bl5 = false;
        String it3 = string;
        boolean bl6 = false;
        if (!functionPattern.matcher(it3).find()) return false;
        return true;
    }

    private static final long builtInOffset(IrSimpleFunction function2) {
        String string = IrUtilsKt.getParentAsClass(function2).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"function.parentAsClass.name.asString()");
        boolean isK = StringsKt.startsWith$default((String)string, (String)"K", (boolean)false, (int)2, null);
        return isK && function2.isSuspend() ? 3L : (isK ? 2L : (function2.isSuspend() ? 1L : 0L));
    }

    /*
     * WARNING - void declaration
     */
    public static final long builtInFunctionId(@NotNull IrDeclaration value) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        IrDeclaration irDeclaration = value;
        if (irDeclaration instanceof IrSimpleFunction) {
            IrDeclaration irDeclaration2 = value;
            boolean bl = false;
            boolean bl2 = false;
            IrSimpleFunction $this$run = (IrSimpleFunction)irDeclaration2;
            boolean bl3 = false;
            l = (long)$this$run.getValueParameters().size() + JsDeclarationTableUtilsKt.builtInOffset((IrSimpleFunction)value) * (long)BUILT_IN_FUNCTION_ARITY_COUNT;
        } else if (irDeclaration instanceof IrClass) {
            Object element$iv2;
            long l2;
            block5: {
                void $this$first$iv;
                Iterable iterable = ((IrClass)value).getDeclarations();
                l2 = BUILT_IN_UNIQ_ID_CLASS_OFFSET;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getName(it).asString(), (Object)"invoke")) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            l = l2 + JsDeclarationTableUtilsKt.builtInFunctionId((IrDeclaration)t);
        } else {
            String string = "Only class or function is expected";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuiltInFunction(@NotNull DeclarationDescriptor value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        DeclarationDescriptor declarationDescriptor = value;
        if (!(declarationDescriptor instanceof FunctionInvokeDescriptor)) {
            FqName it;
            if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
            DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)value).getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof PackageFragmentDescriptor)) {
                declarationDescriptor2 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor2;
            FqName fqn = packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
            Iterable $this$any$iv = functionalPackages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FqName)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual((Object)it, (Object)fqn));
            boolean bl = true;
            if (!bl) return false;
            String string = ((ClassDescriptor)value).getName().asString();
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string;
            boolean bl4 = false;
            if (!functionPattern.matcher(it2).find()) return false;
            return true;
        }
        DeclarationDescriptor declarationDescriptor3 = ((FunctionInvokeDescriptor)value).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"value.containingDeclaration");
        boolean bl = JsDeclarationTableUtilsKt.isBuiltInFunction(declarationDescriptor3);
        return bl;
    }

    private static final long builtInOffset(FunctionInvokeDescriptor function2) {
        DeclarationDescriptor declarationDescriptor = function2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"function.containingDeclaration");
        String string = declarationDescriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"function.containingDeclaration.name.asString()");
        boolean isK = StringsKt.startsWith$default((String)string, (String)"K", (boolean)false, (int)2, null);
        return isK && function2.isSuspend() ? 3L : (isK ? 2L : (function2.isSuspend() ? 1L : 0L));
    }

    /*
     * WARNING - void declaration
     */
    public static final long builtInFunctionId(@NotNull DeclarationDescriptor value) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        DeclarationDescriptor declarationDescriptor = value;
        if (declarationDescriptor instanceof FunctionInvokeDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = value;
            boolean bl = false;
            boolean bl2 = false;
            FunctionInvokeDescriptor $this$run = (FunctionInvokeDescriptor)declarationDescriptor2;
            boolean bl3 = false;
            l = (long)$this$run.getValueParameters().size() + JsDeclarationTableUtilsKt.builtInOffset((FunctionInvokeDescriptor)value) * (long)BUILT_IN_FUNCTION_ARITY_COUNT;
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            Object element$iv$iv$iv2;
            long l2;
            block5: {
                void name$iv;
                void $this$findFirstFunction$iv;
                ClassDescriptor classDescriptor2 = (ClassDescriptor)value;
                String string = "invoke";
                l2 = BUILT_IN_UNIQ_ID_CLASS_OFFSET;
                boolean $i$f$findFirstFunction = false;
                MemberScope memberScope2 = $this$findFirstFunction$iv.getUnsubstitutedMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"unsubstitutedMemberScope");
                MemberScope $this$findFirstFunction$iv$iv = memberScope2;
                boolean $i$f$findFirstFunction2 = false;
                Name name = Name.identifier((String)name$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(name)");
                Iterable $this$first$iv$iv$iv = $this$findFirstFunction$iv$iv.getContributedFunctions(name, NoLookupLocation.FROM_BACKEND);
                boolean $i$f$first = false;
                for (Object element$iv$iv$iv2 : $this$first$iv$iv$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv$iv2;
                    boolean bl = false;
                    if (!true) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)element$iv$iv$iv2;
            l = l2 + JsDeclarationTableUtilsKt.builtInFunctionId(simpleFunctionDescriptor);
        } else {
            String string = "Only class or function is expected";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return l;
    }

    static {
        Object[] objectArray = new FqName[3];
        objectArray[0] = kotlinFqn;
        FqName fqName2 = kotlinFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"kotlinFqn.child(Name.identifier(\"coroutines\"))");
        objectArray[1] = fqName2;
        FqName fqName3 = kotlinFqn.child(Name.identifier("reflect"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"kotlinFqn.child(Name.identifier(\"reflect\"))");
        objectArray[2] = fqName3;
        functionalPackages = CollectionsKt.listOf((Object[])objectArray);
        BUILT_IN_FUNCTION_CLASS_COUNT = 4;
        BUILT_IN_FUNCTION_ARITY_COUNT = 256;
        BUILT_IN_UNIQ_ID_GAP = 2 * BUILT_IN_FUNCTION_ARITY_COUNT * BUILT_IN_FUNCTION_CLASS_COUNT;
        BUILT_IN_UNIQ_ID_CLASS_OFFSET = BUILT_IN_FUNCTION_CLASS_COUNT * BUILT_IN_FUNCTION_ARITY_COUNT;
    }
}

