/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0017JJ\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u0019*\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u00190\u00042\u0006\u0010\u001b\u001a\u0002H\u001a2\u0014\b\u0004\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u00190\u001dH\u0084\b\u00a2\u0006\u0002\u0010\u001eJv\u0010\u001f\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u0019\"\u0004\b\u0002\u0010 *\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u00190\u00042\u0006\u0010\u001b\u001a\u0002H\u001a2 \b\u0004\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u0002H\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H 0!0\u001d2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u00120#H\u0084\b\u00a2\u0006\u0002\u0010$R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/AbstractFirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "()V", "classCache", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeSymbol;", "getClassCache", "()Ljava/util/Map;", "packageCache", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageCache", "topLevelCallableCache", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/ConeCallableSymbol;", "getTopLevelCallableCache", "transformTopLevelClasses", "", "D", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "data", "(Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)V", "lookupCacheOrCalculate", "V", "K", "key", "l", "Lkotlin/Function1;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "lookupCacheOrCalculateWithPostCompute", "T", "Lkotlin/Pair;", "postCompute", "Lkotlin/Function2;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "resolve"})
public abstract class AbstractFirSymbolProvider
implements FirSymbolProvider {
    @NotNull
    private final Map<ClassId, ConeClassLikeSymbol> classCache;
    @NotNull
    private final Map<CallableId, List<ConeCallableSymbol>> topLevelCallableCache;
    @NotNull
    private final Map<FqName, FqName> packageCache;

    @NotNull
    protected final Map<ClassId, ConeClassLikeSymbol> getClassCache() {
        return this.classCache;
    }

    @NotNull
    protected final Map<CallableId, List<ConeCallableSymbol>> getTopLevelCallableCache() {
        return this.topLevelCallableCache;
    }

    @NotNull
    protected final Map<FqName, FqName> getPackageCache() {
        return this.packageCache;
    }

    @Nullable
    protected final <K, V> V lookupCacheOrCalculate(@NotNull Map<K, V> $this$lookupCacheOrCalculate, K key, @NotNull Function1<? super K, ? extends V> l) {
        Object object;
        int $i$f$lookupCacheOrCalculate = 0;
        Intrinsics.checkParameterIsNotNull($this$lookupCacheOrCalculate, (String)"$this$lookupCacheOrCalculate");
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        if ($this$lookupCacheOrCalculate.keySet().contains(key)) {
            object = $this$lookupCacheOrCalculate.get(key);
        } else {
            Object calculated = l.invoke(key);
            $this$lookupCacheOrCalculate.put(key, calculated);
            object = calculated;
        }
        return object;
    }

    @Nullable
    protected final <K, V, T> V lookupCacheOrCalculateWithPostCompute(@NotNull Map<K, V> $this$lookupCacheOrCalculateWithPostCompute, K key, @NotNull Function1<? super K, ? extends Pair<? extends V, ? extends T>> l, @NotNull Function2<? super V, ? super T, Unit> postCompute) {
        Object object;
        int $i$f$lookupCacheOrCalculateWithPostCompute = 0;
        Intrinsics.checkParameterIsNotNull($this$lookupCacheOrCalculateWithPostCompute, (String)"$this$lookupCacheOrCalculateWithPostCompute");
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        Intrinsics.checkParameterIsNotNull(postCompute, (String)"postCompute");
        if ($this$lookupCacheOrCalculateWithPostCompute.keySet().contains(key)) {
            object = $this$lookupCacheOrCalculateWithPostCompute.get(key);
        } else {
            Pair calculated = (Pair)l.invoke(key);
            $this$lookupCacheOrCalculateWithPostCompute.put(key, calculated.getFirst());
            postCompute.invoke(calculated.getFirst(), calculated.getSecond());
            object = calculated.getFirst();
        }
        return object;
    }

    public final <D> void transformTopLevelClasses(@NotNull FirTransformer<? super D> transformer, D data) {
        Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
        Iterable iterable = this.classCache.values();
        boolean bl = false;
        List list2 = new ArrayList();
        List symbols2 = (List)CollectionsKt.filterNotNullTo((Iterable)iterable, (Collection)list2);
        for (ConeClassLikeSymbol symbol2 : symbols2) {
            if (!(symbol2 instanceof FirClassSymbol)) continue;
            FqName fqName2 = symbol2.getClassId().getRelativeClassName().parent();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"symbol.classId.relativeClassName.parent()");
            if (!fqName2.isRoot()) continue;
            ((FirRegularClass)((FirClassSymbol)symbol2).getFir()).transform(transformer, data);
        }
    }

    public AbstractFirSymbolProvider() {
        Map map2;
        AbstractFirSymbolProvider abstractFirSymbolProvider = this;
        boolean bl = false;
        abstractFirSymbolProvider.classCache = map2 = (Map)new LinkedHashMap();
        abstractFirSymbolProvider = this;
        bl = false;
        abstractFirSymbolProvider.topLevelCallableCache = map2 = (Map)new LinkedHashMap();
        abstractFirSymbolProvider = this;
        bl = false;
        abstractFirSymbolProvider.packageCache = map2 = (Map)new LinkedHashMap();
    }

    @Override
    @Nullable
    public ConeClassifierSymbol getSymbolByLookupTag(@NotNull ConeClassifierLookupTag lookupTag) {
        Intrinsics.checkParameterIsNotNull((Object)lookupTag, (String)"lookupTag");
        return FirSymbolProvider.DefaultImpls.getSymbolByLookupTag(this, lookupTag);
    }

    @Override
    @NotNull
    public Set<Name> getAllCallableNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return FirSymbolProvider.DefaultImpls.getAllCallableNamesInPackage(this, fqName2);
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return FirSymbolProvider.DefaultImpls.getClassNamesInPackage(this, fqName2);
    }

    @Override
    @NotNull
    public Set<Name> getAllCallableNamesInClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return FirSymbolProvider.DefaultImpls.getAllCallableNamesInClass(this, classId);
    }

    @Override
    @NotNull
    public Set<Name> getNestedClassesNamesInClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return FirSymbolProvider.DefaultImpls.getNestedClassesNamesInClass(this, classId);
    }

    @Override
    @Nullable
    public FirSession getSessionForClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return FirSymbolProvider.DefaultImpls.getSessionForClass(this, classId);
    }
}

