/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;

public final class NameValidator {
    private static final char[] FORBIDDEN_CHARACTERS = new char[]{'/', '\\', ':', '<', '>', '\"', '?', '*', '|'};
    private static final char FORBIDDEN_LEADING_AND_TRAILING_CHARACTER = '.';

    private NameValidator() {
    }

    public static void validate(String name, String nameDescription, String fixSuggestion) throws InvalidUserDataException {
        if (StringUtils.isEmpty((String)name)) {
            throw NameValidator.newInvalidUserDataException("The " + nameDescription + " must not be empty.", fixSuggestion);
        }
        if (StringUtils.containsAny((String)name, (char[])FORBIDDEN_CHARACTERS)) {
            throw NameValidator.newInvalidUserDataException("The " + nameDescription + " '" + name + "' must not contain any of the following characters: " + Arrays.toString(FORBIDDEN_CHARACTERS) + ".", fixSuggestion);
        }
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            throw NameValidator.newInvalidUserDataException("The " + nameDescription + " '" + name + "' must not start or end with a '" + '.' + "'.", fixSuggestion);
        }
    }

    private static InvalidUserDataException newInvalidUserDataException(String message, String fixSuggestion) {
        return new InvalidUserDataException(message + (StringUtils.isBlank((String)fixSuggestion) ? "" : " " + fixSuggestion));
    }
}

