/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.zip.ZipInputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.JdkZipEntry;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.api.internal.changedetection.state.ZipInput;

class StreamZipInput
implements ZipInput {
    private final ZipInputStream in;

    public StreamZipInput(InputStream in) {
        this.in = new ZipInputStream(in);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            protected ZipEntry computeNext() {
                java.util.zip.ZipEntry nextEntry;
                try {
                    nextEntry = StreamZipInput.this.in.getNextEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
                return nextEntry == null ? (ZipEntry)this.endOfData() : new JdkZipEntry(nextEntry, new Supplier<InputStream>(){

                    @Override
                    public InputStream get() {
                        return StreamZipInput.this.in;
                    }
                });
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

