/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.AttributeSelectionUtils;
import org.gradle.internal.component.model.ComponentAttributeMatcher;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;
import org.gradle.internal.component.model.DefaultMultipleCandidateResult;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultAttributesSchema
implements AttributesSchemaInternal,
AttributesSchema {
    private final ComponentAttributeMatcher componentAttributeMatcher;
    private final InstantiatorFactory instantiatorFactory;
    private final Map<Attribute<?>, AttributeMatchingStrategy<?>> strategies = Maps.newHashMap();
    private final Map<String, Attribute<?>> attributesByName = Maps.newHashMap();
    private final DefaultAttributeMatcher matcher;
    private final IsolatableFactory isolatableFactory;
    private final Map<ExtraAttributesEntry, Attribute<?>[]> extraAttributesCache = Maps.newHashMap();

    public DefaultAttributesSchema(ComponentAttributeMatcher componentAttributeMatcher, InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory) {
        this.componentAttributeMatcher = componentAttributeMatcher;
        this.instantiatorFactory = instantiatorFactory;
        this.matcher = new DefaultAttributeMatcher(componentAttributeMatcher, this.mergeWith(EmptySchema.INSTANCE));
        this.isolatableFactory = isolatableFactory;
    }

    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        AttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return (AttributeMatchingStrategy)Cast.uncheckedCast(strategy);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, Action<? super AttributeMatchingStrategy<T>> configureAction) {
        AttributeMatchingStrategy strategy = (AttributeMatchingStrategy)Cast.uncheckedCast(this.strategies.get(attribute));
        if (strategy == null) {
            strategy = (AttributeMatchingStrategy)Cast.uncheckedCast((Object)this.instantiatorFactory.decorateLenient().newInstance(DefaultAttributeMatchingStrategy.class, new Object[]{this.instantiatorFactory, this.isolatableFactory}));
            this.strategies.put(attribute, strategy);
            this.attributesByName.put(attribute.getName(), attribute);
        }
        if (configureAction != null) {
            configureAction.execute((Object)strategy);
        }
        return strategy;
    }

    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }

    AttributeSelectionSchema mergeWith(AttributesSchemaInternal producerSchema) {
        return new MergedSchema(producerSchema);
    }

    @Override
    public AttributeMatcher withProducer(AttributesSchemaInternal producerSchema) {
        return new DefaultAttributeMatcher(this.componentAttributeMatcher, this.mergeWith(producerSchema));
    }

    @Override
    public AttributeMatcher matcher() {
        return this.matcher;
    }

    @Override
    public CompatibilityRule<Object> compatibilityRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (CompatibilityRule)Cast.uncheckedCast((Object)matchingStrategy.getCompatibilityRules());
        }
        return EmptySchema.INSTANCE.compatibilityRules(attribute);
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (DisambiguationRule)Cast.uncheckedCast((Object)matchingStrategy.getDisambiguationRules());
        }
        return EmptySchema.INSTANCE.disambiguationRules(attribute);
    }

    private static class ExtraAttributesEntry {
        private final ImmutableAttributes[] candidateAttributeSets;
        private final ImmutableAttributes requestedAttributes;
        private final int hashCode;

        private ExtraAttributesEntry(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requestedAttributes) {
            this.candidateAttributeSets = candidateAttributeSets;
            this.requestedAttributes = requestedAttributes;
            int hash = Arrays.hashCode(candidateAttributeSets);
            this.hashCode = hash = 31 * hash + requestedAttributes.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraAttributesEntry that = (ExtraAttributesEntry)o;
            if (this.requestedAttributes != that.requestedAttributes) {
                return false;
            }
            if (this.candidateAttributeSets.length != that.candidateAttributeSets.length) {
                return false;
            }
            for (int i = 0; i < this.candidateAttributeSets.length; ++i) {
                if (this.candidateAttributeSets[i] == that.candidateAttributeSets[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class MergedSchema
    implements AttributeSelectionSchema {
        private final AttributesSchemaInternal producerSchema;

        MergedSchema(AttributesSchemaInternal producerSchema) {
            this.producerSchema = producerSchema;
        }

        @Override
        public boolean hasAttribute(Attribute<?> attribute) {
            return DefaultAttributesSchema.this.getAttributes().contains(attribute) || this.producerSchema.getAttributes().contains(attribute);
        }

        @Override
        public Set<Object> disambiguate(Attribute<?> attribute, Object requested, Set<Object> candidates) {
            DefaultMultipleCandidateResult<Object> result = null;
            DisambiguationRule<Object> rules = DefaultAttributesSchema.this.disambiguationRules(attribute);
            if (rules.doesSomething()) {
                result = new DefaultMultipleCandidateResult<Object>(requested, candidates);
                rules.execute(result);
                if (result.hasResult()) {
                    return result.getMatches();
                }
            }
            if ((rules = this.producerSchema.disambiguationRules(attribute)).doesSomething()) {
                if (result == null) {
                    result = new DefaultMultipleCandidateResult<Object>(requested, candidates);
                }
                rules.execute(result);
                if (result.hasResult()) {
                    return result.getMatches();
                }
            }
            if (requested != null && candidates.contains(requested)) {
                return Collections.singleton(requested);
            }
            return candidates;
        }

        @Override
        public boolean matchValue(Attribute<?> attribute, Object requested, Object candidate) {
            if (requested.equals(candidate)) {
                return true;
            }
            DefaultCompatibilityCheckResult<Object> result = null;
            CompatibilityRule<Object> rules = DefaultAttributesSchema.this.compatibilityRules(attribute);
            if (rules.doesSomething()) {
                result = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
                rules.execute(result);
                if (result.hasResult()) {
                    return result.isCompatible();
                }
            }
            if ((rules = this.producerSchema.compatibilityRules(attribute)).doesSomething()) {
                if (result == null) {
                    result = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
                }
                rules.execute(result);
                if (result.hasResult()) {
                    return result.isCompatible();
                }
            }
            return false;
        }

        @Override
        public Attribute<?> getAttribute(String name) {
            Attribute attribute = (Attribute)DefaultAttributesSchema.this.attributesByName.get(name);
            if (attribute != null) {
                return attribute;
            }
            if (this.producerSchema instanceof DefaultAttributesSchema) {
                return (Attribute)((DefaultAttributesSchema)this.producerSchema).attributesByName.get(name);
            }
            for (Attribute producerAttribute : this.producerSchema.getAttributes()) {
                if (!producerAttribute.getName().equals(name)) continue;
                return producerAttribute;
            }
            return null;
        }

        @Override
        public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requested) {
            ExtraAttributesEntry entry = new ExtraAttributesEntry(candidateAttributeSets, requested);
            Attribute[] attributes = (Attribute[])DefaultAttributesSchema.this.extraAttributesCache.get(entry);
            if (attributes == null) {
                attributes = AttributeSelectionUtils.collectExtraAttributes(this, candidateAttributeSets, requested);
                DefaultAttributesSchema.this.extraAttributesCache.put(entry, attributes);
            }
            return attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergedSchema that = (MergedSchema)o;
            return this.producerSchema.equals(that.producerSchema);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.producerSchema});
        }
    }

    private static class DefaultAttributeMatcher
    implements AttributeMatcher {
        private final ComponentAttributeMatcher componentAttributeMatcher;
        private final AttributeSelectionSchema effectiveSchema;

        DefaultAttributeMatcher(ComponentAttributeMatcher componentAttributeMatcher, AttributeSelectionSchema effectiveSchema) {
            this.componentAttributeMatcher = componentAttributeMatcher;
            this.effectiveSchema = effectiveSchema;
        }

        @Override
        public boolean isMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
            return this.componentAttributeMatcher.isMatching(this.effectiveSchema, candidate, requested);
        }

        @Override
        public <T> boolean isMatching(Attribute<T> attribute, T candidate, T requested) {
            return this.effectiveSchema.matchValue(attribute, requested, candidate);
        }

        @Override
        public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested) {
            return this.matches(candidates, requested, null);
        }

        @Override
        public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested, @Nullable T fallback) {
            return this.componentAttributeMatcher.match(this.effectiveSchema, candidates, requested, fallback);
        }

        @Override
        public List<AttributeMatcher.MatchingDescription> describeMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
            return this.componentAttributeMatcher.describeMatching(this.effectiveSchema, candidate, requested);
        }
    }
}

