/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.OutputsCleaner;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.util.GFileUtils;

public class CleanupOutputsStep<C extends InputChangesContext, R extends Result>
implements Step<C, R> {
    private final Step<? super C, ? extends R> delegate;

    public CleanupOutputsStep(Step<? super C, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(C context) {
        UnitOfWork work;
        boolean incremental = context.getInputChanges().map(inputChanges -> inputChanges.isIncremental()).orElse(false);
        if (!incremental && (work = context.getWork()).shouldCleanupOutputsOnNonIncrementalExecution()) {
            if (work.hasOverlappingOutputs()) {
                this.cleanupOverlappingOutputs((BeforeExecutionContext)context, work);
            } else {
                this.cleanupExclusiveOutputs(work);
            }
        }
        return this.delegate.execute(context);
    }

    private void cleanupOverlappingOutputs(BeforeExecutionContext context, UnitOfWork work) {
        context.getAfterPreviousExecutionState().ifPresent(previousOutputs -> {
            HashSet outputDirectoriesToPreserve = new HashSet();
            work.visitOutputProperties((name, type, roots) -> {
                switch (type) {
                    case FILE: {
                        for (File root : roots) {
                            File parentFile = root.getParentFile();
                            if (parentFile == null) continue;
                            outputDirectoriesToPreserve.add(parentFile);
                        }
                        break;
                    }
                    case DIRECTORY: {
                        Iterables.addAll((Collection)outputDirectoriesToPreserve, (Iterable)roots);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            });
            OutputsCleaner cleaner = new OutputsCleaner(file -> true, dir -> !outputDirectoriesToPreserve.contains(dir));
            for (FileCollectionFingerprint fileCollectionFingerprint : previousOutputs.getOutputFileProperties().values()) {
                try {
                    cleaner.cleanupOutputs(fileCollectionFingerprint);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to clean up output files for " + work.getDisplayName(), e);
                }
            }
        });
    }

    private void cleanupExclusiveOutputs(UnitOfWork work) {
        work.visitOutputProperties((name, type, roots) -> {
            block4: for (File root : roots) {
                if (!root.exists()) continue;
                switch (type) {
                    case FILE: {
                        GFileUtils.forceDelete((File)root);
                        continue block4;
                    }
                    case DIRECTORY: {
                        GFileUtils.cleanDirectory((File)root);
                        continue block4;
                    }
                }
                throw new AssertionError();
            }
        });
    }
}

