(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/text/base58#alphabet::t
    (make-struct-type
     'std/text/base58#alphabet::t
     '#f
     '2
     'alphabet
     '((final: . #t))
     ':init!
     '(enc dec)))
  (define std/text/base58#alphabet?
    (make-struct-predicate std/text/base58#alphabet::t))
  (define std/text/base58#make-alphabet
    (lambda _$args112386_
      (apply make-struct-instance std/text/base58#alphabet::t _$args112386_)))
  (define std/text/base58#alphabet-enc
    (make-struct-field-accessor std/text/base58#alphabet::t '0))
  (define std/text/base58#alphabet-dec
    (make-struct-field-accessor std/text/base58#alphabet::t '1))
  (define std/text/base58#alphabet-enc-set!
    (make-struct-field-mutator std/text/base58#alphabet::t '0))
  (define std/text/base58#alphabet-dec-set!
    (make-struct-field-mutator std/text/base58#alphabet::t '1))
  (define std/text/base58#&alphabet-enc
    (make-struct-field-unchecked-accessor std/text/base58#alphabet::t '0))
  (define std/text/base58#&alphabet-dec
    (make-struct-field-unchecked-accessor std/text/base58#alphabet::t '1))
  (define std/text/base58#&alphabet-enc-set!
    (make-struct-field-unchecked-mutator std/text/base58#alphabet::t '0))
  (define std/text/base58#&alphabet-dec-set!
    (make-struct-field-unchecked-mutator std/text/base58#alphabet::t '1))
  (define std/text/base58#alphabet:::init!
    (lambda (_self112373_ _str112374_)
      (let* ((_alpha112376_ (string->list _str112374_))
             (_enc112378_ (list->vector _alpha112376_))
             (_dec112380_ (make-vector '128 '#f)))
        (for-each
         (lambda (_i112383_ _a112384_)
           (vector-set! _dec112380_ (char->integer _a112384_) _i112383_))
         (iota (string-length _str112374_))
         _alpha112376_)
        (if (##fx< '2 (##vector-length _self112373_))
            (begin
              (##vector-set! _self112373_ '1 _enc112378_)
              (##vector-set! _self112373_ '2 _dec112380_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self112373_)))))
  (bind-method!
   std/text/base58#alphabet::t
   ':init!
   std/text/base58#alphabet:::init!
   '#f)
  (define std/text/base58#alphabet-encode
    (lambda (_ab112247_ _i112248_)
      (vector-ref
       (##unchecked-structure-ref
        _ab112247_
        '1
        std/text/base58#alphabet::t
        '#f)
       _i112248_)))
  (define std/text/base58#alphabet-decode
    (lambda (_ab112242_ _char112243_)
      (let ((_i112245_ (char->integer _char112243_)))
        (if (fx< _i112245_ '128)
            (vector-ref
             (##unchecked-structure-ref
              _ab112242_
              '2
              std/text/base58#alphabet::t
              '#f)
             _i112245_)
            '#f))))
  (define std/text/base58#base58-btc-alphabet
    (let ((__obj112388 (make-object std/text/base58#alphabet::t '2)))
      (std/text/base58#alphabet:::init!
       __obj112388
       '"123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz")
      __obj112388))
  (define std/text/base58#base58-flickr-alphabet
    (let ((__obj112389 (make-object std/text/base58#alphabet::t '2)))
      (std/text/base58#alphabet:::init!
       __obj112389
       '"123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ")
      __obj112389))
  (define std/text/base58#base58-encode__%
    (lambda (_bytes112206_ _ab112207_)
      (let* ((_idx112209_
              (fx+ (fxquotient (fx* (u8vector-length _bytes112206_) '138) '100)
                   '1))
             (_str112211_ (make-string _idx112209_)))
        (let _lp112214_ ((_bn112216_
                          (std/text/base58#bytes->integer _bytes112206_))
                         (_idx112217_ _idx112209_))
          (if (zero? _bn112216_)
              (let ((_zero112219_
                     (std/text/base58#alphabet-encode _ab112207_ '0)))
                (let _pad112221_ ((_i112223_ '0) (_idx112224_ _idx112217_))
                  (if (and (fx< _i112223_ (u8vector-length _bytes112206_))
                           (fxzero? (u8vector-ref _bytes112206_ _i112223_)))
                      (let ((_idx112226_ (fx- _idx112224_ '1)))
                        (string-set! _str112211_ _idx112226_ _zero112219_)
                        (_pad112221_ (fx+ _i112223_ '1) _idx112226_))
                      (substring
                       _str112211_
                       _idx112224_
                       (string-length _str112211_)))))
              (let ((_bn112228_ (quotient _bn112216_ '58))
                    (_mo112229_ (modulo _bn112216_ '58))
                    (_idx112230_ (fx- _idx112217_ '1)))
                (string-set!
                 _str112211_
                 _idx112230_
                 (std/text/base58#alphabet-encode _ab112207_ _mo112229_))
                (_lp112214_ _bn112228_ _idx112230_)))))))
  (define std/text/base58#base58-encode__0
    (lambda (_bytes112235_)
      (let ((_ab112237_ std/text/base58#base58-btc-alphabet))
        (std/text/base58#base58-encode__% _bytes112235_ _ab112237_))))
  (define std/text/base58#base58-encode
    (lambda _g112391_
      (let ((_g112390_ (length _g112391_)))
        (cond ((##fx= _g112390_ 1)
               (apply std/text/base58#base58-encode__0 _g112391_))
              ((##fx= _g112390_ 2)
               (apply std/text/base58#base58-encode__% _g112391_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/base58#base58-encode
                _g112391_))))))
  (define std/text/base58#base58-decode__%
    (lambda (_str112168_ _ab112169_)
      (letrec* ((_leading-zeros112171_
                 (let ((_zero112189_
                        (std/text/base58#alphabet-encode _ab112169_ '0)))
                   (let _lp112191_ ((_i112193_ '0))
                     (if (and (fx< _i112193_ (string-length _str112168_))
                              (eq? _zero112189_
                                   (string-ref _str112168_ _i112193_)))
                         (_lp112191_ (fx+ _i112193_ '1))
                         (make-u8vector _i112193_))))))
        (let _lp112173_ ((_i112175_ '0) (_bn112176_ '0))
          (if (fx< _i112175_ (string-length _str112168_))
              (let* ((_char112178_ (string-ref _str112168_ _i112175_))
                     (_int112180_ (char->integer _char112178_))
                     (_g112392_
                      (if (fx< _int112180_ '128)
                          '#!void
                          (std/error#raise-io-error
                           'base58-decode
                           '"Invalid character"
                           _str112168_
                           _char112178_))))
                (let ((_$e112184_
                       (std/text/base58#alphabet-decode
                        _ab112169_
                        _int112180_)))
                  (if _$e112184_
                      ((lambda (_c112187_)
                         (_lp112173_
                          (fx+ _i112175_ '1)
                          (+ (* _bn112176_ '58) _c112187_)))
                       _$e112184_)
                      (std/error#raise-io-error
                       'base58-decode
                       '"Invalid character"
                       _str112168_
                       _char112178_))))
              (u8vector-append
               _leading-zeros112171_
               (std/text/base58#integer->bytes _bn112176_)))))))
  (define std/text/base58#base58-decode__0
    (lambda (_str112198_)
      (let ((_ab112200_ std/text/base58#base58-btc-alphabet))
        (std/text/base58#base58-decode__% _str112198_ _ab112200_))))
  (define std/text/base58#base58-decode
    (lambda _g112394_
      (let ((_g112393_ (length _g112394_)))
        (cond ((##fx= _g112393_ 1)
               (apply std/text/base58#base58-decode__0 _g112394_))
              ((##fx= _g112393_ 2)
               (apply std/text/base58#base58-decode__% _g112394_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/base58#base58-decode
                _g112394_))))))
  (define std/text/base58#bytes->integer
    (lambda (_bytes112158_)
      (let _lp112160_ ((_i112162_ '0) (_r112163_ '0))
        (if (fx< _i112162_ (u8vector-length _bytes112158_))
            (let ((_b112165_ (u8vector-ref _bytes112158_ _i112162_)))
              (_lp112160_
               (fx+ _i112162_ '1)
               (bitwise-ior (arithmetic-shift _r112163_ '8) _b112165_)))
            _r112163_))))
  (define std/text/base58#integer->bytes
    (lambda (_x112151_)
      (let _lp112153_ ((_x112155_ _x112151_) (_r112156_ '()))
        (if (positive? _x112155_)
            (_lp112153_
             (arithmetic-shift _x112155_ '-8)
             (cons (bitwise-and _x112155_ '255) _r112156_))
            (list->u8vector _r112156_))))))
