/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

public class ColonyTile
extends WorkLocation {
    private static final Logger logger = Logger.getLogger(ColonyTile.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    public static final int UNIT_CAPACITY = 1;
    protected Tile workTile;
    private static final String WORK_TILE_TAG = "workTile";

    protected ColonyTile(Game game, Colony colony, Tile workTile) {
        super(game);
        this.colony = colony;
        this.workTile = workTile;
        this.updateProductionType();
    }

    public ColonyTile(Game game, String id) {
        super(game, id);
    }

    public boolean isColonyCenterTile() {
        return this.getWorkTile() == this.getTile();
    }

    public Tile getWorkTile() {
        return this.workTile;
    }

    public void setWorkTile(Tile workTile) {
        this.workTile = workTile;
    }

    public Unit getOccupyingUnit() {
        return this.workTile.getOccupyingUnit();
    }

    public boolean isOccupied() {
        return this.workTile.isOccupied();
    }

    public ProductionInfo getBasicProductionInfo() {
        Colony colony = this.getColony();
        ProductionInfo pi = new ProductionInfo();
        if (this.isColonyCenterTile()) {
            for (AbstractGoods output : this.getOutputs()) {
                boolean onlyNaturalImprovements = this.getSpecification().getBoolean("model.option.onlyNaturalImprovements") && !output.getType().isFoodType();
                int potential = output.getAmount();
                if (this.workTile.getTileItemContainer() != null) {
                    potential = this.workTile.getTileItemContainer().getTotalBonusPotential(output.getType(), null, potential, onlyNaturalImprovements);
                }
                AbstractGoods production = new AbstractGoods(output.getType(), potential += Math.max(0, colony.getProductionBonus()));
                pi.addProduction(production);
            }
        } else {
            for (AbstractGoods output : this.getOutputs()) {
                GoodsType goodsType = output.getType();
                int amount = this.getUnitList().stream().mapToInt(u -> this.getUnitProduction((Unit)u, goodsType)).sum();
                if (amount <= 0) continue;
                pi.addProduction(new AbstractGoods(goodsType, amount));
            }
        }
        return pi;
    }

    public int improvedBy(TileImprovementType ti) {
        Tile tile = this.getWorkTile();
        Colony colony = this.getColony();
        if (tile == null || tile.getOwningSettlement() != colony || tile.hasTileImprovement(ti)) {
            return 0;
        }
        TileType oldType = tile.getType();
        if (!ti.isTileTypeAllowed(oldType)) {
            return 0;
        }
        ProductionType productionType = this.getProductionType();
        if (productionType == null) {
            return 0;
        }
        Resource resource = tile.getResource();
        TileType newType = ti.getChange(oldType);
        if (productionType.getUnattended()) {
            if (newType == null) {
                return this.getSpecification().getFoodGoodsTypeList().stream().mapToInt(gt -> ti.getBonus((GoodsType)gt)).sum();
            }
            List<AbstractGoods> newProd = newType.getPossibleProduction(true);
            int food = newProd.stream().filter(ag -> ag.getType().isFoodType()).mapToInt(AbstractGoods::getAmount).sum();
            for (AbstractGoods ag2 : this.getProduction()) {
                int change;
                GoodsType goodsType = ag2.getType();
                if (goodsType.isFoodType()) {
                    food -= ag2.getAmount();
                    continue;
                }
                if (!colony.isConsuming(goodsType) || (change = -ag2.getAmount() + AbstractGoods.getCount(goodsType, newProd)) >= 0 || change + colony.getNetProductionOf(goodsType) >= 0) continue;
                return change;
            }
            return food;
        }
        GoodsType work = this.getCurrentWorkType();
        UnitType unitType = this.getFirstUnit().getType();
        return work == null ? 0 : (newType == null ? ti.getBonus(work) : (resource == null ? newType.getPotentialProduction(work, unitType) - oldType.getPotentialProduction(work, unitType) : newType.getPotentialProduction(work, unitType) - resource.applyBonus(work, unitType, oldType.getPotentialProduction(work, unitType))));
    }

    @Override
    public int evaluateFor(Player player) {
        return super.evaluateFor(player) + this.getProductionInfo().getProduction().stream().mapToInt(ag -> ag.evaluateFor(player)).sum();
    }

    @Override
    public StringTemplate getLocationLabel() {
        return this.workTile == null ? null : this.workTile.getColonyTileLocationLabel(this.getColony());
    }

    @Override
    public Location up() {
        return this.getColony();
    }

    @Override
    public String toShortString() {
        return this.getColony().getName() + "-" + this.getWorkTile().getType().getSuffix() + "-" + this.getTile().getDirection(this.getWorkTile());
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        UnitLocation.NoAddReason reason = super.getNoAddReason(locatable);
        return reason != UnitLocation.NoAddReason.NONE ? reason : this.getNoWorkReason();
    }

    @Override
    public int getUnitCapacity() {
        return this.isColonyCenterTile() ? 0 : 1;
    }

    @Override
    public StringTemplate getLabel() {
        return this.workTile == null ? null : this.workTile.getLabel();
    }

    @Override
    public boolean isAvailable() {
        return this.isCurrent() || this.getOwner().canClaimForSettlement(this.getWorkTile());
    }

    @Override
    public boolean isCurrent() {
        return this.getWorkTile().getOwningSettlement() == this.getColony();
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        Player.NoClaimReason claim;
        Tile tile = this.getWorkTile();
        UnitLocation.NoAddReason noAddReason = this.isColonyCenterTile() ? UnitLocation.NoAddReason.COLONY_CENTER : (!this.getColony().hasAbility("model.ability.produceInWater") && !tile.isLand() ? UnitLocation.NoAddReason.MISSING_ABILITY : (tile.getOwningSettlement() == this.getColony() ? UnitLocation.NoAddReason.NONE : ((claim = this.getOwner().canClaimForSettlementReason(tile)) == Player.NoClaimReason.NONE ? UnitLocation.NoAddReason.CLAIM_REQUIRED : (claim == Player.NoClaimReason.TERRAIN || claim == Player.NoClaimReason.RUMOUR || claim == Player.NoClaimReason.WATER ? UnitLocation.NoAddReason.MISSING_ABILITY : (claim == Player.NoClaimReason.SETTLEMENT ? (this.getOwner().owns(tile.getSettlement()) ? UnitLocation.NoAddReason.ANOTHER_COLONY : UnitLocation.NoAddReason.OWNED_BY_ENEMY) : (claim == Player.NoClaimReason.OCCUPIED ? UnitLocation.NoAddReason.OCCUPIED_BY_ENEMY : (claim == Player.NoClaimReason.WORKED ? UnitLocation.NoAddReason.ANOTHER_COLONY : (claim == Player.NoClaimReason.EUROPEANS ? UnitLocation.NoAddReason.OWNED_BY_ENEMY : (claim == Player.NoClaimReason.NATIVES ? UnitLocation.NoAddReason.CLAIM_REQUIRED : UnitLocation.NoAddReason.WRONG_TYPE)))))))));
        return noAddReason;
    }

    @Override
    public boolean canAutoProduce() {
        return this.isColonyCenterTile();
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        Tile workTile = this.getWorkTile();
        return workTile != null && workTile.canProduce(goodsType, unitType);
    }

    @Override
    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        Tile tile = this.getWorkTile();
        return tile == null ? 0 : tile.getBaseProduction(productionType, goodsType, unitType);
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return Collections.emptyList();
        }
        Tile workTile = this.getWorkTile();
        TileType type = workTile.getType();
        String id = goodsType.getId();
        Colony colony = this.getColony();
        Player owner = colony.getOwner();
        Turn turn = this.getGame().getTurn();
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        if (unitType == null) {
            if (this.isColonyCenterTile()) {
                mods.addAll(workTile.getProductionModifiers(goodsType, null));
                mods.addAll(colony.getProductionModifiers(goodsType));
                mods.addAll(colony.getModifiers(id, null, turn));
                if (owner != null) {
                    mods.addAll(owner.getModifiers(id, type, turn));
                }
            }
        } else {
            mods.addAll(workTile.getProductionModifiers(goodsType, unitType));
            mods.addAll(colony.getProductionModifiers(goodsType));
            mods.addAll(unitType.getModifiers(id, type, turn));
            if (owner != null) {
                mods.addAll(owner.getModifiers(id, unitType, turn));
            }
        }
        return mods;
    }

    @Override
    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.workTile == null || this.workTile.getType() == null || unattended != this.isColonyCenterTile() ? Collections.emptyList() : this.workTile.getType().getAvailableProductionTypes(unattended);
    }

    @Override
    public StringTemplate getClaimTemplate() {
        return this.isColonyCenterTile() ? super.getClaimTemplate() : StringTemplate.template("model.colonyTile.claim").addNamed("%direction%", this.getTile().getDirection(this.workTile));
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(WORK_TILE_TAG, this.workTile);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.workTile = xr.makeFreeColGameObject(this.getGame(), WORK_TILE_TAG, Tile.class, true);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getId()).append(" ").append(this.getWorkTile()).append("/").append(this.getColony().getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return ColonyTile.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "colonyTile";
    }
}

