/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;

public final class ValidationContext {
    public final String path;
    public final String mimeType;
    public final EPUBVersion version;
    public final EPUBProfile profile;
    public final Report report;
    public final Locale locale;
    public final FeatureReport featureReport;
    public final GenericResourceProvider resourceProvider;
    public final Optional<OPFItem> opfItem;
    public final Optional<OCFPackage> ocf;
    public final Optional<XRefChecker> xrefChecker;
    public final Set<String> pubTypes;
    public final Set<Property> properties;

    private ValidationContext(String path, String mimeType, EPUBVersion version, EPUBProfile profile, Report report, Locale locale, FeatureReport featureReport, GenericResourceProvider resourceProvider, Optional<OPFItem> opfItem, Optional<OCFPackage> ocf, Optional<XRefChecker> xrefChecker, Set<String> pubTypes, Set<Property> properties) {
        this.path = path;
        this.mimeType = mimeType;
        this.version = version;
        this.profile = profile;
        this.report = report;
        this.locale = locale;
        this.featureReport = featureReport;
        this.resourceProvider = resourceProvider;
        this.opfItem = opfItem;
        this.ocf = ocf;
        this.xrefChecker = xrefChecker;
        this.pubTypes = pubTypes;
        this.properties = properties;
    }

    public static final class ValidationContextPredicates {
        public static Predicate<ValidationContext> hasProp(final Property property) {
            return new Predicate<ValidationContext>(){

                @Override
                public boolean apply(ValidationContext input) {
                    return input.properties.contains(property);
                }
            };
        }

        public static Predicate<ValidationContext> hasPubType(final String type) {
            return new Predicate<ValidationContext>(){

                @Override
                public boolean apply(ValidationContext input) {
                    return input.pubTypes.contains(type);
                }
            };
        }

        public static Predicate<ValidationContext> mimetype(final String mimetype) {
            return new Predicate<ValidationContext>(){

                @Override
                public boolean apply(ValidationContext input) {
                    return input.mimeType.equals(mimetype);
                }
            };
        }

        public static Predicate<ValidationContext> path(final String path) {
            return new Predicate<ValidationContext>(){

                @Override
                public boolean apply(ValidationContext input) {
                    return input.path.equals(path);
                }
            };
        }

        public static Predicate<ValidationContext> profile(final EPUBProfile profile) {
            return new Predicate<ValidationContext>(){

                @Override
                public boolean apply(ValidationContext input) {
                    return input.profile.equals((Object)profile);
                }
            };
        }

        public static Predicate<ValidationContext> version(final EPUBVersion version) {
            return new Predicate<ValidationContext>(){

                @Override
                public boolean apply(ValidationContext input) {
                    return input.version.equals((Object)version);
                }
            };
        }

        private ValidationContextPredicates() {
        }
    }

    public static final class ValidationContextBuilder {
        private String path = null;
        private String mimeType = null;
        private EPUBVersion version = null;
        private EPUBProfile profile = null;
        private Report report = null;
        private FeatureReport featureReport = null;
        private GenericResourceProvider resourceProvider = null;
        private OCFPackage ocf = null;
        private XRefChecker xrefChecker = null;
        private Set<String> pubTypes = null;
        private ImmutableSet.Builder<Property> properties = ImmutableSet.builder();

        public ValidationContextBuilder() {
        }

        public ValidationContextBuilder(ValidationContext context) {
            this.copy(context);
        }

        public ValidationContextBuilder copy(ValidationContext context) {
            this.path = context.path;
            this.mimeType = context.mimeType;
            this.version = context.version;
            this.profile = context.profile;
            this.report = context.report;
            this.featureReport = context.featureReport;
            this.resourceProvider = context.resourceProvider;
            this.ocf = context.ocf.orNull();
            this.xrefChecker = context.xrefChecker.orNull();
            this.pubTypes = context.pubTypes;
            this.properties = ImmutableSet.builder().addAll(context.properties);
            return this;
        }

        public ValidationContextBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ValidationContextBuilder mimetype(String mimetype) {
            this.mimeType = mimetype;
            return this;
        }

        public ValidationContextBuilder version(EPUBVersion version) {
            this.version = version;
            return this;
        }

        public ValidationContextBuilder profile(EPUBProfile profile) {
            this.profile = profile;
            return this;
        }

        public ValidationContextBuilder report(Report report) {
            this.report = report;
            return this;
        }

        public ValidationContextBuilder featureReport(FeatureReport featureReport) {
            this.featureReport = featureReport;
            return this;
        }

        public ValidationContextBuilder resourceProvider(GenericResourceProvider resourceProvider) {
            this.resourceProvider = resourceProvider;
            return this;
        }

        public ValidationContextBuilder ocf(OCFPackage ocf) {
            this.ocf = ocf;
            return this;
        }

        public ValidationContextBuilder xrefChecker(XRefChecker xrefChecker) {
            this.xrefChecker = xrefChecker;
            return this;
        }

        public ValidationContextBuilder pubTypes(Set<String> pubTypes) {
            this.pubTypes = pubTypes;
            return this;
        }

        public ValidationContextBuilder properties(Set<Property> properties) {
            this.properties = ImmutableSet.builder();
            if (properties != null) {
                this.properties.addAll(properties);
            }
            return this;
        }

        public ValidationContextBuilder addProperty(Property property) {
            this.properties.add((Object)Preconditions.checkNotNull(property));
            return this;
        }

        public ValidationContext build() {
            this.path = Strings.nullToEmpty(this.path);
            this.resourceProvider = this.resourceProvider == null && this.ocf != null ? this.ocf : this.resourceProvider;
            Preconditions.checkNotNull(this.resourceProvider);
            Preconditions.checkNotNull(this.report);
            Locale locale = MoreObjects.firstNonNull(this.report instanceof LocalizableReport ? ((LocalizableReport)this.report).getLocale() : null, Locale.getDefault());
            return new ValidationContext(this.path, Strings.nullToEmpty(this.mimeType), this.version != null ? this.version : EPUBVersion.Unknown, this.profile != null ? this.profile : EPUBProfile.DEFAULT, this.report, locale, this.featureReport != null ? this.featureReport : new FeatureReport(), this.resourceProvider, this.xrefChecker != null ? this.xrefChecker.getResource(this.path) : Optional.absent(), Optional.fromNullable(this.ocf), Optional.fromNullable(this.xrefChecker), this.pubTypes != null ? ImmutableSet.copyOf(this.pubTypes) : ImmutableSet.of(), (Set)((Object)this.properties.build()));
        }
    }
}

