/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import com.sun.java.swing.plaf.windows.WindowsScrollBarUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.ComponentUI;
import net.java.plaf.ClientProperties;
import net.java.plaf.util.Messages;

public class XPScrollBarUI
extends WindowsScrollBarUI {
    private ContextMenuListener contextMenuListener;
    private ActionMap actionMap;
    private JPopupMenu contextMenu;
    private static final Messages MESSAGES = new Messages("XPScrollBarUI", "net.java.plaf.windows.xp.XPResources");

    public static ComponentUI createUI(JComponent comp) {
        return new XPScrollBarUI();
    }

    protected void createActionMap() {
        this.actionMap = new ActionMap();
        this.actionMap.put("pageDecreaseAction", new PageDecreaseAction());
        this.actionMap.put("pageIncreaseAction", new PageIncreaseAction());
        this.actionMap.put("scrollIncreaseAction", new ScrollIncreaseAction());
        this.actionMap.put("scrollDecreaseAction", new ScrollDecreaseAction());
        this.actionMap.put("scrollHereAction", new ScrollHereAction());
        this.actionMap.put("scrollToEndAction", new ScrollToEndAction());
        this.actionMap.put("scrollToStartAction", new ScrollToStartAction());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.createActionMap();
    }

    protected void installListeners() {
        super.installListeners();
        this.contextMenuListener = new ContextMenuListener();
        this.scrollbar.addMouseListener(this.contextMenuListener);
        this.incrButton.addMouseListener(this.contextMenuListener);
        this.decrButton.addMouseListener(this.contextMenuListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this.contextMenuListener);
        this.incrButton.removeMouseListener(this.contextMenuListener);
        this.decrButton.removeMouseListener(this.contextMenuListener);
    }

    protected void fillContextMenu(JPopupMenu contextMenu) {
        contextMenu.add(this.actionMap.get("scrollHereAction"));
        contextMenu.addSeparator();
        contextMenu.add(this.actionMap.get("scrollToStartAction"));
        contextMenu.add(this.actionMap.get("scrollToEndAction"));
        contextMenu.addSeparator();
        contextMenu.add(this.actionMap.get("pageDecreaseAction"));
        contextMenu.add(this.actionMap.get("pageIncreaseAction"));
        contextMenu.addSeparator();
        contextMenu.add(this.actionMap.get("scrollDecreaseAction"));
        contextMenu.add(this.actionMap.get("scrollIncreaseAction"));
    }

    private void showContextMenu(MouseEvent event) {
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
        } else {
            this.contextMenu.removeAll();
        }
        this.fillContextMenu(this.contextMenu);
        this.initScrollHereAction(event);
        Component invokerComponent = event.getSource() instanceof Component ? (Component)event.getSource() : this.scrollbar;
        this.contextMenu.show(invokerComponent, event.getX(), event.getY());
    }

    private void initScrollHereAction(MouseEvent event) {
        int herePosition;
        ScrollHereAction scrollHereAction = (ScrollHereAction)this.actionMap.get("scrollHereAction");
        int n = herePosition = this.scrollbar.getOrientation() == 0 ? event.getX() : event.getY();
        if (event.getSource().equals(this.incrButton)) {
            herePosition = this.scrollbar.getMaximum();
        } else if (event.getSource().equals(this.decrButton)) {
            herePosition = this.scrollbar.getMinimum();
        }
        scrollHereAction.setHerePosition(herePosition);
    }

    private boolean isPopupEnabled() {
        Boolean value = (Boolean)this.scrollbar.getClientProperty(ClientProperties.NO_SCROLLBAR_POPUP);
        if (value != null) {
            return value == false;
        }
        return true;
    }

    private static interface MessageConstants {
        public static final String SCROLL_HERE = "ScrollHere";
        public static final String SCROLL_LEFT = "ScrollLeft";
        public static final String SCROLL_RIGHT = "ScrollRight";
        public static final String SCROLL_DOWN = "ScrollDown";
        public static final String SCROLL_UP = "ScrollUp";
        public static final String LEFT_EDGE = "LeftEdge";
        public static final String RIGHT_EDGE = "RightEdge";
        public static final String TOP = "Top";
        public static final String BOTTOM = "Bottom";
        public static final String PAGE_LEFT = "PageLeft";
        public static final String PAGE_UP = "PageUp";
        public static final String PAGE_RIGHT = "PageRight";
        public static final String PAGE_DOWN = "PageDown";
    }

    private class ScrollIncreaseAction
    extends AbstractAction {
        public static final String ACTION_COMMAND = "scrollIncreaseAction";

        public ScrollIncreaseAction() {
            super(ACTION_COMMAND);
        }

        public void actionPerformed(ActionEvent ae) {
            int increment = XPScrollBarUI.this.scrollbar.getUnitIncrement(1);
            int newValue = XPScrollBarUI.this.scrollbar.getValue() + increment;
            XPScrollBarUI.this.scrollbar.setValue(newValue > XPScrollBarUI.this.scrollbar.getMaximum() ? XPScrollBarUI.this.scrollbar.getMaximum() : newValue);
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                if (XPScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    return MESSAGES.getText("ScrollRight");
                }
                return MESSAGES.getText("ScrollDown");
            }
            return super.getValue(key);
        }
    }

    private class ScrollDecreaseAction
    extends AbstractAction {
        public static final String ACTION_COMMAND = "scrollDecreaseAction";

        public ScrollDecreaseAction() {
            super(ACTION_COMMAND);
        }

        public void actionPerformed(ActionEvent ae) {
            int increment = XPScrollBarUI.this.scrollbar.getUnitIncrement(-1);
            int newValue = XPScrollBarUI.this.scrollbar.getValue() - increment;
            XPScrollBarUI.this.scrollbar.setValue(newValue < XPScrollBarUI.this.scrollbar.getMinimum() ? XPScrollBarUI.this.scrollbar.getMinimum() : newValue);
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                if (XPScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    return MESSAGES.getText("ScrollLeft");
                }
                return MESSAGES.getText("ScrollUp");
            }
            return super.getValue(key);
        }
    }

    private class PageIncreaseAction
    extends AbstractAction {
        public static final String ACTION_COMMAND = "pageIncreaseAction";

        public PageIncreaseAction() {
            super(ACTION_COMMAND);
        }

        public void actionPerformed(ActionEvent ae) {
            int blockIncrement = XPScrollBarUI.this.scrollbar.getBlockIncrement(1);
            int newValue = XPScrollBarUI.this.scrollbar.getValue() + blockIncrement;
            XPScrollBarUI.this.scrollbar.setValue(newValue > XPScrollBarUI.this.scrollbar.getMaximum() ? XPScrollBarUI.this.scrollbar.getMaximum() : newValue);
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                if (XPScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    return MESSAGES.getText("PageRight");
                }
                return MESSAGES.getText("PageDown");
            }
            return super.getValue(key);
        }
    }

    private class PageDecreaseAction
    extends AbstractAction {
        public static final String ACTION_COMMAND = "pageDecreaseAction";

        public PageDecreaseAction() {
            super(ACTION_COMMAND);
        }

        public void actionPerformed(ActionEvent ae) {
            int blockIncrement = XPScrollBarUI.this.scrollbar.getBlockIncrement(-1);
            int newValue = XPScrollBarUI.this.scrollbar.getValue() - blockIncrement;
            XPScrollBarUI.this.scrollbar.setValue(newValue < XPScrollBarUI.this.scrollbar.getMinimum() ? XPScrollBarUI.this.scrollbar.getMinimum() : newValue);
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                if (XPScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    return MESSAGES.getText("PageLeft");
                }
                return MESSAGES.getText("PageUp");
            }
            return super.getValue(key);
        }
    }

    private class ScrollToEndAction
    extends AbstractAction {
        public static final String ACTION_COMMAND = "scrollToEndAction";

        public ScrollToEndAction() {
            super(ACTION_COMMAND);
        }

        public void actionPerformed(ActionEvent ae) {
            XPScrollBarUI.this.scrollbar.setValue(XPScrollBarUI.this.scrollbar.getMaximum());
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                if (XPScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    return MESSAGES.getText("RightEdge");
                }
                return MESSAGES.getText("Bottom");
            }
            return super.getValue(key);
        }
    }

    private class ScrollToStartAction
    extends AbstractAction {
        public static final String ACTION_COMMAND = "scrollToStartAction";

        public ScrollToStartAction() {
            super(ACTION_COMMAND);
        }

        public void actionPerformed(ActionEvent ae) {
            XPScrollBarUI.this.scrollbar.setValue(XPScrollBarUI.this.scrollbar.getMinimum());
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                if (XPScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    return MESSAGES.getText("LeftEdge");
                }
                return MESSAGES.getText("Top");
            }
            return super.getValue(key);
        }
    }

    private class ScrollHereAction
    extends AbstractAction {
        private int herePosition;
        public static final String ACTION_COMMAND = "scrollHereAction";

        public ScrollHereAction() {
            super(ACTION_COMMAND);
        }

        public void setHerePosition(int herePosition) {
            this.herePosition = herePosition;
        }

        public void actionPerformed(ActionEvent event) {
            int decrSize = XPScrollBarUI.this.scrollbar.getOrientation() == 0 ? XPScrollBarUI.this.decrButton.getWidth() : XPScrollBarUI.this.decrButton.getHeight();
            int incrSize = XPScrollBarUI.this.scrollbar.getOrientation() == 0 ? XPScrollBarUI.this.incrButton.getWidth() : XPScrollBarUI.this.incrButton.getHeight();
            int scrollbarSize = XPScrollBarUI.this.scrollbar.getOrientation() == 0 ? XPScrollBarUI.this.scrollbar.getWidth() : XPScrollBarUI.this.scrollbar.getHeight();
            double perc = (double)(this.herePosition - decrSize) / (double)(scrollbarSize - incrSize - decrSize);
            int newPos = (int)(perc * (double)(XPScrollBarUI.this.scrollbar.getMaximum() - XPScrollBarUI.this.scrollbar.getMinimum()));
            if (newPos < XPScrollBarUI.this.scrollbar.getMinimum()) {
                newPos = XPScrollBarUI.this.scrollbar.getMinimum();
            }
            if (newPos > XPScrollBarUI.this.scrollbar.getMaximum()) {
                newPos = XPScrollBarUI.this.scrollbar.getMaximum();
            }
            XPScrollBarUI.this.scrollbar.setValue(newPos);
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return MESSAGES.getText("ScrollHere");
            }
            return super.getValue(key);
        }
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private ContextMenuListener() {
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger() && XPScrollBarUI.this.scrollbar.isEnabled() && XPScrollBarUI.this.isPopupEnabled()) {
                XPScrollBarUI.this.showContextMenu(me);
            }
        }
    }
}

