/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonContext;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

public class OsonObjectImpl
extends OsonAbstractObject
implements OracleJsonObject {
    public OsonObjectImpl(OsonContext osonContext, int n2) {
        super(osonContext);
        this.init(n2);
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        JsonpOsonContext jsonpOsonContext = new JsonpOsonContext(this.ctx);
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createObject(jsonpOsonContext, this.pos));
    }

    @Override
    public OracleJsonValue get(Object object) {
        return (OracleJsonValue)this.getInternal(object);
    }

    @Override
    public Collection<OracleJsonValue> values() {
        return new OsonAbstractObject.OsonObjectValues<OracleJsonValue>();
    }

    @Override
    public Set<Map.Entry<String, OracleJsonValue>> entrySet() {
        return new OsonAbstractObject.OsonEntrySet<OracleJsonValue>();
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializerImpl jsonSerializerImpl = new JsonSerializerImpl(stringWriter);
        jsonSerializerImpl.write(this);
        jsonSerializerImpl.close();
        return stringWriter.toString();
    }

    @Override
    public byte[] getBytes(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonBinary)this.getValueInternal(n2)).getBytes();
    }

    @Override
    public byte[] getBytes(String string, byte[] byArray) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return byArray;
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        return oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.BINARY ? oracleJsonValue.asJsonBinary().getBytes() : byArray;
    }

    @Override
    public double getDouble(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(n2)).doubleValue();
    }

    @Override
    public double getDouble(String string, double d2) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return d2;
        }
        OracleJsonNumber oracleJsonNumber = this.getNumeric(n2);
        return oracleJsonNumber == null ? d2 : oracleJsonNumber.doubleValue();
    }

    private OracleJsonNumber getNumeric(int n2) {
        Object object = this.getValueInternal(n2);
        return object instanceof OracleJsonNumber ? (OracleJsonNumber)object : null;
    }

    @Override
    public long getLong(String string, long l2) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return l2;
        }
        OracleJsonNumber oracleJsonNumber = this.getNumeric(n2);
        return oracleJsonNumber == null ? l2 : oracleJsonNumber.longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return bigDecimal;
        }
        OracleJsonNumber oracleJsonNumber = this.getNumeric(n2);
        return oracleJsonNumber == null ? bigDecimal : oracleJsonNumber.bigDecimalValue();
    }

    @Override
    public long getLong(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(n2)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(n2)).bigDecimalValue();
    }

    @Override
    public Instant getInstant(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDate)oracleJsonValue).getInstant();
        }
        return ((OracleJsonTimestamp)oracleJsonValue).getInstant();
    }

    @Override
    public Instant getInstant(String string, Instant instant) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return instant;
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDate)oracleJsonValue).getInstant();
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return ((OracleJsonTimestamp)oracleJsonValue).getInstant();
        }
        return instant;
    }

    @Override
    public OracleJsonValue put(String string, String string2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, int n2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, long l2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, BigDecimal bigDecimal) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, double d2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, boolean bl) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue putNull(String string) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, Instant instant) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, byte[] byArray) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, OracleJsonValue oracleJsonValue) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue remove(Object object) {
        throw this.createNotModifiable();
    }

    @Override
    public void putAll(Map<? extends String, ? extends OracleJsonValue> map) {
        throw this.createNotModifiable();
    }

    @Override
    public void clear() {
        throw this.createNotModifiable();
    }

    private UnsupportedOperationException createNotModifiable() {
        throw OracleJsonExceptions.OBJ_NOT_MUTABLE.create(OracleJsonExceptions.ORACLE_FACTORY, new Object[0]);
    }
}

