/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.HistoryReferenceEventPublisher;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.view.table.AbstractCustomColumnHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

@Deprecated
class SpiderMessagesTableModel
extends AbstractCustomColumnHistoryReferencesTableModel<SpiderTableEntry> {
    private static final long serialVersionUID = 1093393768186896931L;
    private static final HistoryReferencesTableModel.Column[] COLUMNS = new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.CUSTOM, HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP, HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.STATUS_CODE, HistoryReferencesTableModel.Column.STATUS_REASON, HistoryReferencesTableModel.Column.RTT, HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER, HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY, HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY, HistoryReferencesTableModel.Column.HIGHEST_ALERT, HistoryReferencesTableModel.Column.TAGS};
    private static final String[] CUSTOM_COLUMN_NAMES = new String[]{Constant.messages.getString("spider.table.messages.header.processed")};
    private static final ProcessedCellItem SUCCESSFULLY_PROCESSED_CELL_ITEM = new ProcessedCellItem(true, Constant.messages.getString("spider.table.messages.column.processed.successfully"));
    private final ExtensionHistory extensionHistory;
    private EventConsumerImpl eventConsumer;
    private List<SpiderTableEntry> resources = new ArrayList<SpiderTableEntry>();
    private Map<Integer, Integer> idsToRows = new HashMap<Integer, Integer>();
    private Map<String, ProcessedCellItem> cacheProcessedCellItems = new HashMap<String, ProcessedCellItem>();

    public SpiderMessagesTableModel() {
        this(true);
    }

    public SpiderMessagesTableModel(boolean createAlertEventConsumer) {
        super(COLUMNS);
        if (createAlertEventConsumer) {
            this.eventConsumer = new EventConsumerImpl();
            this.extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
            ZAP.getEventBus().registerConsumer(this.eventConsumer, AlertEventPublisher.getPublisher().getPublisherName());
            ZAP.getEventBus().registerConsumer(this.eventConsumer, HistoryReferenceEventPublisher.getPublisher().getPublisherName());
        } else {
            this.eventConsumer = null;
            this.extensionHistory = null;
        }
    }

    @Override
    public void addEntry(SpiderTableEntry entry) {
    }

    public void addHistoryReference(HistoryReference historyReference, boolean processed, String reasonNotProcessed) {
        HistoryReference latestHistoryReference = historyReference;
        if (this.extensionHistory != null) {
            latestHistoryReference = this.extensionHistory.getHistoryReference(historyReference.getHistoryId());
        }
        final SpiderTableEntry entry = new SpiderTableEntry(latestHistoryReference, this.getProcessedCellItem(processed, reasonNotProcessed));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int row = SpiderMessagesTableModel.this.resources.size();
                SpiderMessagesTableModel.this.idsToRows.put(entry.getHistoryId(), row);
                SpiderMessagesTableModel.this.resources.add(entry);
                SpiderMessagesTableModel.this.fireTableRowsInserted(row, row);
            }
        });
    }

    private ProcessedCellItem getProcessedCellItem(boolean processed, String reasonNotProcessed) {
        if (processed) {
            return SUCCESSFULLY_PROCESSED_CELL_ITEM;
        }
        ProcessedCellItem processedCellItem = this.cacheProcessedCellItems.get(reasonNotProcessed);
        if (processedCellItem == null) {
            processedCellItem = new ProcessedCellItem(processed, reasonNotProcessed);
            this.cacheProcessedCellItems.put(reasonNotProcessed, processedCellItem);
        }
        return processedCellItem;
    }

    @Override
    public void clear() {
        this.cacheProcessedCellItems = new HashMap<String, ProcessedCellItem>();
        this.resources = new ArrayList<SpiderTableEntry>();
        this.idsToRows = new HashMap<Integer, Integer>();
        this.fireTableDataChanged();
        if (this.eventConsumer != null) {
            ZAP.getEventBus().unregisterConsumer(this.eventConsumer, AlertEventPublisher.getPublisher().getPublisherName());
            ZAP.getEventBus().unregisterConsumer(this.eventConsumer, HistoryReferenceEventPublisher.getPublisher().getPublisherName());
            this.eventConsumer = null;
        }
    }

    @Override
    public void refreshEntryRow(int historyReferenceId) {
        SpiderTableEntry entry = this.getEntryWithHistoryId(historyReferenceId);
        if (entry != null) {
            int rowIndex = this.getEntryRowIndex(historyReferenceId);
            this.getEntryWithHistoryId(historyReferenceId).refreshCachedValues();
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public void removeEntry(int historyReferenceId) {
    }

    @Override
    public SpiderTableEntry getEntry(int rowIndex) {
        return this.resources.get(rowIndex);
    }

    @Override
    public SpiderTableEntry getEntryWithHistoryId(int historyReferenceId) {
        int row = this.getEntryRowIndex(historyReferenceId);
        if (row != -1) {
            return this.resources.get(row);
        }
        return null;
    }

    @Override
    public int getEntryRowIndex(int historyReferenceId) {
        Integer row = this.idsToRows.get(historyReferenceId);
        if (row != null) {
            return row;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.resources.size();
    }

    @Override
    protected Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getColumnClass(column);
    }

    @Override
    protected Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getPrototypeValue(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == -1) {
            return this.getEntry(rowIndex);
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    protected Object getCustomValueAt(SpiderTableEntry entry, int columnIndex) {
        if (this.getCustomColumnIndex(columnIndex) == 0) {
            return entry.getProcessedCellItem();
        }
        return null;
    }

    @Override
    protected String getCustomColumnName(int columnIndex) {
        return CUSTOM_COLUMN_NAMES[this.getCustomColumnIndex(columnIndex)];
    }

    @Override
    protected Class<?> getCustomColumnClass(int columnIndex) {
        if (this.getCustomColumnIndex(columnIndex) == 0) {
            return ProcessedCellItem.class;
        }
        return null;
    }

    @Override
    protected Object getCustomPrototypeValue(int columnIndex) {
        if (this.getCustomColumnIndex(columnIndex) == 0) {
            return "Successful";
        }
        return null;
    }

    private void refreshEntryRows() {
        if (this.resources.isEmpty()) {
            return;
        }
        for (SpiderTableEntry entry : this.resources) {
            entry.refreshCachedValues();
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.resources.size() - 1, this.getColumnIndex(HistoryReferencesTableModel.Column.HIGHEST_ALERT), 0));
    }

    private class EventConsumerImpl
    implements EventConsumer {
        private EventConsumerImpl() {
        }

        @Override
        public void eventReceived(Event event) {
            switch (event.getEventType()) {
                case "href.tag.added": 
                case "href.tag.removed": 
                case "href.tags.set": {
                    this.refreshEntry(Integer.valueOf(event.getParameters().get("historyReferenceId")));
                    break;
                }
                case "alert.added": 
                case "alert.changed": 
                case "alert.removed": {
                    this.refreshEntry(Integer.valueOf(event.getParameters().get("historyId")));
                    break;
                }
                case "alert.all.removed": {
                    this.refreshEntries();
                    break;
                }
            }
        }

        private void refreshEntry(final int id) {
            if (EventQueue.isDispatchThread()) {
                SpiderMessagesTableModel.this.refreshEntryRow(id);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventConsumerImpl.this.refreshEntry(id);
                }
            });
        }

        private void refreshEntries() {
            if (EventQueue.isDispatchThread()) {
                SpiderMessagesTableModel.this.refreshEntryRows();
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventConsumerImpl.this.refreshEntries();
                }
            });
        }
    }

    static class ProcessedCellItem
    implements Comparable<ProcessedCellItem> {
        private final boolean successful;
        private final String label;

        public ProcessedCellItem(boolean successful, String label) {
            this.successful = successful;
            this.label = label;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        public int hashCode() {
            return 31 * (this.successful ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProcessedCellItem other = (ProcessedCellItem)obj;
            return this.successful == other.successful;
        }

        @Override
        public int compareTo(ProcessedCellItem other) {
            if (other == null) {
                return 1;
            }
            if (this.successful && !other.successful) {
                return 1;
            }
            if (!this.successful && other.successful) {
                return -1;
            }
            return this.label.compareTo(other.label);
        }
    }

    static class SpiderTableEntry
    extends DefaultHistoryReferencesTableEntry {
        private final ProcessedCellItem processedCellItem;

        public SpiderTableEntry(HistoryReference historyReference, ProcessedCellItem processedCellItem) {
            super(historyReference, COLUMNS);
            this.processedCellItem = processedCellItem;
        }

        public ProcessedCellItem getProcessedCellItem() {
            return this.processedCellItem;
        }
    }
}

