/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOnClassnames;
import org.zaproxy.zap.control.BaseZapAddOnXmlData;
import org.zaproxy.zap.control.ZapAddOnXmlFile;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.control.ZapReleaseComparitor;
import org.zaproxy.zap.control.ZapVersionsAddOnEntry;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class AddOn {
    public static final String MANIFEST_FILE_NAME = "ZapAddOn.xml";
    protected static final String BOM_FILE_NAME = "bom.json";
    private static ZapRelease v2_4 = new ZapRelease("2.4.0");
    public static final String FILE_EXTENSION = ".zap";
    private String id;
    private String name;
    private String description = "";
    private String author = "";
    private Version version;
    private Version semVer;
    private Status status;
    private String changes = "";
    private File file = null;
    private URL url = null;
    private URL info = null;
    private URL repo;
    private long size = 0L;
    private boolean hasZapAddOnEntry = false;
    private boolean manifestRead;
    private String notBeforeVersion = null;
    private String notFromVersion = null;
    private String hash = null;
    private String releaseDate;
    private InstallationStatus installationStatus = InstallationStatus.NOT_INSTALLED;
    private List<String> extensions = Collections.emptyList();
    private List<BaseZapAddOnXmlData.ExtensionWithDeps> extensionsWithDeps = Collections.emptyList();
    private List<Extension> loadedExtensions;
    private List<String> ascanrules = Collections.emptyList();
    private List<AbstractPlugin> loadedAscanrules = Collections.emptyList();
    private boolean loadedAscanRulesSet;
    private List<String> pscanrules = Collections.emptyList();
    private List<String> files = Collections.emptyList();
    private List<Lib> libs = Collections.emptyList();
    private AddOnClassnames addOnClassnames = AddOnClassnames.ALL_ALLOWED;
    private ClassLoader classLoader;
    private BaseZapAddOnXmlData.Dependencies dependencies;
    private BundleData bundleData = BundleData.EMPTY_BUNDLE;
    private ResourceBundle resourceBundle;
    private HelpSetData helpSetData = HelpSetData.EMPTY_HELP_SET;
    private boolean mandatory;
    private static final Logger LOGGER = LogManager.getLogger(AddOn.class);

    public static boolean isAddOnFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase(Locale.ROOT).endsWith(FILE_EXTENSION);
    }

    public static boolean isAddOn(Path file) {
        return AddOn.isValidAddOn(file).getValidity() == ValidationResult.Validity.VALID;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ValidationResult isValidAddOn(Path file) {
        if (file == null || file.getNameCount() == 0) {
            return new ValidationResult(ValidationResult.Validity.INVALID_PATH);
        }
        if (!AddOn.isAddOnFileName(file.getFileName().toString())) {
            return new ValidationResult(ValidationResult.Validity.INVALID_FILE_NAME);
        }
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return new ValidationResult(ValidationResult.Validity.FILE_NOT_READABLE);
        }
        try (ZipFile zip = new ZipFile(file.toFile());){
            ValidationResult validationResult;
            block28: {
                ZapAddOnXmlFile manifest;
                InputStream zis;
                block26: {
                    ValidationResult validationResult2;
                    block27: {
                        ZipEntry manifestEntry = zip.getEntry(MANIFEST_FILE_NAME);
                        if (manifestEntry == null) {
                            ValidationResult validationResult3 = new ValidationResult(ValidationResult.Validity.MISSING_MANIFEST);
                            return validationResult3;
                        }
                        zis = zip.getInputStream(manifestEntry);
                        try {
                            try {
                                manifest = new ZapAddOnXmlFile(zis);
                            }
                            catch (IOException e) {
                                ValidationResult validationResult4 = new ValidationResult(ValidationResult.Validity.INVALID_MANIFEST, e);
                                if (zis != null) {
                                    zis.close();
                                }
                                zip.close();
                                return validationResult4;
                            }
                        }
                        catch (Throwable throwable) {
                            if (zis != null) {
                                try {
                                    zis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        if (!AddOn.hasInvalidLibs(file, manifest, zip)) break block26;
                        validationResult2 = new ValidationResult(ValidationResult.Validity.INVALID_LIB);
                        if (zis == null) break block27;
                        zis.close();
                    }
                    return validationResult2;
                }
                validationResult = new ValidationResult(manifest);
                if (zis == null) break block28;
                zis.close();
            }
            return validationResult;
        }
        catch (ZipException e) {
            return new ValidationResult(ValidationResult.Validity.UNREADABLE_ZIP_FILE, e);
        }
        catch (Exception e) {
            return new ValidationResult(ValidationResult.Validity.IO_ERROR_FILE, e);
        }
    }

    private static boolean hasInvalidLibs(Path file, ZapAddOnXmlFile manifest, ZipFile zip) {
        return manifest.getLibs().stream().anyMatch(e -> {
            ZipEntry libEntry = zip.getEntry((String)e);
            if (libEntry == null) {
                LOGGER.warn("The add-on {} does not have the lib: {}", (Object)file, e);
                return true;
            }
            if (libEntry.isDirectory()) {
                LOGGER.warn("The add-on {} does not have a file lib: {}", (Object)file, e);
                return true;
            }
            return false;
        });
    }

    public static Optional<AddOn> createAddOn(Path file) {
        try {
            return Optional.of(new AddOn(file));
        }
        catch (InvalidAddOnException e) {
            String logMessage = "Invalid add-on: " + file.toString() + ".";
            if (LOGGER.isDebugEnabled() || Constant.isDevMode()) {
                LOGGER.warn(logMessage, (Throwable)e);
            } else {
                LOGGER.warn("{} {}", (Object)logMessage, (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create an add-on from: {}", (Object)file, (Object)e);
        }
        return Optional.empty();
    }

    public AddOn(Path file) throws IOException {
        ValidationResult result = AddOn.isValidAddOn(file);
        if (result.getValidity() != ValidationResult.Validity.VALID) {
            throw new InvalidAddOnException(result);
        }
        this.id = AddOn.extractAddOnId(file.getFileName().toString());
        this.file = file.toFile();
        this.size = Files.size(file);
        this.readZapAddOnXmlFile(result.getManifest());
    }

    private static String extractAddOnId(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46)).split("-")[0];
    }

    private void loadManifestFile() throws IOException {
        this.manifestRead = true;
        if (this.file.exists()) {
            try (ZipFile zip = new ZipFile(this.file);){
                ZipEntry zapAddOnEntry = zip.getEntry(MANIFEST_FILE_NAME);
                if (zapAddOnEntry == null) {
                    throw new IOException("Add-on does not have the ZapAddOn.xml file.");
                }
                try (InputStream zis = zip.getInputStream(zapAddOnEntry);){
                    ZapAddOnXmlFile zapAddOnXml = new ZapAddOnXmlFile(zis);
                    this.readZapAddOnXmlFile(zapAddOnXml);
                }
            }
        }
    }

    private void readZapAddOnXmlFile(ZapAddOnXmlFile zapAddOnXml) {
        String helpSetBaseName;
        this.name = zapAddOnXml.getName();
        this.version = zapAddOnXml.getVersion();
        this.semVer = zapAddOnXml.getSemVer();
        this.status = Status.valueOf(zapAddOnXml.getStatus());
        this.description = zapAddOnXml.getDescription();
        this.changes = zapAddOnXml.getChanges();
        this.author = zapAddOnXml.getAuthor();
        this.notBeforeVersion = zapAddOnXml.getNotBeforeVersion();
        this.notFromVersion = zapAddOnXml.getNotFromVersion();
        this.dependencies = zapAddOnXml.getDependencies();
        this.info = this.createUrl(zapAddOnXml.getUrl());
        this.repo = this.createUrl(zapAddOnXml.getRepo());
        this.ascanrules = zapAddOnXml.getAscanrules();
        this.extensions = zapAddOnXml.getExtensions();
        this.extensionsWithDeps = zapAddOnXml.getExtensionsWithDeps();
        this.files = zapAddOnXml.getFiles();
        this.libs = AddOn.createLibs(zapAddOnXml.getLibs());
        this.pscanrules = zapAddOnXml.getPscanrules();
        this.addOnClassnames = zapAddOnXml.getAddOnClassnames();
        String bundleBaseName = zapAddOnXml.getBundleBaseName();
        if (!bundleBaseName.isEmpty()) {
            this.bundleData = new BundleData(bundleBaseName, zapAddOnXml.getBundlePrefix());
        }
        if (!(helpSetBaseName = zapAddOnXml.getHelpSetBaseName()).isEmpty()) {
            this.helpSetData = new HelpSetData(helpSetBaseName, zapAddOnXml.getHelpSetLocaleToken());
        }
        this.hasZapAddOnEntry = true;
    }

    public AddOn(String id, File baseDir, SubnodeConfiguration xmlData) throws MalformedURLException, IOException {
        this.id = id;
        ZapVersionsAddOnEntry addOnData = new ZapVersionsAddOnEntry((HierarchicalConfiguration)xmlData);
        this.name = addOnData.getName();
        this.description = addOnData.getDescription();
        this.author = addOnData.getAuthor();
        this.dependencies = addOnData.getDependencies();
        this.extensionsWithDeps = addOnData.getExtensionsWithDeps();
        this.version = addOnData.getVersion();
        this.semVer = addOnData.getSemVer();
        this.status = Status.valueOf(addOnData.getStatus());
        this.changes = addOnData.getChanges();
        try {
            this.url = new URI(addOnData.getUrl()).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        this.file = new File(baseDir, addOnData.getFile());
        this.size = addOnData.getSize();
        this.notBeforeVersion = addOnData.getNotBeforeVersion();
        this.notFromVersion = addOnData.getNotFromVersion();
        this.info = this.createUrl(addOnData.getInfo());
        this.repo = this.createUrl(addOnData.getRepo());
        this.releaseDate = addOnData.getDate();
        this.hash = addOnData.getHash();
        this.loadManifestFile();
    }

    private URL createUrl(String url) {
        if (url != null && !url.isEmpty()) {
            try {
                return new URI(url).toURL();
            }
            catch (Exception e) {
                LOGGER.warn("Invalid URL for add-on \"{}\": {}", (Object)this.id, (Object)url, (Object)e);
            }
        }
        return null;
    }

    private static List<Lib> createLibs(List<String> libPaths) {
        if (libPaths.isEmpty()) {
            return Collections.emptyList();
        }
        return libPaths.stream().map(Lib::new).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public int getFileVersion() {
        return this.getVersion().getMajorVersion();
    }

    public Version getVersion() {
        return this.version;
    }

    Version getSemVer() {
        return this.semVer;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public String getNormalisedFileName() {
        return this.getId() + "-" + this.getVersion() + FILE_EXTENSION;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setInstallationStatus(InstallationStatus installationStatus) {
        if (installationStatus == null) {
            throw new IllegalArgumentException("Parameter installationStatus must not be null.");
        }
        this.installationStatus = installationStatus;
    }

    public InstallationStatus getInstallationStatus() {
        return this.installationStatus;
    }

    public boolean hasZapAddOnEntry() {
        if (!this.hasZapAddOnEntry && !this.manifestRead) {
            try {
                this.loadManifestFile();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to read the {} file of {}:", (Object)MANIFEST_FILE_NAME, (Object)this.id, (Object)e);
            }
        }
        return this.hasZapAddOnEntry;
    }

    public AddOnClassnames getAddOnClassnames() {
        return this.addOnClassnames;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<String> getExtensionsWithDeps() {
        if (this.extensionsWithDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> extensionClassnames = new ArrayList<String>(this.extensionsWithDeps.size());
        for (BaseZapAddOnXmlData.ExtensionWithDeps extension : this.extensionsWithDeps) {
            extensionClassnames.add(extension.getClassname());
        }
        return extensionClassnames;
    }

    public AddOnClassnames getExtensionAddOnClassnames(String classname) {
        if (this.extensionsWithDeps.isEmpty() || classname == null || classname.isEmpty()) {
            return AddOnClassnames.ALL_ALLOWED;
        }
        for (BaseZapAddOnXmlData.ExtensionWithDeps extension : this.extensionsWithDeps) {
            if (!classname.equals(extension.getClassname())) continue;
            return extension.getAddOnClassnames();
        }
        return AddOnClassnames.ALL_ALLOWED;
    }

    public boolean hasExtensionsWithDeps() {
        return !this.extensionsWithDeps.isEmpty();
    }

    public List<Extension> getLoadedExtensionsWithDeps() {
        List<String> classnames = this.getExtensionsWithDeps();
        ArrayList<Extension> loadedExtensions = new ArrayList<Extension>(this.extensionsWithDeps.size());
        for (Extension extension : this.getLoadedExtensions()) {
            if (!classnames.contains(extension.getClass().getCanonicalName())) continue;
            loadedExtensions.add(extension);
        }
        loadedExtensions.trimToSize();
        return loadedExtensions;
    }

    public List<Extension> getLoadedExtensions() {
        if (this.loadedExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.loadedExtensions);
    }

    public void addLoadedExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        if (this.loadedExtensions == null) {
            this.loadedExtensions = new ArrayList<Extension>(1);
        }
        if (!this.loadedExtensions.contains(extension)) {
            this.loadedExtensions.add(extension);
            extension.setAddOn(this);
        }
    }

    public void removeLoadedExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        if (this.loadedExtensions != null && this.loadedExtensions.contains(extension)) {
            this.loadedExtensions.remove(extension);
            extension.setAddOn(null);
        }
    }

    public List<String> getAscanrules() {
        return this.ascanrules;
    }

    public List<AbstractPlugin> getLoadedAscanrules() {
        return this.loadedAscanrules;
    }

    void setLoadedAscanrules(List<AbstractPlugin> ascanrules) {
        if (ascanrules == null) {
            throw new IllegalArgumentException("Parameter ascanrules must not be null.");
        }
        if (ascanrules.isEmpty()) {
            this.loadedAscanrules = Collections.emptyList();
            return;
        }
        for (AbstractPlugin ascanrule : ascanrules) {
            ascanrule.setStatus(this.getStatus());
        }
        this.loadedAscanrules = Collections.unmodifiableList(new ArrayList<AbstractPlugin>(ascanrules));
    }

    boolean isLoadedAscanrulesSet() {
        return this.loadedAscanRulesSet;
    }

    void setLoadedAscanrulesSet(boolean ascanrulesSet) {
        this.loadedAscanRulesSet = ascanrulesSet;
    }

    public List<String> getPscanrules() {
        return this.pscanrules;
    }

    @Deprecated(since="2.15.0", forRemoval=true)
    public List<PluginPassiveScanner> getLoadedPscanrules() {
        return List.of();
    }

    public List<String> getFiles() {
        return this.files;
    }

    List<Lib> getLibs() {
        return this.libs;
    }

    private boolean hasMissingLibs() {
        return this.libs.stream().anyMatch(lib -> lib.getFileSystemUrl() == null);
    }

    public boolean isSameAddOn(AddOn addOn) {
        return this.getId().equals(addOn.getId());
    }

    public boolean isUpdateTo(AddOn addOn) throws IllegalArgumentException {
        if (!this.isSameAddOn(addOn)) {
            throw new IllegalArgumentException("Different addons: " + this.getId() + " != " + addOn.getId());
        }
        int result = this.getVersion().compareTo(addOn.getVersion());
        if (result != 0) {
            return result > 0;
        }
        result = this.getStatus().compareTo(addOn.getStatus());
        if (result != 0) {
            return result > 0;
        }
        if (this.getFile() == null) {
            return false;
        }
        if (addOn.getFile() == null) {
            return true;
        }
        return this.getFile().lastModified() > addOn.getFile().lastModified();
    }

    public boolean canLoadInCurrentVersion() {
        return this.canLoadInVersion(Constant.PROGRAM_VERSION);
    }

    public boolean canRunInCurrentJavaVersion() {
        return this.canRunInJavaVersion(SystemUtils.JAVA_VERSION);
    }

    public boolean canRunInJavaVersion(String javaVersion) {
        if (this.dependencies == null) {
            return true;
        }
        String requiredVersion = this.dependencies.getJavaVersion();
        if (requiredVersion == null) {
            return true;
        }
        if (javaVersion == null) {
            return false;
        }
        return AddOn.getJavaVersion(javaVersion) >= AddOn.getJavaVersion(requiredVersion);
    }

    public AddOnRunRequirements calculateRunRequirements(Collection<AddOn> availableAddOns) {
        return this.calculateRunRequirements(availableAddOns, true);
    }

    public AddOnRunRequirements calculateInstallRequirements(Collection<AddOn> availableAddOns) {
        return this.calculateRunRequirements(availableAddOns, false);
    }

    private AddOnRunRequirements calculateRunRequirements(Collection<AddOn> availableAddOns, boolean checkLibs) {
        AddOnRunRequirements requirements = new AddOnRunRequirements(this);
        AddOn.calculateRunRequirementsImpl(availableAddOns, requirements, null, this, checkLibs);
        if (requirements.isRunnable()) {
            AddOn.checkExtensionsWithDeps(availableAddOns, requirements, this, checkLibs);
        }
        return requirements;
    }

    private static void calculateRunRequirementsImpl(Collection<AddOn> availableAddOns, BaseRunRequirements requirements, AddOn parent, AddOn addOn, boolean checkLibs) {
        if (checkLibs && addOn.hasMissingLibs()) {
            requirements.setMissingLibsIssue(addOn);
            return;
        }
        AddOn installedVersion = AddOn.getAddOn(availableAddOns, addOn.getId());
        if (installedVersion != null && !addOn.equals(installedVersion)) {
            requirements.setIssue(BaseRunRequirements.DependencyIssue.OLDER_VERSION, installedVersion);
            LOGGER.debug("Add-on {} not runnable, old version still installed: {}", (Object)addOn, (Object)installedVersion);
            return;
        }
        if (!requirements.addDependency(parent, addOn)) {
            LOGGER.warn("Cyclic dependency detected with: {}", requirements.getDependencies());
            requirements.setIssue(BaseRunRequirements.DependencyIssue.CYCLIC, requirements.getDependencies());
            return;
        }
        if (addOn.dependencies == null) {
            return;
        }
        if (!addOn.canRunInCurrentJavaVersion()) {
            requirements.setMinimumJavaVersionIssue(addOn, addOn.dependencies.getJavaVersion());
        }
        for (BaseZapAddOnXmlData.AddOnDep dependency : addOn.dependencies.getAddOns()) {
            String addOnId = dependency.getId();
            if (addOnId == null) continue;
            AddOn addOnDep = AddOn.getAddOn(availableAddOns, addOnId);
            if (addOnDep == null) {
                requirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, addOnId);
                return;
            }
            if (!dependency.getVersion().isEmpty() && !AddOn.versionMatches(addOnDep, dependency)) {
                requirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOnDep, dependency.getVersion());
                return;
            }
            AddOn.calculateRunRequirementsImpl(availableAddOns, requirements, addOn, addOnDep, checkLibs);
            if (!requirements.hasDependencyIssue()) continue;
            return;
        }
    }

    private static void checkExtensionsWithDeps(Collection<AddOn> availableAddOns, AddOnRunRequirements requirements, AddOn addOn, boolean checkLibs) {
        if (addOn.extensionsWithDeps.isEmpty()) {
            return;
        }
        for (BaseZapAddOnXmlData.ExtensionWithDeps extension : addOn.extensionsWithDeps) {
            AddOn.calculateExtensionRunRequirements(extension, availableAddOns, requirements, addOn, checkLibs);
        }
    }

    private static void calculateExtensionRunRequirements(BaseZapAddOnXmlData.ExtensionWithDeps extension, Collection<AddOn> availableAddOns, AddOnRunRequirements requirements, AddOn addOn, boolean checkLibs) {
        ExtensionRunRequirements extensionRequirements = new ExtensionRunRequirements(addOn, extension.getClassname());
        requirements.addExtensionRequirements(extensionRequirements);
        for (BaseZapAddOnXmlData.AddOnDep dependency : extension.getDependencies()) {
            String addOnId = dependency.getId();
            if (addOnId == null) continue;
            AddOn addOnDep = AddOn.getAddOn(availableAddOns, addOnId);
            if (addOnDep == null) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    requirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, addOnId);
                    return;
                }
                extensionRequirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, addOnId);
                continue;
            }
            if (!dependency.getVersion().isEmpty() && !AddOn.versionMatches(addOnDep, dependency)) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    requirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOnDep, dependency.getVersion());
                    return;
                }
                extensionRequirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOnDep, dependency.getVersion());
                continue;
            }
            AddOn.calculateRunRequirementsImpl(availableAddOns, extensionRequirements, addOn, addOnDep, checkLibs);
        }
    }

    private boolean hasOnlyOneExtensionWithDependencies() {
        if (this.extensionsWithDeps.size() != 1) {
            return false;
        }
        return this.extensions.isEmpty() && this.files.isEmpty() && this.pscanrules.isEmpty() && this.ascanrules.isEmpty();
    }

    public AddOnRunRequirements calculateExtensionRunRequirements(Extension extension, Collection<AddOn> availableAddOns) {
        return this.calculateExtensionRunRequirementsImpl(extension.getClass().getCanonicalName(), availableAddOns, true);
    }

    public AddOnRunRequirements calculateExtensionInstallRequirements(Extension extension, Collection<AddOn> availableAddOns) {
        return this.calculateExtensionRunRequirementsImpl(extension.getClass().getCanonicalName(), availableAddOns, false);
    }

    public AddOnRunRequirements calculateExtensionRunRequirements(String classname, Collection<AddOn> availableAddOns) {
        return this.calculateExtensionRunRequirementsImpl(classname, availableAddOns, true);
    }

    public AddOnRunRequirements calculateExtensionInstallRequirements(String classname, Collection<AddOn> availableAddOns) {
        return this.calculateExtensionRunRequirementsImpl(classname, availableAddOns, false);
    }

    private AddOnRunRequirements calculateExtensionRunRequirementsImpl(String classname, Collection<AddOn> availableAddOns, boolean checkLibs) {
        AddOnRunRequirements requirements = new AddOnRunRequirements(this);
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!extensionWithDeps.getClassname().equals(classname)) continue;
            AddOn.calculateExtensionRunRequirements(extensionWithDeps, availableAddOns, requirements, this, checkLibs);
            break;
        }
        return requirements;
    }

    public boolean dependsOn(Extension extension, AddOn addOn) {
        String classname = extension.getClass().getCanonicalName();
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!extensionWithDeps.getClassname().equals(classname)) continue;
            return AddOn.dependsOn(extensionWithDeps.getDependencies(), addOn);
        }
        return false;
    }

    private static boolean dependsOn(List<BaseZapAddOnXmlData.AddOnDep> dependencies, AddOn addOn) {
        for (BaseZapAddOnXmlData.AddOnDep dependency : dependencies) {
            if (!dependency.getId().equals(addOn.id)) continue;
            if (!dependency.getVersion().isEmpty()) {
                return AddOn.versionMatches(addOn, dependency);
            }
            return true;
        }
        return false;
    }

    private static boolean versionMatches(AddOn addOn, BaseZapAddOnXmlData.AddOnDep dependency) {
        if (addOn.version.matches(dependency.getVersion())) {
            return true;
        }
        return addOn.semVer != null && addOn.semVer.matches(dependency.getVersion());
    }

    public boolean isExtensionLoaded(String classname) {
        for (Extension extension : this.getLoadedExtensions()) {
            if (!classname.equals(extension.getClass().getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    public String getMinimumJavaVersion() {
        if (this.dependencies == null) {
            return "";
        }
        return this.dependencies.getJavaVersion();
    }

    private static AddOn getAddOn(Collection<AddOn> addOns, String id) {
        for (AddOn addOn : addOns) {
            if (!addOn.getId().equals(id)) continue;
            return addOn;
        }
        return null;
    }

    public boolean canLoadInVersion(String zapVersion) {
        if (this.notBeforeVersion == null || this.notBeforeVersion.isEmpty()) {
            return false;
        }
        ZapReleaseComparitor zrc = new ZapReleaseComparitor();
        ZapRelease zr = new ZapRelease(zapVersion);
        ZapRelease notBeforeRelease = new ZapRelease(this.notBeforeVersion);
        if (zrc.compare(zr, notBeforeRelease) < 0) {
            return false;
        }
        if (zrc.compare(notBeforeRelease, v2_4) < 0) {
            return false;
        }
        if (this.notFromVersion != null && this.notFromVersion.length() > 0) {
            ZapRelease notFromRelease = new ZapRelease(this.notFromVersion);
            return zrc.compare(zr, notFromRelease) < 0;
        }
        return true;
    }

    public void setNotBeforeVersion(String notBeforeVersion) {
        this.notBeforeVersion = notBeforeVersion;
    }

    public void setNotFromVersion(String notFromVersion) {
        this.notFromVersion = notFromVersion;
    }

    public String getNotBeforeVersion() {
        return this.notBeforeVersion;
    }

    public String getNotFromVersion() {
        return this.notFromVersion;
    }

    public URL getInfo() {
        return this.info;
    }

    public void setInfo(URL info) {
        this.info = info;
    }

    public URL getRepo() {
        return this.repo;
    }

    public String getHash() {
        return this.hash;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public BundleData getBundleData() {
        return this.bundleData;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public HelpSetData getHelpSetData() {
        return this.helpSetData;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public List<String> getIdsAddOnDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>(this.dependencies.getAddOns().size());
        for (BaseZapAddOnXmlData.AddOnDep dep : this.dependencies.getAddOns()) {
            ids.add(dep.getId());
        }
        return ids;
    }

    public boolean dependsOn(AddOn addOn) {
        if (this.dependencies == null || this.dependencies.getAddOns().isEmpty()) {
            return false;
        }
        return AddOn.dependsOn(this.dependencies.getAddOns(), addOn);
    }

    public boolean dependsOn(Collection<AddOn> addOns) {
        if (this.dependencies == null || this.dependencies.getAddOns().isEmpty()) {
            return false;
        }
        for (AddOn addOn : addOns) {
            if (!this.dependsOn(addOn)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[id=").append(this.id);
        strBuilder.append(", version=").append(this.version);
        strBuilder.append(']');
        return strBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddOn other = (AddOn)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.version.equals(other.version);
    }

    private static String getRootCauseMessage(ValidationResult validationResult) {
        Exception exception = validationResult.getException();
        if (exception == null) {
            return validationResult.getValidity().toString();
        }
        Throwable root = ExceptionUtils.getRootCause((Throwable)exception);
        return root == null ? exception.getLocalizedMessage() : root.getLocalizedMessage();
    }

    private static int getJavaVersion(String javaVersion) {
        return AddOn.toVersionInt(AddOn.toJavaVersionIntArray(javaVersion, 2));
    }

    private static int[] toJavaVersionIntArray(String version, int limit) {
        if (version == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        String[] strings = StringUtils.split((String)version, (String)"._- ");
        int[] ints = new int[Math.min(limit, strings.length)];
        int j = 0;
        for (int i = 0; i < strings.length && j < limit; ++i) {
            String s = strings[i];
            if (s.length() <= 0) continue;
            try {
                ints[j] = Integer.parseInt(s);
                ++j;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ints.length > j) {
            int[] newInts = new int[j];
            System.arraycopy(ints, 0, newInts, 0, j);
            ints = newInts;
        }
        return ints;
    }

    private static int toVersionInt(int[] javaVersions) {
        if (javaVersions == null) {
            return 0;
        }
        int intVersion = 0;
        int len = javaVersions.length;
        if (len >= 1) {
            intVersion = javaVersions[0] * 100;
        }
        if (len >= 2) {
            intVersion += javaVersions[1] * 10;
        }
        if (len >= 3) {
            intVersion += javaVersions[2];
        }
        return intVersion;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getSbom() {
        if (this.file != null && this.file.exists()) {
            try (ZipFile zip = new ZipFile(this.file);){
                String string;
                block16: {
                    ZipEntry zapAddOnEntry = zip.getEntry(BOM_FILE_NAME);
                    if (zapAddOnEntry == null) {
                        String string2 = null;
                        return string2;
                    }
                    InputStream zis = zip.getInputStream(zapAddOnEntry);
                    try {
                        string = IOUtils.toString((InputStream)zis, (Charset)StandardCharsets.UTF_8);
                        if (zis == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (zis != null) {
                            try {
                                zis.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    zis.close();
                }
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static class InvalidAddOnException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final ValidationResult validationResult;

        private InvalidAddOnException(ValidationResult validationResult) {
            super(AddOn.getRootCauseMessage(validationResult), validationResult.getException());
            this.validationResult = validationResult;
        }

        public ValidationResult getValidationResult() {
            return this.validationResult;
        }
    }

    public static final class HelpSetData {
        private static final HelpSetData EMPTY_HELP_SET = new HelpSetData();
        private final String baseName;
        private final String localeToken;

        private HelpSetData() {
            this("", "");
        }

        private HelpSetData(String baseName, String localeToken) {
            this.baseName = baseName;
            this.localeToken = localeToken;
        }

        public boolean isEmpty() {
            return this == EMPTY_HELP_SET;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getLocaleToken() {
            return this.localeToken;
        }
    }

    public static final class BundleData {
        private static final BundleData EMPTY_BUNDLE = new BundleData();
        private final String baseName;
        private final String prefix;

        private BundleData() {
            this("", "");
        }

        private BundleData(String baseName, String prefix) {
            this.baseName = baseName;
            this.prefix = prefix;
        }

        public boolean isEmpty() {
            return this == EMPTY_BUNDLE;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static class ExtensionRunRequirements
    extends BaseRunRequirements {
        private final String classname;

        private ExtensionRunRequirements(AddOn addOn, String classname) {
            super(addOn);
            this.classname = classname;
        }

        public String getClassname() {
            return this.classname;
        }
    }

    public static class AddOnRunRequirements
    extends BaseRunRequirements {
        private List<ExtensionRunRequirements> addExtensionsRequirements;

        private AddOnRunRequirements(AddOn addOn) {
            super(addOn);
        }

        public List<ExtensionRunRequirements> getExtensionRequirements() {
            if (this.addExtensionsRequirements == null) {
                this.addExtensionsRequirements = Collections.emptyList();
            }
            return this.addExtensionsRequirements;
        }

        public boolean hasExtensionsWithRunningIssues() {
            for (ExtensionRunRequirements reqs : this.getExtensionRequirements()) {
                if (reqs.isRunnable()) continue;
                return true;
            }
            return false;
        }

        protected void addExtensionRequirements(ExtensionRunRequirements extension) {
            if (this.addExtensionsRequirements == null) {
                this.addExtensionsRequirements = new ArrayList<ExtensionRunRequirements>(5);
            }
            this.addExtensionsRequirements.add(extension);
        }
    }

    public static abstract class BaseRunRequirements {
        private final AddOn addOn;
        private final DirectedGraph<AddOn, DefaultEdge> dependencyTree;
        private Set<AddOn> dependencies;
        private DependencyIssue depIssue;
        private List<Object> issueDetails;
        private String minimumJavaVersion;
        private AddOn addOnMinimumJavaVersion;
        private AddOn addOnMissingLibs;
        private boolean runnable;

        private BaseRunRequirements(AddOn addOn) {
            this.addOn = addOn;
            this.dependencyTree = new DefaultDirectedGraph(DefaultEdge.class);
            this.dependencyTree.addVertex((Object)addOn);
            this.runnable = true;
            this.issueDetails = Collections.emptyList();
        }

        public AddOn getAddOn() {
            return this.addOn;
        }

        public boolean hasDependencyIssue() {
            return this.depIssue != null;
        }

        public DependencyIssue getDependencyIssue() {
            return this.depIssue;
        }

        public List<Object> getDependencyIssueDetails() {
            return this.issueDetails;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        protected void setRunnable(boolean runnable) {
            this.runnable = runnable;
        }

        public Set<AddOn> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new HashSet<AddOn>();
                TopologicalOrderIterator it = new TopologicalOrderIterator(this.dependencyTree);
                while (it.hasNext()) {
                    this.dependencies.add((AddOn)it.next());
                }
                this.dependencies.remove(this.addOn);
            }
            return Collections.unmodifiableSet(this.dependencies);
        }

        protected void setIssue(DependencyIssue issue, Object ... details) {
            this.runnable = false;
            this.depIssue = issue;
            this.issueDetails = details != null ? Arrays.asList(details) : Collections.emptyList();
        }

        protected boolean addDependency(AddOn parent, AddOn addOn) {
            if (parent == null) {
                return true;
            }
            this.dependencyTree.addVertex((Object)parent);
            this.dependencyTree.addVertex((Object)addOn);
            this.dependencyTree.addEdge((Object)parent, (Object)addOn);
            CycleDetector cycleDetector = new CycleDetector(this.dependencyTree);
            boolean cycle = cycleDetector.detectCycles();
            if (cycle) {
                this.dependencies = cycleDetector.findCycles();
                return false;
            }
            return true;
        }

        public boolean isNewerJavaVersionRequired() {
            return this.minimumJavaVersion != null;
        }

        public String getMinimumJavaVersion() {
            return this.minimumJavaVersion;
        }

        public AddOn getAddOnMinimumJavaVersion() {
            return this.addOnMinimumJavaVersion;
        }

        protected void setMinimumJavaVersionIssue(AddOn srcAddOn, String requiredVersion) {
            this.setRunnable(false);
            if (this.minimumJavaVersion == null) {
                this.setMinimumJavaVersion(srcAddOn, requiredVersion);
            } else if (AddOn.getJavaVersion(requiredVersion) > AddOn.getJavaVersion(this.minimumJavaVersion)) {
                this.setMinimumJavaVersion(srcAddOn, requiredVersion);
            }
        }

        private void setMinimumJavaVersion(AddOn srcAddOn, String requiredVersion) {
            this.addOnMinimumJavaVersion = srcAddOn;
            this.minimumJavaVersion = requiredVersion;
        }

        public boolean hasMissingLibs() {
            return this.addOnMissingLibs != null;
        }

        public AddOn getAddOnMissingLibs() {
            return this.addOnMissingLibs;
        }

        protected void setMissingLibsIssue(AddOn srcAddOn) {
            this.setRunnable(false);
            this.addOnMissingLibs = srcAddOn;
        }

        public static enum DependencyIssue {
            CYCLIC,
            OLDER_VERSION,
            MISSING,
            PACKAGE_VERSION_NOT_BEFORE,
            PACKAGE_VERSION_NOT_FROM,
            VERSION;

        }
    }

    static class Lib {
        private final String jarPath;
        private final String name;
        private URL fileSystemUrl;

        Lib(String path) {
            this.jarPath = path;
            this.name = Lib.extractName(path);
        }

        String getJarPath() {
            return this.jarPath;
        }

        String getName() {
            return this.name;
        }

        URL getFileSystemUrl() {
            return this.fileSystemUrl;
        }

        void setFileSystemUrl(URL fileSystemUrl) {
            this.fileSystemUrl = fileSystemUrl;
        }

        private static String extractName(String path) {
            int idx = path.lastIndexOf(47);
            if (idx == -1) {
                return path;
            }
            return path.substring(idx + 1);
        }

        public int hashCode() {
            return Objects.hash(this.jarPath);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.jarPath, ((Lib)obj).jarPath);
        }
    }

    public static class ValidationResult {
        private final Validity validity;
        private final Exception exception;
        private final ZapAddOnXmlFile manifest;

        private ValidationResult(Validity validity) {
            this(validity, null);
        }

        private ValidationResult(ZapAddOnXmlFile manifest) {
            this(Validity.VALID, null, manifest);
        }

        private ValidationResult(Validity validity, Exception exception) {
            this(validity, exception, null);
        }

        private ValidationResult(Validity validity, Exception exception, ZapAddOnXmlFile manifest) {
            this.validity = validity;
            this.exception = exception;
            this.manifest = manifest;
        }

        public Validity getValidity() {
            return this.validity;
        }

        public Exception getException() {
            return this.exception;
        }

        public ZapAddOnXmlFile getManifest() {
            return this.manifest;
        }

        public static enum Validity {
            VALID,
            INVALID_PATH,
            INVALID_FILE_NAME,
            FILE_NOT_READABLE,
            UNREADABLE_ZIP_FILE,
            IO_ERROR_FILE,
            MISSING_MANIFEST,
            INVALID_MANIFEST,
            INVALID_LIB;

        }
    }

    public static enum InstallationStatus {
        AVAILABLE,
        NOT_INSTALLED,
        INSTALLED,
        DOWNLOADING,
        UNINSTALLATION_FAILED,
        SOFT_UNINSTALLATION_FAILED;

    }

    public static enum Status {
        unknown,
        example,
        alpha,
        beta,
        weekly,
        release;

    }
}

