/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.PostBasedAuthenticationMethodType;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Stats;

public class AuthenticationHelper {
    private HttpSender httpSender;
    private SessionManagementMethod sessionManagementMethod;
    private User user;
    private static final Logger LOGGER = LogManager.getLogger(AuthenticationHelper.class);
    private static final String HISTORY_TAG_AUTHENTICATION = "Authentication";
    public static final String AUTH_SUCCESS_STATS = "stats.auth.success";
    public static final String AUTH_FAILURE_STATS = "stats.auth.failure";

    public AuthenticationHelper(HttpSender httpSender, SessionManagementMethod sessionManagementMethod, User user) {
        this.httpSender = httpSender;
        this.sessionManagementMethod = sessionManagementMethod;
        this.user = user;
    }

    @Deprecated
    public static void notifyOutputAuthSuccessful() {
        AuthenticationHelper.notifyOutputAuthSuccessful(null);
    }

    public static void notifyOutputAuthSuccessful(HttpMessage msg) {
        if (msg != null) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_SUCCESS_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        if (View.isInitialised()) {
            View.getSingleton().getOutputPanel().appendAsync(Constant.messages.getString("authentication.output.success") + "\n");
        }
    }

    public static void notifyOutputAuthFailure(HttpMessage msg) {
        try {
            Stats.incCounter(SessionStructure.getHostName(msg), AUTH_FAILURE_STATS);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        if (View.isInitialised()) {
            View.getSingleton().getOutputPanel().appendAsync(Constant.messages.getString("authentication.output.failure", msg.getRequestHeader().getURI().toString()) + "\n");
        }
    }

    public HttpState getCorrespondingHttpState() {
        if (this.user.getAuthenticatedSession() == null) {
            this.user.setAuthenticatedSession(this.sessionManagementMethod.createEmptyWebSession());
        }
        return this.user.getCorrespondingHttpState();
    }

    public static void addAuthMessageToHistory(HttpMessage msg) {
        try {
            ExtensionHistory extHistory;
            final HistoryReference ref = new HistoryReference(Model.getSingleton().getSession(), 11, msg);
            ref.addTag(HISTORY_TAG_AUTHENTICATION);
            if (View.isInitialised() && (extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class)) != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        extHistory.addHistory(ref);
                    }
                });
            }
        }
        catch (Exception ex) {
            LOGGER.error("Cannot add authentication message to History tab.", (Throwable)ex);
        }
    }

    public HttpMessage prepareMessage() {
        return AuthenticationHelper.prepareMessage(this.sessionManagementMethod, this.user);
    }

    public static HttpMessage prepareMessage(SessionManagementMethod sessionManagementMethod, User user) {
        HttpMessage msg = new HttpMessage();
        if (user.getAuthenticatedSession() == null) {
            user.setAuthenticatedSession(sessionManagementMethod.createEmptyWebSession());
        }
        msg.setRequestingUser(user);
        return msg;
    }

    public static String replaceUserData(String data, Map<String, String> keyValuePairs, UnaryOperator<String> encoder) {
        for (Map.Entry<String, String> kvp : keyValuePairs.entrySet()) {
            data = data.replace(kvp.getKey(), (CharSequence)encoder.apply(kvp.getValue()));
        }
        return data;
    }

    public static void replaceUserDataInRequest(HttpMessage msg, Map<String, String> userDataMap, UnaryOperator<String> bodyEncoder) {
        try {
            HashMap<String, String> kvMap = new HashMap<String, String>(userDataMap.size());
            for (Map.Entry<String, String> userdata : userDataMap.entrySet()) {
                kvMap.put(URLEncoder.encode(userdata.getKey(), StandardCharsets.UTF_8.name()), userdata.getValue());
            }
            String uri = AuthenticationHelper.replaceUserData(msg.getRequestHeader().getURI().toString(), kvMap, PostBasedAuthenticationMethodType::encodeParameter);
            msg.getRequestHeader().setURI(new URI(uri, true));
        }
        catch (Exception e) {
            LOGGER.error("Failed to replace user data in request {}", (Object)msg.getRequestHeader().getURI(), (Object)e);
        }
        if (msg.getRequestBody().length() > 0) {
            msg.setRequestBody(AuthenticationHelper.replaceUserData(msg.getRequestBody().toString(), userDataMap, bodyEncoder));
            msg.getRequestHeader().setContentLength(msg.getRequestBody().length());
        }
    }

    public User getRequestingUser() {
        if (this.user.getAuthenticatedSession() == null) {
            this.user.setAuthenticatedSession(this.sessionManagementMethod.createEmptyWebSession());
        }
        return this.user;
    }

    public void sendAndReceive(HttpMessage msg) throws IOException {
        this.httpSender.sendAndReceive(msg);
    }

    public void sendAndReceive(HttpMessage msg, boolean followRedirect) throws IOException {
        this.httpSender.sendAndReceive(msg, followRedirect);
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }
}

