package page

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
	"github.com/chromedp/cdproto/runtime"
	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// AdScriptID identifies the bottom-most script which caused the frame to be
// labelled as an ad.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AdScriptId
type AdScriptID struct {
	ScriptID   runtime.ScriptID         `json:"scriptId"`   // Script Id of the bottom-most script which caused the frame to be labelled as an ad.
	DebuggerID runtime.UniqueDebuggerID `json:"debuggerId"` // Id of adScriptId's debugger.
}

// PermissionsPolicyFeature all Permissions Policy features. This enum should
// match the one defined in
// third_party/blink/renderer/core/permissions_policy/permissions_policy_features.json5.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyFeature
type PermissionsPolicyFeature string

// String returns the PermissionsPolicyFeature as string value.
func (t PermissionsPolicyFeature) String() string {
	return string(t)
}

// PermissionsPolicyFeature values.
const (
	PermissionsPolicyFeatureAccelerometer               PermissionsPolicyFeature = "accelerometer"
	PermissionsPolicyFeatureAmbientLightSensor          PermissionsPolicyFeature = "ambient-light-sensor"
	PermissionsPolicyFeatureAttributionReporting        PermissionsPolicyFeature = "attribution-reporting"
	PermissionsPolicyFeatureAutoplay                    PermissionsPolicyFeature = "autoplay"
	PermissionsPolicyFeatureBluetooth                   PermissionsPolicyFeature = "bluetooth"
	PermissionsPolicyFeatureBrowsingTopics              PermissionsPolicyFeature = "browsing-topics"
	PermissionsPolicyFeatureCamera                      PermissionsPolicyFeature = "camera"
	PermissionsPolicyFeatureChDpr                       PermissionsPolicyFeature = "ch-dpr"
	PermissionsPolicyFeatureChDeviceMemory              PermissionsPolicyFeature = "ch-device-memory"
	PermissionsPolicyFeatureChDownlink                  PermissionsPolicyFeature = "ch-downlink"
	PermissionsPolicyFeatureChEct                       PermissionsPolicyFeature = "ch-ect"
	PermissionsPolicyFeatureChPrefersColorScheme        PermissionsPolicyFeature = "ch-prefers-color-scheme"
	PermissionsPolicyFeatureChPrefersReducedMotion      PermissionsPolicyFeature = "ch-prefers-reduced-motion"
	PermissionsPolicyFeatureChRtt                       PermissionsPolicyFeature = "ch-rtt"
	PermissionsPolicyFeatureChSaveData                  PermissionsPolicyFeature = "ch-save-data"
	PermissionsPolicyFeatureChUa                        PermissionsPolicyFeature = "ch-ua"
	PermissionsPolicyFeatureChUaArch                    PermissionsPolicyFeature = "ch-ua-arch"
	PermissionsPolicyFeatureChUaBitness                 PermissionsPolicyFeature = "ch-ua-bitness"
	PermissionsPolicyFeatureChUaPlatform                PermissionsPolicyFeature = "ch-ua-platform"
	PermissionsPolicyFeatureChUaModel                   PermissionsPolicyFeature = "ch-ua-model"
	PermissionsPolicyFeatureChUaMobile                  PermissionsPolicyFeature = "ch-ua-mobile"
	PermissionsPolicyFeatureChUaFull                    PermissionsPolicyFeature = "ch-ua-full"
	PermissionsPolicyFeatureChUaFullVersion             PermissionsPolicyFeature = "ch-ua-full-version"
	PermissionsPolicyFeatureChUaFullVersionList         PermissionsPolicyFeature = "ch-ua-full-version-list"
	PermissionsPolicyFeatureChUaPlatformVersion         PermissionsPolicyFeature = "ch-ua-platform-version"
	PermissionsPolicyFeatureChUaReduced                 PermissionsPolicyFeature = "ch-ua-reduced"
	PermissionsPolicyFeatureChUaWow64                   PermissionsPolicyFeature = "ch-ua-wow64"
	PermissionsPolicyFeatureChViewportHeight            PermissionsPolicyFeature = "ch-viewport-height"
	PermissionsPolicyFeatureChViewportWidth             PermissionsPolicyFeature = "ch-viewport-width"
	PermissionsPolicyFeatureChWidth                     PermissionsPolicyFeature = "ch-width"
	PermissionsPolicyFeatureClipboardRead               PermissionsPolicyFeature = "clipboard-read"
	PermissionsPolicyFeatureClipboardWrite              PermissionsPolicyFeature = "clipboard-write"
	PermissionsPolicyFeatureComputePressure             PermissionsPolicyFeature = "compute-pressure"
	PermissionsPolicyFeatureCrossOriginIsolated         PermissionsPolicyFeature = "cross-origin-isolated"
	PermissionsPolicyFeatureDirectSockets               PermissionsPolicyFeature = "direct-sockets"
	PermissionsPolicyFeatureDisplayCapture              PermissionsPolicyFeature = "display-capture"
	PermissionsPolicyFeatureDocumentDomain              PermissionsPolicyFeature = "document-domain"
	PermissionsPolicyFeatureEncryptedMedia              PermissionsPolicyFeature = "encrypted-media"
	PermissionsPolicyFeatureExecutionWhileOutOfViewport PermissionsPolicyFeature = "execution-while-out-of-viewport"
	PermissionsPolicyFeatureExecutionWhileNotRendered   PermissionsPolicyFeature = "execution-while-not-rendered"
	PermissionsPolicyFeatureFocusWithoutUserActivation  PermissionsPolicyFeature = "focus-without-user-activation"
	PermissionsPolicyFeatureFullscreen                  PermissionsPolicyFeature = "fullscreen"
	PermissionsPolicyFeatureFrobulate                   PermissionsPolicyFeature = "frobulate"
	PermissionsPolicyFeatureGamepad                     PermissionsPolicyFeature = "gamepad"
	PermissionsPolicyFeatureGeolocation                 PermissionsPolicyFeature = "geolocation"
	PermissionsPolicyFeatureGyroscope                   PermissionsPolicyFeature = "gyroscope"
	PermissionsPolicyFeatureHid                         PermissionsPolicyFeature = "hid"
	PermissionsPolicyFeatureIdentityCredentialsGet      PermissionsPolicyFeature = "identity-credentials-get"
	PermissionsPolicyFeatureIdleDetection               PermissionsPolicyFeature = "idle-detection"
	PermissionsPolicyFeatureInterestCohort              PermissionsPolicyFeature = "interest-cohort"
	PermissionsPolicyFeatureJoinAdInterestGroup         PermissionsPolicyFeature = "join-ad-interest-group"
	PermissionsPolicyFeatureKeyboardMap                 PermissionsPolicyFeature = "keyboard-map"
	PermissionsPolicyFeatureLocalFonts                  PermissionsPolicyFeature = "local-fonts"
	PermissionsPolicyFeatureMagnetometer                PermissionsPolicyFeature = "magnetometer"
	PermissionsPolicyFeatureMicrophone                  PermissionsPolicyFeature = "microphone"
	PermissionsPolicyFeatureMidi                        PermissionsPolicyFeature = "midi"
	PermissionsPolicyFeatureOtpCredentials              PermissionsPolicyFeature = "otp-credentials"
	PermissionsPolicyFeaturePayment                     PermissionsPolicyFeature = "payment"
	PermissionsPolicyFeaturePictureInPicture            PermissionsPolicyFeature = "picture-in-picture"
	PermissionsPolicyFeaturePrivateAggregation          PermissionsPolicyFeature = "private-aggregation"
	PermissionsPolicyFeaturePublickeyCredentialsGet     PermissionsPolicyFeature = "publickey-credentials-get"
	PermissionsPolicyFeatureRunAdAuction                PermissionsPolicyFeature = "run-ad-auction"
	PermissionsPolicyFeatureScreenWakeLock              PermissionsPolicyFeature = "screen-wake-lock"
	PermissionsPolicyFeatureSerial                      PermissionsPolicyFeature = "serial"
	PermissionsPolicyFeatureSharedAutofill              PermissionsPolicyFeature = "shared-autofill"
	PermissionsPolicyFeatureSharedStorage               PermissionsPolicyFeature = "shared-storage"
	PermissionsPolicyFeatureSharedStorageSelectURL      PermissionsPolicyFeature = "shared-storage-select-url"
	PermissionsPolicyFeatureSmartCard                   PermissionsPolicyFeature = "smart-card"
	PermissionsPolicyFeatureStorageAccess               PermissionsPolicyFeature = "storage-access"
	PermissionsPolicyFeatureSyncXhr                     PermissionsPolicyFeature = "sync-xhr"
	PermissionsPolicyFeatureTrustTokenRedemption        PermissionsPolicyFeature = "trust-token-redemption"
	PermissionsPolicyFeatureUnload                      PermissionsPolicyFeature = "unload"
	PermissionsPolicyFeatureUsb                         PermissionsPolicyFeature = "usb"
	PermissionsPolicyFeatureVerticalScroll              PermissionsPolicyFeature = "vertical-scroll"
	PermissionsPolicyFeatureWebShare                    PermissionsPolicyFeature = "web-share"
	PermissionsPolicyFeatureWindowManagement            PermissionsPolicyFeature = "window-management"
	PermissionsPolicyFeatureWindowPlacement             PermissionsPolicyFeature = "window-placement"
	PermissionsPolicyFeatureXrSpatialTracking           PermissionsPolicyFeature = "xr-spatial-tracking"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PermissionsPolicyFeature) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PermissionsPolicyFeature) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PermissionsPolicyFeature) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PermissionsPolicyFeature(v) {
	case PermissionsPolicyFeatureAccelerometer:
		*t = PermissionsPolicyFeatureAccelerometer
	case PermissionsPolicyFeatureAmbientLightSensor:
		*t = PermissionsPolicyFeatureAmbientLightSensor
	case PermissionsPolicyFeatureAttributionReporting:
		*t = PermissionsPolicyFeatureAttributionReporting
	case PermissionsPolicyFeatureAutoplay:
		*t = PermissionsPolicyFeatureAutoplay
	case PermissionsPolicyFeatureBluetooth:
		*t = PermissionsPolicyFeatureBluetooth
	case PermissionsPolicyFeatureBrowsingTopics:
		*t = PermissionsPolicyFeatureBrowsingTopics
	case PermissionsPolicyFeatureCamera:
		*t = PermissionsPolicyFeatureCamera
	case PermissionsPolicyFeatureChDpr:
		*t = PermissionsPolicyFeatureChDpr
	case PermissionsPolicyFeatureChDeviceMemory:
		*t = PermissionsPolicyFeatureChDeviceMemory
	case PermissionsPolicyFeatureChDownlink:
		*t = PermissionsPolicyFeatureChDownlink
	case PermissionsPolicyFeatureChEct:
		*t = PermissionsPolicyFeatureChEct
	case PermissionsPolicyFeatureChPrefersColorScheme:
		*t = PermissionsPolicyFeatureChPrefersColorScheme
	case PermissionsPolicyFeatureChPrefersReducedMotion:
		*t = PermissionsPolicyFeatureChPrefersReducedMotion
	case PermissionsPolicyFeatureChRtt:
		*t = PermissionsPolicyFeatureChRtt
	case PermissionsPolicyFeatureChSaveData:
		*t = PermissionsPolicyFeatureChSaveData
	case PermissionsPolicyFeatureChUa:
		*t = PermissionsPolicyFeatureChUa
	case PermissionsPolicyFeatureChUaArch:
		*t = PermissionsPolicyFeatureChUaArch
	case PermissionsPolicyFeatureChUaBitness:
		*t = PermissionsPolicyFeatureChUaBitness
	case PermissionsPolicyFeatureChUaPlatform:
		*t = PermissionsPolicyFeatureChUaPlatform
	case PermissionsPolicyFeatureChUaModel:
		*t = PermissionsPolicyFeatureChUaModel
	case PermissionsPolicyFeatureChUaMobile:
		*t = PermissionsPolicyFeatureChUaMobile
	case PermissionsPolicyFeatureChUaFull:
		*t = PermissionsPolicyFeatureChUaFull
	case PermissionsPolicyFeatureChUaFullVersion:
		*t = PermissionsPolicyFeatureChUaFullVersion
	case PermissionsPolicyFeatureChUaFullVersionList:
		*t = PermissionsPolicyFeatureChUaFullVersionList
	case PermissionsPolicyFeatureChUaPlatformVersion:
		*t = PermissionsPolicyFeatureChUaPlatformVersion
	case PermissionsPolicyFeatureChUaReduced:
		*t = PermissionsPolicyFeatureChUaReduced
	case PermissionsPolicyFeatureChUaWow64:
		*t = PermissionsPolicyFeatureChUaWow64
	case PermissionsPolicyFeatureChViewportHeight:
		*t = PermissionsPolicyFeatureChViewportHeight
	case PermissionsPolicyFeatureChViewportWidth:
		*t = PermissionsPolicyFeatureChViewportWidth
	case PermissionsPolicyFeatureChWidth:
		*t = PermissionsPolicyFeatureChWidth
	case PermissionsPolicyFeatureClipboardRead:
		*t = PermissionsPolicyFeatureClipboardRead
	case PermissionsPolicyFeatureClipboardWrite:
		*t = PermissionsPolicyFeatureClipboardWrite
	case PermissionsPolicyFeatureComputePressure:
		*t = PermissionsPolicyFeatureComputePressure
	case PermissionsPolicyFeatureCrossOriginIsolated:
		*t = PermissionsPolicyFeatureCrossOriginIsolated
	case PermissionsPolicyFeatureDirectSockets:
		*t = PermissionsPolicyFeatureDirectSockets
	case PermissionsPolicyFeatureDisplayCapture:
		*t = PermissionsPolicyFeatureDisplayCapture
	case PermissionsPolicyFeatureDocumentDomain:
		*t = PermissionsPolicyFeatureDocumentDomain
	case PermissionsPolicyFeatureEncryptedMedia:
		*t = PermissionsPolicyFeatureEncryptedMedia
	case PermissionsPolicyFeatureExecutionWhileOutOfViewport:
		*t = PermissionsPolicyFeatureExecutionWhileOutOfViewport
	case PermissionsPolicyFeatureExecutionWhileNotRendered:
		*t = PermissionsPolicyFeatureExecutionWhileNotRendered
	case PermissionsPolicyFeatureFocusWithoutUserActivation:
		*t = PermissionsPolicyFeatureFocusWithoutUserActivation
	case PermissionsPolicyFeatureFullscreen:
		*t = PermissionsPolicyFeatureFullscreen
	case PermissionsPolicyFeatureFrobulate:
		*t = PermissionsPolicyFeatureFrobulate
	case PermissionsPolicyFeatureGamepad:
		*t = PermissionsPolicyFeatureGamepad
	case PermissionsPolicyFeatureGeolocation:
		*t = PermissionsPolicyFeatureGeolocation
	case PermissionsPolicyFeatureGyroscope:
		*t = PermissionsPolicyFeatureGyroscope
	case PermissionsPolicyFeatureHid:
		*t = PermissionsPolicyFeatureHid
	case PermissionsPolicyFeatureIdentityCredentialsGet:
		*t = PermissionsPolicyFeatureIdentityCredentialsGet
	case PermissionsPolicyFeatureIdleDetection:
		*t = PermissionsPolicyFeatureIdleDetection
	case PermissionsPolicyFeatureInterestCohort:
		*t = PermissionsPolicyFeatureInterestCohort
	case PermissionsPolicyFeatureJoinAdInterestGroup:
		*t = PermissionsPolicyFeatureJoinAdInterestGroup
	case PermissionsPolicyFeatureKeyboardMap:
		*t = PermissionsPolicyFeatureKeyboardMap
	case PermissionsPolicyFeatureLocalFonts:
		*t = PermissionsPolicyFeatureLocalFonts
	case PermissionsPolicyFeatureMagnetometer:
		*t = PermissionsPolicyFeatureMagnetometer
	case PermissionsPolicyFeatureMicrophone:
		*t = PermissionsPolicyFeatureMicrophone
	case PermissionsPolicyFeatureMidi:
		*t = PermissionsPolicyFeatureMidi
	case PermissionsPolicyFeatureOtpCredentials:
		*t = PermissionsPolicyFeatureOtpCredentials
	case PermissionsPolicyFeaturePayment:
		*t = PermissionsPolicyFeaturePayment
	case PermissionsPolicyFeaturePictureInPicture:
		*t = PermissionsPolicyFeaturePictureInPicture
	case PermissionsPolicyFeaturePrivateAggregation:
		*t = PermissionsPolicyFeaturePrivateAggregation
	case PermissionsPolicyFeaturePublickeyCredentialsGet:
		*t = PermissionsPolicyFeaturePublickeyCredentialsGet
	case PermissionsPolicyFeatureRunAdAuction:
		*t = PermissionsPolicyFeatureRunAdAuction
	case PermissionsPolicyFeatureScreenWakeLock:
		*t = PermissionsPolicyFeatureScreenWakeLock
	case PermissionsPolicyFeatureSerial:
		*t = PermissionsPolicyFeatureSerial
	case PermissionsPolicyFeatureSharedAutofill:
		*t = PermissionsPolicyFeatureSharedAutofill
	case PermissionsPolicyFeatureSharedStorage:
		*t = PermissionsPolicyFeatureSharedStorage
	case PermissionsPolicyFeatureSharedStorageSelectURL:
		*t = PermissionsPolicyFeatureSharedStorageSelectURL
	case PermissionsPolicyFeatureSmartCard:
		*t = PermissionsPolicyFeatureSmartCard
	case PermissionsPolicyFeatureStorageAccess:
		*t = PermissionsPolicyFeatureStorageAccess
	case PermissionsPolicyFeatureSyncXhr:
		*t = PermissionsPolicyFeatureSyncXhr
	case PermissionsPolicyFeatureTrustTokenRedemption:
		*t = PermissionsPolicyFeatureTrustTokenRedemption
	case PermissionsPolicyFeatureUnload:
		*t = PermissionsPolicyFeatureUnload
	case PermissionsPolicyFeatureUsb:
		*t = PermissionsPolicyFeatureUsb
	case PermissionsPolicyFeatureVerticalScroll:
		*t = PermissionsPolicyFeatureVerticalScroll
	case PermissionsPolicyFeatureWebShare:
		*t = PermissionsPolicyFeatureWebShare
	case PermissionsPolicyFeatureWindowManagement:
		*t = PermissionsPolicyFeatureWindowManagement
	case PermissionsPolicyFeatureWindowPlacement:
		*t = PermissionsPolicyFeatureWindowPlacement
	case PermissionsPolicyFeatureXrSpatialTracking:
		*t = PermissionsPolicyFeatureXrSpatialTracking

	default:
		in.AddError(fmt.Errorf("unknown PermissionsPolicyFeature value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PermissionsPolicyFeature) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// PermissionsPolicyBlockReason reason for a permissions policy feature to be
// disabled.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyBlockReason
type PermissionsPolicyBlockReason string

// String returns the PermissionsPolicyBlockReason as string value.
func (t PermissionsPolicyBlockReason) String() string {
	return string(t)
}

// PermissionsPolicyBlockReason values.
const (
	PermissionsPolicyBlockReasonHeader            PermissionsPolicyBlockReason = "Header"
	PermissionsPolicyBlockReasonIframeAttribute   PermissionsPolicyBlockReason = "IframeAttribute"
	PermissionsPolicyBlockReasonInFencedFrameTree PermissionsPolicyBlockReason = "InFencedFrameTree"
	PermissionsPolicyBlockReasonInIsolatedApp     PermissionsPolicyBlockReason = "InIsolatedApp"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PermissionsPolicyBlockReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PermissionsPolicyBlockReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PermissionsPolicyBlockReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PermissionsPolicyBlockReason(v) {
	case PermissionsPolicyBlockReasonHeader:
		*t = PermissionsPolicyBlockReasonHeader
	case PermissionsPolicyBlockReasonIframeAttribute:
		*t = PermissionsPolicyBlockReasonIframeAttribute
	case PermissionsPolicyBlockReasonInFencedFrameTree:
		*t = PermissionsPolicyBlockReasonInFencedFrameTree
	case PermissionsPolicyBlockReasonInIsolatedApp:
		*t = PermissionsPolicyBlockReasonInIsolatedApp

	default:
		in.AddError(fmt.Errorf("unknown PermissionsPolicyBlockReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PermissionsPolicyBlockReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// PermissionsPolicyBlockLocator [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyBlockLocator
type PermissionsPolicyBlockLocator struct {
	FrameID     cdp.FrameID                  `json:"frameId"`
	BlockReason PermissionsPolicyBlockReason `json:"blockReason"`
}

// PermissionsPolicyFeatureState [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyFeatureState
type PermissionsPolicyFeatureState struct {
	Feature PermissionsPolicyFeature       `json:"feature"`
	Allowed bool                           `json:"allowed"`
	Locator *PermissionsPolicyBlockLocator `json:"locator,omitempty"`
}

// FrameResource information about the Resource on the page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameResource
type FrameResource struct {
	URL          string               `json:"url"`                    // Resource URL.
	Type         network.ResourceType `json:"type"`                   // Type of this resource.
	MimeType     string               `json:"mimeType"`               // Resource mimeType as determined by the browser.
	LastModified *cdp.TimeSinceEpoch  `json:"lastModified,omitempty"` // last-modified timestamp as reported by server.
	ContentSize  float64              `json:"contentSize,omitempty"`  // Resource content size.
	Failed       bool                 `json:"failed,omitempty"`       // True if the resource failed to load.
	Canceled     bool                 `json:"canceled,omitempty"`     // True if the resource was canceled during loading.
}

// FrameResourceTree information about the Frame hierarchy along with their
// cached resources.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameResourceTree
type FrameResourceTree struct {
	Frame       *cdp.Frame           `json:"frame"`                 // Frame information for this tree item.
	ChildFrames []*FrameResourceTree `json:"childFrames,omitempty"` // Child frames.
	Resources   []*FrameResource     `json:"resources"`             // Information about frame resources.
}

// FrameTree information about the Frame hierarchy.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameTree
type FrameTree struct {
	Frame       *cdp.Frame   `json:"frame"`                 // Frame information for this tree item.
	ChildFrames []*FrameTree `json:"childFrames,omitempty"` // Child frames.
}

// ScriptIdentifier unique script identifier.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScriptIdentifier
type ScriptIdentifier string

// String returns the ScriptIdentifier as string value.
func (t ScriptIdentifier) String() string {
	return string(t)
}

// TransitionType transition type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-TransitionType
type TransitionType string

// String returns the TransitionType as string value.
func (t TransitionType) String() string {
	return string(t)
}

// TransitionType values.
const (
	TransitionTypeLink             TransitionType = "link"
	TransitionTypeTyped            TransitionType = "typed"
	TransitionTypeAddressBar       TransitionType = "address_bar"
	TransitionTypeAutoBookmark     TransitionType = "auto_bookmark"
	TransitionTypeAutoSubframe     TransitionType = "auto_subframe"
	TransitionTypeManualSubframe   TransitionType = "manual_subframe"
	TransitionTypeGenerated        TransitionType = "generated"
	TransitionTypeAutoToplevel     TransitionType = "auto_toplevel"
	TransitionTypeFormSubmit       TransitionType = "form_submit"
	TransitionTypeReload           TransitionType = "reload"
	TransitionTypeKeyword          TransitionType = "keyword"
	TransitionTypeKeywordGenerated TransitionType = "keyword_generated"
	TransitionTypeOther            TransitionType = "other"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t TransitionType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t TransitionType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *TransitionType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch TransitionType(v) {
	case TransitionTypeLink:
		*t = TransitionTypeLink
	case TransitionTypeTyped:
		*t = TransitionTypeTyped
	case TransitionTypeAddressBar:
		*t = TransitionTypeAddressBar
	case TransitionTypeAutoBookmark:
		*t = TransitionTypeAutoBookmark
	case TransitionTypeAutoSubframe:
		*t = TransitionTypeAutoSubframe
	case TransitionTypeManualSubframe:
		*t = TransitionTypeManualSubframe
	case TransitionTypeGenerated:
		*t = TransitionTypeGenerated
	case TransitionTypeAutoToplevel:
		*t = TransitionTypeAutoToplevel
	case TransitionTypeFormSubmit:
		*t = TransitionTypeFormSubmit
	case TransitionTypeReload:
		*t = TransitionTypeReload
	case TransitionTypeKeyword:
		*t = TransitionTypeKeyword
	case TransitionTypeKeywordGenerated:
		*t = TransitionTypeKeywordGenerated
	case TransitionTypeOther:
		*t = TransitionTypeOther

	default:
		in.AddError(fmt.Errorf("unknown TransitionType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *TransitionType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// NavigationEntry navigation history entry.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-NavigationEntry
type NavigationEntry struct {
	ID             int64          `json:"id"`             // Unique id of the navigation history entry.
	URL            string         `json:"url"`            // URL of the navigation history entry.
	UserTypedURL   string         `json:"userTypedURL"`   // URL that the user typed in the url bar.
	Title          string         `json:"title"`          // Title of the navigation history entry.
	TransitionType TransitionType `json:"transitionType"` // Transition type.
}

// ScreencastFrameMetadata screencast frame metadata.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScreencastFrameMetadata
type ScreencastFrameMetadata struct {
	OffsetTop       float64             `json:"offsetTop"`           // Top offset in DIP.
	PageScaleFactor float64             `json:"pageScaleFactor"`     // Page scale factor.
	DeviceWidth     float64             `json:"deviceWidth"`         // Device screen width in DIP.
	DeviceHeight    float64             `json:"deviceHeight"`        // Device screen height in DIP.
	ScrollOffsetX   float64             `json:"scrollOffsetX"`       // Position of horizontal scroll in CSS pixels.
	ScrollOffsetY   float64             `json:"scrollOffsetY"`       // Position of vertical scroll in CSS pixels.
	Timestamp       *cdp.TimeSinceEpoch `json:"timestamp,omitempty"` // Frame swap timestamp.
}

// DialogType javascript dialog type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-DialogType
type DialogType string

// String returns the DialogType as string value.
func (t DialogType) String() string {
	return string(t)
}

// DialogType values.
const (
	DialogTypeAlert        DialogType = "alert"
	DialogTypeConfirm      DialogType = "confirm"
	DialogTypePrompt       DialogType = "prompt"
	DialogTypeBeforeunload DialogType = "beforeunload"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DialogType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DialogType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DialogType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch DialogType(v) {
	case DialogTypeAlert:
		*t = DialogTypeAlert
	case DialogTypeConfirm:
		*t = DialogTypeConfirm
	case DialogTypePrompt:
		*t = DialogTypePrompt
	case DialogTypeBeforeunload:
		*t = DialogTypeBeforeunload

	default:
		in.AddError(fmt.Errorf("unknown DialogType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DialogType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AppManifestError error while paring app manifest.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AppManifestError
type AppManifestError struct {
	Message  string `json:"message"`  // Error message.
	Critical int64  `json:"critical"` // If criticial, this is a non-recoverable parse error.
	Line     int64  `json:"line"`     // Error line.
	Column   int64  `json:"column"`   // Error column.
}

// AppManifestParsedProperties parsed app manifest properties.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AppManifestParsedProperties
type AppManifestParsedProperties struct {
	Scope string `json:"scope"` // Computed scope value
}

// LayoutViewport layout viewport position and dimensions.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-LayoutViewport
type LayoutViewport struct {
	PageX        int64 `json:"pageX"`        // Horizontal offset relative to the document (CSS pixels).
	PageY        int64 `json:"pageY"`        // Vertical offset relative to the document (CSS pixels).
	ClientWidth  int64 `json:"clientWidth"`  // Width (CSS pixels), excludes scrollbar if present.
	ClientHeight int64 `json:"clientHeight"` // Height (CSS pixels), excludes scrollbar if present.
}

// VisualViewport visual viewport position, dimensions, and scale.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-VisualViewport
type VisualViewport struct {
	OffsetX      float64 `json:"offsetX"`        // Horizontal offset relative to the layout viewport (CSS pixels).
	OffsetY      float64 `json:"offsetY"`        // Vertical offset relative to the layout viewport (CSS pixels).
	PageX        float64 `json:"pageX"`          // Horizontal offset relative to the document (CSS pixels).
	PageY        float64 `json:"pageY"`          // Vertical offset relative to the document (CSS pixels).
	ClientWidth  float64 `json:"clientWidth"`    // Width (CSS pixels), excludes scrollbar if present.
	ClientHeight float64 `json:"clientHeight"`   // Height (CSS pixels), excludes scrollbar if present.
	Scale        float64 `json:"scale"`          // Scale relative to the ideal viewport (size at width=device-width).
	Zoom         float64 `json:"zoom,omitempty"` // Page zoom factor (CSS to device independent pixels ratio).
}

// Viewport viewport for capturing screenshot.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-Viewport
type Viewport struct {
	X      float64 `json:"x"`      // X offset in device independent pixels (dip).
	Y      float64 `json:"y"`      // Y offset in device independent pixels (dip).
	Width  float64 `json:"width"`  // Rectangle width in device independent pixels (dip).
	Height float64 `json:"height"` // Rectangle height in device independent pixels (dip).
	Scale  float64 `json:"scale"`  // Page scale factor.
}

// FontFamilies generic font families collection.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FontFamilies
type FontFamilies struct {
	Standard  string `json:"standard,omitempty"`  // The standard font-family.
	Fixed     string `json:"fixed,omitempty"`     // The fixed font-family.
	Serif     string `json:"serif,omitempty"`     // The serif font-family.
	SansSerif string `json:"sansSerif,omitempty"` // The sansSerif font-family.
	Cursive   string `json:"cursive,omitempty"`   // The cursive font-family.
	Fantasy   string `json:"fantasy,omitempty"`   // The fantasy font-family.
	Math      string `json:"math,omitempty"`      // The math font-family.
}

// ScriptFontFamilies font families collection for a script.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScriptFontFamilies
type ScriptFontFamilies struct {
	Script       string        `json:"script"`       // Name of the script which these font families are defined for.
	FontFamilies *FontFamilies `json:"fontFamilies"` // Generic font families collection for the script.
}

// FontSizes default font sizes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FontSizes
type FontSizes struct {
	Standard int64 `json:"standard,omitempty"` // Default standard font size.
	Fixed    int64 `json:"fixed,omitempty"`    // Default fixed font size.
}

// ClientNavigationReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ClientNavigationReason
type ClientNavigationReason string

// String returns the ClientNavigationReason as string value.
func (t ClientNavigationReason) String() string {
	return string(t)
}

// ClientNavigationReason values.
const (
	ClientNavigationReasonFormSubmissionGet     ClientNavigationReason = "formSubmissionGet"
	ClientNavigationReasonFormSubmissionPost    ClientNavigationReason = "formSubmissionPost"
	ClientNavigationReasonHTTPHeaderRefresh     ClientNavigationReason = "httpHeaderRefresh"
	ClientNavigationReasonScriptInitiated       ClientNavigationReason = "scriptInitiated"
	ClientNavigationReasonMetaTagRefresh        ClientNavigationReason = "metaTagRefresh"
	ClientNavigationReasonPageBlockInterstitial ClientNavigationReason = "pageBlockInterstitial"
	ClientNavigationReasonReload                ClientNavigationReason = "reload"
	ClientNavigationReasonAnchorClick           ClientNavigationReason = "anchorClick"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ClientNavigationReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ClientNavigationReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ClientNavigationReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ClientNavigationReason(v) {
	case ClientNavigationReasonFormSubmissionGet:
		*t = ClientNavigationReasonFormSubmissionGet
	case ClientNavigationReasonFormSubmissionPost:
		*t = ClientNavigationReasonFormSubmissionPost
	case ClientNavigationReasonHTTPHeaderRefresh:
		*t = ClientNavigationReasonHTTPHeaderRefresh
	case ClientNavigationReasonScriptInitiated:
		*t = ClientNavigationReasonScriptInitiated
	case ClientNavigationReasonMetaTagRefresh:
		*t = ClientNavigationReasonMetaTagRefresh
	case ClientNavigationReasonPageBlockInterstitial:
		*t = ClientNavigationReasonPageBlockInterstitial
	case ClientNavigationReasonReload:
		*t = ClientNavigationReasonReload
	case ClientNavigationReasonAnchorClick:
		*t = ClientNavigationReasonAnchorClick

	default:
		in.AddError(fmt.Errorf("unknown ClientNavigationReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ClientNavigationReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ClientNavigationDisposition [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ClientNavigationDisposition
type ClientNavigationDisposition string

// String returns the ClientNavigationDisposition as string value.
func (t ClientNavigationDisposition) String() string {
	return string(t)
}

// ClientNavigationDisposition values.
const (
	ClientNavigationDispositionCurrentTab ClientNavigationDisposition = "currentTab"
	ClientNavigationDispositionNewTab     ClientNavigationDisposition = "newTab"
	ClientNavigationDispositionNewWindow  ClientNavigationDisposition = "newWindow"
	ClientNavigationDispositionDownload   ClientNavigationDisposition = "download"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ClientNavigationDisposition) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ClientNavigationDisposition) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ClientNavigationDisposition) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ClientNavigationDisposition(v) {
	case ClientNavigationDispositionCurrentTab:
		*t = ClientNavigationDispositionCurrentTab
	case ClientNavigationDispositionNewTab:
		*t = ClientNavigationDispositionNewTab
	case ClientNavigationDispositionNewWindow:
		*t = ClientNavigationDispositionNewWindow
	case ClientNavigationDispositionDownload:
		*t = ClientNavigationDispositionDownload

	default:
		in.AddError(fmt.Errorf("unknown ClientNavigationDisposition value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ClientNavigationDisposition) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// InstallabilityErrorArgument [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-InstallabilityErrorArgument
type InstallabilityErrorArgument struct {
	Name  string `json:"name"`  // Argument name (e.g. name:'minimum-icon-size-in-pixels').
	Value string `json:"value"` // Argument value (e.g. value:'64').
}

// InstallabilityError the installability error.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-InstallabilityError
type InstallabilityError struct {
	ErrorID        string                         `json:"errorId"`        // The error id (e.g. 'manifest-missing-suitable-icon').
	ErrorArguments []*InstallabilityErrorArgument `json:"errorArguments"` // The list of error arguments (e.g. {name:'minimum-icon-size-in-pixels', value:'64'}).
}

// ReferrerPolicy the referring-policy used for the navigation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ReferrerPolicy
type ReferrerPolicy string

// String returns the ReferrerPolicy as string value.
func (t ReferrerPolicy) String() string {
	return string(t)
}

// ReferrerPolicy values.
const (
	ReferrerPolicyNoReferrer                  ReferrerPolicy = "noReferrer"
	ReferrerPolicyNoReferrerWhenDowngrade     ReferrerPolicy = "noReferrerWhenDowngrade"
	ReferrerPolicyOrigin                      ReferrerPolicy = "origin"
	ReferrerPolicyOriginWhenCrossOrigin       ReferrerPolicy = "originWhenCrossOrigin"
	ReferrerPolicySameOrigin                  ReferrerPolicy = "sameOrigin"
	ReferrerPolicyStrictOrigin                ReferrerPolicy = "strictOrigin"
	ReferrerPolicyStrictOriginWhenCrossOrigin ReferrerPolicy = "strictOriginWhenCrossOrigin"
	ReferrerPolicyUnsafeURL                   ReferrerPolicy = "unsafeUrl"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ReferrerPolicy) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ReferrerPolicy) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ReferrerPolicy) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ReferrerPolicy(v) {
	case ReferrerPolicyNoReferrer:
		*t = ReferrerPolicyNoReferrer
	case ReferrerPolicyNoReferrerWhenDowngrade:
		*t = ReferrerPolicyNoReferrerWhenDowngrade
	case ReferrerPolicyOrigin:
		*t = ReferrerPolicyOrigin
	case ReferrerPolicyOriginWhenCrossOrigin:
		*t = ReferrerPolicyOriginWhenCrossOrigin
	case ReferrerPolicySameOrigin:
		*t = ReferrerPolicySameOrigin
	case ReferrerPolicyStrictOrigin:
		*t = ReferrerPolicyStrictOrigin
	case ReferrerPolicyStrictOriginWhenCrossOrigin:
		*t = ReferrerPolicyStrictOriginWhenCrossOrigin
	case ReferrerPolicyUnsafeURL:
		*t = ReferrerPolicyUnsafeURL

	default:
		in.AddError(fmt.Errorf("unknown ReferrerPolicy value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ReferrerPolicy) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CompilationCacheParams per-script compilation cache parameters for
// Page.produceCompilationCache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-CompilationCacheParams
type CompilationCacheParams struct {
	URL   string `json:"url"`             // The URL of the script to produce a compilation cache entry for.
	Eager bool   `json:"eager,omitempty"` // A hint to the backend whether eager compilation is recommended. (the actual compilation mode used is upon backend discretion).
}

// AutoResponseMode enum of possible auto-response for permissions / prompt
// dialogs.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AutoResponseMode
type AutoResponseMode string

// String returns the AutoResponseMode as string value.
func (t AutoResponseMode) String() string {
	return string(t)
}

// AutoResponseMode values.
const (
	AutoResponseModeNone       AutoResponseMode = "none"
	AutoResponseModeAutoAccept AutoResponseMode = "autoAccept"
	AutoResponseModeAutoReject AutoResponseMode = "autoReject"
	AutoResponseModeAutoOptOut AutoResponseMode = "autoOptOut"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AutoResponseMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AutoResponseMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AutoResponseMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AutoResponseMode(v) {
	case AutoResponseModeNone:
		*t = AutoResponseModeNone
	case AutoResponseModeAutoAccept:
		*t = AutoResponseModeAutoAccept
	case AutoResponseModeAutoReject:
		*t = AutoResponseModeAutoReject
	case AutoResponseModeAutoOptOut:
		*t = AutoResponseModeAutoOptOut

	default:
		in.AddError(fmt.Errorf("unknown AutoResponseMode value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AutoResponseMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// NavigationType the type of a frameNavigated event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-NavigationType
type NavigationType string

// String returns the NavigationType as string value.
func (t NavigationType) String() string {
	return string(t)
}

// NavigationType values.
const (
	NavigationTypeNavigation              NavigationType = "Navigation"
	NavigationTypeBackForwardCacheRestore NavigationType = "BackForwardCacheRestore"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t NavigationType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t NavigationType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *NavigationType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch NavigationType(v) {
	case NavigationTypeNavigation:
		*t = NavigationTypeNavigation
	case NavigationTypeBackForwardCacheRestore:
		*t = NavigationTypeBackForwardCacheRestore

	default:
		in.AddError(fmt.Errorf("unknown NavigationType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *NavigationType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// BackForwardCacheNotRestoredReason list of not restored reasons for
// back-forward cache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredReason
type BackForwardCacheNotRestoredReason string

// String returns the BackForwardCacheNotRestoredReason as string value.
func (t BackForwardCacheNotRestoredReason) String() string {
	return string(t)
}

// BackForwardCacheNotRestoredReason values.
const (
	BackForwardCacheNotRestoredReasonNotPrimaryMainFrame                                      BackForwardCacheNotRestoredReason = "NotPrimaryMainFrame"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabled                                 BackForwardCacheNotRestoredReason = "BackForwardCacheDisabled"
	BackForwardCacheNotRestoredReasonRelatedActiveContentsExist                               BackForwardCacheNotRestoredReason = "RelatedActiveContentsExist"
	BackForwardCacheNotRestoredReasonHTTPSTatusNotOK                                          BackForwardCacheNotRestoredReason = "HTTPStatusNotOK"
	BackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS                                     BackForwardCacheNotRestoredReason = "SchemeNotHTTPOrHTTPS"
	BackForwardCacheNotRestoredReasonLoading                                                  BackForwardCacheNotRestoredReason = "Loading"
	BackForwardCacheNotRestoredReasonWasGrantedMediaAccess                                    BackForwardCacheNotRestoredReason = "WasGrantedMediaAccess"
	BackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled                          BackForwardCacheNotRestoredReason = "DisableForRenderFrameHostCalled"
	BackForwardCacheNotRestoredReasonDomainNotAllowed                                         BackForwardCacheNotRestoredReason = "DomainNotAllowed"
	BackForwardCacheNotRestoredReasonHTTPMethodNotGET                                         BackForwardCacheNotRestoredReason = "HTTPMethodNotGET"
	BackForwardCacheNotRestoredReasonSubframeIsNavigating                                     BackForwardCacheNotRestoredReason = "SubframeIsNavigating"
	BackForwardCacheNotRestoredReasonTimeout                                                  BackForwardCacheNotRestoredReason = "Timeout"
	BackForwardCacheNotRestoredReasonCacheLimit                                               BackForwardCacheNotRestoredReason = "CacheLimit"
	BackForwardCacheNotRestoredReasonJavaScriptExecution                                      BackForwardCacheNotRestoredReason = "JavaScriptExecution"
	BackForwardCacheNotRestoredReasonRendererProcessKilled                                    BackForwardCacheNotRestoredReason = "RendererProcessKilled"
	BackForwardCacheNotRestoredReasonRendererProcessCrashed                                   BackForwardCacheNotRestoredReason = "RendererProcessCrashed"
	BackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed                              BackForwardCacheNotRestoredReason = "SchedulerTrackedFeatureUsed"
	BackForwardCacheNotRestoredReasonConflictingBrowsingInstance                              BackForwardCacheNotRestoredReason = "ConflictingBrowsingInstance"
	BackForwardCacheNotRestoredReasonCacheFlushed                                             BackForwardCacheNotRestoredReason = "CacheFlushed"
	BackForwardCacheNotRestoredReasonServiceWorkerVersionActivation                           BackForwardCacheNotRestoredReason = "ServiceWorkerVersionActivation"
	BackForwardCacheNotRestoredReasonSessionRestored                                          BackForwardCacheNotRestoredReason = "SessionRestored"
	BackForwardCacheNotRestoredReasonServiceWorkerPostMessage                                 BackForwardCacheNotRestoredReason = "ServiceWorkerPostMessage"
	BackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded      BackForwardCacheNotRestoredReason = "EnteredBackForwardCacheBeforeServiceWorkerHostAdded"
	BackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite                            BackForwardCacheNotRestoredReason = "RenderFrameHostReused_SameSite"
	BackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite                           BackForwardCacheNotRestoredReason = "RenderFrameHostReused_CrossSite"
	BackForwardCacheNotRestoredReasonServiceWorkerClaim                                       BackForwardCacheNotRestoredReason = "ServiceWorkerClaim"
	BackForwardCacheNotRestoredReasonIgnoreEventAndEvict                                      BackForwardCacheNotRestoredReason = "IgnoreEventAndEvict"
	BackForwardCacheNotRestoredReasonHaveInnerContents                                        BackForwardCacheNotRestoredReason = "HaveInnerContents"
	BackForwardCacheNotRestoredReasonTimeoutPuttingInCache                                    BackForwardCacheNotRestoredReason = "TimeoutPuttingInCache"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory                      BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledByLowMemory"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine                    BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledByCommandLine"
	BackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer             BackForwardCacheNotRestoredReason = "NetworkRequestDatapipeDrainedAsBytesConsumer"
	BackForwardCacheNotRestoredReasonNetworkRequestRedirected                                 BackForwardCacheNotRestoredReason = "NetworkRequestRedirected"
	BackForwardCacheNotRestoredReasonNetworkRequestTimeout                                    BackForwardCacheNotRestoredReason = "NetworkRequestTimeout"
	BackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit                                BackForwardCacheNotRestoredReason = "NetworkExceedsBufferLimit"
	BackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring                        BackForwardCacheNotRestoredReason = "NavigationCancelledWhileRestoring"
	BackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry                             BackForwardCacheNotRestoredReason = "NotMostRecentNavigationEntry"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender                     BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledForPrerender"
	BackForwardCacheNotRestoredReasonUserAgentOverrideDiffers                                 BackForwardCacheNotRestoredReason = "UserAgentOverrideDiffers"
	BackForwardCacheNotRestoredReasonForegroundCacheLimit                                     BackForwardCacheNotRestoredReason = "ForegroundCacheLimit"
	BackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped                               BackForwardCacheNotRestoredReason = "BrowsingInstanceNotSwapped"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate                      BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledForDelegate"
	BackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame                           BackForwardCacheNotRestoredReason = "UnloadHandlerExistsInMainFrame"
	BackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame                            BackForwardCacheNotRestoredReason = "UnloadHandlerExistsInSubFrame"
	BackForwardCacheNotRestoredReasonServiceWorkerUnregistration                              BackForwardCacheNotRestoredReason = "ServiceWorkerUnregistration"
	BackForwardCacheNotRestoredReasonCacheControlNoStore                                      BackForwardCacheNotRestoredReason = "CacheControlNoStore"
	BackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified                        BackForwardCacheNotRestoredReason = "CacheControlNoStoreCookieModified"
	BackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified                BackForwardCacheNotRestoredReason = "CacheControlNoStoreHTTPOnlyCookieModified"
	BackForwardCacheNotRestoredReasonNoResponseHead                                           BackForwardCacheNotRestoredReason = "NoResponseHead"
	BackForwardCacheNotRestoredReasonUnknown                                                  BackForwardCacheNotRestoredReason = "Unknown"
	BackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857             BackForwardCacheNotRestoredReason = "ActivationNavigationsDisallowedForBug1234857"
	BackForwardCacheNotRestoredReasonErrorDocument                                            BackForwardCacheNotRestoredReason = "ErrorDocument"
	BackForwardCacheNotRestoredReasonFencedFramesEmbedder                                     BackForwardCacheNotRestoredReason = "FencedFramesEmbedder"
	BackForwardCacheNotRestoredReasonWebSocket                                                BackForwardCacheNotRestoredReason = "WebSocket"
	BackForwardCacheNotRestoredReasonWebTransport                                             BackForwardCacheNotRestoredReason = "WebTransport"
	BackForwardCacheNotRestoredReasonWebRTC                                                   BackForwardCacheNotRestoredReason = "WebRTC"
	BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore                       BackForwardCacheNotRestoredReason = "MainResourceHasCacheControlNoStore"
	BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache                       BackForwardCacheNotRestoredReason = "MainResourceHasCacheControlNoCache"
	BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore                        BackForwardCacheNotRestoredReason = "SubresourceHasCacheControlNoStore"
	BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache                        BackForwardCacheNotRestoredReason = "SubresourceHasCacheControlNoCache"
	BackForwardCacheNotRestoredReasonContainsPlugins                                          BackForwardCacheNotRestoredReason = "ContainsPlugins"
	BackForwardCacheNotRestoredReasonDocumentLoaded                                           BackForwardCacheNotRestoredReason = "DocumentLoaded"
	BackForwardCacheNotRestoredReasonDedicatedWorkerOrWorklet                                 BackForwardCacheNotRestoredReason = "DedicatedWorkerOrWorklet"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers                          BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestOthers"
	BackForwardCacheNotRestoredReasonOutstandingIndexedDBTransaction                          BackForwardCacheNotRestoredReason = "OutstandingIndexedDBTransaction"
	BackForwardCacheNotRestoredReasonRequestedMIDIPermission                                  BackForwardCacheNotRestoredReason = "RequestedMIDIPermission"
	BackForwardCacheNotRestoredReasonRequestedAudioCapturePermission                          BackForwardCacheNotRestoredReason = "RequestedAudioCapturePermission"
	BackForwardCacheNotRestoredReasonRequestedVideoCapturePermission                          BackForwardCacheNotRestoredReason = "RequestedVideoCapturePermission"
	BackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors                  BackForwardCacheNotRestoredReason = "RequestedBackForwardCacheBlockedSensors"
	BackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission                        BackForwardCacheNotRestoredReason = "RequestedBackgroundWorkPermission"
	BackForwardCacheNotRestoredReasonBroadcastChannel                                         BackForwardCacheNotRestoredReason = "BroadcastChannel"
	BackForwardCacheNotRestoredReasonIndexedDBConnection                                      BackForwardCacheNotRestoredReason = "IndexedDBConnection"
	BackForwardCacheNotRestoredReasonWebXR                                                    BackForwardCacheNotRestoredReason = "WebXR"
	BackForwardCacheNotRestoredReasonSharedWorker                                             BackForwardCacheNotRestoredReason = "SharedWorker"
	BackForwardCacheNotRestoredReasonWebLocks                                                 BackForwardCacheNotRestoredReason = "WebLocks"
	BackForwardCacheNotRestoredReasonWebHID                                                   BackForwardCacheNotRestoredReason = "WebHID"
	BackForwardCacheNotRestoredReasonWebShare                                                 BackForwardCacheNotRestoredReason = "WebShare"
	BackForwardCacheNotRestoredReasonRequestedStorageAccessGrant                              BackForwardCacheNotRestoredReason = "RequestedStorageAccessGrant"
	BackForwardCacheNotRestoredReasonWebNfc                                                   BackForwardCacheNotRestoredReason = "WebNfc"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch                           BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestFetch"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR                             BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestXHR"
	BackForwardCacheNotRestoredReasonAppBanner                                                BackForwardCacheNotRestoredReason = "AppBanner"
	BackForwardCacheNotRestoredReasonPrinting                                                 BackForwardCacheNotRestoredReason = "Printing"
	BackForwardCacheNotRestoredReasonWebDatabase                                              BackForwardCacheNotRestoredReason = "WebDatabase"
	BackForwardCacheNotRestoredReasonPictureInPicture                                         BackForwardCacheNotRestoredReason = "PictureInPicture"
	BackForwardCacheNotRestoredReasonPortal                                                   BackForwardCacheNotRestoredReason = "Portal"
	BackForwardCacheNotRestoredReasonSpeechRecognizer                                         BackForwardCacheNotRestoredReason = "SpeechRecognizer"
	BackForwardCacheNotRestoredReasonIdleManager                                              BackForwardCacheNotRestoredReason = "IdleManager"
	BackForwardCacheNotRestoredReasonPaymentManager                                           BackForwardCacheNotRestoredReason = "PaymentManager"
	BackForwardCacheNotRestoredReasonSpeechSynthesis                                          BackForwardCacheNotRestoredReason = "SpeechSynthesis"
	BackForwardCacheNotRestoredReasonKeyboardLock                                             BackForwardCacheNotRestoredReason = "KeyboardLock"
	BackForwardCacheNotRestoredReasonWebOTPService                                            BackForwardCacheNotRestoredReason = "WebOTPService"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket                    BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestDirectSocket"
	BackForwardCacheNotRestoredReasonInjectedJavascript                                       BackForwardCacheNotRestoredReason = "InjectedJavascript"
	BackForwardCacheNotRestoredReasonInjectedStyleSheet                                       BackForwardCacheNotRestoredReason = "InjectedStyleSheet"
	BackForwardCacheNotRestoredReasonKeepaliveRequest                                         BackForwardCacheNotRestoredReason = "KeepaliveRequest"
	BackForwardCacheNotRestoredReasonIndexedDBEvent                                           BackForwardCacheNotRestoredReason = "IndexedDBEvent"
	BackForwardCacheNotRestoredReasonDummy                                                    BackForwardCacheNotRestoredReason = "Dummy"
	BackForwardCacheNotRestoredReasonAuthorizationHeader                                      BackForwardCacheNotRestoredReason = "AuthorizationHeader"
	BackForwardCacheNotRestoredReasonContentSecurityHandler                                   BackForwardCacheNotRestoredReason = "ContentSecurityHandler"
	BackForwardCacheNotRestoredReasonContentWebAuthenticationAPI                              BackForwardCacheNotRestoredReason = "ContentWebAuthenticationAPI"
	BackForwardCacheNotRestoredReasonContentFileChooser                                       BackForwardCacheNotRestoredReason = "ContentFileChooser"
	BackForwardCacheNotRestoredReasonContentSerial                                            BackForwardCacheNotRestoredReason = "ContentSerial"
	BackForwardCacheNotRestoredReasonContentFileSystemAccess                                  BackForwardCacheNotRestoredReason = "ContentFileSystemAccess"
	BackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost                        BackForwardCacheNotRestoredReason = "ContentMediaDevicesDispatcherHost"
	BackForwardCacheNotRestoredReasonContentWebBluetooth                                      BackForwardCacheNotRestoredReason = "ContentWebBluetooth"
	BackForwardCacheNotRestoredReasonContentWebUSB                                            BackForwardCacheNotRestoredReason = "ContentWebUSB"
	BackForwardCacheNotRestoredReasonContentMediaSessionService                               BackForwardCacheNotRestoredReason = "ContentMediaSessionService"
	BackForwardCacheNotRestoredReasonContentScreenReader                                      BackForwardCacheNotRestoredReason = "ContentScreenReader"
	BackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper                            BackForwardCacheNotRestoredReason = "EmbedderPopupBlockerTabHelper"
	BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker                BackForwardCacheNotRestoredReason = "EmbedderSafeBrowsingTriggeredPopupBlocker"
	BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails                        BackForwardCacheNotRestoredReason = "EmbedderSafeBrowsingThreatDetails"
	BackForwardCacheNotRestoredReasonEmbedderAppBannerManager                                 BackForwardCacheNotRestoredReason = "EmbedderAppBannerManager"
	BackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource                         BackForwardCacheNotRestoredReason = "EmbedderDomDistillerViewerSource"
	BackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate          BackForwardCacheNotRestoredReason = "EmbedderDomDistillerSelfDeletingRequestDelegate"
	BackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper                         BackForwardCacheNotRestoredReason = "EmbedderOomInterventionTabHelper"
	BackForwardCacheNotRestoredReasonEmbedderOfflinePage                                      BackForwardCacheNotRestoredReason = "EmbedderOfflinePage"
	BackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager BackForwardCacheNotRestoredReason = "EmbedderChromePasswordManagerClientBindCredentialManager"
	BackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager                         BackForwardCacheNotRestoredReason = "EmbedderPermissionRequestManager"
	BackForwardCacheNotRestoredReasonEmbedderModalDialog                                      BackForwardCacheNotRestoredReason = "EmbedderModalDialog"
	BackForwardCacheNotRestoredReasonEmbedderExtensions                                       BackForwardCacheNotRestoredReason = "EmbedderExtensions"
	BackForwardCacheNotRestoredReasonEmbedderExtensionMessaging                               BackForwardCacheNotRestoredReason = "EmbedderExtensionMessaging"
	BackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort                    BackForwardCacheNotRestoredReason = "EmbedderExtensionMessagingForOpenPort"
	BackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame                BackForwardCacheNotRestoredReason = "EmbedderExtensionSentMessageToCachedFrame"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t BackForwardCacheNotRestoredReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t BackForwardCacheNotRestoredReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *BackForwardCacheNotRestoredReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch BackForwardCacheNotRestoredReason(v) {
	case BackForwardCacheNotRestoredReasonNotPrimaryMainFrame:
		*t = BackForwardCacheNotRestoredReasonNotPrimaryMainFrame
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabled:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabled
	case BackForwardCacheNotRestoredReasonRelatedActiveContentsExist:
		*t = BackForwardCacheNotRestoredReasonRelatedActiveContentsExist
	case BackForwardCacheNotRestoredReasonHTTPSTatusNotOK:
		*t = BackForwardCacheNotRestoredReasonHTTPSTatusNotOK
	case BackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS:
		*t = BackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS
	case BackForwardCacheNotRestoredReasonLoading:
		*t = BackForwardCacheNotRestoredReasonLoading
	case BackForwardCacheNotRestoredReasonWasGrantedMediaAccess:
		*t = BackForwardCacheNotRestoredReasonWasGrantedMediaAccess
	case BackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled:
		*t = BackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled
	case BackForwardCacheNotRestoredReasonDomainNotAllowed:
		*t = BackForwardCacheNotRestoredReasonDomainNotAllowed
	case BackForwardCacheNotRestoredReasonHTTPMethodNotGET:
		*t = BackForwardCacheNotRestoredReasonHTTPMethodNotGET
	case BackForwardCacheNotRestoredReasonSubframeIsNavigating:
		*t = BackForwardCacheNotRestoredReasonSubframeIsNavigating
	case BackForwardCacheNotRestoredReasonTimeout:
		*t = BackForwardCacheNotRestoredReasonTimeout
	case BackForwardCacheNotRestoredReasonCacheLimit:
		*t = BackForwardCacheNotRestoredReasonCacheLimit
	case BackForwardCacheNotRestoredReasonJavaScriptExecution:
		*t = BackForwardCacheNotRestoredReasonJavaScriptExecution
	case BackForwardCacheNotRestoredReasonRendererProcessKilled:
		*t = BackForwardCacheNotRestoredReasonRendererProcessKilled
	case BackForwardCacheNotRestoredReasonRendererProcessCrashed:
		*t = BackForwardCacheNotRestoredReasonRendererProcessCrashed
	case BackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed:
		*t = BackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed
	case BackForwardCacheNotRestoredReasonConflictingBrowsingInstance:
		*t = BackForwardCacheNotRestoredReasonConflictingBrowsingInstance
	case BackForwardCacheNotRestoredReasonCacheFlushed:
		*t = BackForwardCacheNotRestoredReasonCacheFlushed
	case BackForwardCacheNotRestoredReasonServiceWorkerVersionActivation:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerVersionActivation
	case BackForwardCacheNotRestoredReasonSessionRestored:
		*t = BackForwardCacheNotRestoredReasonSessionRestored
	case BackForwardCacheNotRestoredReasonServiceWorkerPostMessage:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerPostMessage
	case BackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded:
		*t = BackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded
	case BackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite:
		*t = BackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite
	case BackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite:
		*t = BackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite
	case BackForwardCacheNotRestoredReasonServiceWorkerClaim:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerClaim
	case BackForwardCacheNotRestoredReasonIgnoreEventAndEvict:
		*t = BackForwardCacheNotRestoredReasonIgnoreEventAndEvict
	case BackForwardCacheNotRestoredReasonHaveInnerContents:
		*t = BackForwardCacheNotRestoredReasonHaveInnerContents
	case BackForwardCacheNotRestoredReasonTimeoutPuttingInCache:
		*t = BackForwardCacheNotRestoredReasonTimeoutPuttingInCache
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine
	case BackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer:
		*t = BackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer
	case BackForwardCacheNotRestoredReasonNetworkRequestRedirected:
		*t = BackForwardCacheNotRestoredReasonNetworkRequestRedirected
	case BackForwardCacheNotRestoredReasonNetworkRequestTimeout:
		*t = BackForwardCacheNotRestoredReasonNetworkRequestTimeout
	case BackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit:
		*t = BackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit
	case BackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring:
		*t = BackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring
	case BackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry:
		*t = BackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender
	case BackForwardCacheNotRestoredReasonUserAgentOverrideDiffers:
		*t = BackForwardCacheNotRestoredReasonUserAgentOverrideDiffers
	case BackForwardCacheNotRestoredReasonForegroundCacheLimit:
		*t = BackForwardCacheNotRestoredReasonForegroundCacheLimit
	case BackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped:
		*t = BackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate
	case BackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame:
		*t = BackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame
	case BackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame:
		*t = BackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame
	case BackForwardCacheNotRestoredReasonServiceWorkerUnregistration:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerUnregistration
	case BackForwardCacheNotRestoredReasonCacheControlNoStore:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStore
	case BackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified
	case BackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified
	case BackForwardCacheNotRestoredReasonNoResponseHead:
		*t = BackForwardCacheNotRestoredReasonNoResponseHead
	case BackForwardCacheNotRestoredReasonUnknown:
		*t = BackForwardCacheNotRestoredReasonUnknown
	case BackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857:
		*t = BackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857
	case BackForwardCacheNotRestoredReasonErrorDocument:
		*t = BackForwardCacheNotRestoredReasonErrorDocument
	case BackForwardCacheNotRestoredReasonFencedFramesEmbedder:
		*t = BackForwardCacheNotRestoredReasonFencedFramesEmbedder
	case BackForwardCacheNotRestoredReasonWebSocket:
		*t = BackForwardCacheNotRestoredReasonWebSocket
	case BackForwardCacheNotRestoredReasonWebTransport:
		*t = BackForwardCacheNotRestoredReasonWebTransport
	case BackForwardCacheNotRestoredReasonWebRTC:
		*t = BackForwardCacheNotRestoredReasonWebRTC
	case BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore:
		*t = BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore
	case BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache:
		*t = BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache
	case BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore:
		*t = BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore
	case BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache:
		*t = BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache
	case BackForwardCacheNotRestoredReasonContainsPlugins:
		*t = BackForwardCacheNotRestoredReasonContainsPlugins
	case BackForwardCacheNotRestoredReasonDocumentLoaded:
		*t = BackForwardCacheNotRestoredReasonDocumentLoaded
	case BackForwardCacheNotRestoredReasonDedicatedWorkerOrWorklet:
		*t = BackForwardCacheNotRestoredReasonDedicatedWorkerOrWorklet
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers
	case BackForwardCacheNotRestoredReasonOutstandingIndexedDBTransaction:
		*t = BackForwardCacheNotRestoredReasonOutstandingIndexedDBTransaction
	case BackForwardCacheNotRestoredReasonRequestedMIDIPermission:
		*t = BackForwardCacheNotRestoredReasonRequestedMIDIPermission
	case BackForwardCacheNotRestoredReasonRequestedAudioCapturePermission:
		*t = BackForwardCacheNotRestoredReasonRequestedAudioCapturePermission
	case BackForwardCacheNotRestoredReasonRequestedVideoCapturePermission:
		*t = BackForwardCacheNotRestoredReasonRequestedVideoCapturePermission
	case BackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors:
		*t = BackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors
	case BackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission:
		*t = BackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission
	case BackForwardCacheNotRestoredReasonBroadcastChannel:
		*t = BackForwardCacheNotRestoredReasonBroadcastChannel
	case BackForwardCacheNotRestoredReasonIndexedDBConnection:
		*t = BackForwardCacheNotRestoredReasonIndexedDBConnection
	case BackForwardCacheNotRestoredReasonWebXR:
		*t = BackForwardCacheNotRestoredReasonWebXR
	case BackForwardCacheNotRestoredReasonSharedWorker:
		*t = BackForwardCacheNotRestoredReasonSharedWorker
	case BackForwardCacheNotRestoredReasonWebLocks:
		*t = BackForwardCacheNotRestoredReasonWebLocks
	case BackForwardCacheNotRestoredReasonWebHID:
		*t = BackForwardCacheNotRestoredReasonWebHID
	case BackForwardCacheNotRestoredReasonWebShare:
		*t = BackForwardCacheNotRestoredReasonWebShare
	case BackForwardCacheNotRestoredReasonRequestedStorageAccessGrant:
		*t = BackForwardCacheNotRestoredReasonRequestedStorageAccessGrant
	case BackForwardCacheNotRestoredReasonWebNfc:
		*t = BackForwardCacheNotRestoredReasonWebNfc
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR
	case BackForwardCacheNotRestoredReasonAppBanner:
		*t = BackForwardCacheNotRestoredReasonAppBanner
	case BackForwardCacheNotRestoredReasonPrinting:
		*t = BackForwardCacheNotRestoredReasonPrinting
	case BackForwardCacheNotRestoredReasonWebDatabase:
		*t = BackForwardCacheNotRestoredReasonWebDatabase
	case BackForwardCacheNotRestoredReasonPictureInPicture:
		*t = BackForwardCacheNotRestoredReasonPictureInPicture
	case BackForwardCacheNotRestoredReasonPortal:
		*t = BackForwardCacheNotRestoredReasonPortal
	case BackForwardCacheNotRestoredReasonSpeechRecognizer:
		*t = BackForwardCacheNotRestoredReasonSpeechRecognizer
	case BackForwardCacheNotRestoredReasonIdleManager:
		*t = BackForwardCacheNotRestoredReasonIdleManager
	case BackForwardCacheNotRestoredReasonPaymentManager:
		*t = BackForwardCacheNotRestoredReasonPaymentManager
	case BackForwardCacheNotRestoredReasonSpeechSynthesis:
		*t = BackForwardCacheNotRestoredReasonSpeechSynthesis
	case BackForwardCacheNotRestoredReasonKeyboardLock:
		*t = BackForwardCacheNotRestoredReasonKeyboardLock
	case BackForwardCacheNotRestoredReasonWebOTPService:
		*t = BackForwardCacheNotRestoredReasonWebOTPService
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket
	case BackForwardCacheNotRestoredReasonInjectedJavascript:
		*t = BackForwardCacheNotRestoredReasonInjectedJavascript
	case BackForwardCacheNotRestoredReasonInjectedStyleSheet:
		*t = BackForwardCacheNotRestoredReasonInjectedStyleSheet
	case BackForwardCacheNotRestoredReasonKeepaliveRequest:
		*t = BackForwardCacheNotRestoredReasonKeepaliveRequest
	case BackForwardCacheNotRestoredReasonIndexedDBEvent:
		*t = BackForwardCacheNotRestoredReasonIndexedDBEvent
	case BackForwardCacheNotRestoredReasonDummy:
		*t = BackForwardCacheNotRestoredReasonDummy
	case BackForwardCacheNotRestoredReasonAuthorizationHeader:
		*t = BackForwardCacheNotRestoredReasonAuthorizationHeader
	case BackForwardCacheNotRestoredReasonContentSecurityHandler:
		*t = BackForwardCacheNotRestoredReasonContentSecurityHandler
	case BackForwardCacheNotRestoredReasonContentWebAuthenticationAPI:
		*t = BackForwardCacheNotRestoredReasonContentWebAuthenticationAPI
	case BackForwardCacheNotRestoredReasonContentFileChooser:
		*t = BackForwardCacheNotRestoredReasonContentFileChooser
	case BackForwardCacheNotRestoredReasonContentSerial:
		*t = BackForwardCacheNotRestoredReasonContentSerial
	case BackForwardCacheNotRestoredReasonContentFileSystemAccess:
		*t = BackForwardCacheNotRestoredReasonContentFileSystemAccess
	case BackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost:
		*t = BackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost
	case BackForwardCacheNotRestoredReasonContentWebBluetooth:
		*t = BackForwardCacheNotRestoredReasonContentWebBluetooth
	case BackForwardCacheNotRestoredReasonContentWebUSB:
		*t = BackForwardCacheNotRestoredReasonContentWebUSB
	case BackForwardCacheNotRestoredReasonContentMediaSessionService:
		*t = BackForwardCacheNotRestoredReasonContentMediaSessionService
	case BackForwardCacheNotRestoredReasonContentScreenReader:
		*t = BackForwardCacheNotRestoredReasonContentScreenReader
	case BackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper:
		*t = BackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper
	case BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker:
		*t = BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker
	case BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails:
		*t = BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails
	case BackForwardCacheNotRestoredReasonEmbedderAppBannerManager:
		*t = BackForwardCacheNotRestoredReasonEmbedderAppBannerManager
	case BackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource:
		*t = BackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource
	case BackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate:
		*t = BackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate
	case BackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper:
		*t = BackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper
	case BackForwardCacheNotRestoredReasonEmbedderOfflinePage:
		*t = BackForwardCacheNotRestoredReasonEmbedderOfflinePage
	case BackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager:
		*t = BackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager
	case BackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager:
		*t = BackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager
	case BackForwardCacheNotRestoredReasonEmbedderModalDialog:
		*t = BackForwardCacheNotRestoredReasonEmbedderModalDialog
	case BackForwardCacheNotRestoredReasonEmbedderExtensions:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensions
	case BackForwardCacheNotRestoredReasonEmbedderExtensionMessaging:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensionMessaging
	case BackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort
	case BackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame

	default:
		in.AddError(fmt.Errorf("unknown BackForwardCacheNotRestoredReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *BackForwardCacheNotRestoredReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// BackForwardCacheNotRestoredReasonType types of not restored reasons for
// back-forward cache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredReasonType
type BackForwardCacheNotRestoredReasonType string

// String returns the BackForwardCacheNotRestoredReasonType as string value.
func (t BackForwardCacheNotRestoredReasonType) String() string {
	return string(t)
}

// BackForwardCacheNotRestoredReasonType values.
const (
	BackForwardCacheNotRestoredReasonTypeSupportPending    BackForwardCacheNotRestoredReasonType = "SupportPending"
	BackForwardCacheNotRestoredReasonTypePageSupportNeeded BackForwardCacheNotRestoredReasonType = "PageSupportNeeded"
	BackForwardCacheNotRestoredReasonTypeCircumstantial    BackForwardCacheNotRestoredReasonType = "Circumstantial"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t BackForwardCacheNotRestoredReasonType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t BackForwardCacheNotRestoredReasonType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *BackForwardCacheNotRestoredReasonType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch BackForwardCacheNotRestoredReasonType(v) {
	case BackForwardCacheNotRestoredReasonTypeSupportPending:
		*t = BackForwardCacheNotRestoredReasonTypeSupportPending
	case BackForwardCacheNotRestoredReasonTypePageSupportNeeded:
		*t = BackForwardCacheNotRestoredReasonTypePageSupportNeeded
	case BackForwardCacheNotRestoredReasonTypeCircumstantial:
		*t = BackForwardCacheNotRestoredReasonTypeCircumstantial

	default:
		in.AddError(fmt.Errorf("unknown BackForwardCacheNotRestoredReasonType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *BackForwardCacheNotRestoredReasonType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// BackForwardCacheNotRestoredExplanation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredExplanation
type BackForwardCacheNotRestoredExplanation struct {
	Type    BackForwardCacheNotRestoredReasonType `json:"type"`              // Type of the reason
	Reason  BackForwardCacheNotRestoredReason     `json:"reason"`            // Not restored reason
	Context string                                `json:"context,omitempty"` // Context associated with the reason. The meaning of this context is dependent on the reason: - EmbedderExtensionSentMessageToCachedFrame: the extension ID.
}

// BackForwardCacheNotRestoredExplanationTree [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredExplanationTree
type BackForwardCacheNotRestoredExplanationTree struct {
	URL          string                                        `json:"url"`          // URL of each frame
	Explanations []*BackForwardCacheNotRestoredExplanation     `json:"explanations"` // Not restored reasons of each frame
	Children     []*BackForwardCacheNotRestoredExplanationTree `json:"children"`     // Array of children frame
}

// PrerenderFinalStatus list of FinalStatus reasons for Prerender2.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PrerenderFinalStatus
type PrerenderFinalStatus string

// String returns the PrerenderFinalStatus as string value.
func (t PrerenderFinalStatus) String() string {
	return string(t)
}

// PrerenderFinalStatus values.
const (
	PrerenderFinalStatusActivated                                  PrerenderFinalStatus = "Activated"
	PrerenderFinalStatusDestroyed                                  PrerenderFinalStatus = "Destroyed"
	PrerenderFinalStatusLowEndDevice                               PrerenderFinalStatus = "LowEndDevice"
	PrerenderFinalStatusInvalidSchemeRedirect                      PrerenderFinalStatus = "InvalidSchemeRedirect"
	PrerenderFinalStatusInvalidSchemeNavigation                    PrerenderFinalStatus = "InvalidSchemeNavigation"
	PrerenderFinalStatusInProgressNavigation                       PrerenderFinalStatus = "InProgressNavigation"
	PrerenderFinalStatusNavigationRequestBlockedByCsp              PrerenderFinalStatus = "NavigationRequestBlockedByCsp"
	PrerenderFinalStatusMainFrameNavigation                        PrerenderFinalStatus = "MainFrameNavigation"
	PrerenderFinalStatusMojoBinderPolicy                           PrerenderFinalStatus = "MojoBinderPolicy"
	PrerenderFinalStatusRendererProcessCrashed                     PrerenderFinalStatus = "RendererProcessCrashed"
	PrerenderFinalStatusRendererProcessKilled                      PrerenderFinalStatus = "RendererProcessKilled"
	PrerenderFinalStatusDownload                                   PrerenderFinalStatus = "Download"
	PrerenderFinalStatusTriggerDestroyed                           PrerenderFinalStatus = "TriggerDestroyed"
	PrerenderFinalStatusNavigationNotCommitted                     PrerenderFinalStatus = "NavigationNotCommitted"
	PrerenderFinalStatusNavigationBadHTTPStatus                    PrerenderFinalStatus = "NavigationBadHttpStatus"
	PrerenderFinalStatusClientCertRequested                        PrerenderFinalStatus = "ClientCertRequested"
	PrerenderFinalStatusNavigationRequestNetworkError              PrerenderFinalStatus = "NavigationRequestNetworkError"
	PrerenderFinalStatusMaxNumOfRunningPrerendersExceeded          PrerenderFinalStatus = "MaxNumOfRunningPrerendersExceeded"
	PrerenderFinalStatusCancelAllHostsForTesting                   PrerenderFinalStatus = "CancelAllHostsForTesting"
	PrerenderFinalStatusDidFailLoad                                PrerenderFinalStatus = "DidFailLoad"
	PrerenderFinalStatusStop                                       PrerenderFinalStatus = "Stop"
	PrerenderFinalStatusSslCertificateError                        PrerenderFinalStatus = "SslCertificateError"
	PrerenderFinalStatusLoginAuthRequested                         PrerenderFinalStatus = "LoginAuthRequested"
	PrerenderFinalStatusUaChangeRequiresReload                     PrerenderFinalStatus = "UaChangeRequiresReload"
	PrerenderFinalStatusBlockedByClient                            PrerenderFinalStatus = "BlockedByClient"
	PrerenderFinalStatusAudioOutputDeviceRequested                 PrerenderFinalStatus = "AudioOutputDeviceRequested"
	PrerenderFinalStatusMixedContent                               PrerenderFinalStatus = "MixedContent"
	PrerenderFinalStatusTriggerBackgrounded                        PrerenderFinalStatus = "TriggerBackgrounded"
	PrerenderFinalStatusEmbedderTriggeredAndCrossOriginRedirected  PrerenderFinalStatus = "EmbedderTriggeredAndCrossOriginRedirected"
	PrerenderFinalStatusMemoryLimitExceeded                        PrerenderFinalStatus = "MemoryLimitExceeded"
	PrerenderFinalStatusFailToGetMemoryUsage                       PrerenderFinalStatus = "FailToGetMemoryUsage"
	PrerenderFinalStatusDataSaverEnabled                           PrerenderFinalStatus = "DataSaverEnabled"
	PrerenderFinalStatusHasEffectiveURL                            PrerenderFinalStatus = "HasEffectiveUrl"
	PrerenderFinalStatusActivatedBeforeStarted                     PrerenderFinalStatus = "ActivatedBeforeStarted"
	PrerenderFinalStatusInactivePageRestriction                    PrerenderFinalStatus = "InactivePageRestriction"
	PrerenderFinalStatusStartFailed                                PrerenderFinalStatus = "StartFailed"
	PrerenderFinalStatusTimeoutBackgrounded                        PrerenderFinalStatus = "TimeoutBackgrounded"
	PrerenderFinalStatusCrossSiteRedirect                          PrerenderFinalStatus = "CrossSiteRedirect"
	PrerenderFinalStatusCrossSiteNavigation                        PrerenderFinalStatus = "CrossSiteNavigation"
	PrerenderFinalStatusSameSiteCrossOriginRedirect                PrerenderFinalStatus = "SameSiteCrossOriginRedirect"
	PrerenderFinalStatusSameSiteCrossOriginNavigation              PrerenderFinalStatus = "SameSiteCrossOriginNavigation"
	PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptIn        PrerenderFinalStatus = "SameSiteCrossOriginRedirectNotOptIn"
	PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptIn      PrerenderFinalStatus = "SameSiteCrossOriginNavigationNotOptIn"
	PrerenderFinalStatusActivationNavigationParameterMismatch      PrerenderFinalStatus = "ActivationNavigationParameterMismatch"
	PrerenderFinalStatusActivatedInBackground                      PrerenderFinalStatus = "ActivatedInBackground"
	PrerenderFinalStatusEmbedderHostDisallowed                     PrerenderFinalStatus = "EmbedderHostDisallowed"
	PrerenderFinalStatusActivationNavigationDestroyedBeforeSuccess PrerenderFinalStatus = "ActivationNavigationDestroyedBeforeSuccess"
	PrerenderFinalStatusTabClosedByUserGesture                     PrerenderFinalStatus = "TabClosedByUserGesture"
	PrerenderFinalStatusTabClosedWithoutUserGesture                PrerenderFinalStatus = "TabClosedWithoutUserGesture"
	PrerenderFinalStatusPrimaryMainFrameRendererProcessCrashed     PrerenderFinalStatus = "PrimaryMainFrameRendererProcessCrashed"
	PrerenderFinalStatusPrimaryMainFrameRendererProcessKilled      PrerenderFinalStatus = "PrimaryMainFrameRendererProcessKilled"
	PrerenderFinalStatusActivationFramePolicyNotCompatible         PrerenderFinalStatus = "ActivationFramePolicyNotCompatible"
	PrerenderFinalStatusPreloadingDisabled                         PrerenderFinalStatus = "PreloadingDisabled"
	PrerenderFinalStatusBatterySaverEnabled                        PrerenderFinalStatus = "BatterySaverEnabled"
	PrerenderFinalStatusActivatedDuringMainFrameNavigation         PrerenderFinalStatus = "ActivatedDuringMainFrameNavigation"
	PrerenderFinalStatusPreloadingUnsupportedByWebContents         PrerenderFinalStatus = "PreloadingUnsupportedByWebContents"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PrerenderFinalStatus) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PrerenderFinalStatus) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PrerenderFinalStatus) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PrerenderFinalStatus(v) {
	case PrerenderFinalStatusActivated:
		*t = PrerenderFinalStatusActivated
	case PrerenderFinalStatusDestroyed:
		*t = PrerenderFinalStatusDestroyed
	case PrerenderFinalStatusLowEndDevice:
		*t = PrerenderFinalStatusLowEndDevice
	case PrerenderFinalStatusInvalidSchemeRedirect:
		*t = PrerenderFinalStatusInvalidSchemeRedirect
	case PrerenderFinalStatusInvalidSchemeNavigation:
		*t = PrerenderFinalStatusInvalidSchemeNavigation
	case PrerenderFinalStatusInProgressNavigation:
		*t = PrerenderFinalStatusInProgressNavigation
	case PrerenderFinalStatusNavigationRequestBlockedByCsp:
		*t = PrerenderFinalStatusNavigationRequestBlockedByCsp
	case PrerenderFinalStatusMainFrameNavigation:
		*t = PrerenderFinalStatusMainFrameNavigation
	case PrerenderFinalStatusMojoBinderPolicy:
		*t = PrerenderFinalStatusMojoBinderPolicy
	case PrerenderFinalStatusRendererProcessCrashed:
		*t = PrerenderFinalStatusRendererProcessCrashed
	case PrerenderFinalStatusRendererProcessKilled:
		*t = PrerenderFinalStatusRendererProcessKilled
	case PrerenderFinalStatusDownload:
		*t = PrerenderFinalStatusDownload
	case PrerenderFinalStatusTriggerDestroyed:
		*t = PrerenderFinalStatusTriggerDestroyed
	case PrerenderFinalStatusNavigationNotCommitted:
		*t = PrerenderFinalStatusNavigationNotCommitted
	case PrerenderFinalStatusNavigationBadHTTPStatus:
		*t = PrerenderFinalStatusNavigationBadHTTPStatus
	case PrerenderFinalStatusClientCertRequested:
		*t = PrerenderFinalStatusClientCertRequested
	case PrerenderFinalStatusNavigationRequestNetworkError:
		*t = PrerenderFinalStatusNavigationRequestNetworkError
	case PrerenderFinalStatusMaxNumOfRunningPrerendersExceeded:
		*t = PrerenderFinalStatusMaxNumOfRunningPrerendersExceeded
	case PrerenderFinalStatusCancelAllHostsForTesting:
		*t = PrerenderFinalStatusCancelAllHostsForTesting
	case PrerenderFinalStatusDidFailLoad:
		*t = PrerenderFinalStatusDidFailLoad
	case PrerenderFinalStatusStop:
		*t = PrerenderFinalStatusStop
	case PrerenderFinalStatusSslCertificateError:
		*t = PrerenderFinalStatusSslCertificateError
	case PrerenderFinalStatusLoginAuthRequested:
		*t = PrerenderFinalStatusLoginAuthRequested
	case PrerenderFinalStatusUaChangeRequiresReload:
		*t = PrerenderFinalStatusUaChangeRequiresReload
	case PrerenderFinalStatusBlockedByClient:
		*t = PrerenderFinalStatusBlockedByClient
	case PrerenderFinalStatusAudioOutputDeviceRequested:
		*t = PrerenderFinalStatusAudioOutputDeviceRequested
	case PrerenderFinalStatusMixedContent:
		*t = PrerenderFinalStatusMixedContent
	case PrerenderFinalStatusTriggerBackgrounded:
		*t = PrerenderFinalStatusTriggerBackgrounded
	case PrerenderFinalStatusEmbedderTriggeredAndCrossOriginRedirected:
		*t = PrerenderFinalStatusEmbedderTriggeredAndCrossOriginRedirected
	case PrerenderFinalStatusMemoryLimitExceeded:
		*t = PrerenderFinalStatusMemoryLimitExceeded
	case PrerenderFinalStatusFailToGetMemoryUsage:
		*t = PrerenderFinalStatusFailToGetMemoryUsage
	case PrerenderFinalStatusDataSaverEnabled:
		*t = PrerenderFinalStatusDataSaverEnabled
	case PrerenderFinalStatusHasEffectiveURL:
		*t = PrerenderFinalStatusHasEffectiveURL
	case PrerenderFinalStatusActivatedBeforeStarted:
		*t = PrerenderFinalStatusActivatedBeforeStarted
	case PrerenderFinalStatusInactivePageRestriction:
		*t = PrerenderFinalStatusInactivePageRestriction
	case PrerenderFinalStatusStartFailed:
		*t = PrerenderFinalStatusStartFailed
	case PrerenderFinalStatusTimeoutBackgrounded:
		*t = PrerenderFinalStatusTimeoutBackgrounded
	case PrerenderFinalStatusCrossSiteRedirect:
		*t = PrerenderFinalStatusCrossSiteRedirect
	case PrerenderFinalStatusCrossSiteNavigation:
		*t = PrerenderFinalStatusCrossSiteNavigation
	case PrerenderFinalStatusSameSiteCrossOriginRedirect:
		*t = PrerenderFinalStatusSameSiteCrossOriginRedirect
	case PrerenderFinalStatusSameSiteCrossOriginNavigation:
		*t = PrerenderFinalStatusSameSiteCrossOriginNavigation
	case PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptIn:
		*t = PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptIn
	case PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptIn:
		*t = PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptIn
	case PrerenderFinalStatusActivationNavigationParameterMismatch:
		*t = PrerenderFinalStatusActivationNavigationParameterMismatch
	case PrerenderFinalStatusActivatedInBackground:
		*t = PrerenderFinalStatusActivatedInBackground
	case PrerenderFinalStatusEmbedderHostDisallowed:
		*t = PrerenderFinalStatusEmbedderHostDisallowed
	case PrerenderFinalStatusActivationNavigationDestroyedBeforeSuccess:
		*t = PrerenderFinalStatusActivationNavigationDestroyedBeforeSuccess
	case PrerenderFinalStatusTabClosedByUserGesture:
		*t = PrerenderFinalStatusTabClosedByUserGesture
	case PrerenderFinalStatusTabClosedWithoutUserGesture:
		*t = PrerenderFinalStatusTabClosedWithoutUserGesture
	case PrerenderFinalStatusPrimaryMainFrameRendererProcessCrashed:
		*t = PrerenderFinalStatusPrimaryMainFrameRendererProcessCrashed
	case PrerenderFinalStatusPrimaryMainFrameRendererProcessKilled:
		*t = PrerenderFinalStatusPrimaryMainFrameRendererProcessKilled
	case PrerenderFinalStatusActivationFramePolicyNotCompatible:
		*t = PrerenderFinalStatusActivationFramePolicyNotCompatible
	case PrerenderFinalStatusPreloadingDisabled:
		*t = PrerenderFinalStatusPreloadingDisabled
	case PrerenderFinalStatusBatterySaverEnabled:
		*t = PrerenderFinalStatusBatterySaverEnabled
	case PrerenderFinalStatusActivatedDuringMainFrameNavigation:
		*t = PrerenderFinalStatusActivatedDuringMainFrameNavigation
	case PrerenderFinalStatusPreloadingUnsupportedByWebContents:
		*t = PrerenderFinalStatusPreloadingUnsupportedByWebContents

	default:
		in.AddError(fmt.Errorf("unknown PrerenderFinalStatus value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PrerenderFinalStatus) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// PreloadingStatus preloading status values, see also
// PreloadingTriggeringOutcome. This status is shared by prefetchStatusUpdated
// and prerenderStatusUpdated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PreloadingStatus
type PreloadingStatus string

// String returns the PreloadingStatus as string value.
func (t PreloadingStatus) String() string {
	return string(t)
}

// PreloadingStatus values.
const (
	PreloadingStatusPending      PreloadingStatus = "Pending"
	PreloadingStatusRunning      PreloadingStatus = "Running"
	PreloadingStatusReady        PreloadingStatus = "Ready"
	PreloadingStatusSuccess      PreloadingStatus = "Success"
	PreloadingStatusFailure      PreloadingStatus = "Failure"
	PreloadingStatusNotSupported PreloadingStatus = "NotSupported"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PreloadingStatus) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PreloadingStatus) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PreloadingStatus) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PreloadingStatus(v) {
	case PreloadingStatusPending:
		*t = PreloadingStatusPending
	case PreloadingStatusRunning:
		*t = PreloadingStatusRunning
	case PreloadingStatusReady:
		*t = PreloadingStatusReady
	case PreloadingStatusSuccess:
		*t = PreloadingStatusSuccess
	case PreloadingStatusFailure:
		*t = PreloadingStatusFailure
	case PreloadingStatusNotSupported:
		*t = PreloadingStatusNotSupported

	default:
		in.AddError(fmt.Errorf("unknown PreloadingStatus value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PreloadingStatus) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// FileChooserOpenedMode input mode.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-fileChooserOpened
type FileChooserOpenedMode string

// String returns the FileChooserOpenedMode as string value.
func (t FileChooserOpenedMode) String() string {
	return string(t)
}

// FileChooserOpenedMode values.
const (
	FileChooserOpenedModeSelectSingle   FileChooserOpenedMode = "selectSingle"
	FileChooserOpenedModeSelectMultiple FileChooserOpenedMode = "selectMultiple"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t FileChooserOpenedMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t FileChooserOpenedMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *FileChooserOpenedMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch FileChooserOpenedMode(v) {
	case FileChooserOpenedModeSelectSingle:
		*t = FileChooserOpenedModeSelectSingle
	case FileChooserOpenedModeSelectMultiple:
		*t = FileChooserOpenedModeSelectMultiple

	default:
		in.AddError(fmt.Errorf("unknown FileChooserOpenedMode value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *FileChooserOpenedMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// FrameDetachedReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-frameDetached
type FrameDetachedReason string

// String returns the FrameDetachedReason as string value.
func (t FrameDetachedReason) String() string {
	return string(t)
}

// FrameDetachedReason values.
const (
	FrameDetachedReasonRemove FrameDetachedReason = "remove"
	FrameDetachedReasonSwap   FrameDetachedReason = "swap"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t FrameDetachedReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t FrameDetachedReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *FrameDetachedReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch FrameDetachedReason(v) {
	case FrameDetachedReasonRemove:
		*t = FrameDetachedReasonRemove
	case FrameDetachedReasonSwap:
		*t = FrameDetachedReasonSwap

	default:
		in.AddError(fmt.Errorf("unknown FrameDetachedReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *FrameDetachedReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CaptureScreenshotFormat image compression format (defaults to png).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureScreenshot
type CaptureScreenshotFormat string

// String returns the CaptureScreenshotFormat as string value.
func (t CaptureScreenshotFormat) String() string {
	return string(t)
}

// CaptureScreenshotFormat values.
const (
	CaptureScreenshotFormatJpeg CaptureScreenshotFormat = "jpeg"
	CaptureScreenshotFormatPng  CaptureScreenshotFormat = "png"
	CaptureScreenshotFormatWebp CaptureScreenshotFormat = "webp"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CaptureScreenshotFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CaptureScreenshotFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CaptureScreenshotFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch CaptureScreenshotFormat(v) {
	case CaptureScreenshotFormatJpeg:
		*t = CaptureScreenshotFormatJpeg
	case CaptureScreenshotFormatPng:
		*t = CaptureScreenshotFormatPng
	case CaptureScreenshotFormatWebp:
		*t = CaptureScreenshotFormatWebp

	default:
		in.AddError(fmt.Errorf("unknown CaptureScreenshotFormat value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CaptureScreenshotFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CaptureSnapshotFormat format (defaults to mhtml).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureSnapshot
type CaptureSnapshotFormat string

// String returns the CaptureSnapshotFormat as string value.
func (t CaptureSnapshotFormat) String() string {
	return string(t)
}

// CaptureSnapshotFormat values.
const (
	CaptureSnapshotFormatMhtml CaptureSnapshotFormat = "mhtml"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CaptureSnapshotFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CaptureSnapshotFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CaptureSnapshotFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch CaptureSnapshotFormat(v) {
	case CaptureSnapshotFormatMhtml:
		*t = CaptureSnapshotFormatMhtml

	default:
		in.AddError(fmt.Errorf("unknown CaptureSnapshotFormat value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CaptureSnapshotFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// PrintToPDFTransferMode return as stream.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-printToPDF
type PrintToPDFTransferMode string

// String returns the PrintToPDFTransferMode as string value.
func (t PrintToPDFTransferMode) String() string {
	return string(t)
}

// PrintToPDFTransferMode values.
const (
	PrintToPDFTransferModeReturnAsBase64 PrintToPDFTransferMode = "ReturnAsBase64"
	PrintToPDFTransferModeReturnAsStream PrintToPDFTransferMode = "ReturnAsStream"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PrintToPDFTransferMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PrintToPDFTransferMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PrintToPDFTransferMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PrintToPDFTransferMode(v) {
	case PrintToPDFTransferModeReturnAsBase64:
		*t = PrintToPDFTransferModeReturnAsBase64
	case PrintToPDFTransferModeReturnAsStream:
		*t = PrintToPDFTransferModeReturnAsStream

	default:
		in.AddError(fmt.Errorf("unknown PrintToPDFTransferMode value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PrintToPDFTransferMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ScreencastFormat image compression format.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-startScreencast
type ScreencastFormat string

// String returns the ScreencastFormat as string value.
func (t ScreencastFormat) String() string {
	return string(t)
}

// ScreencastFormat values.
const (
	ScreencastFormatJpeg ScreencastFormat = "jpeg"
	ScreencastFormatPng  ScreencastFormat = "png"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ScreencastFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ScreencastFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ScreencastFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ScreencastFormat(v) {
	case ScreencastFormatJpeg:
		*t = ScreencastFormatJpeg
	case ScreencastFormatPng:
		*t = ScreencastFormatPng

	default:
		in.AddError(fmt.Errorf("unknown ScreencastFormat value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ScreencastFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SetWebLifecycleStateState target lifecycle state.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setWebLifecycleState
type SetWebLifecycleStateState string

// String returns the SetWebLifecycleStateState as string value.
func (t SetWebLifecycleStateState) String() string {
	return string(t)
}

// SetWebLifecycleStateState values.
const (
	SetWebLifecycleStateStateFrozen SetWebLifecycleStateState = "frozen"
	SetWebLifecycleStateStateActive SetWebLifecycleStateState = "active"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t SetWebLifecycleStateState) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t SetWebLifecycleStateState) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *SetWebLifecycleStateState) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch SetWebLifecycleStateState(v) {
	case SetWebLifecycleStateStateFrozen:
		*t = SetWebLifecycleStateStateFrozen
	case SetWebLifecycleStateStateActive:
		*t = SetWebLifecycleStateStateActive

	default:
		in.AddError(fmt.Errorf("unknown SetWebLifecycleStateState value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *SetWebLifecycleStateState) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
