# IDE and developer tools Integrations

## VSCode (Official)
[Visual Studio Code](https://code.visualstudio.com/) is an open source versatile code editor and development environment.

👉 Get it at: <https://github.com/aquasecurity/trivy-vscode-extension>

## JetBrains (Official)
[JetBrains](https://jetbrains.com) makes IDEs such as Goland, Pycharm, IntelliJ, Webstorm, and more.

The Trivy plugin for JetBrains IDEs lets you use Trivy right from your development environment.

👉 Get it at: <https://plugins.jetbrains.com/plugin/18690-trivy-findings-explorer>

## Kubernetes Lens (Official)
[Kubernetes Lens](https://k8slens.dev/) is a management application for Kubernetes clusters.

Trivy has an extension for Kubernetes Lens that lets you scan Kubernetes workloads and view the results in the Lens UI.

👉 Get it at: <https://github.com/aquasecurity/trivy-operator-lens-extension>

## Vim (Community)
[Vim](https://www.vim.org/) is a terminal based text editor.

Vim plugin for Trivy to install and run Trivy.

👉 Get it at: <https://github.com/aquasecurity/vim-trivy>

## Docker Desktop (Community)
[Docker Desktop](https://www.docker.com/products/docker-desktop/) is an easy way to install [Docker]() container engine on your development machine, and manage it in a GUI .

Trivy Docker Desktop extension for scanning container images for vulnerabilities and generating SBOMs

👉 Get it at: <https://github.com/aquasecurity/trivy-docker-extension>

## Rancher Desktop (Community)
[Rancher Desktop](https://rancherdesktop.io/) is an easy way to use containers and Kubernetes on your development machine, and mange it in a GUI.

Trivy is natively integrated with Rancher, no installation is needed. More info in Rancher documentation: <https://docs.rancherdesktop.io/getting-started/features#scanning-images>

## LazyTrivy (Community)
A terminal native UI for Trivy

👉 Get it at: <https://github.com/owenrumney/lazytrivy>

## Trivy Vulnerability explorer (Community)

Web application that allows to load a Trivy report in json format and displays the vulnerabilities of a single target in an interactive data table

👉 Get it at: <https://github.com/dbsystel/trivy-vulnerability-explorer>

## Trivy pre-commit (Community)

A trivy pre-commit hook that runs a `trivy fs` in your git repo before commiting, preventing you from commiting secrets in the first place.

👉 Get it at: <https://github.com/mxab/pre-commit-trivy>
