# Language-specific Packages

`Trivy` automatically detects the following files and scans vulnerabilities in the application dependencies.

## Supported languages

| Language             | File                                                                                       | Image[^7] | Rootfs[^8] | Filesystem[^9] | Repository[^10] | Dev dependencies             | Dependency location[^11] |
|----------------------|--------------------------------------------------------------------------------------------|:---------:|:----------:|:--------------:|:---------------:|------------------------------|:------------------------:|
| Ruby                 | Gemfile.lock                                                                               |     -     |     -      |       ✅        |        ✅        | included                     |            -             |
|                      | gemspec                                                                                    |     ✅     |     ✅      |       -        |        -        | included                     |            -             |
| [Python](python.md)  | Pipfile.lock                                                                               |     -     |     -      |       ✅        |        ✅        | excluded                     |            ✅             |
|                      | poetry.lock                                                                                |     -     |     -      |       ✅        |        ✅        | excluded                     |            -             |
|                      | requirements.txt                                                                           |     -     |     -      |       ✅        |        ✅        | included                     |            -             |
|                      | egg package[^1]                                                                            |     ✅     |     ✅      |       -        |        -        | excluded                     |            -             |
|                      | wheel package[^2]                                                                          |     ✅     |     ✅      |       -        |        -        | excluded                     |            -             |
| [PHP](php.md)        | composer.lock                                                                              |     ✅     |     ✅      |       ✅        |        ✅        | excluded                     |            ✅             |
| [Node.js](nodejs.md) | package-lock.json                                                                          |     -     |     -      |       ✅        |        ✅        | [excluded](./nodejs.md#npm)  |            ✅             |
|                      | yarn.lock                                                                                  |     -     |     -      |       ✅        |        ✅        | [excluded](./nodejs.md#yarn) |            ✅             |
|                      | pnpm-lock.yaml                                                                             |     -     |     -      |       ✅        |        ✅        | excluded                     |            -             |
|                      | package.json                                                                               |     ✅     |     ✅      |       -        |        -        | excluded                     |            -             |
| .NET                 | packages.lock.json                                                                         |     ✅     |     ✅      |       ✅        |        ✅        | included                     |            ✅             |
|                      | packages.config                                                                            |     ✅     |     ✅      |       ✅        |        ✅        | excluded                     |            -             |
|                      | .deps.json                                                                                 |     ✅     |     ✅      |       ✅        |        ✅        | excluded                     |            ✅             |
| [Java](java.md)      | JAR/WAR/PAR/EAR[^3]                                                                        |     ✅     |     ✅      |       -        |        -        | included                     |            -             |
|                      | pom.xml[^4]                                                                                |     -     |     -      |       ✅        |        ✅        | excluded                     |            -             |
|                      | *gradle.lockfile                                                                           |     -     |     -      |       ✅        |        ✅        | excluded                     |            -             |
| [Go](golang.md)      | Binaries built by Go[^5]                                                                   |     ✅     |     ✅      |       -        |        -        | excluded                     |            -             |
|                      | go.mod[^6]                                                                                 |     -     |     -      |       ✅        |        ✅        | included                     |            -             |
| [Rust](rust.md)      | Cargo.lock                                                                                 |     ✅     |     ✅      |       ✅        |        ✅        | excluded                     |            ✅             |
|                      | Binaries built with [cargo-auditable](https://github.com/rust-secure-code/cargo-auditable) |     ✅     |     ✅      |       -        |        -        | excluded                     |            -             |
| C/C++                | conan.lock[^12]                                                                            |     -     |     -      |       ✅        |        ✅        | excluded                     |            -             |   
| Elixir               | mix.lock[^12]                                                                              |     -     |     -      |       ✅        |        ✅        | excluded                     |            ✅             |
| Dart                 | pubspec.lock                                                                               |     -     |     -      |       ✅        |        ✅        | included                     |            -             |

The path of these files does not matter.

Example: [Dockerfile](https://github.com/aquasecurity/trivy-ci-test/blob/main/Dockerfile)

[^1]: `*.egg-info`, `*.egg-info/PKG-INFO`, `*.egg` and `EGG-INFO/PKG-INFO`
[^2]: `.dist-info/META-DATA`
[^3]: `*.jar`, `*.war`, `*.par` and `*.ear`
[^4]: It requires Internet access when the POM doesn't exist in your local repository
[^5]: UPX-compressed binaries don't work
[^6]: If smaller than go 1.17, go.sum is also required
[^7]: ✅ means "enabled" and `-` means "disabled" in the image scanning
[^8]: ✅ means "enabled" and `-` means "disabled" in the rootfs scanning
[^9]: ✅ means "enabled" and `-` means "disabled" in the filesystem scanning
[^10]: ✅ means "enabled" and `-` means "disabled" in the git repository scanning
[^11]: ✅ means that Trivy detects line numbers where each dependency is declared in the scanned file. Only supported in [json](../../../configuration/reporting.md#json) and [sarif](../../../configuration/reporting.md#sarif) formats. SARIF uses `startline == 1 and endline == 1` for unsupported file types
[^12]: To scan a filename other than the default filename use [file-patterns](../../../configuration/others.md#file-patterns)
[^13]: When you scan `Cargo.lock` and `Cargo.toml` together. See about it [here](./rust.md#cargo).

## Data Sources

| Language | Source                                              | Commercial Use | Delay[^1] |
|----------|-----------------------------------------------------|:--------------:|:---------:|
| PHP      | [PHP Security Advisories Database][php]             |       ✅        |     -     |
|          | [GitHub Advisory Database (Composer)][php-ghsa]     |       ✅        |     -     |
| Python   | [GitHub Advisory Database (pip)][python-ghsa]       |       ✅        |     -     |
|          | [Open Source Vulnerabilities (PyPI)][python-osv]    |       ✅        |     -     |
| Ruby     | [Ruby Advisory Database][ruby]                      |       ✅        |     -     |
|          | [GitHub Advisory Database (RubyGems)][ruby-ghsa]    |       ✅        |     -     |
| Node.js  | [Ecosystem Security Working Group][nodejs]          |       ✅        |     -     |
|          | [GitHub Advisory Database (npm)][nodejs-ghsa]       |       ✅        |     -     |
| Java     | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
|          | [GitHub Advisory Database (Maven)][java-ghsa]       |       ✅        |     -     |
| Go       | [GitHub Advisory Database (Go)][go-ghsa]            |       ✅        |     -     |
| Rust     | [Open Source Vulnerabilities (crates.io)][rust-osv] |       ✅        |     -     |
| .NET     | [GitHub Advisory Database (NuGet)][dotnet-ghsa]     |       ✅        |     -     |
| C/C++    | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
| Dart     | [GitHub Advisory Database (Pub)][pub-ghsa]          |       ✅        |     -     |
| Elixir   | [GitHub Advisory Database (Erlang)][erlang-ghsa]    |       ✅        |           |

[^1]: Intentional delay between vulnerability disclosure and registration in the DB

[php-ghsa]: https://github.com/advisories?query=ecosystem%3Acomposer
[python-ghsa]: https://github.com/advisories?query=ecosystem%3Apip
[ruby-ghsa]: https://github.com/advisories?query=ecosystem%3Arubygems
[nodejs-ghsa]: https://github.com/advisories?query=ecosystem%3Anpm
[java-ghsa]: https://github.com/advisories?query=ecosystem%3Amaven
[dotnet-ghsa]: https://github.com/advisories?query=ecosystem%3Anuget
[pub-ghsa]: https://github.com/advisories?query=ecosystem%3Apub
[erlang-ghsa]: https://github.com/advisories?query=ecosystem%3Aerlang
[go-ghsa]: https://github.com/advisories?query=ecosystem%3Ago

[php]: https://github.com/FriendsOfPHP/security-advisories
[ruby]: https://github.com/rubysec/ruby-advisory-db
[nodejs]: https://github.com/nodejs/security-wg
[gitlab]: https://gitlab.com/gitlab-org/advisories-community

[python-osv]: https://osv.dev/list?q=&ecosystem=PyPI
[rust-osv]: https://osv.dev/list?q=&ecosystem=crates.io