/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef LANCODE_H
#define LANCODE_H

#define MAXNODES 8

/* TLF can communicate with other TLF instances to form a net of distributed
 * logging stations. For that purpose it sends broadcast messages about
 * relevant events to other TLF nodes.
 * The following message types are supported:
 */

#define LOGENTRY '1'	// just logged QSO at that station
#define CLUSTERMSG '2'	// received messages from DX-cluster
#define TLFSPOT '3'	// DX-spot generated by operator itself
#define TLFMSG '4'	// Talk message for local chat
#define FREQMSG '5'	// actual QRG
#define INCQSONUM '6'	// last QSO nr used for serial exchange by node
#define TIMESYNC '7'	// actual time (if TIME_MASTER node)
#define QTCRENTRY '8'	// received QTC
#define QTCSENTRY '9'	// sent QTC
#define QTCFLAG ':'	// QTC flags

/* Each sent message is sent as UDP packet and consists of
 * - 1 character for the sending node ID, followed by
 * - 1 character for the above defined message ID, followed by
 * - a message specific string of characters as body
 */

/* The format of the message specific string is as follows:
 *
 * LOGENTRY
 * 	Standard logline with LOGLINELEN characters (last one is \n)
 * CLUSTERMSG
 *	max 78 characters from DX-cluster,
 *	followed by \n
 * TLFSPOT
 *	77 characters self formatted cluster message,
 *	e.g.
 * 'DX de TLF-B:        21.435  K3NBD                                     1041Z'
 *	followed by \n\n
 * TLFMSG
 * 	Max 60 characters text (see talk()) followed by \n
 * FREQMSG
 *	7 characters actual QRG in kHz with one decimal,
 *	left padded with spaces if with TRXcontrol
 *	7 characters band in meters with one decimal if without TRXcontrol
 *	followed by \n in both cases
 * INCQSONR
 *	QSO number with max. 4 digits,
 *	followed by \n
 * TIMESYNC
 * 	actual time_t value as decimal number,
 * 	followed by one space
 *  QTCRENTRY
 *	QTC logline for RECV direction,
 *	followed by \n\n
 *  QTCSENTRY
 *	QTC logline for SEND direction,
 *	followed by \n\n
 *  QTCFLAG
 *	'<callsign>;L' or '<callsign;N,'
 *	followed by \n\n
 */

#include <hamlib/rig.h>

extern char bc_hostaddress[MAXNODES][16];
extern int bc_hostport[MAXNODES];
extern char talkarray[5][62];
extern char thisnode;
extern char lan_message[256];
extern int recv_error;
extern freq_t node_frequencies[MAXNODES];
extern int recv_packets;
extern int send_packets[MAXNODES];
extern int send_error[MAXNODES];

int lan_recv_init(void);
int lan_recv_close(void);
int lan_recv(void);
int lan_send_init(void);
int lan_send_close(void);
void send_lan_message(int opcode, char *message);
void talk(void);
int send_freq(freq_t freq);
void send_time(void) ;

#endif /* LANCODE_H */
