---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles,
              transformée de Laplace
---

# Comment obtenir le "L" de la transformée de Laplace ?

## Avec l'extension <ctanpkg:mathrsfs> 

Pour obtenir le "L" de la 
[transformée de Laplace](wpfr:Transformation_de_Laplace), vous pouvez 
utiliser l'extension <ctanpkg:mathrsfs> et sa commande `\mathscr{L}`.

Si vous n'avez pas l'usage de la commande `\L` (qui affiche le "L barré", Ł),
vous pouvez remplacer sa définition pour celle du "L" de Laplace, 
avec un `\renewcommand` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathrsfs}

  \renewcommand*{\L}{\ensuremath{\mathscr{L}}}

\begin{document}
\[  \L  \]
\end{document}
```

Cette extension fait appel à des polices de caractères particulières. 
Dans les anciennes distributions LaTeX, il fallait les installer 
volontairement. Ça ne semble plus être le cas aujourd'hui.
