// Copyright 2020 Authors of Hubble
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.22.3
// source: tetragon/sensors.proto

package tetragon

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FineGuidanceSensors_GetEvents_FullMethodName           = "/tetragon.FineGuidanceSensors/GetEvents"
	FineGuidanceSensors_GetHealth_FullMethodName           = "/tetragon.FineGuidanceSensors/GetHealth"
	FineGuidanceSensors_AddTracingPolicy_FullMethodName    = "/tetragon.FineGuidanceSensors/AddTracingPolicy"
	FineGuidanceSensors_RemoveSensor_FullMethodName        = "/tetragon.FineGuidanceSensors/RemoveSensor"
	FineGuidanceSensors_ListTracingPolicies_FullMethodName = "/tetragon.FineGuidanceSensors/ListTracingPolicies"
	FineGuidanceSensors_ListSensors_FullMethodName         = "/tetragon.FineGuidanceSensors/ListSensors"
	FineGuidanceSensors_EnableSensor_FullMethodName        = "/tetragon.FineGuidanceSensors/EnableSensor"
	FineGuidanceSensors_DisableSensor_FullMethodName       = "/tetragon.FineGuidanceSensors/DisableSensor"
	FineGuidanceSensors_SetSensorConfig_FullMethodName     = "/tetragon.FineGuidanceSensors/SetSensorConfig"
	FineGuidanceSensors_GetSensorConfig_FullMethodName     = "/tetragon.FineGuidanceSensors/GetSensorConfig"
	FineGuidanceSensors_GetStackTraceTree_FullMethodName   = "/tetragon.FineGuidanceSensors/GetStackTraceTree"
	FineGuidanceSensors_GetVersion_FullMethodName          = "/tetragon.FineGuidanceSensors/GetVersion"
	FineGuidanceSensors_RuntimeHook_FullMethodName         = "/tetragon.FineGuidanceSensors/RuntimeHook"
)

// FineGuidanceSensorsClient is the client API for FineGuidanceSensors service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FineGuidanceSensorsClient interface {
	GetEvents(ctx context.Context, in *GetEventsRequest, opts ...grpc.CallOption) (FineGuidanceSensors_GetEventsClient, error)
	GetHealth(ctx context.Context, in *GetHealthStatusRequest, opts ...grpc.CallOption) (*GetHealthStatusResponse, error)
	AddTracingPolicy(ctx context.Context, in *AddTracingPolicyRequest, opts ...grpc.CallOption) (*AddTracingPolicyResponse, error)
	RemoveSensor(ctx context.Context, in *RemoveSensorRequest, opts ...grpc.CallOption) (*RemoveSensorResponse, error)
	ListTracingPolicies(ctx context.Context, in *ListTracingPoliciesRequest, opts ...grpc.CallOption) (*ListTracingPoliciesResponse, error)
	ListSensors(ctx context.Context, in *ListSensorsRequest, opts ...grpc.CallOption) (*ListSensorsResponse, error)
	EnableSensor(ctx context.Context, in *EnableSensorRequest, opts ...grpc.CallOption) (*EnableSensorResponse, error)
	DisableSensor(ctx context.Context, in *DisableSensorRequest, opts ...grpc.CallOption) (*DisableSensorResponse, error)
	SetSensorConfig(ctx context.Context, in *SetSensorConfigRequest, opts ...grpc.CallOption) (*SetSensorConfigResponse, error)
	GetSensorConfig(ctx context.Context, in *GetSensorConfigRequest, opts ...grpc.CallOption) (*GetSensorConfigResponse, error)
	GetStackTraceTree(ctx context.Context, in *GetStackTraceTreeRequest, opts ...grpc.CallOption) (*GetStackTraceTreeResponse, error)
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*GetVersionResponse, error)
	RuntimeHook(ctx context.Context, in *RuntimeHookRequest, opts ...grpc.CallOption) (*RuntimeHookResponse, error)
}

type fineGuidanceSensorsClient struct {
	cc grpc.ClientConnInterface
}

func NewFineGuidanceSensorsClient(cc grpc.ClientConnInterface) FineGuidanceSensorsClient {
	return &fineGuidanceSensorsClient{cc}
}

func (c *fineGuidanceSensorsClient) GetEvents(ctx context.Context, in *GetEventsRequest, opts ...grpc.CallOption) (FineGuidanceSensors_GetEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &FineGuidanceSensors_ServiceDesc.Streams[0], FineGuidanceSensors_GetEvents_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &fineGuidanceSensorsGetEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FineGuidanceSensors_GetEventsClient interface {
	Recv() (*GetEventsResponse, error)
	grpc.ClientStream
}

type fineGuidanceSensorsGetEventsClient struct {
	grpc.ClientStream
}

func (x *fineGuidanceSensorsGetEventsClient) Recv() (*GetEventsResponse, error) {
	m := new(GetEventsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *fineGuidanceSensorsClient) GetHealth(ctx context.Context, in *GetHealthStatusRequest, opts ...grpc.CallOption) (*GetHealthStatusResponse, error) {
	out := new(GetHealthStatusResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_GetHealth_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) AddTracingPolicy(ctx context.Context, in *AddTracingPolicyRequest, opts ...grpc.CallOption) (*AddTracingPolicyResponse, error) {
	out := new(AddTracingPolicyResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_AddTracingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) RemoveSensor(ctx context.Context, in *RemoveSensorRequest, opts ...grpc.CallOption) (*RemoveSensorResponse, error) {
	out := new(RemoveSensorResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_RemoveSensor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) ListTracingPolicies(ctx context.Context, in *ListTracingPoliciesRequest, opts ...grpc.CallOption) (*ListTracingPoliciesResponse, error) {
	out := new(ListTracingPoliciesResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_ListTracingPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) ListSensors(ctx context.Context, in *ListSensorsRequest, opts ...grpc.CallOption) (*ListSensorsResponse, error) {
	out := new(ListSensorsResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_ListSensors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) EnableSensor(ctx context.Context, in *EnableSensorRequest, opts ...grpc.CallOption) (*EnableSensorResponse, error) {
	out := new(EnableSensorResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_EnableSensor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) DisableSensor(ctx context.Context, in *DisableSensorRequest, opts ...grpc.CallOption) (*DisableSensorResponse, error) {
	out := new(DisableSensorResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_DisableSensor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) SetSensorConfig(ctx context.Context, in *SetSensorConfigRequest, opts ...grpc.CallOption) (*SetSensorConfigResponse, error) {
	out := new(SetSensorConfigResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_SetSensorConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) GetSensorConfig(ctx context.Context, in *GetSensorConfigRequest, opts ...grpc.CallOption) (*GetSensorConfigResponse, error) {
	out := new(GetSensorConfigResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_GetSensorConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) GetStackTraceTree(ctx context.Context, in *GetStackTraceTreeRequest, opts ...grpc.CallOption) (*GetStackTraceTreeResponse, error) {
	out := new(GetStackTraceTreeResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_GetStackTraceTree_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*GetVersionResponse, error) {
	out := new(GetVersionResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_GetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fineGuidanceSensorsClient) RuntimeHook(ctx context.Context, in *RuntimeHookRequest, opts ...grpc.CallOption) (*RuntimeHookResponse, error) {
	out := new(RuntimeHookResponse)
	err := c.cc.Invoke(ctx, FineGuidanceSensors_RuntimeHook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FineGuidanceSensorsServer is the server API for FineGuidanceSensors service.
// All implementations should embed UnimplementedFineGuidanceSensorsServer
// for forward compatibility
type FineGuidanceSensorsServer interface {
	GetEvents(*GetEventsRequest, FineGuidanceSensors_GetEventsServer) error
	GetHealth(context.Context, *GetHealthStatusRequest) (*GetHealthStatusResponse, error)
	AddTracingPolicy(context.Context, *AddTracingPolicyRequest) (*AddTracingPolicyResponse, error)
	RemoveSensor(context.Context, *RemoveSensorRequest) (*RemoveSensorResponse, error)
	ListTracingPolicies(context.Context, *ListTracingPoliciesRequest) (*ListTracingPoliciesResponse, error)
	ListSensors(context.Context, *ListSensorsRequest) (*ListSensorsResponse, error)
	EnableSensor(context.Context, *EnableSensorRequest) (*EnableSensorResponse, error)
	DisableSensor(context.Context, *DisableSensorRequest) (*DisableSensorResponse, error)
	SetSensorConfig(context.Context, *SetSensorConfigRequest) (*SetSensorConfigResponse, error)
	GetSensorConfig(context.Context, *GetSensorConfigRequest) (*GetSensorConfigResponse, error)
	GetStackTraceTree(context.Context, *GetStackTraceTreeRequest) (*GetStackTraceTreeResponse, error)
	GetVersion(context.Context, *GetVersionRequest) (*GetVersionResponse, error)
	RuntimeHook(context.Context, *RuntimeHookRequest) (*RuntimeHookResponse, error)
}

// UnimplementedFineGuidanceSensorsServer should be embedded to have forward compatible implementations.
type UnimplementedFineGuidanceSensorsServer struct {
}

func (UnimplementedFineGuidanceSensorsServer) GetEvents(*GetEventsRequest, FineGuidanceSensors_GetEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetEvents not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) GetHealth(context.Context, *GetHealthStatusRequest) (*GetHealthStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHealth not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) AddTracingPolicy(context.Context, *AddTracingPolicyRequest) (*AddTracingPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTracingPolicy not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) RemoveSensor(context.Context, *RemoveSensorRequest) (*RemoveSensorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveSensor not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) ListTracingPolicies(context.Context, *ListTracingPoliciesRequest) (*ListTracingPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTracingPolicies not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) ListSensors(context.Context, *ListSensorsRequest) (*ListSensorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSensors not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) EnableSensor(context.Context, *EnableSensorRequest) (*EnableSensorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableSensor not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) DisableSensor(context.Context, *DisableSensorRequest) (*DisableSensorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableSensor not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) SetSensorConfig(context.Context, *SetSensorConfigRequest) (*SetSensorConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSensorConfig not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) GetSensorConfig(context.Context, *GetSensorConfigRequest) (*GetSensorConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSensorConfig not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) GetStackTraceTree(context.Context, *GetStackTraceTreeRequest) (*GetStackTraceTreeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStackTraceTree not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) GetVersion(context.Context, *GetVersionRequest) (*GetVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (UnimplementedFineGuidanceSensorsServer) RuntimeHook(context.Context, *RuntimeHookRequest) (*RuntimeHookResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RuntimeHook not implemented")
}

// UnsafeFineGuidanceSensorsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FineGuidanceSensorsServer will
// result in compilation errors.
type UnsafeFineGuidanceSensorsServer interface {
	mustEmbedUnimplementedFineGuidanceSensorsServer()
}

func RegisterFineGuidanceSensorsServer(s grpc.ServiceRegistrar, srv FineGuidanceSensorsServer) {
	s.RegisterService(&FineGuidanceSensors_ServiceDesc, srv)
}

func _FineGuidanceSensors_GetEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetEventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FineGuidanceSensorsServer).GetEvents(m, &fineGuidanceSensorsGetEventsServer{stream})
}

type FineGuidanceSensors_GetEventsServer interface {
	Send(*GetEventsResponse) error
	grpc.ServerStream
}

type fineGuidanceSensorsGetEventsServer struct {
	grpc.ServerStream
}

func (x *fineGuidanceSensorsGetEventsServer) Send(m *GetEventsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _FineGuidanceSensors_GetHealth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHealthStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).GetHealth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_GetHealth_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).GetHealth(ctx, req.(*GetHealthStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_AddTracingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTracingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).AddTracingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_AddTracingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).AddTracingPolicy(ctx, req.(*AddTracingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_RemoveSensor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSensorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).RemoveSensor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_RemoveSensor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).RemoveSensor(ctx, req.(*RemoveSensorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_ListTracingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTracingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).ListTracingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_ListTracingPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).ListTracingPolicies(ctx, req.(*ListTracingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_ListSensors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSensorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).ListSensors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_ListSensors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).ListSensors(ctx, req.(*ListSensorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_EnableSensor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableSensorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).EnableSensor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_EnableSensor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).EnableSensor(ctx, req.(*EnableSensorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_DisableSensor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableSensorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).DisableSensor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_DisableSensor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).DisableSensor(ctx, req.(*DisableSensorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_SetSensorConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSensorConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).SetSensorConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_SetSensorConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).SetSensorConfig(ctx, req.(*SetSensorConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_GetSensorConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSensorConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).GetSensorConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_GetSensorConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).GetSensorConfig(ctx, req.(*GetSensorConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_GetStackTraceTree_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStackTraceTreeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).GetStackTraceTree(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_GetStackTraceTree_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).GetStackTraceTree(ctx, req.(*GetStackTraceTreeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_GetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FineGuidanceSensors_RuntimeHook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RuntimeHookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FineGuidanceSensorsServer).RuntimeHook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FineGuidanceSensors_RuntimeHook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FineGuidanceSensorsServer).RuntimeHook(ctx, req.(*RuntimeHookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FineGuidanceSensors_ServiceDesc is the grpc.ServiceDesc for FineGuidanceSensors service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FineGuidanceSensors_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "tetragon.FineGuidanceSensors",
	HandlerType: (*FineGuidanceSensorsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHealth",
			Handler:    _FineGuidanceSensors_GetHealth_Handler,
		},
		{
			MethodName: "AddTracingPolicy",
			Handler:    _FineGuidanceSensors_AddTracingPolicy_Handler,
		},
		{
			MethodName: "RemoveSensor",
			Handler:    _FineGuidanceSensors_RemoveSensor_Handler,
		},
		{
			MethodName: "ListTracingPolicies",
			Handler:    _FineGuidanceSensors_ListTracingPolicies_Handler,
		},
		{
			MethodName: "ListSensors",
			Handler:    _FineGuidanceSensors_ListSensors_Handler,
		},
		{
			MethodName: "EnableSensor",
			Handler:    _FineGuidanceSensors_EnableSensor_Handler,
		},
		{
			MethodName: "DisableSensor",
			Handler:    _FineGuidanceSensors_DisableSensor_Handler,
		},
		{
			MethodName: "SetSensorConfig",
			Handler:    _FineGuidanceSensors_SetSensorConfig_Handler,
		},
		{
			MethodName: "GetSensorConfig",
			Handler:    _FineGuidanceSensors_GetSensorConfig_Handler,
		},
		{
			MethodName: "GetStackTraceTree",
			Handler:    _FineGuidanceSensors_GetStackTraceTree_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _FineGuidanceSensors_GetVersion_Handler,
		},
		{
			MethodName: "RuntimeHook",
			Handler:    _FineGuidanceSensors_RuntimeHook_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetEvents",
			Handler:       _FineGuidanceSensors_GetEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "tetragon/sensors.proto",
}
