// Copyright 2020 Authors of Hubble
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.22.3
// source: tetragon/sensors.proto

package tetragon

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ListSensorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListSensorsRequest) Reset() {
	*x = ListSensorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSensorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSensorsRequest) ProtoMessage() {}

func (x *ListSensorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSensorsRequest.ProtoReflect.Descriptor instead.
func (*ListSensorsRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{0}
}

type SensorStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the name of the sensor
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// enabled marks whether the sensor is enabled
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// collection is the collection the sensor belongs to (typically a tracing policy)
	Collection string `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
}

func (x *SensorStatus) Reset() {
	*x = SensorStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SensorStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SensorStatus) ProtoMessage() {}

func (x *SensorStatus) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SensorStatus.ProtoReflect.Descriptor instead.
func (*SensorStatus) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{1}
}

func (x *SensorStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SensorStatus) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SensorStatus) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

type ListSensorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sensors []*SensorStatus `protobuf:"bytes,1,rep,name=sensors,proto3" json:"sensors,omitempty"`
}

func (x *ListSensorsResponse) Reset() {
	*x = ListSensorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSensorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSensorsResponse) ProtoMessage() {}

func (x *ListSensorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSensorsResponse.ProtoReflect.Descriptor instead.
func (*ListSensorsResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{2}
}

func (x *ListSensorsResponse) GetSensors() []*SensorStatus {
	if x != nil {
		return x.Sensors
	}
	return nil
}

type ListTracingPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListTracingPoliciesRequest) Reset() {
	*x = ListTracingPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTracingPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTracingPoliciesRequest) ProtoMessage() {}

func (x *ListTracingPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTracingPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListTracingPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{3}
}

type TracingPolicyStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// id is the id of the policy
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// name is the name of the policy
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// namespace is the namespace of the policy (or empty of the policy is global)
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// info is additional information about the policy
	Info string `protobuf:"bytes,4,opt,name=info,proto3" json:"info,omitempty"`
	// sensors loaded in the scope of this policy
	Sensors []string `protobuf:"bytes,5,rep,name=sensors,proto3" json:"sensors,omitempty"`
}

func (x *TracingPolicyStatus) Reset() {
	*x = TracingPolicyStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TracingPolicyStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracingPolicyStatus) ProtoMessage() {}

func (x *TracingPolicyStatus) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracingPolicyStatus.ProtoReflect.Descriptor instead.
func (*TracingPolicyStatus) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{4}
}

func (x *TracingPolicyStatus) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *TracingPolicyStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TracingPolicyStatus) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *TracingPolicyStatus) GetInfo() string {
	if x != nil {
		return x.Info
	}
	return ""
}

func (x *TracingPolicyStatus) GetSensors() []string {
	if x != nil {
		return x.Sensors
	}
	return nil
}

type ListTracingPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policies []*TracingPolicyStatus `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (x *ListTracingPoliciesResponse) Reset() {
	*x = ListTracingPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTracingPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTracingPoliciesResponse) ProtoMessage() {}

func (x *ListTracingPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTracingPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListTracingPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{5}
}

func (x *ListTracingPoliciesResponse) GetPolicies() []*TracingPolicyStatus {
	if x != nil {
		return x.Policies
	}
	return nil
}

type AddTracingPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Yaml string `protobuf:"bytes,1,opt,name=yaml,proto3" json:"yaml,omitempty"`
}

func (x *AddTracingPolicyRequest) Reset() {
	*x = AddTracingPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTracingPolicyRequest) ProtoMessage() {}

func (x *AddTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{6}
}

func (x *AddTracingPolicyRequest) GetYaml() string {
	if x != nil {
		return x.Yaml
	}
	return ""
}

type AddTracingPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddTracingPolicyResponse) Reset() {
	*x = AddTracingPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTracingPolicyResponse) ProtoMessage() {}

func (x *AddTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*AddTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{7}
}

type DeleteTracingPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Yaml string `protobuf:"bytes,1,opt,name=yaml,proto3" json:"yaml,omitempty"`
}

func (x *DeleteTracingPolicyRequest) Reset() {
	*x = DeleteTracingPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTracingPolicyRequest) ProtoMessage() {}

func (x *DeleteTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteTracingPolicyRequest) GetYaml() string {
	if x != nil {
		return x.Yaml
	}
	return ""
}

type DeleteTracingPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteTracingPolicyResponse) Reset() {
	*x = DeleteTracingPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTracingPolicyResponse) ProtoMessage() {}

func (x *DeleteTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*DeleteTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{9}
}

type RemoveSensorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RemoveSensorRequest) Reset() {
	*x = RemoveSensorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveSensorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveSensorRequest) ProtoMessage() {}

func (x *RemoveSensorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveSensorRequest.ProtoReflect.Descriptor instead.
func (*RemoveSensorRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{10}
}

func (x *RemoveSensorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type RemoveSensorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveSensorResponse) Reset() {
	*x = RemoveSensorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveSensorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveSensorResponse) ProtoMessage() {}

func (x *RemoveSensorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveSensorResponse.ProtoReflect.Descriptor instead.
func (*RemoveSensorResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{11}
}

type EnableSensorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnableSensorRequest) Reset() {
	*x = EnableSensorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableSensorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableSensorRequest) ProtoMessage() {}

func (x *EnableSensorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableSensorRequest.ProtoReflect.Descriptor instead.
func (*EnableSensorRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{12}
}

func (x *EnableSensorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type EnableSensorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EnableSensorResponse) Reset() {
	*x = EnableSensorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableSensorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableSensorResponse) ProtoMessage() {}

func (x *EnableSensorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableSensorResponse.ProtoReflect.Descriptor instead.
func (*EnableSensorResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{13}
}

type DisableSensorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DisableSensorRequest) Reset() {
	*x = DisableSensorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableSensorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableSensorRequest) ProtoMessage() {}

func (x *DisableSensorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableSensorRequest.ProtoReflect.Descriptor instead.
func (*DisableSensorRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{14}
}

func (x *DisableSensorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type SetSensorConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Cfgkey string `protobuf:"bytes,2,opt,name=cfgkey,proto3" json:"cfgkey,omitempty"`
	Cfgval string `protobuf:"bytes,3,opt,name=cfgval,proto3" json:"cfgval,omitempty"`
}

func (x *SetSensorConfigRequest) Reset() {
	*x = SetSensorConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSensorConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSensorConfigRequest) ProtoMessage() {}

func (x *SetSensorConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSensorConfigRequest.ProtoReflect.Descriptor instead.
func (*SetSensorConfigRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{15}
}

func (x *SetSensorConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetSensorConfigRequest) GetCfgkey() string {
	if x != nil {
		return x.Cfgkey
	}
	return ""
}

func (x *SetSensorConfigRequest) GetCfgval() string {
	if x != nil {
		return x.Cfgval
	}
	return ""
}

type SetSensorConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetSensorConfigResponse) Reset() {
	*x = SetSensorConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSensorConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSensorConfigResponse) ProtoMessage() {}

func (x *SetSensorConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSensorConfigResponse.ProtoReflect.Descriptor instead.
func (*SetSensorConfigResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{16}
}

type GetSensorConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Cfgkey string `protobuf:"bytes,2,opt,name=cfgkey,proto3" json:"cfgkey,omitempty"`
}

func (x *GetSensorConfigRequest) Reset() {
	*x = GetSensorConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSensorConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSensorConfigRequest) ProtoMessage() {}

func (x *GetSensorConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSensorConfigRequest.ProtoReflect.Descriptor instead.
func (*GetSensorConfigRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{17}
}

func (x *GetSensorConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetSensorConfigRequest) GetCfgkey() string {
	if x != nil {
		return x.Cfgkey
	}
	return ""
}

type GetSensorConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cfgval string `protobuf:"bytes,1,opt,name=cfgval,proto3" json:"cfgval,omitempty"`
}

func (x *GetSensorConfigResponse) Reset() {
	*x = GetSensorConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSensorConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSensorConfigResponse) ProtoMessage() {}

func (x *GetSensorConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSensorConfigResponse.ProtoReflect.Descriptor instead.
func (*GetSensorConfigResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{18}
}

func (x *GetSensorConfigResponse) GetCfgval() string {
	if x != nil {
		return x.Cfgval
	}
	return ""
}

type DisableSensorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisableSensorResponse) Reset() {
	*x = DisableSensorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableSensorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableSensorResponse) ProtoMessage() {}

func (x *DisableSensorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableSensorResponse.ProtoReflect.Descriptor instead.
func (*DisableSensorResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{19}
}

type GetStackTraceTreeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStackTraceTreeRequest) Reset() {
	*x = GetStackTraceTreeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStackTraceTreeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStackTraceTreeRequest) ProtoMessage() {}

func (x *GetStackTraceTreeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStackTraceTreeRequest.ProtoReflect.Descriptor instead.
func (*GetStackTraceTreeRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{20}
}

func (x *GetStackTraceTreeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetStackTraceTreeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Root *StackTraceNode `protobuf:"bytes,1,opt,name=root,proto3" json:"root,omitempty"`
}

func (x *GetStackTraceTreeResponse) Reset() {
	*x = GetStackTraceTreeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStackTraceTreeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStackTraceTreeResponse) ProtoMessage() {}

func (x *GetStackTraceTreeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStackTraceTreeResponse.ProtoReflect.Descriptor instead.
func (*GetStackTraceTreeResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{21}
}

func (x *GetStackTraceTreeResponse) GetRoot() *StackTraceNode {
	if x != nil {
		return x.Root
	}
	return nil
}

type GetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetVersionRequest) Reset() {
	*x = GetVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVersionRequest) ProtoMessage() {}

func (x *GetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVersionRequest.ProtoReflect.Descriptor instead.
func (*GetVersionRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{22}
}

type GetVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetVersionResponse) Reset() {
	*x = GetVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tetragon_sensors_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVersionResponse) ProtoMessage() {}

func (x *GetVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVersionResponse.ProtoReflect.Descriptor instead.
func (*GetVersionResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{23}
}

func (x *GetVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

var File_tetragon_sensors_proto protoreflect.FileDescriptor

var file_tetragon_sensors_proto_rawDesc = []byte{
	0x0a, 0x16, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x73, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x1a, 0x17, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x15, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x14, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x5c,
	0x0a, 0x0c, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x07, 0x73, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x22, 0x85, 0x01, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x69, 0x6e, 0x66,
	0x6f, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x22, 0x58, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x08, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x08, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x22, 0x2d, 0x0a, 0x17, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x79, 0x61, 0x6d, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x79, 0x61, 0x6d, 0x6c, 0x22, 0x1a, 0x0a, 0x18, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x30, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x79, 0x61, 0x6d, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x79, 0x61,
	0x6d, 0x6c, 0x22, 0x1d, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x29, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x16, 0x0a, 0x14,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x0a, 0x13, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x16, 0x0a, 0x14, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2a, 0x0a, 0x14, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x66, 0x67, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x63, 0x66, 0x67, 0x6b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x66, 0x67,
	0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x66, 0x67, 0x76, 0x61,
	0x6c, 0x22, 0x19, 0x0a, 0x17, 0x53, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x66,
	0x67, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x66, 0x67, 0x6b,
	0x65, 0x79, 0x22, 0x31, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x63, 0x66, 0x67, 0x76, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63,
	0x66, 0x67, 0x76, 0x61, 0x6c, 0x22, 0x17, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54,
	0x72, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x49,
	0x0a, 0x19, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54,
	0x72, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x04, 0x72,
	0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x22, 0x13, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x2e,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xe7,
	0x08, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x65, 0x47, 0x75, 0x69, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x48, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47,
	0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1b, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01,
	0x12, 0x52, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x20, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x5b, 0x0a, 0x10, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x4f, 0x0a, 0x0c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x12, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1e, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x64, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x24, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4c, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4f, 0x0a, 0x0c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x12, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x52, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x12, 0x1e, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x58, 0x0a, 0x0f, 0x53,
	0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20,
	0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x53, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x53,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x58, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x5e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65,
	0x54, 0x72, 0x65, 0x65, 0x12, 0x22, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54, 0x72, 0x65,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x49, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4c, 0x0a, 0x0b, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x6f, 0x6f, 0x6b, 0x12, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x6f, 0x6f, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x6f, 0x6f, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_tetragon_sensors_proto_rawDescOnce sync.Once
	file_tetragon_sensors_proto_rawDescData = file_tetragon_sensors_proto_rawDesc
)

func file_tetragon_sensors_proto_rawDescGZIP() []byte {
	file_tetragon_sensors_proto_rawDescOnce.Do(func() {
		file_tetragon_sensors_proto_rawDescData = protoimpl.X.CompressGZIP(file_tetragon_sensors_proto_rawDescData)
	})
	return file_tetragon_sensors_proto_rawDescData
}

var file_tetragon_sensors_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_tetragon_sensors_proto_goTypes = []interface{}{
	(*ListSensorsRequest)(nil),          // 0: tetragon.ListSensorsRequest
	(*SensorStatus)(nil),                // 1: tetragon.SensorStatus
	(*ListSensorsResponse)(nil),         // 2: tetragon.ListSensorsResponse
	(*ListTracingPoliciesRequest)(nil),  // 3: tetragon.ListTracingPoliciesRequest
	(*TracingPolicyStatus)(nil),         // 4: tetragon.TracingPolicyStatus
	(*ListTracingPoliciesResponse)(nil), // 5: tetragon.ListTracingPoliciesResponse
	(*AddTracingPolicyRequest)(nil),     // 6: tetragon.AddTracingPolicyRequest
	(*AddTracingPolicyResponse)(nil),    // 7: tetragon.AddTracingPolicyResponse
	(*DeleteTracingPolicyRequest)(nil),  // 8: tetragon.DeleteTracingPolicyRequest
	(*DeleteTracingPolicyResponse)(nil), // 9: tetragon.DeleteTracingPolicyResponse
	(*RemoveSensorRequest)(nil),         // 10: tetragon.RemoveSensorRequest
	(*RemoveSensorResponse)(nil),        // 11: tetragon.RemoveSensorResponse
	(*EnableSensorRequest)(nil),         // 12: tetragon.EnableSensorRequest
	(*EnableSensorResponse)(nil),        // 13: tetragon.EnableSensorResponse
	(*DisableSensorRequest)(nil),        // 14: tetragon.DisableSensorRequest
	(*SetSensorConfigRequest)(nil),      // 15: tetragon.SetSensorConfigRequest
	(*SetSensorConfigResponse)(nil),     // 16: tetragon.SetSensorConfigResponse
	(*GetSensorConfigRequest)(nil),      // 17: tetragon.GetSensorConfigRequest
	(*GetSensorConfigResponse)(nil),     // 18: tetragon.GetSensorConfigResponse
	(*DisableSensorResponse)(nil),       // 19: tetragon.DisableSensorResponse
	(*GetStackTraceTreeRequest)(nil),    // 20: tetragon.GetStackTraceTreeRequest
	(*GetStackTraceTreeResponse)(nil),   // 21: tetragon.GetStackTraceTreeResponse
	(*GetVersionRequest)(nil),           // 22: tetragon.GetVersionRequest
	(*GetVersionResponse)(nil),          // 23: tetragon.GetVersionResponse
	(*StackTraceNode)(nil),              // 24: tetragon.StackTraceNode
	(*GetEventsRequest)(nil),            // 25: tetragon.GetEventsRequest
	(*GetHealthStatusRequest)(nil),      // 26: tetragon.GetHealthStatusRequest
	(*RuntimeHookRequest)(nil),          // 27: tetragon.RuntimeHookRequest
	(*GetEventsResponse)(nil),           // 28: tetragon.GetEventsResponse
	(*GetHealthStatusResponse)(nil),     // 29: tetragon.GetHealthStatusResponse
	(*RuntimeHookResponse)(nil),         // 30: tetragon.RuntimeHookResponse
}
var file_tetragon_sensors_proto_depIdxs = []int32{
	1,  // 0: tetragon.ListSensorsResponse.sensors:type_name -> tetragon.SensorStatus
	4,  // 1: tetragon.ListTracingPoliciesResponse.policies:type_name -> tetragon.TracingPolicyStatus
	24, // 2: tetragon.GetStackTraceTreeResponse.root:type_name -> tetragon.StackTraceNode
	25, // 3: tetragon.FineGuidanceSensors.GetEvents:input_type -> tetragon.GetEventsRequest
	26, // 4: tetragon.FineGuidanceSensors.GetHealth:input_type -> tetragon.GetHealthStatusRequest
	6,  // 5: tetragon.FineGuidanceSensors.AddTracingPolicy:input_type -> tetragon.AddTracingPolicyRequest
	10, // 6: tetragon.FineGuidanceSensors.RemoveSensor:input_type -> tetragon.RemoveSensorRequest
	3,  // 7: tetragon.FineGuidanceSensors.ListTracingPolicies:input_type -> tetragon.ListTracingPoliciesRequest
	0,  // 8: tetragon.FineGuidanceSensors.ListSensors:input_type -> tetragon.ListSensorsRequest
	12, // 9: tetragon.FineGuidanceSensors.EnableSensor:input_type -> tetragon.EnableSensorRequest
	14, // 10: tetragon.FineGuidanceSensors.DisableSensor:input_type -> tetragon.DisableSensorRequest
	15, // 11: tetragon.FineGuidanceSensors.SetSensorConfig:input_type -> tetragon.SetSensorConfigRequest
	17, // 12: tetragon.FineGuidanceSensors.GetSensorConfig:input_type -> tetragon.GetSensorConfigRequest
	20, // 13: tetragon.FineGuidanceSensors.GetStackTraceTree:input_type -> tetragon.GetStackTraceTreeRequest
	22, // 14: tetragon.FineGuidanceSensors.GetVersion:input_type -> tetragon.GetVersionRequest
	27, // 15: tetragon.FineGuidanceSensors.RuntimeHook:input_type -> tetragon.RuntimeHookRequest
	28, // 16: tetragon.FineGuidanceSensors.GetEvents:output_type -> tetragon.GetEventsResponse
	29, // 17: tetragon.FineGuidanceSensors.GetHealth:output_type -> tetragon.GetHealthStatusResponse
	7,  // 18: tetragon.FineGuidanceSensors.AddTracingPolicy:output_type -> tetragon.AddTracingPolicyResponse
	11, // 19: tetragon.FineGuidanceSensors.RemoveSensor:output_type -> tetragon.RemoveSensorResponse
	5,  // 20: tetragon.FineGuidanceSensors.ListTracingPolicies:output_type -> tetragon.ListTracingPoliciesResponse
	2,  // 21: tetragon.FineGuidanceSensors.ListSensors:output_type -> tetragon.ListSensorsResponse
	13, // 22: tetragon.FineGuidanceSensors.EnableSensor:output_type -> tetragon.EnableSensorResponse
	19, // 23: tetragon.FineGuidanceSensors.DisableSensor:output_type -> tetragon.DisableSensorResponse
	16, // 24: tetragon.FineGuidanceSensors.SetSensorConfig:output_type -> tetragon.SetSensorConfigResponse
	18, // 25: tetragon.FineGuidanceSensors.GetSensorConfig:output_type -> tetragon.GetSensorConfigResponse
	21, // 26: tetragon.FineGuidanceSensors.GetStackTraceTree:output_type -> tetragon.GetStackTraceTreeResponse
	23, // 27: tetragon.FineGuidanceSensors.GetVersion:output_type -> tetragon.GetVersionResponse
	30, // 28: tetragon.FineGuidanceSensors.RuntimeHook:output_type -> tetragon.RuntimeHookResponse
	16, // [16:29] is the sub-list for method output_type
	3,  // [3:16] is the sub-list for method input_type
	3,  // [3:3] is the sub-list for extension type_name
	3,  // [3:3] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_tetragon_sensors_proto_init() }
func file_tetragon_sensors_proto_init() {
	if File_tetragon_sensors_proto != nil {
		return
	}
	file_tetragon_tetragon_proto_init()
	file_tetragon_stack_proto_init()
	file_tetragon_events_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_tetragon_sensors_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSensorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SensorStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSensorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTracingPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TracingPolicyStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTracingPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddTracingPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddTracingPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTracingPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTracingPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveSensorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveSensorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableSensorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableSensorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableSensorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetSensorConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetSensorConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSensorConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSensorConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableSensorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStackTraceTreeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStackTraceTreeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tetragon_sensors_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_tetragon_sensors_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_tetragon_sensors_proto_goTypes,
		DependencyIndexes: file_tetragon_sensors_proto_depIdxs,
		MessageInfos:      file_tetragon_sensors_proto_msgTypes,
	}.Build()
	File_tetragon_sensors_proto = out.File
	file_tetragon_sensors_proto_rawDesc = nil
	file_tetragon_sensors_proto_goTypes = nil
	file_tetragon_sensors_proto_depIdxs = nil
}
