/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

public abstract class DBIdentifier {
    private static final String REGEXP_DELIMITED = "\"(\"\"|[^\"])*\"";
    protected String adqlName = null;
    protected boolean adqlCaseSensitive = false;
    protected String dbName = null;

    protected DBIdentifier(String adqlName) throws NullPointerException {
        this.setADQLName(adqlName);
    }

    protected DBIdentifier(String adqlName, String dbName) throws NullPointerException {
        this.setADQLName(adqlName);
        this.setDBName(dbName);
    }

    public String getADQLName() {
        return this.adqlName;
    }

    public void setADQLName(String newName) throws NullPointerException {
        boolean adqlCS = DBIdentifier.isDelimited(newName);
        String normName = DBIdentifier.normalize(newName);
        if (normName == null) {
            throw new NullPointerException("Missing ADQL name!");
        }
        this.adqlName = normName;
        this.adqlCaseSensitive = adqlCS;
    }

    public boolean isCaseSensitive() {
        return this.adqlCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.adqlCaseSensitive = caseSensitive;
    }

    public String getDBName() {
        return this.dbName == null ? this.getADQLName() : this.dbName;
    }

    public void setDBName(String newName) {
        this.dbName = DBIdentifier.normalize(newName);
    }

    public static boolean isDelimited(String ident) {
        return ident != null && ident.trim().matches(REGEXP_DELIMITED);
    }

    public static String normalize(String ident) {
        if (ident == null || ident.trim().length() == 0) {
            return null;
        }
        String normIdent = ident.trim();
        if (DBIdentifier.isDelimited(normIdent)) {
            return (normIdent = normIdent.substring(1, normIdent.length() - 1).replaceAll("\"\"", "\"")).trim().length() == 0 ? null : normIdent;
        }
        return normIdent;
    }

    public static String denormalize(String ident, boolean caseSensitive) {
        if (caseSensitive && ident != null) {
            return "\"" + ident.replaceAll("\"", "\"\"") + "\"";
        }
        return ident;
    }
}

